---
नाम: क्लाउड-कौशल
विवरण: "क्लाउड कौशल मेटा-कौशल: डोमेन सामग्री (दस्तावेज़/एपीआई/कोड/स्पेस) को एक पुन: प्रयोज्य कौशल (SKILL.md + संदर्भ/स्क्रिप्ट/संपत्ति) में निकालें, और स्पष्टता, सक्रियण विश्वसनीयता और गुणवत्ता द्वार के लिए मौजूदा कौशल को दोबारा तैयार करें।"
---

#क्लाउडस्किल्स मेटा-स्किल

बिखरी हुई डोमेन सामग्री को एक ऐसे कौशल में बदलें जो पुन: प्रयोज्य, रखरखाव योग्य और विश्वसनीय रूप से सक्रिय हो:
- `SKILL.md` प्रवेश बिंदु के रूप में (ट्रिगर, बाधाएं, पैटर्न, उदाहरण)
- दीर्घकालिक साक्ष्य और नेविगेशन के लिए `संदर्भ/`
- मचान और टेम्पलेट्स के लिए वैकल्पिक `स्क्रिप्ट/` और `संपत्तियाँ/`

## इस कौशल का उपयोग कब करना है

जब आपको आवश्यकता हो तो इस मेटा-कौशल को ट्रिगर करें:
- डॉक्स/स्पेक्स/रिपोज़ से शुरू से ही एक नया कौशल बनाएं
- मौजूदा कौशल को पुनः सक्रिय करें (बहुत लंबा, अस्पष्ट, असंगत, मिसफायर)
- डिज़ाइन विश्वसनीय सक्रियण (फ्रंटमैटर + ट्रिगर्स + सीमाएँ)
- बड़ी सामग्री से एक साफ़ त्वरित संदर्भ निकालें
- लंबी सामग्री को नेविगेशन योग्य `संदर्भ/` में विभाजित करें
- एक गुणवत्ता गेट और एक सत्यापनकर्ता जोड़ें

## सीमाओं के लिए नहीं

यह मेटा-कौशल नहीं है:
- अपने आप में एक डोमेन कौशल (यह डोमेन कौशल बनाता है)
- बाहरी तथ्यों का आविष्कार करने का लाइसेंस (यदि सामग्री इसे साबित नहीं करती है, तो ऐसा कहें और सत्यापन पथ जोड़ें)
- आवश्यक इनपुट के लिए एक विकल्प (यदि इनपुट गायब हैं, तो आगे बढ़ने से पहले 1-3 प्रश्न पूछें)

## त्वरित संदर्भ

### डिलिवरेबल्स (आपको क्या उत्पादन करना चाहिए)

आपके आउटपुट में शामिल होना चाहिए:
1. एक ठोस निर्देशिका लेआउट (आमतौर पर `skills/<skill-name>/`)
2. निर्णय लेने योग्य ट्रिगर्स, सीमाओं और प्रतिलिपि प्रस्तुत करने योग्य उदाहरणों के साथ एक कार्रवाई योग्य `SKILL.md`
3. लंबे प्रारूप वाले दस्तावेज़ों को `references/index.md` के साथ `references/` में ले जाया गया
4. प्री-डिलीवरी चेकलिस्ट (क्वालिटी गेट)

### अनुशंसित लेआउट (न्यूनतम -> पूर्ण)

```
skill-name/
|-- SKILL.md              # Required: entrypoint with YAML frontmatter
|-- references/           # Optional: long-form docs/evidence/index
|   `-- index.md          # Recommended: navigation index
|-- scripts/              # Optional: helpers/automation
`-- assets/               # Optional: templates/configs/static assets
```

वास्तव में न्यूनतम संस्करण सिर्फ `SKILL.md` है (आप बाद में `संदर्भ/` जोड़ सकते हैं)।

### YAML फ्रंटमैटर (आवश्यक)

```yaml
---
name: skill-name
description: "What it does + when to use (activation triggers)."
---
```

फ्रंटमैटर नियम:
- `नाम` `^[a-z][a-z0-9-]*$` से मेल खाना चाहिए और निर्देशिका नाम से मेल खाना चाहिए
- `विवरण` निर्णय लेने योग्य होना चाहिए ("एक्स के साथ मदद नहीं") और इसमें ठोस ट्रिगर कीवर्ड शामिल होने चाहिए

### न्यूनतम `SKILL.md` कंकाल (कॉपी/पेस्ट)

```markdown
---
name: my-skill
description: "[Domain] capability: includes [capability 1], [capability 2]. Use when [decidable triggers]."
---

# my-skill Skill

One sentence that states the boundary and the deliverable.

## When to Use This Skill

Trigger when any of these applies:
- [Trigger 1: concrete task/keyword]
- [Trigger 2]
- [Trigger 3]

## Not For / Boundaries

- What this skill will not do (prevents misfires and over-promising)
- Required inputs; ask 1-3 questions if missing

## Quick Reference

### Common Patterns

**Pattern 1:** one-line explanation
```text
[कमांड/स्निपेट आप पेस्ट कर सकते हैं और चला सकते हैं]
```

## Examples

### Example 1
- Input:
- Steps:
- Expected output / acceptance:

### Example 2

### Example 3

## References

- `references/index.md`: navigation
- `references/...`: long-form docs split by topic

## Maintenance

- Sources: docs/repos/specs (do not invent)
- Last updated: YYYY-MM-DD
- Known limits: what is explicitly out of scope
```

### संलेखन नियम (परक्राम्य नहीं)

1. त्वरित संदर्भ संक्षिप्त, सीधे प्रयोग करने योग्य पैटर्न के लिए है
   - जब संभव हो तो इसे <= 20 पैटर्न रखें।
   - जिस किसी भी चीज़ को स्पष्टीकरण के पैराग्राफ की आवश्यकता होती है वह `संदर्भ/` में जाती है।
2. सक्रियण निर्णय योग्य होना चाहिए
   - फ्रंटमैटर 'विवरण' में ठोस कीवर्ड के साथ "क्या + कब" लिखा होना चाहिए।
   - "कब उपयोग करें" में विशिष्ट कार्यों/इनपुट/लक्ष्यों की सूची होनी चाहिए, अस्पष्ट सहायता पाठ की नहीं।
   - विश्वसनीयता के लिए "नॉट फॉर/बाउंड्रीज़" अनिवार्य है।
3. बाहरी विवरणों पर कोई दिखावा नहीं
   - यदि सामग्री इसे साबित नहीं करती है, तो ऐसा कहें और एक सत्यापन पथ शामिल करें।

### वर्कफ़्लो (सामग्री -> कौशल)

चरण न छोड़ें:
1. दायरा: लिखना चाहिए/चाहिए/कभी नहीं (कुल तीन वाक्य ठीक हैं)
2. पैटर्न निकालें: 10-20 उच्च-आवृत्ति पैटर्न चुनें (कमांड/स्निपेट/प्रवाह)
3. उदाहरण जोड़ें: >= 3 आरंभ से अंत तक उदाहरण (इनपुट -> चरण -> स्वीकृति)
4. सीमाएं परिभाषित करें: दायरे से बाहर क्या है + आवश्यक इनपुट
5. संदर्भों को विभाजित करें: लंबे टेक्स्ट को `references/` में ले जाएं + `references/index.md` लिखें
6. गेट लागू करें: चेकलिस्ट और सत्यापनकर्ता चलाएँ

### गुणवत्ता गेट (प्री-डिलीवरी चेकलिस्ट)

न्यूनतम जाँच (पूर्ण संस्करण के लिए `references/quality-checklist.md` देखें):
1. `नाम` `^[a-z][a-z0-9-]*$` से मेल खाता है और निर्देशिका नाम से मेल खाता है
2. `विवरण` ठोस ट्रिगर कीवर्ड के साथ "क्या + कब" बताता है
3. निर्णायक ट्रिगर्स के साथ "इस कौशल का उपयोग कब करें" है
4. मिसफायर को कम करने के लिए "नॉट फ़ॉर / बाउंड्रीज़" है
5. त्वरित संदर्भ <= 20 पैटर्न है और प्रत्येक सीधे प्रयोग योग्य है
6. >=3 प्रतिलिपि प्रस्तुत करने योग्य उदाहरण हैं
7. लंबी सामग्री `references/` में है और `references/index.md` नेविगेट करने योग्य है
8. अनिश्चित दावों में एक सत्यापन पथ शामिल है (कोई झांसा नहीं)
9. एक ऑपरेटर के मैनुअल की तरह पढ़ता है, दस्तावेज़ीकरण डंप की तरह नहीं

स्थानीय रूप से मान्य करें:

```bash
# From repo root (basic validation)
./skills/claude-skills/scripts/validate-skill.sh skills/<skill-name>

# From repo root (strict validation)
./skills/claude-skills/scripts/validate-skill.sh skills/<skill-name> --strict

# From skills/claude-skills/ (basic validation)
./scripts/validate-skill.sh ../<skill-name>

# From skills/claude-skills/ (strict validation)
./scripts/validate-skill.sh ../<skill-name> --strict
```

### उपकरण और टेम्पलेट

एक नया कौशल ढांचा तैयार करें:

```bash
# From repo root (generate into ./skills/)
./skills/claude-skills/scripts/create-skill.sh my-skill --full --output skills

# From skills/claude-skills/ (generate into ../ i.e. ./skills/)
./scripts/create-skill.sh my-skill --full --output ..

# Minimal skeleton
./skills/claude-skills/scripts/create-skill.sh my-skill --minimal --output skills
```

टेम्पलेट्स:
- `assets/template-minimal.md`
- `assets/template-complete.md`

## उदाहरण

### उदाहरण 1: डॉक्स से एक कौशल बनाएं

- इनपुट: एक आधिकारिक दस्तावेज़/विशेषता + 2-3 वास्तविक कोड नमूने + सामान्य विफलता मोड
- कदम:
  1. `create-skill.sh` को `skills/<skill-name>/` को जोड़ने के लिए चलाएँ
  2. फ्रंटमैटर `विवरण` को "क्या + कब" के रूप में लिखें
  3. त्वरित संदर्भ में 10-20 उच्च-आवृत्ति पैटर्न निकालें
  4. स्वीकृति मानदंड के साथ >=3 शुरू से अंत तक उदाहरण जोड़ें
  5. लंबी सामग्री को `references/` में डालें और `references/index.md` तार करें
  6. `validate-skill.sh --strict` चलाएँ और पुनरावृत्त करें

### उदाहरण 2: "डॉक्टर डंप" कौशल को दोबारा तैयार करें

- इनपुट: लंबे समय से चिपकाए गए दस्तावेज़ के साथ एक मौजूदा `SKILL.md`
- कदम:
  1. पहचानें कि कौन से भाग पैटर्न बनाम दीर्घ-रूप स्पष्टीकरण हैं
  2. लंबे प्रारूप वाले टेक्स्ट को `संदर्भ/` में ले जाएं (विषय के आधार पर विभाजित)
  3. त्वरित संदर्भ को संक्षिप्त कॉपी/पेस्ट पैटर्न के रूप में फिर से लिखें
  4. उदाहरण जोड़ें या ठीक करें जब तक कि वे प्रतिलिपि प्रस्तुत करने योग्य न हो जाएं
  5. मिसफायर को कम करने के लिए "नॉट फॉर / बाउंड्रीज़" जोड़ें

### उदाहरण 3: एक कौशल को मान्य करें और प्राप्त करें

- इनपुट: `कौशल/<कौशल-नाम>/`
- कदम:
  1. चेतावनियाँ प्राप्त करने के लिए `validate-skill.sh` (नॉन-स्ट्रिक्ट) चलाएँ
  2. फ्रंटमैटर/नाम बेमेल और गायब अनुभागों को ठीक करें
  3. विशिष्टता लागू करने के लिए `validate-skill.sh --strict` चलाएँ
  4. शिपिंग से पहले स्कोरिंग रूब्रिक को `references/quality-checklist.md` में चलाएँ

## सन्दर्भ

स्थानीय दस्तावेज़:
- `संदर्भ/index.md`
- `संदर्भ/कौशल-spec.md`
- `संदर्भ/गुणवत्ता-चेकलिस्ट.एमडी`
- `संदर्भ/एंटी-पैटर्न.एमडी`
- `संदर्भ/README.md` (अपस्ट्रीम आधिकारिक संदर्भ)

बाहरी (आधिकारिक):
- https://support.claude.com/en/articles/12512176-what-are-skills
- https://support.claude.com/en/articles/12512180-using-skills-in-claude
- https://support.claude.com/en/articles/12512198-creating-custom-skills
- https://docs.claude.com/en/api/skills-guide

## रखरखाव

- स्रोत: `skills/claude-skills/references/` में स्थानीय विशिष्ट फ़ाइलें + `references/README.md` में अपस्ट्रीम आधिकारिक दस्तावेज़
- अंतिम अद्यतन: 2025-12-14
- ज्ञात सीमाएँ: `validate-skill.sh` अनुमानवादी है; सख्त मोड अनुशंसित अनुभाग शीर्षकों को मानता है
