---
name: example-skill
description: This skill should be used when demonstrating skill structure and format.
  Provides example patterns for creating new skills.
author: Joseph OBrien
status: unpublished
updated: '2025-12-23'
version: 1.0.1
tag: skill
type: skill
---

# Example Skill

A demonstration skill showing the proper structure and format for Claude Code skills.

## When to Use This Skill

- Creating new skills and need a reference
- Understanding skill structure and best practices
- Learning how to bundle resources with skills

## What This Skill Does

1. Demonstrates proper YAML frontmatter format
2. Shows content structure requirements
3. Provides examples of bundled resources
4. Illustrates best practices for skill documentation

## Core Principles

### Principle 1: Clear Purpose

Skills should have a clear, well-defined purpose. The "When to Use" section should make it obvious when to apply the skill.

### Principle 2: Progressive Disclosure

Structure content from high-level overview to detailed implementation. Start with "When to Use" and "What This Skill Does" before diving into workflows.

### Principle 3: Actionable Workflows

Provide step-by-step workflows that can be followed directly. Include examples and anti-patterns.

## Workflow

### Step 1: Identify Need

Determine if this skill is appropriate for the current task.

### Step 2: Review Documentation

Read the skill documentation to understand capabilities and limitations.

### Step 3: Apply Skill

Follow the workflow steps to apply the skill.

### Step 4: Validate Results

Check that the skill achieved the intended outcome.

## Best Practices

- Keep skills focused on a single domain or capability
- Include clear examples and use cases
- Document anti-patterns to avoid common mistakes
- Bundle resources when they add value

## Anti-Patterns

- Creating overly broad skills that try to do everything
- Skipping the "When to Use" section
- Missing examples or use cases
- Not documenting bundled resources

## Examples

### Example 1: Basic Usage

**Scenario:** Creating a new skill for code review

**Approach:**

1. Review this example skill structure
2. Use the template from `steve/templates/AGENT_SKILL.template.md`
3. Fill in domain-specific content
4. Add bundled resources if needed

## Reference Files

This skill includes reference files in `references/`:

- `structure-guide.md`: Detailed structure guidelines
- `examples.md`: Additional examples
