---
author: Joseph OBrien
status: unpublished
updated: '2025-12-23'
version: 1.0.1
tag: skill
type: reference
parent: global-standards
---

# Commenting Standards

Guidelines for when and how to write code comments.

## When to Comment

### Do Comment

- Complex algorithms or business logic
- Non-obvious code decisions or workarounds
- Public APIs and interfaces
- Edge cases and known limitations
- Why code exists (not what it does)

### Don't Comment

- Obvious code that's self-explanatory
- Code that simply restates what's already clear
- Outdated or irrelevant information

## Comment Types

### Docstrings

- Function and class documentation
- Parameter descriptions
- Return value documentation
- Usage examples when helpful

### Inline Comments

- Explain complex logic
- Document workarounds
- Note important considerations

### TODO Comments

- Include context and rationale
- Link to issues when possible
- Include priority or timeline

## Best Practices

- Keep comments up to date
- Write comments that explain why, not what
- Use clear, concise language
- Remove outdated comments
