---
author: Joseph OBrien
status: unpublished
updated: '2025-12-23'
version: 1.0.1
tag: skill
type: reference
parent: global-standards
---

# Tech Stack Standards

Technology stack reference and consistency guidelines.

## Framework Patterns

### Frontend

- Follow framework-specific patterns (React hooks, Vue composition API, etc.)
- Use framework-recommended libraries
- Maintain consistency with existing code

### Backend

- Follow framework conventions (Express middleware, FastAPI decorators, etc.)
- Use established patterns for API design
- Maintain consistency across services

## Dependency Management

### Adding Dependencies

- Evaluate necessity before adding
- Prefer existing tools over new ones
- Check for security vulnerabilities
- Document why dependency is needed

### Version Management

- Pin versions for production
- Use semantic versioning
- Keep dependencies up to date
- Test updates before deploying

## Technology Choices

### Consistency

- Use established patterns
- Follow project conventions
- Document technology decisions
- Maintain architectural consistency

### Evaluation Criteria

- Performance requirements
- Team expertise
- Maintenance burden
- Security considerations
- Cost implications
