---
name: seo-analysis
description: SEO analysis and optimization specialist. Use when conducting technical
  SEO audits, optimizing meta tags, analyzing Core Web Vitals, or improving search
  engine rankings. Focuses on actionable recommendations.
author: Joseph OBrien
status: unpublished
updated: '2025-12-23'
version: 1.0.1
tag: skill
type: skill
---

# SEO Analysis

This skill provides comprehensive SEO analysis including technical audits, meta tag optimization, Core Web Vitals analysis, and search engine optimization recommendations.

## When to Use This Skill

- When conducting technical SEO audits
- When optimizing meta tags and descriptions
- When analyzing Core Web Vitals and page performance
- When implementing schema markup
- When optimizing internal linking structure
- When improving search engine rankings

## What This Skill Does

1. **Technical SEO Audits**: Comprehensive site structure and technical analysis
2. **Meta Optimization**: Optimizes titles, descriptions, and meta tags
3. **Core Web Vitals**: Analyzes and improves LCP, FID, and CLS
4. **Schema Markup**: Implements structured data
5. **Link Optimization**: Improves internal linking structure
6. **Mobile Optimization**: Validates mobile-first indexing

## How to Use

### Analyze SEO

```
Conduct a technical SEO audit of this website
```

```
Optimize meta tags for better search visibility
```

### Specific Analysis

```
Analyze Core Web Vitals and suggest improvements
```

## Analysis Areas

### Technical SEO

**Site Structure:**

- URL structure and hierarchy
- Sitemap and robots.txt
- Canonical tags
- Redirect chains
- HTTPS implementation

**Crawlability:**

- Page indexing status
- Blocked resources
- JavaScript rendering
- Mobile usability

### Meta Tags

**Optimization:**

- Title tags (50-60 characters)
- Meta descriptions (150-160 characters)
- Open Graph tags
- Twitter Card tags
- Structured data

### Core Web Vitals

**Metrics:**

- Largest Contentful Paint (LCP) < 2.5s
- First Input Delay (FID) < 100ms
- Cumulative Layout Shift (CLS) < 0.1

## Examples

### Example 1: Meta Tag Optimization

**Input**: Optimize meta tags for homepage

**Output**:

```markdown
## SEO Analysis: Meta Tags

### Current State
- Title: "Home" (too generic)
- Description: Missing
- No Open Graph tags

### Optimized Tags
```html
<!-- Title Tag -->
<title>Example App - Best Tool for Task Management | Free Trial</title>

<!-- Meta Description -->
<meta name="description" content="Example App helps teams manage tasks efficiently. Free 14-day trial. Join 10,000+ teams using Example App.">

<!-- Open Graph -->
<meta property="og:title" content="Example App - Best Tool for Task Management">
<meta property="og:description" content="Help your team manage tasks efficiently with Example App.">
<meta property="og:image" content="https://example.com/og-image.jpg">
```

### Expected Impact

- Improved click-through rate
- Better social sharing
- Enhanced search visibility

```

## Best Practices

### SEO Optimization

1. **Keyword Research**: Use relevant keywords naturally
2. **Content Quality**: Create valuable, original content
3. **Technical Foundation**: Ensure site is crawlable
4. **Performance**: Optimize for Core Web Vitals
5. **Mobile-First**: Ensure mobile usability

## Related Use Cases

- Technical SEO audits
- Meta tag optimization
- Core Web Vitals improvement
- Schema markup implementation
- Search ranking improvement
