---
name: technical-research
description: Technical spike and research investigation specialist. Use when exploring
  options for a technical decision, conducting timeboxed investigations, or evaluating
  technology choices.
author: Joseph OBrien
status: unpublished
updated: '2025-12-23'
version: 1.0.1
tag: skill
type: skill
---

# Technical Research Skill

Structured approach to technical spikes, proof of concepts, and technology evaluations.

## What This Skill Does

- Conducts timeboxed technical investigations
- Creates proof of concept implementations
- Compares technical options objectively
- Documents findings and recommendations
- Identifies risks and dependencies
- Provides implementation paths

## When to Use

- Technology selection decisions
- Architecture exploration
- Feasibility studies
- Performance investigations
- Library/framework evaluation

## Reference Files

- `references/TECHNICAL_SPIKE.template.md` - Structured spike investigation format

## Spike Structure

1. **Objective** - Clear questions to answer
2. **Timebox** - Fixed investigation period
3. **Options** - Multiple approaches explored
4. **POC** - Working code for each option
5. **Comparison** - Weighted criteria matrix
6. **Recommendation** - Justified decision

## Best Practices

- Define success criteria upfront
- Explore at least 2-3 options
- Create runnable POC code
- Document trade-offs honestly
- Track unanswered questions
- Stay within timebox
