# Progression Balance Guide

This guide covers the economy of Experience Points (XP) and the automatic scaling of the Heart Die.

## XP Economy
*   **Award Rate**: 2-4 XP per session (baseline).
*   **Goal**: Steady progression every few sessions.

## XP Costs Table

| Upgrade | Formula | Example Costs |
| :--- | :--- | :--- |
| **New Aspect** | `1` | Always 1. Cheap to encourage narrative depth. |
| **Increase Aspect Rank** | `Current Rank + 1` | Rank 1->2 costs 2 XP. Rank 4->5 costs 5 XP. |
| **Change Aspect** | `0` | Free. Encourage character growth. |
| **Increase Max HP** | `(Current HP / 10) + 1` | 40->50 costs 5 XP. 50->60 costs 6 XP. |
| **Increase Ability Die** | `New Die Size` | d4->d6 costs 6 XP. d10->d12 costs 12 XP. |
| **New Combat Talent** | `Current Combat Talents + 3` | 0->1 costs 3 XP. 5->6 costs 8 XP. |
| **New Noncombat Talent** | `Current Noncombat Talents + 3` | 0->1 costs 3 XP. |
| **New Elemental Talent** | `(Current Combat Talents * 2) + 3` | Very expensive. 2 combat talents -> 7 XP. |
| **Destiny Level** | `Current Destiny Levels + 5` | 0->1 costs 5 XP. 1->2 costs 6 XP. |

## Heart Die Milestones

The Heart Die (stamina) scales automatically with **Total XP earned** (spent or unspent).

| Total XP | Heart Die Size | Tier Description |
| :--- | :--- | :--- |
| **0 - 199** | **d8** | Starting Hero / Novice |
| **200+** | **d10** | Seasoned Adventurer |
| **500+** | **d12** | Veteran Hero |
| **1000+** | **d20** | Legendary Champion |

## Balancing Tips
*   **HP vs Mitigation**: HP is expensive to raise. Mitigation (Armor, Defense rolls) is often more XP-efficient early on.
*   **Talent Bloat**: The increasing cost of talents discourages hoarding low-level abilities and encourages taking Destiny Levels (upgrading existing ones) or diversifying into non-combat areas.
*   **Elemental Magic**: Intentionally priced high to represent the difficulty and power of magic. Spelltouched races bypass this premium.
