# Talent Balance Guide

Talents are the primary way characters specialize. They are divided into Combat, Noncombat, and Elemental categories.

## XP Costs

The cost of a new talent depends on how many you already have of that type.

| Talent Type | XP Cost Formula | Notes |
| :--- | :--- | :--- |
| **Combat Talent** | `Current Combat Talents + 3` | Martial or Cognitive tags. |
| **Noncombat Talent** | `Current Noncombat Talents + 3` | Utility, social, crafting. |
| **Elemental Talent** | `(Current Combat Talents * 2) + 3` | Requires attunement. High cost reflects power. |
| **Elemental (Spelltouched)** | `Current Combat Talents + 3` | Spelltouched race/background gets discount. |
| **Destiny Level** | `Current Destiny Levels + 5` | Upgrades an existing talent. |

## Talent Structure

Every talent must have:
1.  **Name**: Evocative and descriptive.
2.  **Type/Tags**:
    *   **Passive ability**: Always active or triggered automatically. No resource cost.
    *   **Major ability**: Once per day (or long rest). Powerful effects.
    *   **Minor ability**: Costs Rush Points (1st use = 1 RP, 2nd = 2 RP, etc.). Resets after fight.
    *   **Weekly/Monthly ability**: For very powerful narrative effects.
    *   **Instant**: Can be used at any time, even interrupting.
    *   **Full Action**: Consumes the character's main action for the round.
    *   **Ongoing**: Lasts for a duration (usually 1 minute/combat).
3.  **Description**: The mechanical effect.
4.  **Destiny Level**: A significant upgrade or twist on the base ability.

## Balancing Guidelines

### Combat Talents
Combat talents should equat to no more than a consistent +2.5 damage at basic level, and +5 at destiny level.
*   **Passive**: Small, consistent bonuses (+1 to rolls, conditional advantage) or new options (sidestep twice).
*   **Minor (Rush Points)**: Tactical options. Damage boosts, condition infliction, mobility.
*   **Major (Daily)**: Encounter-turning effects. Big damage, mass buffs, unique mechanics.
*   **Martial vs Cognitive**: Martial is physical/weapon-based. Cognitive is mental/tactical.

### Noncombat Talents
*   Focus on narrative agency and utility.
*   Avoid trivializing core challenges without cost.
*   "Weekly" or "Monthly" limits are good for powerful narrative magic (e.g., resurrection, major divination).

### Elemental Talents
*   **Requirement**: Specific elemental attunement (Fire, Water, Void, etc.).
*   **Power**: Generally stronger than martial talents due to higher XP cost and prerequisites.
*   **Cantrips**: Elemental attunement also grants "Cantrips" (magical weapons) - factor this versatility in.

### Destiny Levels
*   Should feel like a "Level 2" version of the talent.
*   Can change a Major ability to Passive or Minor.
*   Can increase dice size (d6 -> d10) or quantity.
*   Can remove restrictions or increase range/targets.
