# Academic Writing Samples

Examples of research papers, analytical essays, and formal academic argumentation.

## Research Paper: COVID-19 Political Polarization Study

### Introduction

> COVID-19 is one of the largest threats the United States has ever faced. As of the time of writing this, over 1.5 million people have tested positive for the virus, and nearly 100,000 people have died. It is highly infectious, and although not highly deadly (estimated 1-3% death rate), due to it's high rate of spread, could have significant impacts on our society. It is also one of the few threats in our history that impacts everyone in the country. The threat requires a concerted effort to overcome, and how each person responds to the situation affects how serious this problem becomes. It is imperative that there is a unified response, which relies on clear, cohesive, and unified messaging from the political elite. However, this has not been the case.
>
> Recent research has shown that the public response to the COVID pandemic has been mixed—divided across party lines. Using data from internet searches, average daily travel distance, and visits to non-essential businesses, Barrios and Hochberg (2020) show a significant positive correlation between a county's proportion of Trump voters and that county's overall noncompliance with public health safety advisories. At a similar time, a 3,000 participant national survey by Gadarian, Goodman, and Pepinskey (2020) show that party affiliation was the single most significant indicator of safety behavior at the time of the study. In our study, we seek to understand if this political divide influences how people evaluate public health announcements related to the virus. We turn to source cues as a likely candidate for a component of the polarization we see surrounding this pandemic.

### Discussion Section

> Statistical analysis clearly showed significant effects of source cues on participant evaluations of messages. However, the strength of these effects suggest that the source cues may not be the critical contributing factors we had previously predicted them to be. Since every evaluation was done out of 100 points, only a few points in either direction does not make a very noticeable difference. However, it's possible that these points are more significant than they appear. Despite being relatively small, we have no indication as to how much change is enough to make the difference between following health guidelines and disobeying. It's possible that the 4 points of aversion to the out-group is enough to change someone's behavior. Similarly, the additional 3 points of warmth felt towards messages from the in-group may be enough to sway someone from apathy to action.
>
> [...]
>
> Our research still leaves several questions to be answered. It is still unclear how much of an effect the little change we saw would have on people's behavior. Without additional surveying, or ideally, being able to observe subjects' behavior, we can't know how much of a difference the few points in evaluations make. If the presence of source cue can change just 1% of the behavior of the people who see it, then it ultimately has the power to sway thousands of people when broadcasted at a state level. For this reason, an assessment of the power of those few points of evaluation would be valuable.

**Key patterns:**
- Strong topic sentences state the point directly
- Evidence follows logically with "For example..." and specific citations
- Acknowledges limitations without hedging excessively
- "However, it's possible that..." introduces counterpoint
- "Our research still leaves..." transitions to future directions
- Synthesis over mere summary—connects ideas meaningfully

## Argumentative Essay: Roman Religion and Expansion

### Thesis and Opening

> Rome's rise to power was marked by its heroic leaders, incredible wars, and disciplined soldiers. But while those attributes may have all directly contributed to Rome's success, they were not the only factors. Behind the mighty armies of Rome there was a society and government that backed it up, providing people, labor, and social infrastructure. However, we can go even further. While Rome did have all these things, so did every other society around them—the Mediterranean was filled with flourishing peoples. So we take a step further, and we look at what was behind that—religion. Clearly, other states within the Mediterranean had religions, but Rome's was unique, and it had an incredible effect on the growth of the state. Religion was an omnipresent tool and force within Rome, and played a critical role in Rome's expansion.

### Evidence and Analysis

> Of the many functions of religion in Roman society, its effects on their ability to wage war were some of the most profound. Specifically, religion gave them conviction in declaration and conduction of war, confidence and certainty on the battlefield, and a willingness of soldiers and leaders alike to give their lives up for Rome, compelling them to fight harder and more devotedly.
>
> The first of these positive effects is of psychological nature, whereby both the soldiers, senate, and the common citizens were all fully committed to the wars, and believed they were fighting righteously and towards a future destined to be theirs. One of the best examples of this lies with the duties of the fetial priests. When the Romans felt they had been wronged, first the fetial priests had to perform a ritual: the priests would go to the borders of whichever state they sought restitution with and state their purpose and demands, and then declare Jupiter as their witness, asking the god to prevent the priest from ever returning home if his demands were unjust (Livy 1.32).
>
> [...]
>
> This sort of tactic was used throughout their battles to similar effect. For example, in Livy's account of the second Punic war, he quotes a line Scipio delivered to his men:
>
> "On my sacred oath I swear that I myself shall not abandon the republic of the Roman people, nor will I allow any other citizen to do so. If I knowingly break my oath, then, Jupiter Optimus Maximus, visit the most terrible destruction on my home, my family, and my possessions. Lucius Caecilius, I demand that you, and the rest of you here present, take an oath using these words of mine. Anyone not swearing—let him know that this sword is drawn against him!" (Livy, 22.53)
>
> Soldiers under Scipio's command made the promise, and by doing so, are no longer just fighting for themselves, but also for their homes, family, and possessions. By invoking this oath, Scipio used religion to tie the loyalty and commitment of his soldiers to things more important than money—their livelihoods. It was religion that bound these motivating factors together.

### Conclusion

> Roman Religion's ability to motivate, persuade, control, change the attitudes of, and unite the people of Rome was fundamental to Rome's growth. It was one of the many keys to Rome's success as a nation. However, more remains to be investigated, and new questions arise. For example, why did Roman religion evolve into what it was, and why didn't the religions of Rome's neighbors evolve similarly? It may also have been fruitful to look closer at other sources to get a better idea of what life as a citizen within Rome was like, and how religion affect one's day-to-day behavior. In any case, it is clear that while religion may have had a profound effect on Rome, there is still much more to explore.

**Key patterns:**
- Clear thesis statement in opening paragraph
- "Of the many functions..." introduces main point
- "The first of these..." provides structure
- Extensive quotations integrated naturally
- "This sort of tactic..." connects examples
- "In other words..." synthesizes ideas
- "Altogether, this indicates..." draws conclusions
- Acknowledges remaining questions without undermining argument
- Formal but not stilted—retains human voice
