# Personal & Reflective Writing Samples

Examples of speeches, personal essays, and introspective writing.

## Graduation Speech: Carleton College

> If there's ever been a time to be thinking about your past, it is now. You are probably reminiscing over the last 4 years—1,383 days if I'm to be trusted with a calculator—and are likely feeling a little sad. No one goes to college twice, and many of the experiences from the last 4 years will be unique in your life. Yes, you may still one day meet new people you can call friends, and yes, you may still one day work until 3 AM sustained on nothing but coffee and chicken tenders, but the special combination of people and goals and circumstances that make Carleton Carleton—that is now forever behind you.
>
> But you are also thinking of the future. And what a future at that. Now, this could be the point in my speech where I expound your great achievements, laud your heroic struggles, and point to a bright future ahead. I could tell you that you would all become decorated doctors, famous philosophers, and and stupendous scientists. I might have said that the future holds great, great successes for all of you. But I didn't say that, and I won't, and I'll tell you why. Because those words, they would be hollow words, coming from someone who hasn't been to the future yet, and can't report back. So I'm not going to make claims I can't back up. In fact, there are good reasons that the future might not hold such greatness. The odds are against you—2020 may turn out to be even harder than comps. So what does that leave me to say? Well, more than you may think.
>
> Because Carleton, Carleton has given you far more than you may realize. While the focus now may seem to be on what skills you can claim on your resume, or how many internships you completed last summer, these are not the best things that Carleton has given you. Alongside a deep and broad academic education that will serve you well into the future, Carleton has nurtured an expansive curiosity in the world, and a profound passion for learning. You have learned to become happier, more resilient, better people. While others may claim to have the best skills prepared for the job, I daresay that you all are some of the best prepared to acquire the skills for the job—and any job at that. This is what I believe differentiates you. This is what makes you ready to achieve your goals, ready to take on the world, ready to move on to the mystically foretold "future".
>
> But as everyone you know seems to question what the years ahead hold, and you wonder to yourself, will I achieve success, I urge you to pause, and consider your dreams, to contemplate this idea of "success". Success is not a place you reach, or a mental state you achieve. It is not some fantastical point between the ages of 25 and 40 where you've finally done it, you've finally achieved that goal. No—it is a staircase that you will keep climbing forever—you cannot focus only on reaching a certain stair, but instead on the happiness you get from climbing at all. Your success will be something that you will define for yourself—your success is what you make of it, not what it is made of. The future, success—these are things you can never reach. So while you feel nostalgic for the past, and eagerly await the future, I hope you won't forget about now.

**Key patterns:**
- Direct address to audience
- Parenthetical aside adds personality "(1,383 days if I'm to be trusted with a calculator)"
- Question-then-answer structure: "So what does that leave me to say? Well, more than you may think."
- Rhetorical listing with parallel structure
- "But I didn't say that, and I won't, and I'll tell you why" — conversational transition
- Em dashes for elaboration and emphasis
- Balances formal occasion with personal voice
- Strong metaphor (staircase) without excessive abstraction

## Personal Reflection: Coming of Age

> Back then, I was convinced things would work out in the end. It was such a logical conclusion from my experiences thus far that I didn't even question it; it wasn't an assumption, or belief—just a fact of my existence. Questions like "What are you going to be when you grow up?" and "Where do you want to go to college?" were never an issue. I was willing to believe that they must be important questions—after all, most people asked me at some point—but it always seemed so trivial: I was just going to be happy, do my thing, and live my life.
>
> However, the way they asked about my future, there was some unspoken assumption of a plan—the plan. At that time, this went right over my head—there weren't even the seeds of a plan in my thoughts; nothing in my life had led me to believe that I had to think about my future in the slightest. After all, I was totally satisfied with my life thus far, had never made a decision I regretted, and had no idea what life was like outside the bubble of my own meager experiences. So why were these old people asking about my future? Of course things were going to turn out okay! Planning was for unimaginative, unadventurous people who wanted consistency.
>
> It wasn't until high school that I encountered the first bit of resistance to my mindset: I didn't like school. This was a bit of a shock to my system. How could I, master of contentedness and satisfaction, always happy with the situation I was given, totally certain in my own destiny for a life of happiness, be unsatisfied in this new environment? Sometimes, I question the honesty of my positive responses to my mother's daily question: "How was school?" Part of me thinks that I was lying to myself—I was repulsed by nearly everything about the school I went to other than my interactions with my teachers and a select few of my peers. However, the other part of me wonders if my little internal engine of happiness was still strong, and managed to spend an entire year cranking out positivity at a rate that gave me no choice but to follow along.

**Key patterns:**
- Conversational opening: "Back then..."
- Em dashes for clarification of thought
- Self-aware and slightly self-deprecating tone
- Questions posed and answered
- "However..." introduces shift in perspective
- Internal dialogue woven naturally
- Reflection on past self with present understanding
- Wry humor: "master of contentedness and satisfaction"
- Lists flow as sentences, not bullets
