# Professional & Application Writing Samples

Examples of cover letters, recommendations, and professional communication.

## Cover Letter: Notion Application

> Dear Hiring Manager,
>
> I've been loosely following Notion since my younger sister first introduced me to it, 6 years ago. I was impressed with its attention to detail and care for the end user, and although the tool didn't perfectly align with how I prefer to record my thoughts (I like old school paper most of the time), I've kept my eye on it. However, since then, I've become a software engineer, and developed a penchant for note apps and AI.
>
> I'd first like to highlight my work on note taking apps. I'm not talking about a tutorial project for learning React, I'm talking about the production app Co-GM—a fully fledged, online rich text editor with numerous integrations with tools built for GMs (game masters, the people who run games of Dungeons and Dragons). The app has attracted over 1,500 users and over 50 of them paying monthly for the premium subscription version. I highly encourage you to check out the app yourself so you can see what it's capable of, but at a high level, it's got a sleek and innovative UI, a marketplace for users to build and share GM-ing resources, and a number of advanced tools for taking notes extremely quickly and effectively. I built the app myself, from the ground up, using React, TypeScript, Node.js, and MongoDB. The project took nine months while also working full time as a consultant. I learned a great deal while building this, and would love to share more!
>
> [...]
>
> All of this is to say, I'd love to work at Notion. I've admired Notion and stayed up to date with its developments, so I've known that Notion's been working with AI more recently. I was working on a creative project earlier today, and thinking to myself—"Gosh, I really wish my note-tool was fully integrated with AI so that it understood the full picture of what I'm trying to accomplish here, because manually inputting this into GPT each time is awful!" That's what made me remember that Notion was working with AI. However, from what I can tell, Notion's not quite doing what I want it to yet, which only made me realize that maybe I could have a chance to help implement it. I'd love to have that opportunity.
>
> Silas

**Key patterns:**
- Opens with genuine connection, includes personal aside in parentheses
- "I'd first like to highlight..." structural marker
- Uses em dashes for elaboration and specificity
- Technical details without over-explaining
- "All of this is to say..." transitional phrase
- "Gosh" brings conversational warmth to professional context
- Closes with enthusiasm but not desperation

## Letter of Support: Immigration Application

> My name is Silas Rhyneer, and I am writing in support of my friend Petr Sopidi and his wife Kate Dollar's application for adjustment of status. I have known Petr for over eight years, since we met as students at Hawaii Preparatory Academy in 2017, and I can personally attest to both his character and the genuine nature of his marriage to Kate.
>
> Petr and I became close friends at Hawaii Prep—he, myself, and another friend were practically inseparable throughout those two years. We played in a band together (Petr was our rhythm guitarist and a total metalhead), spent countless hours talking and laughing, and shared the kind of camaraderie that's rare to find in high school. In many ways, Petr was the steady, grounding presence in our friend group—the person everyone turned to for level-headed advice.
>
> What always stood out about Petr was his emotional maturity and thoughtfulness. He has a natural tendency to think deeply about how his actions affect others. I remember many times when he'd fall quiet and, when you'd ask why, it would turn out he'd been reflecting on an interaction or decision, making sure he was doing right by someone. That kind of self-awareness and care is a core part of who he is.
>
> [...]
>
> Last summer, I had the opportunity to see them together in person when I was traveling through Italy. Petr and Kate insisted that I stay with them, and despite being their guest, Petr refused to let me pay for anything. Spending those days with them gave me a clear window into their relationship. They were completely in sync—constantly joking, sharing stories, finishing each other's thoughts. They moved through daily life together with the kind of ease and comfort that only comes from a deep, genuine partnership. Their connection wasn't performative or exaggerated; it was natural, warm, and clearly built on mutual love and respect. I saw how they supported each other, made decisions together, and brought out the best in one another.
>
> [...]
>
> Petr has always struck me as someone grounded, kind, and loyal. He is the kind of person who takes life seriously but still finds joy and humor in it. He's deeply thoughtful, a steady friend, and someone who enriches the lives of the people around him. To put it simply: Petr is someone I would trust with my life, and someone I'd want by my side in any difficult situation. I have no doubt that he will continue to be a positive and contributing member of any community he calls home.

**Key patterns:**
- Formal opening with clear purpose statement
- Em dashes provide natural elaboration
- Parenthetical aside adds personality "(Petr was our rhythm guitarist and a total metalhead)"
- Specific anecdotes over general claims
- "What always stood out..." introduces character description
- Lists flow as natural sentences, not bullets
- "To put it simply:" transitions to direct statement
