---
name: Writing Like User
description: Emulate the user's personal writing voice and style patterns. Use when the user asks to write content in their voice, draft documents, compose messages, or requests "write this like me" or "in my style."
---

# Writing Like User

## Quick Reference

The voice is **direct, conversational, and confident** with pragmatic, no-nonsense clarity. Key principles:

1. **Be direct** — Say what you mean without padding
2. **Show personality** — Let humor and self-awareness appear naturally
3. **Vary rhythm** — Mix sentence lengths deliberately
4. **Use dashes liberally** — For asides, clarifications, emphasis
5. **Ground in specifics** — Concrete details over abstract concepts
6. **Trust the reader** — Don't over-explain
7. **Write as you'd speak** — But polished, not sloppy

## Core Writing Rules

- Use active voice unless grammatically impossible
- Express with wry, subtle wit—avoid flowery speech
- Avoid contrastive metaphors and syntactic pairings ("This isn't X, it's Y")
- Use direct functional statements describing what something is
- Express claims directly without rhetorical feints
- Avoid subjective qualifiers, value judgments, or evaluative language
- Skip introductory phrases that frame ideas as significant or thought-provoking
- Use direct statements without hyperbole
- Avoid rhetorical negation ("not optional—it's required")
- Avoid contrastive constructions

## Structural Signatures

### Em Dashes for Asides and Elaboration

Use em dashes prolifically for clarifications, examples, or commentary:

- "I'm not talking about a tutorial project for learning React, I'm talking about the production app Co-GM—a fully fledged, online rich text editor with numerous integrations"
- "At first, he had just stopped referring to the extensive, hundred page manual on refund policy—trusting his gut instead"
- "However, the current pandemic is full of unknowns—the United States has never experienced something of this magnitude before"

### Parenthetical Asides for Voice

Deploy strategically for humor, specificity, or conversational texture:

- "(I like old school paper most of the time)"
- "(one of them looked slightly promising, but trading is not my passion)"
- "(what the fuck?)"
- "615 people were recruited from the Amazon Mechanical Turk user population (excluding the 25 that were removed for either straight-lining responses, or spending less than 1/10th of median time)"

### Sentence Length Variation

Mix short, punchy sentences with longer, complex ones:

**Short for impact:**
- "That was fucking stupid."
- "It hurt to move his fingers."
- "Why did it matter?"
- "I know."

**Long for detail:**
- "Over the last two years at Carleton, my work has grown considerably better. I hesitate to say the writing is good, but I think that at this point in time, I can sufficiently write in most formats and styles in ways that clearly convey whatever information is needed."

### Starting with Conjunctions

Frequently begin sentences with "And," "But," "However," or "So":

- "And it was cold."
- "But then Rory started digging in his fucking claws."
- "However, this view does not stand up to much scrutiny."
- "So I'm not going to make claims I can't back up."

### Question-Then-Answer Structure

Pose questions and immediately answer them:

- "What was he thinking, coming up here. He didn't know why he said that—he knew who this girl was"
- "And what about your job? You can't drive and work on your computer at the same time."
- "So what does that leave me to say? Well, more than you may think."

### Parallel Structures

Use repetition for emphasis and rhythm:

- "You are probably reminiscing over the last 4 years—1,383 days if I'm to be trusted with a calculator—and are likely feeling a little sad."
- "I could tell you that you would all become decorated doctors, famous philosophers, and and stupendous scientists."
- "you'd be good at it—and you were—but that didn't mean shit"

### Strategic Fragments

Use incomplete sentences for emphasis:

- "That was my ring."
- "Now, I know."
- "Easy money, D-man."
- "What a future at that."

## Voice and Tone

### Direct Without Hedging

State things plainly when confident:

- "I highly encourage you to check out the app yourself"
- "I'd love to work at Notion."
- "This is stupid."
- "Strangely, our results all indicate..."
- "Religion was an omnipresent tool and force within Rome"

### Self-Aware and Slightly Self-Deprecating

Acknowledge biases, limitations, or uncertainties naturally:

- "I hesitate to say the writing is good, but..."
- "He didn't know why he said that—he knew who this girl was"
- "I didn't know how much any of it cost, but it looked nice."
- "Morris sighed. At least his belly was full now."

### Conversational Even in Formal Contexts

Academic and professional writing retains human voice:

- "All of this is to say, I'd love to work at Notion."
- "Gosh, I really wish my note-tool was fully integrated with AI"
- "It is hot days like these when the plants were the worst."
- "What a future at that."

### Dry Humor Woven In

Humor appears naturally, never forced:

- "Larson flicked another booger towards Allison's head."
- "(what the fuck?)"
- "And yeah, maybe you would be good at it—and you were—but that didn't mean shit."
- "You're fucking nuts dude. That's—that's fucking nuts."

## Word Choice

### Specific Technical Language When Needed

Use jargon purposefully:

- "fine-tuning the LLM on our specific use cases, reducing the need to include instructions on processing or output-formatting"
- "using the PyTorch library to manually force some layers to output to multiple other layers"
- "using an experimental survey, we present participants with public health safety messaging accompanied by either different political party signals"

### Colloquialisms and Casual Speech

Write as you'd actually speak:

- "Cmon, let's take it for a ride."
- "Gosh"
- "wouldya?"
- "You're an idiot, Jack."

### Transitional Phrases

Distinctive markers for moving between ideas:

- "All of this is to say..."
- "At a high level..."
- "However..."
- "In other words..."
- "Altogether..."
- "First, ...Second, ...Lastly..."

### Strong, Active Verbs

Prefer vivid, precise verbs over adverb-heavy constructions:

- "delighting the Romans" (not "making the Romans very happy")
- "baits them into modifying their accusations"
- "tumbling over the roof"
- "drilling a hole into his forehead"

### Lists in Natural Language

Integrate lists as flowing sentences rather than bullet points in prose:

- "Most of all, I think I've developed the conciseness of my writing, which I believe is one of my strengths as a writer."
- "My thesis driven arguments have become more persuasive, my analytical writing has become more precise, and my use of citations is now more robust."

## Paragraph Structure

### Topic Sentences State the Point

Lead paragraphs with clear declarations:

- "Of the many functions of religion in Roman society, its effects on their ability to wage war were some of the most profound."
- "The first of these positive effects is of psychological nature"
- "Religion also acted as a powerful motivating factor"

### Evidence Follows Logically

After stating your point, provide specific support:

- Claim → "For example..." → specific evidence → analysis
- "This sort of tactic was used throughout their battles to similar effect. For example, in Livy's account of the second Punic war..."

### Synthesis Over Summary

Connect ideas and draw conclusions rather than just listing facts:

- "Altogether, this indicates a real commitment to their religious doctrine"
- "In other words, people feel a strong, positive, in-group bias towards their own party"
- "This unification of religious views likely brought people closer together"

## Context-Specific Adaptations

### Professional/Application Writing
- Lead with action and specificity
- Use "I'd like to highlight..." structure
- End with enthusiasm but not desperation
- Show personality: "Gosh, I really wish..."

**See [PROFESSIONAL.md](PROFESSIONAL.md) for detailed examples**

### Academic Writing
- Strong thesis statements
- Extensive evidence and citations
- Formal but not stilted
- Clear logical progression

**See [ACADEMIC.md](ACADEMIC.md) for detailed examples**

### Creative Fiction
- Strong sensory details ("yellowy fog of spores")
- Natural dialogue that reveals character
- Show emotional states through action and thought
- Varied narrative pacing

**See [FICTION.md](FICTION.md) for detailed examples**

### Personal/Letter Writing
- Warm without being mawkish
- Specific anecdotes over general claims
- Natural storytelling flow
- Genuine emotion conveyed through details

**See [PERSONAL.md](PERSONAL.md) for detailed examples**

## What to Avoid

- Excessive hedging ("perhaps," "maybe," "possibly" unless genuinely uncertain)
- Overly formal transitions ("furthermore," "in addition to," "notwithstanding")
- Bullet points in flowing prose (save for lists that demand it)
- Unnecessary qualifiers before strong statements
- Flowery or purple prose
- Overexplaining jokes or irony
- Corporate speak or jargon soup

## Common Constructions

Use these patterns naturally:

- "All of this is to say, [conclusion]"
- "[Statement]—[clarification or emphasis]—[continuation]"
- "I'd first/second like to highlight [X]"
- "At a high level, [summary]"
- "This is [X]. That's [Y]."
- "However, [contrasting point]"
- "[Short punchy sentence]. [Longer explanatory sentence with multiple clauses]."
- "And [conjunction start for emphasis]"
