---
name: parallel-workflows
description: "複数タスクの並列実行を最適化。Use when user mentions running tasks in parallel or together. Do NOT load for: single tasks, sequential-only work, or tasks with dependencies."
description-en: "Optimizes parallel execution of multiple tasks. Use when user mentions running tasks in parallel or together. Do NOT load for: single tasks, sequential-only work, or tasks with dependencies."
description-ja: "複数タスクの並列実行を最適化。Use when user mentions running tasks in parallel or together. Do NOT load for: single tasks, sequential-only work, or tasks with dependencies."
allowed-tools: ["Read", "Task"]
user-invocable: false
---

# Parallel Workflows Skill

複数タスクの並列実行を最適化するスキル。
Task ツールを活用して、独立したタスクを同時に処理します。

---

## トリガーフレーズ

このスキルは以下のフレーズで自動起動します：

- 「並列で実行して」「同時にやって」
- 「まとめてやって」「一気にやって」
- 「効率的にやって」「速くやって」
- "run in parallel", "do these together"

---

## 関連コマンド

- `/work` - Plans.md のタスクを実行（並列実行対応）

---

## 概要

Claude Code は複数のタスクを並列実行できます。
このスキルは、どのタスクが並列化可能かを判断し、最適な実行計画を立てます。

---

## 並列化パターン

### パターン1: 複数ファイルの同時分析

**使用場面**: コードレビュー、構造把握

```
Task tool を並列起動:
- agent1: src/components/ を分析
- agent2: src/lib/ を分析
- agent3: src/app/ を分析
```

**VibeCoder向け言い方**:
```
「このプロジェクトの構造を教えて」
→ 自動的に並列分析を実行
```

### パターン2: テストとビルドの同時実行

**使用場面**: CI/CD、品質チェック

```
並列実行:
- npm run lint
- npm run type-check
- npm run test

直列実行（依存あり）:
- npm run build（上記が全て成功後）
```

**VibeCoder向け言い方**:
```
「チェックして」
→ lint, type-check, test を並列実行
```

### パターン3: 複数機能の同時実装

**使用場面**: 独立した機能の開発

```
Plans.md:
- [ ] ヘッダーコンポーネント作成
- [ ] フッターコンポーネント作成
- [ ] サイドバーコンポーネント作成

→ 3つのTask agentを並列起動
```

**VibeCoder向け言い方**:
```
「レイアウトを全部作って」
→ 独立したコンポーネントを並列実装
```

---

## 判定ロジック

### 並列化可能な条件

1. **ファイル依存なし**: 同じファイルを編集しない
2. **データ依存なし**: 出力が他の入力にならない
3. **順序依存なし**: 実行順序が結果に影響しない

### 並列化不可の例

```
❌ 並列化不可:
1. API クライアント作成
2. API クライアントを使うコンポーネント作成
→ 2は1の出力に依存

✅ 並列化可能:
1. ログインページ作成
2. 会員登録ページ作成
→ 互いに独立
```

---

## 実装ガイド

### Task ツールを使った並列実行

```typescript
// 並列実行パターン
const tasks = [
  { name: "タスクA", prompt: "..." },
  { name: "タスクB", prompt: "..." },
  { name: "タスクC", prompt: "..." }
];

// 全てのタスクを run_in_background: true で起動
// TaskOutput で結果を収集
```

### 統合レポートの生成

各タスク完了後、以下の形式でレポートを生成：

```markdown
## 📊 並列タスク実行レポート

**実行日時**: {{timestamp}}
**タスク数**: {{count}}件（並列実行）
**所要時間**: {{duration}}秒

### 完了タスク

| # | タスク | ステータス | 所要時間 | 成果物 |
|---|-------|----------|---------|-------|
{{#each tasks}}
| {{index}} | {{name}} | {{status}} | {{duration}}秒 | {{output}} |
{{/each}}

### 変更ファイル一覧

{{#each files}}
- `{{path}}` ({{action}})
{{/each}}
```

---

## 実行例

### 例1: プロジェクト分析

```
ユーザー: 「このプロジェクトについて教えて」

Claude Code:
🔍 プロジェクトを並列分析中...

├── [Agent 1] 構造分析中...
├── [Agent 2] 依存関係チェック中...
└── [Agent 3] コード品質分析中...

完了！

📁 プロジェクト概要:
- フレームワーク: Next.js 14
- 主要ディレクトリ: 15個
- ファイル数: 87個
- 依存パッケージ: 23個
- コード品質: 良好（lint警告: 3件）
```

### 例2: 複数機能の実装

```
ユーザー: 「ヘッダー、フッター、サイドバーを作って」

Claude Code:
📋 3つの独立タスクを検出 → 並列実行します

├── [Agent 1] ヘッダー作成中... ✅ 完了
├── [Agent 2] フッター作成中... ✅ 完了
└── [Agent 3] サイドバー作成中... ✅ 完了

⏱️ 所要時間: 45秒（直列なら2分15秒）
```

### 例3: 品質チェック

```
ユーザー: 「全部チェックして」

Claude Code:
🔍 品質チェックを並列実行中...

├── [Lint] ✅ 問題なし
├── [Type] ✅ 型エラーなし
├── [Test] ✅ 15/15 通過
└── [Build] ✅ 成功

✅ 全チェック通過！
```

---

## パフォーマンス指標

| シナリオ | 直列実行 | 並列実行 | 改善率 |
|---------|---------|---------|--------|
| 3ファイル分析 | 30秒 | 12秒 | 60% |
| lint+test+build | 45秒 | 20秒 | 55% |
| 3コンポーネント作成 | 3分 | 1分 | 67% |

---

## エラーハンドリング

### 一部タスク失敗時

1. 成功したタスクの結果は保持
2. 失敗タスクのエラー詳細を表示
3. 再実行オプションを提示

```
📊 並列実行完了（一部エラー）

├── [Task 1] A作成 ✅ (25秒)
├── [Task 2] B作成 ❌ エラー
│   └── 原因: TypeScriptエラー
└── [Task 3] C作成 ✅ (22秒)

⚠️ 1件のタスクが失敗しました。
失敗したタスクを再実行しますか？ (y/n)
```

---

## 使用上の注意

### 推奨

- ✅ 独立したファイルの同時編集
- ✅ 複数の分析タスクの並列実行
- ✅ 非依存テストの同時実行

### 非推奨

- ❌ 同一ファイルへの同時書き込み
- ❌ 依存関係のあるタスクの並列化
- ❌ データベースマイグレーションの並列実行

---

## VibeCoder 向けまとめ

| やりたいこと | 言い方 | 並列化 |
|-------------|--------|--------|
| 複数ページ作成 | 「ページを全部作って」 | ✅ 自動 |
| コード分析 | 「このプロジェクトを分析して」 | ✅ 自動 |
| 品質チェック | 「チェックして」 | ✅ 自動 |
| 順番に実装 | 「順番にやって」 | ❌ 直列 |

**ポイント**: 特に意識しなくても、Claude Code が自動的に並列化可能なタスクを判断して最適化します。
