---
name: core-general-principles
description: "開発の基本原則とセーフティルールを提供する。すべてのタスクで適用される基本的なガイドライン。"
---

# General Principles

claude-code-harness を使用する際の基本原則です。すべてのワークフローで適用されます。

---

## 安全性の原則

### 1. 確認してから変更する

ファイルを編集する前に、必ず以下を確認：

- **Read ツールで内容を確認**: 既存のコードを理解してから変更
- **影響範囲を把握**: 変更が他のファイルに与える影響を考慮
- **バックアップの考慮**: 重要な変更前は git status を確認

### 2. 最小限の差分で編集

```
❌ 悪い例: ファイル全体を書き換える
✅ 良い例: Edit ツールで必要な部分のみ変更
```

### 3. 設定ファイルの尊重

`claude-code-harness.config.json` の設定に従う：

- `safety.mode`: dry-run / apply-local / apply-and-push
- `paths.protected`: 保護されたパスは変更しない
- `paths.allowed_modify`: 許可されたパスのみ変更

---

## 作業の原則

### 1. Plans.md を常に更新

- タスク開始時: `cc:TODO` → `cc:WIP`
- タスク完了時: `cc:WIP` → `cc:完了`
- ブロック時: `blocked` を付与し理由を記載

### 2. 段階的に進める

```
1. 調査・理解 → 2. 計画 → 3. 実装 → 4. 確認 → 5. 報告
```

### 3. エラー時の対応

- 最大 3 回の自動リトライ
- 解決しない場合はエスカレーション（報告）
- エラー内容と試した対処を明記

---

## コミュニケーションの原則

### VibeCoder 対応

技術知識がなくても理解できるよう：

- **専門用語を避ける**: または説明を添える
- **次のアクションを提示**: 「次は〇〇と言ってください」
- **進捗を可視化**: 完了したこと、残っていることを明確に

### PM（Cursor）との連携

- **Plans.md で状態を共有**: 単一ソースとして維持
- **完了報告は `/handoff-to-cursor`**: フォーマットに従う
- **スコープを守る**: 依頼された範囲外の作業は確認を取る

---

## 禁止事項

1. **本番環境への直接デプロイ**（staging まで）
2. **機密情報のハードコード**（.env を使用）
3. **保護されたパスの変更**（.github/, secrets/ など）
4. **ユーザー確認なしの破壊的操作**（rm -rf など）
