---
name: vibecoder-guide
description: "VibeCoder（非技術者）が自然言語で開発を進められるようガイドするスキル。非技術者向けのガイダンスを提供する場合に使用します。"
allowed-tools: ["Read"]
---

# VibeCoder Guide

VibeCoder（非技術者）が自然言語だけで開発を進められるようガイドするスキル。
「どうすればいい？」「次は何？」などの質問に自動で応答します。

---

## トリガーフレーズ

このスキルは以下のフレーズで自動起動します：

- 「どうすればいい？」「どうしたらいい？」
- 「次は何をすればいい？」「次は？」
- 「何ができる？」「何をすればいい？」
- 「困った」「わからない」「助けて」
- 「使い方を教えて」
- "what should I do?", "what's next?", "help"

---

## 概要

VibeCoder は技術的なコマンドやワークフローを知らなくても、
自然な日本語で質問するだけで次のアクションが分かります。

---

## 応答パターン

### パターン1: プロジェクトがない場合

> **まずはプロジェクトを始めましょう！**
>
> **言い方の例：**
> - 「ブログを作りたい」
> - 「タスク管理アプリを作りたい」
> - 「ポートフォリオサイトを作りたい」
>
> ざっくりで大丈夫です。やりたいことを教えてください。

### パターン2: Plans.md があるが進行中タスクがない

> **計画があります。作業を始めましょう！**
>
> **現在の計画:**
> - フェーズ1: 基盤構築
> - フェーズ2: コア機能
> - ...
>
> **言い方の例：**
> - 「フェーズ1を始めて」
> - 「最初のタスクをやって」
> - 「全部やって」

### パターン3: タスク進行中

> **作業中です**
>
> **現在のタスク:** {{タスク名}}
> **進捗:** {{完了数}}/{{全体数}}
>
> **言い方の例：**
> - 「続けて」
> - 「次のタスク」
> - 「今どこまで進んだ？」

### パターン4: フェーズ完了後

> **フェーズが完了しました！**
>
> **次にできること：**
> - 「動作確認して」→ 開発サーバーを起動
> - 「レビューして」→ コード品質チェック
> - 「次のフェーズへ」→ 次の作業を開始
> - 「コミットして」→ 変更を保存

### パターン5: エラー発生時

> **問題が発生しました**
>
> **状況:** {{エラーの要約}}
>
> **言い方の例：**
> - 「直して」→ 自動修正を試行
> - 「説明して」→ 問題の詳細を説明
> - 「スキップして」→ 次のタスクへ

---

## よく使うフレーズ対応表

| やりたいこと | 言い方 |
|-------------|--------|
| プロジェクト開始 | 「〇〇を作りたい」 |
| 計画を見たい | 「計画を見せて」「今の状況は？」 |
| 作業を開始 | 「始めて」「作って」「フェーズ1をやって」 |
| 続きをやる | 「続けて」「次」 |
| 動作確認 | 「動かして」「見せて」 |
| コード確認 | 「レビューして」「チェックして」 |
| 保存する | 「コミットして」「保存して」 |
| 困った時 | 「どうすればいい？」「助けて」 |
| 全部任せる | 「全部やって」「おまかせ」 |

---

## コンテキスト判定

このスキルは以下を確認して適切な応答を選択：

1. **AGENTS.md の存在** → プロジェクトが初期化済みか
2. **Plans.md の内容** → 計画があるか、進捗状況
3. **現在のタスク状態** → `cc:WIP` マーカーの有無
4. **直近のエラー** → 問題が発生しているか

---

## 実装ノート

このスキルが起動したら：

1. 現在の状態を分析
2. 適切なパターンを選択
3. 具体的な「言い方の例」を提示
4. ユーザーの次のアクションを待つ

**重要**: 技術用語を避け、平易な日本語で説明する
