---
name: setup-2agent-files
description: "2エージェント体制に必要なファイル（Cursorコマンド、メモリ構造、バージョンファイル）をセットアップするスキル。Cursor連携のセットアップファイルを生成する場合に使用します。"
allowed-tools: ["Write"]
---

# Setup 2-Agent Files Skill

2エージェント体制（Cursor PM + Claude Code Worker）に必要な補助ファイルをセットアップするスキル。

---

## 目的

`generate-workflow-files` が生成する AGENTS.md, CLAUDE.md, Plans.md 以外の
2エージェント体制に必要なファイルを生成・配置します。

---

## 生成するファイル

### Cursor コマンド (.cursor/commands/)

| ファイル | 用途 | 使うタイミング |
|---------|------|---------------|
| `start-session.md` | セッション開始 | 作業を始める時 |
| `project-overview.md` | プロジェクト全体確認 | 状況を把握したい時 |
| `plan-with-cc.md` | 計画を立てる | 何をすべきか相談したい時 |
| `handoff-to-claude.md` | タスク依頼 | 具体的な作業を依頼する時 |
| `review-cc-work.md` | 完了レビュー | Claude Code の作業を確認する時 |

### Claude Rules (.claude/rules/) - v0.4.0+

| ファイル | 用途 |
|---------|------|
| `workflow.md` | 2-Agent ワークフロールール |
| `coding-standards.md` | コーディング規約（paths: で条件適用） |

### その他のファイル

| ファイル | 用途 |
|---------|------|
| `.claude/memory/session-log.md` | セッション間の作業ログ |
| `.claude/memory/decisions.md` | 重要な決定事項の記録 |
| `.claude/memory/patterns.md` | 学んだパターンの記録 |
| `.claude-code-harness-version` | プラグインバージョン管理 |

---

## 入力

| 項目 | 説明 |
|------|------|
| `plugin_version` | プラグインのバージョン（VERSION ファイルから取得） |
| `project_name` | プロジェクト名（ディレクトリ名から取得） |
| `date` | セットアップ日（自動取得） |
| `setup_status` | セットアップ状態（new / current / outdated） |

### バージョンチェック

既存の `.claude-code-harness-version` がある場合、バージョンを比較して以下を判定：

| 状態 | 判定 | `should_proceed` | `update_type` |
|------|------|------------------|---------------|
| ファイルなし | 新規セットアップ | true | new |
| 同じバージョン | 最新 | false（確認後 true） | skip |
| 古いバージョン | 更新あり | true | update |

---

## 実行手順

### Step 1: バージョン情報の取得

```bash
# プラグインパス（インストール場所に依存しない）
PLUGIN_PATH="${CLAUDE_PLUGIN_ROOT:-$HOME/.claude/plugins/claude-code-harness}"

# プラグインのバージョンを取得
PLUGIN_VERSION=$(cat "$PLUGIN_PATH/VERSION" 2>/dev/null || echo "0.0.0")

# 現在の日付
TODAY=$(date +%Y-%m-%d)

# プロジェクト名
PROJECT_NAME=$(basename "$(pwd)")
```

### Step 2: 既存ファイルの確認

```bash
# 既存ファイルをチェック
[ -f .claude-code-harness-version ] && echo "existing: .claude-code-harness-version"
[ -d .cursor/commands ] && echo "existing: .cursor/commands/"
[ -d .claude/memory ] && echo "existing: .claude/memory/"
```

### Step 3: Cursor コマンドの配置

**重要**: テンプレートフォルダ内の全コマンドをコピーする

```bash
# ディレクトリ作成
mkdir -p .cursor/commands

# テンプレートから全コマンドをコピー
PLUGIN_PATH="${CLAUDE_PLUGIN_ROOT:-$HOME/.claude/plugins/claude-code-harness}"

cp "$PLUGIN_PATH/templates/cursor/commands/start-session.md" .cursor/commands/
cp "$PLUGIN_PATH/templates/cursor/commands/project-overview.md" .cursor/commands/
cp "$PLUGIN_PATH/templates/cursor/commands/plan-with-cc.md" .cursor/commands/
cp "$PLUGIN_PATH/templates/cursor/commands/handoff-to-claude.md" .cursor/commands/
cp "$PLUGIN_PATH/templates/cursor/commands/review-cc-work.md" .cursor/commands/
```

**コピー元テンプレート** (5ファイル):
- `templates/cursor/commands/start-session.md` - セッション開始
- `templates/cursor/commands/project-overview.md` - プロジェクト確認
- `templates/cursor/commands/plan-with-cc.md` - 計画立案
- `templates/cursor/commands/handoff-to-claude.md` - タスク依頼
- `templates/cursor/commands/review-cc-work.md` - 完了レビュー

### Step 4: Claude Rules の配置（v0.4.0+）

```bash
# ディレクトリ作成
mkdir -p .claude/rules

# ルールファイルをテンプレートからコピー
PLUGIN_PATH="${CLAUDE_PLUGIN_ROOT:-$HOME/.claude/plugins/claude-code-harness}"

for template in "$PLUGIN_PATH/templates/rules"/*.template; do
  if [ -f "$template" ]; then
    rule_name=$(basename "$template" .template)
    cp "$template" ".claude/rules/$rule_name"
  fi
done
```

### Step 5: メモリ構造の初期化

```bash
# ディレクトリ作成
mkdir -p .claude/memory
```

**session-log.md** を作成:

```markdown
# Session Log

セッション間で共有する作業ログ。

---

## {{DATE}}

- 2エージェント体制セットアップ完了
```

**decisions.md** を作成:

```markdown
# Decisions

プロジェクトで決定された重要な設計・方針の記録。

---

## 設計決定

（まだ記録なし）

## 方針決定

（まだ記録なし）
```

**patterns.md** を作成:

```markdown
# Patterns

プロジェクトで発見・採用したパターンの記録。

---

## コーディングパターン

（まだ記録なし）

## 問題解決パターン

（まだ記録なし）
```

### Step 6: バージョンファイルの作成

**テンプレートから変数を置換して作成**:

```bash
# templates/.claude-code-harness-version.template を読み込み、変数を置換
sed -e "s/{{VERSION}}/${PLUGIN_VERSION}/g" \
    -e "s/{{DATE}}/${TODAY}/g" \
    "$PLUGIN_PATH/templates/.claude-code-harness-version.template" \
    > .claude-code-harness-version
```

または直接作成:

```
# claude-code-harness version tracking
# This file is auto-generated by /setup-cursor
# DO NOT manually edit - used for update detection

version: {{PLUGIN_VERSION}}
installed_at: {{TODAY}}
last_setup_command: setup-cursor
```

---

## 出力

| 項目 | 説明 |
|------|------|
| `should_proceed` | セットアップを続行するか（boolean） |
| `update_type` | 更新タイプ（new / update / skip） |
| `current_version` | 既存のバージョン（更新時のみ） |
| `cursor_commands_created` | 作成された Cursor コマンド一覧 |
| `memory_initialized` | メモリ構造の初期化完了フラグ |
| `version_file_created` | バージョンファイル作成完了フラグ |

---

## 注意事項

- **既存ファイルがある場合**: 上書き確認を求める
- **テンプレートを直接コピー**: 簡略化せず、詳細版テンプレートを使用
- **バージョン管理**: `.claude-code-harness-version` で更新検出を可能にする

### Step 7: Hooks 設定の配置（自動整理機能）

```bash
# スクリプトディレクトリ作成
mkdir -p .claude/scripts

# Hook スクリプトをコピー
PLUGIN_PATH="${CLAUDE_PLUGIN_ROOT:-$HOME/.claude/plugins/claude-code-harness}"
cp "$PLUGIN_PATH/templates/hooks/auto-cleanup-hook.sh" .claude/scripts/
chmod +x .claude/scripts/auto-cleanup-hook.sh

# 設定ファイルをコピー
cp "$PLUGIN_PATH/templates/.claude-code-harness.config.yaml.template" .claude-code-harness.config.yaml
```

**.claude/settings.json** は `generate-claude-settings` で作成/更新（既存があれば非破壊マージ）:

- `permissions.deny/ask` をチーム運用できる形で整備
- `permissions.disableBypassPermissionsMode` は **設定しない**（bypassPermissions を許可）
  - セキュリティ要件で bypass を禁止したい場合のみ設定（例: managed-settings.json）

**⚠️ パーミッション構文の注意**: プレフィックスマッチには必ず `:*` を使用（`*` 単独は不可）
- 正しい: `"Bash(npm run:*)"` / 間違い: `"Bash(npm run *)"`

手順は `skills/setup/references/claude-settings.md` に従うこと。

---

## 関連スキル

- `generate-workflow-files` - AGENTS.md, CLAUDE.md, Plans.md の生成
- `generate-claude-settings` - `.claude/settings.json` の作成/更新（安全ポリシー + 非破壊マージ）
- `session-memory` - メモリ構造の活用方法
- `core-read-repo-context` - 既存ファイルの確認
- `auto-cleanup` - 自動整理機能
