---
name: review-apply-fixes
description: "レビューで検出された問題を自動修正するスキル。レビューで発見された問題の自動修正が承認された場合に使用します。"
allowed-tools: ["Read", "Edit", "Bash"]
---

# Review Apply Fixes

レビューで検出された問題を自動修正するスキル。

---

## 目的

レビュー結果に基づいて：
- 自動修正可能な問題を特定
- ユーザー確認後に修正を適用
- 修正前後の diff を提示

---

## 入力

| 項目 | 説明 |
|------|------|
| `improvement_suggestions` | 改善提案リスト |
| `user_approved` | ユーザーが修正を承認したか |

---

## 出力

| 項目 | 説明 |
|------|------|
| `applied_fixes` | 適用された修正のリスト |
| `skipped_fixes` | スキップされた修正のリスト |
| `update_files` | 更新されたファイルのリスト |

---

## 自動修正可能な問題

### 確実に自動修正できるもの

| カテゴリ | 問題 | 修正方法 |
|---------|------|---------|
| 品質 | 未使用の import | 削除 |
| 品質 | 未使用の変数 | 削除（または _ プレフィックス） |
| 品質 | フォーマット | Prettier/ESLint --fix |
| セキュリティ | console.log の削除 | 削除またはロガーに置換 |

### 確認が必要なもの

| カテゴリ | 問題 | 確認理由 |
|---------|------|---------|
| パフォーマンス | メモ化追加 | ロジック変更の可能性 |
| 品質 | 関数分割 | 設計判断が必要 |
| セキュリティ | 入力バリデーション | 仕様確認が必要 |

### 自動修正しないもの

| カテゴリ | 問題 | 理由 |
|---------|------|------|
| 設計 | アーキテクチャ変更 | 大規模な変更 |
| ロジック | ビジネスロジック修正 | 仕様理解が必要 |

---

## 実行フロー

```
改善提案リスト
    │
    ▼
┌─────────────────────────────┐
│ 自動修正可能性の判定        │
│ - 確実に修正可能            │
│ - 確認が必要                │
│ - 手動対応が必要            │
└─────────────┬───────────────┘
              │
              ▼
┌─────────────────────────────┐
│ ユーザーへの確認            │
│ - 適用する修正の一覧提示    │
│ - 承認を待つ                │
└─────────────┬───────────────┘
              │
    ┌─────────┴─────────┐
    ▼                   ▼
 承認              キャンセル
    │                   │
    ▼                   ▼
 修正適用          修正なしで終了
    │
    ▼
 diff 提示
```

---

## 出力例

### 修正前の確認

```markdown
## 自動修正の確認

以下の修正を適用しますか？

### 適用予定 (3件)
1. ✅ 未使用 import の削除 - `src/utils/helpers.ts:12`
2. ✅ console.log の削除 - `src/api/posts.ts:45`
3. ✅ フォーマット修正 - `src/components/Button.tsx`

### 確認が必要 (1件)
4. ⚠️ useMemo の追加 - `src/components/List.tsx:23`
   - 計算処理のメモ化を追加しますか？

### 手動対応が必要 (1件)
5. ❌ 関数分割 - `src/services/user.ts:45`
   - 設計判断が必要なため自動修正不可

[適用する] [一部のみ] [キャンセル]
```

### 修正後のレポート

```markdown
## 修正完了

### 適用された修正 (3件)
1. ✅ 未使用 import の削除 - `src/utils/helpers.ts`
2. ✅ console.log の削除 - `src/api/posts.ts`
3. ✅ フォーマット修正 - `src/components/Button.tsx`

### 変更 diff
[diff を表示]

### 次のステップ
- ビルド検証を実行して問題がないことを確認
- 手動対応が必要な 1 件を検討
```

---

## 注意事項

- 修正前に必ず diff を提示する
- 破壊的な変更は行わない
- 修正後にビルド検証を推奨する
- 不明な場合はスキップする
