# Feature Specification Template

## Kanitsal Cerceve (Evidential Frame Activation)
Kaynak dogrulama modu etkin.




## When to Use This Skill

- **Full Feature Development**: Complete end-to-end feature implementation
- **Greenfield Features**: Building new functionality from scratch
- **Research Required**: Features needing best practice research
- **Multi-Layer Changes**: Features spanning frontend, backend, database
- **Production Deployment**: Features requiring full testing and documentation
- **Architecture Design**: Features needing upfront design decisions

## When NOT to Use This Skill

- **Bug Fixes**: Use debugging or smart-bug-fix skills instead
- **Quick Prototypes**: Exploratory coding without production requirements
- **Refactoring**: Code restructuring without new features
- **Documentation Only**: Pure documentation tasks

## Success Criteria

- [ ] Feature fully implemented across all layers
- [ ] Unit tests passing with >80% coverage
- [ ] Integration tests passing
- [ ] E2E tests passing (if applicable)
- [ ] Code reviewed and approved
- [ ] Documentation complete (API docs, user guides)
- [ ] Performance benchmarks met
- [ ] Security review passed
- [ ] Deployed to staging and validated

## Edge Cases to Handle

- **Legacy Integration**: Interfacing with old code or deprecated APIs
- **Breaking Changes**: Features requiring API versioning or migrations
- **Feature Flags**: Gradual rollout or A/B testing requirements
- **Data Migration**: Schema changes requiring backfill scripts
- **Third-Party Dependencies**: External API rate limits or availability
- **Browser Compatibility**: Cross-browser testing requirements

## Guardrails

- **NEVER** skip testing phases to ship faster
- **ALWAYS** research best practices before implementing
- **NEVER** commit directly to main - use feature branches
- **ALWAYS** write tests before or during implementation (TDD)
- **NEVER** hardcode configuration - use environment variables
- **ALWAYS** document architectural decisions (ADRs)
- **NEVER** deploy without staging validation

## Evidence-Based Validation

- [ ] All automated tests passing (npm test / pytest)
- [ ] Code coverage reports reviewed
- [ ] Lighthouse score meets thresholds (if web)
- [ ] Load testing validates performance targets
- [ ] Security scan shows no critical vulnerabilities
- [ ] Accessibility audit passes (axe, WAVE)
- [ ] Manual testing on target devices/browsers

**Feature Name**: [Feature Name]
**Author**: [Your Name]
**Date**: [YYYY-MM-DD]
**Status**: [Draft | In Review | Approved | In Development | Complete]

---

## 1. Overview

### Purpose
Brief description of what this feature does and why it's needed.

### Goals
- Primary goal 1
- Primary goal 2
- Primary goal 3

### Non-Goals
What this feature explicitly does NOT cover:
- Non-goal 1
- Non-goal 2

---

## 2. User Stories

### Primary User Story
**As a** [user type]
**I want** [capability]
**So that** [benefit]

### Acceptance Criteria
- [ ] Criterion 1
- [ ] Criterion 2
- [ ] Criterion 3

### Additional User Stories
1. **As a** ... **I want** ... **So that** ...
2. **As a** ... **I want** ... **So that** ...

---

## 3. Requirements

### Functional Requirements
| ID | Requirement | Priority | Notes |
|----|-------------|----------|-------|
| FR-1 | [Requirement description] | High | [Additional context] |
| FR-2 | [Requirement description] | Medium | [Additional context] |
| FR-3 | [Requirement description] | Low | [Additional context] |

### Non-Functional Requirements
| ID | Requirement | Target | Notes |
|----|-------------|--------|-------|
| NFR-1 | Performance | [Target metric] | [Context] |
| NFR-2 | Scalability | [Target metric] | [Context] |
| NFR-3 | Security | [Target metric] | [Context] |
| NFR-4 | Usability | [Target metric] | [Context] |

---

## 4. Technical Design

### Architecture Overview
High-level description of the technical approach.

### System Components
1. **Component 1**: [Description and responsibilities]
2. **Component 2**: [Description and responsibilities]
3. **Component 3**: [Description and responsibilities]

### Data Model
```
Entity1:
  - field1: type
  - field2: type
  - field3: type

Entity2:
  - field1: type
  - field2: type
```

### API Endpoints (if applicable)
| Method | Endpoint | Description | Auth Required |
|--------|----------|-------------|---------------|
| GET | `/api/resource` | List resources | Yes |
| POST | `/api/resource` | Create resource | Yes |
| PUT | `/api/resource/:id` | Update resource | Yes |
| DELETE | `/api/resource/:id` | Delete resource | Yes |

### External Dependencies
- Dependency 1: [Purpose and version]
- Dependency 2: [Purpose and version]
- Dependency 3: [Purpose and version]

---

## 5. User Interface

### UI Components
1. **Component 1**: [Description, purpose, behavior]
2. **Component 2**: [Description, purpose, behavior]

### User Flow
```
[Entry Point] → [Step 1] → [Step 2] → [Step 3] → [Success State]
                     ↓
                [Error State]
```

### Wireframes/Mockups
[Include links to wireframes or embed images]

---

## 6. Testing Strategy

### Unit Tests
- [ ] Test core business logic
- [ ] Test edge cases
- [ ] Test error handling
- [ ] Target coverage: ≥80%

### Integration Tests
- [ ] Test component interactions
- [ ] Test external API calls
- [ ] Test database operations

### End-to-End Tests
- [ ] Test critical user flows
- [ ] Test cross-browser compatibility
- [ ] Test mobile responsiveness

### Performance Tests
- [ ] Load testing
- [ ] Stress testing
- [ ] Benchmark against targets

---

## 7. Security Considerations

### Authentication & Authorization
- [How users authenticate]
- [How permissions are enforced]

### Data Protection
- [How sensitive data is protected]
- [Encryption requirements]

### Potential Vulnerabilities
| Vulnerability | Mitigation Strategy |
|---------------|---------------------|
| [Vulnerability 1] | [Mitigation] |
| [Vulnerability 2] | [Mitigation] |

---

## 8. Implementation Plan

### Phase 1: Foundation
**Duration**: [Timeframe]
- [ ] Task 1
- [ ] Task 2
- [ ] Task 3

### Phase 2: Core Features
**Duration**: [Timeframe]
- [ ] Task 1
- [ ] Task 2
- [ ] Task 3

### Phase 3: Polish & Testing
**Duration**: [Timeframe]
- [ ] Task 1
- [ ] Task 2
- [ ] Task 3

### Phase 4: Deployment
**Duration**: [Timeframe]
- [ ] Task 1
- [ ] Task 2
- [ ] Task 3

---

## 9. Success Metrics

### Key Performance Indicators (KPIs)
| Metric | Target | Measurement Method |
|--------|--------|-------------------|
| User adoption | [Target] | [How measured] |
| Performance | [Target] | [How measured] |
| Error rate | [Target] | [How measured] |
| User satisfaction | [Target] | [How measured] |

### Monitoring & Alerting
- [What metrics to monitor]
- [Alert thresholds]
- [Escalation procedures]

---

## 10. Risks & Mitigation

| Risk | Probability | Impact | Mitigation Strategy |
|------|-------------|--------|---------------------|
| [Risk 1] | High/Med/Low | High/Med/Low | [Strategy] |
| [Risk 2] | High/Med/Low | High/Med/Low | [Strategy] |
| [Risk 3] | High/Med/Low | High/Med/Low | [Strategy] |

---

## 11. Dependencies & Constraints

### Dependencies
- **External Team 1**: [What they need to deliver]
- **External Team 2**: [What they need to deliver]

### Technical Constraints
- [Constraint 1]
- [Constraint 2]

### Business Constraints
- [Constraint 1]
- [Constraint 2]

---

## 12. Rollout Plan

### Deployment Strategy
- [ ] Feature flags enabled
- [ ] Gradual rollout (5% → 25% → 50% → 100%)
- [ ] A/B testing configured
- [ ] Rollback plan documented

### Communication Plan
- **Internal**: [How to communicate with team]
- **External**: [How to communicate with users]

### Training & Documentation
- [ ] User documentation created
- [ ] API documentation updated
- [ ] Training materials prepared
- [ ] Support team briefed

---

## 13. Appendices

### Appendix A: Research & References
- [Link to research document]
- [Link to competitive analysis]
- [Link to user feedback]

### Appendix B: Design Decisions
| Decision | Options Considered | Chosen Option | Rationale |
|----------|-------------------|---------------|-----------|
| [Decision 1] | [Options] | [Chosen] | [Why] |
| [Decision 2] | [Options] | [Chosen] | [Why] |

### Appendix C: Change Log
| Date | Author | Change Description |
|------|--------|-------------------|
| YYYY-MM-DD | [Name] | Initial draft |
| YYYY-MM-DD | [Name] | [Change description] |

---

**Approval Signatures**

| Role | Name | Signature | Date |
|------|------|-----------|------|
| Product Manager | | | |
| Tech Lead | | | |
| Engineering Manager | | | |
| Security Lead | | | |


---
*Promise: `<promise>FEATURE_SPECIFICATION_VERIX_COMPLIANT</promise>`*
