# Test Plan Template

## Kanitsal Cerceve (Evidential Frame Activation)
Kaynak dogrulama modu etkin.




## When to Use This Skill

- **Full Feature Development**: Complete end-to-end feature implementation
- **Greenfield Features**: Building new functionality from scratch
- **Research Required**: Features needing best practice research
- **Multi-Layer Changes**: Features spanning frontend, backend, database
- **Production Deployment**: Features requiring full testing and documentation
- **Architecture Design**: Features needing upfront design decisions

## When NOT to Use This Skill

- **Bug Fixes**: Use debugging or smart-bug-fix skills instead
- **Quick Prototypes**: Exploratory coding without production requirements
- **Refactoring**: Code restructuring without new features
- **Documentation Only**: Pure documentation tasks

## Success Criteria

- [ ] Feature fully implemented across all layers
- [ ] Unit tests passing with >80% coverage
- [ ] Integration tests passing
- [ ] E2E tests passing (if applicable)
- [ ] Code reviewed and approved
- [ ] Documentation complete (API docs, user guides)
- [ ] Performance benchmarks met
- [ ] Security review passed
- [ ] Deployed to staging and validated

## Edge Cases to Handle

- **Legacy Integration**: Interfacing with old code or deprecated APIs
- **Breaking Changes**: Features requiring API versioning or migrations
- **Feature Flags**: Gradual rollout or A/B testing requirements
- **Data Migration**: Schema changes requiring backfill scripts
- **Third-Party Dependencies**: External API rate limits or availability
- **Browser Compatibility**: Cross-browser testing requirements

## Guardrails

- **NEVER** skip testing phases to ship faster
- **ALWAYS** research best practices before implementing
- **NEVER** commit directly to main - use feature branches
- **ALWAYS** write tests before or during implementation (TDD)
- **NEVER** hardcode configuration - use environment variables
- **ALWAYS** document architectural decisions (ADRs)
- **NEVER** deploy without staging validation

## Evidence-Based Validation

- [ ] All automated tests passing (npm test / pytest)
- [ ] Code coverage reports reviewed
- [ ] Lighthouse score meets thresholds (if web)
- [ ] Load testing validates performance targets
- [ ] Security scan shows no critical vulnerabilities
- [ ] Accessibility audit passes (axe, WAVE)
- [ ] Manual testing on target devices/browsers

**Feature**: [Feature Name]
**Test Plan Author**: [Your Name]
**Date**: [YYYY-MM-DD]
**Version**: 1.0

---

## 1. Test Overview

### Scope
This test plan covers testing for [feature name], including:
- Unit tests
- Integration tests
- End-to-end tests
- Performance tests
- Security tests

### Objectives
- Ensure feature meets all functional requirements
- Verify non-functional requirements (performance, security, usability)
- Achieve ≥80% code coverage
- Identify and fix critical bugs before release

### Out of Scope
- [What is not being tested in this plan]
- [Other exclusions]

---

## 2. Test Strategy

### Test Levels

#### Unit Testing
**Framework**: [Jest / Mocha / pytest / etc.]
**Coverage Target**: ≥90%
**Focus Areas**:
- Core business logic
- Edge cases and boundary conditions
- Error handling and validation
- Pure functions and utilities

#### Integration Testing
**Framework**: [Testing framework]
**Coverage Target**: ≥80%
**Focus Areas**:
- Component interactions
- API endpoints
- Database operations
- External service integrations

#### End-to-End Testing
**Framework**: [Playwright / Cypress / Selenium]
**Coverage Target**: Critical user flows
**Focus Areas**:
- Complete user workflows
- Cross-browser compatibility
- Mobile responsiveness
- Accessibility compliance

#### Performance Testing
**Tools**: [LoadForge / k6 / JMeter]
**Target Metrics**:
- Response time: <200ms (p95)
- Throughput: [target requests/sec]
- Error rate: <0.1%
- Concurrent users: [target number]

#### Security Testing
**Tools**: [OWASP ZAP / Snyk / etc.]
**Focus Areas**:
- Authentication & authorization
- Input validation
- SQL injection prevention
- XSS prevention
- CSRF protection

---

## 3. Test Environment

### Development Environment
- **OS**: [Operating system]
- **Browser**: [Browser versions]
- **Database**: [Database version]
- **Dependencies**: [Key dependencies]

### Staging Environment
- **URL**: [Staging URL]
- **Configuration**: [Similar to production]
- **Test Data**: [Description of test data]

### Production Environment
- **Monitoring**: [Monitoring tools]
- **Canary Deployment**: [Percentage rollout strategy]

---

## 4. Test Cases

### 4.1 Unit Test Cases

#### Test Suite: Core Logic

| Test ID | Description | Input | Expected Output | Priority |
|---------|-------------|-------|-----------------|----------|
| UT-001 | [Test description] | [Input data] | [Expected result] | High |
| UT-002 | [Test description] | [Input data] | [Expected result] | High |
| UT-003 | [Test description] | [Input data] | [Expected result] | Medium |

#### Test Suite: Edge Cases

| Test ID | Description | Input | Expected Output | Priority |
|---------|-------------|-------|-----------------|----------|
| UT-101 | Null input handling | null | Error thrown | High |
| UT-102 | Empty input handling | "" | Error thrown | High |
| UT-103 | Maximum length input | [Max length string] | Success | Medium |

---

### 4.2 Integration Test Cases

| Test ID | Description | Setup | Steps | Expected Result | Priority |
|---------|-------------|-------|-------|-----------------|----------|
| IT-001 | [Integration scenario] | [Preconditions] | [Test steps] | [Expected outcome] | High |
| IT-002 | [Integration scenario] | [Preconditions] | [Test steps] | [Expected outcome] | High |
| IT-003 | [Integration scenario] | [Preconditions] | [Test steps] | [Expected outcome] | Medium |

---

### 4.3 End-to-End Test Cases

| Test ID | User Story | Preconditions | Steps | Expected Result | Priority |
|---------|------------|---------------|-------|-----------------|----------|
| E2E-001 | As a user, I want to... | [Setup] | 1. [Step]<br>2. [Step]<br>3. [Step] | [Outcome] | High |
| E2E-002 | As a user, I want to... | [Setup] | 1. [Step]<br>2. [Step]<br>3. [Step] | [Outcome] | High |

---

### 4.4 Performance Test Cases

| Test ID | Scenario | Load Profile | Success Criteria |
|---------|----------|--------------|------------------|
| PT-001 | Normal load | 100 concurrent users | Response time <200ms (p95) |
| PT-002 | Peak load | 500 concurrent users | Response time <500ms (p95) |
| PT-003 | Stress test | 1000+ concurrent users | Graceful degradation |

---

### 4.5 Security Test Cases

| Test ID | Vulnerability | Test Method | Expected Result |
|---------|--------------|-------------|-----------------|
| ST-001 | SQL Injection | Inject malicious SQL | Input sanitized, attack blocked |
| ST-002 | XSS Attack | Inject script tags | Output escaped, script not executed |
| ST-003 | CSRF Attack | Forge request | CSRF token validated, request rejected |
| ST-004 | Auth Bypass | Access without credentials | 401 Unauthorized |

---

## 5. Test Data

### Test Data Requirements
- **User Accounts**: [Number and types of test users needed]
- **Sample Data**: [Types of data objects needed]
- **Edge Case Data**: [Boundary and special case data]

### Test Data Management
- **Creation**: [How test data is created]
- **Refresh**: [How often test data is refreshed]
- **Cleanup**: [How test data is cleaned up]
- **Privacy**: [How sensitive data is handled]

---

## 6. Test Execution

### Test Schedule

| Phase | Start Date | End Date | Responsible | Status |
|-------|------------|----------|-------------|--------|
| Unit Testing | [Date] | [Date] | [Name] | Not Started |
| Integration Testing | [Date] | [Date] | [Name] | Not Started |
| E2E Testing | [Date] | [Date] | [Name] | Not Started |
| Performance Testing | [Date] | [Date] | [Name] | Not Started |
| Security Testing | [Date] | [Date] | [Name] | Not Started |
| UAT | [Date] | [Date] | [Name] | Not Started |

### Entry Criteria
- [ ] Code complete and merged to test branch
- [ ] Test environment provisioned
- [ ] Test data prepared
- [ ] All blockers resolved

### Exit Criteria
- [ ] All high-priority tests passed
- [ ] Code coverage ≥80%
- [ ] No critical or high-severity bugs open
- [ ] Performance targets met
- [ ] Security scan passed

---

## 7. Defect Management

### Bug Severity Levels
- **Critical**: System crash, data loss, security vulnerability
- **High**: Major feature broken, no workaround
- **Medium**: Feature partially broken, workaround exists
- **Low**: Minor issue, cosmetic problem

### Bug Tracking
- **Tool**: [Jira / GitHub Issues / etc.]
- **Workflow**: Open → In Progress → Fixed → Verified → Closed
- **SLA**:
  - Critical: Fix within 24 hours
  - High: Fix within 3 days
  - Medium: Fix within 1 week
  - Low: Fix within 2 weeks

---

## 8. Test Deliverables

### Test Artifacts
- [ ] Test plan (this document)
- [ ] Test cases (detailed specifications)
- [ ] Test scripts (automated test code)
- [ ] Test data sets
- [ ] Test execution reports
- [ ] Bug reports
- [ ] Test summary report

### Test Reports
- **Daily**: Test execution progress
- **Weekly**: Test summary with metrics
- **Final**: Comprehensive test report with recommendations

---

## 9. Risks & Mitigation

| Risk | Impact | Probability | Mitigation |
|------|--------|-------------|------------|
| Test environment unstable | High | Medium | Set up backup environment |
| Insufficient test data | Medium | Low | Automate test data generation |
| Timeline too aggressive | High | Medium | Prioritize critical tests |
| Dependencies not ready | High | Medium | Mock external dependencies |

---

## 10. Test Metrics

### Key Metrics to Track
- **Test Coverage**: Code coverage percentage
- **Pass Rate**: Percentage of tests passing
- **Defect Density**: Bugs per 1000 lines of code
- **Defect Resolution Time**: Average time to fix bugs
- **Test Execution Time**: Time to run full test suite

### Reporting Dashboard
```
┌─────────────────────────────────────┐
│ Test Coverage:        [XX]%         │
│ Tests Passing:        [XXX/XXX]     │
│ Critical Bugs:        [X]           │
│ High Bugs:            [X]           │
│ Performance (p95):    [XXX]ms       │
└─────────────────────────────────────┘
```

---

## 11. Continuous Testing

### CI/CD Integration
- **Unit Tests**: Run on every commit
- **Integration Tests**: Run on every PR
- **E2E Tests**: Run nightly
- **Performance Tests**: Run weekly
- **Security Scans**: Run on every release

### Automated Test Execution
```bash
# Run full test suite
npm run test:all

# Run unit tests only
npm run test:unit

# Run with coverage
npm run test:coverage

# Run E2E tests
npm run test:e2e
```

---

## 12. Acceptance Criteria

### Feature Acceptance
- [ ] All acceptance criteria from feature spec met
- [ ] Code review completed and approved
- [ ] All automated tests passing
- [ ] Manual testing completed
- [ ] Performance benchmarks met
- [ ] Security scan passed
- [ ] Documentation updated
- [ ] Product owner sign-off

---

## 13. Sign-Off

| Role | Name | Signature | Date |
|------|------|-----------|------|
| QA Lead | | | |
| Tech Lead | | | |
| Product Manager | | | |
| Security Lead | | | |

---

**Appendix A: Test Case Details**

[Detailed test case specifications can be attached or linked here]

**Appendix B: Test Scripts**

[Links to automated test repositories or scripts]

**Appendix C: Test Results**

[Test execution results and screenshots]


---
*Promise: `<promise>TEST_PLAN_VERIX_COMPLIANT</promise>`*
