# GitHub Multi-Repository Skill - Gold Tier

## Kanitsal Cerceve (Evidential Frame Activation)
Kaynak dogrulama modu etkin.



## CRITICAL: GITHUB OPERATIONS SAFETY GUARDRAILS

**BEFORE any GitHub operation, validate**:
- [ ] Branch protection rules respected (required reviews, status checks)
- [ ] No force-push to protected branches (main, master, release/*)
- [ ] PR template completed (description, tests, screenshots)
- [ ] CI checks passing (build, lint, test, security scan)
- [ ] Code review approved by domain experts

**NEVER**:
- Merge without passing CI checks
- Delete branches with unmerged commits
- Bypass CODEOWNERS approval requirements
- Commit secrets or sensitive data (use .gitignore + pre-commit hooks)
- Force-push to shared branches

**ALWAYS**:
- Use conventional commits (feat:, fix:, refactor:, docs:)
- Link PRs to issues for traceability
- Update CHANGELOG.md with user-facing changes
- Tag releases with semantic versioning (vX.Y.Z)
- Document breaking changes in PR description

**Evidence-Based Techniques for GitHub Operations**:
- **Program-of-Thought**: Model PR workflow as state machine (draft -> review -> approved -> merged)
- **Retrieval-Augmented**: Query similar PRs for review patterns
- **Chain-of-Thought**: Trace commit history for root cause analysis
- **Self-Consistency**: Apply same review checklist across all PRs


**Tier**: Gold (12+ files)
**Version**: 2.0.0
**Status**: Production Ready

## Overview

Advanced multi-repository coordination system with comprehensive scripts, templates, and tests for managing organization-wide repository operations.

## Structure

```
github-multi-repo/
├── skill.md                    # Main skill documentation
├── README.md                   # This file
├── resources/
│   ├── scripts/
│   │   ├── sync-repos.js              # Multi-repo synchronization
│   │   ├── architecture-analyzer.js   # Architecture analysis
│   │   ├── cross-repo-refactor.js     # Coordinated refactoring
│   │   └── dependency-updater.js      # Automated dependency updates
│   └── templates/
│       ├── monorepo-config.json       # Monorepo package.json template
│       ├── turbo.json                 # Turborepo configuration
│       └── workspace-package-template.json  # Workspace package template
└── tests/
    ├── sync-repos.test.js             # Sync script tests
    ├── architecture-analyzer.test.js  # Analyzer tests
    └── cross-repo-refactor.test.js    # Refactor tests
```

## Gold Tier Components

### Scripts (4 functional scripts)

1. **sync-repos.js** - Multi-repository synchronization
   - Package version alignment
   - Configuration synchronization
   - Automated PR creation
   - Dry-run support

2. **architecture-analyzer.js** - Repository architecture analysis
   - Structure analysis
   - Dependency mapping
   - Pattern detection
   - Recommendation generation

3. **cross-repo-refactor.js** - Coordinated refactoring
   - Rename operations
   - Import updates
   - Dependency migrations
   - Configuration changes

4. **dependency-updater.js** - Automated dependency management
   - Outdated package detection
   - Coordinated updates
   - Test validation
   - Rollback support

### Templates (3 templates)

1. **monorepo-config.json** - Monorepo configuration
2. **turbo.json** - Turborepo pipeline configuration
3. **workspace-package-template.json** - Package template

### Tests (3 comprehensive test suites)

1. **sync-repos.test.js** - 8+ test cases covering:
   - Repository discovery
   - Version synchronization
   - Configuration sync
   - PR creation

2. **architecture-analyzer.test.js** - 10+ test cases covering:
   - Structure analysis
   - Dependency analysis
   - Pattern detection
   - Recommendations

3. **cross-repo-refactor.test.js** - 12+ test cases covering:
   - Rename operations
   - Import updates
   - Dependency updates
   - Configuration migration

## Usage

### Synchronize Repositories

```bash
node resources/scripts/sync-repos.js \
  --repos "org/repo1,org/repo2" \
  --sync-type versions \
  --create-pr
```

### Analyze Architecture

```bash
node resources/scripts/architecture-analyzer.js \
  --org "my-org" \
  --output report.json \
  --format json
```

### Cross-Repo Refactoring

```bash
node resources/scripts/cross-repo-refactor.js \
  --repos "org/repo1,org/repo2" \
  --operation rename \
  --old "OldAPI" \
  --new "NewAPI"
```

### Update Dependencies

```bash
node resources/scripts/dependency-updater.js \
  --org "my-org" \
  --package "typescript" \
  --version "^5.0.0" \
  --test-before-pr
```

## Testing

```bash
# Run all tests
npm test

# Run specific test suite
npm test tests/sync-repos.test.js

# Run with coverage
npm test -- --coverage
```

## File Count

- **Total**: 12 files
- **Scripts**: 4 functional scripts
- **Templates**: 3 configuration templates
- **Tests**: 3 comprehensive test suites
- **Documentation**: 2 (skill.md + README.md)

## Tier Requirements Met

✅ **Gold Tier (12+ files)**
- 4 multi-repo coordination scripts
- 3 monorepo/workspace templates
- 3 comprehensive test suites
- Full documentation
- Functional, production-ready code

## Features

### Core Capabilities
- Cross-repository synchronization
- Architecture analysis and optimization
- Coordinated refactoring operations
- Automated dependency management
- Monorepo configuration templates
- Comprehensive test coverage

### Integration
- GitHub CLI (gh) for repository operations
- Git for version control
- npm/yarn/pnpm for package management
- Jest for testing
- Turborepo for monorepo builds

## Requirements

- Node.js >= 20.0.0
- GitHub CLI (gh) >= 2.0.0
- Git >= 2.30.0
- npm >= 9.0.0

## License

MIT


---
*Promise: `<promise>README_VERIX_COMPLIANT</promise>`*
