# GitHub Project Management Resources

## Kanitsal Cerceve (Evidential Frame Activation)
Kaynak dogrulama modu etkin.



## CRITICAL: AUTOMATION SAFETY GUARDRAILS

**BEFORE any automation hook, validate**:
- [ ] Idempotency guaranteed (safe to run multiple times)
- [ ] Timeout configured (prevent infinite loops)
- [ ] Error handling with graceful degradation
- [ ] Audit logging for all state changes
- [ ] Human-in-the-loop for destructive operations

**NEVER**:
- Execute destructive operations without confirmation
- Bypass validation in pre-commit/pre-push hooks
- Auto-fix errors without root cause analysis
- Deploy hooks without testing in sandbox environment
- Ignore hook failures (fail fast, not silent)

**ALWAYS**:
- Validate input before processing (schema validation)
- Implement circuit breakers for external dependencies
- Document hook side effects and preconditions
- Provide escape hatches (--no-verify with justification)
- Version hook configurations with rollback capability

**Evidence-Based Techniques for Automation**:
- **Step-by-Step**: Decompose complex automation into atomic steps
- **Verification**: After each hook action, verify expected state
- **Self-Consistency**: Run same validation logic across all hooks
- **Adversarial Prompting**: Test hooks with malformed inputs


## Overview

This directory contains automation scripts, configuration templates, and utilities for comprehensive GitHub project management with AI swarm coordination.

## Contents

### Scripts (`scripts/`)

Automation scripts for intelligent project management:

- **project-board-automation.js** - Automated board synchronization, card management, and smart workflows
- **issue-tracker.js** - Intelligent issue triage, decomposition, and swarm coordination
- **sprint-planner.js** - Sprint planning, velocity tracking, and burndown analytics
- **milestone-manager.js** - Milestone tracking, dependency resolution, and completion prediction

### Templates (`templates/`)

Configuration templates for project setup:

- **project-config.yaml** - Project board configuration with swarm topology and automation rules
- **issue-template.md** - Standardized issue templates for features, bugs, and swarm tasks
- **sprint-template.json** - Sprint planning templates with capacity planning and metrics

## Quick Start

### 1. Project Board Automation

```bash
# Initialize board with automation
node scripts/project-board-automation.js init \
  --project-id "$PROJECT_ID" \
  --config templates/project-config.yaml
```

### 2. Issue Tracking

```bash
# Automated issue triage
node scripts/issue-tracker.js triage \
  --repo "owner/repo" \
  --auto-label \
  --assign-agents
```

### 3. Sprint Planning

```bash
# Plan new sprint
node scripts/sprint-planner.js create \
  --sprint "Sprint 24" \
  --template templates/sprint-template.json \
  --capacity 40
```

### 4. Milestone Management

```bash
# Track milestone progress
node scripts/milestone-manager.js track \
  --milestone "v2.0 Release" \
  --predict-completion
```

## Configuration

All scripts support configuration via:
- Environment variables
- Configuration files (YAML/JSON)
- Command-line arguments
- GitHub repository settings

## Integration

Scripts integrate with:
- GitHub CLI (`gh`)
- GitHub REST API
- GitHub GraphQL API
- ruv-swarm MCP server
- claude-flow coordination

## Examples

See `../examples/` for complete usage walkthroughs demonstrating:
- Kanban board automation
- Sprint planning workflows
- Cross-repository project coordination

## Documentation

Detailed documentation in `../skill.md` covering:
- API reference
- Configuration options
- Best practices
- Troubleshooting guides


---
*Promise: `<promise>README_VERIX_COMPLIANT</promise>`*
