# Code Quality Violation Report

## Kanitsal Cerceve (Evidential Frame Activation)
Kaynak dogrulama modu etkin.



**Project**: `{{project_name}}`
**Timestamp**: `{{timestamp}}`
**Analyzer**: Connascence Analyzer MCP
**Severity**: `{{severity}}` (HIGH / MEDIUM / LOW)

---

## Violation Summary

**Type**: `{{violation_type}}`
**File**: `{{file_path}}:{{line_number}}`
**Function**: `{{function_name}}`
**Detected By**: `{{agent_name}}` (code-analyzer / reviewer)

### Description

{{violation_description}}

### Metrics

- **Violation Count**: {{count}}
- **Threshold**: {{threshold}}
- **Exceeded By**: {{exceeded_by}} ({{exceeded_pct}}%)

---

## Connascence Classification

**Category**: {{connascence_category}}

- **CoN (Name)**: Variables/functions must have same name
- **CoT (Type)**: Variables must have same type
- **CoM (Meaning)**: Multiple components must agree on meaning of values
- **CoP (Position)**: Order of parameters matters
- **CoA (Algorithm)**: Components must agree on algorithm
- **CoE (Execution)**: Order of execution matters
- **CoV (Value)**: Multiple values must be synchronized
- **CoI (Identity)**: Components must reference same entity

**NASA Safety Limits**:
- Max Parameters: 6 (CoP threshold)
- Max Nesting: 4 levels (complexity limit)
- Max Function Length: 50 lines (maintainability limit)

---

## Code Context

```{{language}}
{{code_snippet}}
```

**Violation Highlighted**:
```{{language}}
{{highlighted_violation}}
```

---

## Impact Analysis

### Maintainability Impact

{{maintainability_impact}}

### Security Impact

{{security_impact}}

### Performance Impact

{{performance_impact}}

---

## Recommended Fix Patterns

### Primary Pattern: {{primary_pattern}}

**Strategy**: {{pattern_strategy}}

**Before**:
```{{language}}
{{before_code}}
```

**After**:
```{{language}}
{{after_code}}
```

**Rationale**: {{fix_rationale}}

### Alternative Patterns

1. **{{alt_pattern_1}}** - {{alt_description_1}}
2. **{{alt_pattern_2}}** - {{alt_description_2}}
3. **{{alt_pattern_3}}** - {{alt_description_3}}

---

## Memory-MCP Storage

**Stored**: `{{storage_timestamp}}`
**Memory Key**: `dogfooding/violations/{{project}}/{{violation_id}}`

### Metadata Tags (WHO/WHEN/PROJECT/WHY)

```json
{
  "who": {
    "agent_name": "{{agent_name}}",
    "agent_category": "code-quality",
    "agent_capabilities": ["connascence-analysis", "code-review"]
  },
  "when": {
    "iso_timestamp": "{{iso_timestamp}}",
    "unix_timestamp": {{unix_timestamp}},
    "readable": "{{readable_timestamp}}"
  },
  "project": "{{project_name}}",
  "why": {
    "intent": "quality-detection",
    "purpose": "Detect code quality violations for automated improvement",
    "phase": "dogfooding-phase-1"
  },
  "violation": {
    "type": "{{violation_type}}",
    "severity": "{{severity}}",
    "file": "{{file_path}}",
    "line": {{line_number}}
  }
}
```

---

## Related Violations

Similar violations found in project:

1. **{{related_1_type}}** - `{{related_1_file}}:{{related_1_line}}` (Similarity: {{similarity_1}}%)
2. **{{related_2_type}}** - `{{related_2_file}}:{{related_2_line}}` (Similarity: {{similarity_2}}%)
3. **{{related_3_type}}** - `{{related_3_file}}:{{related_3_line}}` (Similarity: {{similarity_3}}%)

---

## Vector Search Results

**Query**: "{{vector_query}}"
**Top Pattern Match**: {{best_match_similarity}} similarity

### Best Pattern from Memory-MCP

```json
{
  "pattern_id": "{{pattern_id}}",
  "similarity": {{similarity_score}},
  "success_rate": {{success_rate}},
  "application_count": {{application_count}},
  "last_used": "{{last_used_timestamp}}",
  "transformation": {
    "type": "{{transformation_type}}",
    "strategy": "{{transformation_strategy}}",
    "ast_operations": [
      "{{ast_op_1}}",
      "{{ast_op_2}}",
      "{{ast_op_3}}"
    ]
  }
}
```

---

## Action Items

- [ ] Review violation details and context
- [ ] Evaluate recommended fix patterns
- [ ] Select best transformation strategy
- [ ] Apply fix in sandbox environment
- [ ] Run tests in sandbox (target: 100% pass)
- [ ] Verify no regressions introduced
- [ ] Apply to production with git safety
- [ ] Re-run Connascence Analysis
- [ ] Update Memory-MCP with fix outcome
- [ ] Commit with safety metadata

---

## Safety Checks (MANDATORY)

- [ ] ✅ Test coverage ≥70% for affected code
- [ ] ✅ Sandbox testing completed successfully
- [ ] ✅ Git stash backup created before application
- [ ] ✅ Production tests pass after application
- [ ] ✅ No regressions in related functionality
- [ ] ✅ CI/CD pipeline passes all gates
- [ ] ✅ Automated rollback available if needed

---

## Dashboard & Tracking

**Grafana Dashboard**: http://localhost:3000/d/dogfooding
**SQLite Tracking DB**: `metrics/dogfooding/dogfooding.db`
**Cycle ID**: `{{cycle_id}}` (if part of automated cycle)

---

**Generated By**: Dogfooding System - Quality Detection (Phase 1)
**Skill**: `sop-dogfooding-quality-detection`
**Agents**: code-analyzer, reviewer
**MCP Tools**: connascence-analyzer, memory-mcp

---

*This report is part of the automated self-improvement cycle. Store this in Memory-MCP for future pattern retrieval.*


---
*Promise: `<promise>VIOLATION_REPORT_VERIX_COMPLIANT</promise>`*
