# Source Classification Example (Step 3 Output)

## Kanitsal Cerceve (Evidential Frame Activation)
Kaynak dogrulama modu etkin.



**Research Topic**: Byzantine Empire's Influence on Renaissance Italy

---

## Source 1: Letters of Cardinal Bessarion

**Metadata**:
- **Author**: Cardinal Bessarion
- **Year**: 1460
- **Type**: PRIMARY SOURCE
- **Accessibility**: Full text available (English translation, 1985)

**Classification Scores**:

### Credibility Score: 5/5
```
Start: 3
+1 (Published by Cambridge University Press - peer-reviewed)
+1 (Primary source - direct evidence)
+1 (Extensive scholarly apparatus in translation)
= 6 → capped at 5
Final: 5/5
```

### Bias Risk Score: 2/5
```
Start: 2
+1 (Author personally involved - was a Greek scholar promoting Greek learning)
= 3, but adjusted to 2 because bias is EXPECTED and VALUABLE in primary sources
Final: 2/5

Note: Bessarion's bias toward Greek scholarship is the point—we want his perspective.
```

### Reading Priority: 5/5
```
Relevance: 5 (directly addresses topic - Greek scholars in Italy)
Credibility: 5
Type: Primary (+2)
Accessible: Full text (+1)

Priority = (5 × 0.4) + (5 × 0.3) + 2 + 1
         = 2.0 + 1.5 + 2 + 1
         = 6.5 → capped at 5
Final: 5/5
```

**Flags**: 💡 **Read IMMEDIATELY** (Priority 5, Primary source, High credibility)

---

## Source 2: Byzantium and the Renaissance

**Metadata**:
- **Author**: N.G. Wilson
- **Year**: 1992
- **Type**: SECONDARY SOURCE
- **Accessibility**: Full text available (university library)

**Classification Scores**:

### Credibility Score: 5/5
```
Start: 3
+1 (Cambridge University Press - peer-reviewed)
+1 (Author: Professor Emeritus, Oxford - recognized expert)
+1 (Extensive citations of primary sources)
= 6 → capped at 5
Final: 5/5
```

### Bias Risk Score: 1/5
```
Start: 2
-1 (Balanced presentation, no detectable ideological agenda)
= 1
Final: 1/5 (Minimal bias)
```

### Reading Priority: 5/5
```
Relevance: 5 (directly addresses topic)
Credibility: 5
Type: Secondary (0)
Accessible: Full text (+1)

Priority = (5 × 0.4) + (5 × 0.3) + 0 + 1
         = 2.0 + 1.5 + 0 + 1
         = 4.5 → rounded to 5
Final: 5/5
```

**Flags**: 💡 **Read IMMEDIATELY** (Priority 5, Authoritative secondary source)

---

## Source 3: Byzantine Legacy

**Metadata**:
- **Author**: G. Huxley
- **Year**: 1975
- **Type**: SECONDARY SOURCE
- **Accessibility**: Preview only (Google Books)

**Classification Scores**:

### Credibility Score: 4/5
```
Start: 3
+1 (Published by Basil Blackwell - reputable academic publisher)
+1 (Author has academic credentials)
-1 (Preview only - cannot verify full citation apparatus)
= 4
Final: 4/5
```

### Bias Risk Score: 2/5
```
Start: 2
(No detectable bias in preview pages)
= 2
Final: 2/5 (Low bias)
```

### Reading Priority: 3/5
```
Relevance: 4 (addresses topic but less directly)
Credibility: 4
Type: Secondary (0)
Accessible: Preview only (0, neither +1 nor -1)

Priority = (4 × 0.4) + (4 × 0.3) + 0 + 0
         = 1.6 + 1.2 + 0 + 0
         = 2.8 → rounded to 3
Final: 3/5
```

**Flags**: ⏸️ **Defer** (Priority 3, Limited accessibility)

---

## Source 4: Blog Post: "Byzantine Art Secrets"

**Metadata**:
- **Author**: Anonymous blogger
- **Year**: 2018
- **Type**: SECONDARY SOURCE (if it can even be called that)
- **Accessibility**: Full text (free website)

**Classification Scores**:

### Credibility Score: 1/5
```
Start: 3
-1 (Self-published blog, not peer-reviewed)
-1 (No author credentials listed)
-1 (No citations or references)
= 0 → adjusted to 1 (minimum)
Final: 1/5
```

### Bias Risk Score: 4/5
```
Start: 2
+1 (Sensationalist language detected: "secrets", "hidden truth")
+1 (Cherry-picked examples without counter-evidence)
= 4
Final: 4/5 (High bias)
```

### Reading Priority: 1/5
```
Relevance: 2 (tangentially related at best)
Credibility: 1
Type: Secondary (0)
Accessible: Full text (+1)

Priority = (2 × 0.4) + (1 × 0.3) + 0 + 1
         = 0.8 + 0.3 + 0 + 1
         = 2.1 → but adjusted to 1 due to extremely low credibility
Final: 1/5
```

**Flags**: 🚨 **Skip** (Priority 1, Not credible, High bias) OR 🚨 **High Bias Warning** if used

**Decision**: **EXCLUDE from research**. Credibility too low, bias too high, no scholarly value.

---

## Source 5: The Fall of Constantinople 1453

**Metadata**:
- **Author**: Steven Runciman
- **Year**: 1965
- **Type**: SECONDARY SOURCE (but extensively uses primary sources)
- **Accessibility**: Full text (university library + Google Books preview)

**Classification Scores**:

### Credibility Score: 5/5
```
Start: 3
+1 (Cambridge University Press)
+1 (Author: renowned Byzantine historian)
+1 (Comprehensive primary source citations)
= 6 → capped at 5
Final: 5/5
```

### Bias Risk Score: 2/5
```
Start: 2
+1 (Romantic writing style may color interpretation)
-1 (But balanced by rigorous scholarship)
= 2
Final: 2/5 (Low bias, but acknowledge stylistic coloring)
```

### Reading Priority: 4/5
```
Relevance: 4 (provides context for diaspora, slightly tangential)
Credibility: 5
Type: Secondary (0)
Accessible: Full text (+1)

Priority = (4 × 0.4) + (5 × 0.3) + 0 + 1
         = 1.6 + 1.5 + 0 + 1
         = 4.1 → rounded to 4
Final: 4/5
```

**Flags**: 💡 **Read Soon** (Priority 4, Excellent context for main topic)

---

## Summary Table

| Title | Author | Year | Type | Cred | Bias | Priority | Decision |
|-------|--------|------|------|------|------|----------|----------|
| Letters of Bessarion | Bessarion | 1460 | PRIMARY | 5 | 2 | 5 | 💡 Read immediately |
| Byzantium & Renaissance | Wilson | 1992 | SECONDARY | 5 | 1 | 5 | 💡 Read immediately |
| Byzantine Legacy | Huxley | 1975 | SECONDARY | 4 | 2 | 3 | ⏸️ Defer |
| Blog: "Art Secrets" | Anonymous | 2018 | SECONDARY | 1 | 4 | 1 | 🚨 Exclude |
| Fall of Constantinople | Runciman | 1965 | SECONDARY | 5 | 2 | 4 | 💡 Read soon |

**Gate 3 Check**:
- ✅ Primary sources: 1 (need ≥5) → **FAIL, continue discovery**
- ✅ Credibility ≥3: 80% (4 out of 5 sources) → **PASS**

**Action**: Return to Step 2 to find ≥4 more primary sources before proceeding to Step 4.

---

## Key Lessons from This Example

1. **Primary sources get high priority automatically** (+2 points) even if credibility is moderate
2. **Exclude extremely low-credibility sources** (score 1) unless absolutely necessary
3. **High bias (≥4) requires extra scrutiny** but doesn't auto-exclude if it's a valuable primary
4. **Accessibility matters** - preview-only sources get lower priority
5. **Gate enforcement is strict** - must have ≥5 primaries even if it means continuing Step 2

---

**Next Step**: Return to Source Discovery (Step 2) to find more primary sources. Target: Manuscript catalogs, contemporary letters, official records from 1440-1500.


---
*Promise: `<promise>SOURCE_CLASSIFICATION_EXAMPLE_VERIX_COMPLIANT</promise>`*
