# Red's Research Methodology (OSP)

## Kanitsal Cerceve (Evidential Frame Activation)
Kaynak dogrulama modu etkin.



Source: Overly Sarcastic Productions - "How to Do Research" YouTube video

## Core Philosophy

Red's methodology emphasizes **rigorous source evaluation**, **contextual understanding**, and **evidence-based thesis formation**. The approach counters common pitfalls like circular reasoning, confirmation bias, and over-reliance on secondary sources.

---

## The Six Principles

### 1. "Trust No One"

**Meaning**: Question ALL sources, understand their biases, verify their claims.

**Why It Matters**:
- Every source has perspective/bias (even academic ones)
- Authors have agendas, funding pressures, ideological leanings
- What's omitted is as important as what's included

**Implementation in Workflow**:
- **Step 3**: Systematic credibility + bias scoring for EVERY source
- Explicit bias risk calculation (1-5 scale)
- Flag high-bias sources (≥4) for extra scrutiny
- Require multiple sources to corroborate major claims

**Example**: A Renaissance art history book funded by the Medici Bank might emphasize Medici patronage while downplaying other patrons' contributions.

---

### 2. "Context is Everything"

**Meaning**: Sources must be understood within their historical, cultural, and scholarly context.

**Why It Matters**:
- A source from 1850 has different assumptions than one from 2020
- Cultural background shapes what authors see as important
- Scholarly debates evolve; older sources may reflect outdated paradigms

**Implementation in Workflow**:
- **Step 4**: Mandatory contextual analysis for all major sources
- **Temporal Context**: When written? What events influenced author?
- **Cultural Context**: Author's background? Intended audience?
- **Historiographical Context**: Which scholarly tradition/debate?

**Example**: A 1960s source on Byzantine history written during Cold War might emphasize East-West tensions more than pre-WWI sources would.

---

### 3. "Thesis from Evidence" (NOT Evidence from Thesis)

**Meaning**: Let your conclusion EMERGE from the evidence you gather. Don't start with a thesis and cherry-pick evidence to support it.

**Why It Matters**:
- Starting with conclusion = confirmation bias
- Real research follows evidence wherever it leads
- Sometimes evidence doesn't support your initial hypothesis—that's valuable!

**Implementation in Workflow**:
- **Step 6 Phase B**: Explicit instruction to let thesis EMERGE
- "INCONCLUSIVE" option if evidence insufficient/contradictory
- Require listing counter-evidence and alternative interpretations
- Analyst validation checks for cherry-picking

**Red's Warning**: "If you start with your conclusion and work backwards, you're not doing research—you're writing fiction with footnotes."

---

### 4. "Wikipedia is a Gateway, Not a Destination"

**Meaning**: Use Wikipedia to find sources, not as a source itself.

**Why It Matters**:
- Wikipedia articles can change, have biases, or be incomplete
- Real value is in the **References section**—that's where actual sources are
- Wikipedia curates a starting point, not an ending point

**Implementation in Workflow**:
- **Step 1**: Mine Wikipedia's References + Further Reading sections
- Extract citations with complete metadata
- Use these as jumping-off points for deeper research
- **Gate 0**: Fallback to Google Scholar if no Wikipedia article exists

**Red's Tip**: "The References section is a goldmine. It's like having a librarian pre-select 20-50 relevant sources for you."

---

### 5. "Primary Sources Matter"

**Meaning**: Prioritize original documents and eyewitness accounts over later analyses.

**Why It Matters**:
- Secondary sources can misinterpret primaries
- Going to original lets YOU evaluate the evidence
- Closer to events = generally more reliable details

**Implementation in Workflow**:
- **Step 3**: Classify ALL sources as primary vs secondary
- Priority scoring gives +2 points to primary sources
- **Gate 3**: Require ≥5 primary sources (or document exception)
- **Gate 6**: Final report must cite ≥2 primary sources

**When Primaries Aren't Available**:
- Ancient history often has NO surviving primary sources
- In this case: Use ≥10 high-credibility secondaries (≥4 score)
- **Document this limitation** explicitly in final report

**Example**: For Byzantine trade routes, a 12th-century merchant's ledger (primary) > a 2020 textbook chapter analyzing trade (secondary).

---

### 6. "Page Numbers Save Lives"

**Meaning**: ALWAYS record page numbers when taking notes and quoting sources.

**Why It Matters**:
- Verifiability: Others can check your sources
- Re-finding: You can locate quotes again months later
- Academic integrity: Proper citation prevents plagiarism
- Fact-checking: When claims conflict, you can go back to exact pages

**Implementation in Workflow**:
- **Step 5**: Template REQUIRES page numbers for ALL quotes and claims
- Note structure: "Claim 1 (page 42): [quote]"
- **Gate 5**: Requires ≥20 quotes WITH page numbers
- **Step 6 Phase C**: Analyst verifies EVERY claim has page citation

**Red's Warning**: "Future you will curse past you if you write 'somewhere in Chapter 3' instead of 'page 87.'"

---

## The Research Workflow (Red's 6 Phases)

### Phase 1: Wikipedia Mining (Gateway)
- Start with Wikipedia article on your topic
- DON'T use Wikipedia as final source
- Mine the References and Further Reading sections
- Extract 10+ citations as starting points

### Phase 2: Source Hunting (Expansion)
- Use Wikipedia citations to find actual sources
- Search library catalogs (WorldCat)
- Use Google Books for previews
- Follow "Cited by" chains on Google Scholar
- Aim for 20+ sources

### Phase 3: Primary vs Secondary Classification (Validation)
- For EACH source: Is it primary (from the time) or secondary (analysis)?
- Prioritize primaries when available
- Evaluate credibility: Who's the author? What's their expertise?
- Assess bias: Funding? Ideology? Conflicts of interest?

### Phase 4: Contextual Analysis (Deep Dive)
- **When was this written?** What was happening then?
- **Who wrote it?** Cultural background? Audience?
- **What scholarly debate does this fit into?** Mainstream? Controversial?
- **If translated:** How reputable is the translation?

### Phase 5: Comprehensive Note-Taking (Capture)
- Read sources in priority order
- Take detailed notes with **page numbers**
- Capture key claims, supporting evidence, quotable passages
- Note contradictions between sources
- Identify author's biases/agenda

### Phase 6: Synthesis & Dot Connecting (Integration)
- Look for patterns across sources
- Find agreements (corroboration)
- Find disagreements (need to adjudicate)
- **Let thesis EMERGE from evidence**
- List counter-evidence honestly
- Acknowledge limitations of available sources

---

## Common Pitfalls Red Warns Against

### 1. Circular Reasoning
**Problem**: Using Source A to support Claim X, then using Claim X to validate Source A.
**Solution**: Independent corroboration from multiple sources.

### 2. Confirmation Bias
**Problem**: Only reading sources that support your pre-existing conclusion.
**Solution**: Actively seek contradictory sources and engage with them fairly.

### 3. Over-Reliance on Secondary Sources
**Problem**: Building analysis entirely on other people's interpretations.
**Solution**: Go to primary sources whenever possible; evaluate evidence yourself.

### 4. Ignoring Context
**Problem**: Reading 1890s source with 2020s assumptions.
**Solution**: Mandatory contextual analysis (Step 4 of this workflow).

### 5. Cherry-Picking Evidence
**Problem**: Only citing sources that agree with your thesis.
**Solution**: Step 6 Phase C analyst validation checks for this explicitly.

### 6. Assuming Sources Are Neutral
**Problem**: Treating all published sources as objective truth.
**Solution**: "Trust No One" principle—bias scoring for ALL sources.

---

## How This Workflow Embeds Red's Principles

| Red's Principle | Workflow Implementation |
|----------------|-------------------------|
| **Trust No One** | Step 3: Credibility + Bias scoring for ALL sources (1-5 scales) |
| **Context is Everything** | Step 4: Temporal/Cultural/Historiographical context required |
| **Thesis from Evidence** | Step 6: "Let thesis EMERGE" + "INCONCLUSIVE" option |
| **Wikipedia is Gateway** | Step 1: Mine references only. Gate 0 provides Google Scholar fallback |
| **Primary Sources Matter** | Step 3: Classify all sources. Gate 3 & 6 require ≥2-5 primaries |
| **Page Numbers Save Lives** | Step 5: Template requires pages. Gate 5 enforces ≥20 quotes with pages |

---

## Red's Final Advice

> "Research isn't about being the smartest person in the room. It's about being the most thorough. It's about checking your assumptions, questioning your sources, and being honest when the evidence doesn't support your thesis. If you do that, you're already ahead of 90% of people on the internet."

> "Good research takes time. If you're not spending at least a few hours on this, you're probably not doing it right. Wikipedia is a great place to START, but it's a terrible place to STOP."

> "Remember: The goal isn't to prove you're right. The goal is to find out what's TRUE."

---

**Note**: This methodology is optimized for general-purpose research (history, mythology, literature). For academic ML research, use the `literature-synthesis` or `deep-research-orchestrator` skills instead, which implement PRISMA-compliant systematic review methodologies.


---
*Promise: `<promise>RED_METHODOLOGY_VERIX_COMPLIANT</promise>`*
