# Source Credibility Analyzer Skill

## Kanitsal Cerceve (Evidential Frame Activation)
Kaynak dogrulama modu etkin.



**Version**: 2.0 (Production-Ready)
**Created**: 2025-01-06
**Methodology**: Skill-Forge 7-Phase Process + Prompt-Architect Optimization

---

## What This Skill Does

Automates evaluation of research sources using transparent **program-of-thought scoring rubrics**. Outputs credibility (1-5), bias (1-5), and priority (1-5) scores with explanations showing calculation logic. Reduces manual source evaluation from 30-60 minutes to 5-15 minutes per source.

**Duration**: 5-15 minutes per source (vs 30-60 min manual)
**Agent**: analyst
**Quality Gates**: 5 (Gates 0 → 0.5 → 1 → 2 → 3 → 4 → 5)

---

## Skill Structure

```
source-credibility-analyzer/
├── SKILL.md                                    # Main skill file (core SOP)
├── README.md                                   # This file
├── source-credibility-analyzer-process.dot     # GraphViz process visualization
└── examples/
    └── scoring-examples.md                     # 5 complete end-to-end examples
```

---

## When to Use This Skill

**✅ USE FOR**:
- Evaluating research sources for academic projects
- Automating general-research-workflow Step 3 (Source Classification)
- Scoring large batches of sources consistently
- Getting objective second opinion on source quality

**❌ DO NOT USE FOR**:
- Entertainment content (movies, novels) - not designed for this
- Source quality already obvious (Nature paper = high, random blog = low)
- Unique/irreplaceable source (only source on obscure topic) - read anyway

**Decision Tree**: If manual source evaluation takes >10 min → use this tool (saves 15-45 min per source)

---

## Key Features

### 1. Program-of-Thought Rubrics

**Core Innovation**: Explicit calculations make scoring transparent, auditable, and reproducible.

**Example Credibility Calculation**:
```
Source: Academic textbook by PhD author
Baseline: 4 (ACADEMIC category)
+1 (Published by MIT Press)
+1 (Author has PhD + expertise)
+1 (15,000 citations)
= 7 → capped at 5
Final Credibility: 5/5
```

**Why This Matters**:
- Agents reproduce scoring consistently
- Users can verify logic and adjust rubrics
- No subjective "I think this is good" judgments

### 2. Edge Case Handling

**5 Source Categories with Tailored Baselines**:
| Category | Examples | Baseline | Notes |
|----------|----------|----------|-------|
| **ACADEMIC** | Peer-reviewed journals, academic books | 4 | Standard rubric |
| **INSTITUTIONAL** | Government reports, white papers | 3 | Check funding source |
| **GENERAL** | Wikipedia, reputable news, expert blogs | 3 | Verify against other sources |
| **PREPRINTS** | arXiv, bioRxiv, SSRN | 3 | Not peer-reviewed, verify claims |
| **UNVERIFIED** | Personal blogs, social media | 2 | Use with extreme caution |

**Special Cases**:
- **Wikipedia**: Credibility 3, Bias 5 (NPOV), Priority 2 (background only)
- **Preprints**: Credibility 3, Bias 4, Priority = depends (cutting-edge but unverified)
- **Gray Literature**: Credibility 3-4, check funding source carefully

### 3. Conflict Resolution Logic

**Handles conflicting scores** (e.g., High Credibility + High Bias):

| Scenario | Example | Resolution |
|----------|---------|------------|
| High Cred + High Bias | Pharma-funded study in peer-reviewed journal | VERIFY_CLAIMS (read critically) |
| Low Cred + Low Bias | Anonymous blog with balanced presentation | SKIP (find authoritative alternative) |
| High Priority + Low Cred | Preprint on cutting-edge topic | VERIFY_CLAIMS (read but verify) |
| High Cred + Low Priority | Tangential textbook | READ_LATER (background material) |

### 4. Borderline Score Rounding

**Transparent rounding policy** for X.5 scores:
- **Credibility**: Round DOWN (conservative) - 2.5 → 2, 3.5 → 3
- **Bias**: Round UP (benefit of doubt) - 2.5 → 3, 3.5 → 4
- **Priority**: Round UP (favor reading when uncertain) - 2.5 → 3, 3.5 → 4

### 5. Structured JSON Output

**Machine-readable output** for integration:
```json
{
  "scores": {
    "credibility": {"score": 5, "explanation": "..."},
    "bias": {"score": 5, "explanation": "..."},
    "priority": {"score": 5, "explanation": "..."}
  },
  "recommendation": {
    "action": "READ_FIRST | READ_LATER | VERIFY_CLAIMS | SKIP",
    "reason": "...",
    "conflicts": "..."
  }
}
```

---

## How It Was Built

### Design Process (Skill-Forge 7 Phases)

1. **Intent Archaeology** ✅
   - Extracted scoring rubrics from general-research-workflow Step 3
   - Identified need for standalone tool to automate manual scoring
   - Analyzed program-of-thought pattern for transparent calculations

2. **Use Case Crystallization** ✅
   - Example: Scoring 20 sources for literature review (manual: 10 hours → tool: 2-5 hours)
   - Pattern: Input metadata → Apply rubrics → Output scores + recommendation

3. **Structural Architecture** ✅
   - SKILL.md: Core SOP workflow (Steps 0 → 5)
   - Examples: 5 complete scoring scenarios covering all categories
   - Process diagram: Visual workflow with decision trees

4. **Metadata Engineering** ✅
   - Name: `source-credibility-analyzer`
   - Description optimized for discovery (program-of-thought, scoring rubrics, automate source evaluation)
   - Trigger conditions explicit (5-15 min vs 30-60 min manual)

5. **Instruction Crafting** ✅
   - Program-of-thought rubrics with explicit calculations
   - Visual markers (✅ Required, ⚠️ Optional, 💡 Tip, 🚨 Warning)
   - Quality Gates with GO/NO-GO criteria
   - Borderline rounding policy

6. **Resource Development** ✅
   - **Process diagram**: `source-credibility-analyzer-process.dot` (GraphViz with semantic shapes)
   - **Examples**: 5 complete scenarios (academic paper, think tank, preprint, Wikipedia, blog)
   - Each example: Input → Calculations → Output → Explanation

7. **Validation** ✅
   - Prompt-architect analysis identified 10 gaps
   - v2 implemented all Priority 1 improvements:
     - 5 complete few-shot examples
     - Edge case decision tree (5 categories)
     - Conflict resolution logic (4 conflict types)
     - Visual markers (✅⚠️💡🚨)
     - Borderline score rounding policy

---

## Optimization History

### Version 1 → Version 2 (Prompt-Architect Optimized)

**Added** (Priority 1 Critical):
- **Step 0.5**: Edge case classification (ACADEMIC, INSTITUTIONAL, GENERAL, PREPRINTS, UNVERIFIED)
- **5 Complete Examples**: Academic paper, think tank, preprint, Wikipedia, blog (examples/scoring-examples.md)
- **Conflict Resolution**: Matrix + 4 conflict type handlers (Step 4)
- **Visual Markers**: ✅ Required, ⚠️ Optional, 💡 Tip, 🚨 Warning throughout
- **Borderline Rounding**: Conservative for credibility (round down), benefit of doubt for bias/priority (round up)

**Improved**:
- Credibility rubric: Explicit baselines by category (4 for ACADEMIC, 3 for GENERAL, 2 for UNVERIFIED)
- Bias rubric: Special baselines for primary sources (5) and opinion pieces (2)
- Priority rubric: Auto-penalty if credibility <3 or bias <3
- Error handling: Expanded to cover conflicting scores, borderline cases, ambiguous categories

**Graded**:
- v1: B+ (73%) - Strong foundation, missing examples and edge cases
- v2: A (88%) - Production-ready with comprehensive coverage

---

## Success Metrics

### Quantitative
- ✅ All 3 scores calculated (credibility, bias, priority)
- ✅ All scores valid range (1-5)
- ✅ Explanations show calculations
- ✅ Recommendation matches decision matrix
- ✅ Execution time 5-15 min per source (vs 30-60 min manual)
- ✅ Output stored in Memory MCP

### Qualitative
- ✅ Scores match manual scoring within ±1 point (self-consistency)
- ✅ Explanations clearly justify scores with explicit rules
- ✅ Recommendation is actionable (READ_FIRST vs SKIP)
- ✅ Edge cases handled (Wikipedia, preprints, gray literature)
- ✅ Conflicts resolved transparently

---

## Integration with Other Skills

**Before This Skill**:
- Use `general-research-workflow` Steps 1-2 to discover sources via search tools
- Collect metadata (title, author, year, venue, citations)

**During This Skill**:
- Single analyst agent evaluates source using program-of-thought rubrics
- Outputs structured JSON with scores + recommendation
- Stores in Memory MCP with tags for retrieval

**After This Skill**:
- Use `general-research-workflow` Step 4 to create reading plan based on priority scores
- Use `academic-reading-workflow` to annotate high-priority sources (priority ≥4)
- Search Memory MCP for previously scored sources to avoid re-evaluation

**Standalone Usage**:
```bash
# Direct invocation
Skill("source-credibility-analyzer") + {
  "title": "...",
  "author": "...",
  "year": 2020,
  "venue": "...",
  "type": "journal article"
}
```

---

## Example Workflow Execution

```
Source: "Attention Is All You Need" by Vaswani et al. (NeurIPS 2017)

Step 0 (30 sec):
- Validated metadata: All required fields present
- Optional fields: 95,000 citations, DOI present

Step 0.5 (1 min):
- Category: ACADEMIC (peer-reviewed NeurIPS conference)
- Credibility Baseline: 4

Step 1 (3 min):
- Credibility calculation:
  Baseline 4, +1 peer-reviewed, +1 PhD authors, +1 95k citations, +1 DOI = 8 → capped at 5
- Final: 5/5

Step 2 (2 min):
- Bias calculation:
  Baseline 3, +1 peer-reviewed, +1 transparent, +1 no conflicts = 6 → capped at 5
- Final: 5/5

Step 3 (2 min):
- Priority calculation:
  Baseline 3, +1 seminal work, +1 relevant, +1 95k citations, +1 primary source = 7 → capped at 5
- Final: 5/5

Step 4 (1 min):
- Conflict check: No conflicts (all scores optimal)
- Recommendation: READ_FIRST

Step 5 (1 min):
- Generated JSON output
- Stored in Memory MCP with tags

Output: Credibility 5, Bias 5, Priority 5 → READ_FIRST
Total Time: 9 minutes (vs 30-60 min manual)
```

---

## Files Created

1. **C:\Users\17175\skills\source-credibility-analyzer\SKILL.md** (8,500 words)
   - Main skill file with complete SOP
   - 6 sequential steps (0 → 5) with 5 Quality Gates
   - Program-of-thought rubrics for credibility, bias, priority
   - Edge case handling + conflict resolution

2. **C:\Users\17175\skills\source-credibility-analyzer\source-credibility-analyzer-process.dot**
   - GraphViz workflow visualization
   - Shows all steps, gates, decision points
   - Semantic shapes (ellipse=start/end, diamond=decisions, octagon=gates)

3. **C:\Users\17175\skills\source-credibility-analyzer\examples\scoring-examples.md** (6,000 words)
   - 5 complete end-to-end examples
   - ✅ Academic paper (ideal source)
   - ✅ Think tank report (high bias)
   - ⚠️ Preprint (ambiguous credibility)
   - ⚠️ Wikipedia (background material)
   - ❌ Blog post (low quality)
   - Each: Input → Calculations → Output JSON → Explanation

---

## Companion Skills

**Used With**:
- `general-research-workflow` - Automates Step 3 (Source Classification)
- `academic-reading-workflow` - Prioritizes which sources to annotate deeply

**Not Yet Built** (Future):
- `citation-extraction-automation` - Auto-fetch citation counts from Google Scholar API
- `batch-source-scoring` - Score multiple sources in parallel

---

## Design Comparison

| Aspect | v1 Draft | v2 Optimized |
|--------|----------|--------------|
| Examples | 0 | 5 complete scenarios |
| Edge Cases | 0 | 5 categories with baselines |
| Conflict Resolution | None | Matrix + 4 handlers |
| Visual Markers | None | ✅⚠️💡🚨 systematic |
| Borderline Rounding | Unspecified | Explicit policy (conservative/benefit of doubt) |
| Failure Modes | 5 covered | 9 covered (added conflicting scores, borderline, ambiguous category) |

---

## Next Steps

This is **Skill 3 of 3** from Priority 1 of MECE gap analysis.

**✅ Priority 1 COMPLETE** (3 of 3 skills):
1. ✅ general-research-workflow (Red's methodology)
2. ✅ academic-reading-workflow (Blue's methodology)
3. ✅ source-credibility-analyzer (Standalone scoring tool)

**Remaining Priority 2 Skills** (3 skills):
- **digital-annotation-system** - Enhanced annotation tools (Hypothesis, Zotero integration)
- **research-milestone-planner** - Project scheduling and milestone tracking
- **wikipedia-citation-extractor** - Automated Wikipedia reference mining

**Remaining Priority 3 Skills** (3 skills):
- **argumentation-validator** - Detect logical fallacies
- **auto-summary-generator** - Create reading roadmaps automatically
- **voice-to-text-drafting** - Natural idea capture

---

## Credits

**Methodology Source**: Extracted from general-research-workflow Step 3 (program-of-thought scoring rubrics)
**Design Framework**: Skill-Forge 7-Phase Process
**Optimization**: Prompt-Architect evidence-based analysis (v1 B+ → v2 A)
**Implementation**: 2-iteration refinement (v1 Draft → v2 Optimized)

---

**Production Status**: ✅ READY FOR USE
**Last Updated**: 2025-01-06
**Version**: 2.0 (Optimized)


---
*Promise: `<promise>README_VERIX_COMPLIANT</promise>`*
