# Google-Apps-Script - Getting Started

**Pages:** 25

---

## Apps Script Sunset Schedule Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/guides/support/sunset

**Contents:**
- Apps Script Sunset Schedule Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways

Apps Script features are marked as deprecated before they are shut down, allowing time for migration to supported alternatives.

Deprecated features remain available until their sunset date, after which they cease to function or become unavailable.

Developers should upgrade existing scripts to use supported features during the deprecation period to avoid disruptions.

Google provides migration guides and resources to help developers transition away from deprecated features.

The table above lists deprecated Apps Script features, their deprecation and sunset dates, and the expected behavior after sunset.

Once a sunset date for an Apps Script feature has been announced, the feature is considered deprecated, but should still be available for use until the sunset date. During the deprecation period, we encourage you to upgrade existing scripts to use supported features.

---

## Automation quickstart Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/quickstart/automation

**Contents:**
- Automation quickstart Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
- Objectives
- Prerequisites
- Set up the script
- Run the script
- Next steps

This guide helps you build and run an automation that creates a Google Docs document and emails you a link to it.

To use this sample, you need a Google Account and a web browser with internet access.

The setup involves opening the Apps Script editor, creating a new project, pasting in the provided code, saving, and naming the script.

Running the script requires clicking run, authorizing it when prompted, and then checking your Gmail inbox for the email containing the document link.

Build and run a simple automation that creates a Google Docs document and emails you a link to the document.

To use this sample, you need the following prerequisites:

To build the automation, take the following steps:

Delete any code in the script editor and paste in the code below.

Click Untitled project.

Enter a name for your script and click Rename.

To run the script, take the following steps:

When prompted, authorize the script. If the OAuth consent screen displays the warning, This app isn't verified, continue by selecting Advanced > Go to {Project Name} (unsafe).

When the script execution completes, check your Gmail inbox for the email.

Open the email and click the link to open the document that you created.

---

## Build a Google Chat app with Google Apps Script Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/quickstart/chat-bot

**Contents:**
- Build a Google Chat app with Google Apps Script Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
- Objectives
- Prerequisites
- Set up your environment
  - Open your Cloud project in the Google Cloud console
  - Turn on the Chat API
  - Configure the OAuth consent screen
- Set up the script
  - Create the script from the template

Create a Google Chat app that echoes user messages using Apps Script and Google Cloud.

This involves setting up your environment, configuring the script, publishing the app, and testing its functionality.

Prerequisites include a Google Workspace account and a Google Cloud project.

The app is designed to receive direct messages and participate in spaces, integrating with various Google services as needed.

You can find troubleshooting information and cleanup instructions in the provided documentation.

Note: This guide explains how to build an interactive Chat app using Chat API interaction events. You can also build your Chat app as a Google Workspace add-on. To learn about which framework to use, see Build an interactive Google Chat app.

Note: This guide explains how to build an interactive Chat app using Chat API interaction events. You can also build your Chat app as a Google Workspace add-on. To learn about which framework to use, see Build an interactive Google Chat app.

Create a Google Chat app that you can directly message and that responds by echoing your messages.

The following diagram shows the architecture and messaging pattern:

In the preceding diagram, a user interacting with an Apps Script Chat app has the following flow of information:

If it's not open already, open the Cloud project that you intend to use for this sample:

Select a Cloud project

In the Google Cloud console, enable the Google Chat API.

All apps using OAuth 2.0 require a consent screen configuration. Configuring your app's OAuth consent screen defines what is displayed to users and app reviewers, and registers your app so you can publish it later.

To set up the script, you use a template and then set your Cloud project in Apps Script.

Go to IAM & Admin Settings

You now have working app code that you can try out (as described in the following steps) and then customize to meet your requirements.

Make sure that you're signed in to the correct Google Account when you open the Apps Script template. The current account can sometimes switch to your default account without you noticing.

You need a deployment ID for this Apps Script project, so that you can use it in the next step.

To get the head deployment ID, do the following:

Publish the Chat app from the console.

Click Configuration and set up the Chat app:

The Chat app is ready to respond to messages.

To test your Chat app, open a direct message space with the Chat app and send a message:

Open Google Chat using the Google Workspace account that you provided when you added yourself as a trusted tester.

Select your Chat app from the results. A direct message opens.

In the new direct message with the app, type Hello and press enter.

The Chat app thanks you for adding it and echoes your message.

To add trusted testers and learn more about testing interactive features, see Test interactive features for Google Chat apps.

When a Google Chat app or card returns an error, the Chat interface surfaces a message saying "Something went wrong." or "Unable to process your request." Sometimes the Chat UI doesn't display any error message, but the Chat app or card produces an unexpected result; for example, a card message might not appear.

Although an error message might not display in the Chat UI, descriptive error messages and log data are available to help you fix errors when error logging for Chat apps is turned on. For help viewing, debugging, and fixing errors, see Troubleshoot and fix Google Chat errors.

To avoid incurring charges to your Google Cloud account for the resources used in this tutorial, we recommend that you delete the Cloud project.

Caution: Deleting a project has the following effects:

If you plan to explore multiple tutorials and quickstarts, reusing projects can help you avoid exceeding project quota limits.

Go to Resource Manager

---

## Built-in Google Services Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/guides/services

**Contents:**
- Built-in Google Services Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
- Modern JavaScript features
- Using autocomplete
- Understanding global objects
- Calling methods
- Accessing child classes
- Dealing with interfaces
- Working with enums

Google Apps Script offers over 30 built-in services for interacting with user data, other Google systems, and external systems, provided as global objects.

Google Apps Script supports both the modern V8 and older Rhino JavaScript runtimes, with the V8 runtime being strongly recommended for its support of modern ECMAScript features.

The script editor provides an autocomplete feature that assists in identifying valid global objects, methods, and enums within the script's current context.

Services are accessed through global objects, and methods can be called on these objects to perform actions or retrieve data, with the ability to chain method calls when they return other Apps Script classes.

Child classes cannot be accessed directly but must be accessed by calling a method that returns an instance of that class, and some services use "interface" classes to represent generic types that can be cast to a precise class.

Google Apps Script provides more than 30 built-in services for interacting with user data, other Google systems, and external systems. These services are provided as global objects akin to JavaScript's standard Math object. For example, just as Math offers methods like random() and constants like PI, Apps Script's Spreadsheet service offers methods like openById(id), classes (child objects) like Range, and enums like DataValidationCriteria.

The reference documentation for services that control Google Workspace products are collected in the "Google Workspace Services" section under the "Reference" header in the sidebar of this site. Utility services (for things like creating user interfaces, parsing XML, or writing log data) are collected in the "Script Services" section.

Apps Script supports two JavaScript runtimes: the modern V8 runtime and an older one powered by Mozilla's Rhino JavaScript interpreter.

The V8 runtime supports modern ECMAScript syntax and features. The Rhino runtime is based on the older JavaScript 1.6 standard, plus a few features from 1.7 and 1.8. You can freely choose which runtime to use with your script, but the V8 runtime is strongly recommended.

Each runtime supports JavaScript classes and objects that are available to your script in addition to the built-in and advanced Google services. Your scripts can use common objects like Array, Date, RegExp, and so forth, as well as the Math and Object global objects.

The script editor provides a "content assist" feature, more commonly called "autocomplete," which reveals the global objects as well as methods and enums that are valid in the script's current context. Autocomplete suggestions appear automatically whenever you type a period after a global object, enum, or method call that returns an Apps Script class. For example:

Each service provides at least one global (top-level) object; for example, the Gmail service is accessed solely from the GmailApp object. Some services provide multiple global objects; for example, the Base service includes four global objects: Browser, Logger, MimeType, and Session.

The global objects of nearly all built-in or advanced services include methods that return data or an Apps Script class. Scripts make method calls in this format:

For example, a script can send an email by calling the sendEmail(recipient, subject, body) method of the Gmail service like so:

If a method returns another Apps Script class, you can chain method calls on one line. (Return types are shown both in autocomplete and in a method's reference documentation.) For example, the method DocumentApp.create() returns a Document; thus, the following two sections of code are equivalent:

Every service includes one or more child classes that cannot be accessed from the top level as a global object can. You cannot use the new keyword to construct these classes, as you can with standard JavaScript classes like Date; you can only access a child class by calling a method that returns it. If you're not sure how to access a certain class, visit the root page for the service's reference documentation and look for a method that returns the class you want.

A handful of services include special classes that are labeled as "interfaces" in the reference documentation. These are generic classes used as return types for methods that cannot determine the precise type in advance; for example, the Document service method Body.getChild(childIndex) returns a generic Element object. Element is an interface that represents some other class, possibly a Paragraph or Table. Interface objects are rarely useful on their own; instead, you usually want to call a method like Element.asParagraph() to cast the object back to a precise class.

Most services include a few enums (enumerated types) of named values. For example, the Drive service uses the enums Access and Permission to determine which users have access to a file or folder. In almost all cases, you access these enums from the global object. For example, a call to the method Folder.setSharing(accessType, permissionType) looks like this:

**Examples:**

Example 1 (unknown):
```unknown
GlobalObjectName.methodName(argument1, argument2, ..., argumentN);
```

Example 2 (unknown):
```unknown
GmailApp.sendEmail('claire@example.com', 'Subject line', 'This is the body.');
```

Example 3 (unknown):
```unknown
var doc = DocumentApp.create('New document');
var body = doc.getTab('t.0').asDocumentTab().getBody();
body.appendParagraph('New paragraph.');

// Same result as above.
DocumentApp.create('New document').getTab('t.0').asDocumentTab().getBody()
    .appendParagraph('New paragraph.');
```

Example 4 (unknown):
```unknown
// Creates a folder that anyone on the Internet can read from and write to. (Domain administrators can
// prohibit this setting for Google Workspace users.)
var folder = DriveApp.createFolder('Shared Folder');
folder.setSharing(DriveApp.Access.ANYONE, DriveApp.Permission.EDIT);
```

---

## Container-bound Scripts Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/guides/bound

**Contents:**
- Container-bound Scripts Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
- Create a bound script
  - Google Docs, Sheets, or Slides
  - Google Forms
- Special methods
- Custom menus, dialogs, and sidebars
- Triggers
- Custom functions
- Access to bound scripts

A bound script is attached to a specific Google Sheets, Docs, Slides, or Forms file, called its container.

Bound scripts behave similarly to standalone scripts but do not appear in Google Drive and cannot be detached from their container.

Bound scripts have special privileges, including the ability to refer to their parent file without its ID and interact with the parent file's user interface to add custom menus, dialogs, and sidebars.

Bound scripts can be created from within the Google Docs, Sheets, Slides, or Forms file they will be bound to.

Bound scripts can use simple and installable triggers, and in Google Sheets, they can be used to create custom functions.

A script is bound to a Google Sheets, Docs, Slides, or Forms file if it was created from that document rather than as a standalone script. The file that a bound script is attached to is called a "container." Bound scripts generally behave like standalone scripts except that they do not appear in Google Drive, they cannot be detached from the file they are bound to, and they gain a few special privileges over the parent file.

Note that scripts can also be bound to Google Sites, but these scripts are almost always deployed as web apps. Scripts bound to Google Sheets, Docs, Slides, or Forms can also become web apps, although this is uncommon.

To create a bound script in Google Docs, Sheets, or Slides, open a document in Docs, a spreadsheet in Sheets, or a presentation in Slides and click Extensions > Apps Script. To reopen the script in the future, do the same thing or open the script from the Apps Script dashboard.

To create a bound script in Google Forms, open a form and click More more_vert > Script editor. To reopen the script in the future, do the same thing or open the script from the Apps Script dashboard.

Bound scripts can call a few methods that standalone scripts cannot:

For more information, see the guide to extending Google Sheets or the guide to extending Google Docs.

Bound scripts can customize Google Sheets, Docs, and Forms by adding custom menus and dialog boxes or sidebars. Keep in mind, however, that a script can only interact with the user interface for the current instance of an open file. That is, a script bound to one document cannot affect the user interface of another document.

Bound scripts can use simple triggers like the special onOpen() function, which runs automatically whenever a file is opened by a user who has edit access. Like all types of scripts, they can also use installable triggers.

A custom function is a function in a script bound to Google Sheets that you call directly from a cell using the syntax =myFunctionName(). Custom functions are thus similar to the hundreds of built-in functions in Sheets like AVERAGE or SUM except that you define the custom function's behavior.

Only users who have permission to edit a container can run its bound script. Collaborators who have only view access can't open the script editor, although if they make a copy of the container file, they become the owner of the copy and can see and run a copy of the script.

To learn how to share a script's container file, refer to Share files from Google Drive.

---

## Custom Functions in Google Sheets Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/guides/sheets/functions

**Contents:**
- Custom Functions in Google Sheets Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
- Getting started
  - Creating a custom function
  - Getting a custom function from the Google Workspace Marketplace
  - Using a custom function
- Guidelines for custom functions
  - Naming
  - Arguments
  - Return values

Google Sheets allows creating custom functions using Google Apps Script in JavaScript to extend built-in functionalities.

To create a custom function, write JavaScript code in the script editor accessed through the Extensions menu in Google Sheets.

Custom functions can take arguments, return values, and work with various data types supported by JavaScript.

Custom functions can be shared by copying the script to other spreadsheets or publishing them as add-ons.

Optimizing custom functions by processing ranges as arrays can significantly improve performance for large datasets.

Google Sheets offers hundreds of built-in functions like AVERAGE, SUM, and VLOOKUP. When these aren’t enough for your needs, you can use Google Apps Script to write custom functions — say, to convert meters to miles or fetch live content from the Internet — then use them in Google Sheets just like a built-in function.

Custom functions are created using standard JavaScript. If you're new to JavaScript, Codecademy offers a great course for beginners. (Note: this course wasn't developed by and isn't associated with Google.)

Here's a simple custom function, named DOUBLE, which multiplies an input value by 2:

If you don't know how to write JavaScript and don't have time to learn, check the add-on store to see whether someone else has already built the custom function you need.

To write a custom function:

Now you can use the custom function.

The Google Workspace Marketplace offers several custom functions as add-ons for Google Sheets. To use or explore these add-ons:

Once you've written a custom function or installed one from the Google Workspace Marketplace, it's as easy to use as a built-in function:

Before writing your own custom function, there are a few guidelines to know.

In addition to the standard conventions for naming JavaScript functions, be aware of the following:

Like a built-in function, a custom function can take arguments as input values:

If you call your function with a reference to a range of cells as an argument (like =DOUBLE(A1:B10)), the argument will be a two-dimensional array of the cells' values. For example, in the screenshot below, the arguments in =DOUBLE(A1:B2) are interpreted by Apps Script as double([[1,3],[2,4]]). Note that the sample code for DOUBLE from above would need to be modified to accept an array as input.

Custom function arguments must be deterministic. That is, built-in spreadsheet functions that return a different result each time they calculate — such as NOW() or RAND() — are not allowed as arguments to a custom function. If a custom function tries to return a value based on one of these volatile built-in functions, it will display Loading... indefinitely.

Every custom function must return a value to display, such that:

Google Sheets stores data in different formats depending on the nature of the data. When these values are used in custom functions, Apps Script treats them as the appropriate data type in JavaScript. These are the most common areas of confusion:

Google Sheets supports autocomplete for custom functions much like for built-in functions. As you type a function name in a cell, you will see a list of built-in and custom functions that matches what you enter.

Custom functions will appear in this list if their script includes a JsDoc @customfunction tag, as in the DOUBLE() example below.

Custom functions can call certain Google Apps Script services to perform more complex tasks. For example, a custom function can call the Language service to translate an English phrase into Spanish.

Unlike most other types of Apps Scripts, custom functions never ask users to authorize access to personal data. Consequently, they can only call services that do not have access to personal data, specifically the following:

If your custom function throws the error message You do not have permission to call X service., the service requires user authorization and thus cannot be used in a custom function.

To use a service other than those listed above, create a custom menu that runs an Apps Script function instead of writing a custom function. A function that is triggered from a menu will ask the user for authorization if necessary and can consequently use all Apps Script services.

Custom functions start out bound to the spreadsheet they were created in. This means that a custom function written in one spreadsheet can't be used in other spreadsheets unless you use one of the following methods:

Each time a custom function is used in a spreadsheet, Google Sheets makes a separate call to the Apps Script server. If your spreadsheet contains dozens (or hundreds, or thousands!) of custom function calls, this process can be quite slow. Some projects with many or complex custom functions might experience a temporary delay in executions.

Consequently, if you plan to use a custom function multiple times on a large range of data, consider modifying the function so that it accepts a range as input in the form of a two-dimensional array, then returns a two-dimensional array that can overflow into the appropriate cells.

For example, the DOUBLE() function shown above can be rewritten to accept a single cell or range of cells as follows:

The above approach uses the map method of JavaScript's Array object to method on the two-dimensional array of cells to get each row, then for each row, it uses map again to return double each cell's value. It returns a two-dimensional array that contains the results. This way, you can call DOUBLE just once but have it calculate for a large number of cells at once, as shown in the screenshot below. (You could accomplish the same thing with nested if statements instead of the map call.)

Similarly, the custom function below efficiently fetches live content from the Internet and uses a two-dimensional array to display two columns of results with just a single function call. If each cell required its own function call, the operation would take considerably more time, since the Apps Script server would have to download and parse the XML feed each time.

These techniques can be applied to nearly any custom function that is used repeatedly throughout a spreadsheet, although the implementation details will vary depending on the function's behavior.

**Examples:**

Example 1 (unknown):
```unknown
/**
 * Multiplies an input value by 2.
 * @param {number} input The number to double.
 * @return The input multiplied by 2.
 * @customfunction
*/
function DOUBLE(input) {
  return input * 2;
}
```

Example 2 (unknown):
```unknown
/**
 * Multiplies the input value by 2.
 *
 * @param {number} input The value to multiply.
 * @return The input multiplied by 2.
 * @customfunction
 */
function DOUBLE(input) {
  return input * 2;
}
```

Example 3 (javascript):
```javascript
/**
 * Multiplies the input value by 2.
 *
 * @param {number|Array<Array<number>>} input The value or range of cells
 *     to multiply.
 * @return The input multiplied by 2.
 * @customfunction
 */
function DOUBLE(input) {
  return Array.isArray(input) ?
      input.map(row => row.map(cell => cell * 2)) :
      input * 2;
}
```

Example 4 (unknown):
```unknown
/**
 * Show the title and date for the first page of posts on the
 * Developer blog.
 *
 * @return Two columns of data representing posts on the
 *     Developer blog.
 * @customfunction
 */
function getBlogPosts() {
  var array = [];
  var url = 'https://gsuite-developers.googleblog.com/atom.xml';
  var xml = UrlFetchApp.fetch(url).getContentText();
  var document = XmlService.parse(xml);
  var root = document.getRootElement();
  var atom = XmlService.getNamespace('http://www.w3.org/2005/Atom');
  var entries = document.getRootElement().getChildren('entry', atom);
  for (var i = 0; i < entries.length; i++) {
    var title = entries[i].getChild('title', atom).getText();
    var date = entries[i].getChild('published', atom).getValue();
    array.push([title, date]);
  }
  return array;
}
```

---

## Custom function quickstart Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/quickstart/macros

**Contents:**
- Custom function quickstart Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
- Objectives
- Prerequisites
- Set up the script
- Run the script
- Next steps

Google Apps Script can be used to create custom functions for Google Sheets.

This sample demonstrates creating a custom function to calculate and format the sale price of discounted items in US dollars.

The process involves setting up the script in the Apps Script editor and then running the function in a spreadsheet cell.

You can use Google Apps Script to write a custom function, then use it in Google Sheets just like a built-in function.

The following quickstart sample creates a custom function that calculates the sale price of discounted items. The sale price is formatted as US dollars.

To use this sample, you need the following prerequisites:

Delete any code in the script editor and paste in the code below. Then click Save .

The formula that you enter in the cell runs the function in the script you created in the previous section. The function results in a sale price of $80.00.

To continue learning about how to extend Sheets with Apps Script, take a look at the following resources:

---

## Custom function quickstart Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/quickstart/custom-functions

**Contents:**
- Custom function quickstart Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
- Objectives
- Prerequisites
- Set up the script
- Run the script
- Next steps

Google Apps Script can be used to create custom functions for Google Sheets.

This sample demonstrates creating a custom function to calculate and format the sale price of discounted items in US dollars.

The process involves setting up the script in the Apps Script editor and then running the function in a spreadsheet cell.

You can use Google Apps Script to write a custom function, then use it in Google Sheets just like a built-in function.

The following quickstart sample creates a custom function that calculates the sale price of discounted items. The sale price is formatted as US dollars.

To use this sample, you need the following prerequisites:

Delete any code in the script editor and paste in the code below. Then click Save .

The formula that you enter in the cell runs the function in the script you created in the previous section. The function results in a sale price of $80.00.

To continue learning about how to extend Sheets with Apps Script, take a look at the following resources:

---

## Custom Menus in Google Workspace Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/guides/menus

**Contents:**
- Custom Menus in Google Workspace Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
- Custom menus in Google Docs, Sheets, Slides, or Forms
- Clickable images and drawings in Google Sheets

Apps Script allows extending Google products with user-interface elements like custom menus, images, and drawings that trigger script functions.

Custom menus can be added to Google Docs, Sheets, Slides, or Forms and are tied to specific script functions.

Images and drawings in Google Sheets can also have Apps Script functions assigned to them to run when clicked.

Scripts can extend certain Google products by adding user-interface elements that, when clicked, execute an Apps Script function. The most common example is running a script from a custom menu item in Google Docs, Sheets, Slides, or Forms, but script functions can also be triggered by clicking on images and drawings in Google Sheets.

Apps Script can add new menus in Google Docs, Sheets, Slides, or Forms, with each menu item tied to a function in a script. (In Google Forms, custom menus are visible only to an editor who opens the form to modify it, not to a user who opens the form to respond.)

A script can only create a menu if it is bound to the document, spreadsheet, or form. To display the menu when the user opens a file, write the menu code within an onOpen() function.

The example below shows how to add a menu with one item, followed by a visual separator, then a sub-menu that contains another item. (Note that in Google Sheets, unless you're using the new version, you must use the addMenu() syntax instead, and sub-menus are not possible.) When the user selects either menu item, a corresponding function opens an alert dialog. For more information on the types of dialogs you can open, see the guide to dialogs and sidebars.

A document, spreadsheet, presentation, or form can only contain one menu with a given name. If the same script or another script adds a menu with the same name, the new menu replaces the old. Menus cannot be removed while the file is open, although you can write your onOpen() function to skip the menu in the future if a certain property is set.

You can also assign an Apps Script function to an image or drawing in Google Sheets, so long as the script is bound to the spreadsheet. The example below shows how to set this up.

Delete any code in the script editor and paste in the code below.

Return to Sheets and insert an image or drawing by selecting Insert > Image or Insert > Drawing.

After inserting the image or drawing, click it. A small drop-down menu selector appears in the top right-hand corner. Click it and choose Assign script.

In the dialog box that appears, type the name of the Apps Script function that you want to run, without parentheses — in this case, showMessageBox. Click OK.

Click the image or drawing again. The function now executes.

**Examples:**

Example 1 (unknown):
```unknown
function onOpen() {
  var ui = SpreadsheetApp.getUi();
  // Or DocumentApp, SlidesApp or FormApp.
  ui.createMenu('Custom Menu')
      .addItem('First item', 'menuItem1')
      .addSeparator()
      .addSubMenu(ui.createMenu('Sub-menu')
          .addItem('Second item', 'menuItem2'))
      .addToUi();
}

function menuItem1() {
  SpreadsheetApp.getUi() // Or DocumentApp, SlidesApp or FormApp.
     .alert('You clicked the first menu item!');
}

function menuItem2() {
  SpreadsheetApp.getUi() // Or DocumentApp, SlidesApp or FormApp.
     .alert('You clicked the second menu item!');
}
```

Example 2 (unknown):
```unknown
function showMessageBox() {
    Browser.msgBox('You clicked it!');
  }
```

---

## Dialogs and Sidebars in Google Workspace Documents Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/guides/dialogs

**Contents:**
- Dialogs and Sidebars in Google Workspace Documents Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
- Alert dialogs
- Prompt dialogs
- Custom dialogs
  - Code.gs
  - Page.html
- Custom sidebars
  - Code.gs
  - Page.html

Bound scripts in Google Docs, Sheets, or Forms can display prebuilt alerts and prompts, along with custom dialogs and sidebars using HTML service pages.

Alert dialogs are prebuilt and display a message with an "OK" button, suspending the script until closed.

Prompt dialogs are prebuilt and include a message, text-input field, and an "OK" button, also suspending the script until closed.

Custom dialogs and sidebars display HTML service interfaces and do not suspend the server-side script, allowing for asynchronous communication.

Google Picker can be used in custom HTML service dialogs to enable users to select or upload Google Drive files.

Scripts that are bound to Google Docs, Sheets, or Forms can display several types of user-interface elements — prebuilt alerts and prompts, plus dialogs and sidebars that contain custom HTML service pages. Typically, these elements are opened from menu items. (Note that in Google Forms, user-interface elements are visible only to an editor who opens the form to modify it, not to a user who opens the form to respond.)

An alert is a prebuilt dialog that opens inside a Google Docs, Sheets, Slides, or Forms editor. It displays a message and an "OK" button; a title and alternative buttons are optional. It is similar to calling window.alert() in client-side JavaScript within a web browser.

Alerts suspend the server-side script while the dialog is open. The script resumes after the user closes the dialog, but JDBC connections do not persist across the suspension.

As shown in the following example, Google Docs, Forms, Slides, and Sheets all use the method Ui.alert(), which is available in three variants. To override the default "OK" button, pass a value from the Ui.ButtonSet enum as the buttons argument. To evaluate which button the user clicked, compare the return value for alert() to the Ui.Button enum.

A prompt is a prebuilt dialog that opens inside a Google Docs, Sheets, Slides, or Forms editor. It displays a message, a text-input field, and an "OK" button; a title and alternative buttons are optional. It is similar to calling window.prompt() in client-side JavaScript within a web browser.

Prompts suspend the server-side script while the dialog is open. The script resumes after the user closes the dialog, but JDBC connections do not persist across the suspension.

As shown in the following example, Google Docs¸ Forms, Slides, and Sheets all use the method Ui.prompt(), which is available in three variants. To override the default "OK" button, pass a value from the Ui.ButtonSet enum as the buttons argument. To evaluate the user's response, capture the return value for prompt(), then call PromptResponse.getResponseText() to retrieve the user's input, and compare the return value for PromptResponse.getSelectedButton() to the Ui.Button enum.

A custom dialog can display an HTML service user interface inside a Google Docs, Sheets, Slides, or Forms editor.

Custom dialogs do not suspend the server-side script while the dialog is open. The client-side component can make asynchronous calls to the server-side script using the google.script API for HTML-service interfaces.

The dialog can close itself by calling google.script.host.close() in the client side of an HTML-service interface. The dialog cannot be closed by other interfaces, only by the user or itself.

As shown in the following example, Google Docs, Forms, Slides, and Sheets all use the method Ui.showModalDialog() to open the dialog.

A sidebar can display an HTML service user interface inside a Google Docs, Forms, Slides, and Sheets editor.

Sidebars do not suspend the server-side script while the dialog is open. The client-side component can make asynchronous calls to the server-side script using the google.script API for HTML-service interfaces.

The sidebar can close itself by calling google.script.host.close() in the client side of an HTML-service interface. The sidebar cannot be closed by other interfaces, only by the user or itself.

As shown in the following example, Google Docs, Forms, Slides, and Sheets all use the method Ui.showSidebar() to open the sidebar.

Google Picker is a JavaScript API to let users select or upload Google Drive files. The Google Picker library can be used in HTML service to create a custom dialog that lets users select existing files or upload new ones, then pass that selection back to your script for further use.

There are several requirements for using Google Picker with Apps Script.

Set up your environment for Google Picker.

Your script project must use a standard Google Cloud project.

The Apps Script project manifest must specify the authorization scopes required by the Google Picker API so that ScriptApp.getOAuthToken() returns the correct token for PickerBuilder.setOauthtoken().

The API key set in PickerBuilder.setDeveloperKey() can be restricted to Apps Script. Under Application restrictions, complete the following steps:

You must call PickerBuilder.setOrigin(google.script.host.origin).

The following example shows Google Picker in Apps Script.

**Examples:**

Example 1 (unknown):
```unknown
function onOpen() {
  SpreadsheetApp.getUi() // Or DocumentApp or SlidesApp or FormApp.
    .createMenu("Custom Menu")
    .addItem("Show alert", "showAlert")
    .addToUi();
}

function showAlert() {
  var ui = SpreadsheetApp.getUi(); // Same variations.

  var result = ui.alert(
    "Please confirm",
    "Are you sure you want to continue?",
    ui.ButtonSet.YES_NO,
  );

  // Process the user's response.
  if (result == ui.Button.YES) {
    // User clicked "Yes".
    ui.alert("Confirmation received.");
  } else {
    // User clicked "No" or X in the title bar.
    ui.alert("Permission denied.");
  }
}
```

Example 2 (unknown):
```unknown
function onOpen() {
  SpreadsheetApp.getUi() // Or DocumentApp or SlidesApp or FormApp.
    .createMenu("Custom Menu")
    .addItem("Show prompt", "showPrompt")
    .addToUi();
}

function showPrompt() {
  var ui = SpreadsheetApp.getUi(); // Same variations.

  var result = ui.prompt(
    "Let's get to know each other!",
    "Please enter your name:",
    ui.ButtonSet.OK_CANCEL,
  );

  // Process the user's response.
  var button = result.getSelectedButton();
  var text = result.getResponseText();
  if (button == ui.Button.OK) {
    // User clicked "OK".
    ui.alert("Your name is " + text + ".");
  } else if (button == ui.Button.CANCEL) {
    // User clicked "Cancel".
    ui.alert("I didn't get your name.");
  } else if (button == ui.Button.CLOSE) {
    // User clicked X in the title bar.
    ui.alert("You closed the dialog.");
  }
}
```

---

## Google Cloud projects Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/guides/cloud-platform-projects

**Contents:**
- Google Cloud projects Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
- Default Cloud projects
  - View or update default Cloud projects
  - Delete default Cloud projects
- Standard Cloud projects
  - When Apps Script requires standard Cloud projects
  - Standard Cloud project properties
  - Access a standard Cloud project
  - Activate an API in a standard Cloud project

Every Apps Script project uses Google Cloud to manage authorization, advanced services, and other details and has an associated Google Cloud project.

You can use either a default project that Apps Script creates or a standard project that you create yourself; default projects are for simple scripts, while standard projects are for complex, commercial, or publishable applications.

You can switch from a default to a standard project but not back, and switching later in development can cause complications like requiring users to re-authorize.

Standard projects are required for tasks like publishing add-ons, verifying OAuth clients, viewing logs in the Google Cloud console, and manual control over project settings.

Switching to a different standard project requires re-enabling advanced services and APIs, user re-authorization, and affects Google Workspace Marketplace listings if applicable.

Every Apps Script project uses Google Cloud to manage authorization, advanced services, and other details. To configure and manage these settings, every Apps Script project has an associated Google Cloud project. Your script project can use a default project that Apps Script automatically creates, or a standard project that you create yourself. In general, default projects are good for everyday or simple scripts, but you should use a standard project for any application that is complex, commercial quality, or that you intend to publish.

You can switch from a default project to a standard project at any time, but you can't switch back to use a default project. It's best to select the Cloud project your script uses early in development. Switching later can cause complications, like requiring your users to re-authorize.

When you create an Apps Script project, Apps Script creates a default Cloud project that operates in the background.

By default, Cloud projects have an Identity and Access Management (IAM) policy with one entry, a Google service account that acts as the owner of the default project. The Google service account is appsdev-apps-dev-script-auth@system.gserviceaccount.com.

Most users can’t directly locate, view, or edit default projects in the Google Cloud console. If you're an Admin, refer to View default Google Cloud projects.

If you created your script project before April 8, 2019, you might use a default project that you can access in the Google Cloud console. To access the default project, go to the script project's settings and click the project number.

If you're an administrator, you can delete default Cloud projects like you would standard Cloud projects. See View or edit default Cloud projects.

If you're not an administrator, you can't manually delete default projects. However, if you delete the script project or switch it to use a standard project, Apps Script deletes the default project attached to the script along with any settings or information it contains.

Default Cloud projects are the best option for most script projects, unless you need to manually configure the project. In these situations, you must switch your script project to use a standard project.

The following sections describe when Apps Script requires a standard project, the properties of such projects, and common tasks done with them. You can only perform the below tasks with standard projects.

You must use a standard project in the following situations:

Standard projects have the following properties:

To access the standard project associated with your script project, do the following:

You can also find a standard project directly on the Google Cloud console Manage Resources page.

Often an Apps Script application needs access to another Google API. To do this, you must activate the API in the corresponding Cloud project. Activate an API by doing the following:

You might be prompted to accept the Terms of Service for Google APIs or Google Cloud. Review the Terms of Service carefully before accepting them.

Depending on the application, you might also need to configure the API by selecting it in the APIs & Services dashboard.

All Cloud projects have a project name, project ID, and project number. Occasionally, you must have these identifiers to configure services or complete other tasks.

To determine your standard project's ID and number, do the following:

If you're using Google Cloud logging or error reporting for your script project, you can view those logs and reports in the Google Cloud console by doing the following:

When using services that require OAuth, Google prompts users to authorize those services. The OAuth consent screen settings let you set some of the information that Google presents to users, such as the application name and Terms of Service URL.

Default Cloud projects create a consent screen automatically from the Apps Script project details; you can't adjust those settings. Standard Cloud projects let you customize this information. You can configure your script's consent screen by doing the following:

Apps Script usually sets up OAuth for the services your script uses. For some applications, you must create additional OAuth credentials (client IDs and client secrets). You can only do this with standard projects.

To create a client ID and client secret for your script project, do the following:

You can add additional owners or other roles to a standard project. If you're collaborating on a project, this helps ensure that someone on your team always has access to the script project's Google Cloud settings.

You can add additional owners or other roles to a standard project by doing the following. You must have edit permissions for the project to make any of these changes:

You can have multiple Apps Script projects share the same standard Cloud project. To do this, create a standard project and then switch each script project to use it. You can't do this with default projects.

You can switch a script project so that it uses a different standard Cloud project. If your script requires manual configuration of the Cloud project, you must switch from a default project to a standard project. To learn more about when you need to use a standard project, refer to standard Cloud projects.

If you switch your script from a default project or to a different standard project, it has the following effects:

In your standard Cloud project, turn on the Drive API:

Turn on the Drive API

To switch a script's existing Cloud project over to another Cloud project, follow these steps:

Shared drives (formerly Team Drives) provide shared spaces where groups of Drive users can collaborate on Apps Script projects and Drive documents. Shared drives are valuable when developing scripts, add-ons, and web apps with a team, but they place some restrictions on what you can do with older default Cloud projects.

The following list of restrictions describes how Cloud projects interact with shared drives:

To avoid the above restrictions for older scripts, switch to a standard project.

If you have the resourcemanager.projects.list permission for your organization's Apps Script project folder, you can view all of the standard and default Apps Script Cloud projects within the folder.

To delete an Apps Script Cloud project, follow the steps under Get a list of Apps Script Cloud projects, select the project you want to delete and click Delete.

To delete an Apps Script project using gcloud, use the following commands.

For more information about deleting Cloud projects, see Shutting down (deleting) projects.

**Examples:**

Example 1 (unknown):
```unknown
gcloud projects list --filter='parent.id=APPS_SCRIPT_FOLDER_ID'
gcloud projects delete PROJECT_ID
```

---

## Google Sheets Macros Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/guides/sheets/macros

**Contents:**
- Google Sheets Macros Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
- Creating macros in Apps Script
- Editing macros
- Importing functions as macros
- Manifest structure for macros
- Best practices
- Things you can't do
    - Use macros outside bound scripts
    - Define macros in Sheets add-ons

Google Sheets macros automate UI interactions and can be linked to keyboard shortcuts or accessed via the Extensions menu.

Recording a macro automatically creates an Apps Script function in a bound project's macros.gs file and updates the project manifest.

Macros can be created or edited directly within the Apps Script editor, or existing Apps Script functions can be imported as macros.

The manifest file structure defines the name, function, and optional keyboard shortcut for each macro.

Macros are limited to bound scripts in Google Sheets and cannot be used in standalone scripts, web apps, add-ons, libraries, or other Google Workspace applications.

Google Sheets lets you record macros that duplicate a specific series of UI interactions that you define. Once you've recorded a macro, you can link it to a keyboard shortcut in the form Ctrl+Alt+Shift+Number. You can use that shortcut to quickly execute the exact macro steps again, typically in a different place or on different data. You can also activate the macro from the Google Sheets Extensions > Macros menu.

When you record a macro, Google Sheets automatically creates an Apps Script function (the macro function) that replicates the macro steps. The macro function is added to an Apps Script project bound to the sheet, in a file titled macros.gs. In the event that there is already a project file bound to the sheet with that name, the macro function is appended to it. Google Sheets also automatically updates the script project manifest, recording the name and keyboard shortcut assigned to the macro.

Since every recorded macro is defined entirely within Apps Script, you can edit them directly within the Apps Script editor. You can even write macros from scratch in Apps Script, or take functions you've already written and turn them into macros.

You can take functions written in Apps Script and use them as macro functions. The easiest way to do this is by importing an existing function from the Google Sheets editor.

Alternatively, you can create macros within the Apps Script editor by following these steps:

You can edit macros attached to a sheet by doing the following:

If there is already a script bound to a sheet, you can import a function in the script as a new macro and then assign it a keyboard shortcut. You can do this by editing the manifest file and adding another element to the sheets.macros[] property.

Alternatively, follow these steps to import a function as a macro from the Sheets UI:

The following manifest file example snippet shows the section of a manifest that defines Google Sheets macros. The sheets section of the manifest defines the name and keyboard shortcut assigned to the macro and the name of the macro function.

See the Sheets macro manifest resource for more details on how Sheets macro manifests are constructed.

When creating or managing macros in Apps Script, it is recommended that you adhere to the following guidelines.

There are a few restrictions on what you can do with macros:

Macros are defined in scripts bound to specific Google Sheets. Macro definitions are ignored if defined in a standalone script or web app.

You cannot distribute macro definitions using a Sheets add-on. Any macro definitions in a Sheets add-on project are ignored by users of that add-on.

You cannot distribute macro definitions using Apps Script libraries.

Macros are only a feature in Google Sheets, and do not exist for Google Docs, Forms, or Slides.

**Examples:**

Example 1 (unknown):
```unknown
{
    ...
    "sheets": {
      "macros": [{
        "menuName": "QuickRowSum",
        "functionName": "calculateRowSum",
        "defaultShortcut": "Ctrl+Alt+Shift+1"
      }, {
        "menuName": "Headerfy",
        "functionName": "updateToHeaderStyle",
        "defaultShortcut": "Ctrl+Alt+Shift+2"
      }]
    }
  }
```

---

## HTML Service: Restrictions Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/guides/html/restrictions

**Contents:**
- HTML Service: Restrictions Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
- Sandbox Mode
- Restrictions in IFRAME mode
  - Setting the link target attribute
  - Code.js
  - top.html
  - HTTPS required for active content

Apps Script uses iframes to sandbox HTML-service web apps and custom user interfaces for security.

The only remaining sandbox mode is IFRAME; older modes are automatically migrated to this mode.

The IFRAME sandbox mode restricts certain actions, such as top-level navigation, by using specific HTML5 iframe sandboxing attributes.

In IFRAME mode, link targets must be set to _top or _blank.

Active content in IFRAME mode, such as scripts and external stylesheets, must be loaded over HTTPS.

To protect users from being served malicious HTML or JavaScript, Apps Script uses iframes to sandbox HTML-service web apps or custom user interfaces for Google Docs, Sheets, and Forms. (The HTML service does not use a sandbox in other situations, like generating the body of an email.) The sandbox imposes limitations on client-side code.

All sandbox modes are now sunset except for IFRAME. Apps using older sandbox modes now use the newer IFRAME mode automatically. If you have scripts that were developed using the older modes (NATIVE and EMULATED), you should follow the migration instructions to ensure they function properly under the IFRAME mode.

The setSandboxMode method now has no effect when called.

The IFRAME sandbox mode is based on the iframe sandboxing feature in HTML5, using the following keywords:

The allow-top-navigation keyword, which allows the content to navigate its top-level browsing context, is restricted and not set as an attribute in the sandbox. If you need to redirect your script, add a link or a button for the user to take action on instead.

In the IFRAME mode you need to set the link target attribute to either _top or _blank:

You can also override this attribute using the <base> tag within the head section of the enclosing web page:

"Active" content like scripts, external stylesheets, and XmlHttpRequests must be loaded over HTTPS, not HTTP.

**Examples:**

Example 1 (unknown):
```unknown
function doGet() {
  var template = HtmlService.createTemplateFromFile('top');
  return template.evaluate().setSandboxMode(HtmlService.SandboxMode.IFRAME);
}
```

Example 2 (unknown):
```unknown
<!DOCTYPE html>
<html>
 <body>
   <div>
     <a href="http://google.com" target="_top">Click Me!</a>
   </div>
 </body>
</html>
```

Example 3 (unknown):
```unknown
<!DOCTYPE html>
<html>
  <head>
    <base target="_top">
  </head>
  <body>
   <div>
     <a href="http://google.com">Click Me!</a>
   </div>
 </body>
</html>
```

---

## Installable Triggers Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/guides/triggers/installable

**Contents:**
- Installable Triggers Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
- Restrictions
- Time-driven triggers
- Event-driven triggers
- Manage triggers manually
- Manage triggers programmatically
- Errors in triggers
- Triggers in add-ons

Installable triggers allow Apps Script functions to run automatically based on events, offering more flexibility and authorization capabilities than simple triggers.

Installable triggers are subject to restrictions, including not running in read-only mode, not being triggered by script executions or API requests (with one exception), and always running under the creator's account.

Time-driven triggers allow scripts to execute at specific times or intervals.

Event-driven triggers respond to various events in Google Workspace applications, such as opening, editing, or submitting forms, and can call services requiring authorization.

Installable triggers can be managed manually through the script editor or programmatically using the Script service.

Like simple triggers, installable triggers let Apps Script run a function automatically when a certain event, such as opening a document, occurs. Installable triggers, however, offer more flexibility than simple triggers: they can call services that require authorization, they offer several additional types of events including time-driven (clock) triggers, and they can be controlled programmatically. For both simple and installable triggers, Apps Script passes the triggered function an event object that contains information about the context in which the event occurred.

Even though installable triggers offer more flexibility than simple triggers, they are still subject to several restrictions:

Script executions and API requests do not cause triggers to run. For example, calling FormResponse.submit() to submit a new form response does not cause the form's submit trigger to run.

Installable triggers always run under the account of the person who created them. For example, if you create an installable open trigger, it runs when your colleague opens the document (if your colleague has edit access), but it runs as your account. This means that if you create a trigger to send an email when a document is opened, the email is always sent from your account, not necessarily the account that opened the document. However, you could create an installable trigger for each account, which would result in one email sent from each account.

A given account cannot see triggers installed from a second account, even though the first account can still activate those triggers.

Installable triggers are subject to Apps Script trigger quota limits.

A time-driven trigger (also called a clock trigger) is similar to a cron job in Unix. Time-driven triggers let scripts execute at a particular time or on a recurring interval, as frequently as every minute or as infrequently as once per month. (Note that an add-on can use a time-driven trigger once per hour at most.) The time might be slightly randomized—for example, if you create a recurring 9 AM trigger, Apps Script chooses a time between 9 AM and 10 AM, then keeps that timing consistent from day to day so that 24 hours elapse before the trigger fires again.

Installable event-driven triggers are conceptually similar to simple triggers like onOpen(), but they can respond to additional events, and they behave differently.

For example, the installable open trigger for Google Sheets activates whenever the spreadsheet is opened by any user who has edit access, just like the simple onOpen() trigger. However, the installable version can call services that require authorization. The installable version runs with the authorization of the user who created the trigger, even if another user with edit access opens the spreadsheet.

There are several installable triggers for Google Workspace applications:

You can use installable triggers in standalone and bound scripts. For example, a standalone script can programmatically create an installable trigger for an arbitrary Google Sheets file by calling TriggerBuilder.forSpreadsheet(key) and passing in the spreadsheet's ID.

To manually create an installable trigger in the script editor, follow these steps:

You can also create and delete triggers programmatically with the Script service. Start by calling ScriptApp.newTrigger(functionName), which returns a TriggerBuilder.

The following example shows how to create two time-driven triggers—one that fires every 6 hours, and one that fires every Monday at 9 a.m. (in the time zone that your script is set to).

This next example shows how to create an installable open trigger for a spreadsheet. Note that, unlike for a simple onOpen() trigger, the script for the installable trigger does not need to be bound to the spreadsheet. To create this trigger from a standalone script, simply replace SpreadsheetApp.getActive() with a call to SpreadsheetApp.openById(id).

To programmatically modify an existing installable trigger, you must delete it and create a new one. If you have previously stored the ID of a trigger, you can delete it by passing the ID as an argument to the function below.

Before creating a trigger, we recommend that you verify that the associated function has all the necessary OAuth permissions.

When an installable trigger fires but the function throws an exception or otherwise fails to run successfully, you don't see an error message on your screen. After all, when a time-driven trigger runs or another user activates your form-submit trigger, you might not even be at your computer.

Instead, Apps Script sends you an email like the following:

The email includes a link to deactivate or reconfigure the trigger. If the script is bound to a Google Sheets, Docs, or Forms file, the email also includes a link to that file. These links let you deactivate the trigger or edit the script to fix the bug.

To review all of the triggers that are associated with your Google Account and deactivate the triggers you no longer need, follow these steps:

To delete a trigger, at the right of the trigger, click More more_vert > Delete trigger.

In addition to installable triggers, you can use manifest triggers in add-ons. For more information, see Triggers for Google Workspace add-ons.

---

## JDBC Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/guides/jdbc

**Contents:**
- JDBC Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
- Google Cloud SQL databases
  - Creating Google Cloud SQL connections
    - Using Jdbc.getCloudSqlConnection(url) (recommended)
    - Using Jdbc.getConnection(url)
- Other databases
  - Creating other database connections
- Sample code
  - Create a database, user, and table

Apps Script uses the JDBC service to connect to external databases, including Google Cloud SQL, MySQL, Microsoft SQL Server, and Oracle.

Updating external databases with JDBC requires opening a connection and sending SQL statements.

For Google Cloud SQL databases, the recommended connection method is Jdbc.getCloudSqlConnection(url).

To connect to other databases or Google Cloud SQL using Jdbc.getConnection(url), you must authorize specific IP ranges in your database settings.

JDBC connections close automatically when a script finishes, but can be closed manually with close() methods for connections, statements, or result sets.

Apps Script can connect to external databases through the JDBC service, a wrapper around the standard Java Database Connectivity technology. The JDBC service supports Google Cloud SQL for MySQL, MySQL, Microsoft SQL Server, and Oracle databases.

To update an external database with JDBC, your script must open a connection to the database and then make changes by sending SQL statements.

Google Cloud SQL lets you create relational databases that live in Google's cloud. Note that Cloud SQL might incur charges based on your usage.

You can create a Google Cloud SQL instance by following the steps listed in the Cloud SQL quickstart.

There are two ways of establishing a connection with a Google Cloud SQL database using Apps Script's JDBC service:

These methods are explained below. Both are valid, but the second method requires you to authorize a set of IP ranges for access to your database.

This method creates a connection to a Google Cloud SQL MySQL instance using the Jdbc.getCloudSqlConnection(url) method. The database URL has the form of jdbc:google:mysql://subname, where subname is the MySQL Instance connection name listed on the Cloud SQL instance Overview page in the Google Cloud console.

To connect to Cloud SQL SQL Server, see Jdbc.getConnection(url).

In order to use this method, you must authorize certain Classless Inter-Domain Routing (CIDR) IP address ranges so that Apps Script's servers can connect to your database. Before running your script, complete the following steps:

In your Google Cloud SQL instance, authorize the IP ranges, one at at time from this data source.

Copy the URL that was assigned to your database; it should have the form jdbc:mysql:subname.

Once you've authorized these IP ranges, you can create connections to your Google Cloud SQL instance using one of the Jdbc.getConnection(url) methods and the URL you copied above.

If you already have your own MySQL, Microsoft SQL Server, or Oracle database, you can connect to it through Apps Script's JDBC service.

In order to create a database connection using the Apps Script JDBC service, in your database settings you must authorize IP ranges from this data source.

Once these allowlists are in place, you can create a connection to the database using one of the Jdbc.getConnection(url) methods and your database's URL.

The sample code below assumes you are connecting to a Google Cloud SQL database, and creates database connections using the Jdbc.getCloudSqlConnection(url) method. For other databases you must use the Jdbc.getConnection(url) method to create database connections.

For more information on the JDBC methods, see the Java documentation for JDBC.

Most developers use the MySQL command-line tool to create databases, users, and tables. However, it's possible to do the same thing in Apps Script, as shown below. It's a good idea to create at least one other user so that your script doesn't always have to connect to the database as root.

The examples below demonstrate how to write a single record to the database as well as a batch of 500 records. Batching is vital for bulk operations.

Note also the use of parameterized statements, in which the variables are denoted by ?. To prevent SQL injection attacks, you should use parameterized statements to escape all user-supplied data.

This example demonstrates how to read a large number of records from the database, looping over the result set as necessary.

JDBC connections close automatically when a script finishes executing. (Keep in mind that a single google.script.run call counts as a complete execution, even if the HTML service page that made the call remains open.)

Nonetheless, if you know you're done with a connection, statement, or result set before the end of the script, it's a good idea to close them manually by calling JdbcConnection.close(), JdbcStatement.close(), or JdbcResultSet.close().

Showing an alert or prompt dialog also terminates any open JDBC connections. However, other showing UI elements—like custom menus or dialogs and sidebars with custom content—does not.

​Google, Google Workspace, and related marks and logos are trademarks of Google LLC. All other company and product names are trademarks of the companies with which they are associated.​

---

## Migrate scripts to the V8 runtime Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/guides/v8-runtime/migration

**Contents:**
- Migrate scripts to the V8 runtime Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
- V8 migration procedure
- Incompatibilities
  - Avoid for each(variable in object)
  - Avoid Date.prototype.getYear()
  - Avoid using reserved keywords as names
  - Avoid reassigning const variables
  - Avoid XML literals and the XML object
  - Don't build custom iterator functions using __iterator__

The Rhino runtime for Apps Script is being retired on or after January 31, 2026, requiring migration to the V8 runtime.

Migrating to the V8 runtime primarily involves enabling it but also requires addressing incompatibilities and other differences in script behavior.

The migration procedure includes enabling V8, reviewing and correcting code for incompatibilities and other differences, updating syntax, thorough testing, and updating deployments and versions.

Several specific incompatibilities exist, such as avoiding for each...in, Date.prototype.getYear(), reserved keywords as names, reassigning const variables, XML literals/objects, __iterator__ functions, conditional catch clauses, and Object.prototype.toSource().

Other behavioral differences in V8 include changes in locale-specific date/time formatting, lack of Error.fileName/lineNumber, different handling of stringified enum objects and undefined parameters, adjustments needed for global this, and different behavior for instanceof and non-shared resources in libraries.

The Rhino runtime is turning down on or after January 31, 2026. If you have an existing script using the Rhino runtime, you must migrate the script to V8.

Often the only prerequisite to adding V8 syntax and features to a script is enabling the V8 runtime. However, there is a small set of incompatibilities and other differences that can result in a script failing or behaving unexpectedly in the V8 runtime. As you migrate a script to use V8, you must search the script project for these issues and correct any you find.

To migrate a script to V8, follow this procedure:

The original Rhino-based Apps Script runtime unfortunately permitted several non-standard ECMAScript behaviors. Since V8 is standards compliant, these behaviors aren't supported after migration. Failing to correct these issues results in errors or broken script behavior once the V8 runtime is enabled.

The following sections describe each of these behaviors and steps you must take to correct your script code during migration to V8.

The for each (variable in object) statement was added to JavaScript 1.6, and removed in favor of for...of.

When migrating your script to V8, avoid using for each (variable in object) statements.

Instead, use for (variable in object):

In the original Rhino runtime, Date.prototype.getYear() returns two-digit years for years from 1900-1999, but four-digit years for other dates, which was the behavior in JavaScript 1.2 and earlier.

In the V8 runtime, Date.prototype.getYear() returns the year minus 1900 instead as required by ECMAScript standards.

When migrating your script to V8, always use Date.prototype.getFullYear(), which returns a four-digit year regardless of the date.

ECMAScript prohibits the use of certain reserved keywords in function and variable names. The Rhino runtime allowed many of these words, so if your code uses them, you must rename your functions or variables.

When migrating your script to V8, avoid naming variable or functions using one of the reserved keywords. Rename any variable or function to avoid using the keyword name. Common uses of keywords as names are class, import, and export.

In the original Rhino runtime, you can declare a variable using const which means the value of the symbol never changes and future assignments to the symbol are ignored.

In the new V8 runtime, the const keyword is standard compliant and assigning to a variable declared as a const results in a TypeError: Assignment to constant variable runtime error.

When migrating your script to V8, do not attempt to reassign the value of a const variable:

This non-standard extension to ECMAScript allows Apps Script projects to use XML syntax directly.

When migrating your script to V8, avoid using direct XML literals or the XML object.

Instead, use the XmlService to parse XML:

JavaScript 1.7 added a feature to allow adding a custom iterator to any class by declaring an __iterator__ function in that class's prototype; this was also added into Apps Script's Rhino runtime as a developer convenience. However, this feature was never part of the ECMA-262 standard and was removed in ECMAScript-compliant JavaScript engines. Scripts using V8 can't use this iterator construction.

When migrating your script to V8, avoid __iterator__ function to build custom iterators. Instead, use ECMAScript 6 iterators.

Consider the following array construction:

The following code examples show how an iterator could be constructed in the Rhino runtime, and how to construct a replacement iterator in the V8 runtime:

The V8 runtime doesn't support catch..if conditional catch clauses, as they are not standard-compliant.

When migrating your script to V8, move any catch conditionals inside the catch body:

JavaScript 1.3 contained a Object.prototype.toSource() method that was never part of any ECMAScript standard. It is not supported in the V8 runtime.

When migrating your script to V8, remove any use of Object.prototype.toSource() from your code.

In addition to the preceding incompatibilities that can cause script failures, there are a few other differences that, if uncorrected, might result in unexpected V8 runtime script behavior.

The following sections explain how to update your script code to avoid these unexpected surprises.

The Date methods toLocaleString(), toLocaleDateString(), and toLocaleTimeString() behave differently in the V8 runtime as compared to Rhino.

In Rhino, the default format is the long format, and any parameters passed in are ignored.

In the V8 runtime, the default format is the short format and parameters passed in are handled according to the ECMA standard (see the toLocaleDateString() documentation for details).

When migrating your script to V8, test and adjust your code's expectations regarding the output of locale-specific date and time methods:

In the V8 runtime, the standard JavaScript Error object doesn't support the fileName or lineNumber as constructor parameters or object properties.

When migrating your script to V8, remove any dependence on Error.fileName and Error.lineNumber.

An alternative is to use the Error.prototype.stack. This stack is also non-standard, but supported in V8. The format of the stack trace produced by the two platforms is slightly different:

In the original Rhino runtime, using the JavaScript JSON.stringify() method on an enum object only returns {}.

In V8, using the same method on an enum object retuns the enum name.

When migrating your script to V8, test and adjust your code's expectations regarding the output of JSON.stringify() on enum objects:

In the original Rhino runtime, passing undefined to a method as a parameter resulted in passing the string "undefined" to that method.

In V8, passing undefined to methods is equivalent to passing null.

When migrating your script to V8, test and adjust your code's expectations regarding undefined parameters:

The Rhino runtime defines an implicit special context for scripts that use it. Script code runs in this implicit context, distinct from the actual global this. This means that references to the "global this" in the code actually evaluate to the special context, which only contains the code and variables defined in the script. The built-in Apps Script services and ECMAScript objects are excluded from this use of this. This situation was similar to this JavaScript structure:

In V8, the implicit special context is removed. Global variables and functions defined in the script are placed in the global context, beside the built-in Apps Script services and ECMAScript built-ins like Math and Date.

When migrating your script to V8, test and adjust your code's expectations regarding the use of this in a global context. In most cases the differences are only apparent if your code examines the keys or property names of the global this object:

Using instanceof in a library on an object that is passed as a parameter in a function from another project can give false negatives. In the V8 runtime, a project and its libraries are run in different execution contexts and hence have different globals and prototype chains.

Note that this is only the case if your library uses instanceof on an object that is not created in your project. Using it on an object that is created in your project, whether in the same or a different script inside your project, should work as expected.

If a project that’s running on V8 uses your script as a library, check if your script uses instanceof on a parameter that will be passed from another project. Adjust the usage of instanceof and use other feasible alternatives as per your use case.

One alternative for a instanceof b can be to use the constructor of a in cases where you don't need to search the entire prototype chain and just check the constructor. Usage: a.constructor.name == "b"

Consider Project A and Project B where Project A uses Project B as a library.

Another alternative can be to introduce a function that checks instanceof in the main project and pass the function in addition to other parameters when calling a library function. The passed function can then be used to check instanceof inside the library.

Passing a non-shared resource from the main script to a library works differently in the V8 runtime.

In the Rhino runtime, passing a non-shared resource won't work. The library uses its own resource instead.

In the V8 runtime, passing a non-shared resource to the library works. The library uses the passed non-shared resource.

Do not pass non-shared resources as function parameters. Always declare non-shared resources in the same script that uses them.

Consider Project A and Project B where Project A uses Project B as a library. In this example, PropertiesService is a non-shared resource. // Rhino runtime // Project A function testPassingNonSharedProperties() { PropertiesService.getScriptProperties() .setProperty('project', 'Project-A'); B.setScriptProperties(); // Prints: Project-B Logger.log(B.getScriptProperties( PropertiesService, 'project')); }

//Project B function setScriptProperties() { PropertiesService.getScriptProperties() .setProperty('project', 'Project-B'); } function getScriptProperties( propertiesService, key) { return propertiesService.getScriptProperties() .getProperty(key); } // V8 runtime // Project A function testPassingNonSharedProperties() { PropertiesService.getScriptProperties() .setProperty('project', 'Project-A'); B.setScriptProperties(); // Prints: Project-A Logger.log(B.getScriptProperties( PropertiesService, 'project')); }

// Project B function setProperties() { PropertiesService.getScriptProperties() .setProperty('project', 'Project-B'); } function getScriptProperties( propertiesService, key) { return propertiesService.getScriptProperties() .getProperty(key); }

With V8 runtime, we have added new features to the JDBC service.

You can use executeBatch(params) operations to perform batch database operations.

The following example shows how to insert multiple rows into a database using batching:

Here's the Rhino runtime (old method): var conn = Jdbc.getCloudSqlConnection("jdbc:google:mysql://..."); var stmt = conn.prepareStatement("INSERT INTO employees (name, age) VALUES (?, ?)"); var params = [["John Doe", 30], ["John Smith", 25]]; for (var i = 0; i < params.length; i++) { stmt.setString(1, params[i][0]); stmt.setInt(2, params[i][1]); stmt.execute(); }

Here's the V8 runtime (new method): var conn = Jdbc.getCloudSqlConnection("jdbc:google:mysql://..."); var stmt = conn.prepareStatement("INSERT INTO employees (name, age) VALUES (?, ?)"); var params = [["John Doe", 30], ["John Smith", 25]]; stmt.executeBatch(params);

You can use getRows(queryString) to fetch result set data in one call. The queryString consists of comma-separated calls to getter methods of JdbcResultSet, for example: "getString(1), getDouble('price'), getDate(3, 'UTC')". Supported methods include all getter methods which are responsible for reading column data, for example, getHoldability, getMetaData etc are not supported. Arguments can be integer column indexes (1-based) or single or double quoted string column labels.

The following example shows you how to fetch rows from result set:

Here's the Rhino runtime (old method): var conn = Jdbc.getCloudSqlConnection("jdbc:google:mysql://..."); var stmt = conn.createStatement(); var rs = stmt.executeQuery("SELECT name, age FROM employees"); while (rs.next()) { Logger.log(rs.getString('name') + ", " + rs.getInt('age')); }

Here's the V8 runtime (new method): var conn = Jdbc.getCloudSqlConnection("jdbc:google:mysql://..."); var stmt = conn.createStatement(); var rs = stmt.executeQuery("SELECT name, age FROM employees"); var rows = rs.getRows("getString('name'), getInt('age')"); for (var i = 0; i < rows.length; i++) { Logger.log(rows[i][0] + ", " + rows[i][1]); }

For standalone scripts running on V8 runtime, you need to provide users at least view access to the script in order for the script's triggers to work properly.

---

## Monitor and control Apps Script use in your Google Workspace organization Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/guides/admin/monitor-use

**Contents:**
- Monitor and control Apps Script use in your Google Workspace organization Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
- View Apps Script audit logs
- View how many people use Apps Script
- Control access to external domains
- Turn off Apps Script
- Turn off a specific Apps Script project
- Related resources

Admins can monitor Apps Script project actions and daily usage in the Google Admin console.

You can view actions taken on Apps Script projects through Drive log events reporting in the Admin console.

The Admin console allows viewing the daily number of people using Apps Script and the number of projects used per day.

Admins with specific Google Workspace accounts can control access to external domains for Apps Script.

Administrators have the ability to turn Apps Script on or off for their organization or disable individual Apps Script projects.

You can monitor the actions people take on Apps Script projects and how many people use Apps Script per day in the Google Admin console.

You can view the actions people take on Apps Script projects with Drive log events reporting in the Admin console. Take the following steps:

To view the number of people in your organization using Apps Script each day and how many Apps Script projects people use per day, take the following steps:

The charts show data for the last 6 months and include all script executions–meaning any time a script runs.

By default, scripts can send or fetch data using any URL with URL Fetch Service. As an administrator, you can control which external domains your users can access through Apps Script. Refer to Allow only certain external connections for Apps Script and Sheets.

As an administrator, you can turn Apps Script on or off for people in your organization. Refer to Turn Apps Script on or off for users

You can turn off an individual Apps Script project by deleting its associated Cloud project. After you shut down a Cloud project, all executions of the script project stop. Refer to Shutting down (deleting) projects.

To delete a Cloud project, you must have delete permissions on the project. To give delete permissions for projects in your organization, refer to Assign delete permission for all Cloud projects in an organization.

---

## Properties Service Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/guides/properties

**Contents:**
- Properties Service Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
- Comparison of property stores
- Data format
- Saving data
- Reading data
- Modifying data
- Deleting data
- Manage script properties manually
  - Add script properties

The Properties service stores simple key-value data for Apps Script projects, scoped to a script, user, or document.

There are three types of property stores: Script properties (shared by all users), User properties (specific to the current user), and Document properties (specific to an add-on in a document).

All data is stored as strings in key-value pairs, with non-string data types automatically converted.

Data can be saved using setProperty for single values or setProperties for multiple values.

Data can be retrieved using getProperty for single values or getProperties for all values in a store.

Data can be modified by saving the updated value again using setProperty.

Properties can be deleted individually with deleteProperty or all at once with deleteAllProperties.

Script properties can be managed manually through the project settings page for up to fifty properties.

The Properties service lets you store simple data in key-value pairs scoped to one script, one user of a script, or one document in which an add-on is used. It is typically used to store developer configuration or user preferences. Properties are never shared between scripts.

To view the daily quotas and storage limits for the Properties service, see Quotas for Google Services.

The PropertiesService global object offers three methods, each of which returns a similar Properties object but with different access rights, as shown in the following table:

The Properties service stores all data as strings in key-value pairs. Data types that are not already strings are automatically converted to strings, including methods contained within saved objects.

To save a single value, call the method Properties.setProperty(key, value) of the appropriate store, as shown in the following example:

To save data in bulk, pass a map of key-value pairs to Properties.setProperties(properties). Each key-value pair of the object in the parameter is stored as a separate property:

To retrieve a single value that you have previously saved, call Properties.getProperty(key):

To retrieve all values in the current property store, call Properties.getProperties():

The methods getProperty() and getProperties() return a copy of the stored data, not a live view, so changing the returned object will not update the value in the property store. To update the data in the store, simply save it again:

To delete a single value, call Properties.deleteProperty(key):

To delete all properties in the current store, call Properties.deleteAllProperties():

You can manually add up to fifty custom properties, as strings in key-value pairs, from the project settings page. To add more than fifty properties, you need to add them programmatically using the methods described above in Saving data. When you set script properties from the project settings page, you can’t reference script variables.

---

## Script Projects Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/guides/projects

**Contents:**
- Script Projects Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
- Create and delete projects
  - Create a standalone project
  - Create a standalone project from Google Drive
  - Create a container-bound project from Google Docs, Sheets, or Slides
  - Create a container-bound project from Google Forms
  - Create a standalone project using the clasp command line tool
  - Delete a container-bound project
  - Delete a standalone project

A script project in Google Apps Script is a collection of files and resources, including code (.gs) and HTML (.html) files.

You can create both standalone and container-bound script projects from various Google services or using the clasp command line tool.

Deleting script projects and files is a permanent action with no recovery option.

Project files can be managed within the Apps Script editor, including creating, deleting, and exporting.

The time zone for a project can be set in project settings, although specific functions can override this setting.

Multi-login with multiple Google Accounts can cause issues with accessing Apps Script, add-ons, and web apps.

A script project represents a collection of files and resources in Google Apps Script, sometimes referred to simply as "a script". A script project has one or more script files which can either be code files (having a .gs extension) or HTML files (a .html extension). You can also include JavaScript and CSS in HTML files.

The script editor always has one and only one project opened at any given time. You can open multiple projects in multiple browser windows or tabs.

This section explains how to create and delete standalone or container-bound Apps Script projects.

To create a standalone project from Apps Script:

clasp is a command line tool that allows you create, pull/push, and deploy Apps Script projects from a terminal.

See the Command Line Interface using clasp guide for more details.

To take code files out of Apps Script, you can either copy and paste the code from each file into your preferred text editor or use clasp on the command line. To use clasp, refer to download a script project.

You can set the time zone for an Apps Script project. Functions performed by the script use this time zone.

If you want a specific function to use a different time zone than the script project’s, explicitly enter the time zone in your function. For example, in the below sample, each function creates a new event in Google Calendar. The first function defaults to the project time zone. The second function specifies the Pacific time zone, so the event is scheduled in Pacific time, regardless of the project’s time zone.

If you're logged into multiple Google Accounts at the same time, you might have trouble accessing your add-ons and web apps. Multi-login, or being logged into multiple Google Accounts at once, isn't supported for Apps Script, add-ons, or web apps.

If you open the Apps Script editor while logged in to more than one account, Google prompts you to choose the account you want to proceed with.

If you open a web app or add-on and experience multi-login issues, try one of the following solutions:

**Examples:**

Example 1 (unknown):
```unknown
function createEvent(){
// Creates an event in the script project's time zone and logs the ID
var event = CalendarApp.getDefaultCalendar().createEvent('New test event',
   new Date('December 20, 2022 17:00:00'),
   new Date('December 20, 2022 18:00:00'));
console.log('Event ID: ' + event.getId());
}
function createEventPacific(){
// Creates an event with a specified time zone and logs the event ID.
var event = CalendarApp.getDefaultCalendar().createEvent('New sample event',
   new Date('December 20, 2022 17:00:00 PDT'),
   new Date('December 20, 2022 18:00:00 PDT'));
console.log('Event ID: ' + event.getId());
}
```

---

## Simple Triggers Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/guides/triggers

**Contents:**
- Simple Triggers Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
- Getting started
- Restrictions
- onOpen(e)
- onInstall(e)
- onEdit(e)
- onSelectionChange(e)
- doGet(e) and doPost(e)
- Available types of triggers

Simple triggers in Apps Script are reserved functions that run automatically on specific events like opening or editing a document.

Installable triggers offer more features than simple triggers but require activation.

Both simple and installable triggers pass an event object containing context information to the triggered function.

Simple triggers have restrictions, including limitations on services that require authorization and a maximum execution time of 30 seconds.

Triggers let Apps Script run a function automatically when a certain event, like opening a document, occurs. Simple triggers are a set of reserved functions built into Apps Script, like the function onOpen(e), which executes when a user opens a Google Docs, Sheets, Slides, or Forms file. Installable triggers offer more capabilities than simple triggers but must be activated before use. For both types of triggers, Apps Script passes the triggered function an event object that contains information about the context in which the event occurred.

To use a simple trigger, simply create a function that uses one of these reserved function names:

The e parameter in the function names above is an event object that is passed to the function. The object contains information about the context that caused the trigger to fire, but using it is optional.

Because simple triggers fire automatically, without asking the user for authorization, they are subject to several restrictions:

These restrictions do not apply to doGet(e) or doPost(e).

The onOpen(e) trigger runs automatically when a user opens a spreadsheet, document, presentation, or form that they have permission to edit. (The trigger does not run when responding to a form, only when opening the form to edit it.) onOpen(e) is most commonly used to add custom menu items to Google Sheets, Slides, Docs, or Forms.

The onInstall(e) trigger runs automatically when a user installs an Editor add-on from within Google Docs, Sheets, Slides, or Forms. The trigger won't run when a user installs the add-on from the Google Workspace Marketplace website. Note that there are certain restrictions on what onInstall(e) can do, learn more about authorization. The most common use of onInstall(e) is simply to call onOpen(e) to add custom menus. After all, when an add-on is installed, the file is already open, and thus onOpen(e) doesn't run on its own unless the file is reopened.

The onEdit(e) trigger runs automatically when a user changes the value of any cell in a spreadsheet. Most onEdit(e) triggers use the information in the event object to respond appropriately. For example, the onEdit(e) function below sets a comment on the cell that records the last time it was edited.

The onSelectionChange(e) trigger runs automatically when a user changes the selection in a spreadsheet. To activate this trigger, you must refresh the spreadsheet once the trigger is added and every time the spreadsheet is opened.

If the selection moves between multiple cells in a short time, some selection change events might be skipped to reduce latency. For example, if many selection changes are made within two seconds of each other, only the first and last selection changes will activate the onSelectionChange(e) trigger.

In the example below, if an empty cell is selected, the onSelectionChange(e) function sets the cell’s background to red.

The doGet(e) trigger runs automatically when a user visits a web app or a program sends an HTTP GET request to a web app. doPost(e) runs when a program sends an HTTP POST request to a web app. These triggers are demonstrated more in the guides to web apps, HTML service, and Content service. Note that doGet(e) and doPost(e) are not subject to the restrictions listed above.

If the restrictions on simple triggers keep them from meeting your needs, an installable trigger might work instead. The table below summarizes which types of triggers are available for each type of event. For example, Google Sheets, Slides, Forms, and Docs all support simple open triggers, but only Sheets, Docs and Forms support installable open triggers.

function onSelectionChange(e)

function onInstall(e)

* The open event for Google Forms does not occur when a user opens a form to respond, but rather when an editor opens the form to modify it.

---

## Troubleshooting Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/guides/support/troubleshooting

**Contents:**
- Troubleshooting Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
- Error messages
  - Syntax errors
  - Runtime errors
- Common errors
  - Service invoked too many times: <action name>
  - Server not available. or Server error occurred, please try again.
  - Authorization is required to perform that action.
  - Access denied: DriveApp or The domain policy has disabled third-party Drive apps

Troubleshooting is a vital part of development, involving finding, understanding, and debugging errors in scripts.

Errors displayed in scripts are primarily either syntax errors, which violate JavaScript grammar and are detected upon saving, or runtime errors, which occur during execution due to incorrect function or class usage.

Beyond explicit error messages, subtle errors can cause unexpected results, requiring debugging techniques like logging, checking executions, or using the debugger with breakpoints.

Issues can also arise from exceeding service quotas, temporary server unavailability, insufficient authorization, domain policies restricting services like Drive API, problems with user identity access, missing or deleted libraries, or using multiple Google Accounts simultaneously.

Even the most experienced developer rarely writes code correctly on the first try, making troubleshooting an important part of the development process. In this section we'll cover some techniques that can help you find, understand, and debug errors in your scripts.

When your script encounters an error, an error message is displayed. The message is accompanied by a line number used for troubleshooting. There are two basic types of errors displayed in this way: syntax errors and runtime errors.

Syntax errors are caused by writing code that doesn't follow the JavaScript grammar, and the errors are detected as soon as you try to save the script. For example, the following code snippet contains a syntax error:

The syntax problem here is a missing ) character at the end of the fourth line. When you try to save the script you'll get the following error:

Missing ) after argument list. (line 4)

These types of errors are usually simple to troubleshoot, since they are found right away and typically have simple causes. You aren't able to save a file that contains syntax errors, meaning that only valid code is saved into your project.

These errors are caused by using a function or class incorrectly, and can only be detected once the script has been run. For example, the following code causes a runtime error:

The code is formatted correctly, but we are passing the value "john" for the email address when calling MailApp.sendEmail. Since this is not a valid email address the following error is thrown when running the script:

Invalid email: john (line 5)

What makes these errors more challenging to troubleshoot is that often the data you are passing into a function is not written in the code, but instead pulled from a spreadsheet, form, or other external data source. Using the debugging techniques below can help you to identify the cause of these errors.

Below is a list of common errors and their causes.

This error indicates that you have exceeded your daily quota for a given action. For example, you might encounter this error if you send too many emails in a single day. The quotas are set at different levels for consumer, domain, and premier accounts and are subject to change at any time without a prior announcement by Google. You can view the quota limits for various actions in the Apps Script quota documentation.

There are a few possible causes for these errors:

This error indicates that the script is lacking the authorization needed to run. When a script is run in the Script Editor or from a custom menu item an authorization dialog is presented to the user. However, when a script is run from a trigger, embedded with a Google Sites page, or run as a service, the dialog cannot be presented and this error is shown.

To authorize the script, open the Script Editor and run any function. The authorization prompt appears so you can authorize the script project. If the script contains new unauthorized services, you must re-authorize the script.

This error is frequently caused by triggers that are either firing before the user has authorized them or their authorization has expired. If you don't have access to the script project (because the error is occurring for an add-on you use, for example), you can usually authorize the script by using the add-on again. If a trigger continues to fire and cause this error, you can remove your triggers by doing the following:

You can also remove problematic add-on triggers by uninstalling the add-on.

Granular permissions could also cause these errors. Apps Script would automatically request the missing permissions from the user, unless the execution is invoked by a trigger. See our authorization scopes page to protect trigger executions from this error.

Administrators of Google Workspace domains have the ability to disable the Drive API for their domain, which prevents their users from installing and using Google Drive apps. This setting also prevents the users from being able to use Apps Script add-ons that use the Drive service or Advanced Drive Service (even if the script was authorized prior to the admin disabling Drive API).

However, if an add-on or web app using the Drive service is published for domain-wide installation and is installed by the administrator for some or all users in the domain, the script functions for those users even if the Drive API is disabled in the domain.

Indicates that the active user's identity and email are not available to the script. This warning results from a call to Session.getActiveUser(). It can also result from a call to Session.getEffectiveUser() if the script is running in an authorization mode other than AuthMode.FULL. If this warning is signaled, subsequent calls to User.getEmail() only return "".

There are a number of ways to troubleshoot this warning, depending on the authorization mode the script is running under. The authorization mode is exposed in triggered functions as the authMode property of the e event parameter.

If you add a popular library to your script, you might receive an error message stating that it's missing, even though the library is listed as a dependency for your script. The reason might be that too many people are accessing the library at the same time. To avoid this error, try one of the following solutions:

This error message indicates one of the following:

If you encounter Error 400: invalid_scope with the error message Some requested scopes cannot be shown, it means you haven't specified any authorization scopes in the Apps Script project's appsscript.json file. In most cases, Apps Script automatically determines what scopes a script needs, but when you use the Chat advanced service, you must manually add the authorization scopes that your script uses to your Apps Script project's manifest file. See Setting explicit scopes.

To resolve the error, add the appropriate authorization scopes to the Apps Script project's appsscript.json file as part of the oauthScopes array. For example, to call the spaces.messages.create method, add the following:

Google Workspace administrators can turn on an allowlist in the admin console to control which external domains you can access through Apps Script.

To resolve the error, contact your administrator to have them add the URL to the allowlist.

Not all mistakes cause an error message to be displayed. There might be a more subtle error where the code is technically correct and can execute, but the results are not what you expect. Here are some strategies for handling such situations and further investigating a script that is not running the way you expect.

While debugging it's often helpful to record information as a script project executes. Google Apps Script has two methods for logging information: the Cloud logging service and the more basic Logger and console services that are built in to the Apps Script editor.

See the Logging guide for more details.

Exceptions that occur because of runtime errors are automatically recorded using the Google Cloud Error Reporting service. This service lets you search and filter exception messages your script project creates.

To access Error Reporting, see View Cloud logs and error reports in the Google Cloud Platform console.

Every time you run a script, Apps Script makes a record of the execution, including the Cloud logs. These records can help you understand which actions your script performed.

To view the executions of your script in the Apps Script project, at the left, click Executions playlist_play.

Although rare, sometimes specific Google Workspace services (such as Gmail or Drive) encounter temporary problems that can lead to service outages. When this occurs, Apps Script projects that interact with these services may not function as expected.

You can check if there is a Google Workspace service outage by viewing the Google Workspace Status Dashboard. If an outage is currently being experienced, you either wait for it to be resolved or seek additional help in the Google Workspace Help Center or the Google Workspace Known Issues documentation.

To locate problems in your script, you can run it in debug mode. When run in debug mode, a script pauses when it hits a breakpoint, which is a line you've highlighted in your script that you think may have a problem. When a script pauses it displays the value of each variable at that point in time, allowing you to inspect the inner workings of a script without having to add a lot of logging statements.

To add a breakpoint, hover over the line number of the line you want to add the breakpoint to. At the left of the line number, click the circle. The below image shows an example of a breakpoint added to a script:

To run the script in debug mode, at the top of the editor click Debug.

Before the script runs the line with the breakpoint it pauses and displays a table of debug information. You can use this table to inspect data like the values of parameters and the information stored in objects.

To control how the script is run, at the top of the Debugger panel, use the "Step in", "Step over", and "Step out" buttons. These let you run the script one line at a time and inspect how values change over time.

This error appears when an active debugging file is not available. Google Apps Script does not support displaying dynamically generated JavaScript (JS) scripts in the script editor, such as those generated using eval() and new Function(). These scripts are created and executed within the V8 engine but are not represented as standalone files in the editor. If you step-into these scripts, you will encounter this error.

For example, consider the following code:

When eval() is invoked, its argument is treated as JS code and runs as a dynamically created script inside the V8 engine. If you step-into eval(), this error appears. If the script includes a //# sourceURL comment, its name is shown in the call stack. Otherwise, it appears as an unnamed entry.

Despite the error message, the debugging session remains active, and execution can continue. To proceed, continue to step in, step out or resume execution. However, this error continues to appear as long as the execution remains within the scope of the dynamic script. After execution moves out of the dynamic script, debugging continues without this error.

If you're logged into multiple Google Accounts at the same time, you might have trouble accessing your add-ons and web apps. Multi-login, or being logged into multiple Google Accounts at once, isn't supported for Apps Script, add-ons, or web apps.

If you open the Apps Script editor while logged in to more than one account, Google prompts you to choose the account you want to proceed with.

If you open a web app or add-on and experience multi-login issues, try one of the following solutions:

Debugging a problem using the tools and techniques listed above can solve a variety of problems, but there may be issues you run into that require some extra help to solve. See our Support page for information on where to ask questions and file bugs.

**Examples:**

Example 1 (unknown):
```unknown
function emailDataRow(rowNumber) {
  var sheet = SpreadsheetApp.getActiveSheet();
  var data = sheet.getDataRange().getValues();
  var rowData = data[rowNumber-1].join(" ";
  MailApp.sendEmail('john@example.com',
                    'Data in row ' + rowNumber,
                    rowData);
}
```

Example 2 (unknown):
```unknown
function emailDataRow(rowNumber) {
  var sheet = SpreadsheetApp.getActiveSheet();
  var data = sheet.getDataRange().getValues();
  var rowData = data[rowNumber-1].join(" ");
  MailApp.sendEmail('john',
                    'Data in row ' + rowNumber,
                    rowData);
}
```

Example 3 (unknown):
```unknown
"oauthScopes": [
  "https://www.googleapis.com/auth/chat.messages.create"
]
```

Example 4 (unknown):
```unknown
function myFunction() {
  eval('a=2');
}
```

---

## Use Connected Sheets Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/guides/sheets/connected-sheets

**Contents:**
- Use Connected Sheets Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
- Common Connected Sheets actions
- Add required authorization scopes
  - Add additional OAuth scopes to the manifest file
- Example: Create and refresh a data source object
  - Add a data source
    - BigQuery
    - Looker
  - Add a data source object

Connected Sheets allows you to analyze BigQuery and Looker data directly within Google Sheets and is accessible programmatically using the Spreadsheet service.

Common actions with Connected Sheets, such as connecting to a data source or adding charts, are performed using specific DataSource classes and methods in Apps Script.

To access BigQuery or Looker data, you must include enableBigQueryExecution() or enableLookerExecution() respectively in your Apps Script code, which adds the necessary OAuth scopes.

Data source objects can be added and refreshed asynchronously, with methods available to check the execution status and handle errors.

Triggers, including time-driven and event triggers, can be used to automate data source functions, such as refreshing data on a schedule or when a parameter is edited.

Connected Sheets is a Google Sheets feature that lets you analyze BigQuery and Looker data directly within Sheets. You can access Connected Sheets programmatically with the Spreadsheet service.

Use the DataSource classes and objects to connect to BigQuery or Looker and analyze data. The following table lists the most common DataSource actions and how to create them in Apps Script:

To access BigQuery data, you must include the enableBigQueryExecution() method in your Google Apps Script code. This method adds the required bigquery.readonly OAuth scope to your Google Apps Script project.

The following sample shows the SpreadsheetApp.enableBigQueryExecution() method called within a function:

To access Looker data, you must include the enableLookerExecution() method in your Google Apps Script code. Accessing Looker in Apps Script will reuse your existing Google Account Link with Looker.

The following sample shows the SpreadsheetApp.enableLookerExecution() method called within a function:

When connecting with BigQuery, most OAuth scopes are automatically added to the manifest file based on the functions used in your code. If you need additional scopes to access certain BigQuery data, you can set explicit scopes.

For example, to query BigQuery data hosted within Google Drive, you must add a Drive OAuth scope to your manifest file.

The following sample shows the oauthScopes portion of a manifest file. It adds a drive OAuth scope in addition to the minimum required spreadsheet and bigquery.readonly OAuth scopes:

The following examples shows how to add a data source, create a data source object from the data source, refresh the data source object, and get the execution status.

The following examples show how to add a BigQuery and a Looker data source respectively.

To add a BigQuery data source to a spreadsheet, insert a data source sheet with a data source spec. The data source sheet is automatically refreshed to fetch preview data.

Replace <YOUR_PROJECT_ID> below with a valid Google Cloud project ID.

To add a Looker data source to a spreadsheet, insert a data source sheet with a data source spec. The data source sheet is automatically refreshed to fetch preview data.

Replace <INSTANCE_URL>,<MODEL_NAME>, <EXPLORE_NAME> in the following sample with a valid Looker instance URL, model name and explore name respectively.

Once the data source is added to the spreadsheet, data source objects can be created from the data source. In this example, a pivot table is created using DataSourcePivotTable on the BigQuery dataSource created in the code sample which adds a BigQuery datasource.

Unlike regular data in grid sheets that are referenced by cell index or A1 notations, data from data sources are usually referenced by column names. Therefore, most property setters on data source objects use column name as input.

You can refresh data source objects to fetch the latest data from BigQuery based on the data source specs and object configurations.

The process to refresh data is asynchronous. To refresh a data source object, use the following methods:

The sample below illustrates a refresh of the pivot table data:

Automate your Connected Sheets data source functions with triggers and events. For example, use time-driven triggers to refresh data source objects repeatedly at a specific time, and use spreadsheet event triggers to trigger data execution on a predefined event.

The following sample adds a BigQuery data source with a query parameter and refreshes the data source sheet when the query parameter is edited.

Replace <YOUR_PROJECT_ID> below with a valid Google Cloud project ID.

In the above sample, the addDataSource() function adds a data source to the spreadsheet. After you execute addDataSource(), create an event trigger in the Apps Script editor. To learn how to create an event trigger, see Installable triggers.

Select the following options for your trigger:

Once the trigger is created, the data source sheet refreshes automatically every time the parameter cell is edited.

**Examples:**

Example 1 (unknown):
```unknown
// For operations that fetch data from BigQuery, enableBigQueryExecution() must be called.
SpreadsheetApp.enableBigQueryExecution();
var spreadsheet = SpreadsheetApp.create('Test connected sheets');
Logger.log('New test spreadsheet: %s', spreadsheet.getUrl());

// Build data source spec by selecting a table.
var dataSourceSpec = SpreadsheetApp.newDataSourceSpec()
    .asBigQuery()
    .setProjectId('<YOUR_PROJECT_ID>')
    .setTableProjectId('bigquery-public-data')
    .setDatasetId('ncaa_basketball')
    .setTableId('mbb_historical_tournament_games')
    .build();
// Add data source and its associated data source sheet.
var dataSourceSheet = spreadsheet.insertDataSourceSheet(dataSourceSpec);
var dataSource = dataSourceSheet.getDataSource();
```

Example 2 (unknown):
```unknown
// For operations that fetch data from Looker, enableLookerExecution() must be called.
SpreadsheetApp.enableLookerExecution();
var spreadsheet = SpreadsheetApp.create('Test connected sheets');
Logger.log('New test spreadsheet: %s', spreadsheet.getUrl());

// Build data source spec by selecting a table.
var dataSourceSpec = SpreadsheetApp.newDataSourceSpec()
    .asLooker()
    .setInstanceUrl('<INSTANCE_URL>')
    .setModelName('<MODEL_NAME>')
    .setExploreName('<EXPLORE_NAME>')
    .build();
// Add data source and its associated data source sheet.
var dataSourceSheet = spreadsheet.insertDataSourceSheet(dataSourceSpec);
var dataSource = dataSourceSheet.getDataSource();
```

Example 3 (unknown):
```unknown
var rootCell = spreadsheet.insertSheet('pivotTableSheet').getRange('A1');

// Add data source pivot table and set data source specific configurations.
var dataSourcePivotTable = rootCell.createDataSourcePivotTable(dataSource);
var rowGroup = dataSourcePivotTable.addRowGroup('season');
rowGroup.sortDescending().setGroupLimit(5);
dataSourcePivotTable.addColumnGroup('win_school_ncaa');
dataSourcePivotTable.addPivotValue('win_pts', SpreadsheetApp.PivotTableSummarizeFunction.AVERAGE);
dataSourcePivotTable.addPivotValue('game_date', SpreadsheetApp.PivotTableSummarizeFunction.COUNTA);
var filterCriteria = SpreadsheetApp.newFilterCriteria()
    .whenTextEqualToAny(['Duke', 'North Carolina'])
    .build();
dataSourcePivotTable.addFilter('win_school_ncaa', filterCriteria);

// Get a regular pivot table instance and set shared configurations.
var pivotTable = dataSourcePivotTable.asPivotTable();
pivotTable.setValuesDisplayOrientation(SpreadsheetApp.Dimension.ROWS);
```

Example 4 (unknown):
```unknown
var status = dataSourcePivotTable.getStatus();
Logger.log('Initial state: %s', status.getExecutionState());

dataSourcePivotTable.refreshData();

status = dataSourcePivotTable.waitForCompletion(/* timeoutInSeconds= */ 60);
Logger.log('Ending state: %s', status.getExecutionState());
if (status.getExecutionState() == SpreadsheetApp.DataExecutionState.ERROR) {
  Logger.log('Error: %s (%s)', status.getErrorCode(), status.getErrorMessage());
}
```

---

## V8 runtime overview Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/guides/v8-runtime

**Contents:**
- V8 runtime overview Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
- Features of the V8 runtime
  - Modern ECMAScript syntax
  - Improved function detection
  - Call object methods from triggers and callbacks
  - View logs
  - View executions
- V8 syntax examples
  - let and const

The Apps Script and JavaScript runtime environment includes the JavaScript engine that parses and executes script code, and historically Apps Script was powered by Mozilla's Rhino JavaScript interpreter.

Apps Script now supports the V8 runtime, which powers Chrome and Node.js, enabling developers to use modern JavaScript syntax and features not available with the older Rhino runtime.

Scripts using the V8 runtime benefit from modern ECMAScript syntax, improved function detection, the ability to call object methods from triggers and callbacks, and standard logging and execution viewing capabilities.

You can enable the V8 runtime for your Apps Script project through project settings or by editing the appsscript.json manifest file.

Existing scripts can be migrated to V8 to take advantage of new features, and automatic migration for compatible scripts began in February 2020, with an option to opt out.

In Apps Script and JavaScript, a runtime or runtime environment contains the JavaScript engine that parses and executes script code. The runtime provides rules for how memory is accessed, how the program can interact with the computer's operating system, and what program syntax is legal. Each web browser has a runtime environment for JavaScript.

Historically, Apps Script has been powered by Mozilla's Rhino JavaScript interpreter. While Rhino provided a convenient way for Apps Script to execute developer scripts, it also tied Apps Script to a specific JavaScript version (ES5). Apps Script developers can't use more modern JavaScript syntax and features in scripts using the Rhino runtime.

To address this concern, Apps Script is now supported by the V8 runtime that powers Chrome and Node.js. You can migrate existing scripts to V8 in order to take advantage of the modern JavaScript syntax and features.

This page describes the new features enabled by V8 and how you can enable V8 for use in your scripts. Migrating scripts to V8 describes steps for migrating existing scripts to use the V8 runtime.

Scripts that use the V8 runtime are able to take advantage of the following features:

You can use modern ECMAScript syntax in scripts that are powered by the V8 runtime. This syntax includes let, const, and many other popular features.

See V8 syntax examples for a short list of popular syntax improvements you can make using the V8 runtime.

Apps Script function detection is improved for scripts using V8. The new runtime recognizes these function definition formats:

Scripts using V8 can call object methods and class static methods from places where you could already call library methods. These places include the following:

The following V8 example shows the use of object methods when constructing menu items in Google Sheets:

Apps Script provides two logging services: the Logger service and the console class. Both of these services write logs to the same Stackdriver Logging service.

To show Logger and console logs, at the top of the script editor, click Execution log.

To view your script's execution history, open the Apps Script project and at the left, click Executions playlist_play.

The following is a short list of popular syntactical features available to scripts using the V8 runtime.

The let and const keywords allow you to define block scope local variables and block scope constants, respectively.

Arrow functions provide a compact way of defining functions within expressions.

Classes provide a means to conceptually organize code with inheritance. Classes in V8 are primarily syntactical sugar over the JavaScript prototype-based inheritance.

Destructuring assignment expressions are a quick way to unpack values from arrays and objects into distinct variables.

Template literals are string literals that allow embedded expressions. They let you avoid more complex string concatenation statements.

Default parameters let you specify default values for function parameters in the function declaration. This can simplify the code in the function body as it removes the need to explicitly assign default values to missing parameters.

You can define multi-line strings using the same syntax as template literals. As with template literals, this syntax lets you avoid string concatenations and simplify string definitions.

If a script is using the Rhino runtime, you can switch it to V8 by doing the following:

Alternatively you can specify the script runtime directly by editing the script manifest file:

Migrating scripts to V8 explains other steps you should take to ensure your script functions well using V8.

If your script is using V8 and you need to switch it to use the original Rhino runtime, do the following:

Alternatively, edit your script manifest:

The Migrating scripts to V8 guide describes the steps you need to take to migrate an existing script to use V8. This involves enabling the V8 runtime and checking the script for any known incompatibilities.

Starting February 18, 2020 Google will start gradually migrating existing scripts that pass our automated compatibility test to V8. The affected scripts continue to function normally after migration.

If you want to opt a script out of automatic migration, set the runtimeVersion field in its manifest to DEPRECATED_ES5. You can choose to manually migrate the script to V8 at any time thereafter.

The Support guide explains how to get programming help on Stack Overflow, search existing issue reports, file new bugs, and make new feature requests.

**Examples:**

Example 1 (javascript):
```javascript
function onOpen() {
  const ui = SpreadsheetApp.getUi(); // Or DocumentApp, SlidesApp, or FormApp.
  ui.createMenu('Custom Menu')
      .addItem('First item', 'menu.item1')
      .addSeparator()
      .addSubMenu(ui.createMenu('Sub-menu')
          .addItem('Second item', 'menu.item2'))
      .addToUi();
}

const menu = {
  item1: function() {
    SpreadsheetApp.getUi().alert('You clicked: First item');
  },
  item2: function() {
    SpreadsheetApp.getUi().alert('You clicked: Second item');
  }
}
```

---

## Versions Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/guides/versions

**Contents:**
- Versions Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
- Create a version
- View a previous version
- Compare a previous version to the current version
- Restore a version
- Delete versions
  - Delete a version
  - Delete multiple versions at once

Versions are static copies of a script that track changes and cannot be modified once saved.

You can create a new version from an existing deployment in your script project.

You can view, compare to the current version, and restore previous versions through the Project History.

Versions can be permanently deleted if they are not being used by an active deployment.

A version is a static copy of a script. Versions let you track your changes. Once you save a version, you can't modify it. Use versions when you're working on a script that goes through many changes and iterations. Script projects can have up to 200 versions.

Creating versions is required when you're writing a library. For more information, see Libraries.

A version is automatically created when you create a new deployment. You can also create a new version from an existing deployment by taking the following steps:

To view a previously created version within your script project, take the following steps:

To compare a previously created version to the current, or head, version, take the following steps:

Depending on the changes you've made since the selected version, the files list might contain the following markers:

You can permanently delete versions if they're not in use by an active deployment. To archive a deployment or change the version that an active deployment uses, refer to Create and manage deployments.

To delete one version at a time, take the following steps:

To delete multiple versions at the same time, take the following steps:

---

## Work with tabs Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/guides/docs/tabs

**Contents:**
- Work with tabs Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
- What are tabs?
- Access Tabs
  - Tab properties
  - Tab contents
  - Tab hierarchy
  - Other ways of retrieving tabs
- Changes to Document Class structure
  - Access text content within a specific Tab

Apps Script for Google Docs allows access to content from any tab within a document.

Google Docs introduces tabs as an organizational layer within a single document, similar to Sheets.

Tab properties, content, and hierarchy (including child tabs) are accessible through Document.getTabs() and methods of the Tab and DocumentTab classes.

Existing methods on the Document class now operate on the active tab (or the first tab), and accessing content within a specific tab is recommended using Tab.asDocumentTab().

User selection, including cursor position and selection range, operates within the context of the active tab, and the active tab itself can be set using Document.setActiveTab(tabId).

Apps Script for Google Docs lets you access content from any tab in the document.

Google Docs features an organizational layer called tabs. Docs allows users to create one or more tabs within a single document, similar to how there are tabs in Sheets today. Each tab has its own title and an ID (appended in the URL). A tab can also have child tabs, which are tabs that are nested beneath another tab.

Tab properties and content are accessible with Document.getTabs(), which returns a list of Tabs. The later sections give a brief overview of the Tab class; the Tab class documentation also provides more detailed information.

Tab properties can be retrieved using methods such as Tab.getId() and Tab.getTitle().

Document content within each tab can be retrieved using Tab.asDocumentTab(). The Changes to Document Class structure section describes how this can be used.

Child tabs are exposed in Google Apps Script through Tab.getChildTabs(). Accessing content from all tabs requires traversing the "tree" of child tabs. For example, consider a document that contains a tab hierarchy as follows:

In order to access Tab 3.1.2, you could do the following:

See the sample code blocks in the later sections, which provides sample code for iterating across all tabs in a document.

There are two other ways of retrieving tabs:

In the past, documents did not have a concept of tabs, so the Document Class exposed methods to directly access and modify the text contents of the document. The following methods fall into this category:

With the additional structural hierarchy of tabs, these methods no longer semantically represent the text content from all tabs in the document. The text content will now be represented in a different layer; all of the aforementioned text methods are accessible through DocumentTab.

These existing methods on the Document class will access or modify content from either the active tab (in scripts bound to a particular document) or the first tab (if an active one is not available).

Instead of using the text methods off of Document, it is recommended to use the methods that are available off of the DocumentTab class instead (which is available through the Tab.asDocumentTab() method). For example:

The Document class provides getters and setters to manage where in the text the user is selecting, within the active document. These methods operate within the context of the active tab of the user running the script.

With the introduction of tabs, it may be useful to get and set the active tab of the user running the script. This can be done using the following methods:

The user's holistic "selection" is made up of a combination of the active tab along with either the current cursor position or selection range. The two patterns for working with an active selection is to either explicitly modify the user's active tab to a specific tab or use the user's active tab.

Explicitly changing the user's active tab can be done by using Document.setActiveTab(tabId). Alternatively, calling Document.setCursor(position) or Document.setSelection(range) with a Position or Range from an inactive tab will make that tab newly active.

If the intended behavior of the script is to use the user's active tab without changing it, then Document.setActiveTab(tabId) is not necessary. The Document.getCursor() and Document.getSelection() methods will already be operating over the active tab, based on the tab that the user is running the script from.

Note that a document does not support multiple tab selections or multiple positions or ranges across different tabs. Therefore, using Document.setActiveTab(tabId) will clear out the previous cursor position or selection range.

The specific tab is what gives meaning to the text selection concepts of Position and Range. In other words, a cursor position or a selection range are only meaningful if the script knows the specific tab that the position or range is within.

This is achieved by using the DocumentTab.newPosition(element, offset) and DocumentTab.newRange() methods, which construct a Position or Range that targets the specific DocumentTab that the method is called from. In contrast, Document.newPosition(element, offset) and Document.newRange() will construct a Position or Range that targets the active tab (or the first tab, if the script is not bound).

See the sample code blocks in the later sections, which provides sample code for working with selections.

The following code samples describe various ways of interacting with tabs.

Existing code that did this before the tabs feature can be migrated to support tabs by traversing the tabs tree and calling getter methods off of Tab and DocumentTab instead of Document. The following partial code sample shows how to print all of the text contents from every tab in a document. This tab traversal code can be adapted for many other use cases which don't care about the actual structure of the tabs.

This is similar to reading all tabs.

The following partial code sample shows how to target a specific tab when making updates.

The following partial code sample shows how to target the active tab when making updates.

The following partial code sample shows how to update the cursor position or the selection range within the user's active tab. This is only relevant in bound scripts.

The following partial code sample shows how to change the user's active tab. This is only relevant in bound scripts.

Only changes the selection if there is a tab following the

---
