# Google-Apps-Script - Reference

**Pages:** 174

---

## AddOns manifest resource Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/manifest/addons

**Contents:**
- AddOns manifest resource Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
- AddOns
  - Common
  - LayoutProperties
  - UniversalAction

Google Workspace add-on manifests define the content and behavior of add-ons and must include all required components.

The AddOns top-level configuration includes sections for common settings and configurations for specific Google Workspace host applications like Calendar, Chat, Drive, Gmail, Docs, Sheets, Slides, and Meet.

The Common section defines general settings for the add-on that apply across all host applications, including the homepage trigger, layout properties, logo URL, name, allowed outbound link URL prefixes, and universal actions.

The LayoutProperties configuration controls the color scheme for the add-on's toolbar and buttons using primary and secondary color settings.

A UniversalAction allows defining actions available in the add-on UI that either open a specified URL or run an Apps Script function.

The resource configuration that is used to define Google Workspace add-on content and behavior. Google Workspace add-on manifests must have all the components marked as Required.

The top-level of the Google Workspace add-on manifest configuration.

Required. Defines values for a Google Workspace add-on that are common for every host application. Some values defined here are used as a default when specific values for a particular host are omitted.

Required if the Google Workspace add-on extends Calendar. Configurations for Google Workspace add-on appearance and behavior within the Google Calendar host application. If this field is omitted, the add-on is disabled in Google Calendar.

Required if the Google Workspace add-on extends Chat. Configuration of a Google Chat app. If this field is omitted, the add-on is disabled in Google Chat. The addOns.chat object must be empty. To configure the add-on's behavior and appearance in Chat, see Configure a Google Chat app.

The addOns.chat object must be empty. To configure the add-on's behavior and appearance in Chat, see Configure a Google Chat app.

Required if the Google Workspace add-on extends Drive. Configurations for Google Workspace add-on appearance and behavior within the Drive host application. If this field is omitted, the add-on is disabled in Drive.

Required if the Google Workspace add-on extends Gmail. Configurations for Google Workspace add-on appearance and behavior within the Gmail host application. If this field is omitted, the add-on is disabled in Gmail.

Required if the Google Workspace add-on extends Docs. Configurations for the Google Workspace add-on's appearance and behavior within the Docs host application. If this field is omitted, the add-on is disabled in Docs.

Required if the Google Workspace add-on extends Sheets. Configurations for the Google Workspace add-on's appearance and behavior within the Sheets host application. If this field is omitted, the add-on is disabled in Sheets.

Required if the Google Workspace add-on extends Slides. Configurations for the Google Workspace add-on's appearance and behavior within the Slides host application. If this field is omitted, the add-on is disabled in Slides.

Required if the Google Workspace add-on extends Meet. Configurations for Google Workspace add-on appearance and behavior within the Meet host application. If this field is omitted, the add-on is disabled in Meet.

The manifest configuration for parameters that are common for every host application. Some values defined here are used as a default when specific values for a particular host are omitted.

object (HomepageTrigger)

object (LayoutProperties)

Required. The URL of the image shown in the toolbar. The URL must be public.

Required. The name of the add-on shown in the toolbar.

Required if the add-on displays any outbound links, whether within widgets using an OpenLink or text widget using HTML anchor tags. A list of HTTPS URL prefixes. To protect user data, any link rendered by the add-on must match one of the prefixes in this list.

See Allowlist URLs for more details.

object (UniversalAction)

If true, add-on event objects passed to action callback functions or trigger functions include the locale and timezone information of the user. Defaults to false.

See Accessing user locale and timezone for more details.

A configuration that controls the Google Workspace add-on toolbar and button colors and appearance.

A configuration for a universal action. When selected, a universal action either opens the specified URL link, or runs the specified Apps Script function.

See the Universal actions guide for details.

---

## Add-ons overview Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/add-ons/overview

**Contents:**
- Add-ons overview Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
- Add new capabilities to Google Workspace
- Types of add-ons
- Google Workspace add-ons API
- Try a quickstart

Google Workspace add-ons are custom applications that enhance Google Workspace functionality by automating tasks, connecting to third-party services, and streamlining workflows.

Add-ons provide customized user interfaces within Google Workspace, eliminating the need to switch between applications.

Developers can build two types of add-ons: Google Workspace add-ons and Editor add-ons, each offering unique capabilities and functionalities.

The Google Workspace add-ons API enables developers to automate tasks, manage deployments, and control data flow within Google Workspace.

Quickstart guides are available for developers to learn how to build Google Workspace add-ons using Node.js or Apps Script.

Add-ons are customized applications that extend Google Workspace applications.

Add-ons can help automate tasks or make third-party services or information available in Google Workspace. With add-ons, you can do the following:

There are two types of add-ons you can build: Google Workspace add-ons and Editor add-ons. For more information about each, see Add-on types.

With the Google Workspace add-ons API, you can:

For more information about the Google Workspace add-ons API, see the Reference documentation.

To quickly see how building an add-on works, try a quickstart:

---

## Advanced Chat Service Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/advanced/chat

**Contents:**
- Advanced Chat Service Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
- Prerequisites
- Reference
- Sample code
  - Post a message with user credentials
  - Post a message with app credentials
  - Get a space
  - Create a space
  - List memberships

The Advanced Chat service allows using the Google Chat API in Apps Script to manage Chat spaces, members, and messages.

Prerequisites include a configured Google Chat app in the Google Cloud console using a standard Google Cloud project and proper authentication set up.

This is an advanced service that must be explicitly turned on before use.

Sample code demonstrates how to perform common Chat API actions, such as posting messages, getting a space, creating a space, and listing memberships.

Troubleshoot Error 400: invalid_scope by manually adding required authorization scopes to the Apps Script project's appsscript.json file.

The Advanced Chat service has limitations and does not support the media.download method or Developer Preview methods, which require using UrlFetchApp.

The Advanced Chat service lets you use the Google Chat API in Apps Script. This API allows scripts to find, create, and modify Chat spaces, add or remove members to spaces, and read or post messages with text, cards, attachments, and reactions.

For more information about this service, see the Chat API reference documentation. Like all advanced services in Apps Script, the Chat service uses the same objects, methods, and parameters as the public API.

These samples show you how to perform common Google Chat API actions using the advanced service.

The following example demonstrates how to post a message to a Chat space on behalf of the user.

Add the chat.messages.create authorization scope to the Apps Script project's appsscript.json file:

Add a function like this one to the Apps Script project's code:

The following example demonstrates how to post a message to a Chat space on behalf of the app. Using the advanced Chat service with a service account doesn't require you to specify authorization scopes in appsscript.json. For details about authentication with service accounts, see Authenticate as a Google Chat app.

The following example demonstrates how to get information about a Chat space.

Add the chat.spaces.readonly authorization scope to the Apps Script project's appsscript.json file:

Add a function like this one to the Apps Script project's code:

The following example demonstrates how to create a Chat space.

Add the chat.spaces.create authorization scope to the Apps Script project's appsscript.json file:

Add a function like this one to the Apps Script project's code:

The following example demonstrates how to list all the members of a Chat space.

Add the chat.memberships.readonly authorization scope to the Apps Script project's appsscript.json file:

Add a function like this one to the Apps Script project's code:

If you encounter Error 400: invalid_scope with the error message Some requested scopes cannot be shown, it means you haven't specified any authorization scopes in the Apps Script project's appsscript.json file. In most cases, Apps Script automatically determines what scopes a script needs, but when you use the Chat advanced service, you must manually add the authorization scopes that your script uses to your Apps Script project's manifest file. See Setting explicit scopes.

To resolve the error, add the appropriate authorization scopes to the Apps Script project's appsscript.json file as part of the oauthScopes array. For example, to call the spaces.messages.create method, add the following:

The Advanced Chat service doesn't support:

To download a message attachment or call a developer preview method, use UrlFetchApp instead.

**Examples:**

Example 1 (unknown):
```unknown
"oauthScopes": [
  "https://www.googleapis.com/auth/chat.messages.create"
]
```

Example 2 (unknown):
```unknown
"oauthScopes": [
  "https://www.googleapis.com/auth/chat.spaces.readonly"
]
```

Example 3 (unknown):
```unknown
"oauthScopes": [
  "https://www.googleapis.com/auth/chat.spaces.create"
]
```

Example 4 (unknown):
```unknown
"oauthScopes": [
  "https://www.googleapis.com/auth/chat.memberships.readonly"
]
```

---

## Advanced Drive Service Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/advanced/drive

**Contents:**
- Advanced Drive Service Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
- Reference
- Sample code
  - Upload files
  - List folders
  - List revisions
  - Add file properties

The advanced Drive service in Apps Script allows interaction with the Google Drive API for file and folder manipulation.

This service offers extra features compared to the built-in Drive service, such as access to custom file properties and revisions.

The advanced Drive service must be enabled before use and uses the same objects, methods, and parameters as the public Drive API.

Sample code is provided for common tasks like uploading files, listing folders, listing revisions, and adding file properties using API version 3.

The advanced Drive service lets you use the Google Drive API in Apps Script. Much like Apps Script's built-in Drive service, this API allows scripts to create, find, and modify files and folders in Google Drive. In most cases, the built-in service is easier to use, but this advanced service provides a few extra features, including access to custom file properties as well as revisions for files and folders.

For detailed information on this service, see the reference documentation for the Google Drive API. Like all advanced services in Apps Script, the advanced Drive service uses the same objects, methods, and parameters as the public API. For more information, see How method signatures are determined.

To report issues and find other support, see the Drive API support guide.

The code samples in this section use version 3 of the API.

The following code sample shows how to save a file to a user's Drive.

The following code sample shows how to list the top-level folders in the user's Drive. Note the use of page tokens to access the full list of results.

The following code sample shows how to list the revisions for a given file. Note that some files can have several revisions and you should use page tokens to access the full list of results.

The following code sample uses the appProperties field to add a custom property to a file. The custom property is only visible to the script. To add a custom property to the file that's also visible to other apps, use the properties field, instead. For more information, see Add custom file properties.

---

## Advanced Google Workspace Events Service Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/advanced/events

**Contents:**
- Advanced Google Workspace Events Service Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
- Prerequisites
- Reference
- Sample code
  - Create a subscription
  - List subscriptions
  - Get subscription
  - Update subscription
  - Reactivate subscription

The Advanced Google Workspace Events service allows Apps Script to use the Google Workspace Events API to subscribe to resource changes like creations, updates, or deletions.

Using this service requires an Apps Script project with a standard Google Cloud project, a Pub/Sub topic, and necessary authorization scopes.

Specific prerequisites exist for subscribing to Chat events, including a configured Google Chat app.

Sample code is provided for common actions such as creating, listing, getting, updating, reactivating, and deleting subscriptions, as well as getting operation details.

The Advanced Google Workspace Events service lets you use the Google Workspace Events API in Apps Script. This API lets you subscribe to Google Workspace resources so that you receive relevant events that you're interested in. Events represent changes to resources, such as when resources are created, updated, or deleted.

The necessary authorization scopes added to the Apps Script project's appsscript.json file. The necessary scopes depend on the types of the subscriptions' target resources and events. For details, see Choose Google Workspace Events API scopes. For example:

For more information about this service, see the Google Workspace Events API reference documentation. Like all advanced services in Apps Script, the Google Workspace Events service uses the same objects, methods, and parameters as the public API.

These samples show you how to perform common Google Workspace Events API actions using the advanced service.

To create a subscription to a Google Workspace resource, add the following function to the Apps Script project's code:

To list subscriptions filtered by event types and target resource, add the following function to the Apps Script project's code:

To get information about a subscription, add the following function to the Apps Script project's code:

To update or renew a subscription, add the following function to the Apps Script project's code:

To reactivate a subscription, add the following function to the Apps Script project's code:

To delete a subscription, add the following function to the Apps Script project's code:

Most Google Workspace Events API methods return a long-running operation. To determine the status of the operation, you can use the operations.get() method.

To get information about an operation, add the following function to the Apps Script project's code:

To get the name of an operation, use the value from the name field returned from one of the Google Workspace Events API methods, such as subscriptions.create() or subscriptions.patch().

**Examples:**

Example 1 (unknown):
```unknown
"oauthScopes": [
  "https://www.googleapis.com/auth/chat.messages.readonly"
]
```

---

## Advanced People Service Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/advanced/people

**Contents:**
- Advanced People Service Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
- Reference
- Sample code
  - Get the user's connections
  - Get the person for the user
  - Get the person for a Google Account

The advanced People service in Apps Script utilizes the People API to manage contact and profile data.

This is an advanced service that requires explicit enablement before use.

The service uses the same objects, methods, and parameters as the public People API.

Sample code is provided to demonstrate getting user connections, the user's own profile, and information for any Google Account.

The advanced People service allows you to use the People API in Apps Script. This API allows scripts to create, read, and update contact data for the logged in user and read profile data for google users.

For detailed information on this service, see the reference documentation for the People API. Like all advanced services in Apps Script, the advanced People service uses the same objects, methods, and parameters as the public API. For more information, see How method signatures are determined.

To report issues and find other support, see the People v1 support guide.

The sample code below uses version 1 of the API.

To get a list of people in the user's contacts, use the following code:

To get the user's profile, you need to request the https://www.googleapis.com/auth/userinfo.profile scope by following the instructions to add explicit scopes to your appsscript.json manifest file. Once the scope is added, you can use the following code:

To get the person information for any Google Account, use the following code:

---

## Analytics Data Service Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/advanced/analyticsdata

**Contents:**
- Analytics Data Service Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
- Reference
- Sample code
  - Run a report

The Analytics Data service allows Google Analytics users to programmatically access Google Analytics 4 (GA4) report data through the Google Analytics Data API v1 in Apps Script.

This is an advanced service that requires enabling before use in Apps Script.

The AnalyticsData service utilizes the same objects, methods, and parameters as the public API.

Detailed information and support for this service can be found in the Google Analytics Data API v1 reference documentation and support page.

The Analytics Data service allows you to use the Google Analytics Data API v1 in Apps Script. This API gives Google Analytics users programmatic access to Google Analytics 4 (GA4) report data.

For detailed information on this service, see the Google Analytics Data API v1 reference documentation.

Like all advanced services in Apps Script, the AnalyticsData service uses the same objects, methods, and parameters as the public API. For more information, see How method signatures are determined.

To report issues and find other support, see the Google Analytics Data API v1 support page.

The sample runs a report to retrieve the active users count by city and stores the results in a new spreadsheet.

---

## Apps Script Sunset Schedule Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/ui

**Contents:**
- Apps Script Sunset Schedule Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways

Apps Script features are marked as deprecated before they are shut down, allowing time for migration to supported alternatives.

Deprecated features remain available until their sunset date, after which they cease to function or become unavailable.

Developers should upgrade existing scripts to use supported features during the deprecation period to avoid disruptions.

Google provides migration guides and resources to help developers transition away from deprecated features.

The table above lists deprecated Apps Script features, their deprecation and sunset dates, and the expected behavior after sunset.

Once a sunset date for an Apps Script feature has been announced, the feature is considered deprecated, but should still be available for use until the sunset date. During the deprecation period, we encourage you to upgrade existing scripts to use supported features.

---

## Authorization Scopes Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/concepts/scopes

**Contents:**
- Authorization Scopes Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
- View scopes
- Set explicit scopes
- Handle granular OAuth permissions
  - Automatically require permission for necessary scopes
    - Example
  - Create a custom experience for missing scopes
    - Example
  - Ensure that trigger executions have permissions

Script projects accessing user data require authorization, initiating an authorization flow when a script runs for the first time.

OAuth scopes define the specific permissions a script needs, such as reading emails or creating calendar events.

For most scripts, Apps Script automatically detects necessary scopes, but for published applications like add-ons, you should explicitly set the narrowest scopes possible in the manifest file.

Granular OAuth permissions allow users to authorize specific scopes, and scripts should be designed to handle these permissions using requireScopes or getAuthorizationInfo methods.

Scripts using sensitive or restricted OAuth scopes, especially for publicly published applications, may require OAuth client verification and adherence to additional data policies.

Users must authorize script projects that access their data or act on their behalf. When a user runs a script that requires authorization for the first time, the UI presents a prompt to start the authorization flow.

During this flow, the UI tells the user what the script wants permission to do. For example, a script might want permission to read the user's email messages or create events in their calendar. The script project defines these individual permissions as OAuth scopes.

For most scripts, Apps Script automatically detects what scopes are needed for you; you can view the scopes a script uses at any time. You can also set scopes explicitly in your manifest using URL strings. Setting scopes explicitly is sometimes required for certain applications like add-ons, since published applications should always use the narrowest scopes possible.

During the authorization flow, Apps Script presents human-readable descriptions of the required scopes to the user. For example, if your script needs read-only access to your spreadsheets, the manifest may have the scope https://www.googleapis.com/auth/spreadsheets.readonly. During the authorization flow, a script with this scope asks the user to allow this application to "View your Google Spreadsheets".

Some scopes are inclusive of others. For example, when authorized the scope https://www.googleapis.com/auth/spreadsheets allows read and write access to spreadsheets.

For some surfaces where scripts run, such as running a script directly from the Apps Script IDE, users are presented with the granular OAuth consent screen. This lets users select specific permissions to grant rather than granting all permissions at once. It's important to design your script to handle granular OAuth permissions.

You can see the scopes your script project currently requires by doing the following:

Apps Script automatically determines what scopes a script needs by scanning its code for function calls that require them. For most scripts this is sufficient and saves you time, but for published add-ons, web apps, Google Chat apps, and calls to Google Chat API you must exercise more direct control of the scopes.

Apps Script sometimes automatically assigns projects very permissive scopes. This can mean your script asks the user for more than it needs, which is bad practice. For published scripts, you must replace broad scopes with a more limited set that cover the script's needs and no more.

You can explicitly set the scopes your script project uses by editing its manifest file. The manifest field oauthScopes is an array of all scopes used by the project. To set your project's scopes, do the following:

The granular OAuth consent screen lets users specify which individual OAuth scopes they want to authorize. Granular OAuth permissions give users more fine-grained control over what account data they choose to share with each script. For example, imagine you develop a script that requests permission for both email and calendar scopes. Your users might want to use your script only for its capabilities with Google Calendar, but not Gmail. With granular OAuth permissions, users can choose to only grant Calendar permission, but not Gmail.

The following sections describe the main ways to handle granular OAuth permissions.

If an execution flow needs permission for scopes in order to work, you can require users to grant those permissions before they can use it. Your script can check if the user has already given permission and, if not, automatically ask them for it.

The following methods from the ScriptApp class let you validate permission for required scopes and automatically render the authorization prompt to request any missing permissions:

The following example shows how to call the requireScopes(authMode, oAuthScopes) and requireAllScopes(authMode) methods. The script uses scopes for Gmail, Sheets, and Calendar. The sendEmail() function requires only the scopes for Gmail and Sheets while the createEventSendEmail() function requires all scopes used by the script.

You can get the permission details of the user running your script and design a custom experience based on their permission status. For example, you might decide to turn off specific features of your script that require permissions that the user hasn't granted, or present a custom dialog explaining the missing permissions. The following methods get an object with the user's permission information that includes which scopes the user has authorized and a URL to let you request any missing scopes:

To get the permission details from the authorization info object, such as a list of which scopes have been authorized and a URL to request missing permissions, use the methods from the AuthorizationInfo class.

The following example shows how to call the getAuthorizationInfo(authMode, oAuthScopes) method to skip specific features within an execution flow where the required scopes haven't been granted. This lets the rest of the execution flow continue without having to prompt for authorization of the missing scopes.

Functions associated with triggers can run automatically on certain events, and the user may not be present to provide more permissions. We recommended that you use requireScopes(authMode, oAuthScopes) before installing a trigger. This prompts the user for missing permissions and doesn't allow the installation of the trigger without them.

Certain OAuth scopes are sensitive because they allow access to Google User Data. If your script project uses scopes that allow access to user data, the project must go through OAuth client verification before you can publish it publicly as a web app or add-on. For more information, see the following guides:

In addition to sensitive scopes, certain scopes are classified as restricted and subject to additional rules that help protect user data. If you intend to publish a web app or add-on that uses one or more restricted scopes, the app must comply with all the specified restrictions before it can be published.

Review the full list of restricted scopes before you attempt to publish. If your app uses any of them, you must comply with the Additional Requirements for Specific API scopes prior to publishing.

**Examples:**

Example 1 (javascript):
```javascript
// This function requires the Gmail and Sheets scopes.
function sendEmail() {
  // Validates that the user has granted permission for the Gmail and Sheets scopes.
  // If not, the execution ends and prompts the user for authorization.
  ScriptApp.requireScopes(ScriptApp.AuthMode.FULL, [
    'https://mail.google.com/',
    'https://www.googleapis.com/auth/spreadsheets'
  ]);

  // Sends an email.
  GmailApp.sendEmail("dana@example.com", "Subject", "Body");
  Logger.log("Email sent successfully!");

  // Opens a spreadsheet and sheet to track the sent email.
  const ss = SpreadsheetApp.openById("abc1234567");
  const sheet = ss.getSheetByName("Email Tracker")

  // Gets the last row of the sheet.
  const lastRow = sheet.getLastRow();

  // Adds "Sent" to column E of the last row of the spreadsheet.
  sheet.getRange(lastRow, 5).setValue("Sent");
  Logger.log("Sheet updated successfully!");
}

// This function requires all scopes used by the script (Gmail,
// Calendar, and Sheets).
function createEventSendEmail() {
  // Validates that the user has granted permission for all scopes used by the
  // script. If not, the execution ends and prompts the user for authorization.
  ScriptApp.requireAllScopes(ScriptApp.AuthMode.FULL);

  // Creates an event.
  CalendarApp.getDefaultCalendar().createEvent(
    "Meeting",
    new Date("November 28, 2024 10:00:00"),
    new Date("November 28, 2024 11:00:00")
  );
  Logger.log("Calendar event created successfully!");

  // Sends an email.
  GmailApp.sendEmail("dana@example.com", "Subject 2", "Body 2");
  Logger.log("Email sent successfully!");

  // Opens a spreadsheet and sheet to track the created meeting and sent email.
  const ss = SpreadsheetApp.openById("abc1234567");
  const sheet = ss.getSheetByName("Email and Meeting Tracker")
  // Gets the last row
  const lastRow = sheet.getLastRow();

  // Adds "Sent" to column E of the last row
  sheet.getRange(lastRow, 5).setValue("Sent");
  // Adds "Meeting created" to column F of the last row
  sheet.getRange(lastRow, 6).setValue("Meeting created");
  Logger.log("Sheet updated successfully!");
}
```

Example 2 (javascript):
```javascript
// This function uses the Gmail scope and skips the email
// capabilities if the scope for Gmail hasn't been granted.
function myFunction() {
  const authInfo = ScriptApp.getAuthorizationInfo(ScriptApp.AuthMode.FULL, ['https://mail.google.com/']);
  if (authInfo.getAuthorizationStatus() === ScriptApp.AuthorizationStatus.NOT_REQUIRED) {
    GmailApp.sendEmail("dana@example.com", "Subject", "Body");
    Logger.log("Email sent successfully!");
  } else {
    const scopesGranted = ScriptApp.getAuthorizationInfo(ScriptApp.AuthMode.FULL).getAuthorizedScopes();
    console.warn(`Authorized scopes: ${scopesGranted} not enough to send mail, skipping.`);
  }
  // Continue the rest of the execution flow...
}
```

Example 3 (javascript):
```javascript
// This function requires scope Sheets.
function trackFormSubmissions(e){
  // Opens a spreadsheet to track the sent email.
  const ss = SpreadsheetApp.openById("abc1234567");
  const sheet = ss.getSheetByName("Submission Tracker")

  // Gets the last row of the sheet.
  const lastRow = sheet.getLastRow();

  // Adds email address of user that submitted the form
  // to column E of the last row of the spreadsheet.
  sheet.getRange(lastRow, 5).setValue(e.name);
  Logger.log("Sheet updated successfully!");
}


function installTrigger(){
  // Validates that the user has granted permissions for trigger
  // installation and execution. If not, trigger doesn't get
  // installed and prompts the user for authorization.
  ScriptApp.requireScopes(ScriptApp.AuthMode.FULL, [
    'https://www.googleapis.com/auth/script.scriptapp',
    'https://www.googleapis.com/auth/spreadsheets',
    'https://www.googleapis.com/auth/forms.currentonly'
  ]);
  ScriptApp.newTrigger('trackFormSubmission')
    .forForm(FormApp.getActiveForm())
    .onFormSubmit()
    .create();
}
```

---

## Building Editor add-ons Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/add-ons/how-tos/building-editor-addons

**Contents:**
- Building Editor add-ons Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
- Create a script project
  - Collaboration
- Code the add-on
- Test the add-on
- Publish the add-on

Editor add-ons are built using Apps Script, requiring a standalone Apps Script project and code for the add-on's functionality and user interface.

Thorough testing is crucial before publishing using a dedicated test configuration and sample documents, ensuring the add-on functions as intended.

Collaboration involves shared ownership and access, recommending the use of shared drives and adding collaborators to the Cloud Platform project for sustained accessibility.

Publishing makes the add-on accessible to others, either publicly or within a domain, involving a review process for public listings on the Google Workspace Marketplace.

The add-on's appearance and behavior are defined using Apps Script's HTML service, allowing for custom menus, dialogs, and sidebars constructed with HTML and CSS.

Before building your Editor add-on, review the Apps Script quotas and limitations to ensure your project design aligns with these guidelines. Familiarizing yourself with these limits early in your development process can help prevent potential issues later on. Apps Script is ideal for lightweight add-on development for yourself, your team, or your organization. However, if you anticipate building a large-scale add-on that needs to handle many users, requires low latency, or demands full control over your infrastructure, consider developing a Google Workspace add-on on a different runtime environment.

Follow this general procedure when building an Editor add-on:

An Editor add-on is a standalone Apps Script project. The standalone script guide provides instructions to create new projects. You can also just open a new script. If you do this, the project file (initially named Untitled project) is placed in your root Drive folder.

When you collaborate with others in developing an add-on, a single user account owns the add-on project. When you publish an add-on, a single user account acts as the publisher. The publishing account must have edit access to the add-on script project, but it doesn't need to be project owner.

It's very important to avoid situations where you lose access to an add-on's code or settings because the owner of the project left your organization.

To prevent losing access to add-on code, we encourage you to use shared drives when you collaborate on an add-on. Placing your add-on script file in a shared drive ensures that no single account is the sole owner of the project.

It is also recommended that you add collaborators to the script project's Cloud Platform (GCP) project. This helps ensure someone on your team always can access the add-on's Cloud settings.

Once you have created a script project, you can begin writing code to define the add-on appearance and behavior. You use the Apps Script HtmlService to construct the add-on user interface—dialogs and sidebars— using conventional HTML and CSS. Editor add-ons can define custom menu items as well.

As you code, refer to the Editor add-on style guide for guidelines on how to design your add-on user experience. Also, be sure you understand and program for the different authorization lifecycle states your add-on can encounter.

You can test Editor add-ons before they are published to ensure they behave as expected. Testing requires you to create a test configuration and use a testing document, spreadsheet, form, or presentation.

See Test an Editor add-on for details.

Publishing your add-on makes it available to others, either publicly or just users in your domain. Before you start the publishing process, be sure to review the publication overview.

Editor add-ons are published to the Google Workspace Marketplace. Publicly available add-ons must complete add-on review before they are published.

See Publishing an Editor add-on for more details.

---

## Cache Service Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/cache

**Contents:**
- Cache Service Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
- Classes
- Cache
  - Methods
- CacheService
  - Methods

The Cache service allows a script to temporarily store results that take time to fetch or compute.

Public caches are for data not dependent on a specific user, while private caches are for user-specific information.

The Cache class represents a particular cache instance, and the CacheService class provides access to different caches.

The Cache class provides methods for getting, putting, and removing data from the cache, including setting expiration times and handling multiple key/value pairs.

The CacheService class provides methods to retrieve specific cache instances scoped to the document, script, or current user.

This service allows a script to temporarily cache results that take time to fetch/compute. Public caches are for things that are not dependent on which user is accessing your script. Private caches are for things which are user-specific, like settings or recent activity.

---

## Calendar manifest resource Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/manifest/calendar-addons

**Contents:**
- Calendar manifest resource Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
- Calendar
  - ConferenceSolution
  - EventOpenTrigger
  - EventUpdateTrigger
  - EventAttachmentTrigger

The resource configuration is used to define Google Workspace add-on content and behavior within Google Calendar.

Google Workspace add-on manifests must have all components marked as Required if they extend Calendar.

The Calendar configuration details the manifest settings for Google Calendar extensions, including optional and required fields for various triggers and conferencing solutions.

The currentEventAccess field determines the level of access an add-on has to user-generated event data in Google Calendar.

ConferenceSolution configurations are only required for add-ons providing third-party conferencing solutions and specify details like ID, logo URL, name, and the function to call for creation.

The resource configuration that is used to define Google Workspace add-on content and behavior within Google Calendar. Google Workspace add-on manifests must have all the components marked as Required if they extend Calendar.

The Google Workspace add-on manifest configuration for Google Calendar extensions. See Extending Calendar with Google Workspace add-ons for more information.

object (ConferenceSolution)

Determines what level of access the add-on has to user-generated data event data. If not provided, no event metadata is passed to the add-on. The valid settings are the following:

If set to READ or READ_WRITE, the add-on must have the https://www.googleapis.com/auth/calendar.addons.current.event.read scope. If set to WRITE or READ_WRITE, the add-on must have the https://www.googleapis.com/auth/calendar.addons.current.event.write scope.

object (EventOpenTrigger)

The trigger specification for event open triggers in Calendar.

object (EventUpdateTrigger)

Required to provide contextual event update interfaces in Google Calendar. The trigger specification for event update triggers in Calendar.

object (EventAttachmentTrigger)

The trigger specification for event attachment triggers in Calendar.

object (HomepageTrigger)

The trigger function specification for creating the add-on homepage in the Calendar host. This overrides addOns.common.homepageTrigger.

The configuration of a conferencing solution offered by the add-on. Each solution has a corresponding conferencing option presented in the Google Calendar Edit Event UI.

A configuration for a contextual trigger that fires when a Google Calendar event is opened by the user. See Extending the Calendar event interface for more information.

A configuration for a contextual trigger that fires when a Google Calendar event is edited and saved by the user. See Updating Calendar events for more information.

A configuration for a contextual trigger that fires when the user clicks on the add-on attachment provider in the Calendar dropdown menu.

---

## Card Service Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/card-service

**Contents:**
- Card Service Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
- Classes
- Action
  - Methods
- ActionResponse
  - Methods
- ActionResponseBuilder
  - Methods
- ActionStatus

The Card Service enables building card-based user interfaces for Google Workspace add-ons and Google Chat apps across desktop and mobile platforms.

Numerous classes are provided for interactive elements, layout, input and display widgets, response handling, data sources, and styling.

The service includes builders to construct complex UI components and enumerations for various property options.

Methods are available to configure properties, behaviors, and responses for UI elements.

Specific classes and methods are detailed for creating and managing different parts of the user interface, such as sections, cards, carousels, and responses.

This service allows scripts to configure and build card and widget components and behaviors for a UI. The UI structures you build with this service are automatically available in both desktop and mobile devices, so you don't need to develop separate UIs for both.

---

## Charts Service Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/charts

**Contents:**
- Charts Service Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
- Classes
- AreaChartBuilder
  - Methods
- BarChartBuilder
  - Methods
- Chart
  - Methods
- ChartHiddenDimensionStrategy

The Charts service facilitates server-side chart creation using Google Charts Tools, whereas client-side rendering utilizes the Google Charts API.

An example is provided illustrating the process of creating a data table, populating an area chart, and displaying it as an image.

The documentation details various classes and methods for building different chart types such as Area, Bar, Column, Line, Pie, and Scatter charts, as well as data table and text style objects.

Supported chart types are listed, including Timeline, Area, Bar, Bubble, Candlestick, Column, Combo, Gauge, Geo, Histogram, Radar, Line, Org, Pie, Scatter, Sparkline, Stepped Area, Table, Treemap, and Waterfall charts.

Enums are defined for handling hidden data, merging data ranges, specifying column types, setting curve and point styles, defining legend positions, handling string matching in filters, setting orientation, and specifying picker values layout.

This service allows users to create charts using Google Charts Tools and render them server side. If you want to render charts in a web browser, use the Google Charts API instead.

This example creates a basic data table, populates an area chart with the data, and adds it to a web page as an image:

**Examples:**

Example 1 (unknown):
```unknown
function doGet() {
  var data = Charts.newDataTable()
      .addColumn(Charts.ColumnType.STRING, 'Month')
      .addColumn(Charts.ColumnType.NUMBER, 'In Store')
      .addColumn(Charts.ColumnType.NUMBER, 'Online')
      .addRow(['January', 10, 1])
      .addRow(['February', 12, 1])
      .addRow(['March', 20, 2])
      .addRow(['April', 25, 3])
      .addRow(['May', 30, 4])
      .build();

  var chart = Charts.newAreaChart()
      .setDataTable(data)
      .setStacked()
      .setRange(0, 40)
      .setTitle('Sales per Month')
      .build();

  var htmlOutput = HtmlService.createHtmlOutput().setTitle('My Chart');
  var imageData = Utilities.base64Encode(chart.getAs('image/png').getBytes());
  var imageUrl = "data:image/png;base64," + encodeURI(imageData);
  htmlOutput.append("Render chart server side: <br/>");
  htmlOutput.append("<img border=\"1\" src=\"" + imageUrl + "\">");
  return htmlOutput;

}
```

---

## Class Action Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/card-service/action

**Contents:**
- Class Action Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
  - Methods
  - Deprecated methods
- Detailed documentation
  - addRequiredWidget(requiredWidget)
    - Parameters
    - Return
  - setAllWidgetsAreRequired(allWidgetsAreRequired)
    - Parameters

An Action enables interactivity in UI elements by invoking an Apps Script callback function with optional parameters.

Actions are available for Google Workspace add-ons and Google Chat apps.

You can add required widgets, set all widgets as required, and set the name of the callback function for an Action.

Actions also allow setting interaction type (specifically for dialogs in Google Chat), load indicators, and custom parameters.

You can control whether form values persist from the client or are overwritten by server values after an action response.

An action that enables interactivity within UI elements. The action does not happen directly on the client but rather invokes an Apps Script callback function with optional parameters.

Available for Google Workspace add-ons and Google Chat apps.

Adds the names of the widgets that this Action needs for a valid submission. If the widgets in this list don't have a value when this Action is invoked, the form submission is aborted.

Available for Google Workspace add-ons and Google Chat apps.

Action — This object, for chaining.

Indicates whether this Action requires inputs from all widgets.

Available for Google Workspace add-ons and Google Chat apps.

Action — This object, for chaining.

Sets the name of the callback function to be called. Required.

Action — This object, for chaining.

Sets the interaction with a user, only required when opening a dialog. If unspecified, the app responds by executing an Action like opening a link or running a function—as normal.

Only available for Google Chat apps. Not available for Google Workspace add-ons.

Action — This object, for chaining.

Sets the loading indicator that displays while the action is in progress.

Action — This object, for chaining.

Allows custom parameters to be passed to the callback function. Optional.

Action — This object, for chaining.

Indicates whether form values are determined by the client's values or the server's values after an action response updates the form's Card. When set to true, the client's values persist after the server response. When set to false, the server's values overwrite the form values. Defaults to false.

Persisting the client values helps prevent situations where a form changes unexpectedly after a user makes an edit. For example, if a user makes an edit to a TextInput after submitting a form, but before the server responds. If the values are persisted, the edit the user made remains after the server response updates the Card; otherwise the form value returns to the value that the user originally submitted to the form.

Persisting client values can interfere with your script's ability to clear form fields or override form values, so avoid turning on persistence for that type of functionality. Without persistence, it's recommended that you use the LoadIndicator.SPINNER for events, because this locks the UI and prevents user edits before the server responds. Alternatively, you can use LoadIndicator.NONE and make sure every element in the form has an onChange action.

Action — This object, for chaining.

Deprecated. Legacy alias for setFunctionName(functionName).

Action — This object, for chaining.

---

## Class Attachment Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/card-service/attachment

**Contents:**
- Class Attachment Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
  - Methods
- Detailed documentation
  - setIconUrl(iconUrl)
    - Parameters
    - Return
  - setMimeType(mimeType)
    - Parameters
    - Return

The Attachment object represents an attachment created by an add-on for use in Google extensibility products.

You can create a new attachment using CardService.newAttachment().

The Attachment object provides methods to set the resource URL, title, MIME type, and icon URL.

Methods like setIconUrl, setMimeType, setResourceUrl, and setTitle are available to configure the attachment.

Represents an attachment created by an add-on. This can be used within the context of different Google extensibility products to generate new attachments, such as for Calendar events.

Sets the icon URL for the attachment.

Attachment — This object, for chaining.

Sets the MIME type for the attachment.

Attachment — This object, for chaining.

Sets the resource URL for the attachment.

Attachment — This object, for chaining.

Sets the title for the attachment.

Attachment — This object, for chaining.

---

## Class AuthorizationInfo Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/script/authorization-info

**Contents:**
- Class AuthorizationInfo Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
  - Methods
- Detailed documentation
  - getAuthorizationStatus()
    - Return
  - getAuthorizationUrl()
    - Return
  - getAuthorizedScopes()
    - Return

AuthorizationInfo checks if a user has granted authorization for required script scopes and provides an authorization URL to grant those permissions.

The AuthorizationInfo object allows you to control access to code sections requiring certain scopes and request authorization for subsequent executions.

AuthorizationInfo is returned by ScriptApp.getAuthorizationInfo(authMode), with ScriptApp.AuthMode.FULL being the generally recommended authorization mode.

Key methods of AuthorizationInfo include getAuthorizationStatus(), getAuthorizationUrl(), and getAuthorizedScopes().

An object that checks if the user has granted authorization for the required scopes of the script. The object also provides an authorization URL for users to grant those permissions.

Some script executions can start without a user's consent to all required scopes used by the script. The information in this object lets you control access to sections of code that require certain scopes and request authorization of those scopes for subsequent executions.

This object is returned by ScriptApp.getAuthorizationInfo(authMode). In almost all cases, scripts should call ScriptApp.getAuthorizationInfo(ScriptApp.AuthMode.FULL), since no other authorization mode requires that users grant authorization.

Gets a value that indicates whether the user needs to authorize this script to use one or more services (for example, ScriptApp.AuthorizationStatus.REQUIRED).

AuthorizationStatus — the authorization status

Gets the authorization URL that can be used to grant access to the script. This method returns null if no authorization is required. The page at the URL will close automatically if it is accessed and the script does not require any authorization.

String — a URL that can be used to authorize the script

Gets a list of authorized scopes for the script. If authorization information is requested for a specified list of scopes, returns the authorized scopes from the specified list.

String[] — The list of authorized scopes.

---

## Class Banding Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/spreadsheet/banding

**Contents:**
- Class Banding Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
  - Methods
  - Deprecated methods
- Detailed documentation
  - copyTo(range)
    - Parameters
    - Return
    - Authorization
  - getFirstColumnColorObject()

Banding refers to the color patterns applied to rows or columns of a range within a spreadsheet.

Each banding is defined by a range and specific colors for its rows, columns, headers, and footers.

You can access and modify various color properties of a banding for the first and second alternating rows/columns, as well as header and footer rows/columns.

Banding provides methods to copy, remove, and set the range for the banding.

Some methods for getting color properties by returning a String color code are deprecated and replaced by methods that return a Color object.

Access and modify bandings, the color patterns applied to rows or columns of a range. Each banding consists of a range and a set of colors for rows, columns, headers, and footers.

Copies this banding to another range.

Banding — The new banding.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the first alternating column color in the banding, or null if no color is set.

Color — The first alternating column color in the banding, or null if no color is set.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the first alternating row color, or null if no color is set.

Color — The first alternating row color in the banding, or null if no color is set.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the color of the last column in the banding, or null if no color is set.

Color — The last column color in the banding, or null if no color is set.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the last row color in the banding, or null if no color is set.

Color — The footer row color in the banding, or null if no color is set.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the color of the first column in the banding, or null if no color is set.

Color — The first column color in the banding, or null if no color is set.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the color of the header row or null if no color is set.

Color — The color of the header row; returns null if no color is set.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the range for this banding.

Range — The range for this banding.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the second alternating column color in the banding, or null if no color is set.

Color — The second alternating column color in the banding, or null if no color is set.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the second alternating row color, or null if no color is set.

Color — The second alternating row color in the banding, or null if no color is set.

Scripts that use this method require authorization with one or more of the following scopes:

Removes this banding.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the first column color that is alternating.

Banding — This banding, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the first alternating column color in the banding.

Banding — This banding, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the first row color that is alternating.

Banding — This banding, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the first alternating row color in the banding.

Banding — This banding, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the color of the last column.

Banding — This banding, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the color of the last column in the banding.

Banding — This banding, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the color of the last row.

Banding — This banding, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the color of the footer row in the banding.

Banding — This banding, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the color of the header column.

Banding — This banding, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the color of the header column.

Banding — This banding, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the color of the header row.

Banding — This banding, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the color of the header row.

Banding — This banding, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the range for this banding.

Banding — This banding, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the second column color that is alternating.

Banding — This banding, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the second alternating column color in the banding.

Banding — This banding, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the second row color that is alternating.

Banding — This banding, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the second alternating color in the banding.

Banding — This banding, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Deprecated. Replaced by getFirstColumnColorObject()

Returns the first column color that is alternating, or null if no color is set.

String — The color code in CSS notation (such as '#ffffff' or 'white'), or null if no color is set.

Scripts that use this method require authorization with one or more of the following scopes:

Deprecated. Replaced by getFirstRowColorObject()

Returns the first row color that is alternating or null if no color is set.

String — The color code in CSS notation (such as '#ffffff' or 'white'), or null if no color is set.

Scripts that use this method require authorization with one or more of the following scopes:

Deprecated. Replaced by getFooterColumnColorObject()

Returns the color of the last column, or null if no color is set.

String — The color code in CSS notation (such as '#ffffff' or 'white'), or null if no color is set.

Scripts that use this method require authorization with one or more of the following scopes:

Deprecated. Replaced by getFooterRowColorObject()

Returns the color of the last row, or null if no color is set.

String — The color code in CSS notation (such as '#ffffff' or 'white'), or null if no color is set.

Scripts that use this method require authorization with one or more of the following scopes:

Deprecated. Replaced by getHeaderColumnColorObject()

Returns the color of the header column, or null if no color is set.

String — The color code in CSS notation (such as '#ffffff' or 'white'), or null if no color is set.

Scripts that use this method require authorization with one or more of the following scopes:

Deprecated. Replaced by getHeaderRowColorObject()

Returns the color of the header row or null if no color is set.

String — The color code in CSS notation (such as '#ffffff' or 'white'), or null if no color is set.

Scripts that use this method require authorization with one or more of the following scopes:

Deprecated. Replaced by getSecondColumnColorObject()

Returns the second column color that is alternating, or null if no color is set.

String — The HEX color or null if no color is set.

Scripts that use this method require authorization with one or more of the following scopes:

Deprecated. Replaced by getSecondRowColorObject()

Returns the second row color that is alternating or null if no color is set.

String — The color code in CSS notation (such as '#ffffff' or 'white'), or null if no color is set.

Scripts that use this method require authorization with one or more of the following scopes:

---

## Class BigQueryConfig Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/data-studio/big-query-config

**Contents:**
- Class BigQueryConfig Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
  - Methods
- Detailed documentation
  - addQueryParameter(name, type, value)
    - Parameters
    - Return
  - build()
    - Return
  - printJson()

BigQueryConfig is a configuration object for a native BigQuery connector used with Data Studio.

It is returned from the getData() function for Data Studio to query BigQuery.

Methods available for BigQueryConfig include adding query parameters, building the configuration, printing JSON, setting access token, setting billing project ID, setting the query, and setting the SQL interpretation method.

The build() method validates the object and formats it for Data Studio, while other set methods configure specific aspects of the BigQuery connection and query.

A configuration object for a native BigQuery connector. Return this object from getData() for Data Studio to query BigQuery for the connector.

Adds a query parameter to this BigQueryConfig.

BigQueryConfig — This object, for chaining.

Validates this object and returns it in the format needed by Data Studio.

Object — The validated Config object.

Prints the JSON representation of this object. This is for debugging only.

Sets the access token of this BigQueryConfig.

BigQueryConfig — This object, for chaining.

Sets the billing project ID of this BigQueryConfig.

BigQueryConfig — This object, for chaining.

Sets the SQL query of this BigQueryConfig.

BigQueryConfig — This object, for chaining.

Determines if the query is interpreted as standard or legacy SQL.

BigQueryConfig — This object, for chaining.

---

## Class BigQueryDataSourceSpecBuilder Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/spreadsheet/big-query-data-source-spec-builder

**Contents:**
- Class BigQueryDataSourceSpecBuilder Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
  - Methods
- Detailed documentation
  - build()
    - Return
  - copy()
    - Return
  - getDatasetId()
    - Return

BigQueryDataSourceSpecBuilder is used to build a data source specification for BigQuery.

It provides methods to get and set the dataset ID, project ID, table ID, and raw query.

You can manage parameters for the data source, including adding, removing, and setting them from a cell reference.

The build() method finalizes the configuration and returns a DataSourceSpec object.

The builder for BigQueryDataSourceSpecBuilder.

Builds a data source specification from the settings in this builder. Must use as...() to specify a data source type before building.

The following code sample builds a BigQuery DataSource Spec.

The following code sample builds a Looker DataSource Spec.

DataSourceSpec — The data source specification.

Creates a DataSourceSpecBuilder based on this data source's settings.

DataSourceSpecBuilder — The builder.

Gets the BigQuery dataset ID.

String — The dataset ID, or an empty string if the data source spec is defined by a raw query.

Gets the parameters of the data source.

This method is only available for BigQuery data sources.

DataSourceParameter[] — The parameter list.

Gets the billing project ID.

String — The project ID.

Gets the raw query string.

String — The raw query string.

Gets the BigQuery table ID.

String — The table ID, or an empty string if the data source spec is defined by a raw query.

Gets the BigQuery project ID for the table.

String — The table project ID, or an empty string if the data source spec is defined by a raw query.

Gets the type of the data source.

DataSourceType — The data source type.

Removes all the parameters.

BigQueryDataSourceSpecBuilder — The builder, for chaining.

Removes the specified parameter.

BigQueryDataSourceSpecBuilder — The builder, for chaining.

Sets the BigQuery dataset ID.

BigQueryDataSourceSpecBuilder — This builder, for chaining.

Adds a parameter, or if the parameter with the name exists, updates its source cell for data source spec builders of type DataSourceType.BIGQUERY.

This method is only available for BigQuery data sources.

BigQueryDataSourceSpecBuilder — The builder, for chaining.

Sets the billing BigQuery project ID.

BigQueryDataSourceSpecBuilder — The builder, for chaining.

Sets the raw query string.

BigQueryDataSourceSpecBuilder — The builder, for chaining.

Sets the BigQuery table ID.

BigQueryDataSourceSpecBuilder — This builder, for chaining.

Sets the BigQuery project ID for the table.

BigQueryDataSourceSpecBuilder — The builder, for chaining.

---

## Class BigQueryDataSourceSpec Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/spreadsheet/big-query-data-source-spec

**Contents:**
- Class BigQueryDataSourceSpec Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
  - Methods
- Detailed documentation
  - copy()
    - Return
  - getDatasetId()
    - Return
  - getParameters()
    - Return

BigQueryDataSourceSpec allows access to existing BigQuery data source specifications within SpreadsheetApp.

You can create a new data source specification using SpreadsheetApp.newDataSourceSpec().

The methods available include retrieving dataset ID, parameters, project ID, raw query, table ID, table project ID, and data source type.

The copy() method creates a DataSourceSpecBuilder based on the existing data source's settings.

Access the existing BigQuery data source specification. To create a new data source specification, use SpreadsheetApp.newDataSourceSpec().

Creates a DataSourceSpecBuilder based on this data source's settings.

DataSourceSpecBuilder — The builder.

Gets the BigQuery dataset ID.

String — The dataset ID, or an empty string if the data source spec is defined by a raw query.

Gets the parameters of the data source.

This method is only available for BigQuery data sources.

DataSourceParameter[] — The parameter list.

Gets the billing project ID.

String — The project ID.

Gets the raw query string.

String — The raw query string.

Gets the BigQuery table ID.

String — The table ID, or an empty string if the data source spec is defined by a raw query.

Gets the BigQuery project ID for the table.

String — The table project ID, or an empty string if the data source spec is defined by a raw query.

Gets the type of the data source.

DataSourceType — The data source type.

---

## Class BooleanCondition Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/spreadsheet/boolean-condition

**Contents:**
- Class BooleanCondition Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
  - Methods
  - Deprecated methods
- Detailed documentation
  - getBackgroundObject()
    - Return
  - getBold()
    - Return
  - getCriteriaType()

A BooleanCondition is accessed within ConditionalFormatRules and each rule can have one boolean condition.

A boolean condition contains a boolean criteria and formatting settings that are applied if the criteria evaluates to true for a cell.

Methods are available to retrieve the background color, font color, bold, italic, strikethrough, and underline settings of a boolean condition.

Methods also exist to retrieve the criteria type and criteria values of a boolean condition.

Some methods for getting background and font color strings are deprecated and replaced by methods that return Color objects.

Access boolean conditions in ConditionalFormatRules. Each conditional format rule may contain a single boolean condition. The boolean condition itself contains a boolean criteria (with values) and formatting settings. The criteria is evaluated against the content of a cell resulting in either a true or false value. If the criteria evaluates to true, the condition's formatting settings are applied to the cell.

Gets the background color for this boolean condition. Returns null if not set.

Color — The background color, or null if not set for this condition.

Returns true if this boolean condition bolds the text and returns false if this boolean condition removes bolding from the text. Returns null if bolding is unaffected.

Boolean — whether or not the boolean condition bolds the text, or null if bolding is unaffected

Gets the rule's criteria type as defined in the BooleanCriteria enum. To get the arguments for the criteria, use getCriteriaValues(). To use these values to create or modify a conditional formatting rule, see ConditionalFormatRuleBuilder.withCriteria(criteria, args).

BooleanCriteria — The type of conditional formatting criteria.

Gets an array of arguments for the rule's criteria. To get the criteria type, use getCriteriaType(). To use these values to create or modify a conditional formatting rule, see ConditionalFormatRuleBuilder.withCriteria(criteria, args).

Object[] — An array of arguments appropriate to the rule's criteria type; the number of arguments and their type match the corresponding when...() method of the ConditionalFormatRuleBuilder class.

Gets the font color for this boolean condition. Returns null if not set.

Color — The font color, or null if not set for this condition.

Returns true if this boolean condition italicises the text and returns false if this boolean condition removes italics from the text. Returns null if italics are unaffected.

Boolean — whether or not the boolean condition italicises the text, or null if italicising is unaffected

Returns true if this boolean condition strikes through the text and returns false if this boolean condition removes strikethrough from the text. Returns null if strikethrough is unaffected.

Boolean — whether or not the boolean condition strikes through the text, or null if strikethrough is unaffected

Returns true if this boolean condition underlines the text and returns false if this boolean condition removes underlining from the text. Returns null if underlining is unaffected.

Boolean — whether or not the boolean condition underlines the text, or null if underlining is unaffected

Deprecated. Replaced by getBackgroundObject()

Gets the background color string for this boolean condition. Returns null if not set.

String — The background color string, or null if not set for this condition.

Deprecated. Replaced by getFontColorObject()

Gets the font color string for this boolean condition. Returns null if not set.

String — The font color string, or null if not set for this condition.

---

## Class CalendarEventActionResponseBuilder Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/card-service/calendar-event-action-response-builder

**Contents:**
- Class CalendarEventActionResponseBuilder Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
  - Methods
- Detailed documentation
  - addAttachments(attachments)
    - Parameters
    - Return
  - addAttendees(emails)
    - Parameters
    - Return

CalendarEventActionResponseBuilder is a builder for CalendarEventActionResponse objects.

Methods like addAttachments, addAttendees, and setConferenceData specify actions to take on a Calendar event when a UI action is triggered.

The build method validates and creates the CalendarEventActionResponse object.

A builder for CalendarEventActionResponse objects.

Specifies that the response should add the attachments to the Calendar event when the associated UI action is taken.

CalendarEventActionResponseBuilder — This object, for chaining.

Specifies that the response should add the indicated attendees to the Calendar event when the associated UI action is taken.

CalendarEventActionResponseBuilder — This object, for chaining.

Error — If too many attendees have been added.

Builds the current Calendar event action response and validates it.

CalendarEventActionResponse — A validated CalendarEventActionResponse.

Error — If the constructed Calendar event action response isn't valid.

Specifies that the response should set the indicated conference data to the Calendar event when the associated UI action is taken.

CalendarEventActionResponseBuilder — This object, for chaining.

---

## Class CalendarEventActionResponse Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/card-service/calendar-event-action-response

**Contents:**
- Class CalendarEventActionResponse Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
  - Methods
- Detailed documentation
  - printJson()
    - Return

CalendarEventActionResponse represents a response that modifies a calendar event being edited based on a user action.

You can use the CalendarEventActionResponseBuilder to create a response, for example, to add attendees to an event.

The printJson() method is available for debugging purposes, returning a JSON representation of the object.

Represents a response that makes changes to the calendar event that the user is currently editing in reaction to an action taken in the UI, such as a button click.

Prints the JSON representation of this object. This is for debugging only.

---

## Class CalendarEventSeries Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/calendar/calendar-event-series

**Contents:**
- Class CalendarEventSeries Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
  - Methods
- Detailed documentation
  - addEmailReminder(minutesBefore)
    - Parameters
    - Return
    - Throws
    - Authorization
  - addGuest(email)

The CalendarEventSeries object in Google Calendar represents a recurring event and offers methods to manage its properties.

You can add or remove guests, manage their permissions, and retrieve guest information.

The object provides functionality to add, retrieve, and remove various types of reminders.

You can access core event details such as title, description, location, color, and dates.

The object allows modification of event properties like title, description, location, recurrence, and visibility.

The entire event series or specific tags can be deleted using the provided methods.

Represents a series of events (a recurring event).

Adds a new email reminder to the event. The reminder must be at least 5 minutes, and at most 4 weeks (40320 minutes), before the event.

CalendarEventSeries — this CalendarEventSeries for chaining

Error — if there are more than 5 reminders on the event or the time is not within the legal range

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Adds a guest to the event.

CalendarEventSeries — This CalendarEventSeries for chaining.

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Adds a new pop-up notification to the event. The notification must be at least 5 minutes, and at most 4 weeks (40320 minutes), before the event.

CalendarEventSeries — this CalendarEventSeries for chaining

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Adds a new SMS reminder to the event. The reminder must be at least 5 minutes, and at most 4 weeks (40320 minutes), before the event.

CalendarEventSeries — this CalendarEventSeries for chaining

Error — if there are more than 5 reminders on the event or the time is not within the legal range

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Determines whether people can add themselves as guests to a Calendar event.

Boolean — true if non-guests can add themselves to the event; false if not

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Deletes the event series.

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Deletes a key/value tag from the event.

CalendarEventSeries — this CalendarEventSeries for chaining

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Gets all keys for tags that have been set on the event.

String[] — an array of string keys

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Returns the color of the calendar event.

String — The string representation of the event color, as an index (1-11) of values from CalendarApp.EventColor.

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Gets the creators of an event.

String[] — the email addresses of the event's creators

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Gets the date the event was created. You must have access to the calendar.

Date — the date of creation

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Gets the description of the event. You must have edit access to the calendar.

String — the description

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Gets the minute values for all email reminders for the event. You must have edit access to the calendar.

Integer[] — an array in which each value corresponds to the number of minutes before the event that a reminder triggers

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Gets the EventType of this event.

EventType — The event type.

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Gets a guest by email address.

EventGuest — the guest, or null if the email address does not correspond to a guest

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Gets the guests for the event, not including the event owner.

EventGuest[] — an array of the guests

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Gets the guests for the event, potentially including the event owners.

EventGuest[] — an array of the guests

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Gets the unique iCalUID of the event. Note that the iCalUID and the event id used by the Calendar v3 API and Calendar advanced service are not identical and cannot be used interchangeably. One difference in their semantics is that in recurring events all occurrences of one event have different ids while they all share the same iCalUIDs.

String — the iCalUID of the event

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Gets the date the event was last updated.

Date — the last updated date

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Gets the location of the event.

String — the event location

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Gets the event status (such as attending or invited) of the effective user. Always returns GuestStatus.OWNER if the effective user is the owner of the event.

GuestStatus — the status

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Get the ID of the calendar where this event was originally created.

String — the ID of the original calendar

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Gets the minute values for all pop-up reminders for the event.

Integer[] — an array in which each value corresponds to the number of minutes before the event that a reminder triggers

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Gets the minute values for all SMS reminders for the event.

Integer[] — an array in which each value corresponds to the number of minutes before the event that a reminder triggers

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Gets a tag value of the event.

String — the tag value

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Gets the title of the event.

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Gets the transparency of the event. Use this method to determine whether an event is TRANSPARENT, meaning the calendar shows as Available during that time, or OPAQUE , meaning the calendar shows as Busy during that time.

EventTransparency — The transparency value.

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Gets the visibility of the event.

Visibility — the visibility value

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Determines whether guests can invite other guests.

Boolean — true if guests can invite others; false if not

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Determines whether guests can modify the event.

Boolean — true if guests can modify the event; false if not

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Determines whether guests can see other guests.

Boolean — true if guests can see other guests; false if not

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Determines whether you're the owner of the event.

Boolean — true if the event is owned by the effective user; false if not

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Removes all reminders from the event.

CalendarEventSeries — this CalendarEventSeries for chaining

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Removes a guest from the event.

CalendarEventSeries — this CalendarEventSeries for chaining

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Resets the reminders using the calendar's default settings.

CalendarEventSeries — this CalendarEventSeries for chaining

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Sets whether non-guests can add themselves to the event.

CalendarEventSeries — this CalendarEventSeries for chaining

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Sets the color of the calendar event.

CalendarEventSeries — This calendar event, for chaining.

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Sets the description of the event.

CalendarEventSeries — this CalendarEventSeries for chaining

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Sets whether guests can invite other guests.

CalendarEventSeries — this CalendarEventSeries for chaining

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Sets whether guests can modify the event.

CalendarEventSeries — this CalendarEventSeries for chaining

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Sets whether guests can see other guests.

CalendarEventSeries — this CalendarEventSeries for chaining

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Sets the location of the event.

CalendarEventSeries — this CalendarEventSeries for chaining

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Sets the event status (such as attending or invited) of the effective user.

CalendarEventSeries — this CalendarEventSeries for chaining

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Sets the recurrence rules for an all-day event series. Applying this method changes a regular event series into an all-day event series.

CalendarEventSeries — this CalendarEventSeries for chaining

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Sets the recurrence rules for this event series. Applying this method changes an all-day event series into a regular event series.

CalendarEventSeries — this CalendarEventSeries for chaining

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Sets a key/value tag on the event, for storing custom metadata.

CalendarEventSeries — this CalendarEventSeries for chaining

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Sets the title of the event.

CalendarEventSeries — this CalendarEventSeries for chaining

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Sets the transparency of the event. Use this method to set whether an event is TRANSPARENT, meaning the calendar shows as Available during that time, or OPAQUE , meaning the calendar shows as Busy during that time.

CalendarEventSeries — This CalendarEventSeries for chaining.

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Sets the visibility of the event.

CalendarEventSeries — this CalendarEventSeries for chaining

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

---

## Class CalendarEvent Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/calendar/calendar-event

**Contents:**
- Class CalendarEvent Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
  - Methods
- Detailed documentation
  - addEmailReminder(minutesBefore)
    - Parameters
    - Return
    - Throws
    - Authorization
  - addGuest(email)

The CalendarEvent class in Google Apps Script is used to manage properties, guests, and reminders of a single calendar event.

Key functionalities include managing reminders (adding, removing, retrieving), managing guests (adding, removing, getting lists, setting permissions), getting various event information (dates, times, titles, locations, etc.), modifying event properties using setter methods, deleting events, and managing custom tags.

Most methods require authorization with either read-write (https://www.googleapis.com/auth/calendar) or read-only (https://www.googleapis.com/auth/calendar.readonly) scopes.

Represents a single calendar event.

Adds a new email reminder to the event. The reminder must be at least 5 minutes, and at most 4 weeks (40320 minutes), before the event.

CalendarEvent — this CalendarEvent for chaining

Error — if there are more than 5 reminders on the event or the time is not within the legal range

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Adds a guest to the event.

CalendarEvent — This CalendarEvent for chaining.

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Adds a new pop-up notification to the event. The notification must be at least 5 minutes, and at most 4 weeks (40320 minutes), before the event.

CalendarEvent — this CalendarEvent for chaining

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Adds a new SMS reminder to the event. The reminder must be at least 5 minutes, and at most 4 weeks (40320 minutes), before the event.

CalendarEvent — this CalendarEvent for chaining

Error — if there are more than 5 reminders on the event or the time is not within the legal range

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Determines whether people can add themselves as guests to a Calendar event.

Boolean — true if non-guests can add themselves to the event; false if not

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Deletes a Calendar event.

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Deletes a key/value tag from the event.

CalendarEvent — this CalendarEvent for chaining

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Gets the date on which this all-day calendar event ends. (If this is not an all-day event, then this method throws an exception.) The returned Date represents midnight at the beginning of the day after the event ends in the script's time zone. To use the calendar's time zone instead, call getEndTime().

Date — this all-day calendar event's end date

Error — if this event is not an all-day event

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Gets the date on which this all-day calendar event begins. (If this is not an all-day event, then this method throws an exception.) The returned Date represents midnight at the beginning of the day on which the event starts in the script's time zone. To use the calendar's time zone instead, call getStartTime().

Date — this all-day calendar event's start date

Error — if this event is not an all-day event

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Gets all keys for tags that have been set on the event.

String[] — an array of string keys

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Returns the color of the calendar event.

String — The string representation of the event color, as an index (1-11) of values from CalendarApp.EventColor.

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Gets the creators of an event.

String[] — the email addresses of the event's creators

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Gets the date the event was created. You must have access to the calendar.

Date — the date of creation

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Gets the description of the event. You must have edit access to the calendar.

String — the description

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Gets the minute values for all email reminders for the event. You must have edit access to the calendar.

Integer[] — an array in which each value corresponds to the number of minutes before the event that a reminder triggers

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Gets the date and time at which this calendar event ends. You must have access to the calendar. For non–all-day events, this is the instant in time at which the event was defined to end. For all-day events, which only store an end date (not a date and time), this is midnight at the beginning of the day after the event ends in the calendar's time zone. This allows meaningful comparison of end times for all types of events; however, it does not necessarily preserve the original day-of-year unmodified.

For all-day events, getAllDayEndDate() should almost always be called in preference to this method.

Date — this calendar event's end time

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Gets the series of recurring events that this event belongs to. You must have access to the calendar. A CalendarEventSeries object is returned even if this event doesn't belong to a series, so that you can add new recurrence settings.

CalendarEventSeries — the event series this event belongs to, or a new event series if it does not yet belong to a series

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Gets the EventType of this event.

EventType — The event type.

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Gets a guest by email address.

EventGuest — the guest, or null if the email address does not correspond to a guest

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Gets the guests for the event, not including the event owner.

EventGuest[] — an array of the guests

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Gets the guests for the event, potentially including the event owners.

EventGuest[] — an array of the guests

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Gets the unique iCalUID of the event. Note that the iCalUID and the event id used by the Calendar v3 API and Calendar advanced service are not identical and cannot be used interchangeably. One difference in their semantics is that in recurring events all occurrences of one event have different ids while they all share the same iCalUIDs.

String — the iCalUID of the event

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Gets the date the event was last updated.

Date — the last updated date

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Gets the location of the event.

String — the event location

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Gets the event status (such as attending or invited) of the effective user. Always returns GuestStatus.OWNER if the effective user is the owner of the event.

GuestStatus — the status

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Get the ID of the calendar where this event was originally created.

String — the ID of the original calendar

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Gets the minute values for all pop-up reminders for the event.

Integer[] — an array in which each value corresponds to the number of minutes before the event that a reminder triggers

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Gets the minute values for all SMS reminders for the event.

Integer[] — an array in which each value corresponds to the number of minutes before the event that a reminder triggers

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Gets the date and time at which this calendar event begins. For non–all-day events, this is the instant in time at which the event was defined to start. For all-day events, which only store a start date (not a date and time), this is midnight at the beginning of the day on which the event starts in the calendar's time zone. This allows meaningful comparison of start times for all types of events; however, it is not necessarily preserve the original day-of-year unmodified.

For all-day events, getAllDayStartDate() should almost always be called in preference to this method.

Date — this calendar event's start time

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Gets a tag value of the event.

String — the tag value

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Gets the title of the event.

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Gets the transparency of the event. Use this method to determine whether an event is TRANSPARENT, meaning the calendar shows as Available during that time, or OPAQUE , meaning the calendar shows as Busy during that time.

EventTransparency — The transparency value.

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Gets the visibility of the event.

Visibility — the visibility value

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Determines whether guests can invite other guests.

Boolean — true if guests can invite others; false if not

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Determines whether guests can modify the event.

Boolean — true if guests can modify the event; false if not

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Determines whether guests can see other guests.

Boolean — true if guests can see other guests; false if not

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Determines whether this is an all-day event.

Boolean — true if the event is all-day; false if not

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Determines whether you're the owner of the event.

Boolean — true if the event is owned by the effective user; false if not

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Determines whether the event is part of an event series.

Boolean — true if the event is part of an event series; false if not

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Removes all reminders from the event.

CalendarEvent — this CalendarEvent for chaining

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Removes a guest from the event.

CalendarEvent — this CalendarEvent for chaining

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Resets the reminders using the calendar's default settings.

CalendarEvent — this CalendarEvent for chaining

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Sets the date of the event. Applying this method changes a regular event into an all-day event.

CalendarEvent — this CalendarEvent for chaining

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Sets the dates of the event. Applying this method changes a regular event into an all-day event.

CalendarEvent — this CalendarEvent for chaining

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Sets whether non-guests can add themselves to the event.

CalendarEvent — this CalendarEvent for chaining

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Sets the color of the calendar event.

CalendarEvent — This calendar event, for chaining.

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Sets the description of the event.

CalendarEvent — this CalendarEvent for chaining

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Sets whether guests can invite other guests.

CalendarEvent — this CalendarEvent for chaining

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Sets whether guests can modify the event.

CalendarEvent — this CalendarEvent for chaining

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Sets whether guests can see other guests.

CalendarEvent — this CalendarEvent for chaining

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Sets the location of the event.

CalendarEvent — this CalendarEvent for chaining

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Sets the event status (such as attending or invited) of the effective user.

CalendarEvent — this CalendarEvent for chaining

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Sets a key/value tag on the event, for storing custom metadata.

CalendarEvent — this CalendarEvent for chaining

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Sets the dates and times for the start and end of the event. Applying this method changes an all-day event into a regular event.

CalendarEvent — this CalendarEvent for chaining

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Sets the title of the event.

CalendarEvent — this CalendarEvent for chaining

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Sets the transparency of the event. Use this method to set whether an event is TRANSPARENT, meaning the calendar shows as Available during that time, or OPAQUE , meaning the calendar shows as Busy during that time.

CalendarEvent — This CalendarEvent for chaining.

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Sets the visibility of the event.

CalendarEvent — this CalendarEvent for chaining

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

---

## Class CardBuilder Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/card-service/card-builder

**Contents:**
- Class CardBuilder Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
  - Methods
- Detailed documentation
  - addCardAction(cardAction)
    - Parameters
    - Return
  - addSection(section)
    - Parameters
    - Return

CardBuilder is used to build Card objects.

You can add card actions and sections to a Card using the builder.

The build() method finalizes and validates the Card object.

Various methods allow setting the card's display style, footer, header, name, and peek card header.

A builder for Card objects.

Adds a CardAction to this Card.

CardBuilder — This object, for chaining.

Adds a section to this card. You can't add more than 100 sections to a card.

CardBuilder — This object, for chaining.

Builds the current card and validates it.

Card — A validated card.

Error — if the constructed card isn't valid.

Sets the display style for this card.

If the display style is set to DisplayStyle.REPLACE, the card is shown by replacing the view of top card in the card stack.

If the display style is set to DisplayStyle.PEEK, the header of the card appears at the bottom of the sidebar, partially covering the current top card of the stack. Clicking the header pops the card into the card stack. If the card has no header, a generated header is used instead.

DisplayStyle only works for card returned from contextual trigger function.

CardBuilder — This object, for chaining.

Sets a fixed footer for this card.

CardBuilder — This object, for chaining.

Sets the header for this card.

CardBuilder — This object, for chaining.

Sets the name for this card. The name can be used for navigation.

CardBuilder — This object, for chaining.

Sets the peek card header.

The peek card is set on the first card returned from a contextual trigger function. It is used as a descriptive placeholder widget so that users can navigate from a homepage stack to the contextual stack.

CardBuilder — This object, for chaining.

---

## Class CardHeader Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/card-service/card-header

**Contents:**
- Class CardHeader Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
  - Methods
- Detailed documentation
  - setImageAltText(imageAltText)
    - Parameters
    - Return
  - setImageStyle(imageStyle)
    - Parameters
    - Return

CardHeader represents the header for a Card in Google Workspace add-ons and Google Chat apps.

You can set the title, subtitle, image URL, image style, and image alt text for a CardHeader using its methods.

The setImageUrl method accepts either a publicly accessible URL or a base64 encoded image string.

Methods like setTitle and setSubtitle are used to define the text content of the header.

The header of a Card.

Available for Google Workspace add-ons and Google Chat apps.

Sets the alternative text for the header image.

CardHeader — This object, for chaining.

Sets the cropping of the icon in the card header. Defaults to no crop. Optional.

CardHeader — This object, for chaining.

Sets the image to use in the header by providing its URL or data string.

The provided URL can either be a publicly accessible URL or a base64 encoded image string. To obtain the latter, you can use the following code to create an encoded image string from an image in your Google Drive, then store that string for later use with setImageUrl(imageUrl). This method prevents the need for your add-on to access a publicly available image URL:

CardHeader — This object, for chaining.

Sets the subtitle of the card header. Optional.

CardHeader — This object, for chaining.

Sets the title of the card header. Required.

CardHeader — This object, for chaining.

---

## Class CardService Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/card-service/card-service

**Contents:**
- Class CardService Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
  - Properties
  - Methods
- Detailed documentation
  - newAction()
    - Return
  - newActionResponseBuilder()
    - Return
  - newActionStatus()

CardService allows you to create generic cards for use in various Google extensibility products like Google Workspace add-ons.

You can return single or multiple cards using the CardService.

Cards can be built with headers, text, images, and interactive elements like menu items.

CardService provides numerous methods for creating different card components such as buttons, sections, and input fields.

CardService provides the ability to create generic cards used across different Google extensibility products, such as Google Workspace add-ons.

Below is a sample for an add-ons card.

Or you can return multiple Cards like so:

The following shows how you could define a card with a header, text, an image and a menu item:

Sample for a Chat Apps card.

Creates a new Action.

Action — An empty Action.

Creates a new ActionResponseBuilder.

ActionResponseBuilder — An empty ActionResponse builder.

Creates a new ActionStatus.

Only available for Google Chat apps. Not available for Google Workspace add-ons.

ActionStatus — An empty ActionStatus.

Creates a new Attachment.

Attachment — An empty attachment.

Creates a new AuthorizationAction.

AuthorizationAction — An empty AuthorizationAction.

Creates a new AuthorizationException.

AuthorizationException — An empty AuthorizationException.

Creates a new BorderStyle.

BorderStyle — An empty BorderStyle.

Creates a new ButtonSet.

ButtonSet — An empty ButtonSet.

Creates a new CalendarEventActionResponseBuilder.

CalendarEventActionResponseBuilder — An empty CalendarEventActionResponseBuilder.

Creates a new CardAction.

CardAction — An empty CardAction.

Creates a new Card builder.

CardBuilder — An empty Card builder.

Creates a new CardHeader.

CardHeader — An empty CardHeader.

Creates a new CardSection.

CardSection — An empty CardSection.

Creates a new CardWithId. This is used to send a card in a Google Chat message. card ID is a unique identifier for a card in a message when sending multiple cards.

Only available for Google Chat apps. Not available for Google Workspace add-ons.

CardWithId — An empty CardWithId.

Developer Preview: Available as part of the Google Workspace Developer Preview Program, which grants early access to certain features.

Carousel — An empty Carousel.

Creates a new CarouselCard.

Developer Preview: Available as part of the Google Workspace Developer Preview Program, which grants early access to certain features.

CarouselCard — An empty Chip.

Creates a new ChatActionResponse.

Only available for Google Chat apps. Not available for Google Workspace add-ons.

ChatActionResponse — An empty ChatActionResponse.

Creates a new ChatResponseBuilder.

Only available for Google Chat apps. Not available for Google Workspace add-ons.

ChatResponseBuilder — An empty ChatResponseBuilder.

Available for Google Chat apps. In developer preview for Google Workspace add-ons.

Developer Preview: Available as part of the Google Workspace Developer Preview Program, which grants early access to certain features.

Chip — An empty Chip.

Creates a new ChipList.

Available for Google Chat apps. In developer preview for Google Workspace add-ons.

Developer Preview: Available as part of the Google Workspace Developer Preview Program, which grants early access to certain features.

ChipList — An empty ChipList.

Creates a new CollapseControl.

Available for Google Chat apps. In developer preview for Google Workspace add-ons.

Developer Preview: Available as part of the Google Workspace Developer Preview Program, which grants early access to certain features.

CollapseControl — An empty CollapseControl.

Creates a new Column.

Available for Google Chat apps and Google Workspace add-ons.

Column — An empty Column.

Creates a new set of Columns.

Available for Google Chat apps and Google Workspace add-ons.

Columns — An empty set of Columns.

Creates a new ComposeActionResponseBuilder.

ComposeActionResponseBuilder — An empty ComposeActionResponse builder.

Creates a new DatePicker.

DatePicker — An empty DatePicker.

Creates a new DateTimePicker.

DateTimePicker — An empty DateTimePicker.

Creates a new DecoratedText.

DecoratedText — An empty DecoratedText.

Creates a new Dialog.

Only available for Google Chat apps. Not available for Google Workspace add-ons.

Dialog — An empty Dialog.

Creates a new DialogAction.

Only available for Google Chat apps. Not available for Google Workspace add-ons.

DialogAction — An empty DialogAction.

Creates a new Divider. The following sample builds a simple card with 2 paragraphs separated by a divider.

Creates a new DriveItemsSelectedActionResponseBuilder.

DriveItemsSelectedActionResponseBuilder — An empty DriveItemsSelectedActionResponseBuilder.

Creates a new EditorFileScopeActionResponseBuilder.

EditorFileScopeActionResponseBuilder — An empty EditorFileScopeActionResponseBuilder.

Creates a new FixedFooter.

FixedFooter — An empty FixedFooter.

Grid — An empty Grid.

Creates a new GridItem.

GridItem — An empty GridItem.

Creates a new HostAppDataSource and return an empty HostAppDataSource.

Creates a new IconImage.

IconImage — An empty icon image.

Image — An empty Image.

Creates a new ImageButton.

ImageButton — An empty ImageButton.

Creates a new ImageComponent.

ImageComponent — An empty ImageComponent.

Creates a new ImageCropStyle.

ImageCropStyle — An empty ImageCropStyle.

Creates a new KeyValue.

KeyValue — An empty KeyValue.

Creates a new LinkPreview.

LinkPreview — An empty LinkPreview.

Creates a new MaterialIcon.

Available for Google Chat apps and Google Workspace add-ons.

MaterialIcon — An empty MaterialIcon.

Creates a new Navigation.

Navigation — An empty Navigation.

Creates a new Notification.

Notification — An empty Notification.

Creates a new OpenLink.

OpenLink — An empty OpenLink.

Creates a new OverflowMenu.

Available for Google Chat apps. In developer preview for Google Workspace add-ons.

Developer Preview: Available as part of the Google Workspace Developer Preview Program, which grants early access to certain features.

OverflowMenu — An empty OverflowMenu.

Creates a new OverflowMenuItem.

Available for Google Chat apps. In developer preview for Google Workspace add-ons.

Developer Preview: Available as part of the Google Workspace Developer Preview Program, which grants early access to certain features.

OverflowMenuItem — An empty OverflowMenuItem.

Creates a new SelectionInput.

SelectionInput — An empty SelectionInput.

Creates a new Suggestions.

Suggestions — An empty Suggestions.

Creates a new SuggestionsResponseBuilder.

SuggestionsResponseBuilder — An empty SuggestionsResponse builder.

Creates a new Switch.

Switch — An empty Switch.

Creates a new TextButton.

TextButton — An empty TextButton.

Creates a new TextInput.

TextInput — An empty TextInput.

Creates a new TextParagraph.

TextParagraph — An empty TextParagraph.

Creates a new TimePicker.

TimePicker — An empty TimePicker.

Creates a new UniversalActionResponseBuilder.

UniversalActionResponseBuilder — An empty UniversalActionResponse builder.

Creates a new UpdateDraftActionResponseBuilder.

UpdateDraftActionResponseBuilder — An empty UpdateDraftActionResponseBuilder.

Creates a new UpdateDraftBccRecipientsAction;

UpdateDraftBccRecipientsAction — An empty UpdateDraftBccRecipientsAction.

Creates a new UpdateDraftBodyAction.

UpdateDraftBodyAction — An empty UpdateDraftBodyAction.

Creates a new UpdateDraftCcRecipientsAction.

UpdateDraftCcRecipientsAction — An Empty UpdateDraftCcRecipientsAction.

Creates a new UpdateDraftSubjectAction.

UpdateDraftSubjectAction — An empty UpdateDraftSubjectAction.

Creates a new UpdateDraftToRecipientsAction.

UpdateDraftToRecipientsAction — An empty UpdateDraftToRecipientsAction.

Creates a new Validation.

Available for Google Chat apps and Google Workspace add-ons.

Validation — An empty validation.

---

## Class CellImageBuilder Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/spreadsheet/cell-image-builder

**Contents:**
- Class CellImageBuilder Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
  - Properties
  - Methods
  - Deprecated methods
- Detailed documentation
  - build()
    - Return
  - getAltTextDescription()
    - Return

CellImageBuilder is used to create the image value needed to add an image to a cell.

The value type for a CellImage is ValueType.IMAGE.

Key methods include build() to create the image value, setSourceUrl() to set the image source, and methods to get and set alt text (getAltTextDescription, setAltTextDescription, getAltTextTitle, setAltTextTitle).

The getContentUrl() method returns a temporary Google-hosted URL for the image.

The getUrl() method is deprecated and will often return an empty string.

Builder for CellImage. This builder creates the image value needed to add an image to a cell.

Creates the image value type needed to add an image to a cell. The image value is built from the image properties added to the builder, such as the source URL.

CellImage — A representation of the image to add to a cell.

Returns the alt text description for this image.

String — The alt text description.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the alt text title for this image.

String — The alt text title.

Scripts that use this method require authorization with one or more of the following scopes:

Returns a Google-hosted URL to the image. This URL is tagged with the account of the requester, so anyone with the URL effectively accesses the image as the original requester. Access to the image might be lost if the spreadsheet's sharing settings change. The returned URL expires after a short period of time.

String — The Google-hosted URL of the image.

Sets the alt-text description for this image.

CellImage — This image, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the alt text title for this image.

CellImage — This image, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the image source URL.

CellImageBuilder — This builder, for chaining.

Creates a cell image builder based on the current image properties. Use setSourceUrl(url) to set the source URL of the new image. Then you can add it to a cell using Range.setValue(value) or Range.setValues(values).

CellImageBuilder — A builder that creates an image value type based on the given image properties.

Deprecated. For most newly inserted images, the source URL is unavailable.

Gets the image's source URL. Returns an empty string if the URL is unavailable. For most newly inserted images, the source URL is unavailable regardless how the image is inserted.

String — The image's source URL if available; returns an empty string otherwise.

Scripts that use this method require authorization with one or more of the following scopes:

---

## Class CellImage Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/spreadsheet/cell-image

**Contents:**
- Class CellImage Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
  - Properties
  - Methods
  - Deprecated methods
- Detailed documentation
  - getAltTextDescription()
    - Return
    - Authorization
  - getAltTextTitle()

CellImage represents an image value in a cell and is added using SpreadsheetApp.newCellImage() and CellImageBuilder.

CellImage has a valueType property which is always ValueType.IMAGE.

Key methods include retrieving alt text (getAltTextDescription, getAltTextTitle), getting a Google-hosted content URL (getContentUrl), and creating a builder based on current properties (toBuilder).

The getUrl() method is deprecated as the source URL is often unavailable for newly inserted images.

Represents an image value in a cell. To add an image to a cell, you must create a new image value for the image using SpreadsheetApp.newCellImage() and CellImageBuilder. Then you can use Range.setValue(value) or Range.setValues(values) to add the image value to the cell.

Returns the alt text description for this image.

String — The alt text description.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the alt text title for this image.

String — The alt text title.

Scripts that use this method require authorization with one or more of the following scopes:

Returns a Google-hosted URL to the image. This URL is tagged with the account of the requester, so anyone with the URL effectively accesses the image as the original requester. Access to the image might be lost if the spreadsheet's sharing settings change. The returned URL expires after a short period of time.

String — The Google-hosted URL of the image.

Creates a cell image builder based on the current image properties. Use CellImageBuilder.setSourceUrl(url) to set the source URL of the new image. Then you can add it to a cell using Range.setValue(value) or Range.setValues(values).

CellImageBuilder — A builder that creates an image value type based on the given image properties.

Deprecated. For most newly inserted images, the source URL is unavailable.

Gets the image's source URL. Returns an empty string if the URL is unavailable. For most newly inserted images, the source URL is unavailable regardless how the image is inserted.

String — The image's source URL if available; returns an empty string otherwise.

Scripts that use this method require authorization with one or more of the following scopes:

---

## Class Checkbox Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/data-studio/checkbox

**Contents:**
- Class Checkbox Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
  - Methods
- Detailed documentation
  - setAllowOverride(allowOverride)
    - Parameters
    - Return
  - setHelpText(helpText)
    - Parameters
    - Return

Checkbox contains configuration information determining how it's displayed in Data Studio.

Methods available for Checkbox include setting allow override, help text, ID, dynamic status, and name.

Each method returns the Checkbox builder for chaining.

Contains checkbox information for the config. Its properties determine how the checkbox is displayed in Data Studio.

Enables overriding for this config entry. If set to true, data source creators have the option to enable this for report editors.

Checkbox — This builder, for chaining.

Sets the help text for this configuration entry.

Checkbox — This builder, for chaining.

Sets the unique ID for this configuration entry.

Checkbox — This builder, for chaining.

Sets the dynamic status for this configuration entry.

If a dynamic configuration entry is modified, subsequent configuration entries are cleared.

Checkbox — This builder, for chaining.

Sets the display name for this configuration entry.

Checkbox — This builder, for chaining.

---

## Class ColorBuilder Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/spreadsheet/color-builder

**Contents:**
- Class ColorBuilder Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
  - Methods
- Detailed documentation
  - asRgbColor()
    - Return
    - Throws
    - Authorization
  - asThemeColor()
    - Return

ColorBuilder is a builder for creating color objects in Apps Script spreadsheets.

A new ColorBuilder is created using SpreadsheetApp.newColor().

The builder allows setting a color as either an RGB color using a CSS string or as a theme color using a ThemeColorType.

Once configured, the build() method creates the final Color object.

You can also convert a built color object to its RgbColor or ThemeColor representation and get its ColorType.

The builder for ColorBuilder. To create a new builder, use SpreadsheetApp.newColor().

Converts this color to an RgbColor.

RgbColor — The RGB color.

Error — if the color is not an RgbColor

Scripts that use this method require authorization with one or more of the following scopes:

Converts this color to a ThemeColor.

ThemeColor — The theme color.

Error — if the color is not a ThemeColor.

Scripts that use this method require authorization with one or more of the following scopes:

Creates a color object from the settings supplied to the builder.

Color — A color object created from this builder.

Get the type of this color.

ColorType — The color type.

Scripts that use this method require authorization with one or more of the following scopes:

ColorBuilder — This builder, for chaining.

ColorBuilder — This builder, for chaining.

---

## Class ColorScheme Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/slides/color-scheme

**Contents:**
- Class ColorScheme Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
  - Methods
- Detailed documentation
  - getConcreteColor(theme)
    - Parameters
    - Return
    - Authorization
  - getThemeColors()
    - Return

A ColorScheme maps ThemeColorTypes to actual colors used for rendering.

You can retrieve the concrete color associated with a ThemeColorType using getConcreteColor.

The available ThemeColorTypes in a scheme can be listed using getThemeColors.

You can set the concrete color for a ThemeColorType using setConcreteColor with a Color object, RGB values, or a hex string.

A color scheme defines a mapping from members of ThemeColorType to the actual colors used to render them.

Returns the concrete Color associated with the ThemeColorType in this color scheme.

The returned color is guaranteed to not be an instance of ThemeColor.

Color — The concrete color corresponding the theme color type in this scheme.

Scripts that use this method require authorization with one or more of the following scopes:

Returns a list of all possible theme color types in a color scheme.

ThemeColorType[] — The possible theme color types in this scheme.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the concrete color associated with the ThemeColorType in this color scheme to the given color.

ColorScheme — This color scheme, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the concrete color associated with the ThemeColorType in this color scheme to the given color in RGB format.

ColorScheme — This color scheme, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the concrete color associated with the ThemeColorType in this color scheme to the given color in HEX format.

The hex string must be in the format '#RRGGBB'.

ColorScheme — This color scheme, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

---

## Class Color Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/spreadsheet/color

**Contents:**
- Class Color Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
  - Methods
- Detailed documentation
  - asRgbColor()
    - Return
    - Throws
    - Authorization
  - asThemeColor()
    - Return

The Color object represents a color and can be converted to an RgbColor or a ThemeColor.

You can get the type of the color using the getColorType() method.

Converting to RgbColor or ThemeColor may throw an error if the color is not of that type.

Using these methods requires specific spreadsheet authorization scopes.

A representation for a color.

Converts this color to an RgbColor.

RgbColor — The RGB color.

Error — if the color is not an RgbColor

Scripts that use this method require authorization with one or more of the following scopes:

Converts this color to a ThemeColor.

ThemeColor — The theme color.

Error — if the color is not a ThemeColor.

Scripts that use this method require authorization with one or more of the following scopes:

Get the type of this color.

ColorType — The color type.

Scripts that use this method require authorization with one or more of the following scopes:

---

## Class Columns Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/card-service/columns

**Contents:**
- Class Columns Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
  - Methods
- Detailed documentation
  - addColumn(column)
    - Parameters
    - Return
  - setWrapStyle(wrapStyle)
    - Parameters
    - Return

The Columns widget displays up to 2 columns in a card or dialog, where widgets can be added to each column and appear in the order specified.

The height of both columns is determined by the taller column, and rows or widget alignment between columns cannot be defined.

Columns are displayed side-by-side, and their width can be customized, with the second column wrapping below the first on narrower screens at specific pixel widths for web, iOS, and Android devices.

This feature is available for Google Chat apps and Google Workspace add-ons, specifically in dialogs displayed from email drafts and the Add attachment menu in Google Calendar events.

The addColumn(column) method adds up to two child columns to the Columns widget, and the setWrapStyle(wrapStyle) method controls how the columns resize based on screen width.

The Columns widget displays up to 2 columns in a card or dialog. You can add widgets to each Column; the widgets appear in the order that they are specified. For an example in Google Chat apps, see Columns.

The height of each column is determined by the taller column. For example, if the first column is taller than the second column, both columns have the height of the first column. Because each column can contain a different number of widgets, you can't define rows or align widgets between the columns.

Columns are displayed side-by-side. You can customize the width of each column using the HorizontalSizeStyle field. If the user's screen width is too narrow, the second column wraps below the first:

Available for Google Chat apps and Google Workspace add-ons. The add-on UIs that support columns include:

Adds a Column to the Columns widget. Columns are displayed in the order in which they're added. You can add up to two columns.

Columns — This object, for chaining.

Sets the wrap style of the columns, controls how the column resizes based on screen width.

Columns — This object, for chaining.

---

## Class CommunityConnector Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/data-studio/community-connector

**Contents:**
- Class CommunityConnector Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
  - Properties
  - Methods
- Detailed documentation
  - getConfig()
    - Return
  - getFields()
    - Return
  - newAuthTypeResponse()

The CommunityConnector class provides builders and utilities for developing Community Connectors for Data Studio.

You can get references to Fields, FieldType, and AggregationType through the CommunityConnector object.

The CommunityConnector class has properties like AggregationType, AuthType, BigQueryParameterType, and FieldType.

Useful methods like getConfig(), getFields(), newGetDataResponse(), and newGetSchemaResponse() are available for connector development.

CommunityConnector enables scripts to access builders and utilities to help with development of Community Connectors for Data Studio. Use this class to get a reference to the Fields object and the FieldType and AggregationType enums so they can be used in the construction of Fields.

Returns a Config object. Use this object to add configuration entries.

Config — A Config object.

Returns a Fields object. Use this object to add metric and dimension Fields.

Fields — A Fields object.

Returns a new GetAuthTypeResponse object. Use this object to create a response for the getAuthType() function you implement in your script project.

GetAuthTypeResponse — A new GetAuthTypeResponse object.

Returns a new BigQueryConfig object. Use this object to create a response for the getData() function you implement in your script project.

BigQueryConfig — A new BigQueryConfig object.

Returns a new DebugError object. Use this object to create debug errors.

DebugError — A new DebugError object.

Returns a new GetDataResponse object. Use this object to create a response for the getData() function you implement in your script project.

GetDataResponse — A new GetDataResponse object.

Returns a new GetSchemaResponse object. Use this object to create a response for the getSchema() function you implement in your script project.

GetSchemaResponse — A new GetSchemaResponse object.

Returns a new SetCredentialsResponse object. Use this object to create a response for the setCredentials() function you implement in your script project.

SetCredentialsResponse — A new SetCredentialsResponse object.

Returns a new UserError object. Use this object to create user errors.

UserError — A new UserError object.

---

## Class ConditionalFormatRuleBuilder Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/spreadsheet/conditional-format-rule-builder

**Contents:**
- Class ConditionalFormatRuleBuilder Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
  - Methods
- Detailed documentation
  - build()
    - Return
  - copy()
    - Return
  - getBooleanCondition()
    - Return

The ConditionalFormatRuleBuilder class in Google Apps Script provides methods to set conditional formatting rules based on date, formula, number, and text conditions.

Date-based methods like whenDateBefore and whenDateEqualTo can use either specific dates or relative dates such as RelativeDate.TODAY.

whenFormulaSatisfied allows applying formatting based on a custom formula that evaluates to true.

A comprehensive set of methods starting with whenNumber enables formatting based on numerical comparisons like equality, inequality, greater than/less than, and being within or outside a range.

Text-based conditions using methods like whenTextContains and whenTextEqualTo allow formatting based on whether cells contain, do not contain, start with, end with, or are exactly equal to a specific text string.

Builder for conditional format rules.

Constructs a conditional format rule from the settings applied to the builder.

ConditionalFormatRule — A representation of the conditional format rule.

Returns a rule builder preset with this rule's settings.

ConditionalFormatRuleBuilder — A builder based on this rule's settings.

Retrieves the rule's BooleanCondition information if this rule uses boolean condition criteria. Otherwise returns null.

BooleanCondition — The boolean condition object, or null if the rule does not use a boolean condition.

Retrieves the rule's GradientCondition information, if this rule uses gradient condition criteria. Otherwise returns null.

GradientCondition — The gradient condition object, or null if the rule does not use a gradient condition.

Retrieves the ranges to which this conditional format rule is applied.

Range[] — The ranges to which this conditional format rule is applied.

Sets the background color for the conditional format rule's format. Passing in null removes the background color format setting from the rule.

ConditionalFormatRuleBuilder — The builder, for chaining.

Sets the background color for the conditional format rule's format. Passing in null removes the background color format setting from the rule.

ConditionalFormatRuleBuilder — The builder, for chaining.

Sets text bolding for the conditional format rule's format. If bold is true, the rule bolds text if the condition is met; if false, the rule removes any existing bolding if the condition is met. Passing in null removes the bold format setting from the rule.

ConditionalFormatRuleBuilder — The builder, for chaining.

Sets the font color for the conditional format rule's format. Passing in null removes the font color format setting from the rule.

ConditionalFormatRuleBuilder — The builder, for chaining.

Sets the font color for the conditional format rule's format. Passing in null removes the font color format setting from the rule.

ConditionalFormatRuleBuilder — The builder, for chaining.

Clears the conditional format rule's gradient maxpoint value, and instead uses the maximum value in the rule's ranges. Also sets the gradient's maxpoint color to the input color.

ConditionalFormatRuleBuilder — The builder, for chaining.

Clears the conditional format rule's gradient maxpoint value, and instead uses the maximum value in the rule's ranges. Also sets the gradient's maxpoint color to the input color.

ConditionalFormatRuleBuilder — The builder, for chaining.

Sets the conditional format rule's gradient maxpoint fields.

ConditionalFormatRuleBuilder — The builder, for chaining.

Sets the conditional format rule's gradient maxpoint fields.

ConditionalFormatRuleBuilder — The builder, for chaining.

Sets the conditional format rule's gradient midpoint fields. Clears all of the midpoint fields if the passed in interpolation type is null.

ConditionalFormatRuleBuilder — The builder, for chaining.

Sets the conditional format rule's gradient midpoint fields. Clears all of the midpoint fields if the passed in interpolation type is null.

ConditionalFormatRuleBuilder — The builder, for chaining.

Clears the conditional format rule's gradient minpoint value, and instead uses the minimum value in the rule's ranges. Also sets the gradient's minpoint color to the input color.

ConditionalFormatRuleBuilder — The builder, for chaining.

Clears the conditional format rule's gradient minpoint value, and instead uses the minimum value in the rule's ranges. Also sets the gradient's minpoint color to the input color.

ConditionalFormatRuleBuilder — The builder, for chaining.

Sets the conditional format rule's gradient minpoint fields.

ConditionalFormatRuleBuilder — The builder, for chaining.

Sets the conditional format rule's gradient minpoint fields.

ConditionalFormatRuleBuilder — The builder, for chaining.

Sets text italics for the conditional format rule's format. If italic is true, the rule italicises text if the condition is met; if false, the rule removes any existing italicization if the condition is met. Passing in null removes the italic format setting from the rule.

ConditionalFormatRuleBuilder — The builder, for chaining.

Sets one or more ranges to which this conditional format rule is applied. This operation replaces any existing ranges. Setting an empty array clears any existing ranges. A rule must have at least one range.

ConditionalFormatRuleBuilder — The builder, for chaining.

Sets text strikethrough for the conditional format rule's format. If strikethrough is true, the rule strikesthrough text if the condition is met; if false, the rule removes any existing strikethrough formatting if the condition is met. Passing in null removes the strikethrough format setting from the rule.

ConditionalFormatRuleBuilder — The builder, for chaining.

Sets text underlining for the conditional format rule's format. If underline is true, the rule underlines text if the condition is met; if false, the rule removes any existing underlines if the condition is met. Passing in null removes the underline format setting from the rule.

ConditionalFormatRuleBuilder — The builder, for chaining.

Sets the conditional format rule to trigger when the cell is empty.

ConditionalFormatRuleBuilder — The builder, for chaining.

Sets the conditional format rule to trigger when the cell is not empty.

ConditionalFormatRuleBuilder — The builder, for chaining.

Sets the conditional format rule to trigger when a date is after the given value.

ConditionalFormatRuleBuilder — The builder, for chaining.

Sets the conditional format rule to trigger when a date is after the given relative date.

ConditionalFormatRuleBuilder — The builder, for chaining.

Sets the conditional format rule to trigger when a date is before the given date.

ConditionalFormatRuleBuilder — The builder, for chaining.

Sets the conditional format rule to trigger when a date is before the given relative date.

ConditionalFormatRuleBuilder — The builder, for chaining.

Sets the conditional format rule to trigger when a date is equal to the given date.

ConditionalFormatRuleBuilder — The builder, for chaining.

Sets the conditional format rule to trigger when a date is equal to the given relative date.

ConditionalFormatRuleBuilder — The builder, for chaining.

Sets the conditional format rule to trigger when that the given formula evaluates to true.

ConditionalFormatRuleBuilder — The builder, for chaining.

Sets the conditional format rule to trigger when a number falls between, or is either of, two specified values.

ConditionalFormatRuleBuilder — The builder, for chaining.

Sets the conditional format rule to trigger when a number is equal to the given value.

ConditionalFormatRuleBuilder — The builder, for chaining.

Sets the conditional format rule to trigger when a number is greater than the given value.

ConditionalFormatRuleBuilder — The builder, for chaining.

Sets the conditional format rule to trigger when a number is greater than or equal to the given value.

ConditionalFormatRuleBuilder — The builder, for chaining.

Sets the conditional conditional format rule to trigger when a number less than the given value.

ConditionalFormatRuleBuilder — The builder, for chaining.

Sets the conditional format rule to trigger when a number less than or equal to the given value.

ConditionalFormatRuleBuilder — The builder, for chaining.

Sets the conditional format rule to trigger when a number does not fall between, and is neither of, two specified values.

ConditionalFormatRuleBuilder — The builder, for chaining.

Sets the conditional format rule to trigger when a number is not equal to the given value.

ConditionalFormatRuleBuilder — The builder, for chaining.

Sets the conditional format rule to trigger when that the input contains the given value.

ConditionalFormatRuleBuilder — The builder, for chaining.

Sets the conditional format rule to trigger when that the input does not contain the given value.

ConditionalFormatRuleBuilder — The builder, for chaining.

Sets the conditional format rule to trigger when that the input ends with the given value.

ConditionalFormatRuleBuilder — The builder, for chaining.

Sets the conditional format rule to trigger when that the input is equal to the given value.

ConditionalFormatRuleBuilder — The builder, for chaining.

Sets the conditional format rule to trigger when that the input starts with the given value.

ConditionalFormatRuleBuilder — The builder, for chaining.

Sets the conditional format rule to criteria defined by BooleanCriteria values, typically taken from the criteria and arguments of an existing rule.

ConditionalFormatRuleBuilder — The builder, for chaining.

---

## Class Config Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/data-studio/config

**Contents:**
- Class Config Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
  - Methods
- Detailed documentation
  - build()
    - Return
  - newCheckbox()
    - Return
  - newInfo()
    - Return

Config contains the configuration entries for a connector, defining the questions asked when adding a new connector.

The build() method validates the Config object and returns it in the format needed by Data Studio.

Config offers methods to create various configuration entry types like checkbox, info, select multiple, select single, text area, and text input.

Methods like setDateRangeRequired() and setIsSteppedConfig() allow for setting specific behaviors for the connector configuration.

Contains the configuration entries for a connector. These configuration entries define what questions are asked when adding a new connector.

Validates this object and returns it in the format needed by Data Studio.

Object — The validated Config object.

Returns a new checkbox configuration entry.

Checkbox — A new checkbox configuration entry.

Returns a new info configuration entry.

Info — A new info configuration entry.

Returns a new options builder.

OptionBuilder — A new options builder.

Returns a new select multiple configuration entry.

SelectMultiple — A new select multiple configuration entry.

Returns a new select single configuration entry.

SelectSingle — A new select single configuration entry.

Returns a new text area configuration entry.

TextArea — A new text area configuration entry.

Returns a new text input configuration entry.

TextInput — A new text input configuration entry.

Prints the JSON representation of this object. This is for debugging only.

If true, a date range is provided for getData() requests.

Config — This builder, for chaining.

If true, getConfig() is called again with the current user configuration.

Config — This builder, for chaining.

---

## Class ConnectionSite Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/slides/connection-site

**Contents:**
- Class ConnectionSite Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
  - Methods
- Detailed documentation
  - getIndex()
    - Return
    - Authorization
  - getPageElement()
    - Return
    - Authorization

A ConnectionSite is a point on a PageElement that can connect to a connector.

The getIndex() method returns the unique index of a connection site among all connection sites on the same page element.

The getPageElement() method returns the PageElement that the connection site is located on.

The connection site on a PageElement that can connect to a connector.

Returns the index of the connection site. The index is unique among all the connection sites on the same page element.

In most cases, it corresponds to the predefined connection site index from the ECMA-376 standard. More information on those connection sites can be found in the description of the "cnx" attribute in section 20.1.9.9 and Annex H. "Predefined DrawingML Shape and Text Geometries" of "Office Open XML File Formats-Fundamentals and Markup Language Reference", part 1 of ECMA-376 5th edition.

Integer — The index of the connection site.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the PageElement that the connection site is on.

PageElement — The page element of the connection site.

Scripts that use this method require authorization with one or more of the following scopes:

---

## Class DataExecutionStatus Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/spreadsheet/data-execution-status

**Contents:**
- Class DataExecutionStatus Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
  - Methods
- Detailed documentation
  - getErrorCode()
    - Return
  - getErrorMessage()
    - Return
  - getExecutionState()
    - Return

The DataExecutionStatus object provides information about the status of a data execution.

It includes methods to retrieve the error code, error message, execution state, last execution time, and last refreshed time.

You can also check if the data from the last successful execution was truncated using the isTruncated() method.

The data execution status.

Gets the error code of the data execution.

DataExecutionErrorCode — The error code.

Gets the error message of the data execution. The message may be empty.

String — The error message.

Gets the state of the data execution.

DataExecutionState — The execution state.

Gets the time the last data execution completed regardless of the execution state.

Date — The last execution time, or null if there has never been a data execution.

Gets the time the data last successfully refreshed.

Date — The last successfully refreshed time, or null if there is never a successful data execution.

Returns true if the data from last successful execution is truncated, or false otherwise.

Boolean — True if the data from execution is truncated, or false otherwise.

---

## Class DataSourceChart Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/spreadsheet/data-source-chart

**Contents:**
- Class DataSourceChart Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
  - Methods
- Detailed documentation
  - cancelDataRefresh()
    - Return
    - Authorization
  - forceRefreshData()
    - Return
    - Authorization

The DataSourceChart class is used to access and modify existing data source charts linked to a BigQuery database.

You can cancel a running data refresh using cancelDataRefresh() or force a refresh regardless of state with forceRefreshData().

The getDataSource() method retrieves the linked data source and getStatus() provides the current data execution status.

refreshData() initiates a data refresh and waitForCompletion(timeoutInSeconds) waits for the current execution to finish within a specified time limit.

Access and modify an existing data source chart.

Only use this class with data that's connected to a BigQuery database.

Cancels the data refresh associated with this object if it's currently running.

This example shows how to cancel a formula refresh.

Throws an exception if the data source type is not enabled. Use SpreadsheetApp#enable...Execution() methods to enable data execution for specific data source type.

DataSourceChart — The data object.

Scripts that use this method require authorization with one or more of the following scopes:

Refreshes the data of this object regardless of the current state. See refreshData() for more details. If you want to cancel a currently running refresh of this object, see cancelDataRefresh().

Throws an exception if the data source type is not enabled. Use SpreadsheetApp#enable...Execution() methods to enable data execution for specific data source type.

DataSourceChart — The data object.

Scripts that use this method require authorization with one or more of the following scopes:

Gets the data source the object is linked to.

DataSource — The data source.

Scripts that use this method require authorization with one or more of the following scopes:

Gets the data execution status of the object.

DataExecutionStatus — The data execution status.

Scripts that use this method require authorization with one or more of the following scopes:

Refreshes the data of the object.

Throws an exception if currently in error state. Use DataSource#updateSpec() to update the specification. The method is preferred over forceRefreshData() to prevent unexpected edits on data source.

Throws an exception if the data source type is not enabled. Use SpreadsheetApp#enable...Execution() methods to enable data execution for specific data source type.

DataSourceChart — The data object.

Scripts that use this method require authorization with one or more of the following scopes:

Waits until the current execution completes, timing out after the provided number of seconds. Throws an exception if the execution is not completed when timing out, but does not cancel the data execution.

DataExecutionStatus — The data execution status.

Scripts that use this method require authorization with one or more of the following scopes:

---

## Class DataSourceFormula Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/spreadsheet/data-source-formula

**Contents:**
- Class DataSourceFormula Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
  - Methods
- Detailed documentation
  - cancelDataRefresh()
    - Return
    - Authorization
  - forceRefreshData()
    - Return
    - Authorization

Use DataSourceFormula to access and modify existing data source formulas, but use Range.setFormula(formula) to create a new one.

This class is specifically for data connected to a BigQuery database.

Methods are available to cancel, force, or simply refresh data, get information about the formula and its status, and set a new formula.

Scripts using these methods require specific authorization scopes related to spreadsheets.

Access and modify existing data source formulas. To create a new data source formula, use Range.setFormula(formula).

Only use this class with data that's connected to a BigQuery database.

Cancels the data refresh associated with this object if it's currently running.

This example shows how to cancel a formula refresh.

Throws an exception if the data source type is not enabled. Use SpreadsheetApp#enable...Execution() methods to enable data execution for specific data source type.

DataSourceFormula — The data object.

Scripts that use this method require authorization with one or more of the following scopes:

Refreshes the data of this object regardless of the current state. See refreshData() for more details. If you want to cancel a currently running refresh of this object, see cancelDataRefresh().

Throws an exception if the data source type is not enabled. Use SpreadsheetApp#enable...Execution() methods to enable data execution for specific data source type.

DataSourceFormula — The data object.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the Range representing the cell where this data source formula is anchored.

Range — The anchor cell.

Scripts that use this method require authorization with one or more of the following scopes:

Gets the data source the object is linked to.

DataSource — The data source.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the display value of the data source formula.

String — The display value.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the formula for this data source formula.

String — The formula.

Scripts that use this method require authorization with one or more of the following scopes:

Gets the data execution status of the object.

DataExecutionStatus — The data execution status.

Scripts that use this method require authorization with one or more of the following scopes:

Refreshes the data of the object.

Throws an exception if currently in error state. Use DataSource#updateSpec() to update the specification. The method is preferred over forceRefreshData() to prevent unexpected edits on data source.

Throws an exception if the data source type is not enabled. Use SpreadsheetApp#enable...Execution() methods to enable data execution for specific data source type.

DataSourceFormula — The data object.

Scripts that use this method require authorization with one or more of the following scopes:

DataSourceFormula — The data source formula, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Waits until the current execution completes, timing out after the provided number of seconds. Throws an exception if the execution is not completed when timing out, but does not cancel the data execution.

DataExecutionStatus — The data execution status.

Scripts that use this method require authorization with one or more of the following scopes:

---

## Class DataSourceParameter Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/spreadsheet/data-source-parameter

**Contents:**
- Class DataSourceParameter Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
  - Methods
- Detailed documentation
  - getName()
    - Return
  - getSourceCell()
    - Return
  - getType()
    - Return

DataSourceParameter allows you to access existing data source parameters, but should only be used with data connected to a database.

You can use getName() to retrieve the parameter name.

You can use getSourceCell() to get the source cell the parameter is valued based on, or null if the type is not CELL.

You can use getType() to get the parameter type.

Access existing data source parameters.

Only use this class with data that's connected to a database.

Gets the parameter name.

String — The parameter name.

Gets the source cell the parameter is valued based on, or null if the parameter type is not DataSourceParameterType.CELL.

String — The source cell, as specified in A1 notation.

Gets the parameter type.

DataSourceParameterType — The parameter type.

---

## Class DataSourcePivotTable Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/spreadsheet/data-source-pivot-table

**Contents:**
- Class DataSourcePivotTable Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
  - Methods
- Detailed documentation
  - addColumnGroup(columnName)
    - Parameters
    - Return
    - Authorization
  - addFilter(columnName, filterCriteria)
    - Parameters

Use this class to access and modify existing data source pivot tables, exclusively with data connected to a database.

You can add column groups, filters, and pivot values to the data source pivot table.

Methods are available to refresh, force refresh, cancel refresh, and check the status of the data source pivot table.

The asPivotTable() method allows you to return the data source pivot table as a regular pivot table object.

Access and modify existing data source pivot table. To create a new data source pivot table, use Range.createDataSourcePivotTable(dataSource).

Only use this class with data that's connected to a database.

Adds a new pivot column group based on the specified data source column.

PivotGroup — The new pivot group.

Scripts that use this method require authorization with one or more of the following scopes:

Adds a new filter based on the specified data source column with the specified filter criteria.

PivotFilter — The new filter.

Scripts that use this method require authorization with one or more of the following scopes:

Adds a new pivot value based on the specified data source column without any summarize function. For Looker measures only.

The following code shows how you can add a Looker measure as a pivot value.

This method is only available for Looker data sources.

PivotValue — The new pivot value.

Scripts that use this method require authorization with one or more of the following scopes:

Adds a new pivot value based on the specified data source column with the specified summarize function.

In order to add pivot values for Looker measures, use addPivotValue(columnName).

PivotValue — The new pivot value.

Scripts that use this method require authorization with one or more of the following scopes:

Adds a new pivot row group based on the specified data source column.

PivotGroup — The new pivot group.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the data source pivot table as a regular pivot table object.

PivotTable — The pivot table.

Scripts that use this method require authorization with one or more of the following scopes:

Cancels the data refresh associated with this object if it's currently running.

This example shows how to cancel a formula refresh.

Throws an exception if the data source type is not enabled. Use SpreadsheetApp#enable...Execution() methods to enable data execution for specific data source type.

DataSourcePivotTable — The data object.

Scripts that use this method require authorization with one or more of the following scopes:

Refreshes the data of this object regardless of the current state. See refreshData() for more details. If you want to cancel a currently running refresh of this object, see cancelDataRefresh().

Throws an exception if the data source type is not enabled. Use SpreadsheetApp#enable...Execution() methods to enable data execution for specific data source type.

DataSourcePivotTable — The data object.

Scripts that use this method require authorization with one or more of the following scopes:

Gets the data source the object is linked to.

DataSource — The data source.

Scripts that use this method require authorization with one or more of the following scopes:

Gets the data execution status of the object.

DataExecutionStatus — The data execution status.

Scripts that use this method require authorization with one or more of the following scopes:

Refreshes the data of the object.

Throws an exception if currently in error state. Use DataSource#updateSpec() to update the specification. The method is preferred over forceRefreshData() to prevent unexpected edits on data source.

Throws an exception if the data source type is not enabled. Use SpreadsheetApp#enable...Execution() methods to enable data execution for specific data source type.

DataSourcePivotTable — The data object.

Scripts that use this method require authorization with one or more of the following scopes:

Waits until the current execution completes, timing out after the provided number of seconds. Throws an exception if the execution is not completed when timing out, but does not cancel the data execution.

DataExecutionStatus — The data execution status.

Scripts that use this method require authorization with one or more of the following scopes:

---

## Class DataSourceSheet Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/spreadsheet/data-source-sheet

**Contents:**
- Class DataSourceSheet Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
  - Methods
- Detailed documentation
  - addFilter(columnName, filterCriteria)
    - Parameters
    - Return
    - Authorization
  - asSheet()
    - Return

Use the DataSourceSheet class to access and modify existing data source sheets linked to a database.

New data source sheets are created using the Spreadsheet.insertDataSourceSheet(spec) method.

Key methods include adding and removing filters and sort specs, auto-resizing and setting column widths, retrieving sheet values, and managing data refreshes.

You can also get the associated data source, the current execution status, or view the data source sheet as a regular sheet object.

Specific authorization scopes are required for scripts utilizing these methods, primarily related to accessing spreadsheet data.

Access and modify existing data source sheet. To create a new data source sheet, use Spreadsheet.insertDataSourceSheet(spec).

Only use this class with data that's connected to a database.

Adds a filter applied to the data source sheet.

DataSourceSheet — The data source sheet, for method chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the data source sheet as a regular sheet object.

Sheet — The regular sheet.

Scripts that use this method require authorization with one or more of the following scopes:

Auto resizes the width of the specified column.

DataSourceSheet — This data source sheet, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Auto resizes the width of the specified columns.

DataSourceSheet — This data source sheet, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Cancels the data refresh associated with this object if it's currently running.

This example shows how to cancel a formula refresh.

Throws an exception if the data source type is not enabled. Use SpreadsheetApp#enable...Execution() methods to enable data execution for specific data source type.

DataSourceSheet — The data object.

Scripts that use this method require authorization with one or more of the following scopes:

Refreshes the data of this object regardless of the current state. See refreshData() for more details. If you want to cancel a currently running refresh of this object, see cancelDataRefresh().

Throws an exception if the data source type is not enabled. Use SpreadsheetApp#enable...Execution() methods to enable data execution for specific data source type.

DataSourceSheet — The data object.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the width of the specified column.

Integer — The column's width, or null if the column uses the default width.

Scripts that use this method require authorization with one or more of the following scopes:

Gets the data source the object is linked to.

DataSource — The data source.

Scripts that use this method require authorization with one or more of the following scopes:

Returns all filters applied to the data source sheet.

DataSourceSheetFilter[] — An array of all filters applied to the data source sheet.

Scripts that use this method require authorization with one or more of the following scopes:

Returns all the values for the data source sheet for the provided column name.

Object[] — A one-dimensional array of values.

Scripts that use this method require authorization with one or more of the following scopes:

Returns all the values for the data source sheet for the provided column name from the provided start row (based-1) and up to the provided numRows.

Object[] — A one-dimensional array of values.

Scripts that use this method require authorization with one or more of the following scopes:

Gets all the sort specs in the data source sheet.

SortSpec[] — A list of sort specs.

Scripts that use this method require authorization with one or more of the following scopes:

Gets the data execution status of the object.

DataExecutionStatus — The data execution status.

Scripts that use this method require authorization with one or more of the following scopes:

Refreshes the data of the object.

Throws an exception if currently in error state. Use DataSource#updateSpec() to update the specification. The method is preferred over forceRefreshData() to prevent unexpected edits on data source.

Throws an exception if the data source type is not enabled. Use SpreadsheetApp#enable...Execution() methods to enable data execution for specific data source type.

DataSourceSheet — The data object.

Scripts that use this method require authorization with one or more of the following scopes:

Removes all filters applied to the data source sheet column.

DataSourceSheet — The data source sheet, for method chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Removes the sort spec on a column in the data source sheet.

DataSourceSheet — The data source sheet, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the width of the specified column.

DataSourceSheet — This data source sheet, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the width of the specified columns.

DataSourceSheet — This data source sheet, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the sort spec on a column in the data source sheet.

DataSourceSheet — The data source sheet, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the sort spec on a column in the data source sheet.

DataSourceSheet — The data source sheet, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Waits until the current execution completes, timing out after the provided number of seconds. Throws an exception if the execution is not completed when timing out, but does not cancel the data execution.

DataExecutionStatus — The data execution status.

Scripts that use this method require authorization with one or more of the following scopes:

---

## Class DataSourceSpecBuilder Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/spreadsheet/data-source-spec-builder

**Contents:**
- Class DataSourceSpecBuilder Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
  - Methods
- Detailed documentation
  - asBigQuery()
    - Return
  - asLooker()
    - Return
  - build()
    - Return

DataSourceSpecBuilder is used to create a specification for data sources connected to a database.

To start building a specification, use SpreadsheetApp.newDataSourceSpec().

Specific database types like BigQuery and Looker have dedicated builder methods like asBigQuery() and asLooker().

The build() method is used to finalize the specification from the builder's settings.

The builder for DataSourceSpec. To create a specification for certain type, use as...() method. To create a new builder, use SpreadsheetApp.newDataSourceSpec(). To use the specification, see DataSourceTable.

Only use this class with data that's connected to a database.

This example shows how to build a BigQuery data source specification.

This example shows how to build a Looker data source specification. It returns a LookerDataSourceSpec object after using build().

Gets the builder for BigQuery data source.

BigQueryDataSourceSpecBuilder — The BigQuery data source specification builder.

Gets the builder for Looker data source.

LookerDataSourceSpecBuilder — The Looker data source specification builder.

Builds a data source specification from the settings in this builder. Must use as...() to specify a data source type before building.

The following code sample builds a BigQuery DataSource Spec.

The following code sample builds a Looker DataSource Spec.

DataSourceSpec — The data source specification.

Creates a DataSourceSpecBuilder based on this data source's settings.

DataSourceSpecBuilder — The builder.

Gets the parameters of the data source.

This method is only available for BigQuery data sources.

DataSourceParameter[] — The parameter list.

Gets the type of the data source.

DataSourceType — The data source type.

Removes all the parameters.

DataSourceSpecBuilder — The builder, for chaining.

Removes the specified parameter.

DataSourceSpecBuilder — The builder, for chaining.

Adds a parameter, or if the parameter with the name exists, updates its source cell for data source spec builders of type DataSourceType.BIGQUERY.

This method is only available for BigQuery data sources.

DataSourceSpecBuilder — The builder, for chaining.

---

## Class DataSourceSpec Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/spreadsheet/data-source-spec

**Contents:**
- Class DataSourceSpec Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
  - Methods
- Detailed documentation
  - asBigQuery()
    - Return
  - asLooker()
    - Return
  - copy()
    - Return

DataSourceSpec allows access to the general settings of an existing data source spec.

Use as...() methods to access data source specs for specific types like BigQuery or Looker.

This class should only be used with data connected to a database.

You can create a DataSourceSpecBuilder based on an existing spec's settings using the copy() method.

You can retrieve the parameters and the type of the data source spec using getParameters() and getType().

Access the general settings of an existing data source spec. To access data source spec for certain type, use as...() method. To create a new data source spec, use SpreadsheetApp.newDataSourceSpec().

Only use this class with data that's connected to a database.

This example shows how to get information from a BigQuery data source spec.

This example shows how to get information from a Looker data source spec. Using asLooker() returns a LookerDataSourceSpec object.

Gets the spec for BigQuery data source.

BigQueryDataSourceSpec — The BigQuery data source spec.

Gets the spec for Looker data source.

LookerDataSourceSpec — The Looker data source spec.

Creates a DataSourceSpecBuilder based on this data source's settings.

DataSourceSpecBuilder — The builder.

Gets the parameters of the data source.

This method is only available for BigQuery data sources.

DataSourceParameter[] — The parameter list.

Gets the type of the data source.

DataSourceType — The data source type.

---

## Class DataSourceTable Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/spreadsheet/data-source-table

**Contents:**
- Class DataSourceTable Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
  - Methods
- Detailed documentation
  - addColumns(columnNames)
    - Parameters
    - Return
    - Authorization
  - addFilter(columnName, filterCriteria)
    - Parameters

The DataSourceTable class is used to access and modify existing data source tables, specifically with BigQuery data sources.

You can create a new data source table using Spreadsheet.insertSheetWithDataSourceTable(spec) and access it via dataSheet.getDataSourceTables()[0].

Data source tables allow adding columns, filters, and sort specifications to the data.

You can refresh the data in a DataSourceTable using refreshData() or forceRefreshData(), and cancel a refresh with cancelDataRefresh().

The status of data execution for a DataSourceTable can be retrieved using getStatus() and you can wait for completion using waitForCompletion().

Access and modify existing data source table. To create a new data source table on a new sheet, use Spreadsheet.insertSheetWithDataSourceTable(spec).

Only use this class with BigQuery data sources.

This example shows how to create a new data source table.

This example shows how to edit a data source.

Adds columns to the data source table.

DataSourceTable — The data source table, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Adds a filter applied to the data source table.

DataSourceTable — The data source table, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Adds a sort spec on a column in the data source table.

DataSourceTable — The data source sheet, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Adds a sort spec on a column in the data source table.

DataSourceTable — The data source sheet, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Cancels the data refresh associated with this object if it's currently running.

This example shows how to cancel a formula refresh.

Throws an exception if the data source type is not enabled. Use SpreadsheetApp#enable...Execution() methods to enable data execution for specific data source type.

DataSourceTable — The data object.

Scripts that use this method require authorization with one or more of the following scopes:

Refreshes the data of this object regardless of the current state. See refreshData() for more details. If you want to cancel a currently running refresh of this object, see cancelDataRefresh().

Throws an exception if the data source type is not enabled. Use SpreadsheetApp#enable...Execution() methods to enable data execution for specific data source type.

DataSourceTable — The data object.

Scripts that use this method require authorization with one or more of the following scopes:

Gets all the data source columns added to the data source table.

DataSourceTableColumn[] — A list of data source table columns.

Scripts that use this method require authorization with one or more of the following scopes:

Gets the data source the object is linked to.

DataSource — The data source.

Scripts that use this method require authorization with one or more of the following scopes:

Returns all filters applied to the data source table.

DataSourceTableFilter[] — An array of all filters applied to the data source table.

Scripts that use this method require authorization with one or more of the following scopes:

Gets the Range this data source table spans.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the row limit for the data source table.

Integer — The row limit for the data source table, or null if no limit is set and the table uses the default max limit as in Google Sheets UI.

Scripts that use this method require authorization with one or more of the following scopes:

Gets all the sort specs in the data source table.

SortSpec[] — A list of sort specs.

Scripts that use this method require authorization with one or more of the following scopes:

Gets the data execution status of the object.

DataExecutionStatus — The data execution status.

Scripts that use this method require authorization with one or more of the following scopes:

Returns whether the data source table is syncing all columns in the associated data source.

Boolean — True if the data source table is syncing all columns in the associated data source, or false otherwise.

Scripts that use this method require authorization with one or more of the following scopes:

Refreshes the data of the object.

Throws an exception if currently in error state. Use DataSource#updateSpec() to update the specification. The method is preferred over forceRefreshData() to prevent unexpected edits on data source.

Throws an exception if the data source type is not enabled. Use SpreadsheetApp#enable...Execution() methods to enable data execution for specific data source type.

DataSourceTable — The data object.

Scripts that use this method require authorization with one or more of the following scopes:

Removes all the columns in the data source table.

DataSourceTable — The data source table, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Removes all the sort specs in the data source table.

DataSourceTable — The data source sheet, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Updates the row limit for the data source table. If the provided row limit is null, then updates the data source table to use the default max row limit as in Google Sheets UI.

DataSourceTable — The data source table, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sync all current and future columns in the associated data source to the data source table.

DataSourceTable — The data source table, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Waits until the current execution completes, timing out after the provided number of seconds. Throws an exception if the execution is not completed when timing out, but does not cancel the data execution.

DataExecutionStatus — The data execution status.

Scripts that use this method require authorization with one or more of the following scopes:

---

## Class DataSource Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/spreadsheet/data-source

**Contents:**
- Class DataSource Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
  - Methods
- Detailed documentation
  - cancelAllLinkedDataSourceObjectRefreshes()
    - Authorization
  - createCalculatedColumn(name, formula)
    - Parameters
    - Return
    - Authorization

The DataSource class is used to access and modify existing data sources connected to a database.

You can create calculated columns and new pivot or data source tables on new sheets using this class.

The class provides methods to retrieve columns, calculated columns, and associated data source sheets.

You can refresh or cancel refreshes for linked data source objects and update the data source specification.

You can wait for data executions linked to the data source to complete within a specified timeout.

Access and modify existing data source. To create a data source table with new data source, see DataSourceTable.

Only use this class with data that's connected to a database.

Cancels all currently running refreshes of data source objects linked to this data source.

This example shows how to cancel all the refreshes of a data source.

Throws an exception if the data source type is not enabled. Use SpreadsheetApp#enable...Execution() methods to enable data execution for the specific data source type.

Scripts that use this method require authorization with one or more of the following scopes:

Creates a calculated column. This method is only available for BigQuery data sources.

DataSourceColumn — The newly created calculated column.

Scripts that use this method require authorization with one or more of the following scopes:

Creates a data source pivot table from this data source in the first cell of a new sheet. As a side effect, makes the new sheet the active sheet.

DataSourcePivotTable — The newly created data source pivot table.

Scripts that use this method require authorization with one or more of the following scopes:

Creates a data source table from this data source in the first cell of a new sheet. As a side effect, makes the new sheet the active sheet.

This method is only available for BigQuery data sources.

DataSourceTable — The newly created data source table.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the calculated column in the data source that matches the column name.

DataSourceColumn — The calculated column that matches the column name, or null if there is no such calculated column.

Scripts that use this method require authorization with one or more of the following scopes:

Returns all the calculated columns in the data source.

Data source specs of DataSourceType.LOOKER type returns an empty array.

DataSourceColumn[] — An array of all the calculated columns in the data source.

Scripts that use this method require authorization with one or more of the following scopes:

Returns all the columns in the data source.

DataSourceColumn[] — An array of all the DataSourceColumn in the data source.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the data source sheets associated with this data source.

DataSourceSheet[] — An array of data source sheets.

Scripts that use this method require authorization with one or more of the following scopes:

Gets the data source specification.

DataSourceSpec — The data source specification.

Scripts that use this method require authorization with one or more of the following scopes:

Refreshes all data source objects linked to the data source.

Throws an exception if the data source type is not enabled. Use SpreadsheetApp#enable...Execution() methods to enable data execution for the specific data source type.

Scripts that use this method require authorization with one or more of the following scopes:

Updates the data source specification and refreshes the data source objects linked with this data source with the new specification.

Throws an exception if the data source type is not enabled. Use SpreadsheetApp#enable...Execution() methods to enable data execution for the specific data source type.

Throws an exception if the data source specification type is of a different type than the current data source type.

DataSource — The data source.

Scripts that use this method require authorization with one or more of the following scopes:

Updates the data source specification and refreshes the linked data source sheets with the new specification.

Throws an exception if the data source type is not enabled. Use SpreadsheetApp#enable...Execution() methods to enable data execution for the specific data source type.

Throws an exception if the data source specification type is of a different type than the current data source type.

DataSource — The data source.

Scripts that use this method require authorization with one or more of the following scopes:

Waits until all the current executions of the linked data source objects complete, timing out after the provided number of seconds. Throws an exception if the executions are not completed when timing out, but does not cancel the data executions.

Scripts that use this method require authorization with one or more of the following scopes:

---

## Class DataValidationBuilder Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/spreadsheet/data-validation-builder

**Contents:**
- Class DataValidationBuilder Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
  - Methods
- Detailed documentation
  - build()
    - Return
  - copy()
    - Return
  - getAllowInvalid()
    - Return

The DataValidationBuilder is used to construct data validation rules in a spreadsheet.

You can define rules to require specific data types like dates, numbers, text, or values from a list or range.

Builders can be copied to easily modify existing data validation rules.

You can configure whether invalid input results in a warning or is rejected entirely.

Help text can be set to appear when a user hovers over a cell with data validation.

Builder for data validation rules.

Constructs a data validation rule from the settings applied to the builder.

DataValidation — a representation of the data validation rule

Creates a builder for a data validation rule based on this rule's settings.

DataValidationBuilder — a builder based on this rule's settings

Returns true if the rule shows a warning when input fails data validation, or false if it rejects the input entirely. The default for new data validation rules is true.

Boolean — true if the rule allows input that fails data validation; false if not

Gets the rule's criteria type as defined in the DataValidationCriteria enum. To get the arguments for the criteria, use getCriteriaValues(). To use these values to create or modify a data validation rule, see withCriteria(criteria, args).

DataValidationCriteria — the type of data validation criteria

Gets an array of arguments for the rule's criteria. To get the criteria type, use getCriteriaType(). To use these values to create or modify a data validation rule, see withCriteria(criteria, args).

Object[] — an array of arguments appropriate to the rule's criteria type; the number of arguments and their type match the corresponding require...() method of the DataValidationBuilder class

Gets the rule's help text, or null if no help text is set.

String — the rule's help text, or null if no help text is set

Sets the data validation rule to require that the input is a boolean value; this value is rendered as a checkbox.

DataValidationBuilder — this builder, for chaining

Sets the data validation rule to require that the input is the specified value or blank. When the input matches the specified value the cell is rendered as a checked checkbox. When the input is blank the cell is rendered as an unchecked checkbox.

DataValidationBuilder — this builder, for chaining

Sets the data validation rule to require that the input is one of the specified values. When the input is checkedValue the cell is rendered as a checked checkbox. When the input is uncheckedValue the cell is rendered as an unchecked checkbox.

DataValidationBuilder — this builder, for chaining

Sets the data validation rule to require a date.

DataValidationBuilder — this builder, for chaining

Sets the data validation rule to require a date after the given value. The time fields of the Date object are ignored; only the day, month, and year fields are used.

DataValidationBuilder — this builder, for chaining

Sets the data validation rule to require a date before the given value. The time fields of the Date object are ignored; only the day, month, and year fields are used.

DataValidationBuilder — this builder, for chaining

Sets the data validation rule to require a date that falls between, or is either of, two specified dates. The time fields of the Date objects are ignored; only the day, month, and year fields are used.

DataValidationBuilder — this builder, for chaining

Sets the data validation rule to require a date equal to the given value. The time fields of the Date object are ignored; only the day, month, and year fields are used.

DataValidationBuilder — this builder, for chaining

Sets the data validation rule to require a date that does not fall between, and is neither of, two specified dates. The time fields of the Date objects are ignored; only the day, month, and year fields are used.

DataValidationBuilder — this builder, for chaining

Sets the data validation rule to require a date on or after the given value. The time fields of the Date object are ignored; only the day, month, and year fields are used.

DataValidationBuilder — this builder, for chaining

Sets the data validation rule to require a date on or before the given value. The time fields of the Date object are ignored; only the day, month, and year fields are used.

DataValidationBuilder — this builder, for chaining

Sets the data validation rule to require that the given formula evaluates to true.

DataValidationBuilder — this builder, for chaining

Sets the data validation rule to require a number that falls between, or is either of, two specified numbers.

DataValidationBuilder — this builder, for chaining

Sets the data validation rule to require a number equal to the given value.

DataValidationBuilder — this builder, for chaining

Sets the data validation rule to require a number greater than the given value.

DataValidationBuilder — this builder, for chaining

Sets the data validation rule to require a number greater than or equal to the given value.

DataValidationBuilder — this builder, for chaining

Sets the data validation rule to require a number less than the given value.

DataValidationBuilder — this builder, for chaining

Sets the data validation rule to require a number less than or equal to the given value.

DataValidationBuilder — this builder, for chaining

Sets the data validation rule to require a number that does not fall between, and is neither of, two specified numbers.

DataValidationBuilder — this builder, for chaining

Sets the data validation rule to require a number not equal to the given value.

DataValidationBuilder — this builder, for chaining

Sets the data validation rule to require that the input contains the given value.

DataValidationBuilder — this builder, for chaining

Sets the data validation rule to require that the input does not contain the given value.

DataValidationBuilder — this builder, for chaining

Sets the data validation rule to require that the input is equal to the given value.

DataValidationBuilder — this builder, for chaining

Sets the data validation rule to require that the input is in the form of an email address.

DataValidationBuilder — this builder, for chaining

Sets the data validation rule to require that the input is in the form of a URL.

DataValidationBuilder — this builder, for chaining

Sets the data validation rule to require that the input is equal to one of the given values.

DataValidationBuilder — this builder, for chaining

Sets the data validation rule to require that the input is equal to one of the given values, with an option to hide the dropdown menu.

DataValidationBuilder — this builder, for chaining

Sets the data validation rule to require that the input is equal to a value in the given range.

DataValidationBuilder — this builder, for chaining

Sets the data validation rule to require that the input is equal to a value in the given range, with an option to hide the dropdown menu.

DataValidationBuilder — this builder, for chaining

Sets whether to show a warning when input fails data validation or whether to reject the input entirely. The default for new data validation rules is true.

DataValidationBuilder — this builder, for chaining

Sets the help text that appears when the user hovers over the cell on which data validation is set.

DataValidationBuilder — this builder, for chaining

Sets the data validation rule to criteria defined by DataValidationCriteria values, typically taken from the criteria and arguments of an existing rule.

DataValidationBuilder — this builder, for chaining

---

## Class DatePicker Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/card-service/date-picker

**Contents:**
- Class DatePicker Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
  - Methods
- Detailed documentation
  - setFieldName(fieldName)
    - Parameters
    - Return
  - setOnChangeAction(action)
    - Parameters
    - Return

DatePicker is an input field for selecting a date in Google Workspace add-ons and Google Chat apps.

Key methods include setting the field name, title, and default value, as well as defining an action when the input changes.

The setValueInMsSinceEpoch method can accept the default date value as either a number or a string representing milliseconds since the epoch.

An input field that allows inputing a date.

Available for Google Workspace add-ons and Google Chat apps.

Sets the field name that identifies this picker in the event object that is generated when there is a UI interaction. The field name is visible to the user. Required; the specified field name must be unique.

DatePicker — This picker, for chaining.

Sets an Action that the script performs whenever the picker input changes.

DatePicker — This picker, for chaining.

Sets the title displayed above the input field.

DatePicker — This picker, for chaining.

Sets the prefilled value to be set in the input field.

DatePicker — This picker, for chaining.

Sets the prefilled value to be set in the input field.

DatePicker — This picker, for chaining.

---

## Class DateTimePicker Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/card-service/date-time-picker

**Contents:**
- Class DateTimePicker Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
  - Methods
- Detailed documentation
  - setFieldName(fieldName)
    - Parameters
    - Return
  - setHostAppDataSource(hostAppDataSource)
    - Parameters
    - Return

The DateTimePicker is an input field for selecting a date and time, supporting form submission validation.

It is available for Google Workspace add-ons and Google Chat apps.

Key methods include setting the field name, defining an action on change, setting the time zone offset, setting the title, and setting the default value in milliseconds since the epoch.

An input field that allows users to input a date and time.

Supports form submission validation. When Action.setAllWidgetsAreRequired(allWidgetsAreRequired) is set to true or this widget is specified through Action.addRequiredWidget(requiredWidget), the submission action is blocked unless a value is selected.

Available for Google Workspace add-ons and Google Chat apps.

Sets the field name that identifies this picker in the event object that is generated when there is a UI interaction. The field name is visible to the user. Required; the specified field name must be unique.

DateTimePicker — This picker, for chaining.

In a Google Workspace flow, lets input variables accept datetime outputs from other steps in the flow. For example, receive the time a gmail message was sent or the date on which a calendar event is scheduled.

Only available through the Gemini Alpha program for Google Workspace add-ons that extend Google Workspace Flows.

DateTimePicker — This picker, for chaining.

Sets an Action that the script performs whenever the picker input changes.

DateTimePicker — This picker, for chaining.

Sets the number of minutes that the time zone should be offset from UTC. If set, the date and time is displayed in the specified time zone. If not set, the time is displayed in the user's time zone.

DateTimePicker — This picker, for chaining.

Sets the title displayed above the input field.

DateTimePicker — This picker, for chaining.

Sets the prefilled value to be set in the input field.

DateTimePicker — This picker, for chaining.

Sets the prefilled value to be set in the input field.

DateTimePicker — This picker, for chaining.

---

## Class Date Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/document/date

**Contents:**
- Class Date Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
  - Methods
- Detailed documentation
  - copy()
    - Return
    - Authorization
  - getAttributes()
    - Return
    - Authorization

A Date element represents a formatted date and includes methods to retrieve and set its attributes, display text, locale, and timestamp.

The element provides methods for document structure manipulation like getting siblings and parent, checking if it's at the document end, merging with a preceding sibling, and removing itself from its parent.

The element can be copied to create a detached, deep copy including any child elements.

An element representing a formatted date

Returns a detached, deep copy of the current element.

Any child elements present in the element are also copied. The new element doesn't have a parent.

Scripts that use this method require authorization with one or more of the following scopes:

Retrieves the element's attributes.

The result is an object containing a property for each valid element attribute where each property name corresponds to an item in the DocumentApp.Attribute enumeration.

Object — The element's attributes.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the display value that's rendered in the document. The display value uses the UTC timezone and the date's locale. For example, Jul 16, 2021.

String — The display value.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the date's locale used for the display value. For example, en.

String — The locale of the date.

Scripts that use this method require authorization with one or more of the following scopes:

Retrieves the element's next sibling element.

The next sibling has the same parent and follows the current element.

Element — The next sibling element.

Scripts that use this method require authorization with one or more of the following scopes:

Retrieves the element's parent element.

The parent element contains the current element.

ContainerElement — The parent element.

Scripts that use this method require authorization with one or more of the following scopes:

Retrieves the element's previous sibling element.

The previous sibling has the same parent and precedes the current element.

Element — The previous sibling element.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the timestamp associated with the date.

Date — The timestamp.

Scripts that use this method require authorization with one or more of the following scopes:

Retrieves the element's ElementType.

Use getType() to determine the exact type of a given element.

ElementType — The element type.

Scripts that use this method require authorization with one or more of the following scopes:

Determines whether the element is at the end of the Document.

Boolean — Whether the element is at the end of the tab.

Scripts that use this method require authorization with one or more of the following scopes:

Merges the element with the preceding sibling of the same type.

Only elements of the same ElementType can be merged. Any child elements contained in the current element are moved to the preceding sibling element.

The current element is removed from the document.

Date — The merged element.

Scripts that use this method require authorization with one or more of the following scopes:

Removes the element from its parent.

Date — The removed element.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the element's attributes.

The specified attributes parameter must be an object where each property name is an item in the DocumentApp.Attribute enumeration and each property value is the new value to be applied.

Date — The current element.

Scripts that use this method require authorization with one or more of the following scopes:

---

## Class DebugError Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/data-studio/debug-error

**Contents:**
- Class DebugError Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
  - Methods
- Detailed documentation
  - printJson()
    - Return
  - setText(text)
    - Parameters
    - Return
  - throwException()

DebugError is an error only visible to connector admins.

The setText() method is used to set the error text which is only shown to admins.

The throwException() method triggers the debug error to be thrown.

An error that is only visible to admins of the connector.

Prints the JSON representation of this object. This is for debugging only.

Sets the text of the debug error, which is only shown to admins.

DebugError — This object, for chaining.

Triggers this exception to be thrown.

---

## Class DecoratedText Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/card-service/decorated-text

**Contents:**
- Class DecoratedText Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
  - Methods
- Detailed documentation
  - setAuthorizationAction(action)
    - Parameters
    - Return
  - setBottomLabel(text)
    - Parameters
    - Return

DecoratedText is a widget for displaying text with optional icons, and labels above or below.

Setting the text content and either a top label, bottom label, or icon is required for this widget.

DecoratedText is designed to replace the KeyValue widget and is available for Google Workspace add-ons and Google Chat apps.

A widget that displays text with optional decorations. Possible keys include an icon, a label above and a label below. Setting the text content and one of the keys is required using setText(text) and one of DecoratedText, DecoratedText, setTopLabel(text), or setBottomLabel(text). This class is intended to replace KeyValue.

Available for Google Workspace add-ons and Google Chat apps.

Sets an authorization action that opens a URL to the authorization flow when the object is clicked. This opens the URL in a new window. When the user finishes the authorization flow and returns to the application, the add-on reloads.

A UI object can only have one of setOpenLink(openLink), setOnClickAction(action), setOnClickOpenLinkAction(action), setAuthorizationAction(action), or setComposeAction(action, composedEmailType) set.

DecoratedText — This object, for chaining.

Sets the label text to be used as the key and is displayed below the text content.

DecoratedText — This object, for chaining.

Sets the Button that is displayed to the right of the text. A DecoratedText can only support one button or one switch.

DecoratedText — This object, for chaining.

Sets an action that composes a draft email when the object is clicked. A UI object can only have one of setOpenLink(openLink), setOnClickAction(action), setOnClickOpenLinkAction(action), setAuthorizationAction(action), or setComposeAction(action, composedEmailType) set.

The Action parameter must specify a callback function that returns a ComposeActionResponse object configured using ComposeActionResponseBuilder.setGmailDraft(draft).

Note: This method doesn't set a compose action that is used to extend the compose UI. Rather, this method connects this UI element to an Action that composes draft messages in Apps Script that are opened in Gmail when the action completes.

DecoratedText — This object, for chaining.

Sets the optional IconImage that is displayed to the right of the content. A DecoratedText can only support one button, one switch or one icon.

DecoratedText — This object, for chaining.

Sets an action that executes when the object is clicked. A UI object can only have one of setOpenLink(openLink), setOnClickAction(action), setOnClickOpenLinkAction(action), setAuthorizationAction(action), or setComposeAction(action, composedEmailType) set.

The Action parameter must specify a callback function that returns a ActionResponse object.

DecoratedText — This object, for chaining.

Sets an action that opens a URL in a tab when the object is clicked. Use this function when the URL needs to be built or when you need to take other actions in addition to creating the OpenLink object. A UI object can only have one of setOpenLink(openLink), setOnClickAction(action), setOnClickOpenLinkAction(action), setAuthorizationAction(action), or setComposeAction(action, composedEmailType) set.

The Action parameter must specify a callback function that returns a ActionResponse object configured using ActionResponseBuilder.setOpenLink(openLink).

DecoratedText — This object, for chaining.

Sets a URL to be opened when the object is clicked. Use this function when the URL is already known and only needs to be opened. A UI object can only have one of setOpenLink(openLink), setOnClickAction(action), setOnClickOpenLinkAction(action), setAuthorizationAction(action), or setComposeAction(action, composedEmailType) set.

DecoratedText — This object, for chaining.

Sets the optional IconImage to display before the text content.

DecoratedText — This object, for chaining.

Sets the Switch that is displayed to the right of the content. A DecoratedText can only support one button or one switch.

DecoratedText — This object, for chaining.

Sets the text to be used as the value. Supports basic HTML formatting. Required.

DecoratedText — This object, for chaining.

Sets the label text to be used as the key and is displayed above the text content.

DecoratedText — This object, for chaining.

Sets whether the value text should be displayed on a single line or multiple lines.

DecoratedText — This object, for chaining.

---

## Class Document Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/document/document

**Contents:**
- Class Document Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
  - Methods
- Detailed documentation
  - addBookmark(position)
    - Parameters
    - Return
    - Authorization
  - addEditor(emailAddress)
    - Parameters

Documents can contain one or more tabs, each with rich text and elements like tables and lists.

Documents can be opened or created using DocumentApp.

Methods that modify text contents operate on the active or first tab; scripts can be migrated to support tabs using getTabs() and Tab.asDocumentTab().

The Document class provides methods for managing document content, permissions, and properties, such as adding elements like bookmarks, footers, and headers, managing editors and viewers, and retrieving document information like ID, language, name, and URL.

A document, containing one or more Tab objects, each of which contains rich text and elements such as tables and lists.

Documents may be opened or created using DocumentApp.

Methods on the Document class that directly access and modify text contents operate on either the active tab (in scripts bound to a particular document) or the first tab (if an active one isn't available). Scripts relying on these methods (for example, getBody()) can be migrated to support tabs using getTabs() and then Tab.asDocumentTab().

Adds a Bookmark at the given Position to the first tab or, for scripts that are bound to a document, the active tab. To add a bookmark to any tab, use the DocumentTab.addBookmark(position) method.

Bookmark — The new bookmark.

Scripts that use this method require authorization with one or more of the following scopes:

Adds the given user to the list of editors for the Document. If the user was already on the list of viewers, this method promotes the user out of the list of viewers.

Document — This Document, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Adds the given user to the list of editors for the Document. If the user was already on the list of viewers, this method promotes the user out of the list of viewers.

Document — This Document, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Adds the given array of users to the list of editors for the Document. If any of the users were already on the list of viewers, this method promotes them out of the list of viewers.

Document — This Document, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Adds a footer section, if none exists, to the first tab or, for scripts that are bound to a document, the active tab. To add a footer section to any tab, use the DocumentTab.addFooter() method.

FooterSection — The tab footer.

Scripts that use this method require authorization with one or more of the following scopes:

Adds a header section, if none exists, to the first tab or, for scripts that are bound to a document, the active tab. To add a header section to any tab, use the DocumentTab.addHeader() method.

HeaderSection — The tab header.

Scripts that use this method require authorization with one or more of the following scopes:

Adds a NamedRange, which is a Range that has a name and ID to use for later retrieval, in the first tab or, for scripts that are bound to a document, the active tab. To add a NamedRange in any tab, use the DocumentTab.addNamedRange(name, range) method. Names aren't necessarily unique; several different ranges in the same document can share the same name, much like a class in HTML. By contrast, IDs are unique within the document, like an ID in HTML. After you add a NamedRange to a document, you can't modify it, you can only remove it.

Any script that accesses the document can access a NamedRange. To avoid unintended conflicts between scripts, consider prefixing range names with a unique string.

NamedRange — The NamedRange.

Scripts that use this method require authorization with one or more of the following scopes:

Adds the given user to the list of viewers for the Document. If the user was already on the list of editors, this method has no effect.

Document — This Document, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Adds the given user to the list of viewers for the Document. If the user was already on the list of editors, this method has no effect.

Document — This Document, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Adds the given array of users to the list of viewers for the Document. If any of the users were already on the list of editors, this method has no effect for them.

Document — This Document, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Gets the user's currently active Tab in the document. A script can only access the active tab of the user who is running the script, and only if the script is bound to the document.

Tab — The user's currently active Tab, or null if the script is not bound to the document.

Scripts that use this method require authorization with one or more of the following scopes:

Retrieves the current Document contents as a blob of the specified type.

Blob — The current document as a blob.

Retrieves the current Document contents as a blob.

Blob — The current document as a blob.

Retrieves the first tab's Body or, for scripts that are bound to a document, the active tab's DocumentBodySection. To get the DocumentBodySection of any tab, use the DocumentTab.getBody() method.

Tabs may contain different types of sections (for example, HeaderSection, FooterSection). The active section for a tab is the Body.

Element methods in Document delegate to the active Body.

Body — The tab body section.

Scripts that use this method require authorization with one or more of the following scopes:

Gets the Bookmark with the given ID in the first tab or, for scripts that are bound to a document, the active tab. To get a bookmark in any tab, use the DocumentTab.getBookmark(id) method. This method returns null if no such Bookmark exists within the tab.

Bookmark — The Bookmark with the given ID, or null if no such Bookmark exists within the tab.

Scripts that use this method require authorization with one or more of the following scopes:

Gets all Bookmark objects in the first tab or, for scripts that are bound to a document, the active tab. To get all bookmarks in any tab, use the DocumentTab.getBookmarks() method.

Bookmark[] — An array of the Bookmark objects in the tab.

Scripts that use this method require authorization with one or more of the following scopes:

Gets the user's cursor in the active tab. A script can only access the cursor of the user who is running the script, and only if the script is bound to the document.

Position — A representation of the user's cursor, or null if the user does not have a cursor placed in the tab or if the script is not bound to the document.

Scripts that use this method require authorization with one or more of the following scopes:

Gets the list of editors for this Document.

User[] — An array of users with edit permission.

Scripts that use this method require authorization with one or more of the following scopes:

Retrieves the first tab's footer section or, for scripts that are bound to a document, the active tab's footer section. To get the footer section of any tab, use the DocumentTab.getFooter() method.

FooterSection — The tab's footer.

Scripts that use this method require authorization with one or more of the following scopes:

Retrieves all the Footnote elements in the first tab's body or, for scripts that are bound to a document, the active tab's body. To get all the footnotes in any tab, use the DocumentTab.getFootnotes() method.

Calls to getFootnotes cause an iteration over the tab's elements. For large tabs, avoid unnecessary calls to this method.

Footnote[] — The tab's footnotes.

Scripts that use this method require authorization with one or more of the following scopes:

Retrieves the first tab's header section or, for scripts that are bound to a document, the active tab's header section. To get the header section of any tab, use the DocumentTab.getHeader() method.

HeaderSection — The tab's header.

Scripts that use this method require authorization with one or more of the following scopes:

Retrieves the document's unique identifier. The document ID is used with DocumentApp.openById() to open a specific document instance.

String — The document's ID.

Scripts that use this method require authorization with one or more of the following scopes:

Gets the document's language code. This is the language shown in the document editor's File > Language, which may not be the actual language that the document contains.

String — The document language, or null if not defined.

Scripts that use this method require authorization with one or more of the following scopes:

Retrieves the title of the document.

String — The document title.

Scripts that use this method require authorization with one or more of the following scopes:

Gets the NamedRange with the given ID in the first tab or, for scripts that are bound to a document, the active tab. To get the NamedRange with the given ID in any tab, use the DocumentTab.getNamedRangeById(id) method. This method returns null if no such NamedRange exists in the tab. Names are not necessarily unique, even across tabs; several different ranges in the same tab may share the same name, much like a class in HTML. By contrast, IDs are unique within the tab, like an ID in HTML.

NamedRange — The NamedRange with the given ID, or null if no such range exists in the tab.

Scripts that use this method require authorization with one or more of the following scopes:

Gets all NamedRange objects in the first tab or, for scripts that are bound to a document, the active tab. To get all NamedRange objects in any tab, use the DocumentTab.getNamedRanges() method.

A NamedRange can be accessed by any script that accesses the tab. To avoid unintended conflicts between scripts, consider prefixing range names with a unique string.

NamedRange[] — An array of the NamedRange objects in the tab, possibly including multiple ranges with the same name.

Scripts that use this method require authorization with one or more of the following scopes:

Gets all NamedRange objects with the given name in the first tab or, for scripts that are bound to a document, the active tab. To get all NamedRange objects in any tab, use the DocumentTab.getNamedRanges(name) method. Names are not necessarily unique, even across tabs; several different ranges in the same tab may share the same name, much like a class in HTML. By contrast, IDs are unique within the tab, like an ID in HTML.

A NamedRange can be accessed by any script that accesses the document. To avoid unintended conflicts between scripts, consider prefixing range names with a unique string.

NamedRange[] — An array of the NamedRange objects in the tab with the given name.

Scripts that use this method require authorization with one or more of the following scopes:

Gets the user's selection in the active tab. A script can only access the selection of the user who is running the script, and only if the script is bound to the document.

Range — A representation of the user's selection, or null if the user does not have anything selected in the tab, if only the end of a paragraph is selected, if only the end of a paragraph and a new line are selected, or if the script is not bound to the document.

Scripts that use this method require authorization with one or more of the following scopes:

Gets all language codes that are supported in Google Docs files.

String[] — An array of language codes.

Scripts that use this method require authorization with one or more of the following scopes:

Gets the Tab with the specified ID. This method returns null if no such Tab exists. Can access tabs at any nesting level.

Tab — The Tab with the specified ID, or null if no such Tab exists.

Scripts that use this method require authorization with one or more of the following scopes:

Gets all unnested Tabs that are part of the document.

Tabs can contain child tabs, a tab nested within another tab. Child tabs are accessible using Tab.getChildTabs().

Tab[] — The list of all Tabs that are part of the document.

Scripts that use this method require authorization with one or more of the following scopes:

Retrieves the URL to access the current document.

String — The URL to access the current document.

Scripts that use this method require authorization with one or more of the following scopes:

Gets the list of viewers and commenters for this Document.

User[] — An array of users with view or comment permission.

Scripts that use this method require authorization with one or more of the following scopes:

Creates a new Position, which is a reference to a location in the tab, relative to a specific element in the first tab or, for scripts that are bound to a document, the active tab. To create a Position relative to a location in any tab, use the DocumentTab.newPosition(element, offset) method. The user's cursor is represented as a Position, among other uses.

Position — The new Position.

Scripts that use this method require authorization with one or more of the following scopes:

Creates a builder used to construct Range objects from tab elements in the first tab or, for scripts that are bound to a document, the active tab. To create a builder used to construct DocumentRange objects from tab elements in any tab, use the DocumentTab.newRange() method.

RangeBuilder — The new builder.

Scripts that use this method require authorization with one or more of the following scopes:

Removes the given user from the list of editors for the Document. This method doesn't block users from accessing the Document if they belong to a class of users who have general access—for example, if the Document is shared with the user's entire domain, or if the Document is in a shared drive that the user can access.

For Drive files, this also removes the user from the list of viewers.

Document — This Document, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Removes the given user from the list of editors for the Document. This method doesn't block users from accessing the Document if they belong to a class of users who have general access—for example, if the Document is shared with the user's entire domain, or if the Document is in a shared drive that the user can access.

For Drive files, this also removes the user from the list of viewers.

Document — This Document, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Removes the given user from the list of viewers and commenters for the Document. This method has no effect if the user is an editor, not a viewer or commenter. This method also doesn't block users from accessing the Document if they belong to a class of users who have general access—for example, if the Document is shared with the user's entire domain, or if the Document is in a shared drive that the user can access.

For Drive files, this also removes the user from the list of editors.

Document — This Document for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Removes the given user from the list of viewers and commenters for the Document. This method has no effect if the user is an editor, not a viewer. This method also doesn't block users from accessing the Document if they belong to a class of users who have general access—for example, if the Document is shared with the user's entire domain, or if the Document is in a shared drive that the user can access.

For Drive files, this also removes the user from the list of editors.

Document — This Document for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Saves the current Document. Causes pending updates to be flushed and applied.

The saveAndClose() method is automatically invoked at the end of script execution for each open editable Document.

A closed Document can't be edited. Use DocumentApp.openById() to reopen a given document for editing.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the user's selected Tab in the current document to the tab with the specified ID.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the user's cursor, given a Position. A script can only access the cursor of the user who is running the script, and only if the script is bound to the document.

Providing a Position from an inactive Tab switches the user's active tab.

Document — This Document, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the document's language code. This is the language shown in the document editor's File > Language, which may not be the actual language that the document contains. Use getSupportedLanguageCodes() to get all the valid language codes.

Document — This Document, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the document title.

Document — The current document.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the user's selection in the active tab, given a Range. A script can only access the selection of the user who is running the script, and only if the script is bound to the document.

Document — This Document, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

---

## Class Drawing Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/spreadsheet/drawing

**Contents:**
- Class Drawing Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
  - Methods
- Detailed documentation
  - getContainerInfo()
    - Return
    - Authorization
  - getHeight()
    - Return
    - Authorization

The Drawing class represents a drawing object placed on a spreadsheet sheet.

You can retrieve information about a drawing's position, dimensions (height and width), attached macro, parent sheet, and z-index.

Drawings can be removed from the spreadsheet using the remove() method.

You can set the height, width, position, and z-index of a drawing using dedicated methods.

Macros can be assigned to drawings using the setOnAction() method.

Represents a drawing over a sheet in a spreadsheet.

Gets information about where the drawing is positioned in the sheet.

ContainerInfo — An object containing the drawing's container position.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the actual height of this drawing in pixels.

Integer — The height of the drawing in pixels.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the name of the macro attached to this drawing.

String — The macro name attached to this drawing.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the sheet this drawing appears on.

Sheet — The sheet the drawing appears on.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the actual width of this drawing in pixels.

Integer — The width of the drawing in pixels.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the z-index of this drawing.

Number — Z-Index of this drawing.

Scripts that use this method require authorization with one or more of the following scopes:

Deletes this drawing from the spreadsheet. Any further operation on the drawing results in a script error.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the actual height of this drawing in pixels.

Drawing — This drawing, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Assigns a macro function to this drawing.

Drawing — This drawing, for chaining.

Sets the position where the drawing appears on the sheet. The anchor row and column position indices are 1-indexed.

Drawing — This drawing, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the actual width of this drawing in pixels.

Drawing — This drawing, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the z-index of this drawing.

Drawing — This drawing, for chaining.

---

## Class DriveItemsSelectedActionResponseBuilder Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/card-service/drive-items-selected-action-response-builder

**Contents:**
- Class DriveItemsSelectedActionResponseBuilder Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
  - Methods
- Detailed documentation
  - build()
    - Return
  - requestFileScope(itemId)
    - Parameters
    - Return

The DriveItemsSelectedActionResponseBuilder is used to create DriveItemsSelectedActionResponse objects.

The build() method finalizes and returns the Drive action response object.

The requestFileScope(itemId) method allows the response to request file scope for a specific Drive item.

A builder for DriveItemsSelectedActionResponse objects.

Builds the current Drive action response.

DriveItemsSelectedActionResponse — A validated DriveItemsSelectedActionResponse.

Specifies that the response requests file scope for the contextually-relevant item in Drive.

DriveItemsSelectedActionResponseBuilder — This object, for chaining.

---

## Class DriveItemsSelectedActionResponse Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/card-service/drive-items-selected-action-response

**Contents:**
- Class DriveItemsSelectedActionResponse Stay organized with collections Save and categorize content based on your preferences.
  - Methods
- Detailed documentation
  - printJson()
    - Return

Represents a response that makes changes to Drive while Drive items are selected and in reaction to an action taken in the UI, such as a button click.

Prints the JSON representation of this object. This is for debugging only.

---

## Class EmbeddedAreaChartBuilder Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/spreadsheet/embedded-area-chart-builder

**Contents:**
- Class EmbeddedAreaChartBuilder Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
  - Methods
- Detailed documentation
  - addRange(range)
    - Parameters
    - Return
  - asAreaChart()
    - Return
  - asBarChart()

EmbeddedAreaChartBuilder is a builder specifically for area charts, providing methods to configure various aspects of the chart.

You can add or remove data ranges, set the chart's position, and build the final EmbeddedChart object using this builder.

The builder allows customization of chart appearance, including background color, line colors, legend position and style, point style, and axis titles and text styles.

You can change the chart type to other embedded chart types such as bar, column, line, pie, scatter, table, combo, or histogram charts using specific methods.

Advanced options can be set using the setOption(option, value) method, and you can also control hidden dimensions and data merging strategies.

Builder for area charts. For more details, see the Gviz documentation.

Adds a range to the chart this builder modifies. Does not add the range if it has already been added to the chart.

EmbeddedChartBuilder — This builder, for chaining.

Sets the chart type to AreaChart and returns an EmbeddedAreaChartBuilder.

EmbeddedAreaChartBuilder — A builder for an area chart.

Sets the chart type to BarChart and returns an EmbeddedBarChartBuilder.

EmbeddedBarChartBuilder — A builder for a bar chart.

Sets the chart type to ColumnChart and returns an EmbeddedColumnChartBuilder.

EmbeddedColumnChartBuilder — A builder for a column chart.

Sets the chart type to ComboChart and returns an EmbeddedComboChartBuilder.

EmbeddedComboChartBuilder — A builder for a combo chart.

Sets the chart type to HistogramChart and returns an EmbeddedHistogramChartBuilder.

EmbeddedHistogramChartBuilder — A builder for a histogram chart.

Sets the chart type to LineChart and returns an EmbeddedLineChartBuilder.

EmbeddedLineChartBuilder — A builder for a line chart.

Sets the chart type to PieChart and returns an EmbeddedPieChartBuilder.

EmbeddedPieChartBuilder — A builder for a pie chart.

Sets the chart type to ScatterChart and returns an EmbeddedScatterChartBuilder.

EmbeddedScatterChartBuilder — A builder for a scatter chart.

Sets the chart type to TableChart and returns an EmbeddedTableChartBuilder.

EmbeddedTableChartBuilder — A builder for a table chart.

Builds the chart to reflect all changes made to it.

This method does not automatically draw the chart on top of the spreadsheet. A new chart must be inserted via sheet.insertChart(chart), and an existing chart should be updated via sheet.updateChart(chart).

EmbeddedChart — The created chart, which must still be added to the spreadsheet.

Removes all ranges from the chart this builder modifies.

EmbeddedChartBuilder — This builder, for chaining.

Returns the current chart type.

ChartType — The chart type.

Return the chart ContainerInfo, which encapsulates where the chart appears on the sheet.

ContainerInfo — An object containing the chart container's position.

Returns a copy of the list of ranges currently providing data for this chart. Use addRange(range) and removeRange(range) to modify this list.

Range[] — An array of ranges that serve as the chart to be built's data source.

Removes the specified range from the chart this builder modifies. Does not throw an error if the range is not in this chart.

The range removed must match up with a range added via addRange(range); otherwise no change is made to the chart. This method cannot be used to partially remove values from a range.

EmbeddedChartBuilder — This builder, for chaining.

Reverses the drawing of series in the domain axis. For vertical-range charts (such as line, area or column charts), this means the horizontal axis is drawn from right to left. For horizontal-range charts (such as bar charts), this means the vertical axis is drawn from top to bottom. For pie charts, this means the slices are drawn counterclockwise.

EmbeddedAreaChartBuilder — This builder, useful for chaining.

Sets the background color for the chart.

EmbeddedAreaChartBuilder — This builder, useful for chaining.

Changes the type of chart. Not all embedded chart types are currently supported. See ChartType.

EmbeddedChartBuilder — This builder, for chaining.

Sets the colors for the lines in the chart.

EmbeddedAreaChartBuilder — This builder, useful for chaining.

Sets the strategy to use for hidden rows and columns. Defaults to IGNORE_ROWS.

EmbeddedChartBuilder — This builder, for chaining.

Sets the position of the legend with respect to the chart. By default, there is no legend.

EmbeddedAreaChartBuilder — This builder, useful for chaining.

Sets the text style of the chart legend.

EmbeddedAreaChartBuilder — This builder, useful for chaining.

Sets the merge strategy to use when more than one range exists. If MERGE_ROWS, rows are merged; if MERGE_COLUMNS, columns are merged. Defaults to MERGE_COLUMNS.

EmbeddedChartBuilder — This builder, for chaining.

Sets the number of rows or columns of the range that should be treated as headers.

EmbeddedChartBuilder — This builder, for chaining.

Sets advanced options for this chart. To view a list of the available options, see Chart configuration options.

This method doesn't validate the option you specify is valid for this chart type nor if the value is of the correct format/structure.

This example shows how to change the title and set a legend.

EmbeddedChartBuilder — This builder, for chaining.

Sets the style for points in the line. By default, points have no particular styles, and only the line is visible.

EmbeddedAreaChartBuilder — This builder, useful for chaining.

Sets the position, changing where the chart appears on the sheet. anchorRowPos and anchorColPos are 1-indexed.

EmbeddedChartBuilder — This builder, for chaining.

Sets the range for the chart.

If any data points fall outside the range, the range is expanded to include those data points.

EmbeddedAreaChartBuilder — This builder, useful for chaining.

Uses stacked lines, meaning that line and bar values are stacked (accumulated). By default, there is no stacking.

EmbeddedAreaChartBuilder — This builder, useful for chaining.

Sets the title of the chart. The title is displayed centered above the chart.

EmbeddedAreaChartBuilder — This builder, useful for chaining.

Sets the text style of the chart title.

EmbeddedAreaChartBuilder — This builder, useful for chaining.

Sets whether the chart's rows and columns are transposed. If set to true, the rows and columns are switched. Defaults to false.

EmbeddedChartBuilder — This builder, for chaining.

Sets the horizontal axis text style.

EmbeddedAreaChartBuilder — This builder, useful for chaining.

Adds a title to the horizontal axis. The title is centered and appears below the axis value labels.

EmbeddedAreaChartBuilder — This builder, useful for chaining.

Sets the horizontal axis title text style.

EmbeddedAreaChartBuilder — This builder, useful for chaining.

Sets the vertical axis text style.

EmbeddedAreaChartBuilder — This builder, useful for chaining.

Adds a title to the vertical axis. The title is centered and appears to the left of the value labels.

EmbeddedAreaChartBuilder — This builder, useful for chaining.

Sets the vertical axis title text style.

EmbeddedAreaChartBuilder — This builder, useful for chaining.

Makes the range axis into a logarithmic scale (requires all values to be positive). The range axis are the vertical axis for vertical charts (such as line, area, or column) and the horizontal axis for horizontal charts (such as bar).

EmbeddedAreaChartBuilder — This builder, useful for chaining.

---

## Class EmbeddedChart Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/spreadsheet/embedded-chart

**Contents:**
- Class EmbeddedChart Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
  - Methods
- Detailed documentation
  - asDataSourceChart()
    - Return
  - getAs(contentType)
    - Parameters
    - Return
  - getBlob()

The EmbeddedChart class represents a chart embedded in a spreadsheet and provides methods for accessing and modifying chart properties.

You can modify an existing chart by getting it from the sheet, using the modify() method, making changes with the builder, and then updating the chart on the sheet.

New charts can be created using a chartBuilder obtained from the sheet, setting properties like range and chart type, and then inserting the built chart into the sheet.

Methods like getChartId(), getContainerInfo(), getRanges(), and getOptions() allow retrieval of various chart attributes.

The modify() method returns an EmbeddedChartBuilder for making changes, and these changes must be saved using sheet.updateChart().

Represents a chart that has been embedded into a spreadsheet.

This example shows how to modify an existing chart:

This example shows how to create a new chart:

Casts to a data source chart instance if the chart is a data source chart, or null otherwise.

DataSourceChart — The data source chart.

Return the data inside this object as a blob converted to the specified content type. This method adds the appropriate extension to the filename—for example, "myfile.pdf". However, it assumes that the part of the filename that follows the last period (if any) is an existing extension that should be replaced. Consequently, "ShoppingList.12.25.2014" becomes "ShoppingList.12.25.pdf".

To view the daily quotas for conversions, see Quotas for Google Services. Newly created Google Workspace domains might be temporarily subject to stricter quotas.

Blob — The data as a blob.

Return the data inside this object as a blob.

Blob — The data as a blob.

Returns a stable identifier for the chart that is unique across the spreadsheet containing the chart or null if the chart is not in a spreadsheet.

Integer — A stable chart identifier.

Returns information about where the chart is positioned within a sheet.

ContainerInfo — An object containing the chart container's position.

Returns the strategy to use for handling hidden rows and columns. Defaults to IGNORE_ROWS.

ChartHiddenDimensionStrategy — The strategy to use for hidden rows and columns.

Returns the merge strategy used when more than one range exists. If MERGE_ROWS, row are merged; if MERGE_COLUMNS, columns are merged. Defaults to MERGE_COLUMNS.

ChartMergeStrategy — MERGE_ROWS If rows are merged across multiple ranges; MERGE_COLUMNS if columns are merged across multiple ranges.

Returns the number of rows or columns the range that are treated as headers.

Integer — The number of rows or columns treated as headers. Negative values indicate the headers are auto-detected.

Returns the options for this chart, such as height, colors, and axes.

The returned options are immutable.

ChartOptions — The options for this chart, such as height, colors, and axes.

Returns the ranges that this chart uses as a data source.

Range[] — An array of ranges that serve as this chart's data source.

If true, the rows and columns used to populate the chart are switched. Defaults to false.

Boolean — True if the rows and columns used to construct the chart are transposed.

Returns an EmbeddedChartBuilder that can be used to modify this chart. Invoke sheet.updateChart(chart) to save any changes.

EmbeddedChartBuilder — A builder for creating embedded charts.

---

## Class Field Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/data-studio/field

**Contents:**
- Class Field Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
  - Methods
- Detailed documentation
  - getAggregation()
    - Return
  - getDescription()
    - Return
  - getFormula()
    - Return

A Field object contains data-related information and its properties determine how it's used in Data Studio.

You can create a new field using fields.newDimension() or similar methods.

Field objects have methods to get and set various properties like ID, name, description, type, and aggregation.

Methods starting with get retrieve the current value of a field property.

Methods starting with set modify the value of a field property and return the Field object for chaining.

Contains field-related data. Its properties determine how the field is used in Data Studio.

Returns the AggregationType of this Field. AggregationType determines how Data Studio combines similar data into dimensions.

AggregationType — The aggregationType for this field.

Returns the description of this Field. Descriptions are short explanations of a field's purpose.

String — The description for this field.

Returns the formula of this Field. Formulas define a data transformation that Data Studio runs at query-time.

String — The formula for this field.

Returns the group of this Field. Fields collected into a group are presented together in the Data Studio UI.

String — The group for this field.

Returns the ID of this Field. IDs are unique per set of fields and are used in formulas to refer to fields.

String — The ID for this field.

Returns true if this field can be reaggregated, false otherwise.

Boolean — true if this field can be reaggregated, false otherwise.

Returns the name of this Field. Names are shown to the user to distinguish fields.

String — The name for this field.

Returns the FieldType of this Field.

FieldType — The type for this field.

Returns true if this Field is the default metric or dimension.

Boolean — true if this Field is the default metric or dimension; false otherwise.

Returns true if this field is a dimension.

Boolean — true if this field is a dimension; returns false otherwise.

Returns true if this Field is hidden. You can use hidden fields in formulas, but not in charts. You cannot hide fields containing formulas.

Boolean — true if this Field is hidden; false otherwise.

Returns true if this field is a metric.

Boolean — true if this field is a metric; returns false otherwise.

Sets the aggregation type of this Field. AggregationType determines how Data Studio combines similar data into dimensions. This throws an error if called on a metric.

Field — This builder, for chaining.

Sets the description of this Field. Descriptions are short explanations of a field's purpose.

Field — This builder, for chaining.

Sets the formula of this Field. Formulas define a data transformation that Data Studio runs at query-time.

Field — This builder, for chaining.

Sets the group of this Field. Fields collected into a group are presented together in the Data Studio UI.

Field — This builder, for chaining.

Sets the ID of this Field. IDs are unique per set of fields and are used in formulas to refer to fields.

Field — This builder, for chaining.

Sets the hidden status of this Field. You can use hidden fields in formulas, but not in charts. You cannot hide fields containing formulas.

Field — This builder, for chaining.

Sets the reaggregation-permitted status for a Field. Attempting to set an aggregation type on a field that can't be reaggregated results in an error.

Field — This builder, for chaining.

Sets the name of this Field. Names are shown to the user to distinguish fields.

Field — This builder, for chaining.

Sets the FieldType of this Field.

Field — This builder, for chaining.

---

## Class File Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/drive/file

**Contents:**
- Class File Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
  - Methods
- Detailed documentation
  - addCommenter(emailAddress)
    - Parameters
    - Return
    - Authorization
  - addCommenter(user)
    - Parameters

Google Drive File objects in DriveApp allow programmatic interaction with files.

The documentation lists various methods for managing file permissions, getting file information, and manipulating file content.

Specific methods exist for managing access, retrieving details like ID and name, and performing operations like copying or moving files.

Shortcut-specific methods provide information about the target of a shortcut file.

Scripts interacting with files require appropriate Google Drive authorization scopes.

A file in Google Drive. Files can be accessed or created from DriveApp.

Add the given user to the list of commenters for the File. If the user was already on the list of viewers, this method promotes the user out of the list of viewers.

File — This File, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Add the given user to the list of commenters for the File. If the user was already on the list of viewers, this method promotes the user out of the list of viewers.

File — This File, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Add the given array of users to the list of commenters for the File. If any of the users were already on the list of viewers, this method promotes them out of the list of viewers.

File — This File, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Adds the given user to the list of editors for the File. If the user was already on the list of viewers, this method promotes the user out of the list of viewers.

File — This File, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Adds the given user to the list of editors for the File. If the user was already on the list of viewers, this method promotes the user out of the list of viewers.

File — This File, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Adds the given array of users to the list of editors for the File. If any of the users were already on the list of viewers, this method promotes them out of the list of viewers.

File — This File, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Adds the given user to the list of viewers for the File. If the user was already on the list of editors, this method has no effect.

File — This File, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Adds the given user to the list of viewers for the File. If the user was already on the list of editors, this method has no effect.

File — This File, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Adds the given array of users to the list of viewers for the File. If any of the users were already on the list of editors, this method has no effect for them.

File — This File, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Gets the permission granted to a specific user. The method doesn't support returning permissions for a Google Group or permissions inherited through Google Groups.

Permission — The permissions granted to the user.

Scripts that use this method require authorization with one or more of the following scopes:

Gets the permission granted to a specific user. The method doesn't support returning permissions for a Google Group or permissions inherited through Google Groups.

Permission — The permissions granted to the user.

Scripts that use this method require authorization with one or more of the following scopes:

Return the data inside this object as a blob converted to the specified content type. This method adds the appropriate extension to the filename—for example, "myfile.pdf". However, it assumes that the part of the filename that follows the last period (if any) is an existing extension that should be replaced. Consequently, "ShoppingList.12.25.2014" becomes "ShoppingList.12.25.pdf".

To view the daily quotas for conversions, see Quotas for Google Services. Newly created Google Workspace domains might be temporarily subject to stricter quotas.

Blob — The data as a blob.

Return the data inside this object as a blob.

Blob — The data as a blob.

Gets the date the File was created.

Date — the date the File was created

Scripts that use this method require authorization with one or more of the following scopes:

Gets the description for the File.

String — the description for the File

Scripts that use this method require authorization with one or more of the following scopes:

Gets the URL that can be used to download the file. Only users with permission to open the file in Google Drive can access the URL. You can use this URL in a browser to download the file, but you can't use to fetch the file with UrlFetchApp. If you want the contents of the file in the script, use getBlob().

String — The URL that can be used to download the file.

Scripts that use this method require authorization with one or more of the following scopes:

Gets the list of editors for this File. If the user who executes the script does not have edit access to the File, this method returns an empty array.

User[] — If the user has edit access for this File, returns the list of editors. If the user doesn't have edit access, returns an empty array.

Scripts that use this method require authorization with one or more of the following scopes:

Gets the ID of the File.

String — the ID of the File

Scripts that use this method require authorization with one or more of the following scopes:

Gets the date the File was last updated.

Date — the date the File was last updated

Scripts that use this method require authorization with one or more of the following scopes:

Gets the MIME type of the file.

String — The MIME type of the file.

Scripts that use this method require authorization with one or more of the following scopes:

Gets the name of the File.

String — the name of the File

Scripts that use this method require authorization with one or more of the following scopes:

User — The file owner.

Scripts that use this method require authorization with one or more of the following scopes:

Gets a collection of folders that are immediate parents of the File.

FolderIterator — a collection of folders that are immediate parents of the File

Scripts that use this method require authorization with one or more of the following scopes:

Gets the resource key of the File that is required to access items that have been shared using a link.

String — The resource key of the File.

Scripts that use this method require authorization with one or more of the following scopes:

Gets whether this File is eligible to apply the security update that requires a resource key for access when it's shared using a link.

Drive requires a resource key to access some files or folders that have been shared using a link. This change is part of a security update. The update is turned on by default for eligible files and folders. To turn the resource key requirement on or off for eligible files, use setSecurityUpdateEnabled.

Learn more about the Security update for Google Drive.

Boolean — Whether the resource key requirement can be applied for the File.

Scripts that use this method require authorization with one or more of the following scopes:

Gets whether this File requires a resource key for access when it's shared using a link. This requirement is turned on by default for eligible files and folders. To turn the resource key requirement on or off for eligible files, use setSecurityUpdateEnabled.

Learn more about the Security update for Google Drive.

Boolean — Whether the resource key requirement is enabled for this File.

Scripts that use this method require authorization with one or more of the following scopes:

Gets which class of users can access the File, besides any individual users who have been explicitly given access.

Access — which class of users can access the File

Scripts that use this method require authorization with one or more of the following scopes:

Gets the permission granted to those users who can access the File, besides any individual users who have been explicitly given access.

Permission — the permissions granted to users who can access the File

Scripts that use this method require authorization with one or more of the following scopes:

Gets the number of bytes used to store the File in Drive. Note that Google Workspace application files do not count toward Drive storage limits and thus return 0 bytes.

Integer — the number of bytes used to store the File in Drive

Scripts that use this method require authorization with one or more of the following scopes:

If this is a Shortcut, returns the ID of the item it points to.

Otherwise it returns null.

String — The target item ID.

If this is a Shortcut, returns the mime type of the item it points to.

Otherwise it returns null.

String — The target item mime type.

If the file is a shortcut, returns the resource key of the item it points to. A resource key is an additional parameter that you need to pass to access files that have been shared using a link.

If the file isn't a shortcut, it returns null.

String — The target item's resource key or null if the file is not a shortcut.

Scripts that use this method require authorization with one or more of the following scopes:

Gets a thumbnail image for the file, or null if no thumbnail exists.

Blob — The thumbnail image for the file.

Scripts that use this method require authorization with one or more of the following scopes:

Gets the URL that can be used to open the File in a Google App like Drive or Docs.

String — the URL that can be used to view this File in a Google App like Drive or Docs

Scripts that use this method require authorization with one or more of the following scopes:

Gets the list of viewers and commenters for this File. If the user who executes the script does not have edit access to the File, this method returns an empty array.

User[] — If the user has edit access for this File, returns the list of viewers and commenters. If the user doesn't have edit access, returns an empty array.

Scripts that use this method require authorization with one or more of the following scopes:

Determines whether users with edit permissions to the File are allowed to share with other users or change the permissions.

Boolean — true if users with edit permissions are allowed to share with other users or change the permissions; false if not

Scripts that use this method require authorization with one or more of the following scopes:

Determines whether the File has been starred in the user's Drive.

Boolean — true if the File is starred in the user's Drive; false if not

Scripts that use this method require authorization with one or more of the following scopes:

Determines whether the File is in the trash of the user's Drive.

Boolean — true if the File is in the trash of the user's Drive; false if not

Scripts that use this method require authorization with one or more of the following scopes:

Creates a copy of the file.

Scripts that use this method require authorization with one or more of the following scopes:

Creates a copy of the file in the destination directory.

Scripts that use this method require authorization with one or more of the following scopes:

Creates a copy of the file and names it with the name provided.

Scripts that use this method require authorization with one or more of the following scopes:

Creates a copy of the file in the destination directory and names it with the name provided.

Scripts that use this method require authorization with one or more of the following scopes:

Moves this item to the provided destination folder.

The current user must be the owner of the file or have at least edit access to the item's current parent folder in order to move the item to the destination folder.

File — This File, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Removes the given user from the list of commenters for the File. This method does not block users from access the File if they belong to a class of users who have general access — for example, if the File is shared with the user's entire domain.

File — This File, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Removes the given user from the list of commenters for the File. This method does not block users from access the File if they belong to a class of users who have general access — for example, if the File is shared with the user's entire domain.

File — This File, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Removes the given user from the list of editors for the File. This method doesn't block users from accessing the File if they belong to a class of users who have general access—for example, if the File is shared with the user's entire domain, or if the File is in a shared drive that the user can access.

For Drive files, this also removes the user from the list of viewers.

File — This File, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Removes the given user from the list of editors for the File. This method doesn't block users from accessing the File if they belong to a class of users who have general access—for example, if the File is shared with the user's entire domain, or if the File is in a shared drive that the user can access.

For Drive files, this also removes the user from the list of viewers.

File — This File, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Removes the given user from the list of viewers and commenters for the File. This method has no effect if the user is an editor, not a viewer or commenter. This method also doesn't block users from accessing the File if they belong to a class of users who have general access—for example, if the File is shared with the user's entire domain, or if the File is in a shared drive that the user can access.

For Drive files, this also removes the user from the list of editors.

File — This File for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Removes the given user from the list of viewers and commenters for the File. This method has no effect if the user is an editor, not a viewer. This method also doesn't block users from accessing the File if they belong to a class of users who have general access—for example, if the File is shared with the user's entire domain, or if the File is in a shared drive that the user can access.

For Drive files, this also removes the user from the list of editors.

File — This File for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Revokes the access to the File granted to the given user. This method doesn't block users from accessing the File if they belong to a class of users who have general access — for example, if the File is shared with the user's entire domain.

File — This File, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Revokes the access to the File granted to the given user. This method doesn't block users from accessing the File if they belong to a class of users who have general access — for example, if the File is shared with the user's entire domain.

File — This File, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Overwrites the content of the file with a given replacement. Throws an exception if content is larger than 10MB.

Beware: this change is irreversible.

File — This File, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the description for the File.

File — this File, for chaining

Scripts that use this method require authorization with one or more of the following scopes:

Sets the name of the File.

File — this File, for chaining

Scripts that use this method require authorization with one or more of the following scopes:

Changes the owner of the File. This method also gives the previous owner explicit edit access to the File.

File — this File, for chaining

Scripts that use this method require authorization with one or more of the following scopes:

Changes the owner of the File. This method also gives the previous owner explicit edit access to the File.

File — this File, for chaining

Scripts that use this method require authorization with one or more of the following scopes:

Sets whether the File requires a resource key for access when it's shared using a link. Eligible files and folders are enabled by default.

Learn more about the Security update for Google Drive.

File — This File, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets whether users with edit permissions to the File are allowed to share with other users or change the permissions. The default for a new File is true.

File — this File, for chaining

Scripts that use this method require authorization with one or more of the following scopes:

Sets which class of users can access the File and what permissions those users are granted, besides any individual users who have been explicitly given access.

File — this File, for chaining

Scripts that use this method require authorization with one or more of the following scopes:

Sets whether the File is starred in the user's Drive. The default for new Files is false.

File — this File, for chaining

Scripts that use this method require authorization with one or more of the following scopes:

Sets whether the File is in the trash of the user's Drive. Only the owner may trash the File. The default for new Files is false.

File — this File, for chaining

Scripts that use this method require authorization with one or more of the following scopes:

---

## Class FixedFooter Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/card-service/fixed-footer

**Contents:**
- Class FixedFooter Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
  - Methods
- Detailed documentation
  - setPrimaryButton(button)
    - Parameters
    - Return
  - setSecondaryButton(button)
    - Parameters
    - Return

A FixedFooter is a component shown at the bottom of a Card, available for Google Workspace add-ons and Google Chat apps.

It can have a primary button, which must be a filled text button, and optionally a secondary button, which must be an outlined text button and is only shown if a primary button is set.

The fixed footer shown at the bottom of a Card.

Available for Google Workspace add-ons and Google Chat apps.

Set the primary button in the fixed footer. The primary button must be a TextButtonStyle.FILLED button. If the background color is unset for the primary button, the button uses the primary color defined in the add-on manifest.

FixedFooter — This object, for chaining.

Set the secondary button in the fixed footer. The secondary button must be a TextButtonStyle.OUTLINED button. This method does nothing if setPrimaryButton(button) isn't called to set the primary button.

FixedFooter — This object, for chaining.

---

## Class Folder Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/drive/folder

**Contents:**
- Class Folder Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
  - Methods
  - Deprecated methods
- Detailed documentation
  - addEditor(emailAddress)
    - Parameters
    - Return
    - Authorization
  - addEditor(user)

Google Drive folders can be managed using the DriveApp service and the Folder class in Apps Script.

The Folder class provides methods for managing permissions, creating files and folders, retrieving information, and manipulating folder properties.

Several methods for adding and removing files and folders have been deprecated in favor of using moveTo or createShortcut.

Many modification methods return the Folder object for chaining, and require the https://www.googleapis.com/auth/drive scope, while read-only operations typically need https://www.googleapis.com/auth/drive.readonly.

A folder in Google Drive. Folders can be accessed or created from DriveApp.

Adds the given user to the list of editors for the Folder. If the user was already on the list of viewers, this method promotes the user out of the list of viewers.

Folder — This Folder, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Adds the given user to the list of editors for the Folder. If the user was already on the list of viewers, this method promotes the user out of the list of viewers.

Folder — This Folder, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Adds the given array of users to the list of editors for the Folder. If any of the users were already on the list of viewers, this method promotes them out of the list of viewers.

Folder — This Folder, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Adds the given user to the list of viewers for the Folder. If the user was already on the list of editors, this method has no effect.

Folder — This Folder, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Adds the given user to the list of viewers for the Folder. If the user was already on the list of editors, this method has no effect.

Folder — This Folder, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Adds the given array of users to the list of viewers for the Folder. If any of the users were already on the list of editors, this method has no effect for them.

Folder — This Folder, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Creates a file in the current folder from a given Blob of arbitrary data.

Scripts that use this method require authorization with one or more of the following scopes:

Creates a text file in the current folder with the given name and contents. Throws an exception if content is larger than 50 MB.

Scripts that use this method require authorization with one or more of the following scopes:

Creates a file in the current folder with the given name, contents, and MIME type. Throws an exception if content is larger than 10MB.

Scripts that use this method require authorization with one or more of the following scopes:

Creates a folder in the current folder with the given name.

Folder — The new folder.

Scripts that use this method require authorization with one or more of the following scopes:

Creates a shortcut to the provided Drive item ID, and returns it.

File — The new shortcut.

Scripts that use this method require authorization with one or more of the following scopes:

Creates a shortcut to the provided Drive item ID and resource key, and returns it. A resource key is an additional parameter that needs to be passed to access the target file or folder that has been shared using a link.

File — The new shortcut.

Scripts that use this method require authorization with one or more of the following scopes:

Gets the permission granted to a specific user. The method doesn't support returning permissions for a Google Group or permissions inherited through Google Groups.

Permission — The permissions granted to the user.

Scripts that use this method require authorization with one or more of the following scopes:

Gets the permission granted to a specific user. The method doesn't support returning permissions for a Google Group or permissions inherited through Google Groups.

Permission — The permissions granted to the user.

Scripts that use this method require authorization with one or more of the following scopes:

Gets the date the Folder was created.

Date — the date the Folder was created

Scripts that use this method require authorization with one or more of the following scopes:

Gets the description for the Folder.

String — the description for the Folder

Scripts that use this method require authorization with one or more of the following scopes:

Gets the list of editors for this Folder. If the user who executes the script does not have edit access to the Folder, this method returns an empty array.

User[] — The list of editors for this Folder if the user has edit access or an empty array otherwise.

Scripts that use this method require authorization with one or more of the following scopes:

Gets a collection of all files that are children of the current folder.

FileIterator — A collection of all files that are children of the current folder.

Scripts that use this method require authorization with one or more of the following scopes:

Gets a collection of all files that are children of the current folder and have the given name.

FileIterator — A collection of all files that are children of the current folder and have the given name.

Scripts that use this method require authorization with one or more of the following scopes:

Gets a collection of all files that are children of the current folder and have the given MIME type.

FileIterator — A collection of all files that are children of the current folder and have the given MIME type.

Scripts that use this method require authorization with one or more of the following scopes:

Gets a collection of all folders that are children of the current folder.

FolderIterator — A collection of all folders that are children of the current folder.

Scripts that use this method require authorization with one or more of the following scopes:

Gets a collection of all folders that are children of the current folder and have the given name.

FolderIterator — A collection of all folders that are children of the current folder and have the given name.

Scripts that use this method require authorization with one or more of the following scopes:

Gets the ID of the Folder.

String — the ID of the Folder

Scripts that use this method require authorization with one or more of the following scopes:

Gets the date the Folder was last updated.

Date — the date the Folder was last updated

Scripts that use this method require authorization with one or more of the following scopes:

Gets the name of the Folder.

String — the name of the Folder

Scripts that use this method require authorization with one or more of the following scopes:

Gets the owner of this Folder.

User — The owner of this Folder.

Scripts that use this method require authorization with one or more of the following scopes:

Gets a collection of folders that are immediate parents of the Folder.

FolderIterator — a collection of folders that are immediate parents of the Folder

Scripts that use this method require authorization with one or more of the following scopes:

Gets the resource key of the Folder that is required to access items that have been shared using a link.

String — The resource key of the Folder.

Scripts that use this method require authorization with one or more of the following scopes:

Gets whether this Folder is eligible to apply the security update that requires a resource key for access when it's shared using a link.

Drive requires a resource key to access some files or folders that have been shared using a link. This change is part of a security update. The update is turned on by default for eligible files and folders. To turn the resource key requirement on or off for eligible files, use setSecurityUpdateEnabled.

Learn more about the Security update for Google Drive.

Boolean — Whether the resource key requirement can be applied for the Folder.

Scripts that use this method require authorization with one or more of the following scopes:

Gets whether this Folder requires a resource key for access when it's shared using a link. This requirement is turned on by default for eligible files and folders. To turn the resource key requirement on or off for eligible files, use setSecurityUpdateEnabled.

Learn more about the Security update for Google Drive.

Boolean — Whether the resource key requirement is enabled for this Folder.

Scripts that use this method require authorization with one or more of the following scopes:

Gets which class of users can access the Folder, besides any individual users who have been explicitly given access.

Access — which class of users can access the Folder

Scripts that use this method require authorization with one or more of the following scopes:

Gets the permission granted to those users who can access the Folder, besides any individual users who have been explicitly given access.

Permission — the permissions granted to users who can access the Folder

Scripts that use this method require authorization with one or more of the following scopes:

Gets the number of bytes used to store the Folder in Drive. Note that Google Workspace application files do not count toward Drive storage limits and thus return 0 bytes.

Integer — the number of bytes used to store the Folder in Drive

Scripts that use this method require authorization with one or more of the following scopes:

Gets the URL that can be used to open the Folder in a Google App like Drive or Docs.

String — the URL that can be used to view this Folder in a Google App like Drive or Docs

Scripts that use this method require authorization with one or more of the following scopes:

Gets the list of viewers and commenters for this Folder. If the user who executes the script does not have edit access to the Folder, this method returns an empty array.

User[] — The list of viewers and commenters for this Folder if the user has edit access or an empty array otherwise.

Scripts that use this method require authorization with one or more of the following scopes:

Determines whether users with edit permissions to the Folder are allowed to share with other users or change the permissions.

Boolean — true if users with edit permissions are allowed to share with other users or change the permissions; false if not

Scripts that use this method require authorization with one or more of the following scopes:

Determines whether the Folder has been starred in the user's Drive.

Boolean — true if the Folder is starred in the user's Drive; false if not

Scripts that use this method require authorization with one or more of the following scopes:

Determines whether the Folder is in the trash of the user's Drive.

Boolean — true if the Folder is in the trash of the user's Drive; false if not

Scripts that use this method require authorization with one or more of the following scopes:

Moves this item to the provided destination folder.

The current user must be the owner of the file or have at least edit access to the item's current parent folder in order to move the item to the destination folder.

Folder — This Folder, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Removes the given user from the list of editors for the Folder. This method doesn't block users from accessing the Folder if they belong to a class of users who have general access—for example, if the Folder is shared with the user's entire domain, or if the Folder is in a shared drive that the user can access.

For Drive files, this also removes the user from the list of viewers.

Folder — This Folder, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Removes the given user from the list of editors for the Folder. This method doesn't block users from accessing the Folder if they belong to a class of users who have general access—for example, if the Folder is shared with the user's entire domain, or if the Folder is in a shared drive that the user can access.

For Drive files, this also removes the user from the list of viewers.

Folder — This Folder, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Removes the given user from the list of viewers and commenters for the Folder. This method has no effect if the user is an editor, not a viewer or commenter. This method also doesn't block users from accessing the Folder if they belong to a class of users who have general access—for example, if the Folder is shared with the user's entire domain, or if the Folder is in a shared drive that the user can access.

For Drive files, this also removes the user from the list of editors.

Folder — This Folder for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Removes the given user from the list of viewers and commenters for the Folder. This method has no effect if the user is an editor, not a viewer. This method also doesn't block users from accessing the Folder if they belong to a class of users who have general access—for example, if the Folder is shared with the user's entire domain, or if the Folder is in a shared drive that the user can access.

For Drive files, this also removes the user from the list of editors.

Folder — This Folder for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Revokes the access to the Folder granted to the given user. This method doesn't block users from accessing the Folder if they belong to a class of users who have general access — for example, if the Folder is shared with the user's entire domain.

Folder — This Folder, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Revokes the access to the Folder granted to the given user. This method doesn't block users from accessing the Folder if they belong to a class of users who have general access — for example, if the Folder is shared with the user's entire domain.

Folder — This Folder, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Gets a collection of all files that are children of the current folder and match the given search criteria. The search criteria are detailed in the Google Drive SDK documentation. Note that the Drive service uses v2 of the Drive API and some query fields differ from v3. Review the field differences between v2 and v3.

The params argument is a query string that can contain string values, so take care to escape quotation marks correctly (for example "title contains 'Gulliver\\'s Travels'" or 'title contains "Gulliver\'s Travels"').

FileIterator — A collection of all files that are children of the current folder and match the search criteria.

Scripts that use this method require authorization with one or more of the following scopes:

Gets a collection of all folders that are children of the current folder and match the given search criteria. The search criteria are detailed in the Google Drive SDK documentation. Note that the Drive service uses v2 of the Drive API and some query fields differ from v3. Review the field differences between v2 and v3.

The params argument is a query string that can contain string values, so take care to escape quotation marks correctly (for example "title contains 'Gulliver\\'s Travels'" or 'title contains "Gulliver\'s Travels"').

FolderIterator — A collection of all folders that are children of the current folder and match the search criteria.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the description for the Folder.

Folder — this Folder, for chaining

Scripts that use this method require authorization with one or more of the following scopes:

Sets the name of the Folder.

Folder — this Folder, for chaining

Scripts that use this method require authorization with one or more of the following scopes:

Changes the owner of the Folder. This method also gives the previous owner explicit edit access to the Folder.

Folder — this Folder, for chaining

Scripts that use this method require authorization with one or more of the following scopes:

Changes the owner of the Folder. This method also gives the previous owner explicit edit access to the Folder.

Folder — this Folder, for chaining

Scripts that use this method require authorization with one or more of the following scopes:

Sets whether the Folder requires a resource key for access when it's shared using a link. Eligible files and folders are enabled by default.

Learn more about the Security update for Google Drive.

Folder — This Folder, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets whether users with edit permissions to the Folder are allowed to share with other users or change the permissions. The default for a new Folder is true.

Folder — this Folder, for chaining

Scripts that use this method require authorization with one or more of the following scopes:

Sets which class of users can access the Folder and what permissions those users are granted, besides any individual users who have been explicitly given access.

Folder — this Folder, for chaining

Scripts that use this method require authorization with one or more of the following scopes:

Sets whether the Folder is starred in the user's Drive. The default for new Folders is false.

Folder — this Folder, for chaining

Scripts that use this method require authorization with one or more of the following scopes:

Sets whether the Folder is in the trash of the user's Drive. Only the owner may trash the Folder. The default for new Folders is false.

Folder — this Folder, for chaining

Scripts that use this method require authorization with one or more of the following scopes:

Deprecated. Instead, use File.moveTo(destination) or createShortcut(targetId).

Adds the given file to the current folder. This method does not move the file out of its existing parent folder; a file can have more than one parent simultaneously.

Folder — The new parent of the file added as a child.

Scripts that use this method require authorization with one or more of the following scopes:

Deprecated. Instead, use moveTo(destination) or createShortcut(targetId).

Adds the given folder to the current folder. This method does not move the folder out of its existing parent folder; a folder can have more than one parent simultaneously.

Folder — The new parent of the folder added as a child.

Scripts that use this method require authorization with one or more of the following scopes:

Deprecated. Instead, use File.moveTo(destination).

Removes the given file from the current folder. This method does not delete the file, but if a file is removed from all of its parents, it cannot be seen in Drive except by searching for it or using the "All items" view.

Folder — The previous parent of the child.

Scripts that use this method require authorization with one or more of the following scopes:

Deprecated. Instead, use moveTo(destination).

Removes the given folder from the current folder. This method does not delete the folder or its contents, but if a folder is removed from all of its parents, it cannot be seen in Drive except by searching for it or using the "All items" view.

Folder — The previous parent of the child.

Scripts that use this method require authorization with one or more of the following scopes:

---

## Class Form Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/forms/form

**Contents:**
- Class Form Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
  - Methods
  - Deprecated methods
- Detailed documentation
  - addCheckboxGridItem()
    - Return
    - Authorization
  - addCheckboxItem()
    - Return

The Form object in Google Apps Script represents a Google Form and can be accessed or created using FormApp.

The document details numerous methods for the Form object, covering adding and managing various item types, controlling editors and responders, and managing responses.

Methods are provided to get and set form properties and behaviors like title, description, confirmation message, response destination, and response settings.

The document also lists methods for managing form content structure, permissions, and includes notes on deprecated methods.

A form that contains overall properties and items. Properties include title, settings, and where responses are stored. Items include question items like checkboxes or radio items, while layout items refer to things like page breaks. Forms can be accessed or created from FormApp.

Appends a new question item, presented as a grid of columns and rows, that allows the respondent to select multiple choices per row from a sequence of checkboxes.

CheckboxGridItem — The newly created item.

Scripts that use this method require authorization with one or more of the following scopes:

Appends a new question item that allows the respondent to select one or more checkboxes, as well as an optional "other" field.

CheckboxItem — The newly created item.

Scripts that use this method require authorization with one or more of the following scopes:

Appends a new question item that allows the respondent to indicate a date.

DateItem — The newly created item.

Scripts that use this method require authorization with one or more of the following scopes:

Appends a new question item that allows the respondent to indicate a date and time.

DateTimeItem — The newly created item.

Scripts that use this method require authorization with one or more of the following scopes:

Appends a new question item that allows the respondent to indicate a length of time.

DurationItem — The newly created item.

Scripts that use this method require authorization with one or more of the following scopes:

Adds the given user to the list of editors for the Form. If the user was already on the list of viewers or responders, this method promotes the user out of the list.

Form — This Form, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Adds the given user to the list of editors for the Form. If the user was already on the list of viewers or responders, this method promotes the user out of the list.

Form — This Form, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Adds the given array of users to the list of editors for the Form. If any of the users were already on the list of viewers, this method promotes them out of the list of viewers.

Form — This Form, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Appends a new question item, presented as a grid of columns and rows, that allows the respondent to select one choice per row from a sequence of radio buttons.

GridItem — The newly created item.

Scripts that use this method require authorization with one or more of the following scopes:

Appends a new layout item that displays an image.

ImageItem — The newly created item.

Scripts that use this method require authorization with one or more of the following scopes:

Appends a new question item that allows the respondent to select one choice from a dropdown list.

ListItem — The newly created item.

Scripts that use this method require authorization with one or more of the following scopes:

Adds a new question item that allows the respondent to select one choice from a list of radio buttons or an optional "other" field.

MultipleChoiceItem — The newly created item.

Scripts that use this method require authorization with one or more of the following scopes:

Adds a new layout item that marks the start of a page.

PageBreakItem — The newly created item.

Scripts that use this method require authorization with one or more of the following scopes:

Adds a new question item that allows the respondent to enter a block of text.

ParagraphTextItem — The newly created item.

Scripts that use this method require authorization with one or more of the following scopes:

Adds the given user to the list of responders for the Form. If the user was already on the list of editors or viewers, this method has no effect.

Form — This Form, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Adds the given user to the list of responders for the Form. If the user was already on the list of editors or viewers, this method has no effect.

Form — This Form, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Adds the given array of users to the list of responders for the Form. If the user was already on the list of editors or viewers, this method has no effect.

Form — This Form, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Appends a new question item that allows the respondent to give a rating.

RatingItem — The newly created item.

Scripts that use this method require authorization with one or more of the following scopes:

Appends a new question item that allows the respondent to choose one option from a numbered sequence of radio buttons.

ScaleItem — The newly created item.

Scripts that use this method require authorization with one or more of the following scopes:

Appends a new layout item that visually indicates the start of a section.

SectionHeaderItem — The newly created item.

Scripts that use this method require authorization with one or more of the following scopes:

Appends a new question item that allows the respondent to enter a single line of text.

TextItem — The newly created item.

Scripts that use this method require authorization with one or more of the following scopes:

Appends a new question item that allows the respondent to indicate a time of day.

TimeItem — The newly created item.

Scripts that use this method require authorization with one or more of the following scopes:

Appends a new layout item that displays a video.

VideoItem — The newly created item.

Scripts that use this method require authorization with one or more of the following scopes:

Determines whether the form displays a link to edit a response after submitting it.

Regardless of this setting, the method FormResponse.getEditResponseUrl() allows a script author who has edit access to the form to generate a URL that can be used to edit a response.

Boolean — true if the form displays an "Edit your response" link; false if it doesn't.

Scripts that use this method require authorization with one or more of the following scopes:

Determines whether the form collects respondents' email addresses.

Boolean — true if the form collects email addresses; false if it doesn't.

Scripts that use this method require authorization with one or more of the following scopes:

Creates a new response to the form. To answer a question item, create an ItemResponse from the item, then attach it to this form response by calling FormResponse.withItemResponse(response). To save the assembled response, call FormResponse.submit().

FormResponse — The newly created form response.

Scripts that use this method require authorization with one or more of the following scopes:

Deletes all submitted responses from the form's response store. This method does not delete copies of responses stored in an external response destination (like a spreadsheet), but does clear the form's summary view.

Beware: this method is irreversible.

Form — This Form, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Deletes the item at a given index among all the items in the form. Throws a scripting exception if no item exists at the given index.

Error — if no item exists at the given index

Scripts that use this method require authorization with one or more of the following scopes:

Deletes the given item. Throws a scripting exception if the item has already been deleted.

Error — if the item does not exist in the form

Scripts that use this method require authorization with one or more of the following scopes:

Deletes a single response from the form's response store. This method does not delete copies of responses stored in an external response destination (like a spreadsheet), but does remove the response from the form's summary view. The response ID can be retrieved with FormResponse.getId().

Warning: This method is irreversible.

Form — This Form, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Gets the form's confirmation message.

String — The form's confirmation message.

Scripts that use this method require authorization with one or more of the following scopes:

Gets the custom message that is displayed if the form is not accepting responses, or an empty string if no custom message is set.

String — The custom message to display if the form is not accepting responses, or an empty string if no custom message is set.

Scripts that use this method require authorization with one or more of the following scopes:

Gets the form's description.

String — The form's description.

Scripts that use this method require authorization with one or more of the following scopes:

Gets the ID of the form's response destination.

String — The ID of the form's response destination.

Scripts that use this method require authorization with one or more of the following scopes:

Gets the type of the form's response destination.

DestinationType — The type of the form's response destination.

Scripts that use this method require authorization with one or more of the following scopes:

Gets the URL that can be used to access the form's edit mode.

String — The URL to edit the form.

Scripts that use this method require authorization with one or more of the following scopes:

Gets the list of editors for this Form.

User[] — An array of users with edit permission.

Scripts that use this method require authorization with one or more of the following scopes:

Gets the ID of the form.

String — The ID of the form.

Scripts that use this method require authorization with one or more of the following scopes:

Gets the item with a given ID. Returns null if the ID does not correspond to an item in the form.

Item — The item with the given ID, or null if the item does not exist in the form.

Scripts that use this method require authorization with one or more of the following scopes:

Gets an array of all items in the form.

Item[] — An array of all items in the form.

Scripts that use this method require authorization with one or more of the following scopes:

Gets an array of all items of a given type.

Item[] — An array of all items of that type.

Scripts that use this method require authorization with one or more of the following scopes:

Gets the list of responders for this Form.

User[] — An array of users with responder permission.

Scripts that use this method require authorization with one or more of the following scopes:

Gets the URL that can be used to respond to the form.

String — The URL to respond to the form.

Scripts that use this method require authorization with one or more of the following scopes:

Gets a single form response based on its response ID. Response IDs can be retrieved from FormResponse.getId().

FormResponse — The form response.

Error — if the response does not exist

Scripts that use this method require authorization with one or more of the following scopes:

Gets an array of all of the form's responses.

FormResponse[] — An array of all of the form's responses.

Scripts that use this method require authorization with one or more of the following scopes:

Gets an array of all of the form's responses after a given date and time.

FormResponse[] — The list of form responses.

Scripts that use this method require authorization with one or more of the following scopes:

Determines whether the order of the questions on each page of the form is randomized.

Boolean — true if the order of the questions on each page of the form is randomized; false if not.

Scripts that use this method require authorization with one or more of the following scopes:

Gets the URL that can be used to view a summary of the form's responses. Unless setPublishingSummary(enabled) is set to true, only the users with edit permission to the form is able to access the URL.

String — The URL to view a summary of responses.

Scripts that use this method require authorization with one or more of the following scopes:

Gets the form's title.

String — The form's title.

Scripts that use this method require authorization with one or more of the following scopes:

Determines whether the form allows only one response per respondent. If the value is true, the script cannot submit form responses at all.

Boolean — true if the form allows only one response per respondent; false if not.

Scripts that use this method require authorization with one or more of the following scopes:

Determines whether the form displays a progress bar.

Boolean — true if the form displays a progress bar; false if it doesn't.

Scripts that use this method require authorization with one or more of the following scopes:

Determines whether the form displays a link to submit another response after a respondent completes the form.

Boolean — true if the form displays a "Submit another response" link; false if it doesn't.

Scripts that use this method require authorization with one or more of the following scopes:

Determines whether the form is currently accepting responses. This is overwritten when the form's publishing state is changed.

Boolean — true if the form is accepting responses; false if it isn't.

Scripts that use this method require authorization with one or more of the following scopes:

Determines whether the form is published.

This feature is only available for forms that support publishing. Use supportsAdvancedResponderPermissions() to check if the form supports publishing.

Boolean — true if the form is published; false if it isn't.

Error — if called on unsupported forms.

Scripts that use this method require authorization with one or more of the following scopes:

Determines whether the form displays a link to view a summary of responses after a respondent completes the form.

Boolean — true if the form displays a "See previous responses" link; false if it doesn't.

Scripts that use this method require authorization with one or more of the following scopes:

Determines whether the form is a quiz.

Boolean — true if the form is accepting responses; false if it isn't.

Scripts that use this method require authorization with one or more of the following scopes:

Moves an item at a given index among all the items in the form to another given index. Throws a scripting exception if the to index is out of bounds.

Item — The item that was moved.

Error — if either index is out of bounds.

Scripts that use this method require authorization with one or more of the following scopes:

Moves a given item to a given index among all the items in the form. Throws a scripting exception if the given index is out of bounds.

Item — The item that was moved.

Error — if the index is out of bounds.

Scripts that use this method require authorization with one or more of the following scopes:

Unlinks the form from its current response destination. The unlinked former destination still retains a copy of all previous responses. All forms, including those that do not have a destination set explicitly, save a copy of responses in the form's response store. If the form does not currently have a response destination, this method has no effect.

Form — This Form, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Removes the given user from the list of editors for the Form. This method doesn't block users from accessing the Form if they belong to a class of users who have general access—for example, if the Form is shared with the user's entire domain, or if the Form is in a shared drive that the user can access.

For Drive files, this also removes the user from the list of viewers and responders.

Form — This Form, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Removes the given user from the list of editors for the Form. This method doesn't block users from accessing the Form if they belong to a class of users who have general access—for example, if the Form is shared with the user's entire domain, or if the Form is in a shared drive that the user can access.

For Drive files, this also removes the user from the list of viewers.

Form — This Form, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Removes the given user from the list of responders for the Form. This method doesn't block users from accessing the Form if they belong to a class of users who have general access—for example, if the Form is shared with the user's entire domain, or if the Form is in a shared drive that the user can access.

For Drive files, this also removes the user from the list of viewers and editors.

Form — This Form, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Removes the given user from the list of responders for the Form. This method doesn't block users from accessing the Form if they belong to a class of users who have general access—for example, if the Form is shared with the user's entire domain, or if the Form is in a shared drive that the user can access.

For Drive files, this also removes the user from the list of viewers and editors.

Form — This Form, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets whether the form is currently accepting responses. The default for new forms is true. The state is overwritten when the publish state of the form is changed.

Form — This Form, for chaining.

Error — if enabled on an unpublished form.

Scripts that use this method require authorization with one or more of the following scopes:

Sets whether the form displays a link to edit a response after submitting it. The default for new forms is false.

Regardless of this setting, the method FormResponse.getEditResponseUrl() allows a script author who has edit permission to the form to generate a URL that can be used to edit a response.

Form — This Form, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets whether the form collects respondents' email addresses. The default for new forms is false.

Form — This Form, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the form's confirmation message.

Form — This Form, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the message to display if the form is not accepting responses. If no message is set, the form uses a default message.

Form — This Form, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the form's description.

Form — This Form, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the destination where form responses are saved. All forms, including those that do not have a destination set explicitly, save a copy of responses in the form's response store.

Form — This Form, for chaining.

Error — if the given destination ID is invalid

Scripts that use this method require authorization with one or more of the following scopes:

Sets whether the form is a quiz. The default for new forms is false.

Graded questions are only allowed in Quizzes, so setting this to false causes all grading options to be removed from all questions.

Quiz settings are only available in the new Forms UI; making a form a Quiz opts the form into using the new UI.

Form — This Form, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets whether the form allows only one response per respondent. The default for new forms is false. If the value is set to true, the script cannot submit form responses at all.

Form — This Form, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets whether the form has a progress bar. The default for new forms is false.

Form — This Form, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets whether the form is published. The default for new forms is true.

This feature is only available for forms that support publishing. Use supportsAdvancedResponderPermissions() to check if the form supports publishing.

A form needs to be published for it to be accessible to responders. This method supersedes calls to setAcceptingResponses(enabled).

Form — This Form, for chaining.

Error — if called on unsupported forms.

Scripts that use this method require authorization with one or more of the following scopes:

Sets whether the form displays a link to view a summary of responses after a respondent submits the form. The default for new forms is false.

Form — This Form, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets whether the form displays a link to submit another response after a respondent completes the form. The default for new forms is true.

Form — This Form, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets whether the order of the questions on each page of the form is randomized.

Form — This Form, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the form's title.

Form — This Form, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Converts a long URL for a form to a short URL. Throws an exception if the long URL does not belong to Google Forms.

String — A URL in the form http://goo.gl/forms/1234.

Scripts that use this method require authorization with one or more of the following scopes:

Submits grades for the given FormResponses.

If your code includes an onFormSubmit trigger, calling submitGrades() triggers the onFormSubmit condition and causes an infinite loop. To prevent the infinite loop, add code that checks whether grades already exist before calling submitGrades().

Form — This Form, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Determines whether the form supports publishing. This method is used to determine whether the setPublished(enabled) and isPublished() methods, and responder permissions, are available.

Boolean — true if the form supports publishing; false if it doesn't.

Scripts that use this method require authorization with one or more of the following scopes:

Deprecated. This function is deprecated and should not be used in new scripts.

Determines whether the form requires respondents to log in to an account in the same domain or a subdomain before responding.

Boolean — true if the form requires users to log in; false if it doesn't.

Deprecated. This function is deprecated and should not be used in new scripts.

Sets whether the form requires respondents to log in to an account in the same domain or a subdomain before responding. The default for new forms is false unless a domain administrator changes the default.

This feature is available only for forms created by Google Workspace users. Users of other types of Google accounts can't be required to log in.

Form — The current form (for chaining).

Scripts that use this method require authorization with one or more of the following scopes:

---

## Class GetAuthTypeResponse Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/data-studio/get-auth-type-response

**Contents:**
- Class GetAuthTypeResponse Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
  - Methods
- Detailed documentation
  - build()
    - Return
  - printJson()
    - Return
  - setAuthType(authType)
    - Parameters

GetAuthTypeResponse is a builder used to create a getAuthType() response for your script project in Data Studio.

The builder includes methods such as build(), printJson(), setAuthType(authType), and setHelpUrl(helpUrl) to configure the authentication response.

The build() method validates the object and returns it in the format required by Data Studio.

The setAuthType() method sets the authentication type using an AuthType value, and the setHelpUrl() method sets an optional URL for help with authentication setup.

Builder to create a getAuthType() response for your script project.

Validates this object and returns it in the format needed by Data Studio.

Object — The validated GetAuthTypeResponse object.

Prints the JSON representation of this object. This is for debugging only.

Sets the AuthType of the builder.

GetAuthTypeResponse — This builder, for chaining.

Sets the help URL of the builder.

The help URL is an optional URL the user can visit to get help on setting up auth. This is only supported for USER_PASS, KEY, and USER_TOKEN authTypes.

GetAuthTypeResponse — This builder, for chaining.

---

## Class GetDataResponse Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/data-studio/get-data-response

**Contents:**
- Class GetDataResponse Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
  - Methods
- Detailed documentation
  - addAllRows(rows)
    - Parameters
    - Return
  - addRow(row)
    - Parameters
    - Return

GetDataResponse is a builder used to create a getData() response for your script project.

You can add single rows of data using addRow() or multiple rows using addAllRows().

setFields() is used to set the fields of the builder.

The build() method validates the object and returns it in the format needed by Data Studio.

Builder to create a getData() response for your script project.

Adds multiple rows of data to this GetDataResponse.

GetDataResponse — This builder, for chaining.

Adds a row of data to this GetDataResponse.

GetDataResponse — This builder, for chaining.

Validates this object and returns it in the format needed by Data Studio.

Object — The validated GetDataResponse object.

Sets the Fields of the builder.

GetDataResponse — This builder, for chaining.

Sets the filters applied status for this builder. Set to true if all filters were successfully applied, false otherwise.

GetDataResponse — This builder, for chaining.

---

## Class GetSchemaResponse Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/data-studio/get-schema-response

**Contents:**
- Class GetSchemaResponse Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
  - Methods
- Detailed documentation
  - build()
    - Return
  - printJson()
    - Return
  - setFields(fields)
    - Parameters

GetSchemaResponse is a builder used to create a getSchema() response for your script project.

The build() method validates and returns the object in the format Data Studio needs.

The printJson() method prints the JSON representation of the object for debugging.

The setFields(fields) method sets the fields for the builder.

Builder to create a getSchema() response for your script project.

Validates this object and returns it in the format needed by Data Studio.

Object — The validated GetSchemaResponse object.

Prints the JSON representation of this object. This is for debugging only.

Sets the Fields of the builder.

GetSchemaResponse — This builder, for chaining.

---

## Class GmailApp Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/gmail/gmail-app

**Contents:**
- Class GmailApp Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
  - Methods
  - Deprecated methods
- Detailed documentation
  - createDraft(recipient, subject, body)
    - Parameters
    - Return
    - Authorization
    - See also

The GmailApp class in Google Apps Script provides methods to interact with Gmail, managing threads, messages, and labels.

Key functionalities include managing drafts, retrieving threads and messages by various criteria, and handling labels.

You can use GmailApp to get unread counts, mark items as read/unread or important/unimportant, and move items to different folders like trash, archive, inbox, or spam.

The service allows refreshing item states from Gmail, searching threads using queries, and sending emails with various options including attachments and HTML bodies.

Most methods return a GmailApp object or specific Gmail objects, and all methods require authorization with the https://mail.google.com/ scope.

Provides access to Gmail threads, messages, and labels.

Creates a draft email message. The size of the email (including headers) is quota limited.

GmailDraft — the newly created GmailDraft

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Creates a draft email message with optional arguments. The email can contain plain text or an HTML body. The size of the email (including headers, but excluding attachments) is quota limited.

GmailDraft — the newly created GmailDraft

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Create a new user label of the given name.

GmailLabel — the newly created label

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Deletes the specified label.

GmailApp — the Gmail service, useful for chaining

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Gets a list of the emails that are set up as aliases for this account in Gmail.

You can send a message from any of these aliases by using the "from" optional argument.

String[] — an array of aliases for this account

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Retrieve an email message draft by ID.

Use this in conjunction with getId() on Gmail drafts.

GmailDraft — the draft with the given ID

Error — if no draft with the given ID can be found

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Retrieves all draft messages.

GmailMessage[] — an array of draft Gmail messages

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Gets all Gmail draft messages.

GmailDraft[] — an array of Gmail draft messages

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Retrieves all Inbox threads irrespective of labels.

This call will fail when the size of all threads is too large for the system to handle. Where the thread size is unknown, and potentially very large, please use the 'paged' call, and specify ranges of the threads to retrieve in each call.

GmailThread[] — an array of Gmail threads in the Inbox

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Retrieves a range of Inbox threads irrespective of labels.

GmailThread[] — an array of Gmail threads in the Inbox

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Gets the number of unread threads in the inbox.

Integer — the number of threads in the inbox that have unread messages

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Gets a message by ID.

Use this in conjunction with getId() on Gmail messages.

GmailMessage — the message with the given ID

Error — if no message with the given ID can be found

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Retrieve all messages in the specified thread.

GmailMessage[] — array of messages corresponding to this thread

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Retrieve all messages in the specified threads.

GmailMessage[][] — an array of arrays of messages, where each item in the outer array corresponds to a thread and the inner array contains the messages in that thread

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Retrieves all Priority Inbox threads irrespective of labels.

This call will fail when the size of all threads is too large for the system to handle. Where the thread size is unknown, and potentially very large, please use the 'paged' call, and specify ranges of the threads to retrieve in each call.

GmailThread[] — an array of Gmail threads in the Priority Inbox

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Retrieves a range of Priority Inbox threads irrespective of labels.

GmailThread[] — an array of Gmail threads in the Priority Inbox

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Gets the number of unread threads in the Priority Inbox.

Integer — the number of threads in the Priority Inbox that have unread messages

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Retrieves all spam threads irrespective of labels.

This call will fail when the size of all threads is too large for the system to handle. Where the thread size is unknown, and potentially very large, please use the 'paged' call, and specify ranges of the threads to retrieve in each call.

GmailThread[] — an array of Gmail threads in the spam folder

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Retrieves a range of spam threads irrespective of labels.

GmailThread[] — an array of Gmail threads in the spam folder

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Gets the number of unread threads that are spam.

Integer — the number spam threads that have unread messages

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Retrieves all starred threads irrespective of labels.

This call will fail when the size of all threads is too large for the system to handle. Where the thread size is unknown, and potentially very large, please use the 'paged' call, and specify ranges of the threads to retrieve in each call.

GmailThread[] — an array of starred Gmail threads

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Retrieves a range of starred threads irrespective of labels.

GmailThread[] — an array of starred Gmail threads

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Gets the number of unread threads that are starred.

Integer — the number of starred threads that have unread messages

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Use this in conjunction with getId() on Gmail threads.

GmailThread — The thread with the given ID or null if not found.

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Retrieves all trash threads irrespective of labels.

This call will fail when the size of all threads is too large for the system to handle. Where the thread size is unknown, and potentially very large, please use the 'paged' call, and specify ranges of the threads to retrieve in each call.

GmailThread[] — an array of Gmail threads in the trash

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Retrieves a range of trash threads irrespective of labels.

GmailThread[] — an array of Gmail threads in the trash

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Retrieves a label given the label name.

GmailLabel — the Gmail label with the given name

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Retrieves a list of user-created labels.

GmailLabel[] — array of user created labels

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Marks this message read and forces the message to refresh.

GmailApp — the Gmail service, useful for chaining

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Marks this message unread and forces the message to refresh.

GmailApp — the Gmail service, useful for chaining

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Marks these messages read and forces the messages to refresh.

GmailApp — the Gmail service, useful for chaining

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Marks these messages unread and forces the messages to refresh.

GmailApp — the Gmail service, useful for chaining

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Marks this thread as important and forces the thread to refresh.

GmailApp — the Gmail service, useful for chaining

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Marks this thread as read and forces the thread to refresh.

GmailApp — the Gmail service, useful for chaining

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Marks this thread as unimportant and forces the thread to refresh.

GmailApp — the Gmail service, useful for chaining

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Marks this thread unread and forces the thread to refresh.

GmailApp — the Gmail service, useful for chaining

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Marks these threads as important and forces the threads to refresh.

GmailApp — the Gmail service, useful for chaining

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Marks these threads as read and forces the threads to refresh.

GmailApp — the Gmail service, useful for chaining

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Marks these threads as unimportant and forces the threads to refresh.

GmailApp — the Gmail service, useful for chaining

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Marks these threads as unread and forces the threads to refresh.

GmailApp — the Gmail service, useful for chaining

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Moves the message to the trash and forces the message to refresh.

GmailApp — the Gmail service (useful for chaining)

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Moves the specified messages to the trash and forces the messages to refresh.

GmailApp — the Gmail service (useful for chaining)

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Moves this thread to the archive and forces the thread to refresh.

GmailApp — the Gmail service, useful for chaining

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Moves this thread to the inbox and forces the thread to refresh.

GmailApp — the Gmail service, useful for chaining

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Moves this thread to spam and forces the thread to refresh.

GmailApp — the Gmail service, useful for chaining

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Moves this thread to the trash and forces the thread to refresh.

GmailApp — the Gmail service, useful for chaining

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Moves these threads to the archive and forces the threads to refresh.

GmailApp — the Gmail service, useful for chaining

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Moves these threads to the inbox and forces the threads to refresh.

GmailApp — the Gmail service, useful for chaining

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Moves these threads to spam and forces the threads to refresh.

GmailApp — the Gmail service, useful for chaining

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Moves these threads to the trash and forces the threads to refresh.

GmailApp — the Gmail service, useful for chaining

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Reloads the message and associated state from Gmail (useful in case the labels, read state, etc., have changed).

GmailApp — the Gmail service, useful for chaining

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Reloads the messages and associated state from Gmail (useful in case the labels, read state, etc., have changed).

GmailApp — the Gmail service, useful for chaining

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Reloads the thread and associated state from Gmail (useful in case the labels, read state, etc., have changed).

GmailApp — the Gmail service, useful for chaining

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Reloads the threads and associated state from Gmail (useful in case the labels, read state, etc., have changed).

GmailApp — the Gmail service, useful for chaining

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Search Gmail with the given query.

This call will fail when the size of all threads is too large for the system to handle. Where the thread size is unknown, and potentially very large, please use the 'paged' call, and specify ranges of the threads to retrieve in each call.

GmailThread[] — an array of Gmail threads matching this query

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Search Gmail with the given query.

GmailThread[] — an array of Gmail threads matching this query

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Sends an email message. The size of the email (including headers) is quota limited.

GmailApp — the Gmail service, useful for chaining

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Sends an email message with optional arguments. The email can contain plain text or an HTML body. The size of the email (including headers, but excluding attachments) is quota limited.

GmailApp — the Gmail service, useful for chaining

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Sets the current message access token that enables the script to access the current GmailMessage properties.

Only Google Workspace add-on projects using Gmail current message scopes require this method.

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Adds a star to this message and forces the message to refresh.

GmailApp — the Gmail service, useful for chaining

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Adds stars to these messages and forces the messages to refresh.

GmailApp — the Gmail service, useful for chaining

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Removes a star from this message and forces the message to refresh.

GmailApp — the Gmail service, useful for chaining

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Removes stars from these messages and forces the messages to refresh.

GmailApp — the Gmail service, useful for chaining

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Deprecated. This function is deprecated and should not be used in new scripts.

Gets all classic Google Hangouts threads and Google Chat threads until Google switches all users of classic Hangouts to Chat later this year. To learn more, see Learn about the switch from classic Hangouts to Google Chat.

This call fails when the size of all threads is too large for the system to handle. Where the thread size is unknown, and potentially very large, use the 'paged' call, and specify ranges of the threads to retrieve in each call.

GmailThread[] — An array of chat threads from Gmail.

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Deprecated. This function is deprecated and should not be used in new scripts.

Gets a range of classic Google Hangouts threads and Google Chat threads until Google switches all users of classic Hangouts to Chat later this year. To learn more, see Learn about the switch from classic Hangouts to Google Chat.

GmailThread[] — an array of chat Gmail threads

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

---

## Class GmailMessage Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/gmail/gmail-message

**Contents:**
- Class GmailMessage Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
  - Methods
- Detailed documentation
  - createDraftReply(body)
    - Parameters
    - Return
    - Authorization
    - See also
  - createDraftReply(body, options)

GmailMessage represents a single email message within a user's Gmail account.

You can create draft replies, draft replies to all recipients, forward messages, and reply to messages or reply to all recipients with various options for the message body and additional parameters.

The GmailMessage object provides methods to retrieve message details such as attachments, recipients (To, Cc, Bcc), date, sender, subject, and body content in both HTML and plain text formats.

You can check the status of a message, including whether it is a draft, in chats, in the inbox, in priority inbox, in trash, starred, or unread.

Actions like marking a message as read or unread, moving it to trash, starring or unstarring it, and refreshing its state are available methods.

A message in a user's Gmail account.

Creates a draft message replying to the sender of this message using the reply-to address. The size of the email (including headers) is quota limited.

GmailDraft — The newly created draft message.

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Creates a draft message replying to the sender of this message using the reply-to address, with optional arguments.

The email can contain both plain text and an HTML body. The size of the email (including headers) is quota limited.

GmailDraft — The newly created draft message.

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Creates a draft message replying to the sender using the reply-to address and all recipients of this message. The size of the email (including headers) is quota limited.

GmailDraft — The newly created draft message.

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Creates a draft message replying to the sender of this message using the reply-to address and all recipients, with optional arguments.

The email can contain both plain text and an HTML body. The size of the email (including headers) is quota limited.

GmailDraft — The newly created draft message.

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Forwards this message to new recipients. The size of the email (including headers) is quota limited.

GmailMessage — This message, useful for chaining.

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Forwards this message to new recipients, with optional arguments.

The email can contain both plain text, and also an HTML body. The size of the email (including headers) is quota limited.

GmailMessage — This message, useful for chaining.

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Gets all the attachments for this message.

GmailAttachment[] — An array of Blob attachments for this message.

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Gets all the attachments for this message.

GmailAttachment[] — An array of Blob attachments for this message.

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Gets the comma-separated recipients bcc'd on this message.

This is empty for all received messages, by definition.

String — The comma-separated recipients bcc'd on this message.

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Gets the HTML content of the body of this message.

String — The body content of this message.

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Gets the comma-separated recipients cc'd on this message.

String — The comma-separated recipients cc'd on this message.

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Gets the date and time of this message.

Date — The date and time of this message.

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Gets the sender of this message.

String — The email address of the message sender.

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Gets the value of an RFC 2822 header given the header name.

String — The value of the header, or an empty string if the header doesn't exist in the message.

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Gets the ID of this message.

String — The message ID.

Gets the content of the body of this message without HTML formatting. This is more complex than getBody() and takes longer.

String — The plain body content of this message.

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Gets the raw content of this message. This is equivalent to "Show Original" in the Gmail UI.

String — The raw content of this message.

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Gets the reply-to address of this message (usually the sender).

String — The email address for replies.

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Gets the subject of this message.

String — The subject of this message.

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Gets the thread that contains this message.

GmailThread — The GmailThread that contains this message.

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Gets the comma-separated recipients of this message.

String — The comma-separated recipients of this message.

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Gets whether this message is a draft.

Boolean — Whether this message is a draft.

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Gets whether this message is a chat.

Boolean — Whether this message is a chat.

Gets whether this message is in the inbox.

Boolean — Whether this message is in the inbox.

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Returns true if this message is in the priority inbox; returns false otherwise.

Boolean — Whether this message is in the priority inbox.

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Gets whether this message is in the trash.

Boolean — Whether this message is in the trash.

Gets whether this message is starred.

Boolean — Whether this message is starred.

Gets whether this message is unread.

Boolean — The unread status of this message.

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Marks the message as read.

GmailMessage — This GmailMessage, useful for chaining.

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Marks the message as unread.

GmailMessage — This GmailMessage, useful for chaining.

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Moves the message to the trash.

GmailMessage — This GmailMessage, useful for chaining.

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Reloads this message and associated state from Gmail (useful in case the labels, read state, etc., have changed).

GmailMessage — This message for chaining.

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Replies to the sender of this message using the reply-to address. The size of the email (including headers) is quota limited.

GmailMessage — This message, useful for chaining.

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Replies to the sender of this message using the reply-to address, with optional arguments.

The email can contain both plain text, and also an HTML body. The size of the email (including headers) is quota limited.

GmailMessage — This message, useful for chaining.

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Replies to the sender using the reply-to address and all recipients of this message. The size of the email (including headers) is quota limited.

GmailMessage — This message,useful for chaining.

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

Replies to the sender of this message using the reply-to address and all recipients, with optional arguments.

The email can contain both plain text, and also an HTML body. The size of the email (including headers) is quota limited.

GmailMessage — This message, useful for chaining.

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

GmailMessage — This GmailMessage, useful for chaining.

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

GmailMessage — This GmailMessage, useful for chaining.

Scripts that use this method require authorization with one or more of the following scopes or appropriate scopes from the related REST API:

---

## Class GradientCondition Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/spreadsheet/gradient-condition

**Contents:**
- Class GradientCondition Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
  - Methods
  - Deprecated methods
- Detailed documentation
  - getMaxColorObject()
    - Return
  - getMaxType()
    - Return
  - getMaxValue()

GradientCondition is used to access gradient color conditions in ConditionalFormatRuleApis.

A gradient condition is defined by three points (min, mid, max), each with a color, value, and InterpolationType.

Cell colors are interpolated based on their content's proximity to the min, mid, and max points of the gradient condition.

Methods are available to get the color object, interpolation type, and value for the min, mid, and max points.

Some methods for getting color as a string are deprecated and replaced by methods returning Color objects.

Access gradient (color) conditions in ConditionalFormatRuleApis. Each conditional format rule may contain a single gradient condition. A gradient condition is defined by three points along a number scale (min, mid, and max), each of which has a color, a value, and a InterpolationType. The content of a cell is compared to the values in the number scale and the color applied to the cell is interpolated based on the cell content's proximity to the gradient condition min, mid, and max points.

Gets the color set for the maximum value of this gradient condition. Returns null if the color hasn't been set.

Color — The color set for the maximum value of this gradient condition or null.

Gets the interpolation type for the maximum value of this gradient condition. Returns null if the gradient max type hasn't been set.

InterpolationType — The interpolation type for the maximum value of this gradient condition or null.

Gets the max value of this gradient condition. Returns an empty string if the InterpolationType is MAX or if the max value hasn't been set.

String — The maximum value if specified or an empty string.

Gets the color set for the midpoint value of this gradient condition. Returns null if the color hasn't been set.

Color — The color set for the midpoint value of this gradient condition or null.

Gets the interpolation type for the midpoint value of this gradient condition. Returns null if the gradient mid type hasn't been set.

InterpolationType — The interpolation type for the midpoint value of this gradient condition or null.

Gets the midpoint value of this gradient condition. Returns an empty string if the gradient mid value hasn't been set.

String — The midpoint value or an empty string.

Gets the color set for the minimum value of this gradient condition. Returns null if the color hasn't been set.

Color — The color set for the minimum value of this gradient condition or null.

Gets the interpolation type for the minimum value of this gradient condition. Returns null if the gradient min type hasn't been set.

InterpolationType — The interpolation type for the minimum value of this gradient condition or null.

Gets the minimum value of this gradient condition. Returns an empty string if the InterpolationType is MIN or if the min value hasn't been set.

String — The minimum value if specified or an empty string.

Deprecated. Replaced by getMaxColorObject()

Gets the color set for the maximum value of this gradient condition. Returns an empty string if the color hasn't been set.

String — The color set for the maximum value of this gradient condition or an empty string.

Deprecated. Replaced by getMidColorObject()

Gets the color set for the midpoint value of this gradient condition. Returns an empty string if the color hasn't been set.

String — The color set for the midpoint value of this gradient condition or an empty string.

Deprecated. Replaced by getMinColorObject()

Gets the color set for the minimum value of this gradient condition. Returns an empty string if the color hasn't been set.

String — The color set for the minimum value of this gradient condition or an empty string.

---

## Class Group Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/slides/group

**Contents:**
- Class Group Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
  - Methods
- Detailed documentation
  - alignOnPage(alignmentPosition)
    - Parameters
    - Return
  - bringForward()
    - Return
    - Authorization

A Group is a collection of PageElements joined as a single unit.

Groups can be aligned, duplicated, and have their children retrieved.

You can get and set properties of a Group such as height, width, left, top, rotation, title, and description.

Methods exist to change the layering of a Group (bring forward, bring to front, send backward, send to back).

Groups can be removed or ungrouped.

A collection of PageElements joined as a single unit.

Aligns the element to the specified alignment position on the page.

Group — This page element, for chaining.

Brings the page element forward on the page by one element.

The page element must not be in a group.

Group — This page element, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Brings the page element to the front of the page.

The page element must not be in a group.

Group — This page element, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Duplicates the page element.

The duplicate page element is placed on the same page at the same position as the original.

PageElement — The new duplicate of this page element.

Scripts that use this method require authorization with one or more of the following scopes:

Gets the collection of page elements in the group. The minimum size of a group is 2.

PageElement[] — The list of page elements in this group.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the list of ConnectionSites on the page element, or an empty list if the page element does not have any connection sites.

ConnectionSite[] — The connection sites list, which may be empty if this element has no connection sites.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the page element's alt text description. The description is combined with the title to display and read alt text.

String — The page element's alt text description.

Scripts that use this method require authorization with one or more of the following scopes:

Gets the element's height in points, which is the height of the element's bounding box when the element has no rotation.

This method isn't compatible with all page elements. To learn which page elements aren't compatible with this method, refer to the sizing and positioning limitations.

Number — The page element's inherent height in points, or null if the page element does not have a height.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the element's inherent height in points.

The page element's transform is relative to its inherent size. Use the inherent size in conjunction with the element's transform to determine the element's final visual appearance.

Number — The page element's inherent height in points, or null if the page element does not have a height.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the element's inherent width in points.

The page element's transform is relative to its inherent size. Use the inherent size in conjunction with the element's transform to determine the element's final visual appearance.

Number — The page element's inherent width in points, or null if the page element does not have a width.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the element's horizontal position in points, measured from the upper-left corner of the page when the element has no rotation.

Number — This element's horizontal position in points, from the upper-left corner of the page.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the unique ID for this object. Object IDs used by pages and page elements share the same namespace.

String — The unique ID for this object.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the page element's type, represented as a PageElementType enum.

PageElementType — The page element's type.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the group this page element belongs to, or null if the element is not in a group.

Group — The group this page element belongs to, or null.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the page this page element is on.

Page — The page this element resides on.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the element's clockwise rotation angle around its center in degrees, where zero degrees means no rotation.

Number — The rotation angle in degrees between 0 (inclusive) and 360 (exclusive).

Scripts that use this method require authorization with one or more of the following scopes:

Returns the page element's alt text title. The title is combined with the description to display and read alt text.

String — The page element's alt text title.

Scripts that use this method require authorization with one or more of the following scopes:

Gets the element's vertical position in points, measured from the upper-left corner of the page when the element has no rotation.

Number — This element's vertical position in points, from the upper-left corner of the page.

Scripts that use this method require authorization with one or more of the following scopes:

Gets the page element's transform.

The initial transform for a newly created Group is always the identity transform: 1.0 scale parameters, and 0.0 shear and translate parameters.

AffineTransform — The page element's transform.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the element's width in points, which is the width of the element's bounding box when the element has no rotation.

This method isn't compatible with all page elements. To learn which page elements aren't compatible with this method, refer to the sizing and positioning limitations.

Number — The page element's inherent width in points, or null if the page element does not have a width.

Scripts that use this method require authorization with one or more of the following scopes:

Preconcatenates the provided transform to the existing transform of the page element.

For example, to move a page elements 36 points to the left:

You can also replace the page element's transform with setTransform(transform).

Group — This page element, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Removes the page element.

If after a remove operation, a Group contains only one or no page elements, the group itself is also removed.

If a placeholder PageElement is removed on a master or layout, any empty inheriting placeholders are also removed.

Scripts that use this method require authorization with one or more of the following scopes:

Scales the element's height by the specified ratio. The element's height is the height of its bounding box when the element has no rotation.

This method isn't compatible with all page elements. To learn which page elements aren't compatible with this method, refer to the sizing and positioning limitations.

Group — This page element, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Scales the element's width by the specified ratio. The element's width is the width of its bounding box when the element has no rotation.

This method isn't compatible with all page elements. To learn which page elements aren't compatible with this method, refer to the sizing and positioning limitations.

Group — This page element, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Selects only the PageElement in the active presentation and removes any previous selection. This is the same as calling select(replace) with true.

A script can only access the selection of the user who is running the script, and only if the script is bound to the presentation.

This sets the parent Page of the PageElement as the current page selection.

Scripts that use this method require authorization with one or more of the following scopes:

Selects the PageElement in the active presentation.

A script can only access the selection of the user who is running the script, and only if the script is bound to the presentation.

Pass true to this method to select only the PageElement and remove any previous selection. This also sets the parent Page of the PageElement as the current page selection.

Pass false to select multiple PageElement objects. The PageElement objects must be in the same Page.

The following conditions must be met while selecting a page element using a false parameter:

To make sure that’s the case the preferred approach is to select the parent Page first using Page.selectAsCurrentPage() and then select the page elements in that page.

Scripts that use this method require authorization with one or more of the following scopes:

Sends the page element backward on the page by one element.

The page element must not be in a group.

Group — This page element, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sends the page element to the back of the page.

The page element must not be in a group.

Group — This page element, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the page element's alt text description.

The method is not supported for Group elements.

Group — This page element.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the element's height in points, which is the height of the element's bounding box when the element has no rotation.

This method isn't compatible with all page elements. To learn which page elements aren't compatible with this method, refer to the sizing and positioning limitations.

Group — This page element, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the element's horizontal position in points, measured from the upper-left corner of the page when the element has no rotation.

Group — This page element, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the element's clockwise rotation angle around its center in degrees.

This method isn't compatible with all page elements. To learn which page elements aren't compatible with this method, refer to the sizing and positioning limitations.

Group — This page element, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the page element's alt text title.

The method is not supported for Group elements.

Group — This page element.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the element's vertical position in points, measured from the upper-left corner of the page when the element has no rotation.

Group — This page element, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the transform of the page element with the provided transform.

Updating the transform of a group changes the absolute transform of the page elements in that group, which can change their visual appearance.

Updating the transform of a page element that is in a group only changes the transform of that page element; it doesn't affect the transforms of the group or other page elements in the group.

For details on how transforms impact the visual appearance of page elements, see getTransform().

Group — This element, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the element's width in points, which is the width of the element's bounding box when the element has no rotation.

This method isn't compatible with all page elements. To learn which page elements aren't compatible with this method, refer to the sizing and positioning limitations.

Group — This page element, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Ungroups the elements of the group.

The group itself is removed.

Groups inside other groups cannot be ungrouped.

Scripts that use this method require authorization with one or more of the following scopes:

---

## Class Group Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/groups/group

**Contents:**
- Class Group Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
  - Methods
- Detailed documentation
  - getEmail()
    - Return
    - Authorization
  - getGroups()
    - Return
    - Authorization

A Group object allows querying its members and their roles within the group.

You can retrieve a group's email address, its direct child groups, and direct members.

You can check if a specific user or group is a direct member of the group.

You can get the role of a user or a list of users within the group.

A group object whose members and those members' roles within the group can be queried.

Here's an example which shows the members of a group. Before running it, replace the email address of the group with that of one on your domain.

Gets this group's email address.

This example lists the email address of all the groups the user belongs to.

String — The group's email address.

Scripts that use this method require authorization with one or more of the following scopes:

Retrieves the direct child groups of the group. Throws an exception if you do not have permission to view the group's member list.

In addition to this method, you can use the Admin SDK Directory advanced service to retrieve group members in a domain.

Group[] — All the direct child groups of the group.

Scripts that use this method require authorization with one or more of the following scopes:

Retrieves a user's role in the context of the group. A user who is a direct member of a group has exactly one role within that group. Throws an exception if the user is not a member of the group or if you do not have permission to view the group's member list.

This example lists the owners of a group:

Role — That user's role within the group.

Scripts that use this method require authorization with one or more of the following scopes:

Retrieves a user's role in the context of the group. A user who is a direct member of a group has exactly one role within that group. Throws an exception if the user is not a member of the group or if you do not have permission to view the group's member list.

This example lists the owners of a group:

Role — That user's role within the group.

Scripts that use this method require authorization with one or more of the following scopes:

Retrieves users' roles in the context of the group. A user who is a direct member of a group has exactly one role within that group. Throws an exception if any user is not a member of the group or if you do not have permission to view the group's member list.

This example lists the owners of a group:

Role[] — The roles of those users within the group.

Scripts that use this method require authorization with one or more of the following scopes:

Gets the direct members and banned members of the group that have a known corresponding Google account. Throws an exception if you don't have permission to view the group's member list or the member emails.

Note: if you are a member of a group B which is itself a member of another group A then you are indirectly subscribed to group A. Although you receive copies of messages sent to it, you are not actually subscribed to the parent group A.

Here's an example which shows the members of a group. Before running it, replace the email address of the group with that of one on your domain.

User[] — All the direct members of the group.

Scripts that use this method require authorization with one or more of the following scopes:

Tests if a group is a direct member of this group. The method does not return true if the tested group is nested more than one level below this group. Throws an exception if you do not have permission to view the group's member list.

Boolean — true if that group is a child group of this group; false otherwise.

Scripts that use this method require authorization with one or more of the following scopes:

Tests if a group is a direct member of this group. The method does not return true if the tested group is nested more than one level below this group. Throws an exception if you do not have permission to view the group's member list.

Boolean — true if that group is a child group of this group; false otherwise.

Scripts that use this method require authorization with one or more of the following scopes:

Tests if a user is a direct member of the group. Throws an exception if you do not have permission to view the group's member list.

Here's an example which checks if the current user is a member of a group:

Boolean — true if that user is a member of the group; false otherwise.

Scripts that use this method require authorization with one or more of the following scopes:

Tests if a user is a direct member of the group. Throws an exception if you do not have permission to view the group's member list.

Here's an example which checks if the current user is a member of a group:

Boolean — true if that user is a member of the group; false otherwise.

Scripts that use this method require authorization with one or more of the following scopes:

---

## Class Image Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/card-service/image

**Contents:**
- Class Image Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
  - Methods
- Detailed documentation
  - setAltText(altText)
    - Parameters
    - Return
  - setAuthorizationAction(action)
    - Parameters
    - Return

The Image widget displays a single image and is available for Google Workspace add-ons and Google Chat apps.

You must set the alternative text for accessibility using setAltText(altText) and the image URL using setImageUrl(url).

You can define various actions to occur when the image is clicked, including setting authorization actions, composing emails, executing custom actions, or opening links.

An image object can only have one click action defined from the available methods.

A widget that shows a single image. For information about cropping images, see ImageCropStyle.

Available for Google Workspace add-ons and Google Chat apps.

Sets the alternative text of the image for accessibility. Required.

Image — This object, for chaining.

Sets an authorization action that opens a URL to the authorization flow when the object is clicked. This opens the URL in a new window. When the user finishes the authorization flow and returns to the application, the add-on reloads.

A UI object can only have one of setOpenLink(openLink), setOnClickAction(action), setOnClickOpenLinkAction(action), setAuthorizationAction(action), or setComposeAction(action, composedEmailType) set.

Image — This object, for chaining.

Sets an action that composes a draft email when the object is clicked. A UI object can only have one of setOpenLink(openLink), setOnClickAction(action), setOnClickOpenLinkAction(action), setAuthorizationAction(action), or setComposeAction(action, composedEmailType) set.

The Action parameter must specify a callback function that returns a ComposeActionResponse object configured using ComposeActionResponseBuilder.setGmailDraft(draft).

Note: This method doesn't set a compose action that is used to extend the compose UI. Rather, this method connects this UI element to an Action that composes draft messages in Apps Script that are opened in Gmail when the action completes.

Image — This object, for chaining.

Sets the image to use by providing its URL or data string. Required.

The provided URL can either be a publicly accessible URL or a base64 encoded image string. To obtain the latter, you can use the following code to create an encoded image string from an image in your Google Drive, then store that string for later use with setImageUrl(url). This method prevents the need for your add-on to access a publicly available image URL:

Image — This object, for chaining.

Sets an action that executes when the object is clicked. A UI object can only have one of setOpenLink(openLink), setOnClickAction(action), setOnClickOpenLinkAction(action), setAuthorizationAction(action), or setComposeAction(action, composedEmailType) set.

The Action parameter must specify a callback function that returns a ActionResponse object.

Image — This object, for chaining.

Sets an action that opens a URL in a tab when the object is clicked. Use this function when the URL needs to be built or when you need to take other actions in addition to creating the OpenLink object. A UI object can only have one of setOpenLink(openLink), setOnClickAction(action), setOnClickOpenLinkAction(action), setAuthorizationAction(action), or setComposeAction(action, composedEmailType) set.

The Action parameter must specify a callback function that returns a ActionResponse object configured using ActionResponseBuilder.setOpenLink(openLink).

Image — This object, for chaining.

Sets a URL to be opened when the object is clicked. Use this function when the URL is already known and only needs to be opened. A UI object can only have one of setOpenLink(openLink), setOnClickAction(action), setOnClickOpenLinkAction(action), setAuthorizationAction(action), or setComposeAction(action, composedEmailType) set.

Image — This object, for chaining.

---

## Class Image Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/slides/image

**Contents:**
- Class Image Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
  - Methods
- Detailed documentation
  - alignOnPage(alignmentPosition)
    - Parameters
    - Return
  - bringForward()
    - Return
    - Authorization

The Image object represents an image as a PageElement in Google Slides.

You can manipulate the position and layer of an image using methods like alignOnPage, bringForward, bringToFront, sendBackward, and sendToBack.

The image data can be accessed as a Blob using getAs() and getBlob().

You can retrieve information about the image such as its border, connection sites, content URL, description, dimensions, position, link, object ID, parent elements, rotation, source URL, title, and transform using various get methods.

Images can be duplicated, removed, and replaced using duplicate, remove, and replace methods respectively.

You can scale the height and width of an image using scaleHeight and scaleWidth.

Images can be selected programmatically using the select method.

You can set properties like the description, height, left position, link to a slide or URL, rotation, title, top position, and transform using the corresponding set methods.

A PageElement representing an image.

Aligns the element to the specified alignment position on the page.

Image — This page element, for chaining.

Brings the page element forward on the page by one element.

The page element must not be in a group.

Image — This page element, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Brings the page element to the front of the page.

The page element must not be in a group.

Image — This page element, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Duplicates the page element.

The duplicate page element is placed on the same page at the same position as the original.

PageElement — The new duplicate of this page element.

Scripts that use this method require authorization with one or more of the following scopes:

Return the data inside this object as a blob converted to the specified content type. This method adds the appropriate extension to the filename—for example, "myfile.pdf". However, it assumes that the part of the filename that follows the last period (if any) is an existing extension that should be replaced. Consequently, "ShoppingList.12.25.2014" becomes "ShoppingList.12.25.pdf".

To view the daily quotas for conversions, see Quotas for Google Services. Newly created Google Workspace domains might be temporarily subject to stricter quotas.

Blob — The data as a blob.

Return the data inside this image as a blob.

Blob — The image data as a blob.

Returns the Border of the image.

Border — The border of the image.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the list of ConnectionSites on the page element, or an empty list if the page element does not have any connection sites.

ConnectionSite[] — The connection sites list, which may be empty if this element has no connection sites.

Scripts that use this method require authorization with one or more of the following scopes:

Gets a URL to the image.

This URL is tagged with the account of the requester, so anyone with the URL effectively accesses the image as the original requester. Access to the image may be lost if the presentation's sharing settings change. The returned URL expires after a short period of time.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the page element's alt text description. The description is combined with the title to display and read alt text.

String — The page element's alt text description.

Scripts that use this method require authorization with one or more of the following scopes:

Gets the element's height in points, which is the height of the element's bounding box when the element has no rotation.

This method isn't compatible with all page elements. To learn which page elements aren't compatible with this method, refer to the sizing and positioning limitations.

Number — The page element's inherent height in points, or null if the page element does not have a height.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the element's inherent height in points.

The page element's transform is relative to its inherent size. Use the inherent size in conjunction with the element's transform to determine the element's final visual appearance.

Number — The page element's inherent height in points, or null if the page element does not have a height.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the element's inherent width in points.

The page element's transform is relative to its inherent size. Use the inherent size in conjunction with the element's transform to determine the element's final visual appearance.

Number — The page element's inherent width in points, or null if the page element does not have a width.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the element's horizontal position in points, measured from the upper-left corner of the page when the element has no rotation.

Number — This element's horizontal position in points, from the upper-left corner of the page.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the Link or null if there is no link.

Link — The Link or null if there is no link.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the unique ID for this object. Object IDs used by pages and page elements share the same namespace.

String — The unique ID for this object.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the page element's type, represented as a PageElementType enum.

PageElementType — The page element's type.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the group this page element belongs to, or null if the element is not in a group.

Group — The group this page element belongs to, or null.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the page this page element is on.

Page — The page this element resides on.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the parent page element of the placeholder. Returns null if the image is not a placeholder or has no parent.

PageElement — The parent page element of this image placeholder, or null if this image is not a placeholder or doesn't have a parent.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the index of the placeholder image. If two or more placeholder images on the same page are the same type, they each have a unique index value. Returns null if the image isn't a placeholder.

Integer — This image's placeholder index, or null if the image isn't a placeholder.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the placeholder type of the image, or PlaceholderType.NONE if the shape is not a placeholder.

PlaceholderType — The placeholder type of this image.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the element's clockwise rotation angle around its center in degrees, where zero degrees means no rotation.

Number — The rotation angle in degrees between 0 (inclusive) and 360 (exclusive).

Scripts that use this method require authorization with one or more of the following scopes:

Gets the image's source URL, if available.

When an image is inserted by URL, returns the URL provided during image insertion.

String — The image URL or null if the image does not have a source URL.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the page element's alt text title. The title is combined with the description to display and read alt text.

String — The page element's alt text title.

Scripts that use this method require authorization with one or more of the following scopes:

Gets the element's vertical position in points, measured from the upper-left corner of the page when the element has no rotation.

Number — This element's vertical position in points, from the upper-left corner of the page.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the page element's transform.

The visual appearance of the page element is determined by its absolute transform. To compute the absolute transform, preconcatenate a page element's transform with the transforms of all of its parent groups. If the page element is not in a group, its absolute transform is the same as the value in this field.

AffineTransform — The page element's transform.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the element's width in points, which is the width of the element's bounding box when the element has no rotation.

This method isn't compatible with all page elements. To learn which page elements aren't compatible with this method, refer to the sizing and positioning limitations.

Number — The page element's inherent width in points, or null if the page element does not have a width.

Scripts that use this method require authorization with one or more of the following scopes:

Preconcatenates the provided transform to the existing transform of the page element.

For example, to move a page elements 36 points to the left:

You can also replace the page element's transform with setTransform(transform).

Image — This page element, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Removes the page element.

If after a remove operation, a Group contains only one or no page elements, the group itself is also removed.

If a placeholder PageElement is removed on a master or layout, any empty inheriting placeholders are also removed.

Scripts that use this method require authorization with one or more of the following scopes:

Replaces this image with an image described by a BlobSource object.

Inserting the image fetches it from the BlobSource once and a copy is stored for display inside the presentation. Images must be less than 50MB in size, cannot exceed 25 megapixels, and must be in either in PNG, JPEG, or GIF format.

In order to maintain the image's aspect ratio, the image is scaled and centered with respect to the size of the existing image.

Image — This Image after the replacement.

Scripts that use this method require authorization with one or more of the following scopes:

Replaces this image with an image described by a Image object, optionally cropping the image to fit.

Inserting the image fetches it from the BlobSource once and a copy is stored for display inside the presentation. Images must be less than 50MB in size, cannot exceed 25 megapixels, and must be in either in PNG, JPEG, or GIF format.

Image — This Image after the replacement.

Scripts that use this method require authorization with one or more of the following scopes:

Replaces this image with another image downloaded from the provided URL.

Inserting the image fetches it from the URL once and a copy is stored for display inside the presentation. Images must be less than 50MB in size, cannot exceed 25 megapixels, and must be in either in PNG, JPEG, or GIF format.

The provided URL must be publicly accessible and no larger than 2kB. The URL itself is saved with the image and exposed via getSourceUrl().

In order to maintain the image's aspect ratio, the image is scaled and centered with respect to the size of the existing image.

Image — This Image after the replacement.

Scripts that use this method require authorization with one or more of the following scopes:

Replaces this image with another image downloaded from the provided URL, optionally cropping the image to fit.

Inserting the image fetches it from the URL once and a copy is stored for display inside the presentation. Images must be less than 50MB in size, cannot exceed 25 megapixels, and must be in either in PNG, JPEG, or GIF format.

The provided URL must be no larger than 2kB.

Image — This Image after the replacement.

Scripts that use this method require authorization with one or more of the following scopes:

Scales the element's height by the specified ratio. The element's height is the height of its bounding box when the element has no rotation.

This method isn't compatible with all page elements. To learn which page elements aren't compatible with this method, refer to the sizing and positioning limitations.

Image — This page element, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Scales the element's width by the specified ratio. The element's width is the width of its bounding box when the element has no rotation.

This method isn't compatible with all page elements. To learn which page elements aren't compatible with this method, refer to the sizing and positioning limitations.

Image — This page element, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Selects only the PageElement in the active presentation and removes any previous selection. This is the same as calling select(replace) with true.

A script can only access the selection of the user who is running the script, and only if the script is bound to the presentation.

This sets the parent Page of the PageElement as the current page selection.

Scripts that use this method require authorization with one or more of the following scopes:

Selects the PageElement in the active presentation.

A script can only access the selection of the user who is running the script, and only if the script is bound to the presentation.

Pass true to this method to select only the PageElement and remove any previous selection. This also sets the parent Page of the PageElement as the current page selection.

Pass false to select multiple PageElement objects. The PageElement objects must be in the same Page.

The following conditions must be met while selecting a page element using a false parameter:

To make sure that’s the case the preferred approach is to select the parent Page first using Page.selectAsCurrentPage() and then select the page elements in that page.

Scripts that use this method require authorization with one or more of the following scopes:

Sends the page element backward on the page by one element.

The page element must not be in a group.

Image — This page element, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sends the page element to the back of the page.

The page element must not be in a group.

Image — This page element, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the page element's alt text description.

The method is not supported for Group elements.

Image — This page element.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the element's height in points, which is the height of the element's bounding box when the element has no rotation.

This method isn't compatible with all page elements. To learn which page elements aren't compatible with this method, refer to the sizing and positioning limitations.

Image — This page element, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the element's horizontal position in points, measured from the upper-left corner of the page when the element has no rotation.

Image — This page element, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets a Link to the given Slide using the zero-based index of the slide.

Link — The Link that was set.

Scripts that use this method require authorization with one or more of the following scopes:

Sets a Link to the given Slide, the link is set by the given slide ID.

Link — The Link that was set.

Scripts that use this method require authorization with one or more of the following scopes:

Sets a Link to the given Slide using the relative position of the slide.

Link — The Link that was set.

Scripts that use this method require authorization with one or more of the following scopes:

Sets a Link to the given non-empty URL string.

Link — The Link that was set.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the element's clockwise rotation angle around its center in degrees.

This method isn't compatible with all page elements. To learn which page elements aren't compatible with this method, refer to the sizing and positioning limitations.

Image — This page element, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the page element's alt text title.

The method is not supported for Group elements.

Image — This page element.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the element's vertical position in points, measured from the upper-left corner of the page when the element has no rotation.

Image — This page element, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the transform of the page element with the provided transform.

Updating the transform of a group changes the absolute transform of the page elements in that group, which can change their visual appearance.

Updating the transform of a page element that is in a group only changes the transform of that page element; it doesn't affect the transforms of the group or other page elements in the group.

For details on how transforms impact the visual appearance of page elements, see getTransform().

Image — This element, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the element's width in points, which is the width of the element's bounding box when the element has no rotation.

This method isn't compatible with all page elements. To learn which page elements aren't compatible with this method, refer to the sizing and positioning limitations.

Image — This page element, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

---

## Class KeyValue Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/card-service/key-value

**Contents:**
- Class KeyValue Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
  - Methods
  - Deprecated methods
- Detailed documentation
  - setAuthorizationAction(action)
    - Parameters
    - Return
  - setComposeAction(action, composedEmailType)
    - Parameters

This class is deprecated and should not be used in new scripts; instead, use DecoratedText.

You can set an authorization action that opens a URL to the authorization flow when the object is clicked.

You can set an action that composes a draft email when the object is clicked.

You can set an action that executes or opens a URL in a tab when the object is clicked.

You can set a URL to be opened directly when the object is clicked.

Deprecated. This class is deprecated and should not be used in new scripts.

This class is deprecated. Instead, use DecoratedText.

Sets an authorization action that opens a URL to the authorization flow when the object is clicked. This opens the URL in a new window. When the user finishes the authorization flow and returns to the application, the add-on reloads.

A UI object can only have one of setOpenLink(openLink), setOnClickAction(action), setOnClickOpenLinkAction(action), setAuthorizationAction(action), or setComposeAction(action, composedEmailType) set.

KeyValue — This object, for chaining.

Sets an action that composes a draft email when the object is clicked. A UI object can only have one of setOpenLink(openLink), setOnClickAction(action), setOnClickOpenLinkAction(action), setAuthorizationAction(action), or setComposeAction(action, composedEmailType) set.

The Action parameter must specify a callback function that returns a ComposeActionResponse object configured using ComposeActionResponseBuilder.setGmailDraft(draft).

Note: This method doesn't set a compose action that is used to extend the compose UI. Rather, this method connects this UI element to an Action that composes draft messages in Apps Script that are opened in Gmail when the action completes.

KeyValue — This object, for chaining.

Sets an action that executes when the object is clicked. A UI object can only have one of setOpenLink(openLink), setOnClickAction(action), setOnClickOpenLinkAction(action), setAuthorizationAction(action), or setComposeAction(action, composedEmailType) set.

The Action parameter must specify a callback function that returns a ActionResponse object.

KeyValue — This object, for chaining.

Sets an action that opens a URL in a tab when the object is clicked. Use this function when the URL needs to be built or when you need to take other actions in addition to creating the OpenLink object. A UI object can only have one of setOpenLink(openLink), setOnClickAction(action), setOnClickOpenLinkAction(action), setAuthorizationAction(action), or setComposeAction(action, composedEmailType) set.

The Action parameter must specify a callback function that returns a ActionResponse object configured using ActionResponseBuilder.setOpenLink(openLink).

KeyValue — This object, for chaining.

Sets a URL to be opened when the object is clicked. Use this function when the URL is already known and only needs to be opened. A UI object can only have one of setOpenLink(openLink), setOnClickAction(action), setOnClickOpenLinkAction(action), setAuthorizationAction(action), or setComposeAction(action, composedEmailType) set.

KeyValue — This object, for chaining.

Deprecated. This function is deprecated and should not be used in new scripts.

Sets the label text to be used as the key. Displayed below the text-content.

KeyValue — This object, for chaining.

Deprecated. This function is deprecated and should not be used in new scripts.

Sets the Button that is displayed to the right of the context. A KeyValue can only support one button, one switch or one icon.

KeyValue — This object, for chaining.

Deprecated. This function is deprecated and should not be used in new scripts.

Sets the text to be used as the value. Supports basic HTML formatting. Required.

KeyValue — This object, for chaining.

Deprecated. This function is deprecated and should not be used in new scripts.

Sets the icon to be used as the key.

KeyValue — This object, for chaining.

Deprecated. This function is deprecated and should not be used in new scripts.

Sets the alternative text for the icon.

KeyValue — This object, for chaining.

Deprecated. This function is deprecated and should not be used in new scripts.

Sets the URL of the icon to be used as the key.

KeyValue — This object, for chaining.

Deprecated. This function is deprecated and should not be used in new scripts.

Sets whether the value text should be displayed on a single line or multiple lines.

KeyValue — This object, for chaining.

Deprecated. This function is deprecated and should not be used in new scripts.

Sets the Switch that is displayed to the right of the content. A KeyValue can only support one button, one switch or one icon.

KeyValue — This object, for chaining.

Deprecated. This function is deprecated and should not be used in new scripts.

Sets the label text to be used as the key. Displayed above the text-content.

KeyValue — This object, for chaining.

---

## Class Layout Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/slides/layout

**Contents:**
- Class Layout Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
  - Methods
- Detailed documentation
  - getBackground()
    - Return
    - Authorization
  - getColorScheme()
    - Return
    - Authorization

A layout in presentation slides acts as a template defining the arrangement and styling of content.

Layouts provide methods to access and manipulate various page elements like background, images, shapes, and placeholders.

You can insert diverse elements into a layout, including groups, images, lines, shapes, Sheets charts, tables, text boxes, videos, and Word Art.

Layouts also support operations such as removing themselves, replacing all text within them, and selecting themselves as the current page.

All methods related to layouts require specific Google Sheets authorization scopes.

A layout in a presentation.

Each layout serves as a template for slides that inherit from it, determining how content on those slides is arranged and styled.

Gets the page's background.

PageBackground — The page's background.

Scripts that use this method require authorization with one or more of the following scopes:

Gets the ColorScheme associated with the page.

ColorScheme — The page's color scheme.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the list of Group objects on the page.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the list of Image objects on the page.

Scripts that use this method require authorization with one or more of the following scopes:

Gets the name of the layout.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the list of Line objects on the page.

Scripts that use this method require authorization with one or more of the following scopes:

Gets the master that the layout is based on.

Scripts that use this method require authorization with one or more of the following scopes:

Gets the unique ID for the page. Object IDs used by pages and page elements share the same namespace.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the PageElement on the page with the given ID, or null if none exists.

PageElement — The page element with the given ID.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the list of PageElement objects rendered on the page.

Scripts that use this method require authorization with one or more of the following scopes:

Gets the type of the page.

PageType — The page type.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the placeholder PageElement object for a specified PlaceholderType or null if a matching placeholder is not present.

If there are multiple placeholders with the same type, it returns the one with minimal placeholder index. If there are multiple matching placeholders with the same index, it returns the first placeholder from the page's page elements collection.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the placeholder PageElement object for a specified PlaceholderType and a placeholder index, or null if the placeholder is not present.

If there are multiple placeholders with the same type and index, it returns the first placeholder from the page's page elements collection.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the list of placeholder PageElement objects in the page.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the list of Shape objects on the page.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the list of SheetsChart objects on the page.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the list of Table objects on the page.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the list of Video objects on the page.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the list of WordArt objects on the page.

Scripts that use this method require authorization with one or more of the following scopes:

Groups all the specified page elements.

There should be at least two page elements on the same page that are not already in another group. Some page elements, such as Videos, Tables and placeholder Shapes cannot be grouped.

Group — The new group.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts a copy of the provided Group on the page.

The inserted element's position on this page is determined from the source element's position on its respective page.

If the provided element is a placeholder being copied from within the current presentation, properties that inherit from master or layout pages also inherit on the inserted element.

If the provided element is a placeholder being copied from a different presentation, properties that inherit from master or layout pages are copied onto the element from the source presentation.

Group — The inserted group.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts an image at the top left corner of the page with a default size from the specified image blob.

Inserting the image fetches it from the BlobSource once and a copy is stored for display inside the presentation. Images must be less than 50MB in size, cannot exceed 25 megapixels, and must be in either in PNG, JPEG, or GIF format.

Image — The inserted image.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts an image on the page with the provided position and size from the specified image blob.

The image is fetched from the provided BlobSource once at insertion time and a copy is stored for display inside the presentation. Images must be less than 50MB in size, cannot exceed 25 megapixels, and must be in either in PNG, JPEG, or GIF format.

In order to maintain the image's aspect ratio, the image is scaled and centered with respect to the provided size.

Image — The inserted image.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts a copy of the provided Image on the page.

The inserted images's position on this page is determined from the source image's position on its respective page.

If the provided image is a placeholder being copied from within the current presentation, properties that inherit from master or layout pages also inherit on the inserted image.

If the provided image is a placeholder being copied from a different presentation, properties that inherit from master or layout pages are copied onto the image from the source presentation. If the copied placeholder image is empty, nothing is inserted in the destination presentation.

Image — The inserted image.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts an image at the top left corner of the page with a default size from the provided URL.

Inserting the image fetches it from the URL once and a copy is stored for display inside the presentation. Images must be less than 50MB in size, cannot exceed 25 megapixels, and must be in either in PNG, JPEG, or GIF format.

The provided URL must be publicly accessible and no larger than 2kB. The URL itself is saved with the image and exposed via Image.getSourceUrl().

Image — The inserted image.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts an image on the page with the provided position and size from the provided URL.

Inserting the image fetches it from the URL once and a copy is stored for display inside the presentation. Images must be less than 50MB in size, cannot exceed 25 megapixels, and must be in either in PNG, JPEG, or GIF format.

The provided URL must be publicly accessible and no larger than 2kB. The URL itself is saved with the image and exposed via Image.getSourceUrl().

In order to maintain the image's aspect ratio, the image is scaled and centered with respect to the provided size.

Image — The inserted image.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts a copy of the provided Line on the page.

The inserted element's position on this page is determined from the source element's position on its respective page.

If the provided element is a placeholder being copied from within the current presentation, properties that inherit from master or layout pages also inherit on the inserted element.

If the provided element is a placeholder being copied from a different presentation, properties that inherit from master or layout pages are copied onto the element from the source presentation.

Line — The inserted line.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts a line on the page connecting two connection sites. The two connection sites must be on this page.

Line — The inserted line.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts a line on the page.

Line — The inserted line.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts a copy of the provided PageElement on the page.

The inserted element's position on this page is determined from the source element's position on its respective page.

If the provided element is a placeholder being copied from within the current presentation, properties that inherit from master or layout pages also inherit on the inserted element.

If the provided element is a placeholder being copied from a different presentation, properties that inherit from master or layout pages are copied onto the element from the source presentation.

PageElement — The inserted page element.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts a copy of the provided Shape on the page.

The inserted element's position on this page is determined from the source element's position on its respective page.

If the provided element is a placeholder being copied from within the current presentation, properties that inherit from master or layout pages also inherit on the inserted element.

If the provided element is a placeholder being copied from a different presentation, properties that inherit from master or layout pages are copied onto the element from the source presentation.

Shape — The inserted shape.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts a shape on the page.

The shape is inserted with a default size at the top left corner of the page.

Shape — The inserted shape.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts a shape on the page.

Shape — The inserted shape.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts a Google Sheets chart on the page.

The chart is inserted with a default size at the top left corner of the page.

The inserted chart is linked with the source Google Sheets chart which allows it to be updated. Other collaborators can see the link to the source spreadsheet.

SheetsChart — The inserted chart in the page.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts a Google Sheets chart on the page with the provided position and size.

In order to maintain the chart's aspect ratio, the chart is scaled and centered with respect to the provided size.

The inserted chart is linked with the source Google Sheets chart which allows it to be updated. Other collaborators can see the link to the source spreadsheet.

SheetsChart — The inserted chart in the page.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts a copy of the provided SheetsChart on the page.

The inserted element's position on this page is determined from the source element's position on its respective page.

If the provided element is a placeholder being copied from within the current presentation, properties that inherit from master or layout pages also inherit on the inserted element.

If the provided element is a placeholder being copied from a different presentation, properties that inherit from master or layout pages are copied onto the element from the source presentation.

SheetsChart — The inserted sheets chart.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts a Google Sheets chart as an Image on the page.

The image of the chart is inserted with a default size at the top left corner of the page.

The inserted image of chart is not linked with the source Google Sheets chart.

Image — The inserted image of the chart in the page.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts a Google Sheets chart as an Image on the page with the provided position and size.

In order to maintain the chart image's aspect ratio, the image is scaled and centered with respect to the provided size.

The inserted image of the chart is not linked with the source Google Sheets chart.

Image — The inserted image of the chart in the page.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts a table on the page.

The table is centered on the page with default size and evenly distributed rows and columns.

Table — The inserted table.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts a table on the page with the provided position and size.

Rows and columns are evenly distributed in the created table.

Table — The inserted table.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts a copy of the provided Table on the page.

The inserted element's position on this page is determined from the source element's position on its respective page.

If the provided element is a placeholder being copied from within the current presentation, properties that inherit from master or layout pages also inherit on the inserted element.

If the provided element is a placeholder being copied from a different presentation, properties that inherit from master or layout pages are copied onto the element from the source presentation.

Table — The inserted table.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts a text box Shape containing the provided string on the page.

The text box shape is inserted with a default size at the top left corner of the page.

Shape — The inserted text box shape.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts a text box Shape containing the provided string on the page.

Shape — The inserted text box shape.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts a video at the top left corner of the page with a default size.

Only YouTube videos are currently supported.

Video — The inserted video.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts a video on the page with the provided position and size.

Only YouTube videos are currently supported.

Video — The inserted video.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts a copy of the provided Video on the page.

The inserted element's position on this page is determined from the source element's position on its respective page.

If the provided element is a placeholder being copied from within the current presentation, properties that inherit from master or layout pages also inherit on the inserted element.

If the provided element is a placeholder being copied from a different presentation, properties that inherit from master or layout pages are copied onto the element from the source presentation.

Video — The inserted video.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts a copy of the provided WordArt on the page.

The inserted element's position on this page is determined from the source element's position on its respective page.

If the provided element is a placeholder being copied from within the current presentation, properties that inherit from master or layout pages also inherit on the inserted element.

If the provided element is a placeholder being copied from a different presentation, properties that inherit from master or layout pages are copied onto the element from the source presentation.

WordArt — The inserted word art.

Scripts that use this method require authorization with one or more of the following scopes:

Scripts that use this method require authorization with one or more of the following scopes:

Replaces all instances of text matching find text with replace text. The search is case insensitive.

Integer — the number of occurrences changed

Scripts that use this method require authorization with one or more of the following scopes:

Replaces all instances of text matching find text with replace text.

Integer — the number of occurrences changed

Scripts that use this method require authorization with one or more of the following scopes:

Selects the Page in the active presentation as the current page selection and removes any previous selection.

A script can only access the selection of the user who is running the script, and only if the script is bound to the presentation.

Scripts that use this method require authorization with one or more of the following scopes:

---

## Class LinearOptimizationEngine Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/optimization/linear-optimization-engine

**Contents:**
- Class LinearOptimizationEngine Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
  - Methods
- Detailed documentation
  - addConstraint(lowerBound, upperBound)
    - Parameters
    - Return
  - addConstraints(lowerBounds, upperBounds, variableNames, coefficients)
    - Parameters
    - Return

LinearOptimizationEngine is used to model and solve linear programs by defining variables, constraints, and objectives.

You can add variables with specified bounds and types using methods like addVariable and addVariables.

Constraints with defined bounds can be added using addConstraint or addConstraints, and variable coefficients within these constraints are set separately.

The objective function is defined by setting the coefficient for each variable using setObjectiveCoefficient.

The optimization direction can be set to maximization or minimization using setMaximization or setMinimization.

The solve() method is used to find the solution to the defined linear program.

The engine used to model and solve a linear program. The example below solves the following linear program:

Two variables, x and y: 0 ≤ x ≤ 10 0 ≤ y ≤ 5

Constraints: 0 ≤ 2 * x + 5 * y ≤ 10 0 ≤ 10 * x + 3 * y ≤ 20

Objective: Maximize x + y

Adds a new linear constraint in the model. The upper and lower bound of the constraint are defined at creation time. Coefficients for the variables are defined via calls to LinearOptimizationConstraint.setCoefficient(variableName, coefficient).

LinearOptimizationConstraint — the constraint created

Adds constraints in batch to the model.

LinearOptimizationEngine — a linear optimization engine

Adds a new continuous variable to the model. The variable is referenced by its name. The type is set to VariableType.CONTINUOUS.

LinearOptimizationEngine — a linear optimization engine

Adds a new variable to the model. The variable is referenced by its name.

LinearOptimizationEngine — a linear optimization engine

Adds a new variable to the model. The variable is referenced by its name.

LinearOptimizationEngine — a linear optimization engine

Adds variables in batch to the model. The variables are referenced by their names.

LinearOptimizationEngine — a linear optimization engine

Sets the optimization direction to maximizing the linear objective function.

LinearOptimizationEngine — a linear optimization engine

Sets the optimization direction to minimizing the linear objective function.

LinearOptimizationEngine — a linear optimization engine

Sets the coefficient of a variable in the linear objective function.

LinearOptimizationEngine — a linear optimization engine

Solves the current linear program with the default deadline of 30 seconds. Returns the solution found.

LinearOptimizationSolution — solution of the optimization

Solves the current linear program. Returns the solution found. and if it is an optimal solution.

LinearOptimizationSolution — solution of the optimization

---

## Class Line Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/slides/line

**Contents:**
- Class Line Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
  - Methods
- Detailed documentation
  - alignOnPage(alignmentPosition)
    - Parameters
    - Return
  - bringForward()
    - Return
    - Authorization

The Line object in Apps Script represents a line page element and provides methods to manipulate its properties and position.

You can align, move forward/backward, bring to front/back, duplicate, and remove a Line element.

Methods are available to get and set various properties of the line, including its start and end points, height, width, rotation, dash style, arrow styles, fill, weight, line category, and line type.

You can manage connections for the line, including getting and setting connection sites at the start and end, and rerouting connectors.

The Line object also supports setting and removing links, getting the page element type, parent group, parent page, and object ID.

A PageElement representing a line.

Aligns the element to the specified alignment position on the page.

Line — This page element, for chaining.

Brings the page element forward on the page by one element.

The page element must not be in a group.

Line — This page element, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Brings the page element to the front of the page.

The page element must not be in a group.

Line — This page element, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Duplicates the page element.

The duplicate page element is placed on the same page at the same position as the original.

PageElement — The new duplicate of this page element.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the list of ConnectionSites on the page element, or an empty list if the page element does not have any connection sites.

ConnectionSite[] — The connection sites list, which may be empty if this element has no connection sites.

Scripts that use this method require authorization with one or more of the following scopes:

Gets the DashStyle of the line.

DashStyle — The style of the dashing used with this line.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the page element's alt text description. The description is combined with the title to display and read alt text.

String — The page element's alt text description.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the end point of the line, measured from the upper-left corner of the page.

Point — The ending point of the line.

Scripts that use this method require authorization with one or more of the following scopes:

Gets the ArrowStyle of the arrow at the end of the line.

ArrowStyle — The style of the arrow at the end of this line.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the connection at the end of the line, or null if there is no connection.

ConnectionSite — The connection at the end of the line.

Scripts that use this method require authorization with one or more of the following scopes:

Gets the element's height in points, which is the height of the element's bounding box when the element has no rotation.

This method isn't compatible with all page elements. To learn which page elements aren't compatible with this method, refer to the sizing and positioning limitations.

Number — The page element's inherent height in points, or null if the page element does not have a height.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the element's inherent height in points.

The page element's transform is relative to its inherent size. Use the inherent size in conjunction with the element's transform to determine the element's final visual appearance.

Number — The page element's inherent height in points, or null if the page element does not have a height.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the element's inherent width in points.

The page element's transform is relative to its inherent size. Use the inherent size in conjunction with the element's transform to determine the element's final visual appearance.

Number — The page element's inherent width in points, or null if the page element does not have a width.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the element's horizontal position in points, measured from the upper-left corner of the page when the element has no rotation.

Number — This element's horizontal position in points, from the upper-left corner of the page.

Scripts that use this method require authorization with one or more of the following scopes:

Gets the LineCategory of the line.

LineCategory — The line category.

Scripts that use this method require authorization with one or more of the following scopes:

Gets the LineFill of the line.

LineFill — The fill setting of this line.

Scripts that use this method require authorization with one or more of the following scopes:

Gets the LineType of the line.

LineType — The type of this line.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the Link or null if there is no link.

Link — The Link or null if there is no link.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the unique ID for this object. Object IDs used by pages and page elements share the same namespace.

String — The unique ID for this object.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the page element's type, represented as a PageElementType enum.

PageElementType — The page element's type.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the group this page element belongs to, or null if the element is not in a group.

Group — The group this page element belongs to, or null.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the page this page element is on.

Page — The page this element resides on.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the element's clockwise rotation angle around its center in degrees, where zero degrees means no rotation.

Number — The rotation angle in degrees between 0 (inclusive) and 360 (exclusive).

Scripts that use this method require authorization with one or more of the following scopes:

Returns the start point of the line, measured from the upper-left corner of the page.

Point — The starting point of the line.

Scripts that use this method require authorization with one or more of the following scopes:

Gets the ArrowStyle of the arrow at the beginning of the line.

ArrowStyle — The style of the arrow at the beginning of this line.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the connection at the beginning of the line, or null if there is no connection.

ConnectionSite — The connection at the beginning of the line.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the page element's alt text title. The title is combined with the description to display and read alt text.

String — The page element's alt text title.

Scripts that use this method require authorization with one or more of the following scopes:

Gets the element's vertical position in points, measured from the upper-left corner of the page when the element has no rotation.

Number — This element's vertical position in points, from the upper-left corner of the page.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the page element's transform.

The visual appearance of the page element is determined by its absolute transform. To compute the absolute transform, preconcatenate a page element's transform with the transforms of all of its parent groups. If the page element is not in a group, its absolute transform is the same as the value in this field.

AffineTransform — The page element's transform.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the thickness of the line in points.

Number — The thickness of the line in points.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the element's width in points, which is the width of the element's bounding box when the element has no rotation.

This method isn't compatible with all page elements. To learn which page elements aren't compatible with this method, refer to the sizing and positioning limitations.

Number — The page element's inherent width in points, or null if the page element does not have a width.

Scripts that use this method require authorization with one or more of the following scopes:

Returns true if the line is a connector, or false if not.

Connector is a type of line that is used to connect connections sites on applicable page elements. Each end of the connector can be connected to at most one connection site.

Boolean — True if the line is a connector, or false if not.

Scripts that use this method require authorization with one or more of the following scopes:

Preconcatenates the provided transform to the existing transform of the page element.

For example, to move a page elements 36 points to the left:

You can also replace the page element's transform with setTransform(transform).

Line — This page element, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Removes the page element.

If after a remove operation, a Group contains only one or no page elements, the group itself is also removed.

If a placeholder PageElement is removed on a master or layout, any empty inheriting placeholders are also removed.

Scripts that use this method require authorization with one or more of the following scopes:

Reroutes the start and end of the line to the closest two connection sites on the connected page elements. The start and end of the line must be connected to different page elements.

Scripts that use this method require authorization with one or more of the following scopes:

Scales the element's height by the specified ratio. The element's height is the height of its bounding box when the element has no rotation.

This method isn't compatible with all page elements. To learn which page elements aren't compatible with this method, refer to the sizing and positioning limitations.

Line — This page element, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Scales the element's width by the specified ratio. The element's width is the width of its bounding box when the element has no rotation.

This method isn't compatible with all page elements. To learn which page elements aren't compatible with this method, refer to the sizing and positioning limitations.

Line — This page element, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Selects only the PageElement in the active presentation and removes any previous selection. This is the same as calling select(replace) with true.

A script can only access the selection of the user who is running the script, and only if the script is bound to the presentation.

This sets the parent Page of the PageElement as the current page selection.

Scripts that use this method require authorization with one or more of the following scopes:

Selects the PageElement in the active presentation.

A script can only access the selection of the user who is running the script, and only if the script is bound to the presentation.

Pass true to this method to select only the PageElement and remove any previous selection. This also sets the parent Page of the PageElement as the current page selection.

Pass false to select multiple PageElement objects. The PageElement objects must be in the same Page.

The following conditions must be met while selecting a page element using a false parameter:

To make sure that’s the case the preferred approach is to select the parent Page first using Page.selectAsCurrentPage() and then select the page elements in that page.

Scripts that use this method require authorization with one or more of the following scopes:

Sends the page element backward on the page by one element.

The page element must not be in a group.

Line — This page element, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sends the page element to the back of the page.

The page element must not be in a group.

Line — This page element, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the DashStyle of the line.

Line — This line, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the page element's alt text description.

The method is not supported for Group elements.

Line — This page element.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the position of the end point of the line.

The line path may be adjusted after the position changes.

Line — This line, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the position of the end point of the line.

The line path may be adjusted after the position changes.

Line — This line, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the ArrowStyle of the arrow at the end of the line.

Line — This line, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the connection at the end of the line. It moves the end of the line to the specified connection site while keeping the other end intact.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the element's height in points, which is the height of the element's bounding box when the element has no rotation.

This method isn't compatible with all page elements. To learn which page elements aren't compatible with this method, refer to the sizing and positioning limitations.

Line — This page element, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the element's horizontal position in points, measured from the upper-left corner of the page when the element has no rotation.

Line — This page element, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the LineCategory of the line.

You can only set the category on connectors. The connector may be rerouted after changing its category.

Scripts that use this method require authorization with one or more of the following scopes:

Sets a Link to the given Slide using the zero-based index of the slide.

Link — The Link that was set.

Scripts that use this method require authorization with one or more of the following scopes:

Sets a Link to the given Slide, the link is set by the given slide ID.

Link — The Link that was set.

Scripts that use this method require authorization with one or more of the following scopes:

Sets a Link to the given Slide using the relative position of the slide.

Link — The Link that was set.

Scripts that use this method require authorization with one or more of the following scopes:

Sets a Link to the given non-empty URL string.

Link — The Link that was set.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the element's clockwise rotation angle around its center in degrees.

This method isn't compatible with all page elements. To learn which page elements aren't compatible with this method, refer to the sizing and positioning limitations.

Line — This page element, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the position of the start point of the line.

The line path may be adjusted after the position changes.

Line — This line, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the position of the start point of the line.

The line path may be adjusted after the position changes.

Line — This line, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the ArrowStyle of the arrow at the beginning of the line.

Line — This line, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the connection at the beginning of the line. It moves the start of the line to the specified connection site while keeping the other end intact.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the page element's alt text title.

The method is not supported for Group elements.

Line — This page element.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the element's vertical position in points, measured from the upper-left corner of the page when the element has no rotation.

Line — This page element, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the transform of the page element with the provided transform.

Updating the transform of a group changes the absolute transform of the page elements in that group, which can change their visual appearance.

Updating the transform of a page element that is in a group only changes the transform of that page element; it doesn't affect the transforms of the group or other page elements in the group.

For details on how transforms impact the visual appearance of page elements, see getTransform().

Line — This element, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the thickness of the line in points.

Line — This line, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the element's width in points, which is the width of the element's bounding box when the element has no rotation.

This method isn't compatible with all page elements. To learn which page elements aren't compatible with this method, refer to the sizing and positioning limitations.

Line — This page element, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

---

## Class LinkPreview Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/card-service/link-preview

**Contents:**
- Class LinkPreview Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
  - Methods
- Detailed documentation
  - printJson()
    - Return
  - setLinkPreviewTitle(title)
    - Parameters
    - Return
  - setPreviewCard(previewCard)

Card action that displays a link preview card and smart chip in the host app.

Methods include printing JSON, setting the link preview title, setting the preview card, and setting the smart chip title.

setLinkPreviewTitle sets the title above the preview card, or defaults to the preview card header if unset.

setPreviewCard sets the card displaying information about a third-party or non-Google link.

setTitle sets the title in the smart chip for the link preview, or defaults to the preview card header if unset.

Card action that displays a link preview card and smart chip in the host app. For more information, refer to Preview links with smart chips.

Prints the JSON representation of this object. This is for debugging only.

Sets the title that displays in the link preview above the preview card. If unset, the link preview displays the header of the PreviewCard.

LinkPreview — This object, for chaining.

Sets the card that displays information about a link from a third-party or non-Google service.

LinkPreview — This object, for chaining.

Sets the title that displays in the smart chip for the link preview. If unset, the smart chip displays the header of the PreviewCard.

LinkPreview — This object, for chaining.

---

## Class LookerDataSourceSpecBuilder Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/spreadsheet/looker-data-source-spec-builder

**Contents:**
- Class LookerDataSourceSpecBuilder Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
  - Methods
- Detailed documentation
  - build()
    - Return
  - copy()
    - Return
  - getExploreName()
    - Return

LookerDataSourceSpecBuilder is used to create a new Looker Data Source Spec builder in Apps Script.

You can build a data source specification from the builder's settings using the build() method.

The builder provides methods to get and set the Looker explore name, instance URL, and model name.

You can manage parameters using methods like getParameters(), removeAllParameters(), and removeParameter().

The builder for LookerDataSourceSpecBuilder.

This example shows how to create a new Looker Data Source Spec builder.

Builds a data source specification from the settings in this builder. Must use as...() to specify a data source type before building.

The following code sample builds a BigQuery DataSource Spec.

The following code sample builds a Looker DataSource Spec.

DataSourceSpec — The data source specification.

Creates a DataSourceSpecBuilder based on this data source's settings.

DataSourceSpecBuilder — The builder.

Gets the name of the Looker explore in the model.

String — The name of the Looker explore.

Gets the URL of the Looker instance.

String — The URL of the Looker instance.

Gets the name of the Looker model in the instance.

String — The name of the Looker model.

Gets the parameters of the data source.

This method is only available for BigQuery data sources.

DataSourceParameter[] — The parameter list.

Gets the type of the data source.

DataSourceType — The data source type.

Removes all the parameters.

LookerDataSourceSpecBuilder — The builder, for chaining.

Removes the specified parameter.

LookerDataSourceSpecBuilder — The builder, for chaining.

Sets the explore name in the Looker model.

LookerDataSourceSpecBuilder — This builder, for chaining.

Sets the instance URL for Looker.

LookerDataSourceSpecBuilder — The builder, for chaining.

Sets the Looker model name in the Looker instance.

LookerDataSourceSpecBuilder — The builder, for chaining.

Adds a parameter, or if the parameter with the name exists, updates its source cell for data source spec builders of type DataSourceType.BIGQUERY.

This method is only available for BigQuery data sources.

LookerDataSourceSpecBuilder — The builder, for chaining.

---

## Class LookerDataSourceSpec Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/spreadsheet/looker-data-source-spec

**Contents:**
- Class LookerDataSourceSpec Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
  - Methods
- Detailed documentation
  - copy()
    - Return
  - getExploreName()
    - Return
  - getInstanceUrl()
    - Return

LookerDataSourceSpec is a DataSourceSpec used to access existing Looker data source specifications.

You can obtain a Looker data source specification from a sheet with a Looker connection using getDataSources() and asLooker().

The copy() method creates a DataSourceSpecBuilder based on the current data source settings.

Methods like getExploreName(), getInstanceUrl(), and getModelName() retrieve specific details about the Looker data source.

getParameters() gets the data source parameters, which is only available for BigQuery data sources, and getType() gets the data source type.

A DataSourceSpec which is used to access specifically the existing Looker data source specifications. To create a new data source specification, use SpreadsheetApp.newDataSourceSpec().

This example shows how you can get the Looker data source spec from a sheet which has just one Looker connection.

Creates a DataSourceSpecBuilder based on this data source's settings.

DataSourceSpecBuilder — The builder.

Gets the name of the Looker explore in the model.

String — The name of the Looker explore.

Gets the URL of the Looker instance.

String — The URL of the Looker instance.

Gets the name of the Looker model in the instance.

String — The name of the Looker model.

Gets the parameters of the data source.

This method is only available for BigQuery data sources.

DataSourceParameter[] — The parameter list.

Gets the type of the data source.

DataSourceType — The data source type.

---

## Class Master Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/slides/master

**Contents:**
- Class Master Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
  - Methods
- Detailed documentation
  - getBackground()
    - Return
    - Authorization
  - getColorScheme()
    - Return
    - Authorization

A Master in a presentation defines common elements and properties for layouts, including default text styles, shape properties, common page properties, and shapes displayed on all slides.

The Master class provides methods to retrieve various page elements and properties like background, color scheme, groups, images, and layouts.

The Master class also includes methods for inserting different elements such as groups, images, lines, shapes, charts, tables, text boxes, videos, and WordArt.

Additional methods available in the Master class allow for removing the page, replacing text within the page, and selecting the master as the current page.

Most methods within the Master class require specific authorization scopes, such as https://www.googleapis.com/auth/presentations.currentonly or https://www.googleapis.com/auth/presentations.

A master in a presentation.

Masters contains all common page elements and the common properties for a set of layouts. They serve three purposes:

Gets the page's background.

PageBackground — The page's background.

Scripts that use this method require authorization with one or more of the following scopes:

Gets the ColorScheme associated with the page.

ColorScheme — The page's color scheme.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the list of Group objects on the page.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the list of Image objects on the page.

Scripts that use this method require authorization with one or more of the following scopes:

Gets this master's layouts.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the list of Line objects on the page.

Scripts that use this method require authorization with one or more of the following scopes:

Gets the unique ID for the page. Object IDs used by pages and page elements share the same namespace.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the PageElement on the page with the given ID, or null if none exists.

PageElement — The page element with the given ID.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the list of PageElement objects rendered on the page.

Scripts that use this method require authorization with one or more of the following scopes:

Gets the type of the page.

PageType — The page type.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the placeholder PageElement object for a specified PlaceholderType or null if a matching placeholder is not present.

If there are multiple placeholders with the same type, it returns the one with minimal placeholder index. If there are multiple matching placeholders with the same index, it returns the first placeholder from the page's page elements collection.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the placeholder PageElement object for a specified PlaceholderType and a placeholder index, or null if the placeholder is not present.

If there are multiple placeholders with the same type and index, it returns the first placeholder from the page's page elements collection.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the list of placeholder PageElement objects in the page.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the list of Shape objects on the page.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the list of SheetsChart objects on the page.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the list of Table objects on the page.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the list of Video objects on the page.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the list of WordArt objects on the page.

Scripts that use this method require authorization with one or more of the following scopes:

Groups all the specified page elements.

There should be at least two page elements on the same page that are not already in another group. Some page elements, such as Videos, Tables and placeholder Shapes cannot be grouped.

Group — The new group.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts a copy of the provided Group on the page.

The inserted element's position on this page is determined from the source element's position on its respective page.

If the provided element is a placeholder being copied from within the current presentation, properties that inherit from master or layout pages also inherit on the inserted element.

If the provided element is a placeholder being copied from a different presentation, properties that inherit from master or layout pages are copied onto the element from the source presentation.

Group — The inserted group.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts an image at the top left corner of the page with a default size from the specified image blob.

Inserting the image fetches it from the BlobSource once and a copy is stored for display inside the presentation. Images must be less than 50MB in size, cannot exceed 25 megapixels, and must be in either in PNG, JPEG, or GIF format.

Image — The inserted image.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts an image on the page with the provided position and size from the specified image blob.

The image is fetched from the provided BlobSource once at insertion time and a copy is stored for display inside the presentation. Images must be less than 50MB in size, cannot exceed 25 megapixels, and must be in either in PNG, JPEG, or GIF format.

In order to maintain the image's aspect ratio, the image is scaled and centered with respect to the provided size.

Image — The inserted image.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts a copy of the provided Image on the page.

The inserted images's position on this page is determined from the source image's position on its respective page.

If the provided image is a placeholder being copied from within the current presentation, properties that inherit from master or layout pages also inherit on the inserted image.

If the provided image is a placeholder being copied from a different presentation, properties that inherit from master or layout pages are copied onto the image from the source presentation. If the copied placeholder image is empty, nothing is inserted in the destination presentation.

Image — The inserted image.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts an image at the top left corner of the page with a default size from the provided URL.

Inserting the image fetches it from the URL once and a copy is stored for display inside the presentation. Images must be less than 50MB in size, cannot exceed 25 megapixels, and must be in either in PNG, JPEG, or GIF format.

The provided URL must be publicly accessible and no larger than 2kB. The URL itself is saved with the image and exposed via Image.getSourceUrl().

Image — The inserted image.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts an image on the page with the provided position and size from the provided URL.

Inserting the image fetches it from the URL once and a copy is stored for display inside the presentation. Images must be less than 50MB in size, cannot exceed 25 megapixels, and must be in either in PNG, JPEG, or GIF format.

The provided URL must be publicly accessible and no larger than 2kB. The URL itself is saved with the image and exposed via Image.getSourceUrl().

In order to maintain the image's aspect ratio, the image is scaled and centered with respect to the provided size.

Image — The inserted image.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts a copy of the provided Line on the page.

The inserted element's position on this page is determined from the source element's position on its respective page.

If the provided element is a placeholder being copied from within the current presentation, properties that inherit from master or layout pages also inherit on the inserted element.

If the provided element is a placeholder being copied from a different presentation, properties that inherit from master or layout pages are copied onto the element from the source presentation.

Line — The inserted line.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts a line on the page connecting two connection sites. The two connection sites must be on this page.

Line — The inserted line.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts a line on the page.

Line — The inserted line.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts a copy of the provided PageElement on the page.

The inserted element's position on this page is determined from the source element's position on its respective page.

If the provided element is a placeholder being copied from within the current presentation, properties that inherit from master or layout pages also inherit on the inserted element.

If the provided element is a placeholder being copied from a different presentation, properties that inherit from master or layout pages are copied onto the element from the source presentation.

PageElement — The inserted page element.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts a copy of the provided Shape on the page.

The inserted element's position on this page is determined from the source element's position on its respective page.

If the provided element is a placeholder being copied from within the current presentation, properties that inherit from master or layout pages also inherit on the inserted element.

If the provided element is a placeholder being copied from a different presentation, properties that inherit from master or layout pages are copied onto the element from the source presentation.

Shape — The inserted shape.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts a shape on the page.

The shape is inserted with a default size at the top left corner of the page.

Shape — The inserted shape.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts a shape on the page.

Shape — The inserted shape.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts a Google Sheets chart on the page.

The chart is inserted with a default size at the top left corner of the page.

The inserted chart is linked with the source Google Sheets chart which allows it to be updated. Other collaborators can see the link to the source spreadsheet.

SheetsChart — The inserted chart in the page.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts a Google Sheets chart on the page with the provided position and size.

In order to maintain the chart's aspect ratio, the chart is scaled and centered with respect to the provided size.

The inserted chart is linked with the source Google Sheets chart which allows it to be updated. Other collaborators can see the link to the source spreadsheet.

SheetsChart — The inserted chart in the page.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts a copy of the provided SheetsChart on the page.

The inserted element's position on this page is determined from the source element's position on its respective page.

If the provided element is a placeholder being copied from within the current presentation, properties that inherit from master or layout pages also inherit on the inserted element.

If the provided element is a placeholder being copied from a different presentation, properties that inherit from master or layout pages are copied onto the element from the source presentation.

SheetsChart — The inserted sheets chart.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts a Google Sheets chart as an Image on the page.

The image of the chart is inserted with a default size at the top left corner of the page.

The inserted image of chart is not linked with the source Google Sheets chart.

Image — The inserted image of the chart in the page.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts a Google Sheets chart as an Image on the page with the provided position and size.

In order to maintain the chart image's aspect ratio, the image is scaled and centered with respect to the provided size.

The inserted image of the chart is not linked with the source Google Sheets chart.

Image — The inserted image of the chart in the page.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts a table on the page.

The table is centered on the page with default size and evenly distributed rows and columns.

Table — The inserted table.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts a table on the page with the provided position and size.

Rows and columns are evenly distributed in the created table.

Table — The inserted table.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts a copy of the provided Table on the page.

The inserted element's position on this page is determined from the source element's position on its respective page.

If the provided element is a placeholder being copied from within the current presentation, properties that inherit from master or layout pages also inherit on the inserted element.

If the provided element is a placeholder being copied from a different presentation, properties that inherit from master or layout pages are copied onto the element from the source presentation.

Table — The inserted table.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts a text box Shape containing the provided string on the page.

The text box shape is inserted with a default size at the top left corner of the page.

Shape — The inserted text box shape.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts a text box Shape containing the provided string on the page.

Shape — The inserted text box shape.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts a video at the top left corner of the page with a default size.

Only YouTube videos are currently supported.

Video — The inserted video.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts a video on the page with the provided position and size.

Only YouTube videos are currently supported.

Video — The inserted video.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts a copy of the provided Video on the page.

The inserted element's position on this page is determined from the source element's position on its respective page.

If the provided element is a placeholder being copied from within the current presentation, properties that inherit from master or layout pages also inherit on the inserted element.

If the provided element is a placeholder being copied from a different presentation, properties that inherit from master or layout pages are copied onto the element from the source presentation.

Video — The inserted video.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts a copy of the provided WordArt on the page.

The inserted element's position on this page is determined from the source element's position on its respective page.

If the provided element is a placeholder being copied from within the current presentation, properties that inherit from master or layout pages also inherit on the inserted element.

If the provided element is a placeholder being copied from a different presentation, properties that inherit from master or layout pages are copied onto the element from the source presentation.

WordArt — The inserted word art.

Scripts that use this method require authorization with one or more of the following scopes:

Scripts that use this method require authorization with one or more of the following scopes:

Replaces all instances of text matching find text with replace text. The search is case insensitive.

Integer — the number of occurrences changed

Scripts that use this method require authorization with one or more of the following scopes:

Replaces all instances of text matching find text with replace text.

Integer — the number of occurrences changed

Scripts that use this method require authorization with one or more of the following scopes:

Selects the Page in the active presentation as the current page selection and removes any previous selection.

A script can only access the selection of the user who is running the script, and only if the script is bound to the presentation.

Scripts that use this method require authorization with one or more of the following scopes:

---

## Class Menu Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/base/menu

**Contents:**
- Class Menu Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
  - Methods
- Detailed documentation
  - addItem(caption, functionName)
    - Parameters
    - Return
  - addSeparator()
    - Return
  - addSubMenu(menu)

Custom menus are part of the user interface for a Google App and can only be interacted with by container-bound scripts.

The provided example demonstrates how to create a custom menu with items, a separator, and a submenu using Apps Script.

Key methods for creating a custom menu include addItem to add menu options, addSeparator for visual separation, addSubMenu to add nested menus, and addToUi to display the menu.

Each menu method returns the Menu object for chaining except for addToUi, which returns void.

A custom menu in an instance of the user interface for a Google App. A script can only interact with the UI for the current instance of an open document or form, and only if the script is container-bound to the document or form. For more information, see the guide to menus.

Adds an item to the menu. The label for a menu item should be in sentence case (only the first word capitalized).

Menu — This Menu, for chaining.

Adds a visual separator to the menu.

Menu — This Menu, for chaining.

Adds a sub-menu to the menu.

Menu — This Menu, for chaining.

Inserts the menu into the instance of the editor's user interface.

---

## Class Notification Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/card-service/notification

**Contents:**
- Class Notification Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
  - Methods
- Detailed documentation
  - setText(text)
    - Parameters
    - Return

Notifications are displayed to users after interacting with a UI element.

Notifications are created using CardService.newNotification() and can be set with setText(text).

The setText(text) method is required and sets the string content of the notification.

A notification shown to the user as a response to interacting with a UI element.

Sets the text to show in the notification. Required.

Notification — This object, for chaining.

---

## Class Page Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/slides/page

**Contents:**
- Class Page Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
  - Methods
- Detailed documentation
  - asLayout()
    - Return
    - Authorization
  - asMaster()
    - Return
    - Authorization

Various elements such as charts, tables, text boxes, videos, and Word Art can be inserted into a Google Slides page using specific methods with options for position, size, and content.

Elements can be inserted with default settings or with explicitly defined position and size parameters.

Existing elements can be copied and inserted, with their original position influencing the inserted element's position.

The remove() method allows for the deletion of a page.

Text on a page can be replaced using replaceAllText, with an option for case sensitivity.

A page in a presentation.

Returns the page as a layout.

Layout — The page as a layout.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the page as a master.

Master — The page as a master.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the page as a slide.

Slide — The page as a slide.

Scripts that use this method require authorization with one or more of the following scopes:

Gets the page's background.

PageBackground — The page's background.

Scripts that use this method require authorization with one or more of the following scopes:

Gets the ColorScheme associated with the page.

ColorScheme — The page's color scheme.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the list of Group objects on the page.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the list of Image objects on the page.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the list of Line objects on the page.

Scripts that use this method require authorization with one or more of the following scopes:

Gets the unique ID for the page. Object IDs used by pages and page elements share the same namespace.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the PageElement on the page with the given ID, or null if none exists.

PageElement — The page element with the given ID.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the list of PageElement objects rendered on the page.

Scripts that use this method require authorization with one or more of the following scopes:

Gets the type of the page.

PageType — The page type.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the placeholder PageElement object for a specified PlaceholderType or null if a matching placeholder is not present.

If there are multiple placeholders with the same type, it returns the one with minimal placeholder index. If there are multiple matching placeholders with the same index, it returns the first placeholder from the page's page elements collection.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the placeholder PageElement object for a specified PlaceholderType and a placeholder index, or null if the placeholder is not present.

If there are multiple placeholders with the same type and index, it returns the first placeholder from the page's page elements collection.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the list of placeholder PageElement objects in the page.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the list of Shape objects on the page.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the list of SheetsChart objects on the page.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the list of Table objects on the page.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the list of Video objects on the page.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the list of WordArt objects on the page.

Scripts that use this method require authorization with one or more of the following scopes:

Groups all the specified page elements.

There should be at least two page elements on the same page that are not already in another group. Some page elements, such as Videos, Tables and placeholder Shapes cannot be grouped.

Group — The new group.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts a copy of the provided Group on the page.

The inserted element's position on this page is determined from the source element's position on its respective page.

If the provided element is a placeholder being copied from within the current presentation, properties that inherit from master or layout pages also inherit on the inserted element.

If the provided element is a placeholder being copied from a different presentation, properties that inherit from master or layout pages are copied onto the element from the source presentation.

Group — The inserted group.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts an image at the top left corner of the page with a default size from the specified image blob.

Inserting the image fetches it from the BlobSource once and a copy is stored for display inside the presentation. Images must be less than 50MB in size, cannot exceed 25 megapixels, and must be in either in PNG, JPEG, or GIF format.

Image — The inserted image.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts an image on the page with the provided position and size from the specified image blob.

The image is fetched from the provided BlobSource once at insertion time and a copy is stored for display inside the presentation. Images must be less than 50MB in size, cannot exceed 25 megapixels, and must be in either in PNG, JPEG, or GIF format.

In order to maintain the image's aspect ratio, the image is scaled and centered with respect to the provided size.

Image — The inserted image.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts a copy of the provided Image on the page.

The inserted images's position on this page is determined from the source image's position on its respective page.

If the provided image is a placeholder being copied from within the current presentation, properties that inherit from master or layout pages also inherit on the inserted image.

If the provided image is a placeholder being copied from a different presentation, properties that inherit from master or layout pages are copied onto the image from the source presentation. If the copied placeholder image is empty, nothing is inserted in the destination presentation.

Image — The inserted image.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts an image at the top left corner of the page with a default size from the provided URL.

Inserting the image fetches it from the URL once and a copy is stored for display inside the presentation. Images must be less than 50MB in size, cannot exceed 25 megapixels, and must be in either in PNG, JPEG, or GIF format.

The provided URL must be publicly accessible and no larger than 2kB. The URL itself is saved with the image and exposed via Image.getSourceUrl().

Image — The inserted image.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts an image on the page with the provided position and size from the provided URL.

Inserting the image fetches it from the URL once and a copy is stored for display inside the presentation. Images must be less than 50MB in size, cannot exceed 25 megapixels, and must be in either in PNG, JPEG, or GIF format.

The provided URL must be publicly accessible and no larger than 2kB. The URL itself is saved with the image and exposed via Image.getSourceUrl().

In order to maintain the image's aspect ratio, the image is scaled and centered with respect to the provided size.

Image — The inserted image.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts a copy of the provided Line on the page.

The inserted element's position on this page is determined from the source element's position on its respective page.

If the provided element is a placeholder being copied from within the current presentation, properties that inherit from master or layout pages also inherit on the inserted element.

If the provided element is a placeholder being copied from a different presentation, properties that inherit from master or layout pages are copied onto the element from the source presentation.

Line — The inserted line.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts a line on the page connecting two connection sites. The two connection sites must be on this page.

Line — The inserted line.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts a line on the page.

Line — The inserted line.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts a copy of the provided PageElement on the page.

The inserted element's position on this page is determined from the source element's position on its respective page.

If the provided element is a placeholder being copied from within the current presentation, properties that inherit from master or layout pages also inherit on the inserted element.

If the provided element is a placeholder being copied from a different presentation, properties that inherit from master or layout pages are copied onto the element from the source presentation.

PageElement — The inserted page element.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts a copy of the provided Shape on the page.

The inserted element's position on this page is determined from the source element's position on its respective page.

If the provided element is a placeholder being copied from within the current presentation, properties that inherit from master or layout pages also inherit on the inserted element.

If the provided element is a placeholder being copied from a different presentation, properties that inherit from master or layout pages are copied onto the element from the source presentation.

Shape — The inserted shape.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts a shape on the page.

The shape is inserted with a default size at the top left corner of the page.

Shape — The inserted shape.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts a shape on the page.

Shape — The inserted shape.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts a Google Sheets chart on the page.

The chart is inserted with a default size at the top left corner of the page.

The inserted chart is linked with the source Google Sheets chart which allows it to be updated. Other collaborators can see the link to the source spreadsheet.

SheetsChart — The inserted chart in the page.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts a Google Sheets chart on the page with the provided position and size.

In order to maintain the chart's aspect ratio, the chart is scaled and centered with respect to the provided size.

The inserted chart is linked with the source Google Sheets chart which allows it to be updated. Other collaborators can see the link to the source spreadsheet.

SheetsChart — The inserted chart in the page.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts a copy of the provided SheetsChart on the page.

The inserted element's position on this page is determined from the source element's position on its respective page.

If the provided element is a placeholder being copied from within the current presentation, properties that inherit from master or layout pages also inherit on the inserted element.

If the provided element is a placeholder being copied from a different presentation, properties that inherit from master or layout pages are copied onto the element from the source presentation.

SheetsChart — The inserted sheets chart.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts a Google Sheets chart as an Image on the page.

The image of the chart is inserted with a default size at the top left corner of the page.

The inserted image of chart is not linked with the source Google Sheets chart.

Image — The inserted image of the chart in the page.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts a Google Sheets chart as an Image on the page with the provided position and size.

In order to maintain the chart image's aspect ratio, the image is scaled and centered with respect to the provided size.

The inserted image of the chart is not linked with the source Google Sheets chart.

Image — The inserted image of the chart in the page.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts a table on the page.

The table is centered on the page with default size and evenly distributed rows and columns.

Table — The inserted table.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts a table on the page with the provided position and size.

Rows and columns are evenly distributed in the created table.

Table — The inserted table.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts a copy of the provided Table on the page.

The inserted element's position on this page is determined from the source element's position on its respective page.

If the provided element is a placeholder being copied from within the current presentation, properties that inherit from master or layout pages also inherit on the inserted element.

If the provided element is a placeholder being copied from a different presentation, properties that inherit from master or layout pages are copied onto the element from the source presentation.

Table — The inserted table.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts a text box Shape containing the provided string on the page.

The text box shape is inserted with a default size at the top left corner of the page.

Shape — The inserted text box shape.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts a text box Shape containing the provided string on the page.

Shape — The inserted text box shape.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts a video at the top left corner of the page with a default size.

Only YouTube videos are currently supported.

Video — The inserted video.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts a video on the page with the provided position and size.

Only YouTube videos are currently supported.

Video — The inserted video.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts a copy of the provided Video on the page.

The inserted element's position on this page is determined from the source element's position on its respective page.

If the provided element is a placeholder being copied from within the current presentation, properties that inherit from master or layout pages also inherit on the inserted element.

If the provided element is a placeholder being copied from a different presentation, properties that inherit from master or layout pages are copied onto the element from the source presentation.

Video — The inserted video.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts a copy of the provided WordArt on the page.

The inserted element's position on this page is determined from the source element's position on its respective page.

If the provided element is a placeholder being copied from within the current presentation, properties that inherit from master or layout pages also inherit on the inserted element.

If the provided element is a placeholder being copied from a different presentation, properties that inherit from master or layout pages are copied onto the element from the source presentation.

WordArt — The inserted word art.

Scripts that use this method require authorization with one or more of the following scopes:

Scripts that use this method require authorization with one or more of the following scopes:

Replaces all instances of text matching find text with replace text. The search is case insensitive.

Integer — the number of occurrences changed

Scripts that use this method require authorization with one or more of the following scopes:

Replaces all instances of text matching find text with replace text.

Integer — the number of occurrences changed

Scripts that use this method require authorization with one or more of the following scopes:

Selects the Page in the active presentation as the current page selection and removes any previous selection.

A script can only access the selection of the user who is running the script, and only if the script is bound to the presentation.

Scripts that use this method require authorization with one or more of the following scopes:

---

## Class Person Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/document/person

**Contents:**
- Class Person Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
  - Methods
- Detailed documentation
  - copy()
    - Return
    - Authorization
  - getAttributes()
    - Return
    - Authorization

A "Person" element represents a link to a person, primarily through an email address.

An optional name can be associated with the email address and displayed instead of the email in the document body.

Key methods allow for copying, retrieving attributes, getting email and name, navigating siblings and parent, getting element type, checking document end status, merging with siblings, removing from parent, and setting attributes.

An element representing a link to a person. A person link refers to an email address and might optionally have a name associated with the address. If the name is set, the name is what is displayed in the document body.

Returns a detached, deep copy of the current element.

Any child elements present in the element are also copied. The new element doesn't have a parent.

Person — The new copy.

Scripts that use this method require authorization with one or more of the following scopes:

Retrieves the element's attributes.

The result is an object containing a property for each valid element attribute where each property name corresponds to an item in the DocumentApp.Attribute enumeration.

Object — The element's attributes.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the person's email address.

String — The email address of the person.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the person's display name, if set.

String — The display name of the person link, or null if the element displays the email address instead.

Scripts that use this method require authorization with one or more of the following scopes:

Retrieves the element's next sibling element.

The next sibling has the same parent and follows the current element.

Element — The next sibling element.

Scripts that use this method require authorization with one or more of the following scopes:

Retrieves the element's parent element.

The parent element contains the current element.

ContainerElement — The parent element.

Scripts that use this method require authorization with one or more of the following scopes:

Retrieves the element's previous sibling element.

The previous sibling has the same parent and precedes the current element.

Element — The previous sibling element.

Scripts that use this method require authorization with one or more of the following scopes:

Retrieves the element's ElementType.

Use getType() to determine the exact type of a given element.

ElementType — The element type.

Scripts that use this method require authorization with one or more of the following scopes:

Determines whether the element is at the end of the Document.

Boolean — Whether the element is at the end of the tab.

Scripts that use this method require authorization with one or more of the following scopes:

Merges the element with the preceding sibling of the same type.

Only elements of the same ElementType can be merged. Any child elements contained in the current element are moved to the preceding sibling element.

The current element is removed from the document.

Person — The merged element.

Scripts that use this method require authorization with one or more of the following scopes:

Removes the element from its parent.

Person — The removed element.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the element's attributes.

The specified attributes parameter must be an object where each property name is an item in the DocumentApp.Attribute enumeration and each property value is the new value to be applied.

Person — The current element.

Scripts that use this method require authorization with one or more of the following scopes:

---

## Class PivotTable Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/spreadsheet/pivot-table

**Contents:**
- Class PivotTable Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
  - Methods
- Detailed documentation
  - addCalculatedPivotValue(name, formula)
    - Parameters
    - Return
    - Authorization
  - addColumnGroup(sourceDataColumn)
    - Parameters

Pivot tables can be accessed and modified using various methods.

Methods are available to add calculated pivot values, column groups, filters, and pivot values.

You can retrieve information about the pivot table's anchor cell, column groups, filters, pivot values, row groups, source data range, and values display orientation.

Pivot tables can be deleted using the remove() method.

The display orientation of pivot table values can be set using the setValuesDisplayOrientation() method.

Access and modify pivot tables.

Creates a new pivot value in the pivot table calculated from the specified formula with the specified name.

PivotValue — the newly created PivotValue

Scripts that use this method require authorization with one or more of the following scopes:

Defines a new pivot column grouping in the pivot table. The specified sourceDataColumn indicates the column in the source data this grouping is based on.

PivotGroup — the newly created PivotGroup

Scripts that use this method require authorization with one or more of the following scopes:

Creates a new pivot filter for the pivot table. The specified sourceDataColumn indicates the column in the source data this filter operates on.

PivotFilter — the newly created PivotFilter

Scripts that use this method require authorization with one or more of the following scopes:

Defines a new pivot value in the pivot table with the specified summarizeFunction. The specified sourceDataColumn indicates the column in the source data this value is based on.

PivotValue — the newly created PivotValue

Scripts that use this method require authorization with one or more of the following scopes:

Defines a new pivot row grouping in the pivot table. The specified sourceDataColumn indicates the column in the source data this grouping is based on.

PivotGroup — the newly created PivotGroup

Scripts that use this method require authorization with one or more of the following scopes:

Returns the pivot table as a data source pivot table if the pivot table is linked to a DataSource, or null otherwise.

DataSourcePivotTable — A data source pivot table.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the Range representing the cell where this pivot table is anchored.

Range — this pivot table's anchor cell

Scripts that use this method require authorization with one or more of the following scopes:

Returns an ordered list of the column groups in this pivot table.

PivotGroup[] — the column groups in this pivot table

Scripts that use this method require authorization with one or more of the following scopes:

Returns an ordered list of the filters in this pivot table.

PivotFilter[] — the filters in this pivot table

Scripts that use this method require authorization with one or more of the following scopes:

Returns an ordered list of the pivot values in this pivot table.

PivotValue[] — the pivot values in this pivot table

Scripts that use this method require authorization with one or more of the following scopes:

Returns an ordered list of the row groups in this pivot table.

PivotGroup[] — the row groups in this pivot table

Scripts that use this method require authorization with one or more of the following scopes:

Returns the source data range on which the pivot table is constructed.

Range — The source data range of this pivot table.

Scripts that use this method require authorization with one or more of the following scopes:

Returns whether values are displayed as rows or columns.

Dimension — whether values are displayed as rows or columns

Scripts that use this method require authorization with one or more of the following scopes:

Deletes this pivot table. Further operations on this pivot table results in an error.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the layout of this pivot table to display values as columns or rows.

PivotTable — the pivot table for chaining

Scripts that use this method require authorization with one or more of the following scopes:

---

## Class PivotValue Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/spreadsheet/pivot-value

**Contents:**
- Class PivotValue Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
  - Methods
- Detailed documentation
  - getDisplayType()
    - Return
    - Authorization
  - getFormula()
    - Return
    - Authorization

PivotValue allows you to access and modify value groups within pivot tables.

You can retrieve information about a PivotValue such as its display type, formula, associated PivotTable, source data column, and summarization function.

PivotValue provides methods to modify the display name, set the formula, change how the value is shown, and update the summarization function.

You can remove a PivotValue from the pivot table using the remove() method.

Access and modify value groups in pivot tables.

Returns the display type describing how this pivot value is currently displayed in the table.

PivotValueDisplayType — the display type for this pivot value

Scripts that use this method require authorization with one or more of the following scopes:

Returns the formula used to calculate this value. If this value is not a calculated field this method returns null.

String — the pivot value for chaining

Scripts that use this method require authorization with one or more of the following scopes:

Returns the PivotTable which this value belongs to.

PivotTable — the pivot table this value belongs to

Scripts that use this method require authorization with one or more of the following scopes:

Returns the number of the source data column the pivot value summarizes. This index is 1-based, if this group summarizes source data in column "A" of the spreadsheet this method returns 1.

Integer — The source data column number.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the data source column the pivot value summarizes. Returns null if the pivot table is not a {DataSourcePivotTableApi}.

DataSourceColumn — The source data source column the pivot value summarizes.

Scripts that use this method require authorization with one or more of the following scopes:

Returns this group’s summarization function.

PivotTableSummarizeFunction — the group's summarization function

Scripts that use this method require authorization with one or more of the following scopes:

Remove this value from the pivot table.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the display name for this value in the pivot table.

PivotValue — the pivot value for chaining

Scripts that use this method require authorization with one or more of the following scopes:

Sets the formula used to calculate this value. If this value is not a calculated field this method results in an error.

PivotValue — the pivot value for chaining

Scripts that use this method require authorization with one or more of the following scopes:

Displays this value in the pivot table as a function of another value.

PivotValue — the pivot value for chaining

Scripts that use this method require authorization with one or more of the following scopes:

Sets the summarization function.

PivotValue — the pivot value for chaining

Scripts that use this method require authorization with one or more of the following scopes:

---

## Class Presentation Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/slides/presentation

**Contents:**
- Class Presentation Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
  - Methods
- Detailed documentation
  - addEditor(emailAddress)
    - Parameters
    - Return
    - Authorization
  - addEditor(user)
    - Parameters

You can add and remove editors and viewers to a presentation using various methods.

Slides can be appended to or inserted into a presentation with different layouts or by copying existing slides.

Information about the presentation, such as its ID, name, layouts, masters, and page dimensions, can be retrieved using specific methods.

You can get the current user's selection within an active presentation and find specific page elements or slides by their ID.

Text within the presentation can be replaced, and the presentation can be saved and closed.

Adds the given user to the list of editors for the Presentation. If the user was already on the list of viewers, this method promotes the user out of the list of viewers.

Presentation — This Presentation, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Adds the given user to the list of editors for the Presentation. If the user was already on the list of viewers, this method promotes the user out of the list of viewers.

Presentation — This Presentation, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Adds the given array of users to the list of editors for the Presentation. If any of the users were already on the list of viewers, this method promotes them out of the list of viewers.

Presentation — This Presentation, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Adds the given user to the list of viewers for the Presentation. If the user was already on the list of editors, this method has no effect.

Presentation — This Presentation, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Adds the given user to the list of viewers for the Presentation. If the user was already on the list of editors, this method has no effect.

Presentation — This Presentation, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Adds the given array of users to the list of viewers for the Presentation. If any of the users were already on the list of editors, this method has no effect for them.

Presentation — This Presentation, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Appends a slide to the end of the presentation using the PredefinedLayout.BLANK predefined layout based on the current master. The current master is one of the following:

Slide — The new slide that is appended.

Scripts that use this method require authorization with one or more of the following scopes:

Appends a slide to the end of the presentation using the specified layout based on the current master. The current master is one of the following:

Slide — The new slide that is appended.

Scripts that use this method require authorization with one or more of the following scopes:

Appends a slide to the end of the presentation using the specified predefined layout based on the current master. The current master is one of the following:

Slide — The new slide that is appended.

Scripts that use this method require authorization with one or more of the following scopes:

Appends a copy of the provided Slide to the end of the presentation.

If the slide being copied is from a different presentation, the parent master and layout pages are copied as well if they do not already exist in this presentation.

Slide — The new slide that is appended.

Scripts that use this method require authorization with one or more of the following scopes:

Appends a copy of the provided Slide from the source presentation to the end of the current presentation, and sets the slide link as specified by the SlideLinkingMode.

If the slide being copied is from a different presentation, the parent master and layout pages are copied as well if they do not already exist in the current presentation.

If the link mode is SlideLinkingMode.LINKED, the appended slide can be updated to match the provided source slide when Slide.refreshSlide() is called. Other collaborators can see the link to the source slide. SlideLinkingMode.LINKED cannot be used with source slides from the current presentation.

Slide — The new slide.

Scripts that use this method require authorization with one or more of the following scopes:

Gets the list of editors for this Presentation.

User[] — An array of users with edit permission.

Scripts that use this method require authorization with one or more of the following scopes:

Gets the presentation's unique identifier. The presentation ID is used with SlidesApp.openById() to open a specific presentation instance.

String — The ID of this presentation.

Scripts that use this method require authorization with one or more of the following scopes:

Gets the layouts in the presentation.

Layout[] — The list of layouts in this presentation.

Scripts that use this method require authorization with one or more of the following scopes:

Gets the masters in the presentation.

Master[] — The list of masters in this presentation.

Scripts that use this method require authorization with one or more of the following scopes:

Gets the name or title of the presentation.

String — The title of this presentation.

Scripts that use this method require authorization with one or more of the following scopes:

Gets the notes master of the presentation.

NotesMaster — The notes master of the presentation.

Scripts that use this method require authorization with one or more of the following scopes:

Gets the page height of the notes master and notes pages in the presentation in points. They all have the same page height.

Number — The notes page height in points.

Scripts that use this method require authorization with one or more of the following scopes:

Gets the page width of the notes master and notes pages in the presentation in points. They all have the same page width.

Number — The notes page width in points.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the PageElement with the given ID, or null if none exists.

PageElement — The page element with the given ID.

Scripts that use this method require authorization with one or more of the following scopes:

Gets the page height of the slides, layouts, and masters in the presentation in points. They all have the same page height.

Number — The page height in points.

Scripts that use this method require authorization with one or more of the following scopes:

Gets the page width of the slides, layouts, and masters in the presentation in points. They all have the same page width.

Number — The page width in points.

Scripts that use this method require authorization with one or more of the following scopes:

Gets the user’s selection in the active presentation. A script can only access the selection of the user who is running the script, and only if the script is bound to the presentation.

Note that the selection returned is the current effective selection. As the script performs various changes to the presentation, the selection is transformed to take them into account. For example if two shapes A and B are selected, and then the script removes shape B, the returned selection object is implicitly updated such that only shape A is selected.

Selection — A representation of the user's selection, or null if the script is not bound to the presentation or if there is no valid user selection.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the Slide with the given ID, or null if none exists.

Slide — The slide with the given ID.

Scripts that use this method require authorization with one or more of the following scopes:

Gets the slides in the presentation.

Slide[] — The list of slides in this presentation.

Scripts that use this method require authorization with one or more of the following scopes:

Retrieves the URL to access this presentation.

String — The URL to access the current presentation.

Scripts that use this method require authorization with one or more of the following scopes:

Gets the list of viewers and commenters for this Presentation.

User[] — An array of users with view or comment permission.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts a slide at the specified index in the presentation using the PredefinedLayout.BLANK predefined layout based on the current master. The current master is one of the following:

Slide — The new slide that is inserted.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts a slide at the specified index in the presentation using the specified layout based on the current master. The current master is one of the following:

Slide — The new slide that is inserted.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts a slide at the specified index in the presentation using the specified predefined layout based on the current master. The current master is one of the following:

Slide — The new slide that is inserted.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts a copy of the provided Slide at the specified index in the presentation.

If the slide being copied is from a different presentation, the parent master and layout pages are copied as well if they do not already exist in this presentation.

Slide — The new slide that is inserted.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts a copy of the provided Slide from the source presentation into the specified index in the current presentation, and sets the slide link as specified by the SlideLinkingMode.

If the slide being copied is from a different presentation, the parent master and layout pages are copied as well if they do not already exist in the current presentation.

If the link mode is SlideLinkingMode.LINKED, the inserted slide can be updated to match the provided source slide when Slide.refreshSlide() is called. Other collaborators can see the link to the source slide. SlideLinkingMode.LINKED cannot be used with source slides from the current presentation.

Slide — The new slide.

Scripts that use this method require authorization with one or more of the following scopes:

Removes the given user from the list of editors for the Presentation. This method doesn't block users from accessing the Presentation if they belong to a class of users who have general access—for example, if the Presentation is shared with the user's entire domain, or if the Presentation is in a shared drive that the user can access.

For Drive files, this also removes the user from the list of viewers.

Presentation — This Presentation, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Removes the given user from the list of editors for the Presentation. This method doesn't block users from accessing the Presentation if they belong to a class of users who have general access—for example, if the Presentation is shared with the user's entire domain, or if the Presentation is in a shared drive that the user can access.

For Drive files, this also removes the user from the list of viewers.

Presentation — This Presentation, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Removes the given user from the list of viewers and commenters for the Presentation. This method has no effect if the user is an editor, not a viewer or commenter. This method also doesn't block users from accessing the Presentation if they belong to a class of users who have general access—for example, if the Presentation is shared with the user's entire domain, or if the Presentation is in a shared drive that the user can access.

For Drive files, this also removes the user from the list of editors.

Presentation — This Presentation for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Removes the given user from the list of viewers and commenters for the Presentation. This method has no effect if the user is an editor, not a viewer. This method also doesn't block users from accessing the Presentation if they belong to a class of users who have general access—for example, if the Presentation is shared with the user's entire domain, or if the Presentation is in a shared drive that the user can access.

For Drive files, this also removes the user from the list of editors.

Presentation — This Presentation for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Replaces all instances of text matching find text with replace text. The search is case insensitive.

Integer — the number of occurrences changed

Scripts that use this method require authorization with one or more of the following scopes:

Replaces all instances of text matching find text with replace text.

Integer — the number of occurrences changed

Scripts that use this method require authorization with one or more of the following scopes:

Saves the current Presentation. Causes pending updates to be flushed and applied.

The saveAndClose() method is automatically invoked at the end of script execution for each open Presentation, even if the script execution terminated with an error.

A closed Presentation cannot be edited. Use one of the open methods on SlidesApp to reopen a given presentation for editing.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the name or title of the presentation.

Scripts that use this method require authorization with one or more of the following scopes:

---

## Class RangeList Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/spreadsheet/range-list

**Contents:**
- Class RangeList Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
  - Methods
- Detailed documentation
  - activate()
    - Return
    - Authorization
  - breakApart()
    - Return
    - Authorization

RangeList is a collection of one or more Range instances in the same sheet, useful for applying operations on collections of non-adjacent ranges or cells.

RangeList provides methods to modify the appearance and content of the ranges it contains, such as setting background color, font styles, borders, and number formats.

You can use a RangeList to manage checkboxes, including inserting, checking, unchecking, and removing them from the specified ranges.

RangeList methods allow for clearing various aspects of the ranges, such as content, format, data validations, and notes, with options for selective clearing.

Key methods like activate(), breakApart(), and trimWhitespace() provide functionalities for selecting ranges, unmerging cells, and cleaning up cell content within the RangeList.

A collection of one or more Range instances in the same sheet. You can use this class to apply operations on collections of non-adjacent ranges or cells.

Selects the list of Range instances. The last range in the list is set as the active range.

Note: This provides a way to multi-select a number of ranges.

RangeList — The list of active ranges, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Break all horizontally- or vertically-merged cells contained within the range list into individual cells again.

Calling this function on a range list is equivalent to selecting a set of ranges and selecting the Format > Merge > Unmerge Sheets menu item.

RangeList — This range list, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Changes the state of the checkboxes in the range to “checked”. Ignores the cells in the range which currently do not contain either the checked or unchecked value configured.

RangeList — This range list, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Clears the range of contents, formats, and data validation rules for each Range in the range list.

RangeList — This range list, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Clears the range of contents, format, data validation rules, and comments, as specified with the given options. By default all data is cleared.

RangeList — This range list, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Clears the content of each Range in the range list, leaving the formatting intact.

RangeList — This range list, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Clears the data validation rules for each Range in the range list.

RangeList — This range list, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Clears text formatting for each Range in the range list.

This clears text formatting for each range, but does not reset any number formatting rules.

RangeList — This range list, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Clears the note for each Range in the range list.

RangeList — This range list, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Returns a list of one or more Range instances in the same sheet.

Range[] — The list of ranges.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts checkboxes into each cell in the range, configured with true for checked and false for unchecked. Sets the value of all cells in the range to false.

RangeList — This range list, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts checkboxes into each cell in the range, configured with a custom value for checked and the empty string for unchecked. Sets the value of each cell in the range to the empty string.

RangeList — This range list, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts checkboxes into each cell in the range, configured with custom values for the checked and unchecked states. Sets the value of each cell in the range to the custom unchecked value.

RangeList — This range list, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Removes all checkboxes from the range. Clears the data validation of each cell, and additionally clears its value if the cell contains either the checked or unchecked value.

RangeList — This range list, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the background color for each Range in the range list. Color is represented in in CSS notation; for example, '#ffffff' or 'white'.

RangeList — This range list, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the background to the given RGB color. This is a convenience wrapper around a setBackground(color) call.

RangeList — This range list, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the border property for each Range in the range list. The valid values are true (on), false (off) and null (no change).

RangeList — This range list, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the border property with color and/or style for each Range in the range list. Valid values are true (on), false (off) and null (no change). Color is represented in in CSS notation; for example, '#ffffff' or 'white'.

RangeList — This range list, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the font color for each Range in the range list. Color is represented in CSS notation; for example, '#ffffff' or 'white'.

RangeList — This range list, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the font family for each Range in the range list. The font family is described by a string identifier such as Arial or Roboto.

RangeList — This range list, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the font line style for each Range in the range list. The line styles options are 'underline', 'line-through', or 'none'.

RangeList — This range list, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the font size (in points) for each Range in the range list.

RangeList — This range list, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Set the font style for each Range in the range list. The font style options are 'italic' or 'normal'.

RangeList — This range list, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Set the font weight for each Range in the range list. The font weight options are 'normal' or 'bold'.

RangeList — This range list, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Updates the formula for each Range in the range list. The given formula must be in A1 notation.

RangeList — This range list, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Updates the formula for each Range in the range list. The given formula must be in R1C1 notation.

RangeList — This range list, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Set the horizontal alignment for each Range in the range list. The alignment options are 'left', 'center', or 'right'.

RangeList — This range list, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the note text for each Range in the range list.

RangeList — This range list, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the number or date format for each Range in the range list.

The accepted formatting patterns are described in the Sheets API date and number formatting guide.

RangeList — This range list, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets whether or not each Range in the range list should show hyperlinks.

RangeList — This range list, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the text direction for the cells in each Range in the range list. If a specified direction is null, the direction is inferred and then set.

RangeList — This range list, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the text rotation settings for the cells in each Range in the range list. The input corresponds to the angle between the standard text orientation and the desired orientation. An input of zero indicates that the text is set to the standard orientation.

For left to right text direction, positive angles are in the counterclockwise direction, whereas for right to left they are in the clockwise direction.

RangeList — This range list, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the value for each Range in the range list. The value can be numeric, string, boolean or date. If it begins with '=' it is interpreted as a formula.

RangeList — This range list, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Set the vertical alignment for each Range in the range list. The alignment options are 'top', 'middle' or 'bottom'.

RangeList — This range list, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets whether or not to stack the text for the cells for each Range in the range list. If the text is stacked vertically, the degree text rotation setting is ignored.

RangeList — This range list, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Set text wrapping for each Range in the range list. Cells with wrap enabled resize to display their full content. Cells with wrap disabled display as much as possible in the cell without resizing or running to multiple lines.

RangeList — This range list, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the text wrapping strategy for each Range in the range list.

RangeList — This range list, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Trims the whitespace (such as spaces, tabs, or new lines) in every cell in this range list. Removes all whitespace from the start and end of each cell's text, and reduces any subsequence of remaining whitespace characters to a single space.

Note: If the resulting trimmed text starts with a '+' or '=' character, the text remains as a string value and isn't interpreted as a formula.

RangeList — This range list, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Changes the state of the checkboxes in the range to “unchecked”. Ignores the cells in the range which currently do not contain either the checked or unchecked value configured.

RangeList — This range list, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

---

## Class Range Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/spreadsheet/range

**Contents:**
- Class Range Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
  - Methods
  - Deprecated methods
- Detailed documentation
  - activate()
    - Return
  - activateAsCurrentCell()
    - Return
    - Authorization

The Range object in spreadsheets enables access and modification of single cells or groups of adjacent cells.

Methods are available for activating and selecting ranges, retrieving metadata and properties, and manipulating data and values.

The Range object also provides methods for formatting cells, working with formulas, managing data validation, adding notes and links, and interacting with tables, pivot tables, and charts.

Functionality exists for navigating and modifying cells within a range, managing cell groups, applying filters, creating sparklines, setting conditional formatting, handling hyperlinks, and finding/replacing text.

Additional methods cover protecting ranges, checking hidden rows/columns, setting row heights and column widths, and accessing various representations of cell values.

Access and modify spreadsheet ranges. A range can be a single cell in a sheet or a group of adjacent cells in a sheet.

Sets the specified range as the active range, with the top left cell in the range as the current cell.

Range — This range, for chaining.

Sets the specified cell as the current cell.

If the specified cell is present in an existing range, then that range becomes the active range with the cell as the current cell.

If the specified cell is not present in any existing range, then the existing selection is removed and the cell becomes the current cell and the active range.

Note: The specified Range must consist of one cell, otherwise it throws an exception.

Range — This range, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Adds developer metadata with the specified key to the range.

Range — This range, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Adds developer metadata with the specified key and visibility to the range.

Range — This range, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Adds developer metadata with the specified key and value to the range.

Range — This range, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Adds developer metadata with the specified key, value, and visibility to the range.

Range — This range, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Applies a default column banding theme to the range. By default, the banding has header and no footer color.

Banding — The new banding.

Scripts that use this method require authorization with one or more of the following scopes:

Applies a specified column banding theme to the range. By default, the banding has header and no footer color.

Banding — The new banding.

Scripts that use this method require authorization with one or more of the following scopes:

Applies a specified column banding theme to the range with specified header and footer settings.

Banding — The new banding.

Scripts that use this method require authorization with one or more of the following scopes:

Applies a default row banding theme to the range. By default, the banding has header and no footer color.

Banding — The banding.

Scripts that use this method require authorization with one or more of the following scopes:

Applies a specified row banding theme to the range. By default, the banding has header and no footer color.

Banding — The new banding.

Scripts that use this method require authorization with one or more of the following scopes:

Applies a specified row banding theme to the range with specified header and footer settings.

Banding — The new banding.

Scripts that use this method require authorization with one or more of the following scopes:

Fills the destinationRange with data based on the data in this range. The new values are also determined by the specified series type. The destination range must contain this range and extend it in only one direction. For example, the following fills A1:A20 with a series of increasing numbers based on the current values in A1:A4:

Scripts that use this method require authorization with one or more of the following scopes:

Calculates a range to fill with new data based on neighboring cells and automatically fills that range with new values based on the data contained in this range. These new values are also determined by the specified series type.

The calculated destination range considers the surrounding data to determine where the new values should be inserted: if there is data to the immediate left or right of a column that is being auto-filled, new values only extend as far as this adjacent data.

For example, if A1:A20 is filled with a series of increasing numbers and this method is called on the range B1:B4 which contains a series of dates, new values are only inserted into B5:B20. In this way, these new values "stick" to the cells that contain values in column A.

Scripts that use this method require authorization with one or more of the following scopes:

Break any multi-column cells in the range into individual cells again.

Calling this function on a range is equivalent to selecting a range and clicking Format > Merge cells > Unmerge.

Range — This range, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Determines whether the user has permission to edit every cell in the range. The spreadsheet owner is always able to edit protected ranges and sheets.

Boolean — true if the user has permission to edit every cell in the range; false otherwise.

Scripts that use this method require authorization with one or more of the following scopes:

Changes the state of the checkboxes in the range to “checked”. Ignores the cells in the range which currently do not contain either the checked or unchecked value configured.

Range — This range, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Clears the range of contents and formats.

Range — This range, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Clears the range of contents, format, data validation rules, and/or comments, as specified with the given advanced options. By default all data is cleared.

Range — This range, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Clears the content of the range, leaving the formatting intact.

Range — This range, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Clears the data validation rules for the range.

Range — This range, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Clears formatting for this range.

This clears text formatting for the cell or cells in the range, but does not reset any number formatting rules.

Range — This range, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Clears the note in the given cell or cells.

Range — This range, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Collapses all groups that are wholly contained within the range. If no group is fully within the range, the deepest expanded group that is partially within the range is collapsed.

Range — This range, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Copy the formatting of the range to the given location. If the destination is larger or smaller than the source range then the source is repeated or truncated accordingly. Note that this method copies the formatting only.

For a detailed description of the gridId parameter, see getGridId().

Scripts that use this method require authorization with one or more of the following scopes:

Copy the formatting of the range to the given location. If the destination is larger or smaller than the source range then the source is repeated or truncated accordingly. Note that this method copies the formatting only.

Scripts that use this method require authorization with one or more of the following scopes:

Copies the data from a range of cells to another range of cells. Both the values and formatting are copied.

Scripts that use this method require authorization with one or more of the following scopes:

Copies the data from a range of cells to another range of cells.

Scripts that use this method require authorization with one or more of the following scopes:

Copies the data from a range of cells to another range of cells. By default both the values and formatting are copied, but this can be overridden using advanced arguments.

Scripts that use this method require authorization with one or more of the following scopes:

Copy the content of the range to the given location. If the destination is larger or smaller than the source range then the source is repeated or truncated accordingly.

For a detailed description of the gridId parameter, see getGridId().

Scripts that use this method require authorization with one or more of the following scopes:

Copy the content of the range to the given location. If the destination is larger or smaller than the source range then the source is repeated or truncated accordingly.

Scripts that use this method require authorization with one or more of the following scopes:

Creates an empty data source pivot table from the data source, anchored at the first cell in this range.

This example shows how to create and configure a new data source pivot table.

DataSourcePivotTable — The newly created data source pivot table.

Scripts that use this method require authorization with one or more of the following scopes:

Creates an empty data source table from the data source, anchored at the first cell in this range.

This example shows how to create and configure a new data source table.

DataSourceTable — The newly created data source table.

Scripts that use this method require authorization with one or more of the following scopes:

Returns a DeveloperMetadataFinderApi for finding developer metadata within the scope of this range. Metadata is within the scope of the range only if it is wholly contained within that range. For example, metadata associated with the row ‘3:3’ is not in the scope of a range ‘A1:D5’ but is within the scope of a range ‘1:5’.

DeveloperMetadataFinder — A developer metadata finder to search for metadata in the scope of this range.

Creates a filter and applies it to the specified range on the sheet. You can't create more than one filter on a sheet. To access and modify your filter after you create it, use getFilter() or Sheet.getFilter().

Filter — The new filter.

Scripts that use this method require authorization with one or more of the following scopes:

Creates an empty pivot table from the specified sourceData anchored at the first cell in this range.

PivotTable — The newly created PivotTable.

Scripts that use this method require authorization with one or more of the following scopes:

Creates a text finder for the range, which can find and replace text in this range.

TextFinder — The TextFinder for the range

Deletes this range of cells. Existing data in the sheet along the provided dimension is shifted towards the deleted range.

Scripts that use this method require authorization with one or more of the following scopes:

Expands the collapsed groups whose range or control toggle intersects with this range. The control toggle location is the index at which the control toggle is shown, directly before or after the group depending on settings. If there is more than one group at the same location, the shallowest group is expanded.

Range — This range, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Returns a string description of the range, in A1 notation.

String — The string description of the range in A1 notation.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the background color of the top-left cell in the range (for example, '#ffffff').

String — The color code of the background.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the background color of the top-left cell in the range.

Color — The background color of the top-left cell in the range.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the background colors of the cells in the range.

Color[][] — A two-dimensional array of background colors.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the background colors of the cells in the range (for example, '#ffffff').

String[][] — A two-dimensional array of color codes of the backgrounds.

Scripts that use this method require authorization with one or more of the following scopes:

Returns all the bandings that are applied to any cells in this range.

Banding[] — All the bandings that are applied to any cells in this range.

Scripts that use this method require authorization with one or more of the following scopes:

Returns a given cell within a range.

Range — A range containing a single cell at the specified coordinates.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the starting column position for this range.

Integer — The range's starting column position in the spreadsheet.

Scripts that use this method require authorization with one or more of the following scopes:

Returns a copy of the range expanded in the four cardinal Directions to cover all adjacent cells with data in them. If the range is surrounded by empty cells not including those along the diagonals, the range itself is returned. This is similar to selecting the range and typing Ctrl+A in the editor.

Range — The range's data region or a range for the entire spreadsheet.

Scripts that use this method require authorization with one or more of the following scopes:

Returns a copy of the range expanded Direction.UP and Direction.DOWN if the specified dimension is Dimension.ROWS, or Direction.NEXT and Direction.PREVIOUS if the dimension is Dimension.COLUMNS. The expansion of the range is based on detecting data next to the range that is organized like a table. The expanded range covers all adjacent cells with data in them along the specified dimension including the table boundaries. If the original range is surrounded by empty cells along the specified dimension, the range itself is returned. This method is similar to selecting the range and typing Ctrl+Space for columns or Shift+Space for rows in the editor.

Range — The range's data region or a range covering each column or each row spanned by the original range.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the DataSourceFormula for the first cell in the range, or null if the cell doesn't contain a data source formula.

DataSourceFormula — The DataSourceFormula for the cell.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the DataSourceFormulas for the cells in the range.

DataSourceFormula[] — An array of DataSourceFormulas.

Scripts that use this method require authorization with one or more of the following scopes:

Gets all the data source pivot tables intersecting with the range.

DataSourcePivotTable[] — A list of data source pivot tables.

Scripts that use this method require authorization with one or more of the following scopes:

Gets all the data source tables intersecting with the range.

DataSourceTable[] — A list of data source tables.

Scripts that use this method require authorization with one or more of the following scopes:

Returns a URL for the data in this range, which can be used to create charts and queries.

String — A URL for this range as a data source that can be passed to other APIs such as charts.

Scripts that use this method require authorization with one or more of the following scopes:

Return the data inside this object as a DataTable.

DataTable — the data as a datatable.

Return the data inside this range as a DataTable.

DataTable — The data as a datatable.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the data validation rule for the top-left cell in the range. If data validation has not been set on the cell, this method returns null.

DataValidation — The data validation rule for the top-left cell in the range.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the data validation rules for all cells in the range. If data validation has not been set on a given cell, this method returns null for that cell's position in the array.

DataValidation[][] — A two-dimensional array of data validation rules associated with the cells in the range.

Scripts that use this method require authorization with one or more of the following scopes:

Gets the developer metadata associated with this range.

DeveloperMetadata[] — The developer metadata associated with this range.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the displayed value of the top-left cell in the range. The value is a String. The displayed value takes into account date, time and currency formatting formatting, including formats applied automatically by the spreadsheet's locale setting. Empty cells return an empty string.

String — The displayed value in this cell.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the rectangular grid of values for this range.

Returns a two-dimensional array of displayed values, indexed by row, then by column. The values are String objects. The displayed value takes into account date, time and currency formatting, including formats applied automatically by the spreadsheet's locale setting. Empty cells are represented by an empty string in the array. Remember that while a range index starts at 1, 1, the JavaScript array is indexed from [0][0].

String[][] — A two-dimensional array of values.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the filter on the sheet this range belongs to, or null if there is no filter on the sheet.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the font color of the cell in the top-left corner of the range.

Color — The font color of the top-left cell in the range.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the font colors of the cells in the range.

Color[][] — A two-dimensional array of font colors associated with cells in the range.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the font families of the cells in the range.

String[][] — A two-dimensional array of font families associated with cells in the range.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the font family of the cell in the top-left corner of the range.

String — The font family of the cell.

Scripts that use this method require authorization with one or more of the following scopes:

Gets the line style of the cell in the top-left corner of the range ('underline', 'line-through', or 'none').

String — The font line.

Scripts that use this method require authorization with one or more of the following scopes:

Gets the line style of the cells in the range ('underline', 'line-through', or 'none').

String[][] — A two-dimensional array of font lines associated with cells in the range.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the font size in point size of the cell in the top-left corner of the range.

Integer — The font size in point size.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the font sizes of the cells in the range.

Integer[][] — A two-dimensional array of font sizes of text associated with cells in the range.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the font style ('italic' or 'normal') of the cell in the top-left corner of the range.

String — The font style of the text in the cell.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the font styles of the cells in the range.

String[][] — A two-dimensional array of font styles of text associated with cells in the range.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the font weight (normal/bold) of the cell in the top-left corner of the range.

String — The font weight of the text in the cell.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the font weights of the cells in the range.

String[][] — A two-dimensional array of font weights of text associated with cells in the range.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the formula (A1 notation) for the top-left cell of the range, or an empty string if the cell is empty or doesn't contain a formula.

String — The formula for the cell.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the formula (R1C1 notation) for a given cell, or null if none.

String — The formula in R1C1 notation.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the formulas (A1 notation) for the cells in the range. Entries in the 2D array are empty strings for cells with no formula.

String[][] — A two-dimensional array of formulas in string format.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the formulas (R1C1 notation) for the cells in the range. Entries in the 2D array are null for cells with no formula.

String[][] — A two-dimensional array of formulas in R1C1 notation.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the grid ID of the range's parent sheet. IDs are random non-negative int values.

Integer — The grid ID of the parent sheet.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the height of the range.

Integer — The height of the range.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the horizontal alignment of the text (left/center/right) of the cell in the top-left corner of the range.

String — The horizontal alignment of the text in the cell.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the horizontal alignments of the cells in the range.

String[][] — A two-dimensional array of horizontal alignments of text associated with cells in the range.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the end column position.

Integer — The range's ending column position in the spreadsheet.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the end row position.

Integer — The range's ending row position in the spreadsheet.

Scripts that use this method require authorization with one or more of the following scopes:

Returns an array of Range objects representing merged cells that either are fully within the current range, or contain at least one cell in the current range.

Range[] — An array of Range objects, representing merged cells overlapping the range.

Starting at the cell in the first column and row of the range, returns the next cell in the given direction that is the edge of a contiguous range of cells with data in them or the cell at the edge of the spreadsheet in that direction. This is equivalent to typing Ctrl+[arrow key] in the editor.

Range — The data region edge cell or the cell at the edge of the spreadsheet.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the note associated with the given range.

String — The note associated with the given cell.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the notes associated with the cells in the range.

String[][] — A two-dimensional array of notes associated with cells in the range.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the number of columns in this range.

Integer — The number of columns in this range.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the number of rows in this range.

Integer — The number of rows in this range.

Scripts that use this method require authorization with one or more of the following scopes:

Get the number or date formatting of the top-left cell of the given range. The returned format patterns are described in the Sheets API documentation.

String — The number format of the top-left cell of the range.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the number or date formats for the cells in the range. The returned format patterns are described in the Sheets API documentation.

String[][] — A two-dimensional array of number formats.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the Rich Text value for the top left cell of the range, or null if the cell value is not text.

RichTextValue — The Rich Text value of the top left cell in the range, or null if the cell value is not text.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the Rich Text values for the cells in the range.

RichTextValue[][] — A two-dimensional array of Rich Text values.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the row position for this range. Identical to getRowIndex().

Integer — The row position of the range.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the row position for this range. Identical to getRow().

Integer — The row position of the range.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the sheet this range belongs to.

Sheet — The sheet that this range belongs to.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the text direction for the top left cell of the range. Returns null if the cell text direction is determined with automatic detection.

TextDirection — The text direction of the top left cell in the range.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the text directions for the cells in the range. Entries in the 2D array are null for cells using automatic detection.

TextDirection[][] — A two-dimensional array of text directions.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the text rotation settings for the top left cell of the range.

TextRotation — The text rotation settings.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the text rotation settings for the cells in the range.

TextRotation[][] — A two-dimensional array of text rotations associated with cells in the range.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the text style for the top left cell of the range.

TextStyle — The text style of the top left cell in the range.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the text styles for the cells in the range.

TextStyle[][] — A two-dimensional array of text styles.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the value of the top-left cell in the range. The value may be of type Number, Boolean, Date, or String depending on the value of the cell. Empty cells return an empty string.

Object — The value in this cell.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the rectangular grid of values for this range.

Returns a two-dimensional array of values, indexed by row, then by column. The values may be of type Number, Boolean, Date, or String, depending on the value of the cell. Empty cells are represented by an empty string in the array. Remember that while a range index starts at 1, 1, the JavaScript array is indexed from [0][0].

Object[][] — A two-dimensional array of values.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the vertical alignment (top/middle/bottom) of the cell in the top-left corner of the range.

String — The vertical alignment of the text in the cell.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the vertical alignments of the cells in the range.

String[][] — A two-dimensional array of vertical alignments of text associated with cells in the range.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the width of the range in columns.

Integer — The number of columns in the range.

Scripts that use this method require authorization with one or more of the following scopes:

Returns whether the text in the cell wraps. To get more granular wrap strategy, use getWrapStrategy().

Boolean — Whether the text in this cell wraps or not.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the text wrapping strategies for the cells in the range.

WrapStrategy[][] — A two-dimensional array of text wrapping strategies.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the text wrapping strategy for the top left cell of the range.

WrapStrategy — The text wrapping strategy of the top left cell in the range.

Scripts that use this method require authorization with one or more of the following scopes:

Returns whether the text in the cells wrap. To get more granular wrap strategy, use getWrapStrategies().

Boolean[][] — A two-dimensional array of vertical alignments of text associated with cells in the range.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts empty cells into this range. The new cells retain any formatting present in the cells previously occupying this range. Existing data in the sheet along the provided dimension is shifted away from the inserted range.

Range — This range, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts checkboxes into each cell in the range, configured with true for checked and false for unchecked. Sets the value of all cells in the range to false.

Range — This range, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts checkboxes into each cell in the range, configured with a custom value for checked and the empty string for unchecked. Sets the value of each cell in the range to the empty string.

Range — This range, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts checkboxes into each cell in the range, configured with custom values for the checked and unchecked states. Sets the value of each cell in the range to the custom unchecked value.

Range — This range, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Returns true if the range is totally blank.

Boolean — true if the range is blank; false otherwise.

Scripts that use this method require authorization with one or more of the following scopes:

Returns whether all cells in the range have their checkbox state as 'checked'. Returns null if some cells are checked and the rest unchecked, or if some cells do not have checkbox data validation.

Boolean — true, if all cells in the range are checked, false if all cells in the range are unchecked, or null if any of the cells are unchecked or do not have checkbox data validation.

Scripts that use this method require authorization with one or more of the following scopes:

Determines whether the end of the range is bound to a particular column. For example, for the ranges A1:B10 or B:B, which are bound to columns at the end of the range, this method returns true; for the ranges 3:7 or A1:5, which are bound only to particular rows at the end of the range, this method returns false.

Boolean — true if the end of the range is bound to a particular column; false otherwise.

Scripts that use this method require authorization with one or more of the following scopes:

Determines whether the end of the range is bound to a particular row. For example, for the ranges A1:B10 or 3:7, which are bound to rows at the end of the range, this method returns true; for the ranges B:B or A1:C, which are bound only to particular columns at the end of the range, this method returns false.

Boolean — true if the end of the range is bound to a particular row; false otherwise.

Scripts that use this method require authorization with one or more of the following scopes:

Returns true if the cells in the current range overlap any merged cells.

Boolean — true if the range overlaps any merged cells, otherwise returns false.

Determines whether the start of the range is bound to a particular column. For example, for the ranges A1:B10 or B:B, which are bound to columns at the start of the range, this method returns true; for the range 3:7, which is bound only to a row at the start of the range, this method returns false.

Boolean — true if the start of the range is bound to a particular column; false otherwise.

Scripts that use this method require authorization with one or more of the following scopes:

Determines whether the start of the range is bound to a particular row. For example, for the ranges A1:B10 or 3:7, which are bound to rows at the start of the range, this method returns true; for the range B:B, which is bound only to a particular column at the start of the range, this method returns false.

Boolean — true if the start of the range is bound to a particular row; false otherwise.

Scripts that use this method require authorization with one or more of the following scopes:

Merges the cells in the range together into a single block.

Range — This range, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Merge the cells in the range across the columns of the range.

Range — This range, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Merges the cells in the range together.

Range — This range, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Cut and paste (both format and values) from this range to the target range.

Scripts that use this method require authorization with one or more of the following scopes:

Returns a new range that is offset from this range by the given number of rows and columns (which can be negative). The new range is the same size as the original range.

Range — This range, for chaining.

Returns a new range that is relative to the current range, whose upper left point is offset from the current range by the given rows and columns, and with the given height in cells.

Range — This range, for chaining.

Returns a new range that is relative to the current range, whose upper left point is offset from the current range by the given rows and columns, and with the given height and width in cells.

Range — This range, for chaining.

Creates an object that can protect the range from being edited except by users who have permission. Until the script actually changes the list of editors for the range (by calling Protection.removeEditor(emailAddress), Protection.removeEditor(user), Protection.removeEditors(emailAddresses), Protection.addEditor(emailAddress), Protection.addEditor(user), Protection.addEditors(emailAddresses), or setting a new value for Protection.setDomainEdit(editable)), the permissions mirror those of the spreadsheet itself, which effectively means that the range remains unprotected. If the range is already protected, this method creates a new protected range that overlaps the existing one. If a cell is protected by multiple protected ranges and any of them prevent a particular user from editing the cell, then that user is not permitted to edit the cell.

Protection — An object representing the protection settings.

Scripts that use this method require authorization with one or more of the following scopes:

Randomizes the order of the rows in the given range.

Range — This range, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Removes all checkboxes from the range. Clears the data validation of each cell, and additionally clears its value if the cell contains either the checked or unchecked value.

Range — This range, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Removes rows within this range that contain values that are duplicates of values in any previous row. Rows with identical values but different letter cases, formatting, or formulas are considered to be duplicates. This method also removes duplicates rows hidden from view (for example, due to a filter). Content outside of this range isn't removed.

Range — The resulting range after removing duplicates. The size of the range is reduced by a row for every row removed.

Scripts that use this method require authorization with one or more of the following scopes:

Removes rows within this range that contain values in the specified columns that are duplicates of values any previous row. Rows with identical values but different letter cases, formatting, or formulas are considered to be duplicates. This method also removes duplicates rows hidden from view (for example, due to a filter). Content outside of this range isn't removed.

Range — The resulting range after removing duplicates. The size of the range is reduced by a row for every row removed.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the background color of all cells in the range in CSS notation (such as '#ffffff' or 'white').

Range — This range, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the background color of all cells in the range.

Range — This range, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets a rectangular grid of background colors (must match dimensions of this range).

Range — This range, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the background to the given color using RGB values (integers between 0 and 255 inclusive).

Range — This range, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets a rectangular grid of background colors (must match dimensions of this range). The colors are in CSS notation (such as '#ffffff' or 'white').

Range — This range, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the border property. Valid values are true (on), false (off) and null (no change).

Range — This range, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the border property with color and/or style. Valid values are true (on), false (off) and null (no change). For color, use Color in CSS notation (such as '#ffffff' or 'white').

Range — This range, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets one data validation rule for all cells in the range.

Range — This range, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the data validation rules for all cells in the range. This method takes a two-dimensional array of data validations, indexed by row then by column. The array dimensions must correspond to the range dimensions.

Range — This range, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the font color in CSS notation (such as '#ffffff' or 'white').

Range — This range, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the font color of the given range.

Range — This range, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets a rectangular grid of font colors (must match dimensions of this range).

Range — This range, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets a rectangular grid of font colors (must match dimensions of this range). The colors are in CSS notation (such as '#ffffff' or 'white').

Range — This range, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets a rectangular grid of font families (must match dimensions of this range). Examples of font families are "Arial" or "Helvetica".

Range — This range, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the font family, such as "Arial" or "Helvetica".

Range — This range, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the font line style of the given range ('underline', 'line-through', or 'none').

Range — This range, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets a rectangular grid of line styles (must match dimensions of this range).

Range — This range, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the font size, with the size being the point size to use.

Range — This range, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets a rectangular grid of font sizes (must match dimensions of this range). The sizes are in points.

Range — This range, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Set the font style for the given range ('italic' or 'normal').

Range — This range, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets a rectangular grid of font styles (must match dimensions of this range).

Range — This range, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Set the font weight for the given range (normal/bold).

Range — This range, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets a rectangular grid of font weights (must match dimensions of this range). An example of a font weight is "bold".

Range — This range, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Updates the formula for this range. The given formula must be in A1 notation.

Range — This range, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Updates the formula for this range. The given formula must be in R1C1 notation.

Range — This range, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets a rectangular grid of formulas (must match dimensions of this range). The given formulas must be in A1 notation. This method takes a two-dimensional array of formulas, indexed by row, then by column. The array dimensions must correspond to the range dimensions.

Range — This range, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets a rectangular grid of formulas (must match dimensions of this range). The given formulas must be in R1C1 notation.

Range — This range, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Set the horizontal (left to right) alignment for the given range (left/center/right).

Range — This range, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets a rectangular grid of horizontal alignments. see setHorizontalAlignment(alignment)

Range — This range, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the note to the given value.

Range — This range, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets a rectangular grid of notes (must match dimensions of this range).

Range — This range, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the number or date format to the given formatting string. The accepted format patterns are described in the Sheets API documentation.

Range — This range, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets a rectangular grid of number or date formats (must match dimensions of this range). The values are format pattern strings as described in the Sheets API documentation.

Range — This range, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the Rich Text value for the cells in the range.

Range — This range, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets a rectangular grid of Rich Text values.

Range — This range, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets whether or not the range should show hyperlinks.

Range — This range, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the text direction for the cells in the range. If a specified direction is null, the direction is inferred and then set.

Range — This range, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets a rectangular grid of text directions. If a specified direction is null, the direction is inferred and then set.

Range — This range, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the text rotation settings for the cells in the range. The input corresponds to the angle between the standard text orientation and the desired orientation. An input of zero indicates that the text is set to the standard orientation.

For left to right text direction, positive angles are in the counterclockwise direction, whereas for right to left they are in the clockwise direction.

Range — This range, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the text rotation settings for the cells in the range.

Range — This range, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets a rectangular grid of text rotations.

Range — This range, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the text style for the cells in the range.

Range — This range, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets a rectangular grid of text styles.

Range — This range, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the value of the range. The value can be numeric, string, boolean or date. If it begins with '=' it is interpreted as a formula.

Range — This range, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets a rectangular grid of values (must match dimensions of this range). If a value begins with =, it's interpreted as a formula.

Range — This range, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Set the vertical (top to bottom) alignment for the given range (top/middle/bottom).

Range — This range, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets a rectangular grid of vertical alignments (must match dimensions of this range).

Range — This range, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets whether or not to stack the text for the cells in the range. If the text is stacked vertically, the degree text rotation setting is ignored.

Range — This range, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Set the cell wrap of the given range.

Cells with wrap enabled (the default) resize to display their full content. Cells with wrap disabled display as much as possible in the cell without resizing or running to multiple lines.

Range — This range, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets a rectangular grid of wrap strategies.

Range — This range, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the text wrapping strategy for the cells in the range.

Range — This range, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets a rectangular grid of word wrap policies (must match dimensions of this range). Cells with wrap enabled (the default) resize to display their full content. Cells with wrap disabled display as much as possible in the cell without resizing or running to multiple lines.

Range — This range, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Changes the column grouping depth of the range by the specified amount.

This has the effect of creating, modifying, or deleting groups that intersect with the range. For positive deltas, groups are created and/or modified; for negative deltas, groups are destroyed and/or modified.

This has no effect when decreasing the group depth below zero or above eight.

If the column group control position is BEFORE, this throws an error when attempting to shift the depth of the first row.

Range — This range, for chaining.

Error — when attempting to shift the depth of the first column when the control position is GroupControlTogglePosition.BEFORE

Scripts that use this method require authorization with one or more of the following scopes:

Changes the row grouping depth of the range by the specified amount.

This has the effect of creating, modifying, or deleting groups that intersect with the range. For positive deltas, groups are created and/or modified; for negative deltas, groups are destroyed and/or modified.

This has no effect when decreasing the group depth below zero or above eight.

If the row group control position is BEFORE, this throws an error when attempting to shift the depth of the first row.

Range — This range, for chaining.

Error — when attempting to shift the depth of the first row when the control position is GroupControlTogglePosition.BEFORE

Scripts that use this method require authorization with one or more of the following scopes:

Sorts the cells in the given range, by column and order specified.

Range — This range, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Splits a column of text into multiple columns based on an auto-detected delimiter.

Scripts that use this method require authorization with one or more of the following scopes:

Splits a column of text into multiple columns using the specified string as a custom delimiter.

Scripts that use this method require authorization with one or more of the following scopes:

Splits a column of text into multiple columns based on the specified delimiter.

Scripts that use this method require authorization with one or more of the following scopes:

Trims the whitespace (such as spaces, tabs, or new lines) in every cell in this range. Removes all whitespace from the start and end of each cell's text, and reduces any subsequence of remaining whitespace characters to a single space.

Note: If the resulting trimmed text starts with a '+' or '=' character, the text remains as a string value and isn't interpreted as a formula.

Range — This range, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Changes the state of the checkboxes in the range to “unchecked”. Ignores the cells in the range which currently do not contain either the checked or unchecked value configured.

Range — This range, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Deprecated. Replaced by getFontColorObject()

Returns the font color of the cell in the top-left corner of the range, in CSS notation (such as '#ffffff' or 'white').

String — The font color in CSS notation (such as '#ffffff' or 'white').

Scripts that use this method require authorization with one or more of the following scopes:

Deprecated. Replaced by getFontColorObjects()

Returns the font colors of the cells in the range in CSS notation (such as '#ffffff' or 'white').

String[][] — A two-dimensional array of font colors associated with cells in the range.

Scripts that use this method require authorization with one or more of the following scopes:

---

## Class RichLink Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/document/rich-link

**Contents:**
- Class RichLink Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
  - Methods
- Detailed documentation
  - copy()
    - Return
    - Authorization
  - getAttributes()
    - Return
    - Authorization

A RichLink element represents a link to a Google resource like a Drive file or YouTube video.

Key methods for RichLink include copying the element, getting and setting attributes, retrieving its MIME type, navigating sibling and parent elements, getting the title and URL, checking if it's at the document end, merging with a preceding sibling, and removing it from its parent.

Methods like getMimeType(), getTitle(), and getUrl() provide specific information about the linked resource.

Several methods allow for manipulating the element's position and relationship within the document structure, such as getNextSibling(), getParent(), getPreviousSibling(), and removeFromParent().

An element representing a link to a Google resource, such as a Drive file or a YouTube video.

Returns a detached, deep copy of the current element.

Any child elements present in the element are also copied. The new element doesn't have a parent.

RichLink — The new copy.

Scripts that use this method require authorization with one or more of the following scopes:

Retrieves the element's attributes.

The result is an object containing a property for each valid element attribute where each property name corresponds to an item in the DocumentApp.Attribute enumeration.

Object — The element's attributes.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the MIME type of the link, which is available when the item is a link to a Drive file and null otherwise.

For example, if the link points to a Google Docs file, this returns the string application/vnd.google-apps.document.

String — The MIME type of the link, if available.

Scripts that use this method require authorization with one or more of the following scopes:

Retrieves the element's next sibling element.

The next sibling has the same parent and follows the current element.

Element — The next sibling element.

Scripts that use this method require authorization with one or more of the following scopes:

Retrieves the element's parent element.

The parent element contains the current element.

ContainerElement — The parent element.

Scripts that use this method require authorization with one or more of the following scopes:

Retrieves the element's previous sibling element.

The previous sibling has the same parent and precedes the current element.

Element — The previous sibling element.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the link's displayed title. This title matches the title of the linked resource at the time of the insertion or last update of the link. For example, if this link points to a Google Docs document titled "Analysis," this returns Analysis.

String — The display title of the link.

Scripts that use this method require authorization with one or more of the following scopes:

Retrieves the element's ElementType.

Use getType() to determine the exact type of a given element.

ElementType — The element type.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the URL of the resource.

String — The URL of the resource.

Scripts that use this method require authorization with one or more of the following scopes:

Determines whether the element is at the end of the Document.

Boolean — Whether the element is at the end of the tab.

Scripts that use this method require authorization with one or more of the following scopes:

Merges the element with the preceding sibling of the same type.

Only elements of the same ElementType can be merged. Any child elements contained in the current element are moved to the preceding sibling element.

The current element is removed from the document.

RichLink — The merged element.

Scripts that use this method require authorization with one or more of the following scopes:

Removes the element from its parent.

RichLink — The removed element.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the element's attributes.

The specified attributes parameter must be an object where each property name is an item in the DocumentApp.Attribute enumeration and each property value is the new value to be applied.

RichLink — The current element.

Scripts that use this method require authorization with one or more of the following scopes:

---

## Class RichTextValueBuilder Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/spreadsheet/rich-text-value-builder

**Contents:**
- Class RichTextValueBuilder Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
  - Methods
- Detailed documentation
  - build()
    - Return
  - setLinkUrl(startOffset, endOffset, linkUrl)
    - Parameters
    - Return
  - setLinkUrl(linkUrl)

RichTextValueBuilder is used to create Rich Text values.

The builder includes methods to set text, apply text styles, and set link URLs.

Styles and link URLs can be applied to the entire value or specific substrings using offsets.

The build() method finalizes the creation of the RichTextValue.

A builder for Rich Text values.

Creates a Rich Text value from this builder.

RichTextValue — A Rich Text value created from this builder.

Sets the link URL for the given substring of this value, or clears it if linkUrl is null.

RichTextValueBuilder — This builder, for chaining.

Sets the link URL for the entire value, or clears it if linkUrl is null.

RichTextValueBuilder — This builder, for chaining.

Sets the text for this value and clears any existing text style. When creating a new Rich Text value, this should be called before setTextStyle(startOffset, endOffset, textStyle).

RichTextValueBuilder — This builder, for chaining.

Applies a text style to the given substring of this value. Offsets are 0 based and are relative to the cell's text value. Does nothing if textStyle is null.

RichTextValueBuilder — This builder, for chaining.

Applies a text style to the entire value. Previously set text styles are only affected if they are directly overwritten by values within textStyle. Does nothing if textStyle is null.

RichTextValueBuilder — This builder, for chaining.

---

## Class RichTextValue Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/spreadsheet/rich-text-value

**Contents:**
- Class RichTextValue Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
  - Methods
- Detailed documentation
  - copy()
    - Return
  - getEndIndex()
    - Return
  - getLinkUrl()
    - Return

RichTextValue represents cell text with substrings that can have different text styles.

A "run" is the longest unbroken substring with the same text style.

The RichTextValue class provides methods to access text content, styling, link URLs, and indices within a cell.

You can retrieve the text style or link URL for the entire value or a specific range using offset parameters.

The getRuns() method splits the Rich Text string into an array of runs based on consistent text styles.

A stylized text string used to represent cell text. Substrings of the text can have different text styles.

A run is the longest unbroken substring having the same text style. For example, the sentence, "This child is carrying apples" has 4 runs: ['This ', 'child ', 'is carrying ', 'apples'].

Returns a builder for a Rich Text value initialized with the values of this Rich Text value.

RichTextValueBuilder — A builder for a Rich Text value.

Gets the end index of this value in the cell.

Integer — The end index of this value in the cell.

Returns the link URL for this value.

String — The link URL for this value, or null if there is no link or if there are multiple different links.

Returns the link URL for the text from startOffset to endOffset. Offsets are 0 based and relative to the cell's text, with the start offset being inclusive and the end offset being exclusive.

String — The link URL for this value, or null if there is no link or if multiple different links are in the given range.

Returns the Rich Text string split into an array of runs, wherein each run is the longest possible substring having a consistent text style.

RichTextValue[] — An array of runs.

Gets the start index of this value in the cell.

Integer — The start index of this value in the cell.

Returns the text of this value.

String — The text of this value.

Returns the text style of this value.

TextStyle — The text style of this value.

Returns the text style of the text from startOffset to endOffset. Offsets are 0 based and relative to the cell's text, with the start offset being inclusive and the end offset being exclusive.

TextStyle — The text style of the given substring of this value.

---

## Class ScriptApp Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/script/script-app

**Contents:**
- Class ScriptApp Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
  - Properties
  - Methods
  - Deprecated methods
- Detailed documentation
  - deleteTrigger(trigger)
    - Parameters
    - Authorization
  - getAuthorizationInfo(authMode)

The ScriptApp class in Google Apps Script allows users to manage script publishing and triggers.

ScriptApp provides properties to identify authorization status, event types, and installation sources of scripts.

You can use ScriptApp methods to create, delete, and retrieve installable triggers associated with a script or specific documents, forms, or spreadsheets.

ScriptApp includes methods to get authorization information, access tokens, identity tokens, and the script project's unique ID.

The class also allows invalidating script authorization and controlling web app publishing.

Access and manipulate script publishing and triggers. This class allows users to create script triggers and control publishing the script as a service.

Removes the given trigger so it no longer runs.

Scripts that use this method require authorization with one or more of the following scopes:

Gets an object that checks if the user has granted authorization for all the script requirements. The object also provides an authorization URL for users to grant those permissions, in case any of the script requirements are not authorized.

Some script executions can start without a user's consent for all required scopes used by the script. The information in this object lets you control access to sections of code that require certain scopes and request authorization of those scopes for subsequent executions.

AuthorizationInfo — An object that can provide information about the user's authorization status.

Gets an object that checks if the user has granted authorization for the requested scopes. The object also provides an authorization URL for users to grant those permissions, in case any of the requested scopes are not authorized.

Some script executions can start without a user's consent for all required scopes used by the script. The information in this object lets you control access to sections of code that require certain scopes and request authorization of those scopes for subsequent executions. Scopes that are invalid or not required by the script lead to an error.

AuthorizationInfo — An object that provides information about the user's authorization status and an authorization URL in case some consents are missing.

Gets an OpenID Connect identity token for the effective user, if the openid scope has been granted. This scope is not included by default, and you must add it as an explicit scope in the manifest file to request it. Include the scopes https://www.googleapis.com/auth/userinfo.email or https://www.googleapis.com/auth/userinfo.profile to return additional user information in the token.

The returned ID token is an encoded JSON Web Token (JWT), and it must be decoded to extract information from it. The following examples shows how to decode the token and extract the effective user's Google profile ID.

String — The identity token if available; otherwise null.

Returns an enum value that indicates how the script came to be installed as an add-on for the current user (for example, whether the user installed it personally through the Chrome Web Store, or whether a domain administrator installed it for all users).

InstallationSource — The source of installation.

Gets the OAuth 2.0 access token for the effective user. If the script's OAuth scopes are sufficient to authorize another Google API that normally requires its own OAuth flow (like Google Picker), scripts can bypass the second authorization prompt by passing this token instead. The token expires after a time (a few minutes at minimum); scripts should handle authorization failures and call this method to obtain a fresh token when needed.

The token returned by this method only includes scopes that the script currently needs. Scopes that were previously authorized but are no longer used by the script are not included in the returned token. If additional OAuth scopes are needed beyond what the script itself requires, they can be specified in the script's manifest file.

You can use this method to call Google APIs that Apps Script doesn't directly support. Pass the returned token in the `Authorization` header of an HTTP request using UrlFetchApp.fetch(url, params).

String — A string representation of the OAuth 2.0 token.

Gets all installable triggers associated with the current project and current user.

Trigger[] — An array of the current user's triggers associated with this project.

Scripts that use this method require authorization with one or more of the following scopes:

Gets the script project's unique ID. This is the preferred method to get the unique identifier for the script project as opposed to getProjectKey(). This ID can be used in all places where project key was previously provided.

String — The script project's ID.

Gets an object used to control publishing the script as a web app.

Service — An object used to observe and control publishing the script as a web app.

Gets all installable triggers owned by this user in the given document, for this script or add-on only. This method cannot be used to see the triggers attached to other scripts.

Trigger[] — An array of triggers owned by this user in the given document.

Scripts that use this method require authorization with one or more of the following scopes:

Gets all installable triggers owned by this user in the given form, for this script or add-on only. This method cannot be used to see the triggers attached to other scripts.

Trigger[] — An array of triggers owned by this user in the given form.

Scripts that use this method require authorization with one or more of the following scopes:

Gets all installable triggers owned by this user in the given spreadsheet, for this script or add-on only. This method cannot be used to see the triggers attached to other scripts.

Trigger[] — An array of triggers owned by this user in the given spreadsheet.

Scripts that use this method require authorization with one or more of the following scopes:

Invalidates the authorization the effective user has to execute the current script. Used to invalidate any permissions for the current script. This is especially useful for functions tagged as one-shot authorization. Since one-shot authorization functions can only be called the first run after the script has acquired authorization, if you wish to perform an action afterwards, you must revoke any authorization the script had, so the user can see the authorization dialog again.

Error — when invalidation fails

Creates a builder for a state token that can be used in a callback API (like an OAuth flow).

In most OAuth2 flows, the state token is passed to the authorization endpoint directly (not as part of the callback URL), and the authorization endpoint then passes it as part of the callback URL.

StateTokenBuilder — An object used to continue the state-token-building process.

Begins the process of creating an installable trigger that, when fired, calls a given function.

Before creating a trigger, verify that the associated function has all the necessary OAuth permissions

TriggerBuilder — An object used to continue the trigger-building process.

Scripts that use this method require authorization with one or more of the following scopes:

Validates if the user has granted consent for all of the scopes requested by the script. Use this method if an execution flow relies on all of the scopes that a script requests. If any consents are missing, then this method ends the current execution and renders an authorization prompt to request the missing consents.

This method only works when users run the script from a surface that supports granular consent, for example, from within the Apps Script IDE. When the script is run with missing consents from an unsupported surface, such as a Google Workspace add-on, the script renders an authorization prompt at the start of the execution to request all the scopes.

Validates if the user has granted consent for the requested scopes. Use this method if an execution flow relies on one or more services. If any of the specified consents are missing, then this method ends the current execution and renders an authorization prompt to request the missing consents. Scopes that are invalid or not required by the script lead to an error.

This method only works when users run the script from a surface that supports granular consent, for example, from within the Apps Script IDE. When the script is run with missing consents from an unsupported surface, such as a Google Workspace add-on, the script renders an authorization prompt at the start of the execution to request all the scopes.

Deprecated. use getScriptId() instead.

Gets the project key of the current script. The project key is a unique identifier for scripts and used to compose the callback URL used in conjunction with newStateToken().

When called in a library, this returns the project key of the outer-most script being executed.

String — The project key of the current script.

Deprecated. This function is deprecated and should not be used in new scripts.

Gets all installable triggers associated with the current project and current user.

Trigger[] — An array of the current user's triggers associated with this project.

Scripts that use this method require authorization with one or more of the following scopes:

---

## Class SelectionInput Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/card-service/selection-input

**Contents:**
- Class SelectionInput Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
  - Methods
- Detailed documentation
  - addItem(text, value, selected)
    - Parameters
    - Return
  - addMultiSelectItem(text, value, selected, startIconUri, bottomText)
    - Parameters
    - Return

SelectionInput is an input field for choosing from predefined options.

It supports form submission validation for DROP_DOWN and MULTI_SELECT menu types.

It is available for Google Workspace add-ons and Google Chat apps.

Methods like addItem, addMultiSelectItem, setTitle, and setType are available to customize the SelectionInput.

An input field that allows choosing between a set of predefined options.

Supports form submission validation for SelectionInputType.DROP_DOWN and SelectionInputType.MULTI_SELECT menus only. When Action.setAllWidgetsAreRequired(allWidgetsAreRequired) is set to true or this widget is specified through Action.addRequiredWidget(requiredWidget), the submission action is blocked unless a value is selected.

Available for Google Workspace add-ons and Google Chat apps.

Adds a new item that can be selected.

SelectionInput — This object, for chaining.

Adds a new item that can be selected, for multi-select menus.

SelectionInput — This object, for chaining.

Sets external data source, such as a relational data base.

SelectionInput — This object, for chaining.

Sets the key that identifies this selection input in the event object that is generated when there is a UI interaction. Not visible to the user. Required, must be unique.

SelectionInput — This object, for chaining.

Sets the maximum number of items that a user can select.

SelectionInput — This object, for chaining.

Sets the number of text characters that a user inputs before the app queries autocomplete and displays suggested items on the card.

SelectionInput — This object, for chaining.

Sets an Action to be performed whenever the selection input changes.

SelectionInput — This object, for chaining.

Sets a data source from Google Workspace. Used to populate items in a multiselect menu.

SelectionInput — This object, for chaining.

Sets the title to be shown ahead of the input field.

SelectionInput — This object, for chaining.

Sets the type of this input. Defaults to CHECKBOX.

SelectionInput — This object, for chaining.

---

## Class SelectMultiple Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/data-studio/select-multiple

**Contents:**
- Class SelectMultiple Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
  - Methods
- Detailed documentation
  - addOption(optionBuilder)
    - Parameters
    - Return
  - setAllowOverride(allowOverride)
    - Parameters
    - Return

SelectMultiple contains information for the config and determines how the select multiple is displayed in Data Studio.

Key methods include adding options, setting override capabilities, help text, unique IDs, dynamic status, and display names.

The addOption method adds a new select option using an OptionBuilder.

The setAllowOverride method enables or disables overriding for the config entry.

The setId method sets the unique identifier for the configuration entry.

The setIsDynamic method sets the dynamic status, clearing subsequent entries if modified.

Contains select multiple information for the config. Its properties determine how the select multiple is displayed in Data Studio.

Adds a new select option.

SelectMultiple — This builder, for chaining.

Enables overriding for this config entry. If set to true, data source creators have the option to enable this for report editors.

SelectMultiple — This builder, for chaining.

Sets the help text for this configuration entry.

SelectMultiple — This builder, for chaining.

Sets the unique ID for this configuration entry.

SelectMultiple — This builder, for chaining.

Sets the dynamic status for this configuration entry.

If a dynamic configuration entry is modified, subsequent configuration entries are cleared.

SelectMultiple — This builder, for chaining.

Sets the display name for this configuration entry.

SelectMultiple — This builder, for chaining.

---

## Class SelectSingle Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/data-studio/select-single

**Contents:**
- Class SelectSingle Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
  - Methods
- Detailed documentation
  - addOption(optionBuilder)
    - Parameters
    - Return
  - setAllowOverride(allowOverride)
    - Parameters
    - Return

SelectSingle contains configuration information for how a select single is displayed in Data Studio.

You can add select options, enable overriding, set help text, ID, dynamic status, and display name for a SelectSingle config entry.

The provided code example demonstrates how to create a SelectSingle instance and add options to it.

Contains select single information for the config. Its properties determine how the select single is displayed in Data Studio.

Adds a new select option.

SelectSingle — This builder, for chaining.

Enables overriding for this config entry. If set to true, data source creators have the option to enable this for report editors.

SelectSingle — This builder, for chaining.

Sets the help text for this configuration entry.

SelectSingle — This builder, for chaining.

Sets the unique ID for this configuration entry.

SelectSingle — This builder, for chaining.

Sets the dynamic status for this configuration entry.

If a dynamic configuration entry is modified, subsequent configuration entries are cleared.

SelectSingle — This builder, for chaining.

Sets the display name for this configuration entry.

SelectSingle — This builder, for chaining.

---

## Class SetCredentialsResponse Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/data-studio/set-credentials-response

**Contents:**
- Class SetCredentialsResponse Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
  - Methods
- Detailed documentation
  - build()
    - Return
  - printJson()
    - Return
  - setIsValid(isValid)
    - Parameters

The SetCredentialsResponse is a builder used to create a response for the setCredentials() function in a script project.

The build() method validates the object and returns it in the format required by Data Studio.

The printJson() method prints the JSON representation of the object for debugging.

The setIsValid(isValid) method sets the validity status of the SetCredentialsResponse.

Builder to create a setCredentials() response for your script project.

Validates this object and returns it in the format needed by Data Studio.

Object — The validated SetCredentialsResponse object.

Prints the JSON representation of this object. This is for debugging only.

Sets the valid status of this SetCredentialsResponse. Set to true if the credentials provided in the request were valid, false, otherwise.

SetCredentialsResponse — This builder, for chaining.

---

## Class Sheet Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/spreadsheet/sheet

**Contents:**
- Class Sheet Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
  - Methods
  - Deprecated methods
- Detailed documentation
  - activate()
    - Return
  - addDeveloperMetadata(key)
    - Parameters
    - Return

The Sheet object in Google Apps Script provides extensive methods for accessing and modifying individual sheets within a spreadsheet.

You can perform common operations like activating, hiding/showing, and clearing sheet content and formatting.

The object allows for detailed manipulation of sheet structure, including inserting, deleting, and moving columns and rows.

It offers methods to get and set metadata, manage ranges and selections, control formatting and display options, work with groups, and interact with embedded objects like charts and images.

Many methods require specific authorization scopes to execute successfully.

Access and modify spreadsheet sheets. Common operations are renaming a sheet and accessing range objects from the sheet.

Activates this sheet. Does not alter the sheet itself, only the parent's notion of the active sheet.

Sheet — The newly active sheet.

Adds developer metadata with the specified key to the sheet.

Sheet — This sheet, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Adds developer metadata with the specified key and visibility to the sheet.

Sheet — This sheet, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Adds developer metadata with the specified key and value to the sheet.

Sheet — This sheet, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Adds developer metadata with the specified key, value, and visibility to the sheet.

Sheet — This sheet, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Appends a row to the bottom of the current data region in the sheet. If a cell's content begins with =, it's interpreted as a formula.

Sheet — The sheet, useful for method chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the sheet as a DataSourceSheet if the sheet is of type SheetType.DATASOURCE, or null otherwise.

DataSourceSheet — A data source sheet.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the width of the given column to fit its contents.

Sheet — The sheet, useful for method chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the width of all columns starting at the given column position to fit their contents.

Sheet — This sheet, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the height of all rows starting at the given row position to fit their contents.

Sheet — This sheet, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Clears the sheet of content and formatting information.

Sheet — The cleared sheet.

Scripts that use this method require authorization with one or more of the following scopes:

Clears the sheet of contents and/or format, as specified with the given advanced options.

Sheet — This sheet, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Removes all conditional format rules from the sheet. Equivalent to calling setConditionalFormatRules(rules) with an empty array as input.

Scripts that use this method require authorization with one or more of the following scopes:

Clears the sheet of contents, while preserving formatting information.

Sheet — This sheet, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Clears the sheet of formatting, while preserving contents.

Formatting refers to how data is formatted as allowed by choices under the "Format" menu (ex: bold, italics, conditional formatting) and not width or height of cells.

Sheet — This sheet, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Clears the sheet of all notes.

Sheet — This sheet, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Collapses all column groups on the sheet.

Sheet — This sheet, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Collapses all row groups on the sheet.

Sheet — This sheet, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Copies the sheet to a given spreadsheet, which can be the same spreadsheet as the source. The copied sheet is named "Copy of [original name]".

Sheet — The new sheet, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Returns a DeveloperMetadataFinder for finding developer metadata within the scope of this sheet. Metadata is in the scope of a particular sheet if it is either associated with the sheet itself, or associated with a row, column, or range on that sheet.

DeveloperMetadataFinder — A developer metadata finder to search for metadata in the scope of this sheet.

Creates a text finder for the sheet, which can find and replace text within the sheet.

TextFinder — The TextFinder for the sheet.

Deletes the column at the given column position.

Sheet — The sheet, useful for method chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Deletes a number of columns starting at the given column position.

Scripts that use this method require authorization with one or more of the following scopes:

Deletes the row at the given row position.

Sheet — The sheet, useful for method chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Deletes a number of rows starting at the given row position.

Scripts that use this method require authorization with one or more of the following scopes:

Expands all column groups on the sheet. This method requires at least one column group.

Sheet — This sheet, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Expands all row groups on the sheet. This method requires at least one row group.

Sheet — This sheet, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Expands all column groups up to the given depth, and collapses all others.

Sheet — This sheet, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Expands all row groups up to the given depth, and collapses all others.

Sheet — This sheet, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the active cell in this sheet.

Note: It's preferable to use getCurrentCell(), which returns the current highlighted cell.

Range — The current active cell.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the selected range in the active sheet, or null if there is no active range. If multiple ranges are selected this method returns only the last selected range.

The term "active range" refers to the range that a user has selected in the active sheet, but in a custom function it refers to the cell being actively recalculated.

Range — The active range.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the list of active ranges in the active sheet or null if there are no active ranges.

If there is a single range selected, this behaves as a getActiveRange() call.

RangeList — The list of active ranges.

Scripts that use this method require authorization with one or more of the following scopes:

Returns all the bandings in this sheet.

Banding[] — All the bandings in this sheet.

Scripts that use this method require authorization with one or more of the following scopes:

Returns an array of charts on this sheet.

EmbeddedChart[] — An array of charts.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the column group at the given index and group depth.

Group — The column group at the control index and depth, or throws an exception if the group doesn’t exist.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the GroupControlTogglePosition for all column groups on the sheet.

GroupControlTogglePosition — true if the column grouping control toggle is shown after the group on this sheet and false otherwise.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the group depth of the column at the given index.

The group depth indicates how many groups overlap with the column. This can range between zero and eight.

Integer — The group depth of the column at the given index.

Scripts that use this method require authorization with one or more of the following scopes:

Gets the width in pixels of the given column.

Integer — Column width in pixels.

Scripts that use this method require authorization with one or more of the following scopes:

Get all conditional format rules in this sheet.

ConditionalFormatRule[] — An array of all rules in the sheet.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the current cell in the active sheet or null if there is no current cell. The current cell is the cell that has focus in the Google Sheets UI, and is highlighted by a dark border. There is never more than one current cell. When a user selects one or more cell ranges, one of the cells in the selection is the current cell.

Range — The current cell.

Scripts that use this method require authorization with one or more of the following scopes:

Returns a Range corresponding to the dimensions in which data is present.

This is functionally equivalent to creating a Range bounded by A1 and (Sheet.getLastColumn(), Sheet.getLastRow()).

Range — A range consisting of all the data in the spreadsheet.

Scripts that use this method require authorization with one or more of the following scopes:

Gets all the data source formulas.

DataSourceFormula[] — A list of data source formulas.

Scripts that use this method require authorization with one or more of the following scopes:

Gets all the data source pivot tables.

DataSourcePivotTable[] — A list of data source pivot tables.

Scripts that use this method require authorization with one or more of the following scopes:

Gets all the data source tables.

DataSourceTable[] — A list of data source tables.

Scripts that use this method require authorization with one or more of the following scopes:

Get all developer metadata associated with this sheet.

DeveloperMetadata[] — The developer metadata associated with this sheet.

Scripts that use this method require authorization with one or more of the following scopes:

Returns an array of drawings on the sheet.

Drawing[] — The list of drawings on this sheet.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the filter in this sheet, or null if there is no filter.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the URL for the form that sends its responses to this sheet, or null if this sheet has no associated form. Throws an exception if the user does not have permission to edit the spreadsheet.

String — The URL for the form that places its responses in this sheet, or null if this sheet doesn't have an associated form.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the number of frozen columns.

Integer — The number of frozen columns.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the number of frozen rows.

Integer — The number of frozen rows.

Scripts that use this method require authorization with one or more of the following scopes:

Returns all over-the-grid images on the sheet.

OverGridImage[] — An array of over-the-grid images.

Scripts that use this method require authorization with one or more of the following scopes:

Gets the position of the sheet in its parent spreadsheet. Starts at 1.

Integer — The position of the sheet in its parent spreadsheet.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the position of the last column that has content.

Integer — The last column of the sheet that contains content.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the position of the last row that has content.

Integer — The last row of the sheet that contains content.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the current number of columns in the sheet, regardless of content.

Integer — The maximum width of the sheet.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the current number of rows in the sheet, regardless of content.

Integer — The maximum height of the sheet.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the name of the sheet.

String — The name of the sheet.

Scripts that use this method require authorization with one or more of the following scopes:

Gets all the named ranges in this sheet.

NamedRange[] — An array of all the named ranges in the sheet.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the Spreadsheet that contains this sheet.

Spreadsheet — The parent spreadsheet.

Scripts that use this method require authorization with one or more of the following scopes:

Returns all the pivot tables on this sheet.

PivotTable[] — The pivot tables on this sheet.

Scripts that use this method require authorization with one or more of the following scopes:

Gets an array of objects representing all protected ranges in the sheet, or a single-element array representing the protection on the sheet itself.

Protection[] — An array of objects representing all protected ranges in the sheet, or a single-element array representing the protection on the sheet itself.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the range with the top left cell at the given coordinates.

Range — A range containing only this cell.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the range with the top left cell at the given coordinates, and with the given number of rows.

Range — A range containing a single column of data with the number of rows specified.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the range with the top left cell at the given coordinates with the given number of rows and columns.

Range — A range corresponding to the area specified.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the range as specified in A1 notation or R1C1 notation.

Range — The range at the location designated.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the RangeList collection representing the ranges in the same sheet specified by a non-empty list of A1 notations or R1C1 notations.

RangeList — The range list at the location designated.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the row group at the given index and group depth.

Group — The row group at the control index and depth, or throws an exception if the group doesn’t exist.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the GroupControlTogglePosition for all row groups on the sheet.

GroupControlTogglePosition — true if the row grouping control toggle is shown after the group on this sheet and false otherwise.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the group depth of the row at the given index.

The group depth indicates how many groups overlap with the row. This can range between zero and eight.

Integer — The group depth of the row at the given index.

Scripts that use this method require authorization with one or more of the following scopes:

Gets the height in pixels of the given row.

Integer — Row height in pixels.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the current Selection in the spreadsheet.

Selection — The current selection.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the ID of the sheet represented by this object.

This is an ID for the sheet that is unique to the spreadsheet. The ID is a monotonically increasing integer assigned at sheet creation time that is independent of sheet position. This is useful in conjunction with methods such as Range.copyFormatToRange(gridId, column, columnEnd, row, rowEnd) that take a gridId parameter rather than a Sheet instance.

Integer — An ID for the sheet unique to the spreadsheet.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the sheet name.

String — The name of the sheet.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the rectangular grid of values for this range starting at the given coordinates. A -1 value given as the row or column position is equivalent to getting the very last row or column that has data in the sheet.

Object[][] — A two-dimensional array of values.

Scripts that use this method require authorization with one or more of the following scopes:

Returns an array of slicers on the sheet.

Slicer[] — The list of slicers on this sheet.

Scripts that use this method require authorization with one or more of the following scopes:

Gets the sheet tab color, or null if the sheet tab has no color.

Color — The sheet tab color, or null if the sheet tab has no color.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the type of the sheet.

The default type of sheet is SheetType.GRID. A sheet that contains a single embedded object such as an EmbeddedChart is an SheetType.OBJECT sheet.

SheetType — The type of the sheet.

Scripts that use this method require authorization with one or more of the following scopes:

Returns true if the sheet's gridlines are hidden; otherwise returns false. Gridlines are visible by default.

Boolean — true if gridlines are hidden; false otherwise.

Scripts that use this method require authorization with one or more of the following scopes:

Hides the column or columns in the given range.

Scripts that use this method require authorization with one or more of the following scopes:

Hides a single column at the given index. Use 1-index for this method.

To hide more than one column using an index, use hideColumns(columnIndex, numColumns).

To hide more than one column using a range, use hideColumn().

Scripts that use this method require authorization with one or more of the following scopes:

Hides one or more consecutive columns starting at the given index. Use 1-index for this method.

Scripts that use this method require authorization with one or more of the following scopes:

Hides the rows in the given range.

Scripts that use this method require authorization with one or more of the following scopes:

Hides the row at the given index.

Scripts that use this method require authorization with one or more of the following scopes:

Hides one or more consecutive rows starting at the given index.

Scripts that use this method require authorization with one or more of the following scopes:

Hides this sheet. Has no effect if the sheet is already hidden. If this method is called on the only visible sheet, it throws an exception.

Sheet — The current sheet.

Scripts that use this method require authorization with one or more of the following scopes:

Adds a new chart to this sheet.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts a column after the given column position.

Sheet — The sheet, useful for method chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts a column before the given column position.

Sheet — The sheet, useful for method chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts a blank column in a sheet at the specified location.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts one or more consecutive blank columns in a sheet starting at the specified location.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts a given number of columns after the given column position.

Sheet — The sheet, useful for method chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts a number of columns before the given column position.

Sheet — The sheet, useful for method chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts a BlobSource as an image in the document at a given row and column. The image size is retrieved from the blob contents. The maximum supported blob size is 2MB.

OverGridImage — The inserted image.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts a BlobSource as an image in the document at a given row and column, with a pixel offset. The image size is retrieved from the blob contents. The maximum supported blob size is 2MB.

OverGridImage — The inserted image.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts an image in the document at a given row and column.

The provided URL must be publicly accessible.

OverGridImage — The inserted image.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts an image in the document at a given row and column, with a pixel offset.

The provided URL must be publicly accessible.

OverGridImage — The Inserted image.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts a row after the given row position.

Sheet — The sheet, useful for method chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts a row before the given row position.

Sheet — The sheet, useful for method chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts a blank row in a sheet at the specified location.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts one or more consecutive blank rows in a sheet starting at the specified location.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts a number of rows after the given row position.

Sheet — The sheet, useful for method chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts a number of rows before the given row position.

Sheet — The sheet, useful for method chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Adds a new slicer to this sheet.

Slicer — The newly inserted slicer.

Scripts that use this method require authorization with one or more of the following scopes:

Adds a new slicer to this sheet.

Slicer — The newly inserted slicer.

Scripts that use this method require authorization with one or more of the following scopes:

Returns whether the given column is hidden by the user.

Boolean — true if the column is hidden, false otherwise.

Scripts that use this method require authorization with one or more of the following scopes:

Returns true if this sheet layout is right-to-left. Returns false if the sheet uses the default left-to-right layout.

Boolean — true if right-to-left; false otherwise.

Scripts that use this method require authorization with one or more of the following scopes:

Returns whether the given row is hidden by a filter (not a filter view).

Boolean — true if the row is hidden, false otherwise.

Scripts that use this method require authorization with one or more of the following scopes:

Returns whether the given row is hidden by the user.

Boolean — true if the row is hidden, false otherwise.

Scripts that use this method require authorization with one or more of the following scopes:

Returns true if the sheet is currently hidden.

Boolean — true if the sheet is hidden, false otherwise.

Scripts that use this method require authorization with one or more of the following scopes:

Moves the columns selected by the given range to the position indicated by the destinationIndex. The columnSpec itself does not have to exactly represent an entire column or group of columns to move—it selects all columns that the range spans.

Scripts that use this method require authorization with one or more of the following scopes:

Moves the rows selected by the given range to the position indicated by the destinationIndex. The rowSpec itself does not have to exactly represent an entire row or group of rows to move—it selects all rows that the range spans.

Scripts that use this method require authorization with one or more of the following scopes:

Returns a builder to create a new chart for this sheet.

This example shows how to create a new chart:

EmbeddedChartBuilder — A builder to create a new chart.

Creates an object that can protect the sheet from being edited except by users who have permission. Until the script actually changes the list of editors for the sheet (by calling Protection.removeEditor(emailAddress), Protection.removeEditor(user), Protection.removeEditors(emailAddresses), Protection.addEditor(emailAddress), Protection.addEditor(user), Protection.addEditors(emailAddresses), or setting a new value for Protection.setDomainEdit(editable)), the permissions mirror those of the spreadsheet itself, which effectively means that the sheet remains unprotected. If the sheet is already protected, this method returns an object representing its existing protection settings. A protected sheet may include unprotected regions.

Protection — An object representing the protection settings.

Scripts that use this method require authorization with one or more of the following scopes:

Removes a chart from the parent sheet.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the specified range as the active range in the active sheet, with the top left cell in the range as the current cell.

Range — The newly active range.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the specified list of ranges as the active ranges in the active sheet. The last range in the list is set as the active range.

RangeList — The newly selected list of ranges.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the active selection region for this sheet.

Range — The newly active range.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the active selection, as specified in A1 notation or R1C1 notation.

Range — The newly active range.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the position of the column group control toggle on the sheet.

Sheet — This sheet, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the width of the given column in pixels.

Sheet — The sheet, useful for method chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the width of the given columns in pixels.

Sheet — This sheet, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Replaces all currently existing conditional format rules in the sheet with the input rules. Rules are evaluated in their input order.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the specified cell as the current cell.

If the specified cell is present in an already selected range, then that range becomes the active range with the cell as the current cell.

If the specified cell is not present in any selected range, then any existing selection is removed and the cell becomes the current cell and the active range.

Note:The specified Range must consist of one cell, otherwise it throws an exception.

Range — The newly set current cell.

Scripts that use this method require authorization with one or more of the following scopes:

Freezes the given number of columns. If zero, no columns are frozen.

Scripts that use this method require authorization with one or more of the following scopes:

Freezes the given number of rows. If zero, no rows are frozen.

Scripts that use this method require authorization with one or more of the following scopes:

Hides or reveals the sheet gridlines.

Sheet — This sheet, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sheet — This sheet, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets or unsets the sheet layout to right-to-left.

Sheet — This sheet, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the position of the row group control toggle on the sheet.

Sheet — This sheet, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the row height of the given row in pixels. By default, rows grow to fit cell contents. If you want to force rows to a specified height, use setRowHeightsForced(startRow, numRows, height).

Sheet — The sheet, useful for method chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the height of the given rows in pixels. By default, rows grow to fit cell contents. If you want to force rows to a specified height, use setRowHeightsForced(startRow, numRows, height).

Sheet — This sheet, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the height of the given rows in pixels. By default, rows grow to fit cell contents. When you use setRowHeightsForced, rows are forced to the specified height even if the cell contents are taller than the row height.

Sheet — This sheet, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the sheet tab color.

Sheet — This sheet, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the sheet tab color.

Sheet — This sheet, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Unhides the column at the given index.

Scripts that use this method require authorization with one or more of the following scopes:

Unhides one or more consecutive columns starting at the given index.

Scripts that use this method require authorization with one or more of the following scopes:

Unhides the row at the given index.

Scripts that use this method require authorization with one or more of the following scopes:

Unhides one or more consecutive rows starting at the given index.

Scripts that use this method require authorization with one or more of the following scopes:

Makes the sheet visible. Has no effect if the sheet is already visible.

Sheet — The current sheet.

Scripts that use this method require authorization with one or more of the following scopes:

Sorts a sheet by column, ascending.

Sheet — The sheet, useful for method chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sorts a sheet by column. Takes a parameter to specify ascending or descending.

Sheet — The sheet, useful for method chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Unhides the column in the given range.

Scripts that use this method require authorization with one or more of the following scopes:

Unhides the row in the given range.

Scripts that use this method require authorization with one or more of the following scopes:

Updates the chart on this sheet.

Scripts that use this method require authorization with one or more of the following scopes:

Deprecated. For spreadsheets created in the newer version of Google Sheets, use getProtections(type), which returns the more powerful Protection class. Although this method is deprecated, it remains available for compatibility with the older version of Sheets

Returns a PageProtection instance describing the permissions for the current sheet.

PageProtection — An object describing sheet access permissions.

Scripts that use this method require authorization with one or more of the following scopes:

Deprecated. Replaced by getTabColorObject()

Gets the sheet tab color, or null if the sheet tab has no color.

String — Color code in CSS notation (such as '#ffffff').

Scripts that use this method require authorization with one or more of the following scopes:

Deprecated. For spreadsheets created in the newer version of Google Sheets, use protect(), which returns the more powerful Protection class. Although this method is deprecated, it remains available for compatibility with the older version of Sheets

Sets the permissions for the current sheet.

Scripts that use this method require authorization with one or more of the following scopes:

---

## Class Slicer Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/spreadsheet/slicer

**Contents:**
- Class Slicer Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
  - Methods
  - Deprecated methods
- Detailed documentation
  - getBackgroundColorObject()
    - Return
    - Authorization
  - getColumnPosition()
    - Return

A Slicer in Google Sheets is used to filter data ranges, charts, and pivot tables non-collaboratively.

You can access and modify existing slicers using the methods provided by this class.

New slicers can be created using the Sheet.insertSlicer(range, anchorRowPos, anchorColPos) method.

Methods are available to get and set properties of a slicer such as background color, range, title, and filter criteria.

You can check if a slicer is applied to pivot tables and also set this property using the provided methods.

Represents a slicer, which is used to filter ranges, charts and pivot tables in a non-collaborative manner. This class contains methods to access and modify existing slicers. To create a new slicer, use Sheet.insertSlicer(range, anchorRowPos, anchorColPos).

Return the background Color of the slicer.

Color — The background color of this slicer. Returns null if no color is set.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the column position (relative to the data range of the slicer) on which the filter is applied in the slicer, or null if the column position is not set. This should be 1-indexed position of the column similar to filter.

Integer — The column position of this slicer.

Scripts that use this method require authorization with one or more of the following scopes:

Gets information about where the slicer is positioned in the sheet.

ContainerInfo — An object containing the slicer's container position.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the filter criteria of the slicer, or null if the filter criteria is not set.

FilterCriteria — The filter criteria of this slicer.

Scripts that use this method require authorization with one or more of the following scopes:

Gets the data range on which the slicer is applied to.

Range — The slicer range.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the title of the slicer.

String — This slicer, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Gets the horizontal alignment of the title.

String — The horizontal alignment of this slicer's title.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the text style of the slicer's title.

TextStyle — The text style of this slicer's title.

Scripts that use this method require authorization with one or more of the following scopes:

Returns whether the given slicer is applied to pivot tables.

Boolean — true if this slicer is applied to pivot tables, otherwise false.

Scripts that use this method require authorization with one or more of the following scopes:

Scripts that use this method require authorization with one or more of the following scopes:

Sets if the given slicer should be applied to pivot tables in the worksheet.

Slicer — This slicer, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the background color of the slicer. A null value resets the background color.

Slicer — This slicer, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the background Color of the slicer. A null value resets the background color.

Slicer — This slicer, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the column index and filtering criteria of the slicer. A null value resets the slicer filter.

Slicer — This slicer, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the position where the slicer appears on the sheet. The anchor row and column position indices are 1-indexed.

Slicer — This slicer, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the data range on which the slicer is applied.

Slicer — This slicer, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the title of the slicer. An empty title resets the title to default value.

Slicer — This slicer, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the horizontal alignment of the title in the slicer. A null value resets the alignment.

Slicer — This slicer, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the text style of the slicer.

Slicer — This slicer, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Deprecated. Replaced by getBackgroundColorObject()

Returns the background color of the slicer in CSS notation (such as '#ffffff').

String — The background color of this slicer. Returns null if no color is set.

Scripts that use this method require authorization with one or more of the following scopes:

---

## Class Slide Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/slides/slide

**Contents:**
- Class Slide Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
  - Methods
- Detailed documentation
  - duplicate()
    - Return
    - Authorization
  - getBackground()
    - Return
    - Authorization

A Slide represents a page in a presentation and is typically based on a master and a layout.

The Slide object offers numerous methods for both retrieving information about the slide's content and properties, and for manipulating that content, such as inserting, grouping, moving, or removing elements.

Information retrieval methods allow you to get details about the slide's background, color scheme, layout, various page elements (like images, shapes, tables, etc.), linking status, and skip status.

Content manipulation methods enable actions like duplicating the slide, inserting various types of elements (images, shapes, tables, videos, charts), grouping elements, moving or removing the slide, and replacing text.

Several methods specifically deal with linked slides, allowing you to refresh them to reflect source changes, or unlink them.

A slide in a presentation.

These pages contain the content you are presenting to your audience. Most slides are based on a master and a layout. You can specify which layout to use for each slide when it is created.

Duplicates the slide.

The duplicate slide is created immediately following the original.

Slide — The duplicated slide.

Scripts that use this method require authorization with one or more of the following scopes:

Gets the page's background.

PageBackground — The page's background.

Scripts that use this method require authorization with one or more of the following scopes:

Gets the ColorScheme associated with the page.

ColorScheme — The page's color scheme.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the list of Group objects on the page.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the list of Image objects on the page.

Scripts that use this method require authorization with one or more of the following scopes:

Gets the layout that the slide is based on or null if the slide is not based on a layout.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the list of Line objects on the page.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the notes page associated with the slide.

Scripts that use this method require authorization with one or more of the following scopes:

Gets the unique ID for the page. Object IDs used by pages and page elements share the same namespace.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the PageElement on the page with the given ID, or null if none exists.

PageElement — The page element with the given ID.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the list of PageElement objects rendered on the page.

Scripts that use this method require authorization with one or more of the following scopes:

Gets the type of the page.

PageType — The page type.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the placeholder PageElement object for a specified PlaceholderType or null if a matching placeholder is not present.

If there are multiple placeholders with the same type, it returns the one with minimal placeholder index. If there are multiple matching placeholders with the same index, it returns the first placeholder from the page's page elements collection.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the placeholder PageElement object for a specified PlaceholderType and a placeholder index, or null if the placeholder is not present.

If there are multiple placeholders with the same type and index, it returns the first placeholder from the page's page elements collection.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the list of placeholder PageElement objects in the page.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the list of Shape objects on the page.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the list of SheetsChart objects on the page.

Scripts that use this method require authorization with one or more of the following scopes:

Returns a SlideLinkingMode indicating if the slide is linked to another slide.

SlideLinkingMode — The slide linking mode.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the source Presentation ID or null if the slide is not linked.

A slide only has a source Presentation ID when it is linked to a slide within another presentation.

String — The source presentation ID or null.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the source slide ID or null if the slide is not linked.

A slide only has a source slide ID when it is linked to a slide within another presentation.

String — The source slide ID or null.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the list of Table objects on the page.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the list of Video objects on the page.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the list of WordArt objects on the page.

Scripts that use this method require authorization with one or more of the following scopes:

Groups all the specified page elements.

There should be at least two page elements on the same page that are not already in another group. Some page elements, such as Videos, Tables and placeholder Shapes cannot be grouped.

Group — The new group.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts a copy of the provided Group on the page.

The inserted element's position on this page is determined from the source element's position on its respective page.

If the provided element is a placeholder being copied from within the current presentation, properties that inherit from master or layout pages also inherit on the inserted element.

If the provided element is a placeholder being copied from a different presentation, properties that inherit from master or layout pages are copied onto the element from the source presentation.

Group — The inserted group.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts an image at the top left corner of the page with a default size from the specified image blob.

Inserting the image fetches it from the BlobSource once and a copy is stored for display inside the presentation. Images must be less than 50MB in size, cannot exceed 25 megapixels, and must be in either in PNG, JPEG, or GIF format.

Image — The inserted image.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts an image on the page with the provided position and size from the specified image blob.

The image is fetched from the provided BlobSource once at insertion time and a copy is stored for display inside the presentation. Images must be less than 50MB in size, cannot exceed 25 megapixels, and must be in either in PNG, JPEG, or GIF format.

In order to maintain the image's aspect ratio, the image is scaled and centered with respect to the provided size.

Image — The inserted image.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts a copy of the provided Image on the page.

The inserted images's position on this page is determined from the source image's position on its respective page.

If the provided image is a placeholder being copied from within the current presentation, properties that inherit from master or layout pages also inherit on the inserted image.

If the provided image is a placeholder being copied from a different presentation, properties that inherit from master or layout pages are copied onto the image from the source presentation. If the copied placeholder image is empty, nothing is inserted in the destination presentation.

Image — The inserted image.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts an image at the top left corner of the page with a default size from the provided URL.

Inserting the image fetches it from the URL once and a copy is stored for display inside the presentation. Images must be less than 50MB in size, cannot exceed 25 megapixels, and must be in either in PNG, JPEG, or GIF format.

The provided URL must be publicly accessible and no larger than 2kB. The URL itself is saved with the image and exposed via Image.getSourceUrl().

Image — The inserted image.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts an image on the page with the provided position and size from the provided URL.

Inserting the image fetches it from the URL once and a copy is stored for display inside the presentation. Images must be less than 50MB in size, cannot exceed 25 megapixels, and must be in either in PNG, JPEG, or GIF format.

The provided URL must be publicly accessible and no larger than 2kB. The URL itself is saved with the image and exposed via Image.getSourceUrl().

In order to maintain the image's aspect ratio, the image is scaled and centered with respect to the provided size.

Image — The inserted image.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts a copy of the provided Line on the page.

The inserted element's position on this page is determined from the source element's position on its respective page.

If the provided element is a placeholder being copied from within the current presentation, properties that inherit from master or layout pages also inherit on the inserted element.

If the provided element is a placeholder being copied from a different presentation, properties that inherit from master or layout pages are copied onto the element from the source presentation.

Line — The inserted line.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts a line on the page connecting two connection sites. The two connection sites must be on this page.

Line — The inserted line.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts a line on the page.

Line — The inserted line.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts a copy of the provided PageElement on the page.

The inserted element's position on this page is determined from the source element's position on its respective page.

If the provided element is a placeholder being copied from within the current presentation, properties that inherit from master or layout pages also inherit on the inserted element.

If the provided element is a placeholder being copied from a different presentation, properties that inherit from master or layout pages are copied onto the element from the source presentation.

PageElement — The inserted page element.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts a copy of the provided Shape on the page.

The inserted element's position on this page is determined from the source element's position on its respective page.

If the provided element is a placeholder being copied from within the current presentation, properties that inherit from master or layout pages also inherit on the inserted element.

If the provided element is a placeholder being copied from a different presentation, properties that inherit from master or layout pages are copied onto the element from the source presentation.

Shape — The inserted shape.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts a shape on the page.

The shape is inserted with a default size at the top left corner of the page.

Shape — The inserted shape.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts a shape on the page.

Shape — The inserted shape.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts a Google Sheets chart on the page.

The chart is inserted with a default size at the top left corner of the page.

The inserted chart is linked with the source Google Sheets chart which allows it to be updated. Other collaborators can see the link to the source spreadsheet.

SheetsChart — The inserted chart in the page.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts a Google Sheets chart on the page with the provided position and size.

In order to maintain the chart's aspect ratio, the chart is scaled and centered with respect to the provided size.

The inserted chart is linked with the source Google Sheets chart which allows it to be updated. Other collaborators can see the link to the source spreadsheet.

SheetsChart — The inserted chart in the page.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts a copy of the provided SheetsChart on the page.

The inserted element's position on this page is determined from the source element's position on its respective page.

If the provided element is a placeholder being copied from within the current presentation, properties that inherit from master or layout pages also inherit on the inserted element.

If the provided element is a placeholder being copied from a different presentation, properties that inherit from master or layout pages are copied onto the element from the source presentation.

SheetsChart — The inserted sheets chart.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts a Google Sheets chart as an Image on the page.

The image of the chart is inserted with a default size at the top left corner of the page.

The inserted image of chart is not linked with the source Google Sheets chart.

Image — The inserted image of the chart in the page.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts a Google Sheets chart as an Image on the page with the provided position and size.

In order to maintain the chart image's aspect ratio, the image is scaled and centered with respect to the provided size.

The inserted image of the chart is not linked with the source Google Sheets chart.

Image — The inserted image of the chart in the page.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts a table on the page.

The table is centered on the page with default size and evenly distributed rows and columns.

Table — The inserted table.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts a table on the page with the provided position and size.

Rows and columns are evenly distributed in the created table.

Table — The inserted table.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts a copy of the provided Table on the page.

The inserted element's position on this page is determined from the source element's position on its respective page.

If the provided element is a placeholder being copied from within the current presentation, properties that inherit from master or layout pages also inherit on the inserted element.

If the provided element is a placeholder being copied from a different presentation, properties that inherit from master or layout pages are copied onto the element from the source presentation.

Table — The inserted table.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts a text box Shape containing the provided string on the page.

The text box shape is inserted with a default size at the top left corner of the page.

Shape — The inserted text box shape.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts a text box Shape containing the provided string on the page.

Shape — The inserted text box shape.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts a video at the top left corner of the page with a default size.

Only YouTube videos are currently supported.

Video — The inserted video.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts a video on the page with the provided position and size.

Only YouTube videos are currently supported.

Video — The inserted video.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts a copy of the provided Video on the page.

The inserted element's position on this page is determined from the source element's position on its respective page.

If the provided element is a placeholder being copied from within the current presentation, properties that inherit from master or layout pages also inherit on the inserted element.

If the provided element is a placeholder being copied from a different presentation, properties that inherit from master or layout pages are copied onto the element from the source presentation.

Video — The inserted video.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts a copy of the provided WordArt on the page.

The inserted element's position on this page is determined from the source element's position on its respective page.

If the provided element is a placeholder being copied from within the current presentation, properties that inherit from master or layout pages also inherit on the inserted element.

If the provided element is a placeholder being copied from a different presentation, properties that inherit from master or layout pages are copied onto the element from the source presentation.

WordArt — The inserted word art.

Scripts that use this method require authorization with one or more of the following scopes:

Returns whether the slide is skipped in the presentation mode.

Boolean — True if the slide is skipped in the presentation mode.

Scripts that use this method require authorization with one or more of the following scopes:

Move the slide to the specified index.

Scripts that use this method require authorization with one or more of the following scopes:

Refreshes the slide to reflect any changes made to the linked source slide. If this slide is not linked, returns without making any changes.

The refreshSlide method copies the linked source slide's corresponding master and layout pages into the slide's presentation if they do not already exist. If they do already exist, they are likewise updated to reflect any changes made to the source.

Note: The refresh overwrites any changes made to the current slide in order to reflect the state of the source slide.

Error — If read-access to the source presentation is no longer available.

Scripts that use this method require authorization with one or more of the following scopes:

Scripts that use this method require authorization with one or more of the following scopes:

Replaces all instances of text matching find text with replace text. The search is case insensitive.

Integer — the number of occurrences changed

Scripts that use this method require authorization with one or more of the following scopes:

Replaces all instances of text matching find text with replace text.

Integer — the number of occurrences changed

Scripts that use this method require authorization with one or more of the following scopes:

Selects the Page in the active presentation as the current page selection and removes any previous selection.

A script can only access the selection of the user who is running the script, and only if the script is bound to the presentation.

Scripts that use this method require authorization with one or more of the following scopes:

Sets whether the slide is skipped in the presentation mode.

Scripts that use this method require authorization with one or more of the following scopes:

Unlinks the current Slide from its source slide. If this slide is not linked, returns without making any changes.

Scripts that use this method require authorization with one or more of the following scopes:

---

## Class SpreadsheetApp Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/spreadsheet/spreadsheet-app

**Contents:**
- Class SpreadsheetApp Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
  - Properties
  - Methods
- Detailed documentation
  - create(name)
    - Parameters
    - Return
    - Authorization
  - create(name, rows, columns)

The SpreadsheetApp class is used to access and create Google Sheets files and is the parent class for the Spreadsheet service.

The SpreadsheetApp class contains various properties, which are enumerations representing different options or types within a spreadsheet, such as AutoFillSeries, BandingTheme, and BorderStyle.

The SpreadsheetApp class offers methods to manage spreadsheets, including creating new spreadsheets, opening existing ones by ID or URL, and controlling data execution for data sources.

Methods like getActive(), getActiveRange(), getActiveSheet(), and getSelection() allow scripts to interact with the currently active components of a spreadsheet.

The SpreadsheetApp class also provides methods to create builders for various spreadsheet elements like CellImage, Color, ConditionalFormatRule, and DataValidation.

Access and create Google Sheets files. This class is the parent class for the Spreadsheet service.

Creates a new spreadsheet with the given name.

Spreadsheet — a new spreadsheet

Scripts that use this method require authorization with one or more of the following scopes:

Creates a new spreadsheet with the given name and the specified number of rows and columns.

Spreadsheet — a new spreadsheet

Scripts that use this method require authorization with one or more of the following scopes:

Turns data execution on for all types of data sources.

Data execution throws an exception if the data source type isn't turned on. Use this method to turn data execution on for all data source types.

Scripts that use this method require authorization with one or more of the following scopes:

Turns data execution on for BigQuery data sources.

Data execution for BigQuery data source throws an exception if not turned on.

Scripts that use this method require authorization with one or more of the following scopes:

Turns data execution on for Looker data sources.

Data execution for Looker data source throws an exception if not turned on.

Applies all pending Spreadsheet changes.

Spreadsheet operations are sometimes bundled together to improve performance, such as when doing multiple calls to Range.getValue(). However, sometimes you may want to make sure that all pending changes are made right away, for instance to show users data as a script is executing.

Returns the currently active spreadsheet, or null if there is none.

Functions that are run in the context of a spreadsheet can get a reference to the corresponding Spreadsheet object by calling this function.

Spreadsheet — the active Spreadsheet object

Scripts that use this method require authorization with one or more of the following scopes:

Returns the selected range in the active sheet, or null if there is no active range. If multiple ranges are selected this method returns only the last selected range.

This generally means the range that a user has selected in the active sheet, but in a custom function it refers to the cell being actively recalculated.

Range — The active range.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the list of active ranges in the active sheet or null if there are no ranges selected. The active range containing the current highlighted cell is placed last in the list.

If there is a single range selected, this behaves as a getActiveRange() call.

RangeList — the list of active ranges

Scripts that use this method require authorization with one or more of the following scopes:

Gets the active sheet in a spreadsheet.

The active sheet in a spreadsheet is the sheet that is being displayed in the spreadsheet UI.

Sheet — the active Sheet object

Scripts that use this method require authorization with one or more of the following scopes:

Returns the currently active spreadsheet, or null if there is none.

Functions that are run in the context of a spreadsheet can get a reference to the corresponding Spreadsheet object by calling this function.

Spreadsheet — the active Spreadsheet object

Scripts that use this method require authorization with one or more of the following scopes:

Returns the current (highlighted) cell that is selected in one of the active ranges in the active sheet or null if there is no current cell.

Range — the current cell

Scripts that use this method require authorization with one or more of the following scopes:

Returns the current Selection in the spreadsheet.

Selection — the current selection

Scripts that use this method require authorization with one or more of the following scopes:

Returns an instance of the spreadsheet's user-interface environment that allows the script to add features like menus, dialogs, and sidebars. A script can only interact with the UI for the current instance of an open spreadsheet, and only if the script is bound to the spreadsheet. For more information, see the guides to menus and dialogs and sidebars.

Ui — an instance of this spreadsheet's user-interface environment

Creates a builder for a CellImage.

CellImageBuilder — The new builder.

Creates a builder for a Color.

ColorBuilder — The new builder.

Creates a builder for a conditional formatting rule.

ConditionalFormatRuleBuilder — the new builder.

Creates a builder for a DataSourceSpec.

DataSourceSpecBuilder — The new builder.

Creates a builder for a data validation rule.

DataValidationBuilder — The new builder.

Creates a builder for a FilterCriteria.

FilterCriteriaBuilder — the new builder

Creates a builder for a Rich Text value.

RichTextValueBuilder — The new builder.

Creates a builder for a text style.

TextStyleBuilder — The new builder.

Opens the spreadsheet that corresponds to the given File object.

Spreadsheet — the spreadsheet

Scripts that use this method require authorization with one or more of the following scopes:

Opens the spreadsheet with the given ID. A spreadsheet ID can be extracted from its URL. For example, the spreadsheet ID in the URL https://docs.google.com/spreadsheets/d/abc1234567/edit#gid=0 is "abc1234567".

Spreadsheet — the Spreadsheet object with the given id

Scripts that use this method require authorization with one or more of the following scopes:

Opens the spreadsheet with the given URL. Throws a scripting exception if the URL doesn't exist or the user doesn't have permission to access it.

Spreadsheet — The spreadsheet object with the given URL.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the specified range as the active range, with the top left cell in the range as the current cell.

The spreadsheet UI displays the sheet that contains the chosen range and selects the cells defined in the chosen range.

Range — the new active Range

Sets the specified list of ranges as the active ranges. The last range in the list is set as the active range.

RangeList — the newly selected list of ranges

Scripts that use this method require authorization with one or more of the following scopes:

Sets the active sheet in a spreadsheet. The Google Sheets UI displays the chosen sheet unless the sheet belongs to a different spreadsheet.

Sheet — the sheet that has been made the new active sheet

Sets the active sheet in a spreadsheet, with the option to restore the most recent selection within that sheet. The Google Sheets UI displays the chosen sheet unless the sheet belongs to a different spreadsheet.

Sheet — the new active sheet

Scripts that use this method require authorization with one or more of the following scopes:

Sets the active spreadsheet.

Sets the specified cell as the current cell.

If the specified cell is present in an already selected range, then that range becomes the active range with the cell as the current cell.

If the specified cell is not present in any selected range, then the existing selection is removed and the cell becomes the current cell and the active range.

Note:The specified Range must consist of one cell, otherwise this method throws an exception.

Range — the newly set current cell

Scripts that use this method require authorization with one or more of the following scopes:

---

## Class SpreadsheetTheme Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/spreadsheet/spreadsheet-theme

**Contents:**
- Class SpreadsheetTheme Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
  - Methods
- Detailed documentation
  - getConcreteColor(themeColorType)
    - Parameters
    - Return
    - Authorization
  - getFontFamily()
    - Return

SpreadsheetTheme allows access and modification of existing spreadsheet themes.

You can set a theme on a spreadsheet using Spreadsheet.setSpreadsheetTheme(theme).

Methods are available to get and set concrete colors for theme color types and to get and set the font family of a theme.

Methods like getConcreteColor and getFontFamily return theme properties, while methods like setConcreteColor and setFontFamily modify them and return the theme object for chaining.

Using these methods requires specific authorization scopes related to accessing and modifying spreadsheets.

Access and modify existing themes. To set a theme on a spreadsheet, use Spreadsheet.setSpreadsheetTheme(theme).

Returns the concrete Color for a valid theme color type. Throws exception if the theme color type is not set in the current theme.

Color — Concrete color.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the font family of the theme, or null if it's a null theme.

String — The theme font family.

Scripts that use this method require authorization with one or more of the following scopes:

Returns a list of all possible theme color types for the current theme.

ThemeColorType[] — A list of theme colors.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the concrete color associated with the ThemeColorType in this color scheme to the given color.

SpreadsheetTheme — The theme, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the concrete color associated with the ThemeColorType in this color scheme to the given color in RGB format.

SpreadsheetTheme — The theme, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the font family for the theme.

SpreadsheetTheme — This theme, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

---

## Class Spreadsheet Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/spreadsheet/spreadsheet

**Contents:**
- Class Spreadsheet Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
  - Methods
  - Deprecated methods
- Detailed documentation
  - addDeveloperMetadata(key)
    - Parameters
    - Return
    - Authorization
  - addDeveloperMetadata(key, visibility)

The document provides a summary of methods for interacting with Google Sheets using the Spreadsheet object in Google Apps Script.

Common operations include managing sheets, ranges, cells, and collaborators.

Methods are available for handling spreadsheet properties, data sources, and UI elements like custom menus.

The document also lists deprecated methods, often with suggestions for more current alternatives using the Drive service.

Access and modify Google Sheets files. Common operations are adding new sheets and adding collaborators.

Adds developer metadata with the specified key to the top-level spreadsheet.

Spreadsheet — This spreadsheet, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Adds developer metadata with the specified key and visibility to the spreadsheet.

Spreadsheet — This spreadsheet, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Adds developer metadata with the specified key and value to the spreadsheet.

Spreadsheet — This spreadsheet, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Adds developer metadata with the specified key, value, and visibility to the spreadsheet.

Spreadsheet — This spreadsheet, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Adds the given user to the list of editors for the Spreadsheet. If the user was already on the list of viewers, this method promotes the user out of the list of viewers.

Spreadsheet — This Spreadsheet, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Adds the given user to the list of editors for the Spreadsheet. If the user was already on the list of viewers, this method promotes the user out of the list of viewers.

Spreadsheet — This Spreadsheet, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Adds the given array of users to the list of editors for the Spreadsheet. If any of the users were already on the list of viewers, this method promotes them out of the list of viewers.

Spreadsheet — This Spreadsheet, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Creates a new menu in the Spreadsheet UI.

Each menu entry runs a user-defined function. Usually, you want to call it from the onOpen() function so that the menu is automatically created when the spreadsheet is loaded.

Scripts that use this method require authorization with one or more of the following scopes:

Adds the given user to the list of viewers for the Spreadsheet. If the user was already on the list of editors, this method has no effect.

Spreadsheet — This Spreadsheet, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Adds the given user to the list of viewers for the Spreadsheet. If the user was already on the list of editors, this method has no effect.

Spreadsheet — This Spreadsheet, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Adds the given array of users to the list of viewers for the Spreadsheet. If any of the users were already on the list of editors, this method has no effect for them.

Spreadsheet — This Spreadsheet, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Appends a row to the bottom of the current data region in the sheet. If a cell's content begins with =, it's interpreted as a formula.

Sheet — The sheet, useful for method chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the width of the given column to fit its contents.

Sheet — The sheet, useful for method chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Copies the spreadsheet and returns the new one.

Spreadsheet — This spreadsheet, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Returns a DeveloperMetadataFinder for finding developer metadata within the scope of this spreadsheet. By default this considers all metadata associated with the spreadsheet, sheets, rows, and columns.

DeveloperMetadataFinder — A developer metadata finder to search for metadata in the scope of this spreadsheet.

Creates a text finder for the spreadsheet, which can be used to find and replace text within the spreadsheet. The search starts from the first sheet of the spreadsheet.

TextFinder — The TextFinder for the spreadsheet.

Deletes the currently active sheet.

Sheet — The new active sheet.

Scripts that use this method require authorization with one or more of the following scopes:

Deletes the column at the given column position.

Sheet — The sheet, useful for method chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Deletes a number of columns starting at the given column position.

Scripts that use this method require authorization with one or more of the following scopes:

Deletes the row at the given row position.

Sheet — The sheet, useful for method chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Deletes a number of rows starting at the given row position.

Scripts that use this method require authorization with one or more of the following scopes:

Deletes the specified sheet.

Scripts that use this method require authorization with one or more of the following scopes:

Duplicates the active sheet and makes it the active sheet.

Sheet — The new sheet.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the active cell in this sheet.

Note: It's preferable to use getCurrentCell(), which returns the current highlighted cell.

Range — The current active cell.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the selected range in the active sheet, or null if there is no active range. If multiple ranges are selected this method returns only the last selected range.

The term "active range" refers to the range that a user has selected in the active sheet, but in a custom function it refers to the cell being actively recalculated.

Range — The active range.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the list of active ranges in the active sheet or null if there are no active ranges.

If there is a single range selected, this behaves as a getActiveRange() call.

RangeList — The list of active ranges.

Scripts that use this method require authorization with one or more of the following scopes:

Gets the active sheet in a spreadsheet.

The active sheet in a spreadsheet is the sheet that is being displayed in the spreadsheet UI.

Sheet — The active sheet in the spreadsheet.

Return the data inside this object as a blob converted to the specified content type. This method adds the appropriate extension to the filename—for example, "myfile.pdf". However, it assumes that the part of the filename that follows the last period (if any) is an existing extension that should be replaced. Consequently, "ShoppingList.12.25.2014" becomes "ShoppingList.12.25.pdf".

To view the daily quotas for conversions, see Quotas for Google Services. Newly created Google Workspace domains might be temporarily subject to stricter quotas.

Blob — The data as a blob.

Returns all the bandings in this spreadsheet.

Banding[] — The bandings in this spreadsheet.

Scripts that use this method require authorization with one or more of the following scopes:

Return the data inside this object as a blob.

Blob — The data as a blob.

Gets the width in pixels of the given column.

Integer — Column width in pixels.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the current cell in the active sheet or null if there is no current cell. The current cell is the cell that has focus in the Google Sheets UI, and is highlighted by a dark border. There is never more than one current cell. When a user selects one or more cell ranges, one of the cells in the selection is the current cell.

Range — The current cell.

Scripts that use this method require authorization with one or more of the following scopes:

Returns a Range corresponding to the dimensions in which data is present.

This is functionally equivalent to creating a Range bounded by A1 and (Sheet.getLastColumn(), Sheet.getLastRow()).

Range — A range consisting of all the data in the spreadsheet.

Scripts that use this method require authorization with one or more of the following scopes:

Gets all the data source formulas.

DataSourceFormula[] — A list of data source formulas.

Scripts that use this method require authorization with one or more of the following scopes:

Gets all the data source pivot tables.

DataSourcePivotTable[] — A list of data source pivot tables.

Scripts that use this method require authorization with one or more of the following scopes:

Gets the refresh schedules of this spreadsheet.

DataSourceRefreshSchedule[] — The refresh schedules of this spreadsheet.

Scripts that use this method require authorization with one or more of the following scopes:

Returns all the data source sheets in the spreadsheet.

DataSourceSheet[] — An array of all the data source sheets.

Scripts that use this method require authorization with one or more of the following scopes:

Gets all the data source tables.

DataSourceTable[] — A list of data source tables.

Scripts that use this method require authorization with one or more of the following scopes:

Returns all the data sources in the spreadsheet.

DataSource[] — An array of all the data sources.

Scripts that use this method require authorization with one or more of the following scopes:

Gets the developer metadata associated with the top-level spreadsheet.

DeveloperMetadata[] — The developer metadata associated with this range.

Scripts that use this method require authorization with one or more of the following scopes:

Gets the list of editors for this Spreadsheet.

User[] — An array of users with edit permission.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the URL for the form that sends its responses to this spreadsheet, or null if this spreadsheet has no associated form. If multiple forms send responses to this spreadsheet, the form URL returned is indeterminate. As an alternative, per sheet form URL associations can be retrieved through the Sheet.getFormUrl() method. Throws an exception if the user does not have permission to edit the spreadsheet.

String — The URL for the form that places its responses in this spreadsheet, or null if this spreadsheet doesn't have an associated form.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the number of frozen columns.

Integer — The number of frozen columns.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the number of frozen rows.

Integer — The number of frozen rows.

Scripts that use this method require authorization with one or more of the following scopes:

Gets a unique identifier for this spreadsheet. A spreadsheet ID can be extracted from its URL. For example, the spreadsheet ID in the URL https://docs.google.com/spreadsheets/d/abc1234567/edit#gid=0 is "abc1234567".

String — The unique ID (or key) for the spreadsheet.

Returns all over-the-grid images on the sheet.

OverGridImage[] — An array of over-the-grid images.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the threshold value used during iterative calculation. When the results of successive calculation differ by less than this value, the iterative calculation stops.

Number — The convergence threshold.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the position of the last column that has content.

Integer — The last column of the sheet that contains content.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the position of the last row that has content.

Integer — The last row of the sheet that contains content.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the maximum number of iterations to use during iterative calculation.

Integer — The maximum number of calculation iterations.

Scripts that use this method require authorization with one or more of the following scopes:

Gets the name of the document.

String — The name of the spreadsheet.

Scripts that use this method require authorization with one or more of the following scopes:

Gets all the named ranges in this spreadsheet.

NamedRange[] — An array of all the named ranges in the spreadsheet.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the number of sheets in this spreadsheet.

Integer — The number of sheets in the spreadsheet.

Returns the owner of the document, or null for a document in a shared drive.

User — The owner of the document, or null if the document is in a shared drive.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the list of predefined themes.

SpreadsheetTheme[] — List of predefined themes.

Scripts that use this method require authorization with one or more of the following scopes:

Gets an array of objects representing all protected ranges or sheets in the spreadsheet.

Protection[] — An array of objects representing all protected ranges or sheets in the spreadsheet.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the range as specified in A1 notation or R1C1 notation.

Range — The range at the location designated.

Scripts that use this method require authorization with one or more of the following scopes:

Returns a named range, or null if no range with the given name is found. If multiple sheets of the spreadsheet use the same range name, specify the sheet name without additional quotation marks — for example, getRangeByName('TaxRates') or getRangeByName('Sheet Name!TaxRates'), but not getRangeByName('"Sheet Name"!TaxRates').

Range — The range of cells with the given name.

Returns the RangeList collection representing the ranges in the same sheet specified by a non-empty list of A1 notations or R1C1 notations.

RangeList — The range list at the location designated.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the calculation interval for this spreadsheet.

RecalculationInterval — The calculation interval for this spreadsheet.

Scripts that use this method require authorization with one or more of the following scopes:

Gets the height in pixels of the given row.

Integer — Row height in pixels.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the current Selection in the spreadsheet.

Selection — The current selection.

Scripts that use this method require authorization with one or more of the following scopes:

Gets the sheet with the given ID. Use Sheet.getSheetId().

Sheet — The sheet with the given ID or null if no sheet is found.

Returns a sheet with the given name.

If multiple sheets have the same name, the leftmost one is returned. Returns null if there is no sheet with the given name.

Sheet — The sheet with the given name.

Returns the ID of the sheet represented by this object.

This is an ID for the sheet that is unique to the spreadsheet. The ID is a monotonically increasing integer assigned at sheet creation time that is independent of sheet position. This is useful in conjunction with methods such as Range.copyFormatToRange(gridId, column, columnEnd, row, rowEnd) that take a gridId parameter rather than a Sheet instance.

Integer — An ID for the sheet unique to the spreadsheet.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the sheet name.

String — The name of the sheet.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the rectangular grid of values for this range starting at the given coordinates. A -1 value given as the row or column position is equivalent to getting the very last row or column that has data in the sheet.

Object[][] — A two-dimensional array of values.

Scripts that use this method require authorization with one or more of the following scopes:

Gets all the sheets in this spreadsheet.

Sheet[] — An array of all the sheets in the spreadsheet.

Gets the spreadsheet locale.

String — The spreadsheet locale.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the current theme of the spreadsheet, or null if no theme is applied.

SpreadsheetTheme — The current applied theme.

Scripts that use this method require authorization with one or more of the following scopes:

Gets the time zone for the spreadsheet.

String — The time zone, specified in "long" format (for example, "America/New_York", as listed by Joda.org).

Scripts that use this method require authorization with one or more of the following scopes:

Returns the URL for the given spreadsheet.

String — The URL for the given spreadsheet.

Scripts that use this method require authorization with one or more of the following scopes:

Gets the list of viewers and commenters for this Spreadsheet.

User[] — An array of users with view or comment permission.

Scripts that use this method require authorization with one or more of the following scopes:

Hides the column or columns in the given range.

Scripts that use this method require authorization with one or more of the following scopes:

Hides the rows in the given range.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts a column after the given column position.

Sheet — The sheet, useful for method chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts a column before the given column position.

Sheet — The sheet, useful for method chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts a given number of columns after the given column position.

Sheet — The sheet, useful for method chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts a number of columns before the given column position.

Sheet — The sheet, useful for method chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts a new DataSourceSheet in the spreadsheet and starts data execution. As a side effect, this also makes the new sheet the active sheet.

Throws an exception if the data source type is not enabled. Use SpreadsheetApp#enable...Execution() methods to enable data execution for specific data source type.

DataSourceSheet — The new data source sheet.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts a Spreadsheet as an image in the document at a given row and column. The image size is retrieved from the blob contents. The maximum supported blob size is 2MB.

OverGridImage — The inserted image.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts a Spreadsheet as an image in the document at a given row and column, with a pixel offset. The image size is retrieved from the blob contents. The maximum supported blob size is 2MB.

OverGridImage — The inserted image.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts an image in the document at a given row and column.

The provided URL must be publicly accessible.

OverGridImage — The inserted image.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts an image in the document at a given row and column, with a pixel offset.

The provided URL must be publicly accessible.

OverGridImage — The Inserted image.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts a row after the given row position.

Sheet — The sheet, useful for method chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts a row before the given row position.

Sheet — The sheet, useful for method chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts a number of rows after the given row position.

Sheet — The sheet, useful for method chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts a number of rows before the given row position.

Sheet — The sheet, useful for method chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts a new sheet into the spreadsheet, using a default sheet name. The new sheet becomes the active sheet.

Sheet — The new sheet.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts a new sheet into the spreadsheet at the given index. The new sheet becomes the active sheet.

Sheet — The new sheet.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts a new sheet into the spreadsheet at the given index and uses optional advanced arguments. The new sheet becomes the active sheet.

Sheet — The new sheet.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts a new sheet into the spreadsheet, using a default sheet name and optional advanced arguments. The new sheet becomes the active sheet.

Sheet — The new sheet.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts a new sheet into the spreadsheet with the given name. The new sheet becomes the active sheet.

Sheet — The new sheet.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts a new sheet into the spreadsheet with the given name at the given index. The new sheet becomes the active sheet.

Sheet — The new sheet.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts a new sheet into the spreadsheet with the given name at the given index and uses optional advanced arguments. The new sheet becomes the active sheet.

Sheet — The new sheet.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts a new sheet into the spreadsheet with the given name and uses optional advanced arguments. The new sheet becomes the active sheet.

Sheet — The new sheet.

Scripts that use this method require authorization with one or more of the following scopes:

Inserts a new sheet in the spreadsheet, creates a DataSourceTable spanning the entire sheet with the given data source specification, and starts data execution. As a side effect, makes the new sheet the active sheet.

Throws an exception if the data source type is not enabled. Use SpreadsheetApp#enable...Execution() methods to enable data execution for specific data source type.

Sheet — The new sheet.

Scripts that use this method require authorization with one or more of the following scopes:

Returns whether the given column is hidden by the user.

Boolean — true if the column is hidden, false otherwise.

Scripts that use this method require authorization with one or more of the following scopes:

Returns whether iterative calculation is activated in this spreadsheet.

Boolean — true if iterative calculation is activated, false otherwise.

Scripts that use this method require authorization with one or more of the following scopes:

Returns whether the given row is hidden by a filter (not a filter view).

Boolean — true if the row is hidden, false otherwise.

Scripts that use this method require authorization with one or more of the following scopes:

Returns whether the given row is hidden by the user.

Boolean — true if the row is hidden, false otherwise.

Scripts that use this method require authorization with one or more of the following scopes:

Moves the active sheet to the given position in the list of sheets. Throws an exception if the position is negative or greater than the number of sheets.

Scripts that use this method require authorization with one or more of the following scopes:

Creates a new SheetType.OBJECT sheet and moves the provided chart to it. If the chart is already on its own sheet, that sheet is returned without creating a new one.

Sheet — The sheet that the chart is on.

Scripts that use this method require authorization with one or more of the following scopes:

Refreshes all supported data sources and their linked data source objects, skipping invalid data source objects.

Use SpreadsheetApp#enable...Execution() methods to enable data execution for specific data source type.

Scripts that use this method require authorization with one or more of the following scopes:

Removes the given user from the list of editors for the Spreadsheet. This method doesn't block users from accessing the Spreadsheet if they belong to a class of users who have general access—for example, if the Spreadsheet is shared with the user's entire domain, or if the Spreadsheet is in a shared drive that the user can access.

For Drive files, this also removes the user from the list of viewers.

Spreadsheet — This Spreadsheet, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Removes the given user from the list of editors for the Spreadsheet. This method doesn't block users from accessing the Spreadsheet if they belong to a class of users who have general access—for example, if the Spreadsheet is shared with the user's entire domain, or if the Spreadsheet is in a shared drive that the user can access.

For Drive files, this also removes the user from the list of viewers.

Spreadsheet — This Spreadsheet, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Removes a menu that was added by addMenu(name, subMenus). The name argument should have the same value as the corresponding call to addMenu(name, subMenus).

Scripts that use this method require authorization with one or more of the following scopes:

Deletes a named range with the given name. Throws an exception if no range with the given name is found in the spreadsheet.

Scripts that use this method require authorization with one or more of the following scopes:

Removes the given user from the list of viewers and commenters for the Spreadsheet. This method has no effect if the user is an editor, not a viewer or commenter. This method also doesn't block users from accessing the Spreadsheet if they belong to a class of users who have general access—for example, if the Spreadsheet is shared with the user's entire domain, or if the Spreadsheet is in a shared drive that the user can access.

For Drive files, this also removes the user from the list of editors.

Spreadsheet — This Spreadsheet for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Removes the given user from the list of viewers and commenters for the Spreadsheet. This method has no effect if the user is an editor, not a viewer. This method also doesn't block users from accessing the Spreadsheet if they belong to a class of users who have general access—for example, if the Spreadsheet is shared with the user's entire domain, or if the Spreadsheet is in a shared drive that the user can access.

For Drive files, this also removes the user from the list of editors.

Spreadsheet — This Spreadsheet for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Renames the document.

Scripts that use this method require authorization with one or more of the following scopes:

Renames the current active sheet to the given new name.

Scripts that use this method require authorization with one or more of the following scopes:

Removes the applied theme and sets the default theme on the spreadsheet.

SpreadsheetTheme — The default theme.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the specified range as the active range in the active sheet, with the top left cell in the range as the current cell.

Range — The newly active range.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the specified list of ranges as the active ranges in the active sheet. The last range in the list is set as the active range.

RangeList — The newly selected list of ranges.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the active selection region for this sheet.

Range — The newly active range.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the active selection, as specified in A1 notation or R1C1 notation.

Range — The newly active range.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the given sheet to be the active sheet in the spreadsheet. The Google Sheets UI displays the chosen sheet unless the sheet belongs to a different spreadsheet.

Sheet — The active sheet.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the given sheet to be the active sheet in the spreadsheet, with an option to restore the most recent selection within that sheet. The Google Sheets UI displays the chosen sheet unless the sheet belongs to a different spreadsheet.

Sheet — The new active sheet.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the width of the given column in pixels.

Sheet — The sheet, useful for method chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the specified cell as the current cell.

If the specified cell is present in an already selected range, then that range becomes the active range with the cell as the current cell.

If the specified cell is not present in any selected range, then any existing selection is removed and the cell becomes the current cell and the active range.

Note:The specified Range must consist of one cell, otherwise it throws an exception.

Range — The newly set current cell.

Scripts that use this method require authorization with one or more of the following scopes:

Freezes the given number of columns. If zero, no columns are frozen.

Scripts that use this method require authorization with one or more of the following scopes:

Freezes the given number of rows. If zero, no rows are frozen.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the minimum threshold value for iterative calculation. When the results of successive calculation differ by less than this value, the iterative calculation stops. This value must be non-negative, and defaults to 0.05.

Spreadsheet — This spreadsheet, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets whether iterative calculation is activated in this spreadsheet. If the maximum number of calculation cycles and convergence threshold have not previously been set when the calculation is activated, they default to 50 and 0.05 respectively. If either has been set previously, they retain their previous values.

Spreadsheet — This spreadsheet, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the maximum number of calculation iterations that should be performed during iterative calculation. This value must be between 1 and 10,000 (inclusive), and defaults to 50.

Spreadsheet — This spreadsheet, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Scripts that use this method require authorization with one or more of the following scopes:

Sets how often this spreadsheet should recalculate.

Spreadsheet — This spreadsheet, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the row height of the given row in pixels. By default, rows grow to fit cell contents. If you want to force rows to a specified height, use Sheet.setRowHeightsForced(startRow, numRows, height).

Sheet — The sheet, useful for method chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the spreadsheet locale.

Scripts that use this method require authorization with one or more of the following scopes:

Sets a theme on the spreadsheet.

SpreadsheetTheme — The new current theme.

Scripts that use this method require authorization with one or more of the following scopes:

Sets the time zone for the spreadsheet.

Scripts that use this method require authorization with one or more of the following scopes:

Displays a custom user interface component in a dialog centered in the user's browser's viewport. The server-side script's execution is not suspended. To communicate with the server side, the user interface component must make asynchronous callbacks to the server-side script.

If the server-side script previously displayed a dialog that has not yet been dismissed, then the existing dialog is replaced with the newly requested dialog's user interface.

The following code snippet displays a simple HtmlService application in a dialog with the specified title, height, and width:

Scripts that use this method require authorization with one or more of the following scopes:

Sorts a sheet by column, ascending.

Sheet — The sheet, useful for method chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Sorts a sheet by column. Takes a parameter to specify ascending or descending.

Sheet — The sheet, useful for method chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Shows a popup window in the lower right corner of the spreadsheet with the given message.

Scripts that use this method require authorization with one or more of the following scopes:

Shows a popup window in the lower right corner of the spreadsheet with the given message and title.

Scripts that use this method require authorization with one or more of the following scopes:

Shows a popup window in the lower right corner of the spreadsheet with the given title and message, that stays visible for a certain length of time.

Scripts that use this method require authorization with one or more of the following scopes:

Unhides the column in the given range.

Scripts that use this method require authorization with one or more of the following scopes:

Unhides the row in the given range.

Scripts that use this method require authorization with one or more of the following scopes:

Updates a menu that was added by addMenu(name, subMenus). Works exactly like addMenu(name, subMenus).

Scripts that use this method require authorization with one or more of the following scopes:

Waits until all the current executions in the spreadsheet complete, timing out after the provided number of seconds. Throws an exception if the executions are not completed when timing out, but does not cancel the data executions.

Scripts that use this method require authorization with one or more of the following scopes:

Deprecated. For spreadsheets created in the newer version of Google Sheets, use Sheet.getProtections(type), which returns the more powerful Protection class. Although this method is deprecated, it remains available for compatibility with the older version of Sheets

Returns a PageProtection instance describing the permissions for the current sheet.

PageProtection — An object describing sheet access permissions.

Scripts that use this method require authorization with one or more of the following scopes:

Deprecated. As of January 2014 this function is deprecated and not available in the new version of Google Sheets.

Indicates whether the document allows anonymous viewing. As this is no longer supported in the new version of Google Sheets, use File.getSharingAccess() and File.getSharingPermission() instead.

Boolean — true if the document allows anonymous viewing, false otherwise.

Scripts that use this method require authorization with one or more of the following scopes:

Deprecated. As of January 2014 this function is deprecated and not available in the new version of Google Sheets.

Indicates whether the document allows edits from anonymous users. As this is no longer supported in the new version of Google Sheets, use File.getSharingAccess() and File.getSharingPermission() instead.

Boolean — true if the document allows anonymous editing, false otherwise.

Scripts that use this method require authorization with one or more of the following scopes:

Deprecated. As of January 2014 this function is deprecated and not available in the new version of Google Sheets.

Sets the document's policy on anonymous reading and writing. As this is no longer supported in the new version of Google Sheets, use File.setSharing(accessType, permissionType) as an alternative.

Scripts that use this method require authorization with one or more of the following scopes:

Deprecated. For spreadsheets created in the newer version of Google Sheets, use Sheet.protect(), which returns the more powerful Protection class. Although this method is deprecated, it remains available for compatibility with the older version of Sheets

Sets the permissions for the current sheet.

Scripts that use this method require authorization with one or more of the following scopes:

---

## Class Switch Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/card-service/switch

**Contents:**
- Class Switch Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
  - Methods
- Detailed documentation
  - setControlType(controlType)
    - Parameters
    - Return
  - setFieldName(fieldName)
    - Parameters
    - Return

A Switch is a UI element that can be toggled on or off and must be used within a DecoratedText widget.

Switches are available for Google Workspace add-ons and Google Chat apps.

Key methods for Switch include setting the control type, field name, on-change action, selected state, and value.

The setFieldName method is required and identifies the switch in the event object upon UI interaction.

The setValue method sets the string value sent as form input when the switch is toggled on.

A UI element that supports being toggled on or off. This can only be used within a DecoratedText widget.

Available for Google Workspace add-ons and Google Chat apps.

Sets the control type of the switch. Defaults to SWITCH.

Switch — This object, for chaining.

Sets the key that identifies this switch in the event object that is generated when there is a UI interaction. Not visible to the user. Required.

Unlike other form fields, this field name does not need to be unique. The form input values for switches using the same field name are returned as an array. The array consists of the values for all enabled switches with that field name.

Switch — This object, for chaining.

Sets the action to take when the switch is toggled.

Switch — This object, for chaining.

Sets whether this switch should start as selected or unselected.

Switch — This object, for chaining.

Sets the value that is sent as the form input when this switch is toggled on.

Switch — This object, for chaining.

---

## Class TextArea Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/data-studio/text-area

**Contents:**
- Class TextArea Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
  - Methods
- Detailed documentation
  - setAllowOverride(allowOverride)
    - Parameters
    - Return
  - setHelpText(helpText)
    - Parameters
    - Return

TextArea in Data Studio config controls how text input is displayed.

TextArea properties can be set using methods like setId, setName, setHelpText, setAllowOverride, and setPlaceholder.

The setAllowOverride method allows data source creators to enable overriding for report editors.

The setIsDynamic method, when set to true and modified, clears subsequent configuration entries.

All setting methods for TextArea return the TextArea object for method chaining.

Contains text area information for the config. Its properties determine how the text input is displayed in Data Studio.

Enables overriding for this config entry. If set to true, data source creators have the option to enable this for report editors.

TextArea — This builder, for chaining.

Sets the help text for this configuration entry.

TextArea — This builder, for chaining.

Sets the unique ID for this configuration entry.

TextArea — This builder, for chaining.

Sets the dynamic status for this configuration entry.

If a dynamic configuration entry is modified, subsequent configuration entries are cleared.

TextArea — This builder, for chaining.

Sets the display name for this configuration entry.

TextArea — This builder, for chaining.

Sets the placeholder text for this configuration entry.

TextArea — This builder, for chaining.

---

## Class TextFinder Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/spreadsheet/text-finder

**Contents:**
- Class TextFinder Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
  - Methods
- Detailed documentation
  - findAll()
    - Return
    - Authorization
  - findNext()
    - Return
    - Authorization

TextFinder is used to find or replace text within a range, sheet, or spreadsheet with customizable search options.

Key methods include finding all matches, navigating through matches, getting the current match, and replacing text.

Search behavior can be configured to ignore diacritics, match case, match entire cells, or search within formulas.

TextFinder allows starting a search from a specific range and supports using regular expressions.

Find or replace text within a range, sheet or spreadsheet. Can also specify search options.

Returns all cells matching the search criteria.

Range[] — All the matching cells.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the next cell matching the search criteria.

Range — The next matching cell, or null if there are no previous matches.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the previous cell matching the search criteria.

Range — The previous matching cell, or null if there are no previous matches.

Scripts that use this method require authorization with one or more of the following scopes:

Returns the current cell matching the search criteria.

Range — The current matching cell, or null if there are no further matches.

Scripts that use this method require authorization with one or more of the following scopes:

If true, configures the search to ignore diacritics while matching; otherwise the search matches diacritics. A diacritic is a sign, such as an accent or cedilla, which when written above or below a letter indicates a difference in pronunciation from the same letter when unmarked or differently marked.

TextFinder — This text finder, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

If true, configures the search to match the search text's case exactly, otherwise the search defaults to case-insensitive matching.

TextFinder — This text finder, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

If true, configures the search to match the entire contents of a cell; otherwise, the search defaults to partial matching.

TextFinder — This text finder, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

If true, configures the search to return matches that appear within formula text; otherwise cells with formulas are considered based on their displayed value.

TextFinder — This text finder, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

Replaces all matches with the specified text. Returns the number of occurrences replaced, which may be different from the number of matched cells.

Integer — The number of occurrences replaced.

Scripts that use this method require authorization with one or more of the following scopes:

Replaces the search text in the currently matched cell with the specified text and returns the number of occurrences replaced.

Integer — The number of occurrences replaced.

Scripts that use this method require authorization with one or more of the following scopes:

Configures the search to start searching immediately after the specified cell range.

TextFinder — This text finder, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

If true, configures the search to interpret the search string as a regular expression; otherwise the search interprets the search string as normal text. For more details on how to use regular expressions, refer to the Find and replace support page.

TextFinder — This text finder, for chaining.

Scripts that use this method require authorization with one or more of the following scopes:

---

## Class TextInput Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/data-studio/text-input

**Contents:**
- Class TextInput Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
  - Methods
- Detailed documentation
  - setAllowOverride(allowOverride)
    - Parameters
    - Return
  - setHelpText(helpText)
    - Parameters
    - Return

TextInput is used in Data Studio configurations to display text input fields.

Various methods like setAllowOverride, setHelpText, setId, setIsDynamic, setName, and setPlaceholder are available to configure the TextInput's properties.

These methods allow for setting unique IDs, display names, help text, placeholder text, overriding capabilities, and dynamic behavior for the text input field.

Contains text input information for the config. Its properties determine how the text input is displayed in Data Studio.

Enables overriding for this config entry. If set to true, data source creators have the option to enable this for report editors

TextInput — This builder, for chaining.

Sets the help text for this configuration entry.

TextInput — This builder, for chaining.

Sets the unique ID for this configuration entry.

TextInput — This builder, for chaining.

Sets the dynamic status for this configuration entry.

If a dynamic configuration entry is modified, subsequent configuration entries are cleared.

TextInput — This builder, for chaining.

Sets the display name for this configuration entry.

TextInput — This builder, for chaining.

Sets the placeholder text for this configuration entry.

TextInput — This builder, for chaining.

---

## Class TextStyleBuilder Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/spreadsheet/text-style-builder

**Contents:**
- Class TextStyleBuilder Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
  - Methods
- Detailed documentation
  - build()
    - Return
  - setBold(bold)
    - Parameters
    - Return
  - setFontFamily(fontFamily)

TextStyleBuilder is used to create text styles.

It provides methods to set properties like bold, italic, underline, strikethrough, font family, font size, and foreground color.

The build() method creates the final TextStyle object from the builder.

Most methods return the TextStyleBuilder itself, allowing for method chaining.

A builder for text styles.

Creates a text style from this builder.

TextStyle — A text style created from this builder.

Sets whether or not the text is bold.

TextStyleBuilder — The builder for chaining.

Sets the text font family, such as "Arial".

TextStyleBuilder — The builder for chaining.

Sets the text font size in points.

TextStyleBuilder — The builder for chaining.

Sets the text font color.

TextStyleBuilder — The builder for chaining.

Sets the text font color.

TextStyleBuilder — The builder for chaining.

Sets whether or not the text is italic.

TextStyleBuilder — The builder for chaining.

Sets whether or not the text has strikethrough.

TextStyleBuilder — The builder for chaining.

Sets whether or not the text is underlined.

TextStyleBuilder — The builder for chaining.

---

## Class TextStyle Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/spreadsheet/text-style

**Contents:**
- Class TextStyle Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
  - Methods
  - Deprecated methods
- Detailed documentation
  - copy()
    - Return
  - getFontFamily()
    - Return
  - getFontSize()

TextStyle defines the rendered style of text in a cell and can have a corresponding RichTextValue.

If a RichTextValue spans multiple text runs with different style values, a method attempting to read that style will return null.

To avoid getting null when querying text styles, use the RichTextValue.getRuns() method.

TextStyle provides methods to retrieve font properties like family, size, color, and boolean states for bold, italic, strikethrough, and underline.

The getForegroundColor() method is deprecated and has been replaced by getForegroundColorObject().

The rendered style of text in a cell.

Text styles can have a corresponding RichTextValue. If the RichTextValue spans multiple text runs that have different values for a given text style read method, the method returns null. To avoid this, query for text styles using the Rich Text values returned by the RichTextValue.getRuns() method.

Creates a text style builder initialized with the values of this text style.

TextStyleBuilder — A builder from this text style.

Gets the font family of the text. Returns null if the font family isn't set or the corresponding RichTextValue has multiple runs with different font families.

String — The font family of the text (for example, "Arial") or null.

Gets the font size of the text in points. Returns null if the font size isn't set or the corresponding RichTextValue has multiple runs with different font sizes.

Integer — The font size of the text or null.

Gets the font color of the text. Returns null if the font color isn't set or the corresponding RichTextValue has multiple runs with different font colors.

Color — The font color of the text or null.

Gets whether or not the text is bold. Returns null if bold isn't set or the corresponding RichTextValue has multiple runs with different bold settings.

Boolean — Whether or not the cell is bold, or null.

Gets whether or not the cell is italic. Returns null if italic isn't set or the corresponding RichTextValue has multiple runs with different italic settings.

Boolean — Whether or not the cell is italic, or null.

Gets whether or not the cell has strikethrough. Returns null if strikethrough isn't set or the corresponding RichTextValue has multiple runs with different strikethrough settings.

Boolean — Whether or not the cell has strikethrough, or null.

Gets whether or not the cell is underlined. Returns null if underline isn't set or the corresponding RichTextValue has multiple runs with different underline settings.

Boolean — Whether or not the cell is underlined, or null.

Deprecated. Replaced by getForegroundColorObject()

Gets the font color of the text. Returns null if the font color isn't set or the corresponding RichTextValue has multiple runs with different font colors.

String — The font color of the text as a hex CSS value (for example, "#ff0000") or null.

---

## Class ThemeColor Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/spreadsheet/theme-color

**Contents:**
- Class ThemeColor Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
  - Methods
- Detailed documentation
  - getColorType()
    - Return
    - Authorization
  - getThemeColorType()
    - Return
    - Authorization

ThemeColor represents a theme color.

It includes methods to get the color type and theme color type.

Both methods require specific authorization scopes.

A representation for a theme color.

Get the type of this color.

ColorType — The color type.

Scripts that use this method require authorization with one or more of the following scopes:

Gets the theme color type of this color.

ThemeColorType — The theme color type.

Scripts that use this method require authorization with one or more of the following scopes:

---

## Class TimePicker Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/card-service/time-picker

**Contents:**
- Class TimePicker Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
  - Methods
- Detailed documentation
  - setFieldName(fieldName)
    - Parameters
    - Return
  - setHours(hours)
    - Parameters
    - Return

TimePicker is an input field for users to input a time, available for Google Workspace add-ons and Google Chat apps.

Key methods include setting the field name, title, default hours and minutes, and an action to perform when the input changes.

The setFieldName method requires a unique name to identify the picker in UI interaction events.

setHours and setMinutes allow setting prefilled time values, which are represented as strings in form callback parameters.

setOnChangeAction allows associating a script action with changes made to the picker's input.

An input field that allows users to input a time.

Available for Google Workspace add-ons and Google Chat apps.

Sets the field name that identifies this picker in the event object that is generated when there is a UI interaction. The field name is visible to the user. Required; the specified field name must be unique.

TimePicker — This picker, for chaining.

Sets the prefilled hours value to set in the input field.

TimePicker — This picker, for chaining.

Sets the prefilled minutes value to set in the input field.

TimePicker — This picker, for chaining.

Sets an Action that the script performs whenever the picker input changes.

TimePicker — This picker, for chaining.

Sets the title displayed above the input field.

TimePicker — This picker, for chaining.

---

## Class Ui Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/base/ui

**Contents:**
- Class Ui Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
  - Properties
  - Methods
  - Deprecated methods
- Detailed documentation
  - alert(prompt)
    - Parameters
    - Return
  - alert(prompt, buttons)

The Ui object allows scripts to add UI elements like menus, dialogs, and sidebars to a Google App's user interface.

Scripts can only interact with the UI of the currently open editor if they are container-bound to that editor.

The Ui object provides methods to create alert boxes, input prompts, custom menus, modal and modeless dialogs, and sidebars.

Alert and prompt dialogs suspend the server-side script while open, while modal dialogs, modeless dialogs, and sidebars do not.

Buttons and ButtonSet are properties of the Ui object used to define and handle button responses in dialogs.

An instance of the user-interface environment for a Google App that allows the script to add features like menus, dialogs, and sidebars. A script can only interact with the UI for the current instance of an open editor, and only if the script is container-bound to the editor.

Opens a dialog box in the user's editor with the given message and an "OK" button. This method suspends the server-side script while the dialog is open. The script resumes after the user dismisses the dialog, but Jdbc connections and LockService locks don't persist across the suspension. For more information, see the guide to dialogs and sidebars.

Button — The button the user clicked.

Opens a dialog box in the user's editor with the given message and set of buttons. This method suspends the server-side script while the dialog is open. The script resumes after the user dismisses the dialog, but Jdbc connections and LockService locks don't persist across the suspension. For more information, see the guide to dialogs and sidebars.

Button — The button the user clicked.

Opens a dialog box in the user's editor with the given title, message, and set of buttons. This method suspends the server-side script while the dialog is open. The script resumes after the user dismisses the dialog, but Jdbc connections and LockService locks don't persist across the suspension. For more information, see the guide to dialogs and sidebars.

Button — The button the user clicked.

Creates a builder that can be used to insert a sub-menu into the editor's Extensions menu. The menu isn't actually be updated until Menu.addToUi() is called. If the script is running as an add-on, the sub-menu name matches the add-on's name in the web store; if the script is bound to the document directly, the sub-menu name matches the script's name. For more information, see the guide to menus.

Menu — The new menu builder.

Creates a builder that can be used to add a menu to the editor's user interface. The menu isn't actually be added until Menu.addToUi() is called. For more information, see the guide to menus. The label for a top-level menu should be in headline case (all major words capitalized), although the label for a sub-menu should be in sentence case (only the first word capitalized). If the script is published as an add-on, the caption parameter is ignored and the menu is added as a sub-menu of the Extensions menu, equivalent to createAddonMenu().

Menu — The new menu builder.

Opens an input dialog box in the user's editor with the given message and an "OK" button. This method suspends the server-side script while the dialog is open. The script resumes after the user dismisses the dialog, but Jdbc connections and LockService locks don't persist across the suspension. For more information, see the guide to dialogs and sidebars.

PromptResponse — A representation of the user's response.

Opens an input dialog box in the user's editor with the given message and set of buttons. This method suspends the server-side script while the dialog is open. The script resumes after the user dismisses the dialog, but Jdbc connections and LockService locks don't persist across the suspension. For more information, see the guide to dialogs and sidebars.

PromptResponse — A representation of the user's response.

Opens an input dialog box in the user's editor with the given title, message, and set of buttons. This method suspends the server-side script while the dialog is open. The script resumes after the user dismisses the dialog, but Jdbc connections and LockService locks don't persist across the suspension. For more information, see the guide to dialogs and sidebars.

PromptResponse — A representation of the user's response.

Opens a modal dialog box in the user's editor with custom client-side content. This method does not suspend the server-side script while the dialog is open. To communicate with the server-side script, the client-side component must make asynchronous callbacks using the google.script API for HtmlService. To close the dialog programmatically, call google.script.host.close() on the client side of an HtmlService web app. For more information, see the guide to dialogs and sidebars.

Modal dialogs prevent the user from interacting with anything other than the dialog. By contrast, modeless dialogs and sidebars let the user interact with the editor. In almost all cases, a modal dialog or sidebar is a better choice than a modeless dialog.

Scripts that use this method require authorization with one or more of the following scopes:

Opens a modeless dialog box in the user's editor with custom client-side content. This method does not suspend the server-side script while the dialog is open. To communicate with the server-side script, the client-side component must make asynchronous callbacks using the google.script API for HtmlService. To close the dialog programmatically, call google.script.host.close() on the client side of an HtmlService web app. For more information, see the guide to dialogs and sidebars.

Modeless dialogs let the user interact with the editor behind the dialog. By contrast, modal dialogs do not. In almost all cases, a modal dialog or sidebar is a better choice than a modeless dialog.

Scripts that use this method require authorization with one or more of the following scopes:

Opens a sidebar in the user's editor with custom client-side content. This method does not suspend the server-side script while the sidebar is open. To communicate with the server-side script, the client-side component must make asynchronous callbacks using the google.script API for HtmlService. To close the sidebar programmatically, call google.script.host.close() on the client side of an HtmlService web app. For more information, see the guide to dialogs and sidebars.

The sidebar displays on the right side of the editor for users whose environments use a left-to-right language and on the left side of the editor for right-to-left languages. All sidebars shown by scripts are 300 pixels wide.

Scripts that use this method require authorization with one or more of the following scopes:

Deprecated. As of March 2014, this method is deprecated. The direct replacement is showModelessDialog(userInterface, title), but showModalDialog(userInterface, title) is a better choice in almost all cases.

Opens a dialog box in the user's editor with custom client-side content. This method does not suspend the server-side script while the dialog is open. To communicate with the server-side script, the client-side component must make asynchronous callbacks using the google.script API for HtmlService. To close the dialog programmatically, call google.script.host.close() on the client side of an HtmlService web app. For more information, see the guide to dialogs and sidebars.

Scripts that use this method require authorization with one or more of the following scopes:

---

## Class UserError Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/data-studio/user-error

**Contents:**
- Class UserError Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
  - Methods
- Detailed documentation
  - printJson()
    - Return
  - setDebugText(text)
    - Parameters
    - Return
  - setText(text)

A UserError is an error shown to users of the connector.

You can set the text of the error shown to users and a different debug text shown only to admins.

The throwException() method is used to trigger the exception.

An error that is shown to users of the connector.

Prints the JSON representation of this object. This is for debugging only.

Sets the text of the debug error, which is only shown to admins.

UserError — This object, for chaining.

Sets the text of the user error.

UserError — This object, for chaining.

Triggers this exception to be thrown.

---

## Class Utilities Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/utilities/utilities

**Contents:**
- Class Utilities Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
  - Properties
  - Methods
  - Deprecated methods
- Detailed documentation
  - base64Decode(encoded)
    - Parameters
    - Return
  - base64Decode(encoded, charset)

The Utilities service in Apps Script provides various helper functions for common tasks like encoding, decoding, date formatting, and data manipulation.

It offers methods for base-64 encoding and decoding for both standard and web-safe formats with optional character set specification.

The service includes functions for computing message digests and HMAC/RSA signatures using various algorithms.

Utilities provides methods for formatting and parsing dates and strings, generating UUIDs, and creating or manipulating Blob objects for binary data.

Features for compressing and decompressing data using gzip and handling zip archives are also available.

This service provides utilities for string encoding/decoding, date formatting, JSON manipulation, and other miscellaneous tasks.

Decodes a base-64 encoded string into a UTF-8 byte array.

Byte[] — The raw data represented by the base-64 encoded argument as a byte array.

Decodes a base-64 encoded string into a byte array in a specific character set.

Byte[] — The raw data represented by the base-64 encoded argument as a byte array.

Decodes a base-64 web-safe encoded string into a UTF-8 byte array.

Byte[] — The raw data represented by the base-64 web-safe encoded argument as a byte array.

Decodes a base-64 web-safe encoded string into a byte array in a specific character set.

Byte[] — The raw data represented by the base-64 web-safe encoded argument as a byte array.

Generates a base-64 encoded string from the given byte array. Base 64 is a common encoding accepted by a variety of tools that cannot accept binary data. Base 64 is commonly used in internet protocols such as email, HTTP, or in XML documents.

String — The base-64 encoded representation of the passed in data.

Generates a base-64 encoded string from the given string. Base 64 is a common encoding accepted by a variety of tools that cannot accept binary data. Base 64 is commonly used in internet protocols such as email, HTTP, or in XML documents.

String — The base-64 encoded representation of the input string.

Generates a base-64 encoded string from the given string in a specific character set. A Charset is a way of encoding characters such that they can be encoded. These are typically done in a binary format, which can generally be incompatible with certain data transmission protocols. To make the data compatible, they are generally encoded into base 64, which is a common encoding accepted by a variety of tools that cannot accept binary data. Base 64 is commonly used in internet protocols such as email, HTTP, or in XML documents.

String — The base-64 encoded representation of the input string with the given Charset.

Generates a base-64 web-safe encoded string from the given byte array. Base 64 is a common encoding accepted by a variety of tools that cannot accept binary data. Base 64 web-safe is commonly used in internet protocols such as email, HTTP, or in XML documents.

String — The base-64 web-safe encoded representation of the passed in data.

Generates a base-64 web-safe encoded string from the given string. Base 64 is a common encoding accepted by a variety of tools that cannot accept binary data. Base 64 web-safe is commonly used in internet protocols such as email, HTTP, or in XML documents.

String — The base-64 web-safe encoded representation of the input string.

Generates a base-64 web-safe encoded string from the given string in a specific character set. A Charset is a way of encoding characters such that they can be encoded. These are typically done in a binary format, which can generally be incompatible with certain data transmission protocols. To make the data compatible, they are generally encoded into base 64, which is a common encoding accepted by a variety of tools that cannot accept binary data. Base 64 web-safe is commonly used in internet protocols such as email, HTTP, or in XML documents.

String — The base-64 web-safe encoded representation of the input string with the given Charset.

Compute a digest using the specified algorithm on the specified Byte[] value.

Byte[] — A byte[] representing the output digest.

Compute a digest using the specified algorithm on the specified String value.

Byte[] — A byte[] representing the output digest.

Compute a digest using the specified algorithm on the specified String value with the given character set.

Byte[] — A byte[] representing the output digest.

Signs the provided value using HMAC-SHA256 with the given key.

Byte[] — A byte[] representing the output signature.

Signs the provided value using HMAC-SHA256 with the given key.

Byte[] — A byte[] representing the output signature.

Signs the provided value using HMAC-SHA256 with the given key and character set.

Byte[] — A byte[] representing the output signature.

Compute a message authentication code using the specified algorithm on the specified key and value.

Byte[] — A byte[] representing the output signature.

Compute a message authentication code using the specified algorithm on the specified key and value.

Byte[] — A byte[] representing the output signature.

Compute a message authentication code using the specified algorithm on the specified key and value.

Byte[] — A byte[] representing the output signature.

Signs the provided value using RSA-SHA1 with the given key.

Byte[] — A byte[] representing the output signature.

Signs the provided value using RSA-SHA1 with the given key and charset.

Byte[] — A byte[] representing the output signature.

Signs the provided value using RSA-SHA256 with the given key.

Byte[] — A byte[] representing the output signature.

Signs the provided value using RSA-SHA256 with the given key.

Byte[] — A byte[] representing the output signature.

Signs the provided value using the specified RSA algorithm with the given key.

Byte[] — A byte[] representing the output signature.

Signs the provided value using the specified RSA algorithm with the given key and charset.

Byte[] — A byte[] representing the output signature.

Formats date according to specification described in Java SE SimpleDateFormat class. Please visit the specification at http://docs.oracle.com/javase/7/docs/api/java/text/SimpleDateFormat.html

String — The input date as a formatted string.

Performs sprintf-like string formatting using '%'-style format strings.

String — The formatted string.

Get a UUID as a string (equivalent to using the java.util.UUID.randomUUID() method). This identifier is not guaranteed to be unique across all time and space. As such, do not use in situations where guaranteed uniqueness is required.

String — A string representation of the UUID.

gzip-compresses the provided Blob data and returns it in a new Blob object.

Blob — A new Blob containing the compressed data.

gzip-compresses the provided Blob data and returns it in a new Blob object. This version of the method allows a filename to be specified.

Blob — A new Blob containing the compressed data.

Create a new Blob object from a byte array. Blobs are used in many Apps Script APIs that take binary data as input.

Blob — The newly created Blob.

Create a new Blob object from a byte array and content type. Blobs are used in many Apps Script APIs that take binary data as input.

Blob — The newly created Blob.

Create a new Blob object from a byte array, content type, and name. Blobs are used in many Apps Script APIs that take binary data as input.

Blob — The newly created Blob.

Create a new Blob object from a string. Blobs are used in many Apps Script APIs that take binary data as input.

Blob — The newly created Blob.

Create a new Blob object from a string and content type. Blobs are used in many Apps Script APIs that take binary data as input.

Blob — The newly created Blob.

Create a new Blob object from a string, content type, and name. Blobs are used in many Apps Script APIs that take binary data as input.

Blob — The newly created Blob.

Returns a tabular 2D array representation of a CSV string.

String[][] — A two-dimensional array containing the values in the CSV string.

Returns a tabular 2D array representation of a CSV string using a custom delimiter.

String[][] — A two-dimensional array containing the values in the CSV string.

Parses the provided string date according to the specification described in the Java Standard Edition SimpleDateFormat class. For more information, see the Java SimpleDateFormat class.

Date — The input string as a date.

Sleeps for specified number of milliseconds. Immediately puts the script to sleep for the specified number of milliseconds. The maximum allowed value is 300000 (or 5 minutes).

Uncompresses a Blob object and returns a Blob containing the uncompressed data.

Blob — A Blob representing the decompressed data.

Takes a Blob representing a zip file and returns its component files.

Blob[] — A Blob[] representing the component blobs, each named with the full path inside the zip.

Creates a new Blob object that is a zip file containing the data from the Blobs passed in.

Blob — A new blob containing the inputs as an archive.

Creates a new Blob object that is a zip file containing the data from the Blobs passed in. This version of the method allows a filename to be specified.

Blob — A new blob containing the inputs as an archive.

Deprecated. As of November 2013, replaced by JSON.parse()

Return an object corresponding to the JSON string passed in.

Object — A JavaScript object representation of the input.

Deprecated. As of November 2013, replaced by JSON.stringify()

Return a JSON string of the object passed in.

String — a JSON serialized JavaScript object

---

## Conference Data Service Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/conference-data

**Contents:**
- Conference Data Service Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
- Classes
- ConferenceData
  - Methods
- ConferenceDataBuilder
  - Methods
- ConferenceDataService
  - Properties
  - Methods

The Conference Data service allows scripts to configure conferencing data objects that interact with Google Calendar.

This service is primarily used with Calendar conferencing add-ons or Google Workspace add-ons that connect to third-party conferencing systems.

The service provides classes for managing conference data, handling errors, and defining entry points for joining conferences.

Key classes include ConferenceData, ConferenceDataBuilder, and ConferenceDataService.

Enumerations are available for defining conference error types, entry point features, and entry point types.

This service allows scripts to configure and build conferencing data objects that interact with Google Calendar.

---

## Contacts Service Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/contacts

**Contents:**
- Contacts Service Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
- Classes
- AddressField
  - Methods
- CompanyField
- Contact
- ContactGroup
- ContactsApp
- CustomField

The Contacts service is deprecated and users should instead use the People API advanced service.

This service allows scripts to access and modify Google Contacts for both individuals and groups.

The documentation lists various classes related to contacts and their fields, such as AddressField, CompanyField, Contact, and ContactGroup.

Several methods are documented for accessing and modifying information within these contact field classes, such as getAddress(), getLabel(), setAddress(), and setLabel().

Deprecated. Instead, use the People API advanced service

This service allows scripts to access and modify Google Contacts, both for individual contacts and for groups.

---

## Container-bound Scripts Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/scripts_containers

**Contents:**
- Container-bound Scripts Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
- Create a bound script
  - Google Docs, Sheets, or Slides
  - Google Forms
- Special methods
- Custom menus, dialogs, and sidebars
- Triggers
- Custom functions
- Access to bound scripts

A bound script is attached to a specific Google Sheets, Docs, Slides, or Forms file, called its container.

Bound scripts behave similarly to standalone scripts but do not appear in Google Drive and cannot be detached from their container.

Bound scripts have special privileges, including the ability to refer to their parent file without its ID and interact with the parent file's user interface to add custom menus, dialogs, and sidebars.

Bound scripts can be created from within the Google Docs, Sheets, Slides, or Forms file they will be bound to.

Bound scripts can use simple and installable triggers, and in Google Sheets, they can be used to create custom functions.

A script is bound to a Google Sheets, Docs, Slides, or Forms file if it was created from that document rather than as a standalone script. The file that a bound script is attached to is called a "container." Bound scripts generally behave like standalone scripts except that they do not appear in Google Drive, they cannot be detached from the file they are bound to, and they gain a few special privileges over the parent file.

Note that scripts can also be bound to Google Sites, but these scripts are almost always deployed as web apps. Scripts bound to Google Sheets, Docs, Slides, or Forms can also become web apps, although this is uncommon.

To create a bound script in Google Docs, Sheets, or Slides, open a document in Docs, a spreadsheet in Sheets, or a presentation in Slides and click Extensions > Apps Script. To reopen the script in the future, do the same thing or open the script from the Apps Script dashboard.

To create a bound script in Google Forms, open a form and click More more_vert > Script editor. To reopen the script in the future, do the same thing or open the script from the Apps Script dashboard.

Bound scripts can call a few methods that standalone scripts cannot:

For more information, see the guide to extending Google Sheets or the guide to extending Google Docs.

Bound scripts can customize Google Sheets, Docs, and Forms by adding custom menus and dialog boxes or sidebars. Keep in mind, however, that a script can only interact with the user interface for the current instance of an open file. That is, a script bound to one document cannot affect the user interface of another document.

Bound scripts can use simple triggers like the special onOpen() function, which runs automatically whenever a file is opened by a user who has edit access. Like all types of scripts, they can also use installable triggers.

A custom function is a function in a script bound to Google Sheets that you call directly from a cell using the syntax =myFunctionName(). Custom functions are thus similar to the hundreds of built-in functions in Sheets like AVERAGE or SUM except that you define the custom function's behavior.

Only users who have permission to edit a container can run its bound script. Collaborators who have only view access can't open the script editor, although if they make a copy of the container file, they become the owner of the copy and can see and run a copy of the script.

To learn how to share a script's container file, refer to Share files from Google Drive.

---

## Create and manage deployments Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/concepts/deployments

**Contents:**
- Create and manage deployments Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
- Head deployments
- Versioned deployments
- Create a versioned deployment
- View versioned deployments
- Edit a versioned deployment
- Find a deployment ID
- Test a deployment
- Archive a versioned deployment

Apps Script project deployments make script versions available for use as web apps, add-ons, or API executables.

There are two types of deployments: Head deployments, which are always synced to the current project code and used for testing, and Versioned deployments, which are connected to a specific project version and used for public consumption.

You can create, view, edit, and find the ID of versioned deployments through the Deploy > Manage deployments menu in your Apps Script project.

You can test deployments differently depending on the type of app you build, with specific instructions for Google Workspace add-ons, Editor add-ons, web apps, Google Chat apps, and API Executables.

Versioned deployments cannot be deleted but can be archived and redeployed through the Deploy > Manage deployments menu.

An Apps Script project deployment is a version of the script that is made available for use as a web app, add-on, or API executable. By creating and managing deployments, you can iterate on your code, keep track of your changes, and control the exact code version your users have access to.

There are two types of deployments:

A head deployment is the current project code. When you create an Apps Script project, you automatically create a head deployment for that project.

The head deployment is always in sync with most recently saved code. For example, if you create a versioned deployment and then modify your code, the head deployment reflects those changes, while the versioned deployment remains intact.

Use head deployments to test code. Don't use head deployments for public use.

A versioned deployment makes a specific version of the project code available. This lets your users continue to use a functioning version while you make changes and improvements to the code.

When your application is published for public consumption, always use a versioned deployment. You can have multiple active versioned deployments at one time.

Important: You can't transfer ownership of versioned deployments. If you transfer ownership of a script project to someone, the owner of the existing versioned deployments within the project doesn't change. If an administrator deletes the deployment owner's account, you might experience script errors for their deployments.

To deploy a version of a Google Workspace add-on, Editor add-on, Google Chat app, or an API executable, you must first switch your Apps Script’s Google Cloud project association from the default project to a standard project.

To create a versioned deployment, follow these steps:

Enter the information about your deployment and click Deploy.

To view the deployments of an Apps Script project, at the top, click Deploy > Manage deployments.

To view the code of a specific version, refer to View a previous version.

You can edit a versioned deployment to change its description or version. To edit a deployment, follow these steps:

Make your changes and click Deploy.

If you want to edit an archived deployment, you must redeploy it, then follow the preceding steps.

When you want to deploy a change to the project code, create a new version and edit the deployment to use it. The new version is automatically used by any users that use that deployment.

Every deployment has an associated string ID automatically created for it. To find this ID, follow the steps below:

Select an active deployment to find its ID.

Deployment IDs only appear on active deployments.

How you test a deployment depends on the type of app you build.

Google Workspace add-on

To test a Google Workspace add-on deployment, see Testing Google Workspace add-ons.

To test an Editor add-on deployment, see Test an Editor add-on.

To test a web app deployment, see Test a web app deployment.

To test a Chat app deployment, you must first create a versioned deployment of the script to access its deployment ID.

After you have the deployment ID, specify the ID in the Chat API configuration and follow the steps to test interactive features.

To test an API executable deployment, you must first create a versioned deployment. After you create a deployment, follow the steps below: At the top right of the Apps Script project, click Deploy > Test Deployments. Next to ”Select type,” click Enable deployment types > API Executable. Copy and use the URL to test your API Executable deployment.

You can't delete versioned deployments. Instead, you can archive them.

To archive a versioned deployment:

---

## Create third-party resources from the @ menu Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/add-ons/editors/gsao/create-insert-resource-smart-chip

**Contents:**
- Create third-party resources from the @ menu Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
- How users create resources
- Prerequisites
  - Apps Script
  - Node.js
  - Python
  - Java
- Set up resource creation for your add-on
  - Configure resource creation

This guide details building a Google Workspace add-on to create and manage external resources (like support cases) directly within Google Docs.

Users can create resources via a form within Docs, which then inserts a smart chip linking to the resource in the external service.

The add-on requires configuration in the manifest file and utilizes Apps Script, Node.js, Python, or Java for development.

Comprehensive code samples are provided to guide developers through card creation, form submission, and error handling.

Smart chips representing the created resources offer link previews, enhancing user experience and information access.

This page explains how to build a Google Workspace add-on that lets Google Docs users create resources, such as a support case or project task, in a third-party service from within Google Docs.

With a Google Workspace add-on, you can add your service to the @ menu in Docs. The add-on adds menu items that let users create resources in your service through a form dialog in Docs.

To create a resource in your service from within a Google Docs document, users type @ in a document and select your service from the @ menu:

When users type @ in a document and select your service, you present them with a card that includes the form inputs that users need in order to create a resource. After the user submits the resource creation form, your add-on should create the resource in your service and generate a URL that points to it.

The add-on inserts a chip into the document for the created resource. When users hold the pointer over this chip, it invokes the add-on's associated link preview trigger. Make sure your add-on inserts chips with link patterns that are supported by your link preview triggers.

This section explains how to set up resource creation for your add-on, which includes the following steps:

To configure resource creation, specify the following sections and fields in your add-on's manifest:

Under the addOns section in the docs field, implement the createActionTriggers trigger that includes a runFunction. (You define this function in the following section, Build the form cards.)

To learn about what fields you can specify in the createActionTriggers trigger, see the reference documentation for Apps Script manifests or deployment resources for other runtimes.

In the oauthScopes field, add the scope https://www.googleapis.com/auth/workspace.linkcreate so that users can authorize the add-on to create resources. Specifically, this scope allows the add-on to read the information that users submit to the resource creation form and insert a smart chip into the document based on that information.

As an example, see the addons section of a manifest that configures resource creation for the following support case service:

In the example, the Google Workspace add-on lets users create support cases. Each createActionTriggers trigger must have the following fields:

To create resources in your service from the Docs @ menu, you must implement any functions that you specified in the createActionTriggers object.

When a user interacts with one of your menu items, the corresponding createActionTriggers trigger fires and its callback function presents a card with form inputs for creating the resource.

To create the card interface, you use widgets to display information and inputs that users need in order to create the resource. Most Google Workspace add-on widgets and actions are supported with the following exceptions:

The following example shows an Apps Script callback function that displays a card when a user selects Create support case from the @ menu:

The createCaseInputCard function renders the following card:

The card includes text inputs, a drop-down menu, and a checkbox. It also has a text button with anonClick action that runs another function to handle the submission of the creation form.

After the user fills out the form and clicks Create, the add-on sends the form inputs to theonClick action function–called submitCaseCreationForm in our example–at which point the add-on can validate the inputs and use them to create the resource in the third-party service.

After a user submits the creation form, the function associated with the onClick action runs. For an ideal user experience, your add-on should handle both successful and erroneous form submissions.

The onClick function of your add-on should create the resource in your third-party service and generate a URL that points to it.

In order to communicate the resource's URL back to Docs for chip creation, the onClick function should return a SubmitFormResponse with a one-element array in renderActions.action.links that points to a link. The link title should represent the title of the created resource and the URL should point to that resource.

The following example shows a SubmitFormResponse for a created resource:

After the SubmitFormResponse is returned, the modal dialog closes and the add-on inserts a chip into the document. When users hold the pointer over this chip, it invokes the associated link preview trigger. Make sure your add-on doesn't insert chips with link patterns not supported by your link preview triggers.

If a user tries to submit a form with invalid fields, instead of returning a SubmitFormResponse with a link, the add-on should return a render action that displays an error using an updateCard navigation. This lets the user see what they did wrong and try again. See updateCard(card) for Apps Script and updateCard for other runtimes. Notifications and pushCard navigations aren't supported.

The following example shows the code that's invoked when a user submits the form. If the inputs are invalid, the card updates and shows error messages. If the inputs are valid, the add-on returns a SubmitFormResponse with a link to the created resource.

The following code sample validates the form inputs and creates error messages for invalid inputs:

The following example shows a Google Workspace add-on that previews links to a company's support cases and lets users create support cases from within Google Docs.

The example does the following:

The following code shows how to implement a link preview for the created resource: python/3p-resources/create_link_preview/main.py View on GitHub # Copyright 2023 Google LLC # # Licensed under the Apache License, Version 2.0 (the "License") # you may not use this file except in compliance with the License. # You may obtain a copy of the License at # # https:#www.apache.org/licenses/LICENSE-2.0 # # Unless required by applicable law or agreed to in writing, software # distributed under the License is distributed on an "AS IS" BASIS, # WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. # See the License for the specific language governing permissions and # limitations under the License. from typing import Any, Mapping from urllib.parse import urlparse, parse_qs import flask import functions_framework @functions_framework.http def create_link_preview(req: flask.Request): """Responds to any HTTP request related to link previews. Args: req: An HTTP request context. Returns: An HTTP response context. """ event = req.get_json(silent=True) if event["docs"]["matchedUrl"]["url"]: url = event["docs"]["matchedUrl"]["url"] parsed_url = urlparse(url) # If the event object URL matches a specified pattern for preview links. if parsed_url.hostname == "example.com": if parsed_url.path.startswith("/support/cases/"): return case_link_preview(parsed_url) return {} def case_link_preview(url): """A support case link preview. Args: url: A matching URL. Returns: The resulting preview link card. """ # Parses the URL and identify the case details. query_string = parse_qs(url.query) name = f'Case {query_string["name"][0]}' # Uses the text from the card's header for the title of the smart chip. return { "action": { "linkPreview": { "title": name, "previewCard": { "header": { "title": name }, "sections": [{ "widgets": [{ "textParagraph": { "text": query_string["description"][0] } }] }], } } } }

The following code shows how to implement a link preview for the created resource: java/3p-resources/src/main/java/CreateLinkPreview.java View on GitHub /** * Copyright 2024 Google LLC * * Licensed under the Apache License, Version 2.0 (the "License"); * you may not use this file except in compliance with the License. * You may obtain a copy of the License at * * https://www.apache.org/licenses/LICENSE-2.0 * * Unless required by applicable law or agreed to in writing, software * distributed under the License is distributed on an "AS IS" BASIS, * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. * See the License for the specific language governing permissions and * limitations under the License. */ import com.google.cloud.functions.HttpFunction; import com.google.cloud.functions.HttpRequest; import com.google.cloud.functions.HttpResponse; import com.google.gson.Gson; import com.google.gson.JsonArray; import com.google.gson.JsonObject; import com.google.gson.JsonPrimitive; import java.io.UnsupportedEncodingException; import java.net.URL; import java.net.URLDecoder; import java.util.HashMap; import java.util.Map; public class CreateLinkPreview implements HttpFunction { private static final Gson gson = new Gson(); /** * Responds to any HTTP request related to link previews. * * @param request An HTTP request context. * @param response An HTTP response context. */ @Override public void service(HttpRequest request, HttpResponse response) throws Exception { JsonObject event = gson.fromJson(request.getReader(), JsonObject.class); String url = event.getAsJsonObject("docs") .getAsJsonObject("matchedUrl") .get("url") .getAsString(); URL parsedURL = new URL(url); // If the event object URL matches a specified pattern for preview links. if ("example.com".equals(parsedURL.getHost())) { if (parsedURL.getPath().startsWith("/support/cases/")) { response.getWriter().write(gson.toJson(caseLinkPreview(parsedURL))); return; } } response.getWriter().write("{}"); } /** * A support case link preview. * * @param url A matching URL. * @return The resulting preview link card. */ JsonObject caseLinkPreview(URL url) throws UnsupportedEncodingException { // Parses the URL and identify the case details. Map<String, String> caseDetails = new HashMap<String, String>(); for (String pair : url.getQuery().split("&")) { caseDetails.put(URLDecoder.decode(pair.split("=")[0], "UTF-8"), URLDecoder.decode(pair.split("=")[1], "UTF-8")); } // Builds a preview card with the case name, and description // Uses the text from the card's header for the title of the smart chip. JsonObject cardHeader = new JsonObject(); String caseName = String.format("Case %s", caseDetails.get("name")); cardHeader.add("title", new JsonPrimitive(caseName)); JsonObject textParagraph = new JsonObject(); textParagraph.add("text", new JsonPrimitive(caseDetails.get("description"))); JsonObject widget = new JsonObject(); widget.add("textParagraph", textParagraph); JsonArray widgets = new JsonArray(); widgets.add(widget); JsonObject section = new JsonObject(); section.add("widgets", widgets); JsonArray sections = new JsonArray(); sections.add(section); JsonObject previewCard = new JsonObject(); previewCard.add("header", cardHeader); previewCard.add("sections", sections); JsonObject linkPreview = new JsonObject(); linkPreview.add("title", new JsonPrimitive(caseName)); linkPreview.add("previewCard", previewCard); JsonObject action = new JsonObject(); action.add("linkPreview", linkPreview); JsonObject renderActions = new JsonObject(); renderActions.add("action", action); return renderActions; } }

**Examples:**

Example 1 (unknown):
```unknown
{
  "oauthScopes": [
    "https://www.googleapis.com/auth/workspace.linkpreview",
    "https://www.googleapis.com/auth/workspace.linkcreate"
  ],
  "addOns": {
    "docs": {
      "linkPreviewTriggers": [
        ...
      ],
      "createActionTriggers": [
        {
          "id": "createCase",
          "labelText": "Create support case",
          "localizedLabelText": {
            "es": "Crear caso de soporte"
          },
          "runFunction": "createCaseInputCard",
          "logoUrl": "https://www.example.com/images/case.png"
        }
      ]
    }
  }
}
```

---

## Custom Functions in Google Sheets Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/execution_custom_functions

**Contents:**
- Custom Functions in Google Sheets Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
- Getting started
  - Creating a custom function
  - Getting a custom function from the Google Workspace Marketplace
  - Using a custom function
- Guidelines for custom functions
  - Naming
  - Arguments
  - Return values

Google Sheets allows creating custom functions using Google Apps Script in JavaScript to extend built-in functionalities.

To create a custom function, write JavaScript code in the script editor accessed through the Extensions menu in Google Sheets.

Custom functions can take arguments, return values, and work with various data types supported by JavaScript.

Custom functions can be shared by copying the script to other spreadsheets or publishing them as add-ons.

Optimizing custom functions by processing ranges as arrays can significantly improve performance for large datasets.

Google Sheets offers hundreds of built-in functions like AVERAGE, SUM, and VLOOKUP. When these aren’t enough for your needs, you can use Google Apps Script to write custom functions — say, to convert meters to miles or fetch live content from the Internet — then use them in Google Sheets just like a built-in function.

Custom functions are created using standard JavaScript. If you're new to JavaScript, Codecademy offers a great course for beginners. (Note: this course wasn't developed by and isn't associated with Google.)

Here's a simple custom function, named DOUBLE, which multiplies an input value by 2:

If you don't know how to write JavaScript and don't have time to learn, check the add-on store to see whether someone else has already built the custom function you need.

To write a custom function:

Now you can use the custom function.

The Google Workspace Marketplace offers several custom functions as add-ons for Google Sheets. To use or explore these add-ons:

Once you've written a custom function or installed one from the Google Workspace Marketplace, it's as easy to use as a built-in function:

Before writing your own custom function, there are a few guidelines to know.

In addition to the standard conventions for naming JavaScript functions, be aware of the following:

Like a built-in function, a custom function can take arguments as input values:

If you call your function with a reference to a range of cells as an argument (like =DOUBLE(A1:B10)), the argument will be a two-dimensional array of the cells' values. For example, in the screenshot below, the arguments in =DOUBLE(A1:B2) are interpreted by Apps Script as double([[1,3],[2,4]]). Note that the sample code for DOUBLE from above would need to be modified to accept an array as input.

Custom function arguments must be deterministic. That is, built-in spreadsheet functions that return a different result each time they calculate — such as NOW() or RAND() — are not allowed as arguments to a custom function. If a custom function tries to return a value based on one of these volatile built-in functions, it will display Loading... indefinitely.

Every custom function must return a value to display, such that:

Google Sheets stores data in different formats depending on the nature of the data. When these values are used in custom functions, Apps Script treats them as the appropriate data type in JavaScript. These are the most common areas of confusion:

Google Sheets supports autocomplete for custom functions much like for built-in functions. As you type a function name in a cell, you will see a list of built-in and custom functions that matches what you enter.

Custom functions will appear in this list if their script includes a JsDoc @customfunction tag, as in the DOUBLE() example below.

Custom functions can call certain Google Apps Script services to perform more complex tasks. For example, a custom function can call the Language service to translate an English phrase into Spanish.

Unlike most other types of Apps Scripts, custom functions never ask users to authorize access to personal data. Consequently, they can only call services that do not have access to personal data, specifically the following:

If your custom function throws the error message You do not have permission to call X service., the service requires user authorization and thus cannot be used in a custom function.

To use a service other than those listed above, create a custom menu that runs an Apps Script function instead of writing a custom function. A function that is triggered from a menu will ask the user for authorization if necessary and can consequently use all Apps Script services.

Custom functions start out bound to the spreadsheet they were created in. This means that a custom function written in one spreadsheet can't be used in other spreadsheets unless you use one of the following methods:

Each time a custom function is used in a spreadsheet, Google Sheets makes a separate call to the Apps Script server. If your spreadsheet contains dozens (or hundreds, or thousands!) of custom function calls, this process can be quite slow. Some projects with many or complex custom functions might experience a temporary delay in executions.

Consequently, if you plan to use a custom function multiple times on a large range of data, consider modifying the function so that it accepts a range as input in the form of a two-dimensional array, then returns a two-dimensional array that can overflow into the appropriate cells.

For example, the DOUBLE() function shown above can be rewritten to accept a single cell or range of cells as follows:

The above approach uses the map method of JavaScript's Array object to method on the two-dimensional array of cells to get each row, then for each row, it uses map again to return double each cell's value. It returns a two-dimensional array that contains the results. This way, you can call DOUBLE just once but have it calculate for a large number of cells at once, as shown in the screenshot below. (You could accomplish the same thing with nested if statements instead of the map call.)

Similarly, the custom function below efficiently fetches live content from the Internet and uses a two-dimensional array to display two columns of results with just a single function call. If each cell required its own function call, the operation would take considerably more time, since the Apps Script server would have to download and parse the XML feed each time.

These techniques can be applied to nearly any custom function that is used repeatedly throughout a spreadsheet, although the implementation details will vary depending on the function's behavior.

**Examples:**

Example 1 (unknown):
```unknown
/**
 * Multiplies an input value by 2.
 * @param {number} input The number to double.
 * @return The input multiplied by 2.
 * @customfunction
*/
function DOUBLE(input) {
  return input * 2;
}
```

Example 2 (unknown):
```unknown
/**
 * Multiplies the input value by 2.
 *
 * @param {number} input The value to multiply.
 * @return The input multiplied by 2.
 * @customfunction
 */
function DOUBLE(input) {
  return input * 2;
}
```

Example 3 (javascript):
```javascript
/**
 * Multiplies the input value by 2.
 *
 * @param {number|Array<Array<number>>} input The value or range of cells
 *     to multiply.
 * @return The input multiplied by 2.
 * @customfunction
 */
function DOUBLE(input) {
  return Array.isArray(input) ?
      input.map(row => row.map(cell => cell * 2)) :
      input * 2;
}
```

Example 4 (unknown):
```unknown
/**
 * Show the title and date for the first page of posts on the
 * Developer blog.
 *
 * @return Two columns of data representing posts on the
 *     Developer blog.
 * @customfunction
 */
function getBlogPosts() {
  var array = [];
  var url = 'https://gsuite-developers.googleblog.com/atom.xml';
  var xml = UrlFetchApp.fetch(url).getContentText();
  var document = XmlService.parse(xml);
  var root = document.getRootElement();
  var atom = XmlService.getNamespace('http://www.w3.org/2005/Atom');
  var entries = document.getRootElement().getChildren('entry', atom);
  for (var i = 0; i < entries.length; i++) {
    var title = entries[i].getChild('title', atom).getText();
    var date = entries[i].getChild('published', atom).getValue();
    array.push([title, date]);
  }
  return array;
}
```

---

## Data Studio Service Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/data-studio

**Contents:**
- Data Studio Service Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
- Classes
- AggregationType
  - Properties
- AuthType
  - Properties
- BigQueryConfig
  - Methods
- BigQueryParameterType

The Data Studio service allows scripts to access and modify Data Studio Community Connectors.

It provides classes and methods for interacting with various aspects of Data Studio connectors, including configuration, fields, authentication, and data retrieval.

Enums are defined for aggregation types, authentication types, BigQuery parameter types, and field types.

Builders are available for creating responses for authentication type, data, schema, and set credentials requests.

Error handling can be implemented using DebugError for admin-only errors and UserError for errors visible to users.

This service allows scripts to access and modify Data Studio Community Connectors.

---

## Document Service Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/document

**Contents:**
- Document Service Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
- Classes
- Attribute
  - Properties
- Body
  - Methods
- Bookmark
  - Methods
- ContainerElement

The Google Apps Script Document service allows programmatic creation, access, and modification of Google Docs files.

DocumentApp is the main class for creating and opening documents, while the Document class manages the document as a whole.

The service provides numerous classes to represent document elements, such as Body, Paragraph, Table, and Text, each with methods for manipulation.

Attributes like font size, color, and alignment can be controlled using the Attribute enumeration.

The Element class serves as a base for all document components, offering general methods for accessing properties and navigating the document structure.

This service allows scripts to create, access, and modify Google Docs files.

**Examples:**

Example 1 (unknown):
```unknown
// Open a document by ID.
var doc = DocumentApp.openById('DOCUMENT_ID');

// Create and open a document.
doc = DocumentApp.create('Document Name');
```

---

## Drive Service Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/drive

**Contents:**
- Drive Service Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
- Classes
- Access
  - Properties
- DriveApp
  - Properties
  - Methods
- File
  - Methods

The Drive service in Apps Script allows scripts to manage files and folders in Google Drive.

For enhanced features, including shared drive access, use the advanced Drive service.

If using a standard Cloud project, the Drive API must be manually enabled.

Google Workspace Administrators can disable the Drive SDK, affecting script access unless the add-on is domain-wide installed or the client is allowlisted.

This service lets scripts create, find, and modify files and folders in Google Drive. Although the built-in Drive service is easier to use, it has some limitations. For the most up-to-date features and support, and to access files or folders in shared drives, use the advanced Drive service.

If your script uses a standard Cloud project instead of a default Cloud project, you must manually turn on the Drive API. In your standard Cloud project, turn on the Drive API:

Turn on the Drive API

Note: Google Workspace Administrators can turn off the Drive SDK for their domain, which prevents their users from installing and using Google Drive apps. This setting also prevents users from using Apps Script scripts, web apps and add-ons that use the Drive service or Advanced Drive Service (even if the add-on or web app was installed before the admin turned off the Drive SDK).

However, if an add-on using the Drive service is published for domain-wide installation and is installed by the administrator for some or all users in the domain, or any script that has its OAuth client allowlisted by the domain administrator, the add-on functions for those users even if the Drive SDK is turned off in the domain.

**Examples:**

Example 1 (unknown):
```unknown
// Logs the name of every file in the user's Drive.
var files = DriveApp.getFiles();
while (files.hasNext()) {
  var file = files.next();
  console.log(file.getName());
}
```

---

## Enum AuthType Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/data-studio/auth-type

**Contents:**
- Enum AuthType Stay organized with collections Save and categorize content based on your preferences.
  - Properties

An enum that defines the authentication types that can be set for a connector.

To call an enum, you call its parent class, name, and property. For example, DataStudioApp.AuthType.OAUTH2.

---

## Enum BigQueryParameterType Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/data-studio/big-query-parameter-type

**Contents:**
- Enum BigQueryParameterType Stay organized with collections Save and categorize content based on your preferences.
  - Properties

An enum that defines the BigQuery parameter types that you can set.

To call an enum, you call its parent class, name, and property. For example, DataStudioApp.BigQueryParameterType.STRING.

---

## Enum DataExecutionErrorCode Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/spreadsheet/data-execution-error-code

**Contents:**
- Enum DataExecutionErrorCode Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
  - Properties

DataExecutionErrorCode is an enumeration of data execution error codes.

You call an enum by calling its parent class, name, and property, like SpreadsheetApp.DataExecutionErrorCode.TIME_OUT.

The available properties represent different types of data execution errors, such as timeout, too many rows/columns/cells, engine errors, invalid parameters, unsupported data types, duplicate column names, interruptions, and permission denied.

An enumeration of data execution error codes.

To call an enum, you call its parent class, name, and property. For example, SpreadsheetApp.DataExecutionErrorCode.TIME_OUT.

For BigQuery, ARRAY or STRUCT type is not supported.

---

## Enum DataExecutionState Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/spreadsheet/data-execution-state

**Contents:**
- Enum DataExecutionState Stay organized with collections Save and categorize content based on your preferences.
  - Properties

An enumeration of data execution states.

To call an enum, you call its parent class, name, and property. For example, SpreadsheetApp.DataExecutionState.RUNNING.

---

## Enum DataSourceParameterType Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/spreadsheet/data-source-parameter-type

**Contents:**
- Enum DataSourceParameterType Stay organized with collections Save and categorize content based on your preferences.
  - Properties

An enumeration of data source parameter types.

To call an enum, you call its parent class, name, and property. For example, SpreadsheetApp.DataSourceParameterType.CELL.

---

## Enum DataSourceType Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/spreadsheet/data-source-type

**Contents:**
- Enum DataSourceType Stay organized with collections Save and categorize content based on your preferences.
  - Properties

An enumeration of data source types.

To call an enum, you call its parent class, name, and property. For example, SpreadsheetApp.DataSourceType.BIGQUERY.

---

## Enum DisplayStyle Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/card-service/display-style

**Contents:**
- Enum DisplayStyle Stay organized with collections Save and categorize content based on your preferences.
  - Properties

An enum that defines the display style of card.

DisplayStyle.REPLACE means that the card is shown by replacing the view of top card in the card stack.

DisplayStyle.PEEK mean that the header of the card appears at the bottom of the sidebar, partially covering the current top card of the stack. Clicking the header pops the card into the card stack. If the card has no header, a generated header is used instead.

DisplayStyle only works for card returned from contextual trigger function.

To call an enum, you call its parent class, name, and property. For example, CardService.DisplayStyle.PEEK.

---

## Enum EventTransparency Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/calendar/event-transparency

**Contents:**
- Enum EventTransparency Stay organized with collections Save and categorize content based on your preferences.
  - Properties

An enum representing the transparency of an event.

To call an enum, you call its parent class, name, and property. For example, CalendarApp.EventTransparency.OPAQUE.

---

## Enum EventType Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/calendar/event-type

**Contents:**
- Enum EventType Stay organized with collections Save and categorize content based on your preferences.
  - Properties

An enum representing the type of an event.

To call an enum, you call its parent class, name, and property. For example, CalendarApp.EventType.DEFAULT.

---

## Enum FieldType Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/data-studio/field-type

**Contents:**
- Enum FieldType Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
  - Properties

The FieldType enum defines the types that can be set for a Field.

To use a FieldType enum value, call its parent class, name, and property, such as DataStudioApp.FieldType.YEAR.

The FieldType enum includes properties for various data types including dates and times, geographical locations, numbers, text, booleans, URLs, images, and numerous global currencies.

An enum that defines the types that can be set for a Field.

To call an enum, you call its parent class, name, and property. For example, DataStudioApp.FieldType.YEAR.

---

## Enum Permission Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/drive/permission

**Contents:**
- Enum Permission Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
  - Properties

The Permission enum represents the permissions granted to users for accessing files or folders in Google Drive.

Permissions can be accessed using DriveApp.Permission.

The Permission enum includes properties like VIEW, EDIT, COMMENT, OWNER, ORGANIZER, FILE_ORGANIZER, and NONE, each defining a specific level of access or role.

Some Permission values like OWNER, ORGANIZER, FILE_ORGANIZER, and NONE (unless combined with Access.ANYONE) can be returned to indicate current permissions but cannot be set directly using setSharing.

An enum representing the permissions granted to users who can access a file or folder, besides any individual users who have been explicitly given access. These properties can be accessed from DriveApp.Permission.

To call an enum, you call its parent class, name, and property. For example, DriveApp.Permission.VIEW.

---

## Enum RecalculationInterval Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/spreadsheet/recalculation-interval

**Contents:**
- Enum RecalculationInterval Stay organized with collections Save and categorize content based on your preferences.
  - Properties

An enumeration representing the possible intervals used in spreadsheet recalculation.

To call an enum, you call its parent class, name, and property. For example, SpreadsheetApp.RecalculationInterval.ON_CHANGE.

---

## Enum SheetType Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/spreadsheet/sheet-type

**Contents:**
- Enum SheetType Stay organized with collections Save and categorize content based on your preferences.
  - Properties

The different types of sheets that can exist in a spreadsheet.

To call an enum, you call its parent class, name, and property. For example, SpreadsheetApp.SheetType.GRID.

---

## Enum SlideLinkingMode Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/slides/slide-linking-mode

**Contents:**
- Enum SlideLinkingMode Stay organized with collections Save and categorize content based on your preferences.
  - Properties

The mode of links between slides.

To call an enum, you call its parent class, name, and property. For example, SlidesApp.SlideLinkingMode.LINKED.

---

## Enum SwitchControlType Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/card-service/switch-control-type

**Contents:**
- Enum SwitchControlType Stay organized with collections Save and categorize content based on your preferences.
  - Properties

Type of a Switch widget control.

To call an enum, you call its parent class, name, and property. For example, CardService.SwitchControlType.SWITCH.

---

## Enum TextButtonStyle Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/card-service/text-button-style

**Contents:**
- Enum TextButtonStyle Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
  - Properties

TextButtonStyle is an enum used to specify the style for TextButton.

Available styles include OUTLINED (default), FILLED, FILLED_TONAL, and BORDERLESS.

The TEXT property is deprecated and should not be used.

You can set the background color for FILLED buttons using TextButton.setBackgroundColor().

Enums are called using their parent class, name, and property, such as CardService.TextButtonStyle.OUTLINED.

An enum that specifies the style for TextButton.

OUTLINED is the default; it renders a simple text button with clear background. FILLED buttons have a background color you can set with TextButton.setBackgroundColor(backgroundColor).

To call an enum, you call its parent class, name, and property. For example, CardService.TextButtonStyle.OUTLINED.

---

## Enum ThemeColorType Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/spreadsheet/theme-color-type

**Contents:**
- Enum ThemeColorType Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
  - Properties

ThemeColorType is an enum describing various color entries supported in themes.

You call an enum by calling its parent class, name, and property, like SpreadsheetApp.ThemeColorType.TEXT.

Supported ThemeColorType properties include colors for text, background, accents, and hyperlinks.

An enum which describes various color entries supported in themes.

To call an enum, you call its parent class, name, and property. For example, SpreadsheetApp.ThemeColorType.TEXT.

---

## Forms Service Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/forms

**Contents:**
- Forms Service Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
- Classes
- Alignment
  - Properties
- CheckboxGridItem
  - Methods
- CheckboxGridValidation
- CheckboxGridValidationBuilder
  - Methods

The Google Forms service allows scripts to create, access, and modify Google Forms.

An example script demonstrates creating a form with various item types, publishing it, and sharing it.

The documentation lists numerous classes within the Forms service, including items, responses, validation builders, and enums.

Detailed information on properties and methods is provided for many of the listed classes, outlining their specific functionalities.

This service allows scripts to create, access, and modify Google Forms.

---

## Gmail Service Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/gmail

**Contents:**
- Gmail Service Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
- Classes
- GmailApp
  - Methods
- GmailAttachment
  - Methods
- GmailDraft
  - Methods
- GmailLabel

The Gmail service allows for a wide range of email and account management tasks beyond just sending emails.

This service includes classes for interacting with threads, messages, drafts, labels, and attachments within Gmail.

The GmailApp class provides methods for creating drafts and labels, deleting labels, retrieving various types of threads and messages, marking and moving messages and threads, and searching Gmail.

Additional classes such as GmailAttachment, GmailDraft, GmailLabel, GmailMessage, and GmailThread offer specific methods for managing their respective components.

The Mail Service is a simpler alternative for sending email only.

This Service lets you send email, compose drafts, manage labels, mark messages and threads, and conduct a variety of other Gmail account management tasks. See also Mail Service, a simpler service that only allows the sending of email.

---

## Google Apps Script overview Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/overview

**Contents:**
- Google Apps Script overview Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
- What can Apps Script do?
- Try a quickstart

Google Apps Script is a rapid application development platform for creating business applications that integrate with Google Workspace, using modern JavaScript and built-in libraries for popular Google applications.

You don't need to install anything as it offers a browser-based code editor, saves scripts to Google Drive, and runs them on Google's servers.

Apps Script is versatile and can be used to add custom features to Google Docs, Sheets, and Forms, build web apps, interact with other Google services, and create add-ons.

Quickstarts are available to help you get started with Apps Script projects quickly, such as building automation, custom functions, or a Google Chat bot.

Google Apps Script is a rapid application development platform that makes it fast and easy to create business applications that integrate with Google Workspace. You write code in modern JavaScript and have access to built-in libraries for favorite Google Workspace applications like Gmail, Calendar, Drive, and more. There's nothing to install—we give you a code editor right in your browser, and your scripts are saved to Google Drive and run on Google's servers.

If you're new to JavaScript, Codecademy offers a number of JavaScript courses. (Note that these courses weren't developed by and aren't associated with Google.)

Apps Script is versatile. Among other things, you can:

Try one of the following quickstarts to get an Apps Script project up and running in less than 5 minutes.

---

## Google Apps Script release notes Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/releases

**Contents:**
- Google Apps Script release notes Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
- June 04, 2025
- April 23, 2025
- April 08, 2025
- February 20, 2025
- January 08, 2025
- December 09, 2024
- November 27, 2024
- October 02, 2024

Several Apps Script services have been updated, including the Spreadsheet, Forms, Calendar, Docs, Chat, and Google Workspace Add-ons services, adding new features and capabilities.

The Google Analytics Advanced Service and the Rhino runtime are scheduled for deprecation, requiring migration to the Google Analytics Data API Advanced Service and the V8 runtime respectively.

The Apps Script IDE has received significant enhancements, such as improved version management, better debugging tools, and a redesigned interface.

Several services and advanced services have been deprecated or removed, including the Contacts service, classic Google Sites service, Fusion Tables advanced service, and the UI service.

New services and advanced services have been introduced, such as advanced services for Google Tables, Google Drive API version 3, the Chat API, and Google Workspace Events.

To get the latest product updates delivered to you, add the URL of this page to your feed reader, or add the feed URL directly: https://developers.google.com/feeds/apps-script-release-notes.xml.

This page contains release notes for features and updates to Apps Script. We recommend that Apps Script developers periodically check this list for any new announcements.

Google Analytics 4 has replaced Universal Analytics, which means the Apps Script Advanced Service for Google Analytics Management API and Reporting API is deprecated. Use the Google Analytics Data API Advanced Service instead.

Between approximately September 2024 and March 2025, for Google Sheets modifications made by time-based Apps Script triggers, a bug caused incorrect OAuth App IDs and App Names to be logged in the Google Admin console.

This logging issue did not impact the functionality of Apps Script or Google Sheets. A fix was deployed on March 27, 2025, preventing future incorrect logging. Historical logs will not be corrected.

To learn more about Apps Script and audit logs, see Monitor and control Apps Script use in your Google Workspace organization.

You can now use the Forms Service to publish forms, and to have granular control over who can respond to forms.

Learn about the setPublished method to publish forms.

As of February 20, 2025, the Rhino runtime is deprecated. Scripts running on Rhino will continue to function until January 31, 2026, after which they will no longer execute. Please migrate your scripts to the V8 runtime before this date. Refer to Migrate scripts to the V8 runtime.

Generally Available: Granular OAuth permissions are now supported for users executing scripts in the Apps Script IDE. The granular OAuth consent screen lets users specify which individual OAuth scopes they would like to authorize. The granular consent screen will gradually launch to the remaining Apps Script surfaces, such as add-ons and trigger executions, in the future.

For more information, refer to the Workspace Updates blog post: Granular OAuth consent in Google Apps Script IDE executions.

Generally Available: To complement the release of the granular consent flow in Apps Script IDE executions, the following methods have been added to the ScriptApp and AuthorizationInfo classes to let Apps Script developers programmatically interact with the scopes granted for a script.

AuthorizationInfo class:

For more information, refer to Handle granular OAuth permissions.

Generally available: The getSheetById() method has been added to the Spreadsheet class of the Spreadsheet service. This lets you get a sheet in a spreadsheet using its unique ID.

Generally available: You can now get and set the transparency of a calendar event, meaning whether the event shows as "Busy" or "Available" in Google Calendar. For more information, refer to the following documentation:

The getUrl() method for the CellImage, CellImageBuilder, and OverGridImage classes of the Spreadsheet service has been deprecated. An image's source URL isn't available regardless of how the image is inserted into a spreadsheet.

The Calendar service now has a getEventType() method that lets developers differentiate regular events from other types of events like out-of-office and working location events. For more information, see the following documentation:

Apps Script has rescheduled the shutdown date of the Contacts service to January 31, 2025. Refer to the Apps Script sunset schedule.

The Apps Script Contacts service was deprecated in December 2022. Instead, use the People API advanced service. Refer to Migrate from Contacts service to People API advanced service.

Generally available: You can now use Looker in Connected Sheets from Apps Script. This update lets you create a new or access existing Looker data source connections, connect a sheet to them, create pivot tables, and more.

The following updates have been made to the Spreadsheet service to support Looker in Connected Sheets from Apps Script.

Generally Available: You can now create and organize tabs in Google Docs documents using Apps Script's Document service. For more information, refer to Work with tabs.

Google Workspace administrators can now turn on an allowlist in the admin console to control which external domains users can access through Apps Script's URL Fetch service.

For more information, refer to the Google Workspace Admin Help article: Allow only certain external connections for Apps Script and Sheets.

(Generally Available): Multiselect menus are now generally available for Add-ons.

For more information refer to the following:

(Generally Available): Columns are now generally available for Add-ons.

For more information refer to the following:

To subscribe to events using Apps Script, you can now use the Advanced Google Workspace Events service. For details, see the Apps Script reference documentation.

The cancelDataRefresh() method has been added to the following classes of the Spreadsheet service:

The cancelDataRefresh() method cancels the data refresh associated with the object it's called on if the refresh is currently running.

The cancelAllLinkedDataSourceObjectRefreshes() method has been added to the DataSource class. This method cancels all currently running refreshes of data source objects linked to the data source this method is called on.

(Generally Available): Google Chat apps now support Google Apps Script's Card Service. If you've built your Chat app using Apps Script, you can use Card Service to build user interfaces such as card messages and dialogs. For more information, see the Card Service reference documentation.

The default property for the TextButtonStyle enum in the Apps Script Card Service has been renamed from TEXT to OUTLINED to align with the Google Material 3 design system. Existing scripts that use the original default, TEXT, render the same as the new default, OUTLINED.

(Generally Available): You can now delete multiple unused versions at the same time from the Project History page. Refer to Delete multiple versions.

(Generally Available): The LinkPreview class has been added to the Apps Script Card service. This class lets you control various aspects of link previews, including the smart chip title, the link preview title, and the link preview card.

The 200 version limit, first announced for new scripts on December 6, 2023, has been extended to all script projects. If your existing script project already has more than 200 versions, after June 1, 2024 you won't be able to add a new version. To delete unused versions, refer to Delete a version.

(Developer Preview): Multiselect menus are now in Developer Preview for Add-ons.

For more information refer to the following:

(Developer Preview): Columns are now in Developer Preview for Add-ons.

For more information refer to the following:

(Developer Preview): Google Chat apps now support Google Apps Script's Card Service. If you've built your Chat app using Apps Script, you can use Card Service to build user interfaces such as card messages and dialogs. For more information, see the Card Service reference documentation.

(Generally Available): Google Workspace Add-ons now support third-party resource creation from the @ menu in Google Docs. This feature is gradually rolling out over the next few weeks. To use this feature, see Create third-party resources from the @ menu.

(Generally available): Google Workspace Add-ons now support link previews in Google Sheets and Slides. To learn more, see Preview links with smart chips.

(Generally available): The setPersistValues(persistValues) method has been added to the Action class of the Card service. This means that you can now indicate whether form values are determined by the client's values or the server's values after an action response updates a form's card.

(Generally Available): You can now call version 3 of the Google Drive API from Apps Script with the advanced Drive service. To learn more, see Advanced Drive service.

To fix a bug that prevented events of eventType != 'default' from importing, we updated the code sample in Populate a team vacation calendar, the popular Apps Script + Calendar API solution. Review the code change in GitHub.

(Generally available): You can now delete versions in your Apps Script project from the project history page in the Apps Script IDE.

Script projects created after December 10, 2023 can have up to 200 versions. If your script reaches the versions limit, or you want to clean up your script project, delete undeployed versions that you no longer need.

To learn more, see Delete a version.

(Developer Preview): Google Workspace Add-ons now support third-party resource creation from the @ menu in Google Docs. To use this feature, see Create third-party resources from the @ menu.

(Developer Preview): Available as part of the Google Workspace Developer Preview Program, which grants early access to certain features.

Google Workspace Add-ons now support link previews in Google Sheets and Slides. To learn more, see Preview links with smart chips.

(Generally available): You can now call the Chat API from Apps Script with the Advanced Chat Service. To learn how, see Advanced Chat Service in the Apps Script reference documentation.

We've also updated the Apps Script code samples to use the Advanced Chat Service in the following Chat API developer guides:

The email address that sends notifications about errors in triggers has been updated from apps-scripts-notifications@google.com to noreply-apps-scripts-notifications@google.com.

The classic Google Sites service has been deprecated due to the transition from classic Sites to new Sites. There isn't a way to connect to new Sites with Apps Script.

You can now view previously deployed script versions and compare them to the current script version in the Apps Script IDE. Anyone who has edit permission on an Apps Script project can access the project history page. To learn more, refer to the following:

Google Workspace Updates blog: View & compare script versions with Apps Script project history

Developer documentation: Versions

Third-party smart chips and link previews are now generally available. To build a Google Workspace Add-on that uses this feature, see Preview links with smart chips.

Apps Script has deprecated the Contacts service. Instead, use the People API advanced service. Refer to Migrate from Contacts service to People API advanced service.

The Contacts service shutdown has been rescheduled from April 2023 to January 2025. Refer to the Apps Script sunset schedule.

Apps Script added a new method to the Utilities class. parseDate(date, timeZone, format) parses a provided string date according to the specification described in the Java Standard Edition SimpleDateFormat class.

Apps Script has sunset the following methods:

There isn't a replacement method to get this data with Apps Script.

Learn about the switch from Classic Hangouts to Chat.

Apps Script has turned down the legacy integrated development environment (IDE) in favor of the redesigned IDE that launched in December 2020.

Learn more about the IDE updates from the following blog posts:

Apps Script now automatically deletes default Google Cloud projects (Google Cloud projects that Apps Script creates in the background) when their associated scripts haven't run in 180 days or more. If the script runs after Apps Script deletes the default Google Cloud project, Apps Script creates one for the script.

This update doesn't affect standard Google Cloud projects (Google Cloud projects created by people).

Apps Script has deprecated the following methods:

These methods will become unavailable later this year once Google switches all users from Classic Hangouts to Google Chat. There isn't a replacement method to get this data with Apps Script.

Learn about the switch from Classic Hangouts to Chat.

You can now call functions in separate files before they're parsed. Previously, the V8 runtime required a script file to be parsed before any other file could call the functions it defines.

Now, the order of files in the Apps Script editor doesn't matter. This means that you can call a function in a different file to assign a value to a global variable—the function is always defined before it's called. This behavior reflects that of the legacy Rhino runtime.

You can now perform the following actions in the new Apps Script integrated development environment (IDE):

For Google Workspace Add-ons, an Attachment class has been added to the Card Service that lets you add custom attachments to Calendar events. You can also set an event trigger that fires when the user clicks on the add-on attachment provider in the Calendar dropdown menu. For more information, refer to EventAttachmentTrigger.

The get methods for several color objects in the Spreadsheet Service have been deprecated in favor of a new naming convention. The functionality remains the same. For example, the getFontColor() method from the Range class has been replaced with getFontColorObject().

The following classes have updated get methods for color objects:

Owners receive email alerts when someone outside the owner's organization edits a script project in the new integrated development environment (IDE).

For container-bound scripts: If someone outside the container owner's organization creates or edits a container-bound script project, the container owner receives an email notification.

For standalone scripts: If someone outside the script project owner's organization edits a standalone script project, the script project owner receives an email notification.

The following classes have been added to the Spreadsheet Service to let you add images to cells:

To add an image to a cell, you must create a new image value for the image using SpreadsheetApp.newCellImage() and CellImageBuilder. Then, use Range.setValue(value) or Range.setValues(values) to add the image value to the cell.

Versions 1.0 and 1.1 of the TLS security protocol are disabled. To establish JDBC connections, use TLS 1.2 or higher.

In the HTML Service iframe sandbox, allow-top-navigation, which allows the content to navigate its top-level browsing context, is restricted and not set as an attribute in the sandbox. Instead, the allow-top-navigation-by-user-activation attribute has been added to the sandbox.

If you need to redirect your script, add a link or a button for the user to take action on.

Learn more about HMTL Service restrictions.

The Drive Service has added three new methods to the file and folder classes to manage the use of resource keys when sharing files and folders.

Learn more about the resource key security update for Drive.

The Document Service has added support for smart chips by adding three new classes:

Learn more about smart chips in Google Docs.

The Microsoft SQL Server JDBC driver was updated to version 7.2.1. If you encounter issues, report them on the issue tracker. If you're an administrator and need live support, contact Google Workspace support.

A new divider widget has been added for Google Workspace Add-ons. To add a divider to an add-on card, use the newDivider() method within the Card service.

A new method has been added to the Sheet class of the Spreadsheet service. setRowHeightsForced(startRow, numRows, height) lets you manually set the height for a row or a set of rows.

The following updates have been made to deployments in the new editor:

To learn more, see Create and manage deployments.

The Apps Script integrated development environment, or IDE, has been fully redesigned. Along with a completely new interface, the following features have been updated:

To switch back to the legacy IDE from within the editor, at the top, click Use legacy editor.

An advanced service for Google Tables has been added to Apps Script. The Tables service allows scripts to programmatically read and edit rows within Tables.

New classes and methods have been added to support Connected Sheets.

The following new classes have been added to the Spreadsheet service:

New methods to support Connected Sheets have been added to the following classes in the Spreadsheet service:

A new class called DecoratedText has been added to the Card Service. DecoratedText adds text with optional decorations and was added to replace the KeyValue class.

To help simplify Google Drive's folder structure and sharing models, new methods have been added to the Drive service and some existing methods have been deprecated.

The DriveApp now has an enforceSingleParent(value) method that enables or disables enforceSingleParent behavior.

The File class now has the following methods:

The Folder class now has the following methods:

The following Folder class methods have been deprecated:

New methods have been added to the Spreadsheet service:

A new simple trigger, onSelectionChange(e), has been added for Google Sheets. The onSelectionChange(e) trigger runs automatically when a user changes the selection in a spreadsheet.

The following has been added to the Spreadsheet service:

The following has been added to the Drive service:

The following methods have been added to the Spreadsheet service to support the use of theme colors. Many of these methods duplicate the effect of existing color methods, but let you use Color objects instead of strings as parameters and return types:

Apps Script now supports the V8 runtime. This enables modern JavaScript features and syntax in Apps Script. You can migrate existing scripts to use V8 and its features.

To support the launch of G Suite Add-ons, the following manifest changes, service, classes, and methods have been added to Add-ons:

The add-ons manifest structure has been updated to provide configuration controls for G Suite Add-ons. All add-on manifest settings are specified in the AddOns object in the manifest. Manifest fields that previously supported Gmail add-ons still exist, but are now deprecated. See Upgrading your published add-ons for instructions on how to upgrade a Gmail add-on into a G Suite add-on.

The Card service has been extended with the following classes and methods that provide new widgets and event responses:

The Conference Data service has been added to Apps Script. The service helps G Suite Add-ons that extend Google Calendar to stay in sync with third-party conferencing applications. This service is only useful to developers who manage a conferencing application and want to make it available in Google Calendar.

The Spreadsheet service has been extended with the following class and new methods to support using color building and theme colors:

The Data Studio service has been extended with the following class and new methods to support different response types and dynamic statuses:

The Spreadsheet service has been extended with the following class and new methods to support using slicers to filter ranges, charts, and pivot tables:

The Script service has been extended with the ScriptApp.getIdentityToken() method, which returns an identity token for the effective user.

You can no longer publish web apps to the Chrome Web Store. The Chrome Web Store deprecated Chrome apps in 2016 and they are now only available for ChromeOS devices. This change includes published Apps Script web apps. Previously published web apps are no longer discoverable in the Chrome Web Store. Editor Add-ons aren't affected; you can still publish Editor Add-ons to the Chrome Web Store.

The Slides service class RgbColor and the enumeration ColorType have been moved from the Slides service to the [Base script service](https://developers.google.com/apps-script/reference/base). The functionality of these classes has not changed. Moving these classes to the Base script service enables other services to make use of them in the future. You can now find the documentation for these classes at [RgbColor](https://developers.google.com/apps-script/reference/base/rgb-color) and [ColorType`](https://developers.google.com/apps-script/reference/base/color-type).

Several classes and methods relating to the now shutdown UiApp service have been removed. Most of these methods involved interactions between the Charts service and UiApp that were very seldom used. The following is a full list of the removed classes and methods:

The Card service methods CardHeader.setUrl(url) and Image.setUrl(url) have been updated to accept an encoded image data string as an input parameter. As before, you can alternatively use a publicly-available image URL as the input parameter.

Documentation for the UI service has been removed. This service was deprecated in December 2014 and officially shut down on July 15, 2019. To build interfaces for web apps and Editor Add-ons, use the HTML service.

The Document service has been updated to add methods to get and set the language of a document:

The Data Studio service has been updated to add a few values to FieldType enum:

The behavior of the Google Cloud (GCP) projects used by scripts has been altered. Now, the default GCP projects that Apps Script creates for new scripts are hidden and script owners can't access them directly. Admins and domain users with the resourcemanager.projects.list permission on the parenting GCP folder can still access default GCP projects.

If you need access to a script's GCP project (because you wish to publish it or take a similar action), it's best to switch your script to use a standard GCP project.

The Spreadsheet service has been extended with the following new classes and methods to support BigQuery data connectors in Sheets:

The Data Studio service has been extended with the following new methods involving reaggregation settings:

The deprecated UiApp service will be officially shutdown on July 15th, 2019. After this date, the service will no longer function for any script project.

The Slides service has been extended with the following new classes and methods that support connector lines:

The Fusion Tables advanced service has been deprecated and will shutdown fully on December 3rd, 2019.

The following methods in the Spreadsheet service now return an OverGridImage object instead of void:

The Spreadsheet service has been extended with the following new classes and methods:

The following methods have been added to existing services:

The Card service has been extended with the following classes and methods to support Gmail add-on compose actions:

The Data Studio service is now available. You can use this service when building a Data Studio Community Connector.

The Utilities service has been extended with the following methods and classes:

The quota limits for UrlFetch GET response size and POST size have been increased to 50MB / call.

The quota on total data received by UrlFetch per day per user has been removed.

Macros for Google Sheets are now becoming available for users, and will finish rolling out over then next few weeks. This feature lets you record macros in the Google Sheets UI and use Apps Script to create or edit them.

The Sheets service has been extended with a large number of new classes and methods. The addition of these methods make it possible to reproduce in code nearly any action a Sheets user can take at a keyboard. The new classes and methods include:

The Charts service has been extended to support EmbeddedCharts in Google Sheets with the enums ChartHiddenDimensionStrategy and ChartMergeStrategy. In addition, the following ChartTypes have been added:

The Spreadsheet service has been extended with the following new methods:

Calendar event triggers are now available. You can use these triggers in conjunction with the Calendar advanced service to discover recently changed calendar events via regular sync operations.

Add-ons now require OAuth Client Verification prior to beginning the publication process. Verification no longer is conducted during the add-on review.

Added Apps Script support for the Google Slides service. You can now use Apps Script to create and edit presentations and their contents; you can also build add-ons for Google Slides.

To protect users from abuse, Google OAuth clients that request certain sensitive OAuth scopes are subject to review by Google. Such apps may present users with a warning screen saying the app is unverified by Google. You can remove this screen from your app's authorization flow by submitting a review request.

Stackdriver Logging has been moved out of Early Access. All scripts now have access to Stackdriver logging.

Added the method Range.randomize() that randomizes the order of rows in a spreadsheet Range.

Introduced the Early Access program for new G Suite Business features. These features include App Maker and Stackdriver Logging.

Added forms validation classes for check boxes, generic data, grid items, paragraph text items, and text items.

Added X-Frame-Option header support to HtmlService, allowing iframes to render Apps Script HTML and web apps.

Added support for Android add-ons. Now you can make Google Docs and Sheets add-ons that work on Android.

The use of project keys to identify scripts is now deprecated. The preferred unique identifier for a script is the Script ID. There are no plans to turn off or disable the use of project keys; code that uses project keys will continue to work for the foreseeable future.

NATIVE sandbox mode is now shut down. All scripts default to IFRAME mode, regardless of which mode, if any, is specified. Scripts that relied on NATIVE mode features may need to be migrated.

Support for PATCH requests has been added to UrlFetchApp.

Deprecated the add(widget) method in the DashboardPanel class because it takes a UiApp.Widget argument, and UiApp was deprecated in 2014.

The Spreadsheet API adds new methods for getTabColor() and setTabColor(color).

The Spreadsheet API adds a new NamedRange type and the following related methods:

The Utilities API includes a new getUuid() method that generates a unique identifier.

In the HTML service, EMULATED sandbox mode was sunset. Any scripts that explicitly request EMULATED mode now default to IFRAME mode.

In the HTML service, all new scripts default to IFRAME sandbox mode unless NATIVE mode is explicitly specified.

Deprecated the method Service.enable() in the ScriptApp global object. This method is no longer useful because Apps Script's authorization model has changed since the time the method was introduced.

Added the following methods to the Spreadsheet service to let scripts control "warning-based" protection for spreadsheet ranges (which means that every user can edit data in the area, except editing prompts the user to confirm the edit):

Added two variations of the method computeRsaSha256Signature to the Utilities global object to let scripts sign a string using the RSA SHA-256 algorithm.

Added the method getUserAgent() to the HtmlService global object to let scripts get the user-agent string for the current browser.

Deprecated the following OAuth class and methods in favor of OAuth libraries: + OAuthConfig + UrlFetchApp.addOAuthService(serviceName) + UrlFetchApp.removeOAuthService(serviceName)

The DocsList service, which was deprecated in 2014, has been sunset and no longer functions. Users relying on DocsList should switch to DriveApp.

Deprecated the URL Fetch service's class OAuthConfig, which provided the ability to connect to OAuth 1.0 APIs. This has been replaced by the open source library OAuth1 for Apps Script. See the migration guide for more information.

Added the following class, enum, and methods to the Spreadsheet service, to give precise control over protected sheets and ranges:

Deprecated the following class and methods, which have been replaced by the more powerful Protection class above. Although this class and these methods are deprecated, they will remain available for compatibility with the older version of Sheets.

Replaced the method SpreadsheetApp.open(file), which takes a File object from the deprecated DocsList service as a parameter, with a version that takes a File object from the Drive service instead. The new method has the same name.

Changed the Document service methods Text.getFontFamily() and Text.setFontFamily(fontFamilyName) to use string names for font families instead of the FontFamily enum, and consequently deprecated FontFamily.

Changed several Spreadsheet methods that previously returned void so that they now return a Spreadsheet object that can be used to chain method calls.

Issue 4617: HTML service pages that use the new IFRAME sandbox mode now render correctly in Firefox.

Added a new IFRAME sandbox mode for HTML service that imposes many fewer restrictions than the other sandbox modes and runs much faster. However, IFRAME mode does not work at all in certain older browsers, including Internet Explorer 9.

Add-ons are now available in Google Forms. As with add-ons for Docs and Sheets, Forms add-ons are in developer preview, so you must apply to publish them.

Removed the Finance service, as announced earlier in the year.

Issue 3928: The Document method setSelection, the Sheet method activate, and the Spreadsheet methods setActiveRange and setActiveSelection now work correctly if they are called from an onOpen or onEdit trigger.

Add-ons for Google Sheets and Docs can now use time-driven installable triggers.

The UiService widget DocsListDialog now requires that you call DocsListDialog.setOAuthToken(oAuthToken) before calling DocsListDialog.showDocsPicker().

Replaced the CacheService methods getPrivateCache() and getPublicCache() and the LockService methods getPrivateLock() and getPublicLock() with getUserCache(), getScriptCache(), getUserLock(), and getScriptLock(), respectively. The old method names have been deprecated, but will continue to function. The new names follow the same conventions as PropertiesService.

Added the value ON_CHANGE to the ScriptApp.EventType enum so that Google Sheets change events can be detected correctly.

Deprecated the script gallery in the old version of Google Sheets. As explained in the blog post, the add-on store in the new version of Sheets gives developers wider distribution, automatic updates, and several other features not available in the script gallery.

Added the Document service methods getTextAlignment and setTextAlignment as well as the enum TextAlignment, to support NORMAL, SUPERSCRIPT, and SUBSCRIPT text alignment in Google Docs.

Deprecated both ScriptDB and the Domain service. As announced in the blog post, the services will remain available for the next six months but will be turned off on November 20, 2014. To replace ScriptDB, see the migration guide and the improved guide to connecting to external databases through JDBC. To replace the Domain service, see the Admin SDK Directory and Admin SDK Reports advanced services.

Added a source property to the event parameter for form triggers. This makes it possible to retrieve the form that triggered the event.

The "Report an issue" dialog for add-ons now asks users whether they would like to share their name and email address with the developer.

In the new version of Google Sheets, the Undo command can now revert changes made by a script. This was already true in Docs, Forms, and the older version of Sheets.

The Document method setSelection, the Sheet method activate, and the Spreadsheet methods setActiveRange and setActiveSelection no longer have any effect if they are called from an onOpen or onEdit trigger.

The deprecated SOAP service and old XML service have now been removed from autocomplete and documentation, as announced on July 9, 2013 and documented in the Apps Script sunset schedule. Existing scripts that use these services should still function. The UI service widgets DeckPanel, DecoratedPopupPanel, DockLayoutPanel, DockPanel, StackLayoutPanel, and TabLayoutPanel have been completely disabled, as announced on April 15, 2013.

The Range method getDataSourceUrl() is now supported in the new version of Google Sheets. For information on other incomplete Apps Script features in the new version of Sheets, see the list of known issues.

When an add-on is installed from the store, the onInstall() simple trigger is now passed an event parameter, e, which includes an authMode property. This makes it easier for an add-on to call onOpen(e) from onInstall(e).

In the new version of Google Sheets, Range.setValues() now automatically extends the spreadsheet if the range is larger than the present size.

Issue 3757: The link to the Google Developers Console in the Advanced Google Services dialog now opens the correct project.

Announced a developer preview for add-ons in Google Docs and the new version of Google Sheets, with support for Google Forms coming soon. An add-on is an Apps Script project published to a store inside Docs or Sheets, which makes it easy for users to find and install new features. Our guides cover everything you need to know to develop, design, and apply to publish your first add-on.

Changed the quota for Gmail from 10,000 reads and 10,000 writes per day (excluding sent messages) to 20,000 reads and writes combined per day.

Deprecated the Finance service. As announced in the blog post, the service will remain available for the next six months but will be turned off on September 26, 2014.

Issue 3622: The title bar of a sidebar shown by a script in Google Docs, Forms, or the new version of Sheets is now the same height as in a sidebar shown by a built-in feature.

Removed the Session method getActiveUserTimeZone(), which did not return a value for most users.

The quota for the number of email recipients for scripts running from consumer (gmail.com) or free Google Apps accounts has been reduced from 500 to 100 per day. The quota for paid Google Apps accounts has not been changed.

Added the following Session methods, which allow scripts to determine the user's locale and time zone:

Renamed several classes and methods in DocumentApp. The old names are deprecated but will continue to work. You do not need to update your code.

The new SpreadsheetApp method Spreadsheet.getUi() allows scripts to access the spreadsheet's user-interface environment in order to add features like menus, dialogs, and sidebars. This method is consistent with the getUi() methods in DocumentApp and FormApp, but only works in the new version of Google Sheets. The older version of Google Sheets continues to use the existing methods documented in the guides to dialogs and sidebars and menus.

Renamed the Cursor object in DocumentApp to Position. This does not require any changes to existing code.

Deprecated the SpreadsheetApp.Spreadsheet methods isAnonymousView(), isAnonymousWrite(), isReadable(), isWritable(), and setAnonymousAccess(). Various methods of the File class in DriveApp can achieve the same functionality.

Added the SpreadsheetApp method DataValidationBuilder.requireFormulaSatisfied(String), as well as an accompanying CUSTOM_FORMULA value in DataValidationCriteria. This feature can only be used in the new version of Google Sheets.

Added the advanced parameter escaping to UrlFetchApp.fetch(). If false, reserved characters in the URL will not be automatically escaped.

The Maps.DirectionFinder.Mode enum now includes the TRANSIT value allowing for the retrieval of public transit routes in the Maps service.

Added seven new advanced services: + Admin SDK Directory service + Admin SDK Reports service + Fusion Tables service + Google+ Domains service + Mirror service + YouTube service + YouTube Analytics service

Issue 3461: A yellow warning bar should no longer appear on Apps Script gadgets that are embedded in Google Sites.

Added TITLE and SUBTITLE values to the DocumentApp.ParagraphHeading enum.

The Apps Script methods Utilities.jsonParse() and Utilities.jsonStringify() have been deprecated in favor of the now-standard JavaScript methods JSON.parse() and JSON.stringify(), which now appear in autocomplete.

Issue 3189: A rare issue in which LockService failed to acquire a lock should no longer occur.

If a version of a library has been deleted by the library owner, scripts can no longer use that version.

Issue 2817: Sporadic errors about missing libraries should now occur less frequently.

Issue 74: Simple onEdit() triggers now fire correctly when the user is not signed in to a Google account.

Added the following FormApp methods, which allow scripts to work with progress bars, custom closed-form messages, and YouTube videos. + Form.hasProgressBar() + Form.setProgressBar(enabled) + Form.getCustomClosedFormMessage() + Form.setCustomClosedFormMessage(message) + Form.addVideoItem()

Added the following DriveApp methods, which allow scripts to get the owner of a File or Folder.

The UiApp widgets Hyperlink, InlineHyperlink, LayoutPanel, and RichTextArea have now been disabled, as announced on March 13, 2013 and documented in the Apps Script sunset schedule.

Added the DocumentApp methods InlineImage.getLinkUrl() and InlineImage.setLinkUrl(url).

Deprecated the DocumentApp methods getFootnotes(), getLinkUrl(), setLinkUrl(url), and isAtDocumentEnd() in the classes FooterSection, FootnoteSection, and HeaderSection, as well as the methods getNextSibling() and getPreviousSibling() in the classes FooterSection and HeaderSection. These methods were not useful.

Issue 2621: A situation in which certain scripts did not terminate despite exceeding the execution-time limit no longer occurs.

Removed the ability to get the user's email address in simple onEdit() triggers. Because simple triggers don't request user authentication, this change was important to protect the identity of collaborators who hadn't explicitly granted permission for the script to collect their email address.

Added the DriveApp methods File.makeCopy(destination) and File.makeCopy(name, destination), which allow scripts to specify a folder to which a file should be copied.

Issue 3097: A performance issue that affected certain scripts no longer occurs.

Added the method Spreadsheet.deleteSheet(sheet), which allows deletions of sheets that are not the active sheet.

Deprecated the DocsList methods find(query, start, max), getAllFiles(start, max), getAllFolders(start, max), getFiles(start, max), getFilesByType(fileType, start, max), and getFolders(start, max). Instead of these methods, use DriveApp or one of the DocsList.get*ForPaging() methods.

All new scripts now use the new authorization flow by default.

On ChromeOS devices, it is now possible to activate autocomplete (sometimes called "content assist") with the keyboard shortcut Ctrl + Space.

Issue 2947: Newlines are now supported in Ui.alert() and Ui.prompt() dialogs.

Added DriveApp and FormApp to the services tracked on the Apps Script Dashboard.

Issue 2801: Fixed an issue in which specific URL parameters did not work with HtmlService.

Added XmlService to replace the old Xml service.

Deprecated the old Xml service, SoapService, and support for the JavaScript feature E4X.

Issue 2158: The request object passed in to doPost() methods now contains the POST body. It can be accessed using e.postData.getDataAsString().

Issue 2740: UrlFetchApp.fetch() calls no longer fail if the advanced parameters specify a payload without specifying the request method.

Issue 1363: Added support for spreadsheet change events. The onChange() event now fires when certain modifications, such as row insertions, are done to a spreadsheet.

Issue 2585: Xml.parse() once again correctly parses well-structured XML and HTML documents.

Large scripts in the Script Gallery now install more quickly.

The following changes were made to simplify the Document service:

Deprecated UiApp widgets DeckPanel, DecoratedPopupPanel, DockLayoutPanel, DockPanel, StackLayoutPanel, and TabLayoutPanel, which had limited usability.

Issue 2565: DocsList.createFile() no longer allows the creation of files with invalid MIME types or Google document MIME types.

Issue 995: The new methods Sheet.hideSheet(), Sheet.isSheetHidden(), and Sheet.showSheet() allow scripts to control the visibility of individual sheets within a spreadsheet.

Renamed the action "Publish to Gallery" to "Submit to Gallery", to avoid confusion with publishing a web app.

Deprecated the GUI Builder and the UIApp widgets Hyperlink, InlineHyperlink, LayoutPanel, RichTextArea, and SuggestBox, which had limited usability.

Issue 1917: It is no longer possible to install a script multiple times from the Script Gallery.

When setting font colors in a spreadsheet using Range.setFontColor() or Range.setFontColors(), color names will now automatically be converted to their corresponding hexadecimal values. For example, after calling setFontColor('red') the method getFontColor() will return "#ff0000".

Added the method DocumentApp.openByUrl(), which allows documents to be opened by their URL directly.

Added the ability to directly attach StaticMap objects in emails.

Added the method SpreadsheetApp.openByUrl(), which allows spreadsheets to be opened by their URL directly.

Added the method after(durationMilliseconds) to class ClockTriggerBuilder to simplify the creation of one-off triggers.

Issue 2204: Utilities.formatDate no longer rejects certain time-zone formats, such as EST, CST, etc.

Added extra validation to the datasource URLs used in charts. Custom datasource URLs that rely on non-Google authentication will no longer work.

Added the ability to disable SSL certificate validation in the SoapService, in response to a feature request.

Updated some icons to match icons of other Google Drive applications.

Added options to EmbeddedChartBuilder to make it easier to configure embedded charts. EmbeddedChartBuilder now contains the methods asAreaChart(), asBarChart(), asColumnChart(), asLineChart(), asPieChart(), asScatterChart() and asTableChart() as replacements for calls to setChartType().

Fixed an issue where certain files could not be copied via DocsList.copy().

Added a setLabelSeparator() method to CategoryFilterBuilder, to allow for label separator strings to be used.

Enabled SSL certificate validation for UrlFetchApp requests. If you wish to disable this behavior you can set the advanced option validateHttpsCertificates to "false".

Updated DocsList.getFilesByType() to accept values from the DocsList.FileType enumeration. Passing in string values for the document type is deprecated but still functional. (Issue 1755)

Added an isDeleted() method to SitesApp's Page class.

Fixed an issue with scrolling in the script editor so that line numbers will be displayed even when horizontally scrolling on long lines.

Added a getThumbnail() method to the DocsList service's File class.

Made improvements to the speed of handling large batches of data in ScriptDb.

Fixed an issue where setting an empty key in Script Properties or User Properties resulted in a "Data storage error" message.

Fixed an issue where the script editor could not be accessed for some container-bound scripts.

Updated the link to the support page on the Google Apps Script Dashboard.

Added a scrollbar to the file panel in the Script Editor,

Fixed an issue where PDF documents uploaded and saved to Google Drive were being saved as blank files.

Simplified sharing settings for scripts. For new script projects, the script will inherit the permissions of its parent. For example, if a script is associated with a Spreadsheet, and user1@example.com has edit access to the Spreadsheet, then user1@example.com will have edit access to the script. The extra blue Share button will no longer be present on these newly created scripts, since the permissions are tied to those of the parent. For scripts created prior to June 8, 2012, the Share button will remain if the checkbox to "Allow document collaborators to edit project" or "Allow site collaborators and owners to edit project" was not selected for that script. For more information see Security. If you would like to have script source that cannot be modified by the editors of your Spreadsheet or Site, then you can use Script Libraries.

Fixed an issue with ClockTriggerBuilder.nearMinute, where invalid minute values were sometimes created.

Launched the Google Apps Script Dashboard so that developers can view service health and quota limits.

Added a DocumentApp.HorizontalAlignment.JUSTIFY value to the DocumentApp.HorizontalAlignment enumeration.

Fixed an issue where files and collections in Google Docs could not be shared with groups.

Launched the Script service in response to this feature request, which allows developers to programmatically set triggers and manage the publishing of scripts as a service.

Modified document collaboration and sharing rules to make them consistent with what is possible in the user interface.

Fixed an issue where Spreadsheet.insertSheet() failed to properly copy a sheet when given a {template:sheet_obj} parameter.

Added the ability to set the subject line via the subject field in the advanced arguments for GmailMessage.forward().

Fixed an issue where Anchor.setWordWrap() was not working.

Fixed an issue with Paragraph.setHeading() where text was not formatted as expected.

Fixed an issue with the debugger, where it would close when stepping into a function that is located in a different file.

Fixed an issue where an error occurred if an empty ListBox was used as a callback element.

Added support for ScrollPanel to the GUI Builder.

Added supports for projects in Apps Script.

Fixed an issue where Xml.element failed if the child elements were XmlElements.

Fixed an issue where GmailApp.getUserLabelByName() failed for label names that contained spaces.

Fixed an issue with UiApp.getActiveApplication().setStyleAttribute() for 'cursor.'

Added an appendRow() method to Spreadsheet.

Added a method in Utilities class that parses CSV text.

Introducing the Debugger! The debugger significantly enhances the ability of Apps Script users to debug their scripts. With the debugger, users can set breakpoints, inspect variables, step-in and step-out of functions.

Added integration with Google Sites, so that Apps Script can now be run from within Google Sites. Read more here.

Fixed an issue with the Sheet.getFrozenRows, where an error was returned in some cases.

Line numbers in error messages are now denoted with (line nnn), rather than (# nnn), where nnn is the line number.

---

## Google Apps Script release notes Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/docs/release-notes

**Contents:**
- Google Apps Script release notes Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
- June 04, 2025
- April 23, 2025
- April 08, 2025
- February 20, 2025
- January 08, 2025
- December 09, 2024
- November 27, 2024
- October 02, 2024

Several Apps Script services have been updated, including the Spreadsheet, Forms, Calendar, Docs, Chat, and Google Workspace Add-ons services, adding new features and capabilities.

The Google Analytics Advanced Service and the Rhino runtime are scheduled for deprecation, requiring migration to the Google Analytics Data API Advanced Service and the V8 runtime respectively.

The Apps Script IDE has received significant enhancements, such as improved version management, better debugging tools, and a redesigned interface.

Several services and advanced services have been deprecated or removed, including the Contacts service, classic Google Sites service, Fusion Tables advanced service, and the UI service.

New services and advanced services have been introduced, such as advanced services for Google Tables, Google Drive API version 3, the Chat API, and Google Workspace Events.

To get the latest product updates delivered to you, add the URL of this page to your feed reader, or add the feed URL directly: https://developers.google.com/feeds/apps-script-release-notes.xml.

This page contains release notes for features and updates to Apps Script. We recommend that Apps Script developers periodically check this list for any new announcements.

Google Analytics 4 has replaced Universal Analytics, which means the Apps Script Advanced Service for Google Analytics Management API and Reporting API is deprecated. Use the Google Analytics Data API Advanced Service instead.

Between approximately September 2024 and March 2025, for Google Sheets modifications made by time-based Apps Script triggers, a bug caused incorrect OAuth App IDs and App Names to be logged in the Google Admin console.

This logging issue did not impact the functionality of Apps Script or Google Sheets. A fix was deployed on March 27, 2025, preventing future incorrect logging. Historical logs will not be corrected.

To learn more about Apps Script and audit logs, see Monitor and control Apps Script use in your Google Workspace organization.

You can now use the Forms Service to publish forms, and to have granular control over who can respond to forms.

Learn about the setPublished method to publish forms.

As of February 20, 2025, the Rhino runtime is deprecated. Scripts running on Rhino will continue to function until January 31, 2026, after which they will no longer execute. Please migrate your scripts to the V8 runtime before this date. Refer to Migrate scripts to the V8 runtime.

Generally Available: Granular OAuth permissions are now supported for users executing scripts in the Apps Script IDE. The granular OAuth consent screen lets users specify which individual OAuth scopes they would like to authorize. The granular consent screen will gradually launch to the remaining Apps Script surfaces, such as add-ons and trigger executions, in the future.

For more information, refer to the Workspace Updates blog post: Granular OAuth consent in Google Apps Script IDE executions.

Generally Available: To complement the release of the granular consent flow in Apps Script IDE executions, the following methods have been added to the ScriptApp and AuthorizationInfo classes to let Apps Script developers programmatically interact with the scopes granted for a script.

AuthorizationInfo class:

For more information, refer to Handle granular OAuth permissions.

Generally available: The getSheetById() method has been added to the Spreadsheet class of the Spreadsheet service. This lets you get a sheet in a spreadsheet using its unique ID.

Generally available: You can now get and set the transparency of a calendar event, meaning whether the event shows as "Busy" or "Available" in Google Calendar. For more information, refer to the following documentation:

The getUrl() method for the CellImage, CellImageBuilder, and OverGridImage classes of the Spreadsheet service has been deprecated. An image's source URL isn't available regardless of how the image is inserted into a spreadsheet.

The Calendar service now has a getEventType() method that lets developers differentiate regular events from other types of events like out-of-office and working location events. For more information, see the following documentation:

Apps Script has rescheduled the shutdown date of the Contacts service to January 31, 2025. Refer to the Apps Script sunset schedule.

The Apps Script Contacts service was deprecated in December 2022. Instead, use the People API advanced service. Refer to Migrate from Contacts service to People API advanced service.

Generally available: You can now use Looker in Connected Sheets from Apps Script. This update lets you create a new or access existing Looker data source connections, connect a sheet to them, create pivot tables, and more.

The following updates have been made to the Spreadsheet service to support Looker in Connected Sheets from Apps Script.

Generally Available: You can now create and organize tabs in Google Docs documents using Apps Script's Document service. For more information, refer to Work with tabs.

Google Workspace administrators can now turn on an allowlist in the admin console to control which external domains users can access through Apps Script's URL Fetch service.

For more information, refer to the Google Workspace Admin Help article: Allow only certain external connections for Apps Script and Sheets.

(Generally Available): Multiselect menus are now generally available for Add-ons.

For more information refer to the following:

(Generally Available): Columns are now generally available for Add-ons.

For more information refer to the following:

To subscribe to events using Apps Script, you can now use the Advanced Google Workspace Events service. For details, see the Apps Script reference documentation.

The cancelDataRefresh() method has been added to the following classes of the Spreadsheet service:

The cancelDataRefresh() method cancels the data refresh associated with the object it's called on if the refresh is currently running.

The cancelAllLinkedDataSourceObjectRefreshes() method has been added to the DataSource class. This method cancels all currently running refreshes of data source objects linked to the data source this method is called on.

(Generally Available): Google Chat apps now support Google Apps Script's Card Service. If you've built your Chat app using Apps Script, you can use Card Service to build user interfaces such as card messages and dialogs. For more information, see the Card Service reference documentation.

The default property for the TextButtonStyle enum in the Apps Script Card Service has been renamed from TEXT to OUTLINED to align with the Google Material 3 design system. Existing scripts that use the original default, TEXT, render the same as the new default, OUTLINED.

(Generally Available): You can now delete multiple unused versions at the same time from the Project History page. Refer to Delete multiple versions.

(Generally Available): The LinkPreview class has been added to the Apps Script Card service. This class lets you control various aspects of link previews, including the smart chip title, the link preview title, and the link preview card.

The 200 version limit, first announced for new scripts on December 6, 2023, has been extended to all script projects. If your existing script project already has more than 200 versions, after June 1, 2024 you won't be able to add a new version. To delete unused versions, refer to Delete a version.

(Developer Preview): Multiselect menus are now in Developer Preview for Add-ons.

For more information refer to the following:

(Developer Preview): Columns are now in Developer Preview for Add-ons.

For more information refer to the following:

(Developer Preview): Google Chat apps now support Google Apps Script's Card Service. If you've built your Chat app using Apps Script, you can use Card Service to build user interfaces such as card messages and dialogs. For more information, see the Card Service reference documentation.

(Generally Available): Google Workspace Add-ons now support third-party resource creation from the @ menu in Google Docs. This feature is gradually rolling out over the next few weeks. To use this feature, see Create third-party resources from the @ menu.

(Generally available): Google Workspace Add-ons now support link previews in Google Sheets and Slides. To learn more, see Preview links with smart chips.

(Generally available): The setPersistValues(persistValues) method has been added to the Action class of the Card service. This means that you can now indicate whether form values are determined by the client's values or the server's values after an action response updates a form's card.

(Generally Available): You can now call version 3 of the Google Drive API from Apps Script with the advanced Drive service. To learn more, see Advanced Drive service.

To fix a bug that prevented events of eventType != 'default' from importing, we updated the code sample in Populate a team vacation calendar, the popular Apps Script + Calendar API solution. Review the code change in GitHub.

(Generally available): You can now delete versions in your Apps Script project from the project history page in the Apps Script IDE.

Script projects created after December 10, 2023 can have up to 200 versions. If your script reaches the versions limit, or you want to clean up your script project, delete undeployed versions that you no longer need.

To learn more, see Delete a version.

(Developer Preview): Google Workspace Add-ons now support third-party resource creation from the @ menu in Google Docs. To use this feature, see Create third-party resources from the @ menu.

(Developer Preview): Available as part of the Google Workspace Developer Preview Program, which grants early access to certain features.

Google Workspace Add-ons now support link previews in Google Sheets and Slides. To learn more, see Preview links with smart chips.

(Generally available): You can now call the Chat API from Apps Script with the Advanced Chat Service. To learn how, see Advanced Chat Service in the Apps Script reference documentation.

We've also updated the Apps Script code samples to use the Advanced Chat Service in the following Chat API developer guides:

The email address that sends notifications about errors in triggers has been updated from apps-scripts-notifications@google.com to noreply-apps-scripts-notifications@google.com.

The classic Google Sites service has been deprecated due to the transition from classic Sites to new Sites. There isn't a way to connect to new Sites with Apps Script.

You can now view previously deployed script versions and compare them to the current script version in the Apps Script IDE. Anyone who has edit permission on an Apps Script project can access the project history page. To learn more, refer to the following:

Google Workspace Updates blog: View & compare script versions with Apps Script project history

Developer documentation: Versions

Third-party smart chips and link previews are now generally available. To build a Google Workspace Add-on that uses this feature, see Preview links with smart chips.

Apps Script has deprecated the Contacts service. Instead, use the People API advanced service. Refer to Migrate from Contacts service to People API advanced service.

The Contacts service shutdown has been rescheduled from April 2023 to January 2025. Refer to the Apps Script sunset schedule.

Apps Script added a new method to the Utilities class. parseDate(date, timeZone, format) parses a provided string date according to the specification described in the Java Standard Edition SimpleDateFormat class.

Apps Script has sunset the following methods:

There isn't a replacement method to get this data with Apps Script.

Learn about the switch from Classic Hangouts to Chat.

Apps Script has turned down the legacy integrated development environment (IDE) in favor of the redesigned IDE that launched in December 2020.

Learn more about the IDE updates from the following blog posts:

Apps Script now automatically deletes default Google Cloud projects (Google Cloud projects that Apps Script creates in the background) when their associated scripts haven't run in 180 days or more. If the script runs after Apps Script deletes the default Google Cloud project, Apps Script creates one for the script.

This update doesn't affect standard Google Cloud projects (Google Cloud projects created by people).

Apps Script has deprecated the following methods:

These methods will become unavailable later this year once Google switches all users from Classic Hangouts to Google Chat. There isn't a replacement method to get this data with Apps Script.

Learn about the switch from Classic Hangouts to Chat.

You can now call functions in separate files before they're parsed. Previously, the V8 runtime required a script file to be parsed before any other file could call the functions it defines.

Now, the order of files in the Apps Script editor doesn't matter. This means that you can call a function in a different file to assign a value to a global variable—the function is always defined before it's called. This behavior reflects that of the legacy Rhino runtime.

You can now perform the following actions in the new Apps Script integrated development environment (IDE):

For Google Workspace Add-ons, an Attachment class has been added to the Card Service that lets you add custom attachments to Calendar events. You can also set an event trigger that fires when the user clicks on the add-on attachment provider in the Calendar dropdown menu. For more information, refer to EventAttachmentTrigger.

The get methods for several color objects in the Spreadsheet Service have been deprecated in favor of a new naming convention. The functionality remains the same. For example, the getFontColor() method from the Range class has been replaced with getFontColorObject().

The following classes have updated get methods for color objects:

Owners receive email alerts when someone outside the owner's organization edits a script project in the new integrated development environment (IDE).

For container-bound scripts: If someone outside the container owner's organization creates or edits a container-bound script project, the container owner receives an email notification.

For standalone scripts: If someone outside the script project owner's organization edits a standalone script project, the script project owner receives an email notification.

The following classes have been added to the Spreadsheet Service to let you add images to cells:

To add an image to a cell, you must create a new image value for the image using SpreadsheetApp.newCellImage() and CellImageBuilder. Then, use Range.setValue(value) or Range.setValues(values) to add the image value to the cell.

Versions 1.0 and 1.1 of the TLS security protocol are disabled. To establish JDBC connections, use TLS 1.2 or higher.

In the HTML Service iframe sandbox, allow-top-navigation, which allows the content to navigate its top-level browsing context, is restricted and not set as an attribute in the sandbox. Instead, the allow-top-navigation-by-user-activation attribute has been added to the sandbox.

If you need to redirect your script, add a link or a button for the user to take action on.

Learn more about HMTL Service restrictions.

The Drive Service has added three new methods to the file and folder classes to manage the use of resource keys when sharing files and folders.

Learn more about the resource key security update for Drive.

The Document Service has added support for smart chips by adding three new classes:

Learn more about smart chips in Google Docs.

The Microsoft SQL Server JDBC driver was updated to version 7.2.1. If you encounter issues, report them on the issue tracker. If you're an administrator and need live support, contact Google Workspace support.

A new divider widget has been added for Google Workspace Add-ons. To add a divider to an add-on card, use the newDivider() method within the Card service.

A new method has been added to the Sheet class of the Spreadsheet service. setRowHeightsForced(startRow, numRows, height) lets you manually set the height for a row or a set of rows.

The following updates have been made to deployments in the new editor:

To learn more, see Create and manage deployments.

The Apps Script integrated development environment, or IDE, has been fully redesigned. Along with a completely new interface, the following features have been updated:

To switch back to the legacy IDE from within the editor, at the top, click Use legacy editor.

An advanced service for Google Tables has been added to Apps Script. The Tables service allows scripts to programmatically read and edit rows within Tables.

New classes and methods have been added to support Connected Sheets.

The following new classes have been added to the Spreadsheet service:

New methods to support Connected Sheets have been added to the following classes in the Spreadsheet service:

A new class called DecoratedText has been added to the Card Service. DecoratedText adds text with optional decorations and was added to replace the KeyValue class.

To help simplify Google Drive's folder structure and sharing models, new methods have been added to the Drive service and some existing methods have been deprecated.

The DriveApp now has an enforceSingleParent(value) method that enables or disables enforceSingleParent behavior.

The File class now has the following methods:

The Folder class now has the following methods:

The following Folder class methods have been deprecated:

New methods have been added to the Spreadsheet service:

A new simple trigger, onSelectionChange(e), has been added for Google Sheets. The onSelectionChange(e) trigger runs automatically when a user changes the selection in a spreadsheet.

The following has been added to the Spreadsheet service:

The following has been added to the Drive service:

The following methods have been added to the Spreadsheet service to support the use of theme colors. Many of these methods duplicate the effect of existing color methods, but let you use Color objects instead of strings as parameters and return types:

Apps Script now supports the V8 runtime. This enables modern JavaScript features and syntax in Apps Script. You can migrate existing scripts to use V8 and its features.

To support the launch of G Suite Add-ons, the following manifest changes, service, classes, and methods have been added to Add-ons:

The add-ons manifest structure has been updated to provide configuration controls for G Suite Add-ons. All add-on manifest settings are specified in the AddOns object in the manifest. Manifest fields that previously supported Gmail add-ons still exist, but are now deprecated. See Upgrading your published add-ons for instructions on how to upgrade a Gmail add-on into a G Suite add-on.

The Card service has been extended with the following classes and methods that provide new widgets and event responses:

The Conference Data service has been added to Apps Script. The service helps G Suite Add-ons that extend Google Calendar to stay in sync with third-party conferencing applications. This service is only useful to developers who manage a conferencing application and want to make it available in Google Calendar.

The Spreadsheet service has been extended with the following class and new methods to support using color building and theme colors:

The Data Studio service has been extended with the following class and new methods to support different response types and dynamic statuses:

The Spreadsheet service has been extended with the following class and new methods to support using slicers to filter ranges, charts, and pivot tables:

The Script service has been extended with the ScriptApp.getIdentityToken() method, which returns an identity token for the effective user.

You can no longer publish web apps to the Chrome Web Store. The Chrome Web Store deprecated Chrome apps in 2016 and they are now only available for ChromeOS devices. This change includes published Apps Script web apps. Previously published web apps are no longer discoverable in the Chrome Web Store. Editor Add-ons aren't affected; you can still publish Editor Add-ons to the Chrome Web Store.

The Slides service class RgbColor and the enumeration ColorType have been moved from the Slides service to the [Base script service](https://developers.google.com/apps-script/reference/base). The functionality of these classes has not changed. Moving these classes to the Base script service enables other services to make use of them in the future. You can now find the documentation for these classes at [RgbColor](https://developers.google.com/apps-script/reference/base/rgb-color) and [ColorType`](https://developers.google.com/apps-script/reference/base/color-type).

Several classes and methods relating to the now shutdown UiApp service have been removed. Most of these methods involved interactions between the Charts service and UiApp that were very seldom used. The following is a full list of the removed classes and methods:

The Card service methods CardHeader.setUrl(url) and Image.setUrl(url) have been updated to accept an encoded image data string as an input parameter. As before, you can alternatively use a publicly-available image URL as the input parameter.

Documentation for the UI service has been removed. This service was deprecated in December 2014 and officially shut down on July 15, 2019. To build interfaces for web apps and Editor Add-ons, use the HTML service.

The Document service has been updated to add methods to get and set the language of a document:

The Data Studio service has been updated to add a few values to FieldType enum:

The behavior of the Google Cloud (GCP) projects used by scripts has been altered. Now, the default GCP projects that Apps Script creates for new scripts are hidden and script owners can't access them directly. Admins and domain users with the resourcemanager.projects.list permission on the parenting GCP folder can still access default GCP projects.

If you need access to a script's GCP project (because you wish to publish it or take a similar action), it's best to switch your script to use a standard GCP project.

The Spreadsheet service has been extended with the following new classes and methods to support BigQuery data connectors in Sheets:

The Data Studio service has been extended with the following new methods involving reaggregation settings:

The deprecated UiApp service will be officially shutdown on July 15th, 2019. After this date, the service will no longer function for any script project.

The Slides service has been extended with the following new classes and methods that support connector lines:

The Fusion Tables advanced service has been deprecated and will shutdown fully on December 3rd, 2019.

The following methods in the Spreadsheet service now return an OverGridImage object instead of void:

The Spreadsheet service has been extended with the following new classes and methods:

The following methods have been added to existing services:

The Card service has been extended with the following classes and methods to support Gmail add-on compose actions:

The Data Studio service is now available. You can use this service when building a Data Studio Community Connector.

The Utilities service has been extended with the following methods and classes:

The quota limits for UrlFetch GET response size and POST size have been increased to 50MB / call.

The quota on total data received by UrlFetch per day per user has been removed.

Macros for Google Sheets are now becoming available for users, and will finish rolling out over then next few weeks. This feature lets you record macros in the Google Sheets UI and use Apps Script to create or edit them.

The Sheets service has been extended with a large number of new classes and methods. The addition of these methods make it possible to reproduce in code nearly any action a Sheets user can take at a keyboard. The new classes and methods include:

The Charts service has been extended to support EmbeddedCharts in Google Sheets with the enums ChartHiddenDimensionStrategy and ChartMergeStrategy. In addition, the following ChartTypes have been added:

The Spreadsheet service has been extended with the following new methods:

Calendar event triggers are now available. You can use these triggers in conjunction with the Calendar advanced service to discover recently changed calendar events via regular sync operations.

Add-ons now require OAuth Client Verification prior to beginning the publication process. Verification no longer is conducted during the add-on review.

Added Apps Script support for the Google Slides service. You can now use Apps Script to create and edit presentations and their contents; you can also build add-ons for Google Slides.

To protect users from abuse, Google OAuth clients that request certain sensitive OAuth scopes are subject to review by Google. Such apps may present users with a warning screen saying the app is unverified by Google. You can remove this screen from your app's authorization flow by submitting a review request.

Stackdriver Logging has been moved out of Early Access. All scripts now have access to Stackdriver logging.

Added the method Range.randomize() that randomizes the order of rows in a spreadsheet Range.

Introduced the Early Access program for new G Suite Business features. These features include App Maker and Stackdriver Logging.

Added forms validation classes for check boxes, generic data, grid items, paragraph text items, and text items.

Added X-Frame-Option header support to HtmlService, allowing iframes to render Apps Script HTML and web apps.

Added support for Android add-ons. Now you can make Google Docs and Sheets add-ons that work on Android.

The use of project keys to identify scripts is now deprecated. The preferred unique identifier for a script is the Script ID. There are no plans to turn off or disable the use of project keys; code that uses project keys will continue to work for the foreseeable future.

NATIVE sandbox mode is now shut down. All scripts default to IFRAME mode, regardless of which mode, if any, is specified. Scripts that relied on NATIVE mode features may need to be migrated.

Support for PATCH requests has been added to UrlFetchApp.

Deprecated the add(widget) method in the DashboardPanel class because it takes a UiApp.Widget argument, and UiApp was deprecated in 2014.

The Spreadsheet API adds new methods for getTabColor() and setTabColor(color).

The Spreadsheet API adds a new NamedRange type and the following related methods:

The Utilities API includes a new getUuid() method that generates a unique identifier.

In the HTML service, EMULATED sandbox mode was sunset. Any scripts that explicitly request EMULATED mode now default to IFRAME mode.

In the HTML service, all new scripts default to IFRAME sandbox mode unless NATIVE mode is explicitly specified.

Deprecated the method Service.enable() in the ScriptApp global object. This method is no longer useful because Apps Script's authorization model has changed since the time the method was introduced.

Added the following methods to the Spreadsheet service to let scripts control "warning-based" protection for spreadsheet ranges (which means that every user can edit data in the area, except editing prompts the user to confirm the edit):

Added two variations of the method computeRsaSha256Signature to the Utilities global object to let scripts sign a string using the RSA SHA-256 algorithm.

Added the method getUserAgent() to the HtmlService global object to let scripts get the user-agent string for the current browser.

Deprecated the following OAuth class and methods in favor of OAuth libraries: + OAuthConfig + UrlFetchApp.addOAuthService(serviceName) + UrlFetchApp.removeOAuthService(serviceName)

The DocsList service, which was deprecated in 2014, has been sunset and no longer functions. Users relying on DocsList should switch to DriveApp.

Deprecated the URL Fetch service's class OAuthConfig, which provided the ability to connect to OAuth 1.0 APIs. This has been replaced by the open source library OAuth1 for Apps Script. See the migration guide for more information.

Added the following class, enum, and methods to the Spreadsheet service, to give precise control over protected sheets and ranges:

Deprecated the following class and methods, which have been replaced by the more powerful Protection class above. Although this class and these methods are deprecated, they will remain available for compatibility with the older version of Sheets.

Replaced the method SpreadsheetApp.open(file), which takes a File object from the deprecated DocsList service as a parameter, with a version that takes a File object from the Drive service instead. The new method has the same name.

Changed the Document service methods Text.getFontFamily() and Text.setFontFamily(fontFamilyName) to use string names for font families instead of the FontFamily enum, and consequently deprecated FontFamily.

Changed several Spreadsheet methods that previously returned void so that they now return a Spreadsheet object that can be used to chain method calls.

Issue 4617: HTML service pages that use the new IFRAME sandbox mode now render correctly in Firefox.

Added a new IFRAME sandbox mode for HTML service that imposes many fewer restrictions than the other sandbox modes and runs much faster. However, IFRAME mode does not work at all in certain older browsers, including Internet Explorer 9.

Add-ons are now available in Google Forms. As with add-ons for Docs and Sheets, Forms add-ons are in developer preview, so you must apply to publish them.

Removed the Finance service, as announced earlier in the year.

Issue 3928: The Document method setSelection, the Sheet method activate, and the Spreadsheet methods setActiveRange and setActiveSelection now work correctly if they are called from an onOpen or onEdit trigger.

Add-ons for Google Sheets and Docs can now use time-driven installable triggers.

The UiService widget DocsListDialog now requires that you call DocsListDialog.setOAuthToken(oAuthToken) before calling DocsListDialog.showDocsPicker().

Replaced the CacheService methods getPrivateCache() and getPublicCache() and the LockService methods getPrivateLock() and getPublicLock() with getUserCache(), getScriptCache(), getUserLock(), and getScriptLock(), respectively. The old method names have been deprecated, but will continue to function. The new names follow the same conventions as PropertiesService.

Added the value ON_CHANGE to the ScriptApp.EventType enum so that Google Sheets change events can be detected correctly.

Deprecated the script gallery in the old version of Google Sheets. As explained in the blog post, the add-on store in the new version of Sheets gives developers wider distribution, automatic updates, and several other features not available in the script gallery.

Added the Document service methods getTextAlignment and setTextAlignment as well as the enum TextAlignment, to support NORMAL, SUPERSCRIPT, and SUBSCRIPT text alignment in Google Docs.

Deprecated both ScriptDB and the Domain service. As announced in the blog post, the services will remain available for the next six months but will be turned off on November 20, 2014. To replace ScriptDB, see the migration guide and the improved guide to connecting to external databases through JDBC. To replace the Domain service, see the Admin SDK Directory and Admin SDK Reports advanced services.

Added a source property to the event parameter for form triggers. This makes it possible to retrieve the form that triggered the event.

The "Report an issue" dialog for add-ons now asks users whether they would like to share their name and email address with the developer.

In the new version of Google Sheets, the Undo command can now revert changes made by a script. This was already true in Docs, Forms, and the older version of Sheets.

The Document method setSelection, the Sheet method activate, and the Spreadsheet methods setActiveRange and setActiveSelection no longer have any effect if they are called from an onOpen or onEdit trigger.

The deprecated SOAP service and old XML service have now been removed from autocomplete and documentation, as announced on July 9, 2013 and documented in the Apps Script sunset schedule. Existing scripts that use these services should still function. The UI service widgets DeckPanel, DecoratedPopupPanel, DockLayoutPanel, DockPanel, StackLayoutPanel, and TabLayoutPanel have been completely disabled, as announced on April 15, 2013.

The Range method getDataSourceUrl() is now supported in the new version of Google Sheets. For information on other incomplete Apps Script features in the new version of Sheets, see the list of known issues.

When an add-on is installed from the store, the onInstall() simple trigger is now passed an event parameter, e, which includes an authMode property. This makes it easier for an add-on to call onOpen(e) from onInstall(e).

In the new version of Google Sheets, Range.setValues() now automatically extends the spreadsheet if the range is larger than the present size.

Issue 3757: The link to the Google Developers Console in the Advanced Google Services dialog now opens the correct project.

Announced a developer preview for add-ons in Google Docs and the new version of Google Sheets, with support for Google Forms coming soon. An add-on is an Apps Script project published to a store inside Docs or Sheets, which makes it easy for users to find and install new features. Our guides cover everything you need to know to develop, design, and apply to publish your first add-on.

Changed the quota for Gmail from 10,000 reads and 10,000 writes per day (excluding sent messages) to 20,000 reads and writes combined per day.

Deprecated the Finance service. As announced in the blog post, the service will remain available for the next six months but will be turned off on September 26, 2014.

Issue 3622: The title bar of a sidebar shown by a script in Google Docs, Forms, or the new version of Sheets is now the same height as in a sidebar shown by a built-in feature.

Removed the Session method getActiveUserTimeZone(), which did not return a value for most users.

The quota for the number of email recipients for scripts running from consumer (gmail.com) or free Google Apps accounts has been reduced from 500 to 100 per day. The quota for paid Google Apps accounts has not been changed.

Added the following Session methods, which allow scripts to determine the user's locale and time zone:

Renamed several classes and methods in DocumentApp. The old names are deprecated but will continue to work. You do not need to update your code.

The new SpreadsheetApp method Spreadsheet.getUi() allows scripts to access the spreadsheet's user-interface environment in order to add features like menus, dialogs, and sidebars. This method is consistent with the getUi() methods in DocumentApp and FormApp, but only works in the new version of Google Sheets. The older version of Google Sheets continues to use the existing methods documented in the guides to dialogs and sidebars and menus.

Renamed the Cursor object in DocumentApp to Position. This does not require any changes to existing code.

Deprecated the SpreadsheetApp.Spreadsheet methods isAnonymousView(), isAnonymousWrite(), isReadable(), isWritable(), and setAnonymousAccess(). Various methods of the File class in DriveApp can achieve the same functionality.

Added the SpreadsheetApp method DataValidationBuilder.requireFormulaSatisfied(String), as well as an accompanying CUSTOM_FORMULA value in DataValidationCriteria. This feature can only be used in the new version of Google Sheets.

Added the advanced parameter escaping to UrlFetchApp.fetch(). If false, reserved characters in the URL will not be automatically escaped.

The Maps.DirectionFinder.Mode enum now includes the TRANSIT value allowing for the retrieval of public transit routes in the Maps service.

Added seven new advanced services: + Admin SDK Directory service + Admin SDK Reports service + Fusion Tables service + Google+ Domains service + Mirror service + YouTube service + YouTube Analytics service

Issue 3461: A yellow warning bar should no longer appear on Apps Script gadgets that are embedded in Google Sites.

Added TITLE and SUBTITLE values to the DocumentApp.ParagraphHeading enum.

The Apps Script methods Utilities.jsonParse() and Utilities.jsonStringify() have been deprecated in favor of the now-standard JavaScript methods JSON.parse() and JSON.stringify(), which now appear in autocomplete.

Issue 3189: A rare issue in which LockService failed to acquire a lock should no longer occur.

If a version of a library has been deleted by the library owner, scripts can no longer use that version.

Issue 2817: Sporadic errors about missing libraries should now occur less frequently.

Issue 74: Simple onEdit() triggers now fire correctly when the user is not signed in to a Google account.

Added the following FormApp methods, which allow scripts to work with progress bars, custom closed-form messages, and YouTube videos. + Form.hasProgressBar() + Form.setProgressBar(enabled) + Form.getCustomClosedFormMessage() + Form.setCustomClosedFormMessage(message) + Form.addVideoItem()

Added the following DriveApp methods, which allow scripts to get the owner of a File or Folder.

The UiApp widgets Hyperlink, InlineHyperlink, LayoutPanel, and RichTextArea have now been disabled, as announced on March 13, 2013 and documented in the Apps Script sunset schedule.

Added the DocumentApp methods InlineImage.getLinkUrl() and InlineImage.setLinkUrl(url).

Deprecated the DocumentApp methods getFootnotes(), getLinkUrl(), setLinkUrl(url), and isAtDocumentEnd() in the classes FooterSection, FootnoteSection, and HeaderSection, as well as the methods getNextSibling() and getPreviousSibling() in the classes FooterSection and HeaderSection. These methods were not useful.

Issue 2621: A situation in which certain scripts did not terminate despite exceeding the execution-time limit no longer occurs.

Removed the ability to get the user's email address in simple onEdit() triggers. Because simple triggers don't request user authentication, this change was important to protect the identity of collaborators who hadn't explicitly granted permission for the script to collect their email address.

Added the DriveApp methods File.makeCopy(destination) and File.makeCopy(name, destination), which allow scripts to specify a folder to which a file should be copied.

Issue 3097: A performance issue that affected certain scripts no longer occurs.

Added the method Spreadsheet.deleteSheet(sheet), which allows deletions of sheets that are not the active sheet.

Deprecated the DocsList methods find(query, start, max), getAllFiles(start, max), getAllFolders(start, max), getFiles(start, max), getFilesByType(fileType, start, max), and getFolders(start, max). Instead of these methods, use DriveApp or one of the DocsList.get*ForPaging() methods.

All new scripts now use the new authorization flow by default.

On ChromeOS devices, it is now possible to activate autocomplete (sometimes called "content assist") with the keyboard shortcut Ctrl + Space.

Issue 2947: Newlines are now supported in Ui.alert() and Ui.prompt() dialogs.

Added DriveApp and FormApp to the services tracked on the Apps Script Dashboard.

Issue 2801: Fixed an issue in which specific URL parameters did not work with HtmlService.

Added XmlService to replace the old Xml service.

Deprecated the old Xml service, SoapService, and support for the JavaScript feature E4X.

Issue 2158: The request object passed in to doPost() methods now contains the POST body. It can be accessed using e.postData.getDataAsString().

Issue 2740: UrlFetchApp.fetch() calls no longer fail if the advanced parameters specify a payload without specifying the request method.

Issue 1363: Added support for spreadsheet change events. The onChange() event now fires when certain modifications, such as row insertions, are done to a spreadsheet.

Issue 2585: Xml.parse() once again correctly parses well-structured XML and HTML documents.

Large scripts in the Script Gallery now install more quickly.

The following changes were made to simplify the Document service:

Deprecated UiApp widgets DeckPanel, DecoratedPopupPanel, DockLayoutPanel, DockPanel, StackLayoutPanel, and TabLayoutPanel, which had limited usability.

Issue 2565: DocsList.createFile() no longer allows the creation of files with invalid MIME types or Google document MIME types.

Issue 995: The new methods Sheet.hideSheet(), Sheet.isSheetHidden(), and Sheet.showSheet() allow scripts to control the visibility of individual sheets within a spreadsheet.

Renamed the action "Publish to Gallery" to "Submit to Gallery", to avoid confusion with publishing a web app.

Deprecated the GUI Builder and the UIApp widgets Hyperlink, InlineHyperlink, LayoutPanel, RichTextArea, and SuggestBox, which had limited usability.

Issue 1917: It is no longer possible to install a script multiple times from the Script Gallery.

When setting font colors in a spreadsheet using Range.setFontColor() or Range.setFontColors(), color names will now automatically be converted to their corresponding hexadecimal values. For example, after calling setFontColor('red') the method getFontColor() will return "#ff0000".

Added the method DocumentApp.openByUrl(), which allows documents to be opened by their URL directly.

Added the ability to directly attach StaticMap objects in emails.

Added the method SpreadsheetApp.openByUrl(), which allows spreadsheets to be opened by their URL directly.

Added the method after(durationMilliseconds) to class ClockTriggerBuilder to simplify the creation of one-off triggers.

Issue 2204: Utilities.formatDate no longer rejects certain time-zone formats, such as EST, CST, etc.

Added extra validation to the datasource URLs used in charts. Custom datasource URLs that rely on non-Google authentication will no longer work.

Added the ability to disable SSL certificate validation in the SoapService, in response to a feature request.

Updated some icons to match icons of other Google Drive applications.

Added options to EmbeddedChartBuilder to make it easier to configure embedded charts. EmbeddedChartBuilder now contains the methods asAreaChart(), asBarChart(), asColumnChart(), asLineChart(), asPieChart(), asScatterChart() and asTableChart() as replacements for calls to setChartType().

Fixed an issue where certain files could not be copied via DocsList.copy().

Added a setLabelSeparator() method to CategoryFilterBuilder, to allow for label separator strings to be used.

Enabled SSL certificate validation for UrlFetchApp requests. If you wish to disable this behavior you can set the advanced option validateHttpsCertificates to "false".

Updated DocsList.getFilesByType() to accept values from the DocsList.FileType enumeration. Passing in string values for the document type is deprecated but still functional. (Issue 1755)

Added an isDeleted() method to SitesApp's Page class.

Fixed an issue with scrolling in the script editor so that line numbers will be displayed even when horizontally scrolling on long lines.

Added a getThumbnail() method to the DocsList service's File class.

Made improvements to the speed of handling large batches of data in ScriptDb.

Fixed an issue where setting an empty key in Script Properties or User Properties resulted in a "Data storage error" message.

Fixed an issue where the script editor could not be accessed for some container-bound scripts.

Updated the link to the support page on the Google Apps Script Dashboard.

Added a scrollbar to the file panel in the Script Editor,

Fixed an issue where PDF documents uploaded and saved to Google Drive were being saved as blank files.

Simplified sharing settings for scripts. For new script projects, the script will inherit the permissions of its parent. For example, if a script is associated with a Spreadsheet, and user1@example.com has edit access to the Spreadsheet, then user1@example.com will have edit access to the script. The extra blue Share button will no longer be present on these newly created scripts, since the permissions are tied to those of the parent. For scripts created prior to June 8, 2012, the Share button will remain if the checkbox to "Allow document collaborators to edit project" or "Allow site collaborators and owners to edit project" was not selected for that script. For more information see Security. If you would like to have script source that cannot be modified by the editors of your Spreadsheet or Site, then you can use Script Libraries.

Fixed an issue with ClockTriggerBuilder.nearMinute, where invalid minute values were sometimes created.

Launched the Google Apps Script Dashboard so that developers can view service health and quota limits.

Added a DocumentApp.HorizontalAlignment.JUSTIFY value to the DocumentApp.HorizontalAlignment enumeration.

Fixed an issue where files and collections in Google Docs could not be shared with groups.

Launched the Script service in response to this feature request, which allows developers to programmatically set triggers and manage the publishing of scripts as a service.

Modified document collaboration and sharing rules to make them consistent with what is possible in the user interface.

Fixed an issue where Spreadsheet.insertSheet() failed to properly copy a sheet when given a {template:sheet_obj} parameter.

Added the ability to set the subject line via the subject field in the advanced arguments for GmailMessage.forward().

Fixed an issue where Anchor.setWordWrap() was not working.

Fixed an issue with Paragraph.setHeading() where text was not formatted as expected.

Fixed an issue with the debugger, where it would close when stepping into a function that is located in a different file.

Fixed an issue where an error occurred if an empty ListBox was used as a callback element.

Added support for ScrollPanel to the GUI Builder.

Added supports for projects in Apps Script.

Fixed an issue where Xml.element failed if the child elements were XmlElements.

Fixed an issue where GmailApp.getUserLabelByName() failed for label names that contained spaces.

Fixed an issue with UiApp.getActiveApplication().setStyleAttribute() for 'cursor.'

Added an appendRow() method to Spreadsheet.

Added a method in Utilities class that parses CSV text.

Introducing the Debugger! The debugger significantly enhances the ability of Apps Script users to debug their scripts. With the debugger, users can set breakpoints, inspect variables, step-in and step-out of functions.

Added integration with Google Sites, so that Apps Script can now be run from within Google Sites. Read more here.

Fixed an issue with the Sheet.getFrozenRows, where an error was returned in some cases.

Line numbers in error messages are now denoted with (line nnn), rather than (# nnn), where nnn is the line number.

---

## Groups Service Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/groups

**Contents:**
- Groups Service Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
- Classes
- Group
  - Methods
- GroupsApp
  - Properties
  - Methods
- Role
  - Properties

The Google Groups service allows scripts to access information about Google Groups, such as email addresses or member lists.

The GroupsApp class provides access to Google Groups information and methods like getGroups() to retrieve the groups a user is a direct member of.

The Group class represents a group object, allowing queries about members and their roles.

The Role class defines the possible roles a user can have within a group, such as owner, manager, or member.

This service allows scripts to access Google Groups. It can be used to query information such as a group's email address, or the list of groups in which the user is a direct member. Here's an example that shows how many groups the current user is a member of:

**Examples:**

Example 1 (unknown):
```unknown
var groups = GroupsApp.getGroups();
Logger.log('You are a member of %s Google Groups.', groups.length);
```

---

## How to get help Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/support

**Contents:**
- How to get help Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
- Questions & advice
  - Community Forums (Official)
  - Reddit (Unofficial)
  - Stack Overflow
- Developer product feedback
- Contact Google Workspace support

Different platforms are available to support developers depending on the type of help needed.

Community forums and Stack Overflow are resources for questions and advice, while the Issue Tracker is for product feedback.

Google Workspace administrators have access to email support for developer issues.

Check the Service status dashboard for known outages in Apps Script services.

We use a mixture of different platforms to provide support to developers, so review the options below to determine the best way to get help.

Join the conversation about Google Workspace development in the Google Workspace Developers community forum.

You can also find help in community-run subreddits:

We also use the popular programming Q&A website Stack Overflow to field technical questions. Google doesn't own or manage this site, but you can sign in with your Google account.

Stack Overflow contains questions on a variety of topics, and developers use the tag [google-apps-script] to mark questions relevant to this service. You might want to add additional tags to your question to attract the attention of experts in related technologies.

Search existing questions Ask a new question

If you have feedback about developer product features or functionality, search our Issue Tracker to see if others have already submitted the same feedback. If you find an existing feedback report, click the star next to the issue number to express your agreement and help us prioritize the most important reports. If you have additional context or information to contribute, you can add a comment.

If no one else has submitted similar feedback, you can submit a new feedback report. Please describe your feedback as specifically as possible, including why you think it's important.

Search existing feedback Submit bug Submit feature request

Google Workspace administrators can email a Google Workspace developer support specialist

Make sure you include the following information when you contact us:

---

## HTML Service Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/html

**Contents:**
- HTML Service Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
- Classes
- HtmlOutput
  - Methods
- HtmlOutputMetaTag
  - Methods
- HtmlService
  - Properties
  - Methods

The HTML service in Apps Script allows applications to return HTML, typically for user interfaces.

Key classes for working with HTML in Apps Script include HtmlOutput, HtmlService, and HtmlTemplate.

HtmlOutput objects represent HTML content that can be served from a script and offer methods for managing content, meta tags, and display properties.

HtmlService is the main service for creating and managing HtmlOutput and HtmlTemplate objects.

HtmlTemplate allows for dynamically constructing HTML content before evaluating it to an HtmlOutput object.

This service allows Apps Script applications to return HTML, usually as a user interface. If you're new to using this class, we recommend you also see the guide to Html Service

---

## Introduction Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/api/concepts

**Contents:**
- Introduction Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
- Overview of the API

The Google Apps Script API allows programmatically creating, modifying, and deploying Apps Script projects.

This API replaces and extends the Apps Script Execution API for remote function execution.

The API is divided into resources for managing projects, deployments, versions, processes, and script executions.

The Apps Script API does not work with service accounts and requires enabling and granting access for third-party applications.

The Google Apps Script API lets you programmatically create, modify, and deploy Apps Script projects—actions that otherwise require you to use the Apps Script editor. Your apps can use the API to manage your script projects, create and deploy new script versions, and monitor script executions.

The Apps Script API also replaces and extends the Apps Script Execution API. You can use the Apps Script API to execute Apps Script functions remotely, just as you could with the Execution API.

The Apps Script API is divided into several resources, each with a specific purpose and set of requests you can make. These resources are the following:

---

## JDBC Service Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/jdbc

**Contents:**
- JDBC Service Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
- Classes
- Jdbc
  - Methods
- JdbcArray
  - Methods
- JdbcBlob
  - Methods
- JdbcCallableStatement

The Apps Script JDBC service allows connecting to various JDBC-compliant databases like Google Cloud SQL, MySQL, Microsoft SQL Server, and Oracle.

The Jdbc class is the primary entry point for establishing database connections and creating date/time objects.

The service provides numerous classes representing JDBC concepts, such as JdbcConnection, JdbcStatement, JdbcResultSet, and metadata classes, mirroring methods from the java.sql package.

These classes offer comprehensive methods for managing connections, executing queries and updates, handling different data types (including large objects and XML), retrieving result set information, and obtaining database metadata.

This service allows scripts to connect to JDBC-compliant databases, including Google Cloud SQL, MySQL, Microsoft SQL Server, and Oracle. See also the guide to JDBC.

---

## Language Service Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/language

**Contents:**
- Language Service Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
- Classes
- LanguageApp
  - Methods

The Language service enables scripts to automatically translate text.

The LanguageApp class provides methods for translating text.

The translate method is used to translate text from a source language to a target language.

This service allows scripts to automatically translate text.

**Examples:**

Example 1 (unknown):
```unknown
// The code below will write 'Esta es una prueba' to the log.
var spanish = LanguageApp.translate('This is a test', 'en', 'es');
Logger.log(spanish);
```

---

## Lock Service Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/lock

**Contents:**
- Lock Service Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
- Classes
- Lock
  - Methods
- LockService
  - Methods

The Lock service in Apps Script prevents concurrent access to sections of code, useful for managing shared resources and preventing collisions.

The LockService class provides methods to get different types of locks: document, script, and user.

The Lock class represents a mutual-exclusion lock and includes methods to check if a lock is acquired, release a lock, and attempt to acquire a lock with or without timing out.

This service allows scripts to prevent concurrent access to sections of code. This can be useful when you have multiple users or processes modifying a shared resource and want to prevent collisions.

---

## Manifest structure Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/manifest

**Contents:**
- Manifest structure Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways

An Apps Script project's manifest file defines its function or purpose.

The manifest uses a JSON data structure with various fields for configuration.

Fields in the manifest can configure the project as a Google Workspace add-on, Google Chat app, or web app.

The manifest includes configurations for dependencies, exception logging, authorization scopes, runtime version, and time zone.

A URL allowlist can be used in the manifest to restrict fetched URL endpoints.

This page describes the top-level of an Apps Script project's manifest file JSON data structure. The manifest defines the function or purpose of the Apps Script project.

The resource configuration of the project if deployed as a Google Workspace add-on.

The configuration of the project if deployed as a Google Chat app. Note: For new Chat apps, we recommend that you use the addOns.chat field instead. If you are maintaining an existing Chat app that uses the chat field, it should be an empty object. To configure the details of the Chat app, you must enable the Google Chat API. For details, see Configure the Google Chat API. Apps Script handles authorization at the script level. Chat apps that require authorization can't perform any actions until the user authorizes the Chat app. To post a message before authorization, you can add an addToSpaceFallbackMessage object to the manifest. If your Chat app requires initialization logic, you might need to duplicate this logic in the onMessage action. The following example shows a Chat app that responds with a default welcome message when a user adds it to a Chat space: "chat": { "addToSpaceFallbackMessage": "Thank you for adding me!" }

Note: For new Chat apps, we recommend that you use the addOns.chat field instead. If you are maintaining an existing Chat app that uses the chat field, it should be an empty object.

Apps Script handles authorization at the script level. Chat apps that require authorization can't perform any actions until the user authorizes the Chat app. To post a message before authorization, you can add an addToSpaceFallbackMessage object to the manifest. If your Chat app requires initialization logic, you might need to duplicate this logic in the onMessage action.

The following example shows a Chat app that responds with a default welcome message when a user adds it to a Chat space:

object (Dependencies)

The configuration of advanced services and libraries enabled for use by the script project.

The location where exceptions are logged. The valid settings are the following:

object (ExecutionApi)

The script project's API executable configuration. This is only used if the project is deployed for API execution.

The definition of authorization scopes used by the script project.

The runtime version the script is using. If this field is not present in the manifest, the script uses the default runtime (STABLE). Valid options for this field are the following:

The resource configuration that defines Sheets macros.

The script time zone in one of the available ZoneId values such as "America/Denver".

A list of HTTPS URL prefixes. If present, any URL endpoint fetched must match one of the prefixes in this list. This can help to protect user data. This field is optional for test deployments, but is required for deployments. Learn more about allowlisting URLs.

The script project's web app configuration, which is only used if the project is deployed as a web app.

---

## Maps Service Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/maps

**Contents:**
- Maps Service Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
- Classes
- Avoid
  - Properties
- Color
  - Properties
- DirectionFinder
  - Methods
- DirectionFinderEnums

The Maps service allows scripts to generate static maps, find directions, convert addresses to coordinates, and sample elevations.

The service provides classes for finding directions, geocoding, sampling elevation, and creating static map images.

Enums are available for defining restrictions to avoid in directions, map image formats, marker sizes, travel modes, and map types.

You can create new instances of DirectionFinder, ElevationSampler, Geocoder, and StaticMap using the Maps class methods.

Authentication for a Google Maps APIs Premium Plan account can be set to leverage additional quota allowances.

This service allows scripts to generate static maps, find directions, convert addresses into geocode coordinates, and sample elevations.

---

## Migrate from Contacts service to People API advanced service Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/migration/contacts-people

**Contents:**
- Migrate from Contacts service to People API advanced service Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
- Methods without People API equivalents
- Additional features available with People API
- Code samples for common tasks
  - Get a contact group by name
  - Get a contact by email address
  - Get all contacts
  - Get a contact’s full name
  - Get all phone numbers for a contact

You must migrate your scripts from the Contacts service to the People API advanced service before the Contacts service shuts down on January 31, 2025.

The People API advanced service uses a newer JSON protocol and offers advanced features not available in the Contacts service.

While some Contacts service search methods lack direct People API equivalents, you can still search by fields like names, email addresses, and phone numbers.

The People API advanced service provides additional features like specifying data sources, searching by query strings, and batch requests.

Code samples are provided for common tasks to assist with migrating from the Contacts service to the People API advanced service.

Apps Script deprecated the Contacts service on December 16,2022. Instead, use the People API advanced service. The People API uses a newer JSON protocol and provides advanced features, like merging contacts with profiles.

Use this guide to learn which Contacts service methods have no equivalent in the People API advanced service, learn what you can use instead, and find code samples for migrating common tasks. For more information, refer to the Contacts API Migration Guide.

The following lists getContacts methods in the Contacts service that don’t have equivalent ways to search for contacts in the People API advanced service. With the People API advanced service, you can search by a contact's names, nickNames, emailAddresses, phoneNumbers, and organizations fields that are from the CONTACT source.

The following lists getContacts methods from the Contacts service that use an extra label parameter. You can use searchContacts from the People API advanced service to get contacts by the equivalent field, but you can’t limit the search to a specific label.

When you migrate to the People API advanced service, you can access the following People API features that aren't available in the Contacts service:

This section lists common tasks from the Contacts service. The code samples show how to construct the tasks using the People API advanced service.

The following code sample shows how to get a contact group by its name, which is the equivalent to getContactGroup(name) in the Contacts service.

The following code sample shows how to get a contact by their email address, which is the equivalent to getContact(emailAddress) in the Contacts service.

The following code sample shows how to get all of a user’s contacts, which is the equivalent to getContacts() in the Contacts service.

The following code sample shows how to get a contact’s full name, which is the equivalent to getFullName() in the Contacts service.

The following code sample shows how to get all of the phone numbers for a contact, which is the equivalent to getPhones() in the Contacts service.

The following code sample shows how to get a specific phone number for a contact, which is the equivalent to getPhoneNumber() in the Contacts service.

---

## Optimization Service Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/optimization

**Contents:**
- Optimization Service Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
- Classes
- LinearOptimizationConstraint
  - Methods
- LinearOptimizationEngine
  - Methods
- LinearOptimizationService
  - Properties
  - Methods

The linear optimization service is used to model and solve linear and mixed-integer linear programs.

Key classes for this service include LinearOptimizationConstraint, LinearOptimizationEngine, LinearOptimizationService, and LinearOptimizationSolution.

The LinearOptimizationEngine is used to build the linear program model by adding constraints and variables, and setting the optimization direction.

The LinearOptimizationSolution provides methods to retrieve the objective value, the status of the solution, and the values of the variables.

The Status property indicates the result of the solve operation, such as OPTIMAL, FEASIBLE, or INFEASIBLE.

The linear optimization service, used to model and solve linear and mixed-integer linear programs.

---

## Populate a team vacation calendar Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/samples/automations/vacation-calendar

**Contents:**
- Populate a team vacation calendar Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
- Objectives
- About this solution
  - How it works
  - Apps Script services
- Prerequisites
- Set up the script
  - Create a team vacation calendar
  - Create the Apps Script project

This solution automatically populates a shared team vacation calendar by syncing events from individual team members' Google Calendars.

The script scans the personal calendars of members in a specified Google Group for events containing keywords like "Vacation" or "Out of office" and adds them to the shared calendar.

The automation runs hourly using a time-driven trigger in Apps Script, which can be modified to change the scanning frequency.

The solution utilizes the Apps Script Groups service to identify group members and the Calendar advanced service to access and manage calendar events.

Prerequisites include having a Google Account and access to the internet, and the setup involves creating a team vacation calendar and configuring an Apps Script project.

Coding level: Beginner Duration: 15 min Project type: Automation with a time-driven trigger

A shared vacation calendar is a great tool for helping your team collaborate; anyone can determine who's out of the office at a glance. This solution lets you see when your colleagues are out of the office, with no manual entry required.

This solution populates a shared vacation calendar based on the individual calendars of each person in a Google Group. When someone books time off, they add an event to their personal Google Calendar using a keyword like "Vacation" or "Out of office."

Every hour, the script scans the calendars of the members in the group and syncs appropriate events to the shared calendar. You can change how often the script scans for new events.

This solution only accesses Calendar events that your colleagues have made visible to you via their privacy settings.

This solution uses the following services:

To use this sample, you need the following prerequisites:

When prompted, authorize the script. If the OAuth consent screen displays the warning, This app isn't verified, continue by selecting Advanced > Go to {Project Name} (unsafe).

When complete, return to Calendar to confirm the Team Vacations calendar is populated with events.

To review the Apps Script code for this solution, click View source code below: View source code Code.gs

---

## Preview links with smart chips Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/add-ons/editors/gsao/preview-links

**Contents:**
- Preview links with smart chips Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
- How users preview links
  - How users preview links in Slides
- Prerequisites
  - Apps Script
  - Node.js
  - Python
  - Java
- Optional: Set up authentication to a third-party service

Google Workspace add-ons can enhance link interactions in Docs, Sheets, and Slides by replacing them with smart chips or linked titles that reveal detailed previews.

Add-on developers can use Apps Script, Node.js, Python, or Java to build these link preview functionalities, leveraging widgets and actions to create interactive cards.

To implement this, developers need to configure link preview triggers in the add-on's manifest, defining URL patterns and a callback function that returns a card object with relevant information.

Preview cards are cached for 5 minutes and can be refreshed if the title changes; however, Slides currently only supports linked titles with previews, not third-party smart chips.

The documentation provides code samples for different programming languages and demonstrates a support case scenario to guide developers through the process.

This page explains how to build a Google Workspace add-on that lets Google Docs, Sheets, and Slides users preview links from a third-party service.

A Google Workspace add-on can detect your service's links and prompt users to preview them. You can configure an add-on to preview multiple URL patterns, such as links to support cases, sales leads, and employee profiles.

To preview links, users interact with smart chips and cards.

When users type or paste a URL into a document or spreadsheet, Google Docs or Google Sheets prompts them to replace the link with a smart chip. The smart chip displays an icon and short title or description of the link's content. When the user hovers over the chip, they see a card interface that previews more information about the file or link.

The following video shows how a user converts a link into a smart chip and previews a card:

Third-party smart chips aren't supported for link previews in Slides. When users type or paste a URL into a presentation, Slides prompts them to replace the link with its title as linked text instead of a chip. When the user hovers over the link title, they see a card interface that previews information about the link.

The following image shows how a link preview renders in Slides:

If your add-on connects to a service that requires authorization, users must authenticate to the service to preview links. This means that when users paste a link from your service into a Docs, Sheets, or Slides file for the first time, your add-on must invoke the authorization flow.

To set up an OAuth service or custom authorization prompt, see Connect your add-on to a third-party service.

This section explains how to set up link previews for your add-on, which includes the following steps:

To configure link previews, specify the following sections and fields in your add-on's manifest:

In each field, implement the linkPreviewTriggers trigger that includes a runFunction (You define this function in the following section, Build the smart chip and card).

To learn about what fields you can specify in the linkPreviewTriggers trigger, see the reference documentation for Apps Script manifests or deployment resources for other runtimes.

In the oauthScopes field, add the scope https://www.googleapis.com/auth/workspace.linkpreview so that users can authorize the add-on to preview links on their behalf.

As an example, see the oauthScopes and addons section of the following manifest that configures link previews for a support case service.

In the example, the Google Workspace add-on previews links for a company's support case service. The add-on specifies three URL patterns to preview links. Whenever a link matches one of the URL patterns, the callback function caseLinkPreview builds and displays a card and a smart chip in Docs, Sheets, or Slides, and replaces the URL with the link title.

To return a smart chip and card for a link, you must implement any functions that you specified in the linkPreviewTriggers object.

When a user interacts with a link that matches a specified URL pattern, the linkPreviewTriggers trigger fires and its callback function passes the event object EDITOR_NAME.matchedUrl.url as an argument. You use the payload of this event object to build the smart chip and card for your link preview.

For example, if a user previews the link https://www.example.com/cases/123456 in Docs, the following event payload is returned:

To create the card interface, you use widgets to display information about the link. You can also build actions that let users open the link or modify its contents. For a list of available widgets and actions, see Supported components for preview cards.

To build the smart chip and card for a link preview:

The following code creates the callback function caseLinkPreview for Docs:

Google Workspace add-ons support the following widgets and actions for link preview cards:

The following example features a Google Workspace add-on that previews links to a company's support cases in Google Docs.

The example does the following:

**Examples:**

Example 1 (unknown):
```unknown
{
  "oauthScopes": [
    "https://www.googleapis.com/auth/workspace.linkpreview"
  ],
  "addOns": {
    "common": {
      "name": "Preview support cases",
      "logoUrl": "https://www.example.com/images/company-logo.png",
      "layoutProperties": {
        "primaryColor": "#dd4b39"
      }
    },
    "docs": {
      "linkPreviewTriggers": [
        {
          "runFunction": "caseLinkPreview",
          "patterns": [
            {
              "hostPattern": "example.com",
              "pathPrefix": "support/cases"
            },
            {
              "hostPattern": "*.example.com",
              "pathPrefix": "cases"
            },
            {
              "hostPattern": "cases.example.com"
            }
          ],
          "labelText": "Support case",
          "logoUrl": "https://www.example.com/images/support-icon.png",
          "localizedLabelText": {
            "es": "Caso de soporte"
          }
        }
      ]
    },
    "sheets": {
      "linkPreviewTriggers": [
        {
          "runFunction": "caseLinkPreview",
          "patterns": [
            {
              "hostPattern": "example.com",
              "pathPrefix": "support/cases"
            },
            {
              "hostPattern": "*.example.com",
              "pathPrefix": "cases"
            },
            {
              "hostPattern": "cases.example.com"
            }
          ],
          "labelText": "Support case",
          "logoUrl": "https://www.example.com/images/support-icon.png",
          "localizedLabelText": {
            "es": "Caso de soporte"
          }
        }
      ]
    },
    "slides": {
      "linkPreviewTriggers": [
        {
          "runFunction": "caseLinkPreview",
          "patterns": [
            {
              "hostPattern": "example.com",
              "pathPrefix": "support/cases"
            },
            {
              "hostPattern": "*.example.com",
              "pathPrefix": "cases"
            },
            {
              "hostPattern": "cases.example.com"
            }
          ],
          "labelText": "Support case",
          "logoUrl": "https://www.example.com/images/support-icon.png",
          "localizedLabelText": {
            "es": "Caso de soporte"
          }
        }
      ]
    }
  }
}
```

Example 2 (unknown):
```unknown
{
  "oauthScopes": [
    "https://www.googleapis.com/auth/workspace.linkpreview"
  ],
  "addOns": {
    "common": {
      "name": "Preview support cases",
      "logoUrl": "https://developers.google.com/workspace/add-ons/images/support-icon.png",
      "layoutProperties": {
        "primaryColor": "#dd4b39"
      }
    },
    "docs": {
      "linkPreviewTriggers": [
        {
          "runFunction": "URL",
          "patterns": [
            {
              "hostPattern": "example.com",
              "pathPrefix": "support/cases"
            },
            {
              "hostPattern": "*.example.com",
              "pathPrefix": "cases"
            },
            {
              "hostPattern": "cases.example.com"
            }
          ],
          "labelText": "Support case",
          "localizedLabelText": {
            "es": "Caso de soporte"
          },
          "logoUrl": "https://developers.google.com/workspace/add-ons/images/support-icon.png"
        }
      ]
    }
  }
}
```

---

## Properties Service Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/properties

**Contents:**
- Properties Service Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
- Classes
- Properties
  - Methods
- PropertiesService
  - Methods
- ScriptProperties
- UserProperties

The Properties service allows scripts to store key-value pairs with different scopes: script, user, or document.

The Properties object provides methods for accessing and managing key-value pairs within a specific property store.

The PropertiesService provides methods to get property stores for the document, script, or user.

ScriptProperties and UserProperties are types of persistent key-value stores with script-wide or user-specific scopes respectively.

This service allows scripts to store strings as key-value pairs scoped to one script, one user of a script, or one document in which an editor add-on is used. For more information about when to use each type of property, see the guide to the Properties service.

---

## Script Service Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/script

**Contents:**
- Script Service Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
- Classes
- AuthMode
  - Properties
- AuthorizationInfo
  - Methods
- AuthorizationStatus
  - Properties
- CalendarTriggerBuilder

The Script service provides access to script triggers and script publishing.

It includes classes for managing authorization modes, statuses, and information.

Various trigger builders are available for specific event types like calendar, clock, document, form, and spreadsheet.

The ScriptApp class allows access to properties like AuthMode, EventType, and TriggerSource, and methods for managing triggers and getting authorization information.

The Service class provides methods to check the status and URL of a published web app.

This service provides access to script triggers and script publishing.

---

## Simple Triggers Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/understanding_triggers

**Contents:**
- Simple Triggers Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
- Getting started
- Restrictions
- onOpen(e)
- onInstall(e)
- onEdit(e)
- onSelectionChange(e)
- doGet(e) and doPost(e)
- Available types of triggers

Simple triggers in Apps Script are reserved functions that run automatically on specific events like opening or editing a document.

Installable triggers offer more features than simple triggers but require activation.

Both simple and installable triggers pass an event object containing context information to the triggered function.

Simple triggers have restrictions, including limitations on services that require authorization and a maximum execution time of 30 seconds.

Triggers let Apps Script run a function automatically when a certain event, like opening a document, occurs. Simple triggers are a set of reserved functions built into Apps Script, like the function onOpen(e), which executes when a user opens a Google Docs, Sheets, Slides, or Forms file. Installable triggers offer more capabilities than simple triggers but must be activated before use. For both types of triggers, Apps Script passes the triggered function an event object that contains information about the context in which the event occurred.

To use a simple trigger, simply create a function that uses one of these reserved function names:

The e parameter in the function names above is an event object that is passed to the function. The object contains information about the context that caused the trigger to fire, but using it is optional.

Because simple triggers fire automatically, without asking the user for authorization, they are subject to several restrictions:

These restrictions do not apply to doGet(e) or doPost(e).

The onOpen(e) trigger runs automatically when a user opens a spreadsheet, document, presentation, or form that they have permission to edit. (The trigger does not run when responding to a form, only when opening the form to edit it.) onOpen(e) is most commonly used to add custom menu items to Google Sheets, Slides, Docs, or Forms.

The onInstall(e) trigger runs automatically when a user installs an Editor add-on from within Google Docs, Sheets, Slides, or Forms. The trigger won't run when a user installs the add-on from the Google Workspace Marketplace website. Note that there are certain restrictions on what onInstall(e) can do, learn more about authorization. The most common use of onInstall(e) is simply to call onOpen(e) to add custom menus. After all, when an add-on is installed, the file is already open, and thus onOpen(e) doesn't run on its own unless the file is reopened.

The onEdit(e) trigger runs automatically when a user changes the value of any cell in a spreadsheet. Most onEdit(e) triggers use the information in the event object to respond appropriately. For example, the onEdit(e) function below sets a comment on the cell that records the last time it was edited.

The onSelectionChange(e) trigger runs automatically when a user changes the selection in a spreadsheet. To activate this trigger, you must refresh the spreadsheet once the trigger is added and every time the spreadsheet is opened.

If the selection moves between multiple cells in a short time, some selection change events might be skipped to reduce latency. For example, if many selection changes are made within two seconds of each other, only the first and last selection changes will activate the onSelectionChange(e) trigger.

In the example below, if an empty cell is selected, the onSelectionChange(e) function sets the cell’s background to red.

The doGet(e) trigger runs automatically when a user visits a web app or a program sends an HTTP GET request to a web app. doPost(e) runs when a program sends an HTTP POST request to a web app. These triggers are demonstrated more in the guides to web apps, HTML service, and Content service. Note that doGet(e) and doPost(e) are not subject to the restrictions listed above.

If the restrictions on simple triggers keep them from meeting your needs, an installable trigger might work instead. The table below summarizes which types of triggers are available for each type of event. For example, Google Sheets, Slides, Forms, and Docs all support simple open triggers, but only Sheets, Docs and Forms support installable open triggers.

function onSelectionChange(e)

function onInstall(e)

* The open event for Google Forms does not occur when a user opens a form to respond, but rather when an editor opens the form to modify it.

---

## Slides Service Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/slides

**Contents:**
- Slides Service Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
- Classes
- AffineTransform
  - Methods
- AffineTransformBuilder
  - Methods
- AlignmentPosition
  - Properties
- ArrowStyle

The Google Slides service for Apps Script enables creation, access, and modification of presentations through various classes and methods.

Key classes like PageElement and Shape provide extensive methods for manipulating visual elements such as position, size, rotation, and ordering.

Classes like TextRange and TextStyle offer detailed control over text content and appearance within shapes and tables.

Specialized classes like Image, Line, Table, Video, and WordArt provide methods specific to interacting with those particular element types.

The SlidesApp class acts as the main entry point, allowing creation and opening of presentations and providing access to various enumerations and builder classes.

This service allows scripts to create, access, and modify Google Slides files. See also the Google Slides documentation for more details on the underlying features of the Slides service.

---

## Spreadsheet Service Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/spreadsheet

**Contents:**
- Spreadsheet Service Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
- Classes
- AutoFillSeries
  - Properties
- Banding
  - Methods
- BandingTheme
  - Properties
- BigQueryDataSourceSpec

The Google Sheets service in Apps Script allows creation, access, and modification of Google Sheets files with performance bundling.

Numerous classes are available to interact with various spreadsheet aspects, including formatting, data sources, structure, and content.

Specific classes are provided for managing conditional formatting, data validation, pivot tables, named ranges, and protection.

Chart builders offer extensive methods for creating and customizing different types of embedded charts within sheets.

Classes like DeveloperMetadata and TextFinder enable advanced interactions such as managing custom metadata and finding/replacing text.

This service allows scripts to create, access, and modify Google Sheets files. See also the guide to storing data in spreadsheets.

Sometimes, spreadsheet operations are bundled together to improve performance, such as when doing multiple calls to a method. If you want to make sure that all pending changes are made right away, for instance to show users information as a script is executing, call SpreadsheetApp.flush().

---

## Tables service Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/advanced/tables

**Contents:**
- Tables service Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
- Reference
- Sample code
  - Get a list of tables
  - Get a table’s information and column definitions
    - Find the table ID
  - Read rows of a table
    - Get one row from a table
    - Filter the list of rows

The Tables service enables scripts to programmatically interact with Google Tables, allowing for reading and editing of rows.

This is an advanced service that requires explicit enabling before use.

The Tables service uses the same objects, methods, and parameters as the public Tables API.

The provided content includes sample code for common operations such as listing tables and rows, getting table and row information, and creating, updating, and deleting rows.

Batch operations for creating, updating, and deleting rows are supported, with a limit of up to 500 rows per batch.

The Tables service allows scripts to programmatically read and edit rows within Google Tables.

For more information about this service, see the documentation for the Tables API. Like all advanced services in Apps Script, the Tables service uses the same objects, methods, and parameters as the public API. For more information, see How method signatures are determined.

To report issues and find other support, see the Tables support guide.

The following sample shows how to get a list of all the tables the user owns.

Below is an example of the response, which includes information about the table and the table column definitions:

The response includes up to 20 tables by default. To retrieve more tables, paginate the responses using the page_token and page_size parameters, shown below:

The max value of the page_size parameter for listing tables is 100.

The following sample shows how to get a specific table’s information and column definition.

To find a table’s ID, open the table in the Tables web app. In the URL at the top, the table ID is right after /table/.

The below sample shows where to find the table ID in various Tables URLs:

The following sample shows how to get a list of a table’s rows and read the field values.

A sample response is shown below. The response includes a list of the rows in the table and the values for each field.

The response includes up to 50 rows by default. To retrieve more rows, paginate the responses using the page_token and page_size parameters, shown below:

If there are more pages available, the response offers a nextPageToken. Otherwise, the response is undefined. To retrieve the next page of results, pass in the nextPageToken to the next list call.

The max value of the page_size parameter is 1,000.

The following sample shows how to read the field values of one row from a table.

To filter the list of rows in order to obtain only those results that you are interested in, use the filter parameter. For more details on the syntax and column types supported by the filter, please take a look at the filtering API documentation.

The response includes the rows with the 'Point of Contact' column set to 'john.doe@gmail.com'

The following sample shows how to add a row to a table.

When you specify the values to set for the new row, the keys of the object key-value pairs must exactly match the case-sensitive titles of the table columns unless the writable column's type is a lookup or summary column. You set values for lookup and summary columns using the value for the relationship. You must update the value for the relationship using the relationship name found in the Relationships dialog.

The acceptable values for a column depend on the column’s data type:

The Tables service makes a best-effort attempt to convert given values to match the column type. If the data doesn’t match, it won’t set the value and leaves it as blank for new rows.

The following sample shows how to add multiple rows to a table at the same time. var tableID = “TABLE_ID”; var tableName = "tables/" + tableID; Area120Tables.Tables.Rows.batchCreate({requests: [ {row:{values:{"Col 1":"Sample", "Col 2":"One", "Col 3":"A"}}}, {row:{values:{"Col 1":"Example", "Col 2":"Two", "Col 3":"B"}}}, {row:{values:{"Col 1":"Test", "Col 2":"Three", "Col 3":"C"}}}, ]}, tableName)

The following sample shows how to update the values of an existing row in a table: var rowName = "tables/TABLE_ID/rows/ROW_ID"; var values = {"Column": "HELLO"}; var response = Area120Tables.Tables.Rows.patch({values: values}, rowName); Logger.log("Update row:" + JSON.stringify(response)); The response returns the updated row.

You can find the ID for a row two ways:

When you read rows from a table, you can use the name attribute for each row, which includes the table and row IDs.

The below sample shows where to find the row ID in the URL:

The following sample shows how to update the values of multiple rows in a table: var tableID = “TABLE_ID”; var tableName = "tables/" + tableID; var requests = [ {row: {name: "tables/TABLE_ID/rows/ROW_ID_1", values: {"Column": "WORLD"}}}, {row: {name: "tables/TABLE_ID/rows/ROW_ID_2", values: {"Column": "WORLD"}}}, {row: {name: "tables/TABLE_ID/rows/ROW_ID_3", values: {"Column": "WORLD"}}}, ]; var response = Area120Tables.Tables.Rows.batchUpdate({requests: requests}, tableName); Logger.log("Batch update rows:" + JSON.stringify(response));

The following sample shows how to delete a single row from a table: var rowName = "tables/TABLE_ID/rows/ROW_ID"; var response = Area120Tables.Tables.Rows.remove(rowName); Logger.log("Delete row:" + JSON.stringify(response));

The following sample shows how to delete multiple rows in a table: var tableID = “TABLE_ID”; var tableName = "tables/" + tableID; var rowNames = [ "tables/TABLE_ID/rows/ROW_ID_1", "tables/TABLE_ID/rows/ROW_ID_2", "tables/TABLE_ID/rows/ROW_ID_3", ]; Area120Tables.Tables.Rows.batchDelete({names: rowNames}, tableName);

You can restore deleted rows from the Tables UI. To restore a deleted row, follow the steps below:

The following sample shows how to get a list of all the workspaces the user owns.

Below is an example of the output logs: My Workspace Table: Table 1 Table: Table 2 My TODOs Table: Tasks

---

## Test an Editor add-on Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/add-ons/how-tos/testing-editor-addons

**Contents:**
- Test an Editor add-on Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
- Create a test deployment
- Run a test deployment
  - Testing details

Apps Script allows developers to test editor add-ons directly within Google Docs, Sheets, Slides, or Forms to verify functionality and installation flow.

Developers can create test deployments to specify add-on versions, authorization states, and associated documents for controlled testing environments.

Saved test deployments can be executed repeatedly, enabling developers to iterate on their add-ons and observe changes in real-time within the test document.

While offering valuable testing capabilities, test deployments have limitations such as not supporting installable triggers and shared property persistence across deployments using the same add-on and document.

Test deployments provide a shareable URL for collaborative testing and may require authorization for the script, both within and outside the testing environment.

Add-ons should be tested thoroughly prior to publishing to ensure they behave as intended. Apps Script lets you test Editor add-ons in development on specific Google Docs Sheets, Forms, or Slides files. This can be used to:

A test deployment is the combination of an add-on and a test document. Once you have a script version developed and would like to test it as an add-on, follow these steps:

All saved test deployments appear in the Test deployments dialog. This lets you revisit the same test deployment later on.

If you have one or more saved test deployments, you can run one of them by following these steps:

The test document opens in a new tab. The add-on is in the authorization state specified in the test deployment. You can verify that the add-on functions as intended by interacting with its menu and UI elements.

There are a number of things to keep in mind while testing Editor add-ons this way:

---

## URL Fetch Service Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/url-fetch

**Contents:**
- URL Fetch Service Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
    - See also
- Classes
- HTTPResponse
  - Methods
- UrlFetchApp
  - Methods

The UrlFetch service allows scripts to fetch URLs and make HTTP/HTTPS requests and receive responses.

Requests made using this service originate from a set pool of IP ranges that can be looked up for whitelisting.

Using this service requires the https://www.googleapis.com/auth/script.external_request scope.

The UrlFetchApp class is used to fetch resources and communicate with other hosts over the Internet.

The HTTPResponse class allows users to access specific information about HTTP responses, such as headers, content, and response codes.

This service allows scripts to access other resources on the web by fetching URLs. A script can use the UrlFetch service to issue HTTP and HTTPS requests and receive responses. The UrlFetch service uses Google's network infrastructure for efficiency and scaling purposes.

Requests made using this service originate from a set pool of IP ranges. You can look up the full list of IP addresses if you need to whitelist or approve these requests.

The default user agent string of UrlFetch service requests is Mozilla/5.0 (compatible; Google-Apps-Script; beanserver; +https://script.google.com; id: SCRIPT_ID). This service requires the https://www.googleapis.com/auth/script.external_request scope. In most cases Apps Script automatically detects and includes scopes a script needs, but if you are setting your scopes explicitly you must manually add this scope to use UrlFetchApp. See also HTTPResponse Setting explicit scopes Classes NameBrief description HTTPResponseThis class allows users to access specific information on HTTP responses. UrlFetchAppFetch resources and communicate with other hosts over the Internet. HTTPResponse Methods MethodReturn typeBrief description getAllHeaders()ObjectReturns an attribute/value map of headers for the HTTP response, with headers that have multiple values returned as arrays. getAs(contentType)BlobReturn the data inside this object as a blob converted to the specified content type. getBlob()BlobReturn the data inside this object as a blob. getContent()Byte[]Gets the raw binary content of an HTTP response. getContentText()StringGets the content of an HTTP response encoded as a string. getContentText(charset)StringReturns the content of an HTTP response encoded as a string of the given charset. getHeaders()ObjectReturns an attribute/value map of headers for the HTTP response. getResponseCode()IntegerGet the HTTP status code (200 for OK, etc.) of an HTTP response. UrlFetchApp Methods MethodReturn typeBrief description fetch(url)HTTPResponseMakes a request to fetch a URL. fetch(url, params)HTTPResponseMakes a request to fetch a URL using optional advanced parameters. fetchAll(requests)HTTPResponse[]Makes multiple requests to fetch multiple URLs using optional advanced parameters. getRequest(url)ObjectReturns the request that is made if the operation was invoked. getRequest(url, params)ObjectReturns the request that is made if the operation were invoked.

This service requires the https://www.googleapis.com/auth/script.external_request scope. In most cases Apps Script automatically detects and includes scopes a script needs, but if you are setting your scopes explicitly you must manually add this scope to use UrlFetchApp. See also HTTPResponse Setting explicit scopes Classes NameBrief description HTTPResponseThis class allows users to access specific information on HTTP responses. UrlFetchAppFetch resources and communicate with other hosts over the Internet. HTTPResponse Methods MethodReturn typeBrief description getAllHeaders()ObjectReturns an attribute/value map of headers for the HTTP response, with headers that have multiple values returned as arrays. getAs(contentType)BlobReturn the data inside this object as a blob converted to the specified content type. getBlob()BlobReturn the data inside this object as a blob. getContent()Byte[]Gets the raw binary content of an HTTP response. getContentText()StringGets the content of an HTTP response encoded as a string. getContentText(charset)StringReturns the content of an HTTP response encoded as a string of the given charset. getHeaders()ObjectReturns an attribute/value map of headers for the HTTP response. getResponseCode()IntegerGet the HTTP status code (200 for OK, etc.) of an HTTP response. UrlFetchApp Methods MethodReturn typeBrief description fetch(url)HTTPResponseMakes a request to fetch a URL. fetch(url, params)HTTPResponseMakes a request to fetch a URL using optional advanced parameters. fetchAll(requests)HTTPResponse[]Makes multiple requests to fetch multiple URLs using optional advanced parameters. getRequest(url)ObjectReturns the request that is made if the operation was invoked. getRequest(url, params)ObjectReturns the request that is made if the operation were invoked.

---

## Utilities Service Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/utilities

**Contents:**
- Utilities Service Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
- Classes
- Charset
  - Properties
- DigestAlgorithm
  - Properties
- MacAlgorithm
  - Properties
- RsaAlgorithm

The Utilities service provides various functions for handling string encoding/decoding, date formatting, and JSON manipulation.

It includes classes for specifying character sets, digest algorithms, MAC algorithms, and RSA algorithms.

The Utilities class offers methods for tasks such as base-64 encoding/decoding, computing digests and signatures, formatting and parsing dates, working with Blobs, and managing compressed data.

This service provides utilities for string encoding/decoding, date formatting, JSON manipulation, and other miscellaneous tasks.Classes NameBrief description CharsetA typesafe enum for character sets. DigestAlgorithmSelector of Digest algorithm. MacAlgorithmSelector of MAC algorithm RsaAlgorithmSelector of RSA algorithm UtilitiesThis service provides utilities for string encoding/decoding, date formatting, JSON manipulation, and other miscellaneous tasks. Charset Properties PropertyTypeDescription US_ASCIIEnum UTF_8Enum DigestAlgorithm Properties PropertyTypeDescription MD2EnumMD2 algorithm MD5EnumMD5 algorithm SHA_1EnumSHA-1 algorithm SHA_256EnumSHA-256 algorithm SHA_384EnumSHA-384 algorithm SHA_512EnumSHA-512 algorithm MacAlgorithm Properties PropertyTypeDescription HMAC_MD5Enum HMAC_SHA_1Enum HMAC_SHA_256Enum HMAC_SHA_384Enum HMAC_SHA_512Enum RsaAlgorithm Properties PropertyTypeDescription RSA_SHA_1Enum RSA_SHA_256Enum Utilities Properties PropertyTypeDescription CharsetCharset DigestAlgorithmDigestAlgorithm MacAlgorithmMacAlgorithm RsaAlgorithmRsaAlgorithm Methods MethodReturn typeBrief description base64Decode(encoded)Byte[]Decodes a base-64 encoded string into a UTF-8 byte array. base64Decode(encoded, charset)Byte[]Decodes a base-64 encoded string into a byte array in a specific character set. base64DecodeWebSafe(encoded)Byte[]Decodes a base-64 web-safe encoded string into a UTF-8 byte array. base64DecodeWebSafe(encoded, charset)Byte[]Decodes a base-64 web-safe encoded string into a byte array in a specific character set. base64Encode(data)StringGenerates a base-64 encoded string from the given byte array. base64Encode(data)StringGenerates a base-64 encoded string from the given string. base64Encode(data, charset)StringGenerates a base-64 encoded string from the given string in a specific character set. base64EncodeWebSafe(data)StringGenerates a base-64 web-safe encoded string from the given byte array. base64EncodeWebSafe(data)StringGenerates a base-64 web-safe encoded string from the given string. base64EncodeWebSafe(data, charset)StringGenerates a base-64 web-safe encoded string from the given string in a specific character set. computeDigest(algorithm, value)Byte[]Compute a digest using the specified algorithm on the specified Byte[] value. computeDigest(algorithm, value)Byte[]Compute a digest using the specified algorithm on the specified String value. computeDigest(algorithm, value, charset)Byte[]Compute a digest using the specified algorithm on the specified String value with the given character set. computeHmacSha256Signature(value, key)Byte[]Signs the provided value using HMAC-SHA256 with the given key. computeHmacSha256Signature(value, key)Byte[]Signs the provided value using HMAC-SHA256 with the given key. computeHmacSha256Signature(value, key, charset)Byte[]Signs the provided value using HMAC-SHA256 with the given key and character set. computeHmacSignature(algorithm, value, key)Byte[]Compute a message authentication code using the specified algorithm on the specified key and value. computeHmacSignature(algorithm, value, key)Byte[]Compute a message authentication code using the specified algorithm on the specified key and value. computeHmacSignature(algorithm, value, key, charset)Byte[]Compute a message authentication code using the specified algorithm on the specified key and value. computeRsaSha1Signature(value, key)Byte[]Signs the provided value using RSA-SHA1 with the given key. computeRsaSha1Signature(value, key, charset)Byte[]Signs the provided value using RSA-SHA1 with the given key and charset. computeRsaSha256Signature(value, key)Byte[]Signs the provided value using RSA-SHA256 with the given key. computeRsaSha256Signature(value, key, charset)Byte[]Signs the provided value using RSA-SHA256 with the given key. computeRsaSignature(algorithm, value, key)Byte[]Signs the provided value using the specified RSA algorithm with the given key. computeRsaSignature(algorithm, value, key, charset)Byte[]Signs the provided value using the specified RSA algorithm with the given key and charset. formatDate(date, timeZone, format)StringFormats date according to specification described in Java SE SimpleDateFormat class. formatString(template, args)StringPerforms sprintf-like string formatting using '%'-style format strings. getUuid()StringGet a UUID as a string (equivalent to using the java.util.UUID.randomUUID() method). gzip(blob)Blobgzip-compresses the provided Blob data and returns it in a new Blob object. gzip(blob, name)Blobgzip-compresses the provided Blob data and returns it in a new Blob object. newBlob(data)BlobCreate a new Blob object from a byte array. newBlob(data, contentType)BlobCreate a new Blob object from a byte array and content type. newBlob(data, contentType, name)BlobCreate a new Blob object from a byte array, content type, and name. newBlob(data)BlobCreate a new Blob object from a string. newBlob(data, contentType)BlobCreate a new Blob object from a string and content type. newBlob(data, contentType, name)BlobCreate a new Blob object from a string, content type, and name. parseCsv(csv)String[][]Returns a tabular 2D array representation of a CSV string. parseCsv(csv, delimiter)String[][]Returns a tabular 2D array representation of a CSV string using a custom delimiter. parseDate(date, timeZone, format)DateParses the provided string date according to the specification described in the Java Standard Edition SimpleDateFormat class. sleep(milliseconds)voidSleeps for specified number of milliseconds. ungzip(blob)BlobUncompresses a Blob object and returns a Blob containing the uncompressed data. unzip(blob)Blob[]Takes a Blob representing a zip file and returns its component files. zip(blobs)BlobCreates a new Blob object that is a zip file containing the data from the Blobs passed in. zip(blobs, name)BlobCreates a new Blob object that is a zip file containing the data from the Blobs passed in.

Classes NameBrief description CharsetA typesafe enum for character sets. DigestAlgorithmSelector of Digest algorithm. MacAlgorithmSelector of MAC algorithm RsaAlgorithmSelector of RSA algorithm UtilitiesThis service provides utilities for string encoding/decoding, date formatting, JSON manipulation, and other miscellaneous tasks. Charset Properties PropertyTypeDescription US_ASCIIEnum UTF_8Enum DigestAlgorithm Properties PropertyTypeDescription MD2EnumMD2 algorithm MD5EnumMD5 algorithm SHA_1EnumSHA-1 algorithm SHA_256EnumSHA-256 algorithm SHA_384EnumSHA-384 algorithm SHA_512EnumSHA-512 algorithm MacAlgorithm Properties PropertyTypeDescription HMAC_MD5Enum HMAC_SHA_1Enum HMAC_SHA_256Enum HMAC_SHA_384Enum HMAC_SHA_512Enum RsaAlgorithm Properties PropertyTypeDescription RSA_SHA_1Enum RSA_SHA_256Enum Utilities Properties PropertyTypeDescription CharsetCharset DigestAlgorithmDigestAlgorithm MacAlgorithmMacAlgorithm RsaAlgorithmRsaAlgorithm Methods MethodReturn typeBrief description base64Decode(encoded)Byte[]Decodes a base-64 encoded string into a UTF-8 byte array. base64Decode(encoded, charset)Byte[]Decodes a base-64 encoded string into a byte array in a specific character set. base64DecodeWebSafe(encoded)Byte[]Decodes a base-64 web-safe encoded string into a UTF-8 byte array. base64DecodeWebSafe(encoded, charset)Byte[]Decodes a base-64 web-safe encoded string into a byte array in a specific character set. base64Encode(data)StringGenerates a base-64 encoded string from the given byte array. base64Encode(data)StringGenerates a base-64 encoded string from the given string. base64Encode(data, charset)StringGenerates a base-64 encoded string from the given string in a specific character set. base64EncodeWebSafe(data)StringGenerates a base-64 web-safe encoded string from the given byte array. base64EncodeWebSafe(data)StringGenerates a base-64 web-safe encoded string from the given string. base64EncodeWebSafe(data, charset)StringGenerates a base-64 web-safe encoded string from the given string in a specific character set. computeDigest(algorithm, value)Byte[]Compute a digest using the specified algorithm on the specified Byte[] value. computeDigest(algorithm, value)Byte[]Compute a digest using the specified algorithm on the specified String value. computeDigest(algorithm, value, charset)Byte[]Compute a digest using the specified algorithm on the specified String value with the given character set. computeHmacSha256Signature(value, key)Byte[]Signs the provided value using HMAC-SHA256 with the given key. computeHmacSha256Signature(value, key)Byte[]Signs the provided value using HMAC-SHA256 with the given key. computeHmacSha256Signature(value, key, charset)Byte[]Signs the provided value using HMAC-SHA256 with the given key and character set. computeHmacSignature(algorithm, value, key)Byte[]Compute a message authentication code using the specified algorithm on the specified key and value. computeHmacSignature(algorithm, value, key)Byte[]Compute a message authentication code using the specified algorithm on the specified key and value. computeHmacSignature(algorithm, value, key, charset)Byte[]Compute a message authentication code using the specified algorithm on the specified key and value. computeRsaSha1Signature(value, key)Byte[]Signs the provided value using RSA-SHA1 with the given key. computeRsaSha1Signature(value, key, charset)Byte[]Signs the provided value using RSA-SHA1 with the given key and charset. computeRsaSha256Signature(value, key)Byte[]Signs the provided value using RSA-SHA256 with the given key. computeRsaSha256Signature(value, key, charset)Byte[]Signs the provided value using RSA-SHA256 with the given key. computeRsaSignature(algorithm, value, key)Byte[]Signs the provided value using the specified RSA algorithm with the given key. computeRsaSignature(algorithm, value, key, charset)Byte[]Signs the provided value using the specified RSA algorithm with the given key and charset. formatDate(date, timeZone, format)StringFormats date according to specification described in Java SE SimpleDateFormat class. formatString(template, args)StringPerforms sprintf-like string formatting using '%'-style format strings. getUuid()StringGet a UUID as a string (equivalent to using the java.util.UUID.randomUUID() method). gzip(blob)Blobgzip-compresses the provided Blob data and returns it in a new Blob object. gzip(blob, name)Blobgzip-compresses the provided Blob data and returns it in a new Blob object. newBlob(data)BlobCreate a new Blob object from a byte array. newBlob(data, contentType)BlobCreate a new Blob object from a byte array and content type. newBlob(data, contentType, name)BlobCreate a new Blob object from a byte array, content type, and name. newBlob(data)BlobCreate a new Blob object from a string. newBlob(data, contentType)BlobCreate a new Blob object from a string and content type. newBlob(data, contentType, name)BlobCreate a new Blob object from a string, content type, and name. parseCsv(csv)String[][]Returns a tabular 2D array representation of a CSV string. parseCsv(csv, delimiter)String[][]Returns a tabular 2D array representation of a CSV string using a custom delimiter. parseDate(date, timeZone, format)DateParses the provided string date according to the specification described in the Java Standard Edition SimpleDateFormat class. sleep(milliseconds)voidSleeps for specified number of milliseconds. ungzip(blob)BlobUncompresses a Blob object and returns a Blob containing the uncompressed data. unzip(blob)Blob[]Takes a Blob representing a zip file and returns its component files. zip(blobs)BlobCreates a new Blob object that is a zip file containing the data from the Blobs passed in. zip(blobs, name)BlobCreates a new Blob object that is a zip file containing the data from the Blobs passed in.

---

## Web Apps Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/execution_web_apps

**Contents:**
- Web Apps Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
- Requirements for web apps
- Request parameters
- Deploy a script as a web app
- Test a web app deployment
- Permissions
- Embed your web app in Google Sites
- Web Apps and Browser History

Apps Script allows you to publish scripts with a user interface as web apps accessible from a browser.

A script needs to contain a doGet(e) or doPost(e) function that returns an HtmlOutput or TextOutput object to be published as a web app.

Request parameters are passed to the doGet(e) or doPost(e) function via the e event parameter, containing information about the query string and parameters.

You can deploy a script as a web app through the "Deploy" menu in the script project, configuring deployment settings and sharing the resulting URL.

Web apps can be configured to execute as the script owner or the user accessing the web app, which affects permissions.

If you build a user interface for a script, you can publish the script as a web app. For example, a script that lets users schedule appointments with members of a support team would best be presented as a web app so that users can access it directly from their browsers.

Both standalone scripts and scripts bound to Google Workspace applications can be turned into web apps, so long as they meet the requirements below.

A script can be published as a web app if it meets these requirements:

When a user visits an app or a program sends the app an HTTP GET request, Apps Script runs the function doGet(e). When a program sends the app an HTTP POST request, Apps Script runs doPost(e) instead. In both cases, the e argument represents an event parameter that can contain information about any request parameters. The structure of the event object is shown in the table below:

The value of the query string portion of the URL, or null if no query string is specified

An object of key/value pairs that correspond to the request parameters. Only the first value is returned for parameters that have multiple values.

An object similar to e.parameter, but with an array of values for each key

The URL path after /exec or /dev. For example, if the URL path ends in /exec/hello, the path info is hello.

The length of the request body for POST requests, or -1 for GET requests

The same as e.contentLength

The MIME type of the POST body

The content text of the POST body

Always the value "postData"

For instance, you could pass parameters such as username and age to a URL as shown below:

Then, you can display the parameters like so:

In the above example, doGet(e) returns the following output:

To deploy a script as a web app, follow these steps:

You can share the web app URL with those you would like to use your app, provided you have granted them access.

To test your script as a web app, follow the steps below:

Paste the URL in your browser and test your web app.

This URL ends in /dev and can only be accessed by users who have edit access to the script. This instance of the app always runs the most recently saved code and is only intended for testing during development.

The permissions for a web app differ depending how you choose to execute the app:

In order to embed a web app in Google Sites, it must first be deployed. You also need the Deployed URL from the Deploy dialog.

To embed a web app into a Sites page, follow these steps:

The web app appears in a frame in the page's preview. When you publish the page, your site viewers may need to authorize the web app before it executes normally. Unauthorized web apps present authorization prompts to the user.

It can be desirable to have an Apps Script web app simulate a multi-page application, or one with a dynamic UI controlled via URL parameters. In order to do this well, you can define a state object to represent the app's UI or page, and push the state into the browser history as the user navigates your app. You can also listen to history events so that your web app displays the correct UI when the user navigates back and forth with the browser buttons. By querying the URL parameters at load time, you can have your app dynamically build its UI based on those parameters, allowing the user to start the app in a particular state.

Apps Script provides two asynchronous client-side JavaScript APIs to assist with creating web apps that are linked to the browser history:

google.script.history provides methods to allow dynamic response to browser history changes. This includes: pushing states (simple Objects you can define) onto the browser history, replacing the top state in the history stack, and setting a listener callback function to respond to history changes.

google.script.url provides the means to retrieve the current page's URL parameters and URL fragment, if they are present.

These history APIs are only available to web apps. They are not supported for sidebars, dialogs or add-ons. This functionality is also not recommended for use in web apps embedded in a Google Sites.

**Examples:**

Example 1 (unknown):
```unknown
https://script.google.com/.../exec?username=jsmith&age=21
```

Example 2 (unknown):
```unknown
function doGet(e) {
  var params = JSON.stringify(e);
  return ContentService.createTextOutput(params).setMimeType(ContentService.MimeType.JSON);
}
```

Example 3 (unknown):
```unknown
{
  "queryString": "username=jsmith&age=21",
  "parameter": {
    "username": "jsmith",
    "age": "21"
  },
  "contextPath": "",
  "parameters": {
    "username": [
      "jsmith"
    ],
    "age": [
      "21"
    ]
  },
  "contentLength": -1
}
```

---

## XML Service Stay organized with collections Save and categorize content based on your preferences.

**URL:** https://developers.google.com/apps-script/reference/xml-service

**Contents:**
- XML Service Stay organized with collections Save and categorize content based on your preferences.
- AI-generated Key Takeaways
- Classes
- Attribute
  - Methods
- Cdata
  - Methods
- Comment
  - Methods
- Content

The XML Service allows scripts to parse, navigate, and programmatically create XML documents.

It provides classes like Document, Element, and Attribute for working with XML structure.

The service includes methods for parsing XML strings, creating new XML elements and documents, and formatting XML output.

You can navigate through XML elements using methods like getRootElement(), getChild(), and getChildren().

The service supports retrieving and setting text content and attributes of XML nodes.

This service allows scripts to parse, navigate, and programmatically create XML documents.

---
