# Authentication APIs

## Get App Access Token

Obtain an access token for API authentication. Token expires after 7200 seconds (2 hours).

### Endpoint
```
POST https://openapi.seatalk.io/auth/app_access_token
```

### Rate Limit
600 requests/hour per app_id

### Request
```bash
curl -X POST https://openapi.seatalk.io/auth/app_access_token \
  -H "Content-Type: application/json" \
  -d '{
    "app_id": "123",
    "app_secret": "V79JzZ0yasBAs69tQOD1"
  }'
```

### Response
```json
{
  "code": 0,
  "app_access_token": "c8bda0f77ef940c5bea9f23b2d7fc0d8",
  "expire": 1590581487
}
```

### Fields
| Field | Type | Description |
|-------|------|-------------|
| code | int | 0 = success |
| app_access_token | string | Token for API calls |
| expire | int | Unix timestamp of expiration |

### Best Practices
- Cache the token and refresh before expiration
- Token lifetime: 7200 seconds (2 hours)
- Use token in Authorization header: `Bearer {token}`

## Using the Token

All API requests require the access token in the Authorization header:

```bash
curl -X GET https://openapi.seatalk.io/contacts/v2/profile \
  -H "Authorization: Bearer c8bda0f77ef940c5bea9f23b2d7fc0d8" \
  -H "Content-Type: application/json"
```

## Other Authentication APIs

### Verify Single Sign-on Token
Verify SSO tokens for web integrations.

### Verify Login With SeaTalk Code
Verify login codes for SeaTalk authentication flow.
