# Contacts APIs

## Get Employee Profile

Retrieve employee profile information.

### Endpoint
```
GET https://openapi.seatalk.io/contacts/v2/profile
```

### Permission
Get Contact Profile + relevant Data Scope

### Request
```
GET /contacts/v2/profile?employee_code=123&employee_code=456&employee_code=789
```

Batch up to 500 employee codes in a single request.

### Response
```json
{
  "code": 0,
  "employees": [
    {
      "employee_code": "e_12345",
      "seatalk_id": "9876543210",
      "seatalk_nickname": "John D",
      "avatar": "https://avatar.url/image.jpg",
      "name": "John Doe",
      "email": "john.doe@company.com",
      "mobile": "+1234567890",
      "departments": [
        {
          "department_id": "dept_001",
          "department_name": "Engineering"
        }
      ],
      "gender": 1,
      "reporting_manager_employee_code": "e_manager",
      "offboarding_time": 0,
      "custom_fields": [
        {
          "name": "Office Location",
          "type": "text",
          "value": "Singapore"
        }
      ]
    }
  ]
}
```

### Response Fields

| Field | Type | Description |
|-------|------|-------------|
| employee_code | string | Unique employee identifier |
| seatalk_id | string | SeaTalk user ID |
| seatalk_nickname | string | Display name in SeaTalk |
| avatar | string | Profile picture URL |
| name | string | Full name |
| email | string | Work email |
| mobile | string | Phone number |
| departments | []object | Department memberships |
| gender | int | 0=Blank, 1=Male, 2=Female, 3=Unknown |
| reporting_manager_employee_code | string | Manager's employee code |
| offboarding_time | int | Offboarding timestamp (0 if active) |
| custom_fields | []object | Custom profile fields |

---

## Get Employee Code With Email

Look up employee code by email address.

### Endpoint
```
GET https://openapi.seatalk.io/contacts/v2/employee_code
```

### Request
```
GET /contacts/v2/employee_code?email=user@company.com
```

---

## Get User Language Preference

Get user's preferred language setting.

### Endpoint
```
GET https://openapi.seatalk.io/contacts/v2/language_preference
```

---

## Employee Management APIs

### Onboard Employee
Create a new employee in the organization.
```
POST https://openapi.seatalk.io/contacts/v2/employee/onboard
```

### Reboard Employee
Reactivate an offboarded employee.
```
POST https://openapi.seatalk.io/contacts/v2/employee/reboard
```

### Delete Employee
Remove an employee from the organization.
```
POST https://openapi.seatalk.io/contacts/v2/employee/delete
```

### Update Employee
Update employee profile information.
```
POST https://openapi.seatalk.io/contacts/v2/employee/update
```

### Update Employee Avatar
Update an employee's profile picture.
```
POST https://openapi.seatalk.io/contacts/v2/employee/avatar
```

### Check Employee Existence
Verify if an employee exists.
```
GET https://openapi.seatalk.io/contacts/v2/employee/exists
```

---

## Department APIs

### Create Department
```
POST https://openapi.seatalk.io/contacts/v2/department/create
```

### Get Departments
```
GET https://openapi.seatalk.io/contacts/v2/departments
```

### Get Department Employees
```
GET https://openapi.seatalk.io/contacts/v2/department/employees
```

### Update Department
```
POST https://openapi.seatalk.io/contacts/v2/department/update
```

### Delete Department
```
POST https://openapi.seatalk.io/contacts/v2/department/delete
```
