# Group Chat Management APIs

## Create Group Chat

Create a new group chat with the bot.

### Endpoint
```
POST https://openapi.seatalk.io/messaging/v2/group_chat/create_group
```

### Rate Limit
- 100 groups per app per day
- 10 groups per app per minute

### Permission
Create Group Chat

### Request
```json
{
  "group_owner": "owner_employee_code",
  "group_member_list": [
    {"employee_code": "member1", "role": 0},
    {"employee_code": "member2", "role": 1},
    {"employee_code": "member3", "role": 0}
  ],
  "group_name": "Project Team",
  "group_settings": {
    "chat_history_for_new_members": 2
  }
}
```

| Parameter | Type | Required | Description |
|-----------|------|----------|-------------|
| group_owner | string | Yes | Employee code of group owner |
| group_member_list | []object | Yes | 1-30 members |
| group_member_list[].employee_code | string | Yes | Member's employee code |
| group_member_list[].role | int | No | 0=member (default), 1=admin |
| group_name | string | No | Group name (max 120 chars) |
| group_settings | object | No | Group settings |
| group_settings.chat_history_for_new_members | int | No | 0=Off, 1=24h, 2=7days |

### Response
```json
{
  "code": 0,
  "group_id": "NTk2NjAxMDUyMzMz",
  "users_not_added": ["invalid_user_code"]
}
```

### Notes
- All members must be in bot's service scope
- Bot is NOT automatically added to the group it creates
- `bot_added_to_group_chat` event is NOT triggered for bot-created groups

---

## Get Group Info

Retrieve information about a group chat.

### Endpoint
```
GET https://openapi.seatalk.io/messaging/v2/group_chat/info
```

### Rate Limit
100 requests/minute

### Request
```
GET /messaging/v2/group_chat/info?group_id=abc123&page_size=50&cursor=xxx
```

| Parameter | Type | Required | Description |
|-----------|------|----------|-------------|
| group_id | string | Yes | Group chat ID |
| page_size | int | No | 1-100 (default 50) |
| cursor | string | No | Pagination cursor |

### Response
```json
{
  "code": 0,
  "next_cursor": "",
  "group": {
    "group_name": "Test Group",
    "group_settings": {
      "chat_history_for_new_members": "7 days",
      "can_notify_with_at_all": true,
      "can_view_member_list": true
    },
    "group_user_total": 5,
    "group_bot_total": 2,
    "group_system_account_total": 0,
    "group_user_list": [
      {
        "seatalk_id": "12345678",
        "employee_code": "e_293847124",
        "email": "user@company.com"
      }
    ],
    "group_bot_list": ["bot_seatalk_id_1", "bot_seatalk_id_2"],
    "group_system_account_list": []
  }
}
```

---

## Get Chat History

Retrieve chat history from a group.

### Endpoint
```
GET https://openapi.seatalk.io/messaging/v2/group_chat/history
```

### Rate Limit
100 requests/minute

### Permission
Get Chat History (requires management approval)

### Request
```
GET /messaging/v2/group_chat/history?group_id=abc123&page_size=50
```

### Response
```json
{
  "code": 0,
  "next_cursor": "pagination_cursor",
  "chat_history": [
    {
      "message_id": "msg123",
      "quoted_message_id": "",
      "thread_id": "thread123",
      "sender": {
        "seatalk_id": "123456",
        "employee_code": "e_abc",
        "email": "user@company.com",
        "sender_type": 1
      },
      "message_sent_time": 1687944533,
      "tag": "text",
      "text": {
        "plain_text": "Hello world!",
        "last_edited_time": 0,
        "mentioned_list": []
      }
    }
  ]
}
```

### Sender Types
- `1` = User
- `2` = Bot
- `3` = System Account

### Message Tags
- `text`
- `image`
- `file`
- `video`
- `combined_forwarded_message_history`

### Limitations
- Only messages from past 7 days
- Returns in reverse chronological order
- Media URLs expire in 7 days

---

## Get Thread by Thread ID

Retrieve all messages in a thread.

### Endpoint
```
GET https://openapi.seatalk.io/messaging/v2/group_chat/get_thread_by_thread_id
```

### Rate Limit
100 requests/minute

### Request
```
GET /messaging/v2/group_chat/get_thread_by_thread_id?group_id=abc123&thread_id=thread123&page_size=50
```

### Response
```json
{
  "code": 0,
  "next_cursor": "",
  "thread_messages": [
    {
      "message_id": "msg1",
      "thread_id": "thread123",
      "sender": {...},
      "message_sent_time": 1687944533,
      "tag": "text"
    }
  ]
}
```

### Thread Identification
- `thread_id == message_id` = Root message
- `thread_id != message_id` = Thread reply

---

## Add Group Members

Add members to an existing group.

### Endpoint
```
POST https://openapi.seatalk.io/messaging/v2/group_chat/add_group_members
```

### Rate Limit
10 groups per minute

### Request
```json
{
  "group_id": "abc123",
  "employee_codes": ["emp1", "emp2", "emp3"]
}
```

| Parameter | Type | Required | Description |
|-----------|------|----------|-------------|
| group_id | string | Yes | Target group ID |
| employee_codes | []string | Yes | 1-30 employee codes |

### Response
```json
{
  "code": 0,
  "message": "success",
  "total_num": 3,
  "success_num": 2,
  "error_num": 1,
  "add_failed": [
    {
      "email": "user@company.com",
      "employee_code": "emp3",
      "error_code": 3001,
      "error_message": "User not found"
    }
  ]
}
```

### Prerequisites
- Group setting "Allow members to add members" = ON
- Bot must be a member of the group
- Users must be in bot's service scope

---

## Remove Group Members

Remove members from a group.

### Endpoint
```
POST https://openapi.seatalk.io/messaging/v2/group_chat/remove_group_members
```

---

## Get Joined Group Chat List

List all groups the bot has joined.

### Endpoint
```
GET https://openapi.seatalk.io/messaging/v2/group_chat/joined_list
```
