# Interactive Message Cards

## Overview

Interactive message cards are rich, structured messages with buttons, images, and formatted text. They can be sent to group chats, 1-on-1 bot chats, and service notices.

## Card Structure

Cards are built by stacking elements from top to bottom, like building blocks.

```json
{
  "tag": "interactive_message",
  "interactive_message": {
    "elements": [
      {"element_type": "title", ...},
      {"element_type": "description", ...},
      {"element_type": "image", ...},
      {"element_type": "button", ...},
      {"element_type": "button_group", ...}
    ]
  }
}
```

---

## Element Types

### Title Element

Display a prominent title.

```json
{
  "element_type": "title",
  "title": {
    "text": "Approval Request"
  }
}
```

| Property | Type | Required | Limits |
|----------|------|----------|--------|
| title.text | string | Yes | 1-120 characters |

**Limits:** Maximum 3 title elements per card

---

### Description Element

Display formatted text content.

```json
{
  "element_type": "description",
  "description": {
    "format": 1,
    "text": "Please review the **attached document** and provide your feedback.\n\nDeadline: *Friday 5PM*"
  }
}
```

| Property | Type | Required | Description |
|----------|------|----------|-------------|
| description.format | int | No | 1=Markdown (default), 2=Plain |
| description.text | string | Yes | 1-1000 characters |

**Limits:** Maximum 5 description elements per card

---

### Button Element

Single action button.

#### Callback Button
Sends `value` to your callback URL when clicked.

```json
{
  "element_type": "button",
  "button": {
    "button_type": "callback",
    "text": "Approve",
    "value": "action:approve:request_123"
  }
}
```

#### Redirect Button
Navigates to an app page when clicked.

```json
{
  "element_type": "button",
  "button": {
    "button_type": "redirect",
    "text": "View Details",
    "mobile_link": {
      "type": "web",
      "path": "https://app.example.com/details/123"
    },
    "desktop_link": {
      "type": "web",
      "path": "https://app.example.com/details/123"
    }
  }
}
```

| Property | Type | Required | Description |
|----------|------|----------|-------------|
| button.button_type | string | Yes | "callback" or "redirect" |
| button.text | string | Yes | Button label (1-50 chars) |
| button.value | string | For callback | Data sent to callback (1-200 chars) |
| button.mobile_link | object | For redirect | Mobile navigation config |
| button.desktop_link | object | For redirect | Desktop navigation config |

**Link Types:**
- `"web"` - Opens URL in webview
- `"rn"` - Opens React Native page

**Limits:** Maximum 5 buttons total per card

---

### Button Group Element

Row of 1-3 buttons displayed horizontally.

```json
{
  "element_type": "button_group",
  "button_group": [
    {
      "button_type": "callback",
      "text": "Approve",
      "value": "approve"
    },
    {
      "button_type": "callback",
      "text": "Reject",
      "value": "reject"
    },
    {
      "button_type": "redirect",
      "text": "Details",
      "mobile_link": {"type": "web", "path": "https://..."}
    }
  ]
}
```

**Limits:**
- 1-3 buttons per group
- Maximum 3 button groups per card

---

### Image Element

Display an image in the card.

```json
{
  "element_type": "image",
  "image": {
    "content": "base64_encoded_image_data"
  }
}
```

| Property | Type | Required | Description |
|----------|------|----------|-------------|
| image.content | string | Yes | Base64-encoded PNG/JPG/GIF |

**Limits:**
- Maximum 5MB per image
- Maximum 3 images per card
- Requires SeaTalk v3.60+

---

## Complete Example

```json
{
  "group_id": "abc123",
  "message": {
    "tag": "interactive_message",
    "interactive_message": {
      "elements": [
        {
          "element_type": "title",
          "title": {
            "text": "Leave Request Approval"
          }
        },
        {
          "element_type": "description",
          "description": {
            "format": 1,
            "text": "**Employee:** John Doe\n**Type:** Annual Leave\n**Dates:** Dec 25-27, 2024\n**Reason:** Family vacation"
          }
        },
        {
          "element_type": "button_group",
          "button_group": [
            {
              "button_type": "callback",
              "text": "Approve",
              "value": "leave:approve:req_123"
            },
            {
              "button_type": "callback",
              "text": "Reject",
              "value": "leave:reject:req_123"
            }
          ]
        },
        {
          "element_type": "button",
          "button": {
            "button_type": "redirect",
            "text": "View Full Request",
            "mobile_link": {
              "type": "web",
              "path": "https://hr.company.com/leave/req_123"
            },
            "desktop_link": {
              "type": "web",
              "path": "https://hr.company.com/leave/req_123"
            }
          }
        }
      ]
    }
  }
}
```

---

## Multi-Language Support

For Service Notice API, provide localized versions:

```json
{
  "tag": "interactive_message",
  "interactive_message": {
    "default": {
      "elements": [
        {"element_type": "title", "title": {"text": "System Alert"}}
      ]
    },
    "zh-Hans": {
      "elements": [
        {"element_type": "title", "title": {"text": "System Alert Chinese"}}
      ]
    },
    "id": {
      "elements": [
        {"element_type": "title", "title": {"text": "Peringatan Sistem"}}
      ]
    }
  },
  "employee_codes": ["emp1", "emp2"]
}
```

**Supported language codes:**
- `default` (required)
- `zh-Hans` (Simplified Chinese)
- `zh-Hant` (Traditional Chinese)
- `id` (Indonesian)
- `vi` (Vietnamese)
- `th` (Thai)
- `pt` (Portuguese)
- And others...

---

## Element Limits Summary

| Element | Max Per Card |
|---------|-------------|
| title | 3 |
| description | 5 |
| button | 5 (total) |
| button_group | 3 |
| image | 3 |

---

## Version Requirements

| Feature | Minimum SeaTalk Version |
|---------|------------------------|
| Interactive messages | v3.38.1 |
| Image element | v3.60.0 |
| Threading support | v3.44.5 |
