# Messaging APIs

## Send Message to Group Chat

Send messages to a group chat where the bot is a member.

### Endpoint
```
POST https://openapi.seatalk.io/messaging/v2/group_chat
```

### Rate Limit
100 requests/minute

### Message Types

#### Text Message
```json
{
  "group_id": "abc123",
  "message": {
    "tag": "text",
    "text": {
      "format": 1,
      "content": "Hello **world**! This supports *markdown*."
    }
  }
}
```

| Parameter | Type | Required | Description |
|-----------|------|----------|-------------|
| group_id | string | Yes | Target group ID |
| message.tag | string | Yes | "text" |
| message.text.format | int | No | 1=Markdown (default), 2=Plain |
| message.text.content | string | Yes | Message content (max 4096 chars) |

#### Image Message
```json
{
  "group_id": "abc123",
  "message": {
    "tag": "image",
    "image": {
      "content": "base64_encoded_image_string"
    }
  }
}
```

- Supports PNG, JPG, GIF
- Maximum 5MB after Base64 encoding

#### File Message
```json
{
  "group_id": "abc123",
  "message": {
    "tag": "file",
    "file": {
      "content": "base64_encoded_file",
      "filename": "document.pdf"
    }
  }
}
```

- Requires SeaTalk v3.41.0+
- File size: 10B - 5MB
- Filename max 100 characters

#### Interactive Message Card
```json
{
  "group_id": "abc123",
  "message": {
    "tag": "interactive_message",
    "interactive_message": {
      "elements": [
        {
          "element_type": "title",
          "title": {"text": "Approval Request"}
        },
        {
          "element_type": "description",
          "description": {
            "format": 1,
            "text": "Please review the **attached document**."
          }
        },
        {
          "element_type": "button",
          "button": {
            "button_type": "callback",
            "text": "Approve",
            "value": "approved"
          }
        }
      ]
    }
  }
}
```

- Requires SeaTalk v3.38.1+

### Threading Support

Reply to a thread by including `thread_id`:

```json
{
  "group_id": "abc123",
  "thread_id": "original_message_id",
  "message": {
    "tag": "text",
    "text": {
      "format": 1,
      "content": "This is a thread reply"
    }
  }
}
```

**Threading Rules:**
- Root message must be less than 7 days old
- @all mentions not allowed in thread replies
- Requires SeaTalk v3.44.5+

### Response
```json
{
  "code": 0,
  "message_id": "unique_message_id"
}
```

---

## Send Message to Bot User (1-on-1 Chat)

Send direct messages to users in private bot chat.

### Endpoint
```
POST https://openapi.seatalk.io/messaging/v2/single_chat
```

### Rate Limit
300 requests/minute

### Request
```json
{
  "employee_code": "e_12345678",
  "message": {
    "tag": "text",
    "text": {
      "format": 1,
      "content": "Hello! How can I help you?"
    }
  },
  "usable_platform": "all"
}
```

| Parameter | Type | Required | Description |
|-----------|------|----------|-------------|
| employee_code | string | Yes | Target user's employee code |
| message | object | Yes | Message object (same as group chat) |
| usable_platform | string | No | "all", "mobile", or "desktop" |

### Platform Targeting

- `"all"` - All platforms (default)
- `"mobile"` - Mobile only (iOS + Android)
- `"desktop"` - Desktop only (Desktop + Web)

When platform-restricted, users on other platforms see a fallback message.

---

## Send Service Notice

Send notifications to the Application Center channel.

### Endpoint
```
POST https://openapi.seatalk.io/messaging/v2/service_notice/send_message
```

### Permission
Send Service Notice (Internationalized)

### Request
```json
{
  "tag": "interactive_message",
  "interactive_message": {
    "default": {
      "elements": [
        {
          "element_type": "title",
          "title": {"text": "System Alert"}
        },
        {
          "element_type": "description",
          "description": {"text": "Your request has been processed."}
        }
      ]
    },
    "zh-Hans": {
      "elements": [
        {
          "element_type": "title",
          "title": {"text": "System Alert (Chinese)"}
        }
      ]
    }
  },
  "employee_codes": ["emp1", "emp2", "emp3"],
  "usable_platform": "all"
}
```

| Parameter | Type | Required | Description |
|-----------|------|----------|-------------|
| tag | string | Yes | "interactive_message" only |
| interactive_message.default | object | Yes | Default language elements |
| interactive_message.{lang} | object | No | Localized versions |
| employee_codes | []string | Yes | 1-50 recipients |
| usable_platform | string | No | Platform targeting |

### Response
```json
{
  "code": 0,
  "delivery": [
    {"code": 0, "employee_code": "emp1", "message_id": "abc123"},
    {"code": 3001, "employee_code": "emp2"}
  ]
}
```

---

## Update Message

Update an existing message.

### Endpoint
```
POST https://openapi.seatalk.io/messaging/v2/update_message
```

---

## Get Message by Message ID

Retrieve a specific message by its ID.

### Endpoint
```
GET https://openapi.seatalk.io/messaging/v2/message
```
