package Aliscore_module;

use strict    ;
use warnings  ;
use Tie::File ;
use Fcntl     ;


#converts different line feeds in open process
use open IN => ":raw", OUT => ":raw" ;

#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#  
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#  
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
#  MA 02110-1301, USA.
#  


#generated by Bernhard Misof, 15th April    2007

#updated   by Bernhard Misof,  4th July     2007
#updated   by Bernhard Misof, 26th August   2007
#updated   by Bernhard Misof, 10th November 2007
#updated   by Bernhard Misof, 22nd December 2007
#updated   by Bernhard Misof,  2nd January  2008
#updated   by Bernhard Misof, 10th February 2008
#updated   by Bernhard Misof, 16th February 2008
#updated   by Bernhard Misof,  4th March    2008
#updated   by Bernhard Misof,  7th March    2008
#updated   by Bernhard Misof, 11th March    2008
#updated   by Bernhard Misof, 26th March    2008
#updated   by Bernhard Misof,  2nd April    2008
#updated   by Bernhard Misof, 23nd June     2008
#updated   by Bernhard Misof,  2nd September 2008
#updated   by Bernhard Misof, 24th September 2008  => $ingo in reading FASTA files included
#updated   by Bernhard Misof, 20th February 2012 => svg output added 
#updated   by Bernhard Misof, 21th February 2012 => RY input files possible 

#used in Aliscore.02.1.pl


sub get_options {
	
	#no warnings;
	
			  my $file      ;
			  my $random    ;
			  my $window    ;
			  my $option    ;
			  my $tree      ;
			  my $level     ;
			  my $strict    ;
			  my $outgroup  ;
			  my $pairs     ;
			  my $indels    ; 
			  my $group     ;
			  my $strict_in ;
			  my $ingo      ;
			  my $matrix    ;   
			  my %options   ;	

our $USAGE = do {

<<USAGE;
usage   : Aliscore.pl -i infile 
                             
options	: [-N] 
	  [-r [#]] 
	  [-l [#]] 
	  [-w [#]] 	
	  [-t [treefile]] 
	  [-s] 
	  [-o taxon1,taxon2,..] 
	  [-e]                    
	  [-h] 
	  
defaults: without -N      : gaps treated as fifth character, 
			    will be ignored for 'aa' data
	  
	  without -w #    : windowsize is 6
	  
	  without -r #    : 4 x Taxa of random pairs 
	                    if -r without # or no treefile
	  
	  without -s      : inference of a consensus profile, 
	                    otherwise strict profile
	  
	  with -o taxa    : group of taxa can be selected, 
	                    separated by commatas
	  
	  with -t treefile: used to score all nodelevels, 
	                    otherwise specify by -l option
	 
	  with -t         : without a treefile a NJ tree will 
	                    be generated as guiding tree
	  
	  with -l #       : nodelevel to stop, starting at terminals, 
			    if -l #+ is used, only profiles of 
			    node level >=# are recorded
	  
	  with -e         : strange option for aminoacid scoring	  

random input order of options allowed


two output files are produced:

one profile, one list of characters below 0 cutoff line



	  
USAGE

};

die $USAGE if ! @ARGV ;

our $HELP = do {

<<HELP;

usage: Aliscore.pl -i infile 

options	: [-N] 
	  [-r [#]] 
	  [-l [#]] 
	  [-w [#]] 	
	  [-t [treefile]] 
	  [-s] 
	  [-o taxon1,taxon2,..] 
	  [-e]                    
	  [-h] 		             

for detailed help on options type : 

Aliscore.pl help option 

e.g. Aliscore.pl help -i 
  or Aliscore.pl help -t

     Aliscore.pl help -output
     Aliscore.pl help -scoring
     Aliscore.pl help -commands

to get information on output and scoring


HELP

};		

		 for    (  $file      ,
			   $random    ,
			   $window    ,
			   $option    ,
			   $tree      ,
			   $level     ,
			   $strict    ,
			   $outgroup  ,
			   $pairs     ,
			   $indels    , 
			   $group     ,
			   $strict_in ,
			   $ingo      ,
			   $matrix       
		        )               { $_ = '-' } 	                    

		my @INPUT = @ARGV ;
		
		if ( grep /help/ , @INPUT ) { 
			
			no warnings ;
			
			die $HELP if   ($INPUT[0] =~ /^help$/ and ! defined $INPUT[1]);
			die $HELP if   ($INPUT[0] !~ /^help$/ )                       ;
			
			if ( ($INPUT[1] !~ / (^\-w(\s*\d*))$    |
					     (^\-i$       )     |
					     (^\-o$       )     |
					     (^\-r(\s*\d*)$)    |
					     (^\-h$       )     |
					     (^\-s$       )     |
					     (^\-N$       )     |
					     (^\-e$       )     |
					     (^\-t$       )     |
					     (^\-l(\s*\d*\+*)$) |
					     (^\-output$  )     |
					     (^\-scoring$ )     |
					     (^\-commands$)     /x)  
			    )

			{ die "don't know what you want! use e.g. help -commands\n"            }
			
			help ( $INPUT[1] ) if $INPUT[0] =~ /^help$/ and $INPUT[1] =~ /^-.+$/   ;
			
			exit ;
			
		}
		
		for ( @ARGV ) { die "\nUnknown option: $_"."\n\n".$USAGE if /^-[^BPMirwNtlsohec]/ } ;
		
		
		my $dec_opts = 'irwNosehlt';
		
		$options{$_} = 0  for ( split"",$dec_opts ) ;
	
		die "semicolon not allowed in input options!\n" if map { /\:/ } @ARGV ;
	
=pod

If infile is not present, ALISCORE stops!

=cut
 
				
		PROTEINMATRIX: {
		
		     no warnings ;		
		
		   ( $matrix ) = grep /^-((PAM250|PAM500|MATCH|BLOSUM62))$ /xi , @INPUT ;
		     $matrix   =~ s/-//                                                 ;
					
				}
		
		map { s/^-(.)(.*)$/--$1\:$2/ } @INPUT ;
	
		@INPUT = ( split"--",( join"",@INPUT ) ) ;
		
		shift @INPUT;
		
		my $input_error = do { "don't know what you want! use e.g. help -commands\n" } ;

		for ( @INPUT ) {
			
			if ( /^w/ ) { die $input_error if !/ ^w\:\d*$    /x }
			if ( /^o/ ) { die $input_error if  / ^o\:$       /x }
			if ( /^r/ ) { die $input_error if !/ ^r\:\d*$    /x }
			if ( /^h/ ) { die $input_error if !/ ^h\:$       /x }
			if ( /^s/ ) { die $input_error if !/ ^s\:$       /x }
			if ( /^N/ ) { die $input_error if !/ ^N\:$       /x }
			if ( /^e/ ) { die $input_error if !/ ^e\:$       /x }
			if ( /^l/ ) { die $input_error if !/ ^l\:\d*\+*  /x }
			     
		}
		
		
		for ( @INPUT ) { die "use blanks between options!\n" if !/\:/ }
			
		for ( @INPUT ) {
		
			my ( $key, $value ) = split ":" ;
		
			$options{$key}     = $value        if ( exists $options{$key} and $value =~ /./   );
			$options{$key}     = 1             if ( exists $options{$key} and $value !~ /./   );
			$options{'matrix'} = uc( $matrix ) if defined $matrix;
				
		}
		
		INPUT: {

			$file      =  $options{i}      if  $options{i} =~ /\D (?#:file name should contain a letter) /x    ;           
        
			$window    =  $options{w}      if  $options{w} >  1                                                ;
			$window    =  6                if  $options{w} <= 1                                                ;
			
			$option    =  qw(N)            if  $options{N} == 1                                                ;
			$indels    = 'ambiguous'       if  $options{N} == 1                                                ;
			$indels    = 'characters'      if  $options{N} == 0                                                ;
			
			$random    =  $options{r}      if  $options{r} >  1                                                ;
			$random    =  qw(r)            if  $options{r} == 1                                                ;
			
			$pairs     = '4*NTAXA'         if  $options{r} == 1                                                ;
			$pairs     =  $options{r}      if  $options{r} >  1                                                ;    
			
			$tree      =  '-'              if  $options{r} >  1 && 
							   $options{t} =~ /0/                                              ; 
			$tree      =  $options{t}      if  $options{t} =~ /\D+ (?#:file name should contain a letter) /x   ;
			$tree      =  qw(NJ)           if  $options{t} =~ /^1/                                             ;
			$tree      =  qw(NJ)           if  $options{t} =~ /^0$/ && 
							   $options{r} =~ /^0$/ &&
							   $options{t} !~ /\D+ (?#:file name should contain a letter) /x   ;
							   
			$level     =  qw(all)          if  $options{t} =~ /^1$/ || 
							   $options{t} =~ /\D+/                                            ;
			$level     =  $options{l}      if  $options{l} !~ /^0$ (?#:any number is ok) /x                    ;   
			$level     =  qw(all)          if  $options{t} =~ /^0$/ && 
							   $options{r} =~ /^0$/ && 
							   $options{l} =~ /^0$/;
			
			$strict    =  $options{s}      if  $options{s} == 1                                                ;      
			$strict_in = 'yes'    	       if  $options{s} == 1                                                ;                        
			
			$outgroup  =  $options{o}      if  $options{o} !~ /^0$/                                            ;
			$group     = 'yes'             if  $options{o} !~ /^0$/                                            ; 

			$ingo      =  $options{e}      if  $options{e} == 1                                                ;
			
			$matrix    =  'BLOSUM62'                                                                           ;
			$matrix    =  $options{matrix} if  defined $options{matrix}                                        ;				
			
			die $HELP                      if  $options{h} == 1                                                ;
				
				
			}
	
		
		$window = Aliscore_module::even_numbered_window ( $window ) ;

		die "\nrandom and tree based selection of pairs are not compatible\n\n".$USAGE  if $random =~ /\w+/ && ($tree =~ /\w+/ || $level =~ /\d+/);
	
	
	return  (  $file      ,
		   $random    ,
		   $window    ,
		   $option    ,
		   $tree      ,
		   $level     ,
		   $strict    ,
		   $outgroup  ,
		   $pairs     ,
		   $indels    , 
		   $group     ,
		   $strict_in ,
		   $ingo      ,
		   $matrix       
		)
		
	}


sub even_numbered_window {
		
		my ( $window ) = @_ ;
		
		my $window2 = $window / 2 ;
	        
		$window += 1 if $window2 =~ /\./ ;

		return $window
		
	}



sub help {
	
		use Text::Wrap qw ($columns &wrap);

		$columns = 70 ;

		my ( $option ) = @_ ;
		
		$option eq '-w' and do {
			
				my @text = ('-w option ...','specifies dimension of the sliding window, default is w = 6. Window size below 4 do not make much sense since',
				            'error rates for miscalling randomness and non-randomness will be much to high. Only window dimensions of even numbered size ',
					    'will be accepted, if an uneven number is called by the user it will be changed to the next larger even number.','Larger window',
					    'dimensions will make the profiling less sensitive to small alignment sections of randomness.','Changing the window dimension is ',
					    'like using different magnifying glasses. see also Misof & Misof, 2008, Syst. Biol.'
					    );
		
				
				print   "\nhelp called for $option .... \n\n" ;
				print wrap("","              ",@text), "\n\n" ;

				exit;
				
				};
		
		$option eq '-i' and do {
			
				my @text = ('-i option ...','give the full name of the input file including extension. Input file must be in same folder as ALISCORE.',
					    'ALISCORE currently accepts files in FASTA format, in simple ASCII text format. Avoid formating input file with text editors',
					    'like MSWord or something comparable. Sequences my contain line breaks. The first line break is interpreted',						  ' as taxon name separator following the FASTA file convention. Taxon names must not contain *, ambiguities ',
					    ' ?, indels and stop codons (*) in are possible. ALISCORE estimates data type from ',
					    'frequencies of ACGT. Only if estimates are consistant among sequencies, ALISCORE continues with the process using the appropriate',
					    'scoring function.','RNA sequences will be recoded to DNA sequences. Leading and trailing indels will be replaced by N\'s in ',
                                            'nucleotide, but not in aminoacids sequences. There is no restriction on sequence number and sequence length.','For more',
					    ' information on reading the input data consult manual.'
					    );
		
				print   "\nhelp called for $option .... \n\n" ;
				print wrap("","              ",@text), "\n\n" ;

				exit;
				
				};
		
		$option eq '-t' and do {
			
				my @text = ('-t option ...','There are two possibilities to use a guiding tree in ALISCORE: if option -t is used without a input treefile',
					    'a NJ tree will be reconstructed using simple Hamming distances. The NJ tree will be saved in a file with .tre suffix. If -t is used with a treefile name, tree will be read from a file',
					    'in NEWICK format. Tree file must be in same folder. Only the first tree in a multiple trees file is read. If taxon names do not ',
					    'match between sequence files and tree files, ALISCORE issues an error.','ALISCORE uses the tree to work through the MSA from tips',
					    'to bottom. First, sister groups of terminal taxa are identified (node lists, level 1) and compared, these taxa are then replaced',
					    'by consensus sequences using the ambiguity code. Consensus sequences represent now new sets of terminal taxa.','This process is',
					    'repeated until every possible pair of sequences is evaluated.'
					    );
		
				print   "\nhelp called for $option .... \n\n" ;
				print wrap("","              ",@text), "\n\n" ;

				exit;
				
				};
				
		$option eq '-r' and do {
			
				my @text = ('-r option ...','if -r is used without an argument 4*N random pairs are compared, checking for replications (which are avoided).',
					    'If -r is used with an argument which is beyond the maximal number of possible non-overlapping pairs, only the maximal number',
					    'of pairs is compared. If the -r option and the -t option are not used, a NJ tree is generated by default for nucleotide,',
					    'sequences and 4*N random pairs are compared for aminoacid sequences.'
					    );

				print   "\nhelp called for $option .... \n\n" ;
				print wrap("","              ",@text), "\n\n" ;

				exit;
				
				};
		
		$option eq '-o' and do {
			
				my @text = ('-o option ...','The -o option is used with a list of taxa separated by commatas. A blank between -o and list of taxa is mandatory, ',
					    'taxa must beseparated by commatas and blanks should be avoided within taxon names and between taxa. These taxa will be compared with',
					    'all other taxa',
				            'not in this list. This option can be used to assess the range of randomness between outgroup taxa and ingroup taxa, or between',
					    'any two groups of taxa. This option is currently not compatible with the tree -t option.'
					    );
		
				print   "\nhelp called for $option .... \n\n" ;
				print wrap("","              ",@text), "\n\n" ;

				exit;
				
				};
				
		$option eq '-l' and do {
			
				my @text = ('-l option ...','-l can be used to restrict iterating through the tree to a specific node level, specified with the argument at',
					    'the -l option. If -l 1 is used only primary sister group relationships are used to infer the consensus profile. If there are ',
					    'less node levels then arguments, ALISCORE iterates through the tree and stops.','If -l #+ is used, ALISCORE records only single',
					    'profiles starting at the specified node label. Using this option can give you information on the signal in the data depending on',
					    'node level in the tree.'
					    );
		
				print   "\nhelp called for $option .... \n\n" ;
				print wrap("","              ",@text), "\n\n" ;

				exit;
				
				};		
		
		$option eq '-s' and do {
			
				my @text = ('-s option ...','option can be used to generate a strict profile from all single comparisons. This profile will be very conservative',
				            'because it scores every site as negative in the consensus profile which exhibits a negative score in one single profile already.',
					    );
		
				print   "\nhelp called for $option .... \n\n" ;
				print wrap("","              ",@text), "\n\n" ;

				exit;
				
				};

		$option eq '-N' and do {
			
				my @text = ('-N option ...','without invoking the -N option indels are treated as 5th character. With the -N option indels are treated as ',
				            'ambiguous characters. Leading and trailing gaps of sequences are always interpreted as ambiguous characters with and without ',
					    'the -N option. Interpreting indels as ambiguous characters results in a loss of long indel sections consistently found in the ',
					    'majority of taxa. This means that well aligned expansion segements in rDNA sequences, which are not present in other taxa will ',
					    'be lost, if not commonly found in the MSA. Interpreting gaps as 5th character interprets stretches of indels as well aligned ',
					    'sections. This option is currently ignored for aminoacid sequences.'
					    );
		
				print   "\nhelp called for $option .... \n\n" ;
				print wrap("","              ",@text), "\n\n" ;

				exit;
				
				};
				
		$option eq '-output' and do {
			
				my @text = ('output ...    ','Aliscore writes into two(three) files. One file will be a flat list of characters scoring negatively in the consensus ',
					    'profile separated by single spaces. This list can be used to define a character set for example in PAUP. The other file will be a flat table',
					    'of three columns, first column alignment position, second column characters scoring positively otherwise zero, and third column characters ',
					    'scoring negatively or zero. These columns can be used to generate a profile in many software packages, like GNUplot, Gnumerics or Excel.',
		 			    'If -t option was used a third file with the NJ guiding tree will be written. ALISCORE does not remove any characters from your alignment.'
					    );
		
				print   "\nhelp called for $option .... \n\n" ;
				print wrap("","              ",@text), "\n\n" ;

				exit;
				
				};

		$option eq '-scoring' and do {
			
				my @text = ('scoring ...   ','For nucleotide sequences ALISCORE uses a simple match/mismatch scoring matrix to calculate the observed window ',
				            'and resampled window scores. If ambiguities are present, ALISCORE makes an optimistic estimate with a reduced match score according',
					    'to degeneracy of ambiguities. Indels are either scored a fith\'s charaters or ambiguities.','For aminoacid sequences a BLOSUM62 ',
					    'matrix is used, indels are scored as strongly penalized mismatches if matching and not penalized if matching an aminoacid.',
					    'This scoring induces the effect, that if indels dominate in sections, these sections will be scored negatively in consensus profiles',
					    ', but if aminoacids dominate the section, indels will not have a negative effect.','this scoring was set to account for missing data,',
					    'typical in concatenated EST or phylogenomic data.','The biological implications of this scoring are admittedly problematic.'
					    );
		
				print   "\nhelp called for $option .... \n\n" ;
				print wrap("","              ",@text), "\n\n" ;

				exit;
				
				};
				
		$option eq '-commands' and do {
			
				my @text = ('commands ...  ','Input must contain an infile, all other options are not mandatory. Order of options in command line does not ',
				            'matter. You can use e.g. Aliscore.pl -i infile -t -N -l 6+ or Aliscore.pl -N -l 6+ -i infile -t . All options must proceed a -',
					    'sign e.g. -i or -o etc.. Specifications of options like number of pairwise comparison, tree file, window size must directly ',
					    'follow option invokation with blanks inbetween. If you use no option, ALISCORE will switch to defaults, tree search for ',
					    'nucleotide sequences and 4*NTAXA for amino acid sequences with window size of 6.'
					    );
		
				print   "\nhelp called for $option .... \n\n" ;
				print wrap("","              ",@text), "\n\n" ;

				exit;
				
				};
		
		$option eq '-e' and do {
			
				my @text = ('-e option ...','If run with the -e option ALISCORE scores indels in aminoacid data in an very unorthodox way',' It penalizes matching',
					    'indels heavily, but does not so if aminoacids and indels are compared. This has the effect, that alignment sections in which a couple of',
					    'sequences have missing data or long stretches of indels, these sections will not be penalized if otherwise conserved or with apparent signal.',
					    'A biological interpretation of this option is clearly absent, but it makes sense if data with lots of missing sections, like EST data,',
					    'are used. One possibility to interpret this scoring is, if many indels are present in a column, it is interpreted as an artifact.',
					    'This option is internally handled by the variable $ingo in honor of its initializer.'
					    );
		
				print   "\nhelp called for $option .... \n\n" ;
				print wrap("","              ",@text), "\n\n" ;

				exit;
				
				};		
				
				
	}
	
	

sub draw_singletons {

			no warnings;
			
			my ($type,$ref_FASTA) = @_;
			my @TAXA              = keys %$ref_FASTA;
			
			my $compare           = sub {

							my ($type,$seq1,$seq2) = @_    ;
							my  @seq1        = @$seq1;
							my  @seq2        = @$seq2;
			
							    $seq1        = join"" ,@seq1;
							    $seq1        =~s/-//g       ;
							    @seq1        = split"",$seq1; 
							#print "@seq1\n";

							    $seq2        = join"" ,@seq2;
							    $seq2        =~s/-//g       ;
							    @seq2        = split"",$seq2; 
							#print "@seq2\n";
			    
							my  $maxposition = @seq1 < @seq2 ? @seq1 : @seq2;


							$type eq 'nt' and do {
				
								CHECK: for my $position (0..$maxposition){
										return -1 if (($seq1[$position] ne "N") and ($seq2[$position] ne "N") and ($seq1[$position] ne $seq2[$position]));
									}
							};		
					
							$type eq 'aa' and do {
				
								CHECK: for my $position (0..$maxposition){
										return -1 if (($seq1[$position] ne "X") and ($seq2[$position] ne "X") and ($seq1[$position] ne $seq2[$position]));
									}
							};					
						    };
	
					
			
			my (@PAIRS,@TABOO);
			
				until (1 == @TAXA){
					my $first = shift@TAXA;
					push @PAIRS, ($first.",".$TAXA[$_]) for(0..$#TAXA);	
				}

				for (@PAIRS){
						my ($taxon1,$taxon2) = split "\,";#print "taxon1: ",$taxon1," Taxon2: ",$taxon2,"\n";
						my  $score           = $compare->($type,$$ref_FASTA{$taxon1},$$ref_FASTA{$taxon2}) || 1 ;
	
						if (1 == $score){
							if ($type eq 'nt') {
								if  ((my $count1 = grep /[AGCT]/i,@{$$ref_FASTA{$taxon1}})                 <  (my $count2 = grep /[AGCT]/i,@{$$ref_FASTA{$taxon2}}))                 { push @TABOO, $taxon1 and printf "\t%-20.20s pot. sim. to %-20.20s\n" , $taxon1, $taxon2 if !grep /\b$taxon1\b/,@TABOO }; 	
								if  ((my $count1 = grep /[AGCT]/i,@{$$ref_FASTA{$taxon1}})                 >  (my $count2 = grep /[AGCT]/i,@{$$ref_FASTA{$taxon2}}))                 { push @TABOO, $taxon2 and printf "\t%-20.20s pot. sim. to %-20.20s\n" , $taxon2, $taxon1 if !grep /\b$taxon2\b/,@TABOO }; 	
								if  ((my $count1 = grep /[AGCT]/i,@{$$ref_FASTA{$taxon1}})                 == (my $count2 = grep /[AGCT]/i,@{$$ref_FASTA{$taxon2}}))                 { push @TABOO, $taxon2 and printf "\t%-20.20s pot. sim. to %-20.20s\n" , $taxon2, $taxon1  if !grep /\b$taxon2\b/,@TABOO }; 	
							}
						
							if ($type eq 'aa') {
								if  ((my $count1 = grep /[ARNDCQEGHILKMFPSTWYV]/i,@{$$ref_FASTA{$taxon1}}) <  (my $count2 = grep /[ARNDCQEGHILKMFPSTWYV]/i,@{$$ref_FASTA{$taxon2}})) { push @TABOO, $taxon1 and printf "\t%-20.20s pot. sim. to %-20.20s\n" , $taxon1, $taxon2 if !grep /\b$taxon1\b/,@TABOO }; 	
								if  ((my $count1 = grep /[ARNDCQEGHILKMFPSTWYV]/i,@{$$ref_FASTA{$taxon1}}) >  (my $count2 = grep /[ARNDCQEGHILKMFPSTWYV]/i,@{$$ref_FASTA{$taxon2}})) { push @TABOO, $taxon2 and printf "\t%-20.20s pot. sim. to %-20.20s\n" , $taxon2, $taxon1 if !grep /\b$taxon2\b/,@TABOO }; 	
								if  ((my $count1 = grep /[ARNDCQEGHILKMFPSTWYV]/i,@{$$ref_FASTA{$taxon1}}) == (my $count2 = grep /[ARNDCQEGHILKMFPSTWYV]/i,@{$$ref_FASTA{$taxon2}})) { push @TABOO, $taxon2 and printf "\t%-20.20s pot. sim. to %-20.20s\n" , $taxon2, $taxon1 if !grep /\b$taxon2\b/,@TABOO }; 	
							}
						}
				}		

			#filter all double entries!		
	
			my %seen;
			
			@TABOO = grep { ! $seen{$_}++ } @TABOO;
	
		return @TABOO;	
	
	}


#_______________________________________________________________________________________

sub get_scoring {
			my ( $type, $matrix ) = @_;
			my %SCORING;

			die "sequence type not known!\n"                                       if $type   !~ /(nt|aa|RY)/;
			die "scoring matrix not implemented\nuse BLOSUM62, PAM250, PAM500 or MATCH\n" if $matrix !~ /(BLOSUM62|PAM250|PAM500|MATCH)/; 

			$matrix    = uc ( $matrix ) ;

			my $check  = sub {
					my ($arr1,$arr2) = @_;
					my (%hash2,@overlap);

					$hash2{$_} = 1 for (@$arr2);
					for (0..$#$arr1){push @overlap, $arr1->[$_] if (defined $hash2{$arr1->[$_]})};
	
					my $hit = @overlap;
					return $hit;
					};

			#creates nuleotide scoring function, includes ambiguities

			$type eq "nt" and do {

				my @nucleotides = qw ( A C G T - AC AG AT CG CT GT ACG ACT CGT AGT ACGT A- C- G- T- AC- AG- AT- CG- CT- GT- ACG- ACT- CGT- AGT- ACGT-);
				my %ambiguities =    ('A-'=>'A-','C-'=>'C-','G-'=>'G-','T-'=>'T-','AC'=>'M','AG'=>'R','AT'=>'W','CG'=>'S','CT'=>'Y','GT'=>'K','ACG'=>'V',
						      'ACT'=>'H','CGT'=>'B','AGT'=>'D','ACGT'=>'N','AC-'=>'M-','AG-'=>'R-','AT-'=>'W-','CG-'=>'S-','CT-'=>'Y-','GT-'=>'K-',
						      'ACG-'=>'V-','ACT-'=>'H-','CGT-'=>'B-','AGT-'=>'D-','ACGT-'=>'N-');
				for my $i (@nucleotides){
				    my @i       = split"",$i;#print $i,"\t";
				    my $recode1 = defined $ambiguities{$i} ? $ambiguities{$i} : $i;		
	
					for my $j (@nucleotides){
					    my @j       = split"",$j;#print $j,"\n";exit;
					    my $recode2 = defined $ambiguities{$j} ? $ambiguities{$j} : $j;
				            my $overlap = $check->(\@i,\@j);
				            my $max     = @i > @j ? @i : @j;#print $max,"\n";exit;
	    	       	    
					    $SCORING{$recode1.$recode2} = $overlap > 0 ? 1/$max : -1 if $max < 4; 
					    $SCORING{$recode1.$recode2} = $overlap > 0 ? 0      : -1 if $max > 3;
						
						}
					}

				};#end of do nucleotides!
				
			$type eq 'RY' and do {

				my @nucleotides = qw ( - AC AG AT CG CT GT ACG ACT CGT AGT ACGT AC- AG- AT- CG- CT- GT- ACG- ACT- CGT- AGT- ACGT-);
				my %ambiguities =    ('AC'=>'M','AG'=>'R','AT'=>'W','CG'=>'S','CT'=>'Y','GT'=>'K','ACG'=>'V',
						      'ACT'=>'H','CGT'=>'B','AGT'=>'D','ACGT'=>'N','AC-'=>'M-','AG-'=>'R-','AT-'=>'W-','CG-'=>'S-','CT-'=>'Y-','GT-'=>'K-',
						      'ACG-'=>'V-','ACT-'=>'H-','CGT-'=>'B-','AGT-'=>'D-','ACGT-'=>'N-');
				for my $i (@nucleotides){
				    my @i       = split"",$i;#print $i,"\t";
				    my $recode1 = defined $ambiguities{$i} ? $ambiguities{$i} : $i;		
	
					for my $j (@nucleotides){
					    my @j       = split"",$j;#print $j,"\n";exit;
					    my $recode2 = defined $ambiguities{$j} ? $ambiguities{$j} : $j;
				            my $overlap = $check->(\@i,\@j);
				            my $max     = @i > @j ? @i : @j;#print $max,"\n";exit;
	    	       	    
					    $SCORING{$recode1.$recode2} = $overlap > 0  ? 1/$max : -1 if $max  < 4 ;
					    $SCORING{$recode1.$recode2} = $overlap > 0  ? 0      : -1 if $max  > 3 ;
					    $SCORING{$recode1.$recode2} = 1 if $overlap > 0 and $recode1=~ /Y/ and $recode2=~ /Y/; 
						$SCORING{$recode1.$recode2} = 1 if $overlap > 0 and $recode1=~ /R/ and $recode2=~ /R/;
						
						}
					}

				};#end of do RY scoring
				
			
			$type eq "aa" and do {			
			
				#  Blosum62 source: NCBI
				#  Matrix made by matblas from blosum62.iij
				#  * column uses minimum score
				#  BLOSUM Clustered Scoring Matrix in 1/2 Bit Units
				#  Blocks Database = /data/blocks_5.0/blocks.dat
				#  Cluster Percentage: >= 62
				#  Entropy =   0.6979, Expected =  -0.5209
				
				my @BLOSUM62 =	(
				
						[ 4,-1,-2,-2, 0,-1,-1, 0,-2,-1,-1,-1,-1,-2,-1, 1, 0,-3,-2, 0,-2,-1, 0,-4 ],
						[-1, 5, 0,-2,-3, 1, 0,-2, 0,-3,-2, 2,-1,-3,-2,-1,-1,-3,-2,-3,-1, 0,-1,-4 ],
						[-2, 0, 6, 1,-3, 0, 0, 0, 1,-3,-3, 0,-2,-3,-2, 1, 0,-4,-2,-3, 3, 0,-1,-4 ],
						[-2,-2, 1, 6,-3, 0, 2,-1,-1,-3,-4,-1,-3,-3,-1, 0,-1,-4,-3,-3, 4, 1,-1,-4 ],
						[ 0,-3,-3,-3, 9,-3,-4,-3,-3,-1,-1,-3,-1,-2,-3,-1,-1,-2,-2,-1,-3,-3,-2,-4 ],
						[-1, 1, 0, 0,-3, 5, 2,-2, 0,-3,-2, 1, 0,-3,-1, 0,-1,-2,-1,-2, 0, 3,-1,-4 ],
						[-1, 0, 0, 2,-4, 2, 5,-2, 0,-3,-3, 1,-2,-3,-1, 0,-1,-3,-2,-2, 1, 4,-1,-4 ],
						[ 0,-2, 0,-1,-3,-2,-2, 6,-2,-4,-4,-2,-3,-3,-2, 0,-2,-2,-3,-3,-1,-2,-1,-4 ],
						[-2, 0, 1,-1,-3, 0, 0,-2, 8,-3,-3,-1,-2,-1,-2,-1,-2,-2, 2,-3, 0, 0,-1,-4 ],
						[-1,-3,-3,-3,-1,-3,-3,-4,-3, 4, 2,-3, 1, 0,-3,-2,-1,-3,-1, 3,-3,-3,-1,-4 ],
						[-1,-2,-3,-4,-1,-2,-3,-4,-3, 2, 4,-2, 2, 0,-3,-2,-1,-2,-1, 1,-4,-3,-1,-4 ],
						[-1, 2, 0,-1,-3, 1, 1,-2,-1,-3,-2, 5,-1,-3,-1, 0,-1,-3,-2,-2, 0, 1,-1,-4 ],
						[-1,-1,-2,-3,-1, 0,-2,-3,-2, 1, 2,-1, 5, 0,-2,-1,-1,-1,-1, 1,-3,-1,-1,-4 ],
						[-2,-3,-3,-3,-2,-3,-3,-3,-1, 0, 0,-3, 0, 6,-4,-2,-2, 1, 3,-1,-3,-3,-1,-4 ],
						[-1,-2,-2,-1,-3,-1,-1,-2,-2,-3,-3,-1,-2,-4, 7,-1,-1,-4,-3,-2,-2,-1,-2,-4 ],
						[ 1,-1, 1, 0,-1, 0, 0, 0,-1,-2,-2, 0,-1,-2,-1, 4, 1,-3,-2,-2, 0, 0, 0,-4 ],
						[ 0,-1, 0,-1,-1,-1,-1,-2,-2,-1,-1,-1,-1,-2,-1, 1, 5,-2,-2, 0,-1,-1, 0,-4 ],
						[-3,-3,-4,-4,-2,-2,-3,-2,-2,-3,-2,-3,-1, 1,-4,-3,-2,11, 2,-3,-4,-3,-2,-4 ],
						[-2,-2,-2,-3,-2,-1,-2,-3, 2,-1,-1,-2,-1, 3,-3,-2,-2, 2, 7,-1,-3,-2,-1,-4 ],
						[ 0,-3,-3,-3,-1,-2,-2,-3,-3, 3, 1,-2, 1,-1,-2,-2, 0,-3,-1, 4,-3,-2,-1,-4 ],
						[-2,-1, 3, 4,-3, 0, 1,-1, 0,-3,-4, 0,-3,-3,-2, 0,-1,-4,-3,-3, 4, 1,-1,-4 ],
						[-1, 0, 0, 1,-3, 3, 4,-2, 0,-3,-3, 1,-1,-3,-1, 0,-1,-3,-2,-2, 1, 4,-1,-4 ],
						[ 0,-1,-1,-1,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2, 0, 0,-2,-1,-1,-1,-1,-1,-4 ],
						[-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4, 1 ],
						
						);
			
			
				#  PAM250 source: NCBI
				# This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
				# PAM 250 substitution matrix, scale = ln(2)/3 = 0.231049
				# Expected score = -0.844, Entropy = 0.354 bits
				# Lowest score = -8, Highest score = 17
				#
			
				my @PAM250 =	(
				
						[ 2,-2, 0, 0,-2, 0, 0, 1,-1,-1,-2,-1,-1,-3, 1, 1, 1,-6,-3, 0, 0, 0, 0,-8 ],
						[-2, 6, 0,-1,-4, 1,-1,-3, 2,-2,-3, 3, 0,-4, 0, 0,-1, 2,-4,-2,-1, 0,-1,-8 ],
						[ 0, 0, 2, 2,-4, 1, 1, 0, 2,-2,-3, 1,-2,-3, 0, 1, 0,-4,-2,-2, 2, 1, 0,-8 ],
						[ 0,-1, 2, 4,-5, 2, 3, 1, 1,-2,-4, 0,-3,-6,-1, 0, 0,-7,-4,-2, 3, 3,-1,-8 ],
						[-2,-4,-4,-5,12,-5,-5,-3,-3,-2,-6,-5,-5,-4,-3, 0,-2,-8, 0,-2,-4,-5,-3,-8 ],
						[ 0, 1, 1, 2,-5, 4, 2,-1, 3,-2,-2, 1,-1,-5, 0,-1,-1,-5,-4,-2, 1, 3,-1,-8 ],
						[ 0,-1, 1, 3,-5, 2, 4, 0, 1,-2,-3, 0,-2,-5,-1, 0, 0,-7,-4,-2, 3, 3,-1,-8 ],
						[ 1,-3, 0, 1,-3,-1, 0, 5,-2,-3,-4,-2,-3,-5, 0, 1, 0,-7,-5,-1, 0, 0,-1,-8 ],
						[-1, 2, 2, 1,-3, 3, 1,-2, 6,-2,-2, 0,-2,-2, 0,-1,-1,-3, 0,-2, 1, 2,-1,-8 ],
						[-1,-2,-2,-2,-2,-2,-2,-3,-2, 5, 2,-2, 2, 1,-2,-1, 0,-5,-1, 4,-2,-2,-1,-8 ],
						[-2,-3,-3,-4,-6,-2,-3,-4,-2, 2, 6,-3, 4, 2,-3,-3,-2,-2,-1, 2,-3,-3,-1,-8 ],
						[-1, 3, 1, 0,-5, 1, 0,-2, 0,-2,-3, 5, 0,-5,-1, 0, 0,-3,-4,-2, 1, 0,-1,-8 ],
						[-1, 0,-2,-3,-5,-1,-2,-3,-2, 2, 4, 0, 6, 0,-2,-2,-1,-4,-2, 2,-2,-2,-1,-8 ],
						[-3,-4,-3,-6,-4,-5,-5,-5,-2, 1, 2,-5, 0, 9,-5,-3,-3, 0, 7,-1,-4,-5,-2,-8 ],
						[ 1, 0, 0,-1,-3, 0,-1, 0, 0,-2,-3,-1,-2,-5, 6, 1, 0,-6,-5,-1,-1, 0,-1,-8 ],
						[ 1, 0, 1, 0, 0,-1, 0, 1,-1,-1,-3, 0,-2,-3, 1, 2, 1,-2,-3,-1, 0, 0, 0,-8 ],
						[ 1,-1, 0, 0,-2,-1, 0, 0,-1, 0,-2, 0,-1,-3, 0, 1, 3,-5,-3, 0, 0,-1, 0,-8 ],
						[-6, 2,-4,-7,-8,-5,-7,-7,-3,-5,-2,-3,-4, 0,-6,-2,-5,17, 0,-6,-5,-6,-4,-8 ],
						[-3,-4,-2,-4, 0,-4,-4,-5, 0,-1,-1,-4,-2, 7,-5,-3,-3, 0,10,-2,-3,-4,-2,-8 ],
						[ 0,-2,-2,-2,-2,-2,-2,-1,-2, 4, 2,-2, 2,-1,-1,-1, 0,-6,-2, 4,-2,-2,-1,-8 ],
						[ 0,-1, 2, 3,-4, 1, 3, 0, 1,-2,-3, 1,-2,-4,-1, 0, 0,-5,-3,-2, 3, 2,-1,-8 ],
						[ 0, 0, 1, 3,-5, 3, 3, 0, 2,-2,-3, 0,-2,-5, 0, 0,-1,-6,-4,-2, 2, 3,-1,-8 ],
						[ 0,-1, 0,-1,-3,-1,-1,-1,-1,-1,-1,-1,-1,-2,-1, 0, 0,-4,-2,-1,-1,-1,-1,-8 ],
						[-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8, 1 ],
						
						);
			
			
				#  PAM500 source: NCBI
				# This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
				# PAM 500 substitution matrix, scale = ln(2)/7 = 0.0990210
				# Expected score = -0.401, Entropy = 0.0803 bits
				# Lowest score = -9, Highest score = 34
				#
				
				my @PAM500 =	(
						
						[ 1,-1, 0, 1,-2, 0, 1, 1, 0, 0,-1, 0,-1,-3, 1, 1, 1,-6,-3, 0, 1, 0, 0,-9 ],
						[-1, 5, 1, 0,-4, 2, 0,-1, 2,-2,-2, 4, 0,-4, 0, 0, 0, 4,-4,-2, 0, 1, 0,-9 ],
						[ 0, 1, 1, 2,-3, 1, 1, 1, 1,-1,-2, 1,-1,-4, 0, 1, 0,-5,-3,-1, 1, 1, 0,-9 ],
						[ 1, 0, 2, 3,-5, 2, 3, 1, 1,-2,-3, 1,-2,-5, 0, 1, 0,-7,-5,-1, 2, 2, 0,-9 ],
						[-2,-4,-3,-5,22,-5,-5,-3,-4,-2,-6,-5,-5,-3,-2, 0,-2,-9, 2,-2,-4,-5,-2,-9 ],
						[ 0, 2, 1, 2,-5, 2, 2, 0, 2,-1,-2, 1,-1,-4, 1, 0, 0,-5,-4,-1, 2, 2, 0,-9 ],
						[ 1, 0, 1, 3,-5, 2, 3, 1, 1,-2,-3, 1,-1,-5, 0, 1, 0,-7,-5,-1, 2, 2, 0,-9 ],
						[ 1,-1, 1, 1,-3, 0, 1, 4,-1,-2,-3, 0,-2,-5, 1, 1, 1,-8,-5,-1, 1, 1, 0,-9 ],
						[ 0, 2, 1, 1,-4, 2, 1,-1, 4,-2,-2, 1,-1,-2, 0, 0, 0,-2, 0,-2, 1, 2, 0,-9 ],
						[ 0,-2,-1,-2,-2,-1,-2,-2,-2, 3, 4,-2, 3, 2,-1,-1, 0,-5, 0, 3,-2,-2, 0,-9 ],
						[-1,-2,-2,-3,-6,-2,-3,-3,-2, 4, 7,-2, 4, 4,-2,-2,-1,-1, 1, 3,-3,-2,-1,-9 ],
						[ 0, 4, 1, 1,-5, 1, 1, 0, 1,-2,-2, 4, 0,-5, 0, 0, 0,-3,-5,-2, 1, 1, 0,-9 ],
						[-1, 0,-1,-2,-5,-1,-1,-2,-1, 3, 4, 0, 4, 1,-1,-1, 0,-4,-1, 2,-1,-1, 0,-9 ],
						[-3,-4,-4,-5,-3,-4,-5,-5,-2, 2, 4,-5, 1,13,-4,-3,-3, 3,13, 0,-4,-5,-2,-9 ],
						[ 1, 0, 0, 0,-2, 1, 0, 1, 0,-1,-2, 0,-1,-4, 4, 1, 1,-6,-5,-1, 0, 1, 0,-9 ],
						[ 1, 0, 1, 1, 0, 0, 1, 1, 0,-1,-2, 0,-1,-3, 1, 1, 1,-3,-3,-1, 1, 0, 0,-9 ],
						[ 1, 0, 0, 0,-2, 0, 0, 1, 0, 0,-1, 0, 0,-3, 1, 1, 1,-6,-3, 0, 0, 0, 0,-9 ],
						[-6, 4,-5,-7,-9,-5,-7,-8,-2,-5,-1,-3,-4, 3,-6,-3,-6,34, 2,-6,-6,-6,-4,-9 ],
						[-3,-4,-3,-5, 2,-4,-5,-5, 0, 0, 1,-5,-1,13,-5,-3,-3, 2,15,-1,-4,-4,-2,-9 ],
						[ 0,-2,-1,-1,-2,-1,-1,-1,-2, 3, 3,-2, 2, 0,-1,-1, 0,-6,-1, 3,-1,-1, 0,-9 ],
						[ 1, 0, 1, 2,-4, 2, 2, 1, 1,-2,-3, 1,-1,-4, 0, 1, 0,-6,-4,-1, 2, 2, 0,-9 ],
						[ 0, 1, 1, 2,-5, 2, 2, 1, 2,-2,-2, 1,-1,-5, 1, 0, 0,-6,-4,-1, 2, 2, 0,-9 ],
						[ 0, 0, 0, 0,-2, 0, 0, 0, 0, 0,-1, 0, 0,-2, 0, 0, 0,-4,-2, 0, 0, 0, 0,-9 ],
						[-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9, 1 ],

						);
				
				my @MATCH =	(
						
						[ 1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1 ],
						[-1, 1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1 ],
						[-1,-1, 1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1 ],
						[-1,-1,-1, 1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1 ],
						[-1,-1,-1,-1, 1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1 ],
						[-1,-1,-1,-1,-1, 1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1 ],
						[-1,-1,-1,-1,-1,-1, 1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1 ],
						[-1,-1,-1,-1,-1,-1,-1, 1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1 ],
						[-1,-1,-1,-1,-1,-1,-1,-1, 1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1 ],
						[-1,-1,-1,-1,-1,-1,-1,-1,-1, 1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1 ],
						[-1,-1,-1,-1,-1,-1,-1,-1,-1,-1, 1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1 ],
						[-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1, 1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1 ],
						[-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1, 1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1 ],
						[-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1, 1,-1,-1,-1,-1,13,-1,-1,-1,-1,-1 ],
						[-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1, 1,-1,-1,-1,-1,-1,-1,-1,-1,-1 ],
						[-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1, 1,-1,-1,-1,-1,-1,-1,-1,-1 ],
						[-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1, 1,-1,-1,-1,-1,-1,-1,-1 ],
						[-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1, 1,-1,-1,-1,-1,-1,-1 ],
						[-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,13,-1,-1,-1,-1, 1,-1,-1,-1,-1,-1 ],
						[-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1, 1,-1,-1,-1,-1 ],
						[-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1, 1,-1,-1,-1 ],
						[-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1, 1,-1,-1 ],
						[-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1, 1,-1 ],
						[-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1, 1 ],

						);
				
				
=pod

Following lines generate a hash with scoring values for a given scoring matrix and fill indel scoring with scoring of stop codons derived from the scoring matrix.


=cut
				my @aminoacids = ( 'A', 'R', 'N', 'D', 'C', 'Q', 'E', 'G', 'H', 'I', 'L', 'K', 'M', 'F', 'P', 'S', 'T', 'W', 'Y', 'V', 'B', 'Z', 'X', '*');
			
				my $create = sub {
					
							my $aa_lead    = 0 ;
				
							for my $line (@_) {
								
									for (my $a=0;$a<=$#{$line};$a++) {
					
										$SCORING{$aminoacids[$aa_lead].$aminoacids[$a]} = $line -> [$a];
				
									}
				
									$aa_lead ++
							}
					
						} ;
				
				
				
				$matrix eq 'BLOSUM62' and do { $create -> ( @BLOSUM62 ) } ;
				$matrix eq 'PAM250'   and do { $create -> ( @PAM250   ) } ;
				$matrix eq 'PAM500'   and do { $create -> ( @PAM500   ) } ;
				$matrix eq 'MATCH'    and do { $create -> ( @MATCH    ) } ;
				
				my $indel_score =  $SCORING{'A'.'*'};
				
				for (@aminoacids) { $SCORING{$_.'-'}  = $indel_score; $SCORING{'-'.$_}  = $indel_score; $SCORING{'-'.'-'} = $indel_score }
					
					    
			
			};

			return \%SCORING;
	
	}#end of sub get_scoring


#_______________________________________________________________________________________


sub ambiguity_table {
	
			my %TABLE;
			my @nucleotides = qw ( A C G T - M R W S Y K V H B D N A- C- G- T- M- R- W- S- Y- K- V- H- B- D- N-);
			my %ambiguities =    ('A'=>'A','C'=>'C','G'=>'G','T'=>'T','-'=>'-','A-'=>'A-','C-'=>'C-','G-'=>'G-','T-'=>'T-','AC'=>'M','AG'=>'R','AT'=>'W',
					      'CG'=>'S','CT'=>'Y','GT'=>'K','ACG'=>'V','ACT'=>'H','CGT'=>'B','AGT'=>'D','ACGT'=>'N','AC-'=>'M-','AG-'=>'R-','AT-'=>'W-',
					      'CG-'=>'S-','CT-'=>'Y-','GT-'=>'K-','ACG-'=>'V-','ACT-'=>'H-','CGT-'=>'B-','AGT-'=>'D-','ACGT-'=>'N-');
	
	
			for my $i (@nucleotides){
			    my ($recode1,$recode2);
		
				for my $key (keys %ambiguities){
					if ($i eq $ambiguities{$key}){ $recode1 = $key}
					}
		
			for my $j (@nucleotides){
				
				for my $key (keys %ambiguities){
					if ($j eq $ambiguities{$key}){ $recode2 = $key}
					}	
			
				my @merging = sort (split"",($recode1.$recode2));
			
				my $merging =   join"",@merging;
				   $merging =~ s/(-*)(.+)/$2$1/;
				   $merging =~ tr/ACGT-/ACGT-/s;
					       	    
			      $TABLE{$i.$j} = $ambiguities{$merging};
	       		
					}
				}

			return \%TABLE;
	}#end of sub ambiguity table	   

#_______________________________________________________________________________________

#sub of getting threshhold fot aa scoring

sub get_threshhold {
	
			my ($ref_scoring,$window,$ref_FASTA) = @_;
			my @aminoacids = qw(A R N D C Q E G H I L K M F P S T W Y V);
			my %freq_aa;
			my $aa_total;
			my @freq_aa_base;
			my %freq_scores;
	
			for my $ref_sequence (values %$ref_FASTA) { $aa_total += (grep /[ARNDCQEGHILKMFPSTWYV]/,@$ref_sequence ) }
		
	
			for my $aa (@aminoacids) {
				my $aa_single;
				for my $ref_sequence (values %$ref_FASTA) { $aa_single += (grep /$aa/,@$ref_sequence ) }
				$freq_aa{$aa} = int (($aa_single/$aa_total) * 100 )
		
			}
		
		
			for my $key (keys %freq_aa) {
				push @freq_aa_base, ($key) x ( $freq_aa {$key}*10 )
	
			}
		
		
			for (1..100) {
				
				my @boot;
				push @boot , \$freq_aa_base[int(rand($#freq_aa_base + 1))] until (($#freq_aa_base + 1) == @boot);
				
				
					for (1..100)  {
						my @half_boot;
						push @half_boot , $boot[int(rand($#boot + 1))] until (($#boot + 1)/2 == @half_boot);	
						
						for (1..100) {
							my $score;
					
								for (1..$window) {
									$score += $$ref_scoring { ${$half_boot[ int(rand($#half_boot + 1))]}.${$half_boot[ int(rand($#half_boot + 1))]} }
								}
					
						$freq_scores {$score} ++
						}
					}	
			}
			
			map { $_/=(100*100*100) } (values %freq_scores);
		
			my  ($cum_score,$threshhold);	
			
			#open OUT,">","distribution.txt";
			
			CUTOFF:	for my $single_score (sort {$a<=>$b} keys %freq_scores){
					
			#		print OUT $single_score,"\t",$freq_scores {$single_score},"\n";
					
					$cum_score                 += $freq_scores{$single_score};
					$freq_scores{$single_score} = $cum_score;
					$threshhold                 = $single_score and last CUTOFF if $freq_scores{$single_score} >= 0.95
				}
		#print $threshhold,"\n";
	return $threshhold;
	
	};

#_______________________________________________________________________________________

#sub replace ambiguities in DNA, sequences must be 2-dimensional arrays

sub rp_ambiguities {
			my ($position) = @_;
			#ambiguities
			my @N = qw(A C G T);
			my @M = qw(A C);
			my @R = qw(A G);
			my @W = qw(A T);
			my @S = qw(C G);
			my @Y = qw(C T);
			my @K = qw(G T);
			my @V = qw(A C G);
			my @H = qw(A C T);
			my @B = qw(C G T);
			my @D = qw(A G T);
			#replace with arrays
				if (grep /N/,@$position){shift @$position;push @$position, @N}
				if (grep /M/,@$position){shift @$position;push @$position, @M}
				if (grep /R/,@$position){shift @$position;push @$position, @R}
				if (grep /W/,@$position){shift @$position;push @$position, @W}
				if (grep /S/,@$position){shift @$position;push @$position, @S}
				if (grep /Y/,@$position){shift @$position;push @$position, @Y}
				if (grep /K/,@$position){shift @$position;push @$position, @K}
				if (grep /V/,@$position){shift @$position;push @$position, @V}
				if (grep /H/,@$position){shift @$position;push @$position, @H}
				if (grep /B/,@$position){shift @$position;push @$position, @B}
				if (grep /D/,@$position){shift @$position;push @$position, @D}	
	}#end of sub rp_ambiguities


#_______________________________________________________________________________________


sub nuc_score_two {
	
			my ($ref_scoring,$variability,$window,$seq1,$seq2) = @_;
			
			#sequences are read as references, $seq1, $seq2 are references	
			my @basket = ($seq1,$seq2);
			
			#check whether sequences are of equal length
			die "sequences are not of equal length!\n" if (my $length1 = @$seq1)!= (my $length2 = @$seq2);
			my $length = $length1;
			
			#declare and initialize return array of alignment quality scores and references to input sequences
			my @MSA_Score = (0)x $length;
			
			#start sliding window approach for MC quality score, labeled SLIDE
			SLIDE:	foreach my $j (@$variability){
				
				my ($MC_score,%MC_Hash,$score,$threshhold,$Org_score);
				my $position = $j;

			#evaluates window of original sequences
			#print $seq1->[$position].$seq2->[$position],'=>',$$ref_scoring{$seq1->[$position].$seq2->[$position]},"\n";
					$Org_score += $$ref_scoring{$seq1->[$position].$seq2->[$position]}, $position++ for (1..$window);#print $Org_score,"\n";exit;
					undef $position;
			#print "org_score: $Org_score, position: $j\n";


			#checks $Org_score value, starts MC resampling if Org_score did not hit max or min value
			#PERFECT:
			if ($Org_score == $window){
					map {$_+=1} @MSA_Score[$j..($j+($window-1))] and next SLIDE;#print "@MSA_Score\n";
					}
			#NOTHING:
			elsif ($Org_score == (0-$window)){
					map {$_-=1} @MSA_Score[$j..($j+($window-1))] and next SLIDE;#print "@MSA_Score\n";
					}
			#starts MC resampling, since Org_score did not hit max or min value	
			#TESTING:
			else {
			#set MC sampling pool from a double size sequence window,
			#does not move compositional window until $j>=$window/2
			#LEFT:
					if ($j < ($window/2)){
			#runs the MC resampling approach to generate new similarity scores of randomly drawn sequences
						foreach (1..100){
							foreach (1..$window){
								$MC_score=0;
			#selects randomly two positions from compositional window of both sequences
								$MC_score+=$$ref_scoring{$basket[int(rand(2))]->[int(rand($window*2))].$basket[int(rand(2))]->[int(rand($window*2))]};
								}
			#print "mc-score: $MC_score\n";
							$MC_Hash{$MC_score}++;
		      					}
						}	   
			#does not move compositional window if $j>$length-($window*2+1)	
			#RIGHT:
					elsif ($j > ($length-($window+$window/2))){
			#runs the MC resampling approach to generate new similarity scores of randomly drawn sequences
						foreach (1..100){
							foreach (1..$window){
								$MC_score=0;
								$MC_score+=$$ref_scoring{$basket[int(rand(2))]->[$length-(int(rand($window*2))+1)].$basket[int(rand(2))]->[$length-(int(rand($window*2))+1)]};
								}
							$MC_Hash{$MC_score}++;
		      					}
						}	
			#slides compositional window if ($window/2)<$j>$length-($window*2+1)	
			#MIDDLE:
					else {
			#runs the MC resampling approach to generate new similarity scores of randomly drawn sequences
						foreach (1..100){
							foreach (1..$window){
								$MC_score=0;;
								$MC_score+=$$ref_scoring{$basket[int(rand(2))]->[(int(rand($window*2)))+($j-$window/2)].$basket[int(rand(2))]->[(int(rand($window*2)))+($j-$window/2)]};	    
								}
							$MC_Hash{$MC_score}++;
		      					}
						}

						
			#MC resampling finished, Hash with scores of random sampling generated

			#summarizes hits of MC resampling
			CUTOFF:		foreach $MC_score (sort {$a<=>$b} keys %MC_Hash){
			#print "key: $MC_score\t->value: $MC_Hash{$MC_score}\t";
						$score+=$MC_Hash{$MC_score};
						$MC_Hash{$MC_score}=$score;#print "cumul. score: $score\n";
						$threshhold=$MC_score and last CUTOFF if $MC_Hash{$MC_score}>=95
						}
						
			#sets score value for each position in MSA Aliscore array
			#print "threshhold: $threshhold\n";
						map {$_+=1} @MSA_Score[$j..($j+($window-1))] if $Org_score > $threshhold;	
						map {$_-=1} @MSA_Score[$j..($j+($window-1))] if $Org_score <= $threshhold;
			#print "@MSA_Score\n";
			
				}#end of else TESTING
				
				
			#cleaning of runing variables
			($Org_score,$MC_score,$threshhold)=();
			undef %MC_Hash;
			
			}#end of sliding window and for loop

			return \@MSA_Score;

	} #end of sub pars_score_two


#_______________________________________________________________________________________



sub aa_score_two {
	
			my ($ref_scoring,$threshhold,$window,$seq1,$seq2) = @_;
			
			#sequences are read as references, $seq1, $seq2 are references	
			my @basket = ($seq1,$seq2);
			
			#check whether sequences are of equal length
			die "sequences are not of equal length!\n" if (my $length1 = @$seq1) != (my $length2 = @$seq2);
			my $length = $length1;
			
			#declare and initialize return array of alignment quality scores and references to input sequences
			my @MSA_Score = (0)x $length;
 
			
			#start sliding window approach for MC quality score, labeled SLIDE
			SLIDE:	foreach my $j (0..$length-($window+1)){
			
					my $Org_score    ;
					my $position = $j;

			#evaluates window of original sequences
			
					$Org_score += $$ref_scoring{$seq1->[$position].$seq2->[$position]}, $position++ for (1..$window);#print $Org_score,"\n";exit;
					
			#print "org_score: $Org_score, position: $j\n";#exit;

			
			#PERFECT:
					if ($Org_score  > $threshhold) {
						map {$_+=1} @MSA_Score[$j..($j+($window-1))] and next SLIDE;
					}
			#NOTHING:
					if ($Org_score <= $threshhold) {
						map {$_-=1} @MSA_Score[$j..($j+($window-1))] and next SLIDE;#print "@MSA_Score\n";
					}
			
				
				}#end of else SLIDE
				
	return \@MSA_Score;

	} #end of sub pars_score_two


#_______________________________________________________________________________________


#sub consensus sequence for two 2-dimensional sequence arrays

sub conseq {
			my ($seq1,$seq2)=@_;
			my @conseq;
			#check whether sequences are of equal length
			die "sequences are not of equal length!\n" if (my $length1=@$seq1)!= (my $length2=@$seq2);
			#compares 2-dimensional arrays

			for my $i (0..$length1-1){
			    my (@position,$hit);
			    my $dimension=@{$seq1->[$i]};
				for my $n (0..$dimension-1){
					push @position, $seq1->[$i][$n] if 0 == ($hit=(grep /$seq1->[$i][$n]/,@{$seq2->[$i]}));
					}
			    push @position, @{$seq2->[$i]};#print "pos: @position\n";
			    push @conseq, \@position;
				}
			return @conseq;
	}

#_______________________________________________________________________________________

sub consensus_sequence {
			my ($table,$seq1,$seq2)=@_;
			my @conseq;
			my $length1=@$seq1;#print $length1,"\n",$seq1->[0],"\n";exit;	
	
			die "sequences are not of equal length!\n" if ($length1!= (my $length2=@$seq2));

			push @conseq, ($$table{$seq1->[$_].$seq2->[$_]}) foreach (0..$length1-1);
			return @conseq;
	}

#_______________________________________________________________________________________

#sub for overlap of arrays

sub overlap {
			my ($arr1,$arr2)=@_;
			my (%hash2,@overlap);

			$hash2{$_}=1 for (@$arr2);
			for (0..$#$arr1){push @overlap, $arr1->[$_] if (defined $hash2{$arr1->[$_]})};
	
			my $hit=@overlap;
			return \$hit;
	}	
#_______________________________________________________________________________________

sub overlap_explicit {
			my ($arr1,$arr2)=@_;
			my (%hash2,@overlap);

			$hash2{$_}=1 for (@$arr2);
			for (0..$#$arr1){push @overlap, $arr1->[$_] if (defined $hash2{$arr1->[$_]})};
	
			return \@overlap;
	}	

#_______________________________________________________________________________________


#sub read FASTA file, returns references to fasta hash, keys taxa, values sequences

sub readFASTA_simple {
	

		my ($taxon,@FASTA,%FASTA,%STRUCTURES,$number,$type,$aa_type);
		
		$aa_type             = 0 ;

		my ( $file , $ingo ) = @_;
		
		
		#makes sure that linefeeds are just naked \n and nothing else
			
			(open IN , $file ) || die "file $file can not be opened!\n"; close IN ;
			
			(tie ( my @data, 'Tie::File', $file ));
			
			die "file $file is empty!\n" if 0 == @data ;
			map { s/\r\n/\n/g } @data ;
			map { s/\r/\n/g   } @data ;

			untie @data ;
		
		open (my $fh, "<",$file) || die "file $file not found! terminated\n";
	
		READING: 
		
		while ( <$fh> ) {

			die "convert from mac format!\n" if /\r[^\n]/;
		
			chomp ;
				
			next READING                if /^\s+$/;
			die "taxon name missing!\n" if /^\>$/ ;
			
			if ( /\>/ ) {		
			
				$taxon = $_                                               ;
				$taxon =~ s/^\>\s*/\>/g                                   ;
				$taxon =~ s/\s*$//g                                       ;
				die "multiple taxa of $taxon\n" if defined $FASTA{$taxon} ; 
				next READING                                              ;
				
			}
	
			s/\s*//g and $FASTA{$taxon} .= $_ ;
		
		}
		
	
		for my $key ( keys %FASTA ) { 
			
			my $NAMEERROR = do { "forbidden sign or space in\n$key\n" } ;
			
			for ( $key ) {
				
				die $NAMEERROR if /\|/ ; 
				die $NAMEERROR if /\(/ ;
				die $NAMEERROR if /\)/ ;
				die $NAMEERROR if /\:/ ;
				die $NAMEERROR if /\;/ ;
				die $NAMEERROR if /\,/ ;
				die $NAMEERROR if /--/ ;
				die $NAMEERROR if /\*/ ;
				die $NAMEERROR if /\s/ ;
				
			}
			
			die "file is not in FASTA format\n" if $key          !~  /^\>/;
			die "file is not in FASTA format\n" if $FASTA{$key}  =~  /\>/ ;
			die "not enough sequences!\n"       if 1>= keys %FASTA        ;
			
			my %seen = () ;
			
			my @TAXA = grep { ! $seen{$_}++ } keys %FASTA ;

		}
		
	
	#cleaning of taxa and sequences removing leading and trailing blanks
	
		grep s/^\>// || s/^\s*// || s/\s*$// , @FASTA = %FASTA;
		
		%FASTA = @FASTA;
		
		
	#identifying structure strings, cleaning, reading and modifying sequences using input options	
			
		for $taxon ( keys %FASTA ) {
			
			no warnings ;
			
			if ( $FASTA{$taxon} =~ /\(/ && /\)/ && /\./ ) {
				
				s/ //g;
				
				die "structure not balanced\n" if grep /\(/,$FASTA{$taxon} != grep /\)/,$FASTA{$taxon};
				
				print "\tstructure: $taxon \-\> ",length ( $FASTA{$taxon} ),"\n";
				
				$STRUCTURES{$taxon} = $FASTA{$taxon};
				
				delete $FASTA{$taxon}
			}
			
			else {
				
				$number ++;
				
				$FASTA{$taxon} = uc( $FASTA{$taxon} );
			
				$FASTA{$taxon} =~ s/ //g;		#print $taxon,"\n";
			
				die "\nsequence $taxon contains unknown characters!\nprocess terminated!\n" if $FASTA{$taxon} =~ /[^A-Z\?\-\*]/;	
				
				my $abs_indelN = ($FASTA{$taxon} =~ tr/N\-//      );
				
				if ( length( $FASTA{$taxon} ) != $abs_indelN ) {
					
					my $freq_ACGT  = ($FASTA{$taxon} =~ tr/ACG(T|U)// )/(length( $FASTA{$taxon} ) - $abs_indelN);
					my $freq_RY    = ($FASTA{$taxon} =~       tr/RY// )/(length( $FASTA{$taxon} ) - $abs_indelN);
					   $type       =  $freq_ACGT > 0.8 ? 'nt' : 'aa';
					   $type       =  $freq_RY   > 0.8 ? 'RY' : 'aa' if $type eq 'aa' 
				}
				
				if ( length( $FASTA{$taxon} ) == $abs_indelN ) {
					
					$number --
				}
				
				my @sequence   = split"", $FASTA{$taxon} ;
		
					$type eq "nt" and do {
								
								grep { s/\?/N/ } @sequence ;
								grep { s/\*/N/ } @sequence ;
								
							$ingo =~ /-/ and do {
								
								for  (           @sequence ){ last if /\w/; s/\-/N/ }
								for  ( reverse   @sequence ){ last if /\w/; s/\-/N/ }
								
									    };
							
							     };	

					$type eq "aa" and do {
		
								grep { s/\?/-/ } @sequence ;
								#for  (           @sequence ){ last if /\w/; s/\-/X/ }
								#for  ( reverse   @sequence ){ last if /\w/; s/\-/X/ }
			
							     };	
					$type eq 'RY' and do {
								
								grep { s/\?/N/ } @sequence ;
								grep { s/\*/N/ } @sequence ;
								die "A,C,G,T are not allowed in RY recoded sequences!\n" if grep /[ACGT]/i,@sequence; 
								
							$ingo =~ /-/ and do {
								
								for  (           @sequence ){ last if /\w/; s/\-/N/ }
								for  ( reverse   @sequence ){ last if /\w/; s/\-/N/ }
								
									    };
							
							     };	
	#reports on sequence length
				
				printf     "\t%-20.20s \-\> sites: %-6s\n" , $taxon, $#sequence+1;
		
				$FASTA{$taxon} = \@sequence;
		
				$aa_type++ if $type eq "aa";
		
				}
				
		}
		
	die "mixture of nucleotide and amino acid sequences!\n" if (0 < ($number - $aa_type)/$number) && (1 > ($number - $aa_type)/$number) ;
	
	#returns reference to FASTA hash and structure hash		

	return (\%FASTA,\%STRUCTURES,$type);print "\n\n";#exit;
	
	}#end of sub
#_______________________________________________________________________________________

#_______________________________________________________________________________________
#reads tree from file, and returns list of nodes, tree must be rooted at first taxon in tree!!!!!, needs sub list_nodes!!!
sub readTOPOLOGY {

#reads a tree in newick format and strips business parts of the tree, like brlens and support values and semi colons;taxon names may contain blanks alphanumeric signs and -, but no other signs, blanks are not modified into underscores! trees must not be fully resolved!
	my ($tree) = @_;
	
	#makes sure that linefeeds are just naked \n and nothing else
		
			tie ( my @data, 'Tie::File', $tree ) or die "file $tree can not be opened!\n" ;

			map { s/\r\n/\n/g } @data ;
			map { s/\r/\n/g   } @data ;

			untie @data ;
	
	open (my ($tr),"<",$tree) || die "tree file not found!\n";
	
	my @tree   = <$tr>;                                                                                            #print "da: ","@tree\n";exit;
	
	die "tree is unbalanced or not in NEWICK standard format!\n" if ($tree[0]!~/\(/) || ($tree[0]!~/\;/) || ($tree[0]!~/\)/);
	
	$tree      = join"",@tree;
	
	for($tree){
		s/e\-\d+//g            ;
		s/(\:\-*?\d+\.*\d*)//g ;
		s/\;//g                ;
		}
	
	my @taxa   = $tree =~ /(?i:[\w\-\. ])+/g;                                                                         #print $tree,"\n";exit;

#generates node list	
	my $nodes  = node_list($tree);
	return \@taxa,$nodes,\$tree;

		sub node_list {
	
				my ($tree)=@_;
				$tree=~s/ {2,}/ /g;#print $tree,"\n";#exit;
				die "unbalanced tree !\n" if ($tree=~/\(/)!=($tree=~/\)/);
				my (%nodes,$level);
		
		#First level Filter 
				$level++;
				my @selection=$tree=~/\((?i:[\w\-\. ])+\,(?i:[\w\-\. ])+(?i:[\w\-\,\. ])*\)(?#:two or more taxa)|
					              \((?i:[\w\-\. ])+\,(?i:[\w\-\. ])+(?i:[\w\-\,\. ])*\((?#:two or more taxa)|
					              \)(?i:[\w\-\. ])+\,(?i:[\w\-\. ])+(?i:[\w\-\,\. ])*\)(?#:two or more taxa)
					             /gx;
				#die "tree not dichotomous!\n" if grep /(?i:[\w\-\. ])+\,(?i:[\w\-\. ])+(?i:[\w\-\,\. ])+/,@selection;
				
				grep s/\(|\)//g,@selection;#print "@selection\n";
			
		#wrights nodes and level to key and value of %nodes
				$nodes{$_}=$level for (@selection);		   
		
				             $tree=~s/\(((?i:[\w\-\. ])+\,(?i:[\w\-\. ])+(?i:[\w\-\,\. ])*)\(/$1\(/g;
				             $tree=~s/\)((?i:[\w\-\. ])+\,(?i:[\w\-\. ])+(?i:[\w\-\,\. ])*)\)/\)$1/g;
	
				clean_tree (\$tree);
	
				sub clean_tree {
					
					my ($tree)=@_; 
					for ($$tree){
						    s/\(((?i:[\w\-\. ])+\,(?i:[\w\-\. ])+(?i:[\w\-\,\. ])*)\)/\,$1\,/g;
						    s/\,*\)\,*/\)/g;
						    s/\,*\(\,*/\(/g;
						    s/\,+/\,/g;
						  }
					}#print $tree,"\n";
	
		
		#Second++ level Filter	
	
				until ($tree!~/\(/ || $tree!~/\)/){
					$level++;
					my @selection=$tree=~/\((?i:[\w\-\. ])+\,(?i:[\w\-\. ])+(?i:[\w\-\,\. ])*\)(?#:two or more taxa)/gx;
	 				
				#	die "tree not dichotomous!\n" if grep /(?i:[\w\-\. ])+\,(?i:[\w\-\. ])+(?i:[\w\-\,\. ])+/,@selection;
					
					grep s/\(|\)//g,@selection;
					
		#wrights nodes and level to key and value of %nodes	
					$nodes{$_}=$level for (@selection);		   
					clean_tree (\$tree);#print $tree,"\n";	
					}#end of second level Filter
			
			#map {print $_,"\t",$nodes{$_},"\n"} (keys %nodes);exit;
			return \%nodes	
		}#end of sub node_list
	
}#end of readTopology


sub hamming_distance {
	
=pod

A simple match/mismatch distance matrix is calculated from sequence data, using a FASTA file as input file. Only the upper triangle without the zero diagonal is computed. Data is stored in a hash structure with taxon names separated by * as keys for distances between these two taxa as values. It returns a reference to the full distance matrix.
N's are ignored as ambiguous characters, all other ambiguities and indels are considered real differences. If Aliscore, for example was set to indels as ambiguous characters, -N option, all indels will be ignored.

=cut


		my ( $ref_FASTA, @taboo ) = @_;
		
		my @TAXA          = keys %$ref_FASTA;
		my %dist_matrix   = ();


print <<DISTANCE;
		Calculating Hamming distances ...
DISTANCE
		
		#remove potentially identical taxa
		
			for my $taboo (@taboo){grep s/\b$taboo\b//,@TAXA};
			    
			my $TAXA = join",",@TAXA;
				
			for ($TAXA){
					
				s/^\,+//x   ;
				s/\,+/\,/xg ;
				s/\,+$//x   ;
			} 	
			       
			@TAXA = split",",$TAXA;
			
			die "\n\tnot enough taxa left for tree reconstruction!\n\n" if 2 >= @TAXA ;
		
		until ( 1 == @TAXA ) {
			
			my $first = shift @TAXA ;
						
			for my $second  ( @TAXA ) {
				
				my $distance = 0;
				my $length   = @{$$ref_FASTA{$first}};
				
					COMPARISON: for ( 0..$#{$$ref_FASTA{$first}} ) {
						
								$distance ++ and next COMPARISON if   ${$$ref_FASTA{$first}}[$_] ne ${$$ref_FASTA{$second}}[$_]         ;

								  $length -- and next COMPARISON if ( ${$$ref_FASTA{$first}}[$_] |  ${$$ref_FASTA{$second}}[$_] ) eq 'N';
								  
						     }
					     
				$dist_matrix{$first."*".$second} = $distance / $length ;     
				
			}
		
		}

		return \%dist_matrix ;

}

sub net_divergence {

=pod

This subroutine expects as input a distance matrix. Full distance matrices will not result in correct calculations of net divergence of unique taxa. It further expects that distance matrix is handed over as a hash structure in which distances are values and both taxa separated by a * are associated keys. The subroutine extracts a list of unique taxa from the keys list of the distance matrix and extracts all keys from the distance matrix in which a particular taxon is involved. From these entries a net divergence for each taxon is then calculated.
The subroutine returns a reference to a hash with keys of unique taxa and associated net divergence values.

	net_div(i) = sum d(ij) for all j from i ... N
	
Remark:
Identical taxa names would lead to wrong net divergence calculations. Currently, the subroutine does not check for doubled entries of taxon names and it will also not report on these if present.

=cut

		my ( $dist_matrix ) = @_ ;
		
		my ( %net_div, @TAXA, @tmp, %seen );

		
		push @tmp , (split /\*/ , $_ ) for ( keys %$dist_matrix ) ;
		
		@TAXA = grep { ! $seen{$_}++ } @tmp ; 
		
		
		for my $taxon ( @TAXA ) {
			
			my @set = grep /\Q$taxon\E/, keys %$dist_matrix ;
				
			$net_div{$taxon} += $$dist_matrix{$_} for ( @set )
						
		}
			
		return \%net_div ;	
		
}


sub smallest_relative_distance_pair {
	
=pod	
	
Calculates an upper triangle relative distance matrix ( not including zero diagonals and both symetric cases) by using two input matrices, first the absolute distance matrix and secondly a net divergence matriy for all unique taxa. If taxon names do not correspond, the calculation of the relative distance matrix will be wrong. If the distance matrix has double entries of taxa, 'no-unique' taxa names, it will give wrong results, because the association of net divergence taxon names and distance taxon names will not be unique. 
It returns a reference to the relative full distance matrix stored in a hash structure, taxa separated by * as keys, and relative distances as associated values.

M(ij) = d(ij)-[ net_div(i)+net_div(j)]/(N-2)

=cut	
			

		my ( $dist_matrix, $net_div ) = @_ ;
		
		my ( $closest_dist, $closest_pair, @TAXA, @tmp, %seen ) ;
		
		push @tmp , (split /\*/ , $_ ) for ( keys %$dist_matrix )   ;
		
		@TAXA     = grep { ! $seen{$_}++ } @tmp ;
		
		my $NTAXA = @TAXA ;
		
		for my $key ( keys %$dist_matrix ) {
			
			if ( 3 > $NTAXA ) {
			
			$closest_pair          = $key and return $closest_pair ;
			
			}
			
			else {
				
			my ( $first, $second ) = split /\*/ , $key ;
			
			$closest_pair          = $key              ;
				
			$closest_dist          = $$dist_matrix{$key} - ( $$net_div{$first} + $$net_div{$second} ) / ( $NTAXA - 2 ) ;
			
			last 
			
			}

		}
		
		for my $key ( keys %$dist_matrix ) {
			
			my ( $first, $second ) = split /\*/ , $key ;
			
			my $min_relative_dist  = $$dist_matrix{$key} - ( $$net_div{$first} + $$net_div{$second} ) / ( $NTAXA - 2 ) ;
			
			if ( $closest_dist > $min_relative_dist ) {
				
				$closest_pair  = $key               ;
				$closest_dist  = $min_relative_dist ;
			
			}
			
		}
	
	return $closest_pair

}


sub closest_pair_net_divergence {
	
	my ( $dist_matrix )      = @_ ;
	
	my $net_div              =          net_divergence         ( $dist_matrix )           ;
	
	my $closest_pair         = smallest_relative_distance_pair ( $dist_matrix, $net_div ) ;
	
	return $closest_pair, $net_div
	
}
	

sub NJ_tree {
	
	no warnings ;
	
=pod

This subroutine calculates a NJ tree given a set of taxa and its associated set of distances. It reads a hash list of distances with taxon names separated with * as key entries. If taxon namesare not separated by * it will fail to construct a correct NJ tree. Any list of distances can be used, given that they contain positive values.


=cut
	
		my ( $dist_matrix ) = @_ ;
		
		my @node_list       = () ;
		
=pod

Loop through the distance matrix to create a full NJ tree.

=cut

print<<NJ;
		Building NJ tree     	      ...
NJ

DECOMPOSITION: while ( keys %$dist_matrix ) {


=pod

The net_divergence of each single taxon (not combined taxon from the distance matrix!) is calculated using the formular given by Saitou
	
	net_div(i) = sum d(ij) for all j from i ... N
	
The relative distance between taxa stored again in a hash of combined taxa as keys is calculated using the formular given by Saitou 

	M(ij) = d(ij) - [ net_div(i) + net_div(j) ] / (N-2)

=cut

		my ( $closest_pair, $net_div ) = closest_pair_net_divergence ( $dist_matrix ) ;
		

=pod

The closest pair within this hash of relative sequences is identified via reverse hash copying and its associated set of branch lengths is calculated, pairs of identical taxa (selve similar) are not present in the distance matrix due to prior removal.

	s(iu) = d(ij)/2 + [ net_div(i) - net_div(j) ]/ 2*(N-2)
	s(ju) = d(ij)/2 - s(iu)
	
=cut
		
		my %seen  = () ;
		my @tmp   = () ;
		my @TAXA  = () ;
		
		my $ntaxa = keys %$dist_matrix;
		
		push @tmp , (split /\*/ , $_ ) for ( keys %$dist_matrix ) ;
				 
		@TAXA                   = grep { ! $seen{$_}++ } @tmp     ;
		
		my $NTAXA               = @TAXA                           ;
				
		my ( $taxon1, $taxon2 ) = split /\*/, $closest_pair       ;
		
		my ( $brlens_taxon1 , $brlens_taxon2 ) = ( 0 , 0 )        ;
		
		if ( 0 == $NTAXA - 2 ) {
			
			$brlens_taxon1       = ( $$dist_matrix{$taxon1."*".$taxon2} || $$dist_matrix{$taxon2."*".$taxon1} ) / 2 + $$net_div{$taxon1} ;
		
			$brlens_taxon2       = ( $$dist_matrix{$taxon1."*".$taxon2} || $$dist_matrix{$taxon2."*".$taxon1} ) - $brlens_taxon1 
		}
		else {
		
			$brlens_taxon1       = ( $$dist_matrix{$taxon1."*".$taxon2} || $$dist_matrix{$taxon2."*".$taxon1} ) / 2 + ( $$net_div{$taxon1} - $$net_div{$taxon2} ) / (2*( $NTAXA - 2 )) ;
		
			$brlens_taxon2       = ( $$dist_matrix{$taxon1."*".$taxon2} || $$dist_matrix{$taxon2."*".$taxon1} ) - $brlens_taxon1 ;
		}

=pod

Pushes node plus branch length into the node list array and deletes all entries in the original distance matrix (hash) of taxon1 and taxon2
It calculates new entries of the distance matrix by combining the two taxa into one and recalculating distances of this combined taxon (new node) to the remaining taxa using.


=cut
				
		push @node_list , "($taxon1:$brlens_taxon1,$taxon2:$brlens_taxon2)" ; 
		
		
=pod		

Filters both taxa from the list of taxa in the distance matrix.
		
=cut		
		
		my @TAXA_filtered = () ;
		
		for ( @TAXA ) {
			
			push @TAXA_filtered , $_ if ! /\Q$taxon1\E/ || /\Q$taxon2\E/ ;
		}
		
		
=pod		

Replaces distances of taxon1*taxon2 with combined net distances.

	d(kij) = [ d(ik) + d(jk) -d(ij) ] / 2


=cut		
		
		for ( @TAXA_filtered ) {
			
			no warnings ;
			
			$$dist_matrix{$_."*"."($taxon1:$brlens_taxon1,$taxon2:$brlens_taxon2)"} = 
			
				( 
				  ( $$dist_matrix{$_."*".$taxon1}      || $$dist_matrix{$taxon1."*".$_} )      + 
				  ( $$dist_matrix{$_."*".$taxon2}      || $$dist_matrix{$taxon2."*".$_} )      - 
				  ( $$dist_matrix{$taxon1."*".$taxon2} || $$dist_matrix{$taxon2."*".$taxon1} ) 
								  
				) / 2 
								
		} 
						
		
		for ( keys %$dist_matrix ) {
			
			delete $$dist_matrix{$_} if $_ =~ /( \*\Q$taxon1\E$ |
							     \*\Q$taxon2\E$ |
					                      ^\Q$taxon1\E\*|
					                      ^\Q$taxon2\E\*  )/x 
		}		
		


=pod		

End of loop DECOMPOSITION 

=cut	
	
	
	}	
		
	return my $tree = $node_list[-1], @node_list 
		
			
}


sub profiles_svg {


	my ( $file , $ref_Profiles ) = @_             ;

	my $init_line = '<?xml version="1.0" encoding="UTF-8" standalone="no"?>' ;
	my $gen_line  = '<!-- created by matrix_reduction.pl -->'                ;

	open my $fh_matrix_out , ">" , "$file.profiles.svg"                      ;

	my $width  = @{$ref_Profiles->[0]}                                       ;
	my $height = $width/10 ;
	my $y_zero = $height/2 ;

	my $framewidth = $width ;
	my $frameheight= $height;
	my $unit_height= $height/5;
	

print $fh_matrix_out <<FRAME1;
$init_line
$gen_line

<svg
   xmlns:svg="http://www.w3.org/2000/svg"
   xmlns="http://www.w3.org/2000/svg"
   version="1.0"
   width="$framewidth"
   height="$frameheight"
   id="svg2">

  <defs
     id="defs4" />

<line
     x1="0"
     y1="$y_zero"
     x2="$width"
     y2="$y_zero"
     style="stroke: black;stroke-width:1.5;"
     id="line001" />

<line
     x1="0"
     y1="0"
     x2="0"
     y2="$height"
     style="stroke: black;stroke-width:1.5;"
     id="line002" />

<line
     x1="0"
     y1="$y_zero"
     x2="-5"
     y2="$y_zero"
     style="stroke: black;stroke-width:1.5;"
     id="line003" />
     
FRAME1


for (1..5){
	
	$unit_height *= $_;
	print $fh_matrix_out  '<line',"\n",'x1="0" y1="',$y_zero+$unit_height/2,'" x2="-5" y2="',$y_zero+$unit_height/2,'" style="stroke: black;stroke-width:1.5;" id="line004"/>',"\n";
	print $fh_matrix_out  '<line',"\n",'x1="0" y1="',$y_zero-$unit_height/2,'" x2="-5" y2="',$y_zero-$unit_height/2,'" style="stroke: black;stroke-width:1.5;" id="line004"/>',"\n";
	print {$fh_matrix_out}   '<text',"\n",'x="-15" y="',$y_zero-$unit_height/2,'"',' text-anchor="end"',"\n",'style="font-size:12px;font-family:Bitstream Vera Sans"',"\n",'>',$_/5,'</text>',"\n";
	print {$fh_matrix_out}   '<text',"\n",'x="-15" y="',$y_zero+$unit_height/2,'"',' text-anchor="end"',"\n",'style="font-size:12px;font-family:Bitstream Vera Sans"',"\n",'>','-',$_/5,'</text>',"\n";
    $unit_height /= $_;
}


for (my $x=0;$x<$width;$x+=10){
	
	if ($x%100 == 0){
		print $fh_matrix_out  '<line',"\n",'x1="',$x,'" y1="',$y_zero,'" x2="',$x,'" y2="',$y_zero+5,'" style="stroke: black;stroke-width:1.5;" id="line005"/>',"\n";
	}
	else{
		print $fh_matrix_out  '<line',"\n",'x1="',$x,'" y1="',$y_zero,'" x2="',$x,'" y2="',$y_zero+5,'" style="stroke: black;stroke-width:0.5;" id="line005"/>',"\n";
	}
}


my $median = shift @{$ref_Profiles} ;


for my $profile (@{$ref_Profiles}){

	my $profile_line = '' ;

	for (my $x=1,my $y=0;$x<=$width;$x++,$y++){
		$profile_line .= $x.' '.($y_zero-${$profile}[$y]*$height/2).',';
	}
	
	chop $profile_line ; #print $profile_line,"\n";exit;

print $fh_matrix_out <<PROFILE;

<polyline
	points="$profile_line"
	style="stroke:grey;stroke-width:0.25;fill:none"/>

PROFILE

}

my $median_line= '' ;

for (my $x=1,my $y=0;$x<=$width;$x++,$y++){
		$median_line .= $x.' '.($y_zero-${$median}[$y]*$height/2).',';#print ${$median}[$y],"\t",$height/2,"\t",$y_zero,"\t",${$median}[$y]*$height/2,"\t",${$median}[$y]*$height/2+$y_zero,"\n";exit; 
	}
	chop $median_line ; #print $median_line,"\n";exit;

print $fh_matrix_out <<MEDIANLINE;

<polyline
	points="$median_line"
	style="stroke:black;stroke-width:2;fill:none"/>

MEDIANLINE


my $median_line1 = '0'.' '.$y_zero.',' ;
my $median_line2 = '0'.' '.$y_zero.',' ;

for (my $x=1,my $y=0;$x<=$width;$x++,$y++){
	if (${$median}[$y]<= 0){
		$median_line1 .= $x.' '.($y_zero).',' ;
		$median_line2 .= $x.' '.($y_zero-${$median}[$y]*$height/2).',';
	}
	else{
		$median_line1 .= $x.' '.($y_zero-${$median}[$y]*$height/2).',' ;
		$median_line2 .= $x.' '.($y_zero).',' ;
	}
}

$median_line1 .= $width.' '.$y_zero.','.'0'.' '.$y_zero;
$median_line2 .= $width.' '.$y_zero.','.'0'.' '.$y_zero;

print $fh_matrix_out <<MEDIAN;

<polygon
     points="$median_line1"
     style="stroke: none;stroke-width:2;fill:green;fill-opacity:0.3"/>
<polygon
     points="$median_line2"
     style="stroke: none;stroke-width:2;fill:red;fill-opacity:0.3"/>
     
MEDIAN



print $fh_matrix_out <<FINISH;

</svg>


FINISH



}







1;











