# BetterCreator ChatGPT Brainstorming Techniques & Prompts

**Source**: <https://bettercreator.com/chat-gpt-prompts-to-brainstorm-and-find-infinite-new-ideas/>

---

## Overview

BetterCreator documents 20 systematic brainstorming techniques designed to unlock creative potential using ChatGPT and language models. These techniques enable content creators, entrepreneurs, and innovators to move beyond inspiration-dependent workflows toward systematic ideation processes.

---

## 20 Brainstorming Techniques

### 1. Brainwriting

**Description**: Structure ideas in written form, building iteratively on existing concepts before expanding collectively.

**Mechanism**: Write ideas individually, then use ChatGPT to develop, refine, and synthesize them into cohesive concepts.

**Content Creator Application**: Ideal for creating article outlines, content calendars, and campaign themes. Allows writers to capture raw ideas and progressively enhance them into publishable material.

**Prompt Template**:

```
Let's brainstorm ideas for [topic] by writing down as many ideas as you can,
then I can build on them with related ideas.
```

---

### 2. Reverse Brainstorming

**Description**: Intentionally generate flawed, problematic, or undesirable solutions to spark unexpected creative directions.

**Mechanism**: Ask ChatGPT to identify worst-case scenarios or deliberately bad ideas, then invert the solutions to find novel approaches.

**Content Creator Application**: Overcome creative blocks by identifying what NOT to do. Useful for identifying audience pain points and content gaps.

**Prompt Template**:

```
What would be the worst possible [content type] for my [audience]?
Now, invert each problem to identify better solutions.
```

---

### 3. Mind Mapping

**Description**: Create branching visual connections radiating from a central concept, establishing relationships between ideas.

**Mechanism**: Use ChatGPT to generate hierarchical idea structures, progressively expanding from core concept to peripheral applications.

**Content Creator Application**: Plan comprehensive content series, interconnect content themes, and visualize content strategy relationships.

**Prompt Template**:

```
Create a mind map for [topic] with central concept and 5 branching themes,
each with 3-4 sub-ideas.
```

---

### 4. Assumptions Challenge

**Description**: Identify and systematically challenge foundational beliefs underlying a problem or project.

**Mechanism**: List core assumptions, question their validity, and explore implications if each assumption is false.

**Content Creator Application**: Discover untapped audience segments or content angles by questioning basic content industry assumptions.

**Prompt Template**:

```
List the top 5 assumptions I'm making about [content domain].
For each, what if the opposite were true? What opportunities emerge?
```

---

### 5. SWOT Analysis

**Description**: Evaluate internal strengths and weaknesses alongside external opportunities and threats.

**Mechanism**: Systematically assess competitive position within a market or content niche.

**Content Creator Application**: Identify unique positioning, content opportunities, competitive advantages, and vulnerabilities in your niche.

**Prompt Template**:

```
Conduct a SWOT analysis for [content creator role/niche].
Detail strengths, weaknesses, opportunities, and threats specific to my situation.
```

---

### 6. SCAMPER Method

**Description**: Apply seven distinct operations to existing ideas: Substitute, Combine, Adapt, Modify, Put to another use, Eliminate, Reverse.

**Mechanism**: Systematically apply each operation to an existing product, service, or content format to generate variations.

**Content Creator Application**: Transform existing content into multiple formats and repurposing strategies across platforms.

**Prompt Template**:

```
Apply SCAMPER to [existing content/product]:
- Substitute: What could I replace?
- Combine: What could I merge?
- Adapt: What could I adjust?
- Modify: What could I change?
- Put to another use: What new applications exist?
- Eliminate: What could I remove?
- Reverse: What could I flip or rearrange?
```

---

### 7. Six Thinking Hats

**Description**: Approach problems from six distinct psychological perspectives simultaneously, cycling through different thinking modes.

**Mechanism**: Examine a challenge from critical, creative, logical, emotional, intuitive, and organizational viewpoints sequentially.

**Content Creator Application**: Develop well-rounded content addressing multiple audience perspectives and concerns.

**Prompt Template**:

```
Analyze [content topic] using Six Thinking Hats:
- White Hat (Facts): What do we know?
- Red Hat (Emotion): What feelings does this evoke?
- Black Hat (Critical): What could fail?
- Yellow Hat (Positive): What are benefits?
- Green Hat (Creative): What alternatives exist?
- Blue Hat (Process): How do we organize this?
```

---

### 8. Worst Possible Idea

**Description**: Deliberately devise terrible, absurd, or impractical solutions to unlock unconventional creative pathways.

**Mechanism**: Brainstorm intentionally bad ideas, then identify kernels of insight within the worst suggestions.

**Content Creator Application**: Identify surprising angles and unconventional content hooks by exploring deliberately bad content concepts.

**Prompt Template**:

```
What would be the absolute worst [content type] I could create for [audience]?
Generate 5 terrible ideas. Now, find one valuable insight in each terrible idea.
```

---

### 9. Trigger Words (Random Stimuli)

**Description**: Use randomly selected vocabulary, objects, or concepts to spark unexpected associations and connections.

**Mechanism**: Select unrelated words or images and force connections between them and your challenge.

**Content Creator Application**: Discover unexpected content angles, metaphors, and conceptual connections by associating random concepts with your niche.

**Prompt Template**:

```
Here are 5 random words: [word1], [word2], [word3], [word4], [word5]
How could each inspire a content idea about [topic]?
```

---

### 10. Questioning (5 Ws and H)

**Description**: Transform who/what/when/where/why/how inquiries into actionable concepts and insights.

**Mechanism**: Systematically ask foundational questions about a challenge, using answers to identify solution directions.

**Content Creator Application**: Generate comprehensive content outlines by fully exploring question dimensions of your topic.

**Prompt Template**:

```
Generate content ideas by answering these questions about [topic]:
- WHO is affected or interested?
- WHAT are the key components?
- WHEN is this relevant?
- WHERE do these issues occur?
- WHY does it matter?
- HOW can it be addressed?
```

---

### 11. Rolestorming

**Description**: Adopt customer, employee, competitor, or stakeholder perspectives for empathetic ideation.

**Mechanism**: Imagine different personas and generate ideas from their unique viewpoints and constraints.

**Content Creator Application**: Develop audience-centric content by exploring perspectives of different audience segments, competitors, or industry experts.

**Prompt Template**:

```
I'm [specific role/persona - customer, competitor, expert, etc.]
How would I approach [topic]? What content would solve my problems?
```

---

### 12. Scenario Planning

**Description**: Contrast best-case and worst-case outcome planning to identify risks and opportunities.

**Mechanism**: Imagine multiple future scenarios and plan content or strategies for each contingency.

**Content Creator Application**: Create content addressing audience concerns across different scenarios and use cases.

**Prompt Template**:

```
For [topic/product/goal], envision three scenarios:
- Best case: Everything goes right. Content needs?
- Worst case: Everything fails. What content prevents disaster?
- Likely case: Realistic middle ground. What content is essential?
```

---

### 13. Analogy Thinking

**Description**: Identify metaphorical parallels and transfer properties from analogous domains to your challenge.

**Mechanism**: Draw explicit comparisons between your domain and unrelated fields, transferring successful patterns.

**Content Creator Application**: Discover content frameworks by identifying analogies between your niche and successful models in other industries.

**Prompt Template**:

```
[My content niche/challenge] is like [analogous domain/situation] because...
What practices from [analogous domain] could I transfer to create better content about [topic]?
```

---

### 14. Idea Spurring (Building and Expanding)

**Description**: Build iteratively upon existing concepts as launching platforms for deeper exploration.

**Mechanism**: Take one idea and systematically expand it through variations, applications, and combinations.

**Content Creator Application**: Transform single content insights into comprehensive content series and campaigns.

**Prompt Template**:

```
Starting with this idea: [initial concept]
Generate 5 expanded variations:
1. A deeper exploration
2. An opposite approach
3. A niche application
4. A broader framework
5. A hybrid combination with [related concept]
```

---

### 15. Concept Fan

**Description**: Branch outward from a single idea in multiple directions, exploring diverse applications and permutations.

**Mechanism**: Identify core concept and systematically explore all possible branches, extensions, and variations.

**Content Creator Application**: Generate content series by systematically expanding one core concept across multiple angles.

**Prompt Template**:

```
Core concept: [single idea about topic]
Generate 5 branches:
1. [Different audience application]
2. [Different platform application]
3. [Different problem it solves]
4. [Historical or comparative angle]
5. [Future or predictive angle]
```

---

### 16. Evil Genius (Antagonistic Reversal)

**Description**: Reverse-engineer antagonistic or sabotaging strategies, then convert them into constructive improvements.

**Mechanism**: Imagine how a competitor or adversary would undermine your goal, then flip strategies to strengthen it.

**Content Creator Application**: Identify content vulnerabilities and competitive gaps by understanding how competitors could outmaneuver you.

**Prompt Template**:

```
If I were trying to make my [content/product/goal] fail, I would [describe sabotage strategy].
Now flip this: How can I use these insights to strengthen my actual approach?
```

---

### 17. Random Stimuli (Objects, Images, Quotes)

**Description**: Connect unrelated objects, quotes, images, or concepts to topic exploration, forcing unexpected combinations.

**Mechanism**: Select random external input and force logical or metaphorical connections to your challenge.

**Content Creator Application**: Discover unconventional content angles by connecting random stimuli to your niche.

**Prompt Template**:

```
Here's a random stimulus: [image, object, quote, or concept]
How could this inspire a content idea about [topic]?
Look for unexpected connections and metaphors.
```

---

### 18. Headline Writing (Distillation and Expansion)

**Description**: Distill complex concepts into compelling slogans, then systematically expand slogans into full ideas.

**Mechanism**: Compress concepts into headlines, then use headlines as seeds for expanded exploration.

**Content Creator Application**: Generate punchy content titles and hooks that expand into comprehensive articles or campaigns.

**Prompt Template**:

```
Create 10 compelling headlines about [topic].
For each headline, expand into:
- A one-paragraph summary
- 3 key sub-topics
- One unique angle the headline captures
```

---

### 19. Brainstorming Journey (Narrative Scenarios)

**Description**: Narrate fictional scenarios or customer journeys to catalyze emerging insights and identify content needs.

**Mechanism**: Create detailed narrative scenarios of user experiences, identifying pain points and opportunities within the story.

**Content Creator Application**: Develop content addressing real customer journey stages and decision points by mapping narrative scenarios.

**Prompt Template**:

```
Imagine a customer journey for someone dealing with [problem/goal]:
- Beginning: What's their starting point?
- Middle: What obstacles do they face?
- End: What's the ideal outcome?

For each journey stage, what content would help them progress?
```

---

### 20. Outside Perspectives

**Description**: Integrate diverse viewpoints from different industries, disciplines, cultures, and expertise areas for comprehensive analysis.

**Mechanism**: Seek input or simulate perspectives from people outside your primary domain.

**Content Creator Application**: Develop multi-faceted content by incorporating perspectives from complementary industries and disciplines.

**Prompt Template**:

```
Bring in different viewpoints to ideate on [topic] and get new perspectives.
- [Industry expert]: How would you approach this?
- [Customer perspective]: What's your main concern?
- [Competitor perspective]: What's your strategy?
- [Adjacent industry]: How does this apply in your field?

Develop these different viewpoints, explaining why each is relevant.
```

---

## Practical Applications for Content Creators

### Content Development

These 20 techniques enable content creators to:

- Move beyond inspiration-dependent workflows toward systematic ideation
- Generate comprehensive content outlines and series plans
- Identify audience pain points and content gaps
- Develop multi-platform content strategies
- Create content addressing diverse audience perspectives

### Creative Problem-Solving

When facing creative blocks, specific techniques prove effective:

- Reverse Brainstorming and Worst Possible Idea (identify what to avoid)
- Trigger Words and Random Stimuli (force unexpected connections)
- Rolestorming (explore customer-centric perspectives)
- SCAMPER (repurpose existing successful formats)

### Audience Engagement

Techniques supporting audience connection and retention:

- Scenario Planning (address audience concerns across contexts)
- Brainstorming Journey (develop content addressing journey stages)
- Outside Perspectives (incorporate diverse viewpoints)
- Six Thinking Hats (develop emotionally and logically resonant content)

### Strategic Planning

For content strategy and business alignment:

- SWOT Analysis (identify positioning and competitive advantage)
- Analogy Thinking (transfer successful models from other industries)
- Concept Fan (systematically explore niche variations)
- Mind Mapping (visualize content ecosystem and relationships)

---

## Implementation Guidelines

### Selecting the Right Technique

**For generating quantity**: Brainwriting, Trigger Words, Worst Possible Idea, Concept Fan **For generating quality**: SWOT Analysis, Six Thinking Hats, Analogy Thinking, Outside Perspectives **For solving blocks**: Reverse Brainstorming, Evil Genius, Random Stimuli **For strategic thinking**: SCAMPER, Scenario Planning, Brainstorming Journey

### Combining Techniques

Multiple techniques can be sequenced for deeper exploration:

1. Start with Brainwriting to capture raw ideas
2. Apply SCAMPER to generate format variations
3. Use Rolestorming to evaluate audience fit
4. Employ Six Thinking Hats to assess comprehensively
5. Document using Mind Mapping for systematic organization

### Providing Context to ChatGPT

BetterCreator emphasizes that ChatGPT performs better when you provide:

- Specific context about your challenge or topic
- Target audience details and constraints
- Desired outcome or end goal
- Format preferences and platform considerations
- Any relevant background information

This context narrows possibilities and enables more relevant, actionable results.

---

## Key Principles

From BetterCreator's approach:

1. **Systematic Over Spontaneous**: Techniques replace "waiting for inspiration" with repeatable processes
2. **Iterative Development**: Each technique builds depth through progressive refinement
3. **Perspective Multiplicity**: Viewing challenges from different angles yields more comprehensive solutions
4. **Constraint-Based Creativity**: Specific constraints (SCAMPER operations, hat perspectives) unlock creative thinking
5. **Context Matters**: Providing complete context to ChatGPT significantly improves output relevance

---

## See Also

- SCAMPER Method for content format innovation
- Six Thinking Hats for stakeholder-inclusive decision making
- Mind Mapping for visual content organization
- SWOT Analysis for competitive positioning
