# Journal-Specific Figure Requirements

## Overview

Different journals have specific technical requirements for figures. This reference compiles common requirements from major scientific publishers. **Always check the specific journal's author guidelines for the most current requirements.**

## Nature Portfolio (Nature, Nature Methods, etc.)

### Technical Specifications
- **File formats**:
  - Vector: PDF, EPS, AI (preferred for graphs)
  - Raster: TIFF, PNG (for images)
  - Never: PowerPoint, Word, JPEG

- **Resolution**:
  - Line art: 1000-1200 DPI
  - Combination (line art + images): 600 DPI
  - Photographs/microscopy: 300 DPI minimum

- **Color space**: RGB (Nature is digital-first)

- **Dimensions**:
  - Single column: 89 mm (3.5 inches)
  - 1.5 column: 120 mm (4.7 inches)
  - Double column: 183 mm (7.2 inches)
  - Maximum height: 247 mm (9.7 inches)

- **Fonts**:
  - Arial or Helvetica (or similar sans-serif)
  - Minimum 5-7 pt at final size
  - Embed all fonts in PDF/EPS

### Nature Specific Guidelines
- Panel labels: a, b, c (lowercase, bold) in top-left corner
- Scale bars required for microscopy images
- Gel images: Include molecular weight markers
- Cropping: Indicate with line breaks
- Statistics: Mark significance; define symbols in legend
- Source data: Required for all graphs

### File Naming
Format: `FirstAuthorLastName_FigureNumber.ext`
Example: `Smith_Fig1.pdf`

## Science (AAAS)

### Technical Specifications
- **File formats**:
  - Vector: EPS, PDF (preferred)
  - Raster: TIFF
  - Acceptable: AI, PSD (Photoshop)

- **Resolution**:
  - Line art: 1000 DPI minimum
  - Photographs: 300 DPI minimum
  - Combination: 600 DPI minimum

- **Color space**: RGB

- **Dimensions**:
  - Single column: 5.5 cm (2.17 inches)
  - 1.5 column: 12 cm (4.72 inches)
  - Full width: 17.5 cm (6.89 inches)
  - Maximum height: 23.3 cm (9.17 inches)

- **Fonts**:
  - Helvetica (or Arial)
  - 6-8 pt minimum at final size
  - Consistent across all figures

### Science Specific Guidelines
- Panel labels: (A), (B), (C) in parentheses
- Minimal text within figures (details in caption)
- High contrast for web and print
- Error bars required; define in caption
- Avoid excessive whitespace

### File Naming
Format: `Manuscript#_Fig#.ext`
Example: `abn1234_Fig1.eps`

## Cell Press (Cell, Neuron, Molecular Cell, etc.)

### Technical Specifications
- **File formats**:
  - Vector: PDF, EPS (preferred for graphs/diagrams)
  - Raster: TIFF (for photographs)

- **Resolution**:
  - Line art: 1000 DPI
  - Photographs: 300 DPI
  - Combination: 600 DPI

- **Color space**: RGB

- **Dimensions**:
  - Single column: 85 mm (3.35 inches)
  - Double column: 178 mm (7.01 inches)
  - Maximum height: 230 mm (9.06 inches)

- **Fonts**:
  - Arial or Helvetica only
  - 8-12 pt for axis labels
  - 6-8 pt for tick labels

### Cell Press Specific Guidelines
- Panel labels: (A), (B), (C) or A, B, C in top-left
- Related panels should match in size
- Scale bars mandatory for microscopy
- Western blots: Include molecular weight markers
- Arrows/arrowheads: 2 pt minimum width
- Line widths: 1-2 pt for data

## PLOS (Public Library of Science)

### Technical Specifications
- **File formats**:
  - Vector: EPS, PDF (preferred)
  - Raster: TIFF, PNG
  - TIFF with LZW compression acceptable

- **Resolution**:
  - Minimum 300 DPI at final size (all figure types)
  - 600 DPI preferred for line art

- **Color space**: RGB

- **Dimensions**:
  - Single column: 8.3 cm (3.27 inches)
  - 1.5 column: 11.4 cm (4.49 inches)
  - Double column: 17.3 cm (6.81 inches)
  - Maximum height: 23.3 cm (9.17 inches)

- **Fonts**:
  - Sans-serif preferred (Arial, Helvetica)
  - 8-12 pt for labels at final size

### PLOS Specific Guidelines
- Figures should be understandable without caption
- Color required only if adding information
- All figures convertible to grayscale
- Panel labels optional but recommended
- Open access: Figures must be CC-BY licensed
- Source data files encouraged

## ACS (American Chemical Society)

### Technical Specifications
- **File formats**:
  - Preferred: TIFF, PDF, EPS
  - Application files: AI, CDX (ChemDraw), CDL
  - Acceptable: PNG (not for publication)

- **Resolution**:
  - Minimum 300 DPI at final size
  - 600 DPI for line art and chemical structures
  - 1200 DPI for detailed structures

- **Color space**: RGB or CMYK (check specific journal)

- **Dimensions**:
  - Single column: 3.25 inches (8.25 cm)
  - Double column: 7 inches (17.78 cm)

- **Fonts**:
  - Embedded fonts required
  - Consistent sizing across figures

### ACS Specific Guidelines
- Chemical structures: Use ChemDraw or equivalent
- Atom labels: 10-12 pt
- Bond thickness: 2 pt
- Panel labels: Lowercase bold (a, b, c)
- High contrast required (many ACS journals grayscale print)

## Elsevier Journals (varies by journal)

### Technical Specifications
- **File formats**:
  - Vector: EPS, PDF
  - Raster: TIFF, JPEG (only for photographs)

- **Resolution**:
  - Line art: 1000 DPI minimum
  - Photographs: 300 DPI minimum
  - Combination: 600 DPI minimum

- **Color space**: RGB (for online); CMYK (for print journals)

- **Dimensions**: Vary by journal
  - Common single column: 90 mm
  - Common double column: 190 mm

- **Fonts**:
  - Preferred: Arial, Times, Symbol
  - Minimum 6 pt at final size

### Elsevier Specific Guidelines
- Check individual journal guidelines (highly variable)
- Some journals charge for color in print
- Panel labels typically (A), (B), (C) or A, B, C
- Graphical abstract often required (separate from figures)

## IEEE (Engineering/Computer Science)

### Technical Specifications
- **File formats**:
  - Vector: PDF, EPS (preferred)
  - Raster: TIFF, PNG

- **Resolution**:
  - Photographs/graphics: 300 DPI minimum at final size
  - Line art: 600 DPI minimum

- **Color space**: RGB (online); CMYK (print)

- **Dimensions**:
  - Single column: 3.5 inches (8.9 cm)
  - Double column: 7.16 inches (18.2 cm)

- **Fonts**:
  - Sans-serif preferred
  - Minimum 8-10 pt at final size

### IEEE Specific Guidelines
- Figures should be readable in black and white
- Color figures incur no charge (online publication)
- Panel labels: (a), (b), (c) in lowercase
- Captions below figures (not on separate page)
- Use IEEE graphics checker tool before submission

## BMC (BioMed Central) - Open Access

### Technical Specifications
- **File formats**:
  - Any standard format accepted
  - Preferred: TIFF, PDF, EPS, PNG

- **Resolution**:
  - Minimum 600 DPI for line art
  - Minimum 300 DPI for photographs

- **Color space**: RGB

- **Dimensions**:
  - Flexible, but consider readability
  - Maximum width typically 140 mm

- **Fonts**:
  - Embedded and readable

### BMC Specific Guidelines
- Open access: CC-BY license required
- Figure files uploaded separately
- Panel labels as appropriate for field
- Source data encouraged
- Accessibility important (colorblind-friendly)

## Common Requirements Across Journals

### Universal Best Practices
1. **Never use JPEG for graphs/plots**: Compression artifacts
2. **Embed all fonts**: In PDF/EPS files
3. **Layer structure**: Flatten images (merge layers in Photoshop)
4. **RGB vs CMYK**: Most journals now RGB (digital-first)
5. **High resolution**: Always better to start high, reduce if needed
6. **Consistency**: Same style across all figures in manuscript
7. **File size**: Balance quality with reasonable file sizes (typically <10 MB per figure)

### Submitting Figures
- **Initial submission**: Lower resolution often acceptable (for review)
- **Revision/acceptance**: High-resolution required
- **Separate files**: Each figure as separate file
- **File naming**: Clear, systematic naming
- **Supporting information**: May have different requirements

## Quick Reference Table

| Publisher | Single Column | Double Column | Min DPI (photos) | Min DPI (line art) | Preferred Format |
|-----------|---------------|---------------|------------------|-------------------|------------------|
| Nature | 89 mm | 183 mm | 300 | 1000 | EPS, PDF |
| Science | 5.5 cm | 17.5 cm | 300 | 1000 | EPS, PDF |
| Cell Press | 85 mm | 178 mm | 300 | 1000 | EPS, PDF |
| PLOS | 8.3 cm | 17.3 cm | 300 | 600 | EPS, TIFF |
| ACS | 3.25 in | 7 in | 300 | 600 | TIFF, EPS |

## Checking Requirements

### Before Submission Checklist
1. Read journal's author guidelines (figure section)
2. Check file format requirements
3. Verify resolution requirements
4. Confirm size specifications (width × height)
5. Check font requirements
6. Verify color space (RGB vs CMYK)
7. Check panel labeling style
8. Review supplementary materials requirements
9. Confirm file naming conventions
10. Check file size limits

### Useful Tools
- **ImageJ/Fiji**: Check/adjust DPI
- **Adobe Acrobat**: Verify embedded fonts, check PDF properties
- **GIMP**: Free alternative to Photoshop for raster editing
- **Inkscape**: Free vector graphics editor

## Resources

- **Journal websites**: Always check "Author Guidelines" or "Instructions for Authors"
- **Publisher resources**: Many provide templates and tools
- **Format conversion**: Use reputable tools; check output quality
- **Help desks**: Contact journal staff if unclear

## Notes

- Requirements change periodically - always verify current guidelines
- Preprint servers (bioRxiv, arXiv) often have different requirements
- Conference proceedings may have separate requirements
- Some journals offer figure preparation services (often paid)
- Supplementary figures may have relaxed requirements compared to main text figures
