# Medical Journal Structured Abstract Examples

Examples of structured abstracts for NEJM, Lancet, JAMA, and BMJ showing the labeled section format expected at medical journals.

---

## NEJM Style (250 words max)

### Example 1: Clinical Trial

```
BACKGROUND
Sodium-glucose cotransporter 2 (SGLT2) inhibitors reduce cardiovascular 
events in patients with type 2 diabetes and established cardiovascular 
disease. Whether these benefits extend to patients with heart failure and 
reduced ejection fraction, regardless of diabetes status, is unknown.

METHODS
We randomly assigned 4,744 patients with heart failure and an ejection 
fraction of 40% or less to receive dapagliflozin (10 mg once daily) or 
placebo, in addition to recommended therapy. The primary outcome was a 
composite of worsening heart failure (hospitalization or urgent visit 
requiring intravenous therapy) or cardiovascular death.

RESULTS
Over a median of 18.2 months, the primary outcome occurred in 386 of 
2,373 patients (16.3%) in the dapagliflozin group and in 502 of 2,371 
patients (21.2%) in the placebo group (hazard ratio, 0.74; 95% confidence 
interval [CI], 0.65 to 0.85; P<0.001). A first worsening heart failure 
event occurred in 237 patients (10.0%) in the dapagliflozin group and 
in 326 patients (13.7%) in the placebo group (hazard ratio, 0.70; 95% 
CI, 0.59 to 0.83). Death from cardiovascular causes occurred in 227 
patients (9.6%) and 273 patients (11.5%), respectively (hazard ratio, 
0.82; 95% CI, 0.69 to 0.98). Effects were similar in patients with and 
without diabetes. Serious adverse events were similar between groups.

CONCLUSIONS
Among patients with heart failure and a reduced ejection fraction, 
dapagliflozin reduced the risk of worsening heart failure or 
cardiovascular death, regardless of the presence of diabetes.
```

**Key Features**:
- Four labeled sections (BACKGROUND, METHODS, RESULTS, CONCLUSIONS)
- Background: 2 sentences (problem + gap)
- Methods: Study design, population, intervention, primary outcome
- Results: Primary outcome with HR and 95% CI, key secondary outcomes
- Conclusions: Clear, measured statement of findings

---

### Example 2: Observational Study

```
BACKGROUND
Long-term use of proton-pump inhibitors (PPIs) has been associated with 
adverse outcomes in observational studies, but causality remains uncertain. 
The relationship between PPI use and chronic kidney disease is unclear.

METHODS
We conducted a prospective cohort study using data from 10,482 participants 
in the Atherosclerosis Risk in Communities study who were free of kidney 
disease at baseline. PPI use was ascertained at baseline and follow-up 
visits. The primary outcome was incident chronic kidney disease, defined 
as an estimated glomerular filtration rate less than 60 ml per minute per 
1.73 m² of body-surface area.

RESULTS
Over a median follow-up of 13.9 years, incident chronic kidney disease 
occurred in 56.0 per 1000 person-years among PPI users and in 42.0 per 
1000 person-years among non-users (adjusted hazard ratio, 1.50; 95% 
confidence interval [CI], 1.14 to 1.96). The association persisted after 
adjustment for potential confounders, including indication for PPI use 
and baseline kidney function. Sensitivity analyses using propensity-score 
matching yielded similar results. No association was observed for 
histamine H2-receptor antagonist use (hazard ratio, 1.08; 95% CI, 0.87 
to 1.34).

CONCLUSIONS
PPI use was associated with an increased risk of incident chronic kidney 
disease in this community-based cohort. These findings warrant cautious 
use of PPIs and further investigation to establish causality.
```

**Key Features**:
- Appropriate hedging for observational study ("associated with")
- Incidence rates provided (per 1000 person-years)
- Sensitivity analyses mentioned
- Negative control (H2-receptor antagonists)
- Cautious conclusion acknowledging limitation

---

## Lancet Style (300 words max)

### Example 3: Clinical Trial with Summary Box

```
BACKGROUND
Dexamethasone has been shown to reduce mortality in hospitalized patients 
with COVID-19 requiring respiratory support. We aimed to evaluate whether 
higher doses of corticosteroids would provide additional benefit in 
patients with severe COVID-19 pneumonia.

METHODS
In this randomized, controlled, open-label trial conducted at 18 hospitals 
in Brazil, we assigned patients with moderate-to-severe COVID-19 (PaO2/FiO2 
≤200 mm Hg) to receive high-dose dexamethasone (20 mg once daily for 5 
days, then 10 mg once daily for 5 days) or standard dexamethasone (6 mg 
once daily for 10 days). The primary outcome was ventilator-free days 
at 28 days.

FINDINGS
Between June 17, 2020, and September 20, 2021, we enrolled 299 patients 
(151 assigned to high-dose dexamethasone and 148 to standard 
dexamethasone). The mean number of ventilator-free days at 28 days was 
14·2 (SD 10·8) in the high-dose group and 15·5 (SD 10·4) in the standard 
group (difference, −1·3 days; 95% CI, −3·9 to 1·3; P=0·32). There was 
no significant difference in 28-day mortality (high dose 35·8% vs 
standard 31·8%; hazard ratio 1·16; 95% CI, 0·79 to 1·70). Hyperglycemia 
requiring insulin was more frequent with high-dose dexamethasone (66·0% 
vs 53·4%; P=0·027).

INTERPRETATION
In patients with moderate-to-severe COVID-19 pneumonia, high-dose 
dexamethasone did not improve ventilator-free days and was associated 
with increased hyperglycemia compared with standard-dose dexamethasone. 
These findings do not support the use of high-dose corticosteroids in 
COVID-19.

FUNDING
Ministry of Health of Brazil.
```

**Key Features**:
- Lancet uses "Findings" instead of "Results"
- Lancet uses "Interpretation" instead of "Conclusions"
- Includes funding statement in abstract
- Decimal point (·) instead of period in numbers (Lancet style)

---

## JAMA Style (350 words max)

### Example 4: Diagnostic Study

```
IMPORTANCE
Lung cancer screening with low-dose computed tomography (CT) reduces 
mortality but identifies many indeterminate pulmonary nodules, leading 
to unnecessary invasive procedures. Improved risk prediction could 
reduce harms while preserving benefits.

OBJECTIVE
To develop and validate a deep learning model for predicting malignancy 
risk of lung nodules detected on screening CT.

DESIGN, SETTING, AND PARTICIPANTS
This retrospective cohort study included 14,851 participants with 
lung nodules from the National Lung Screening Trial (NLST) for model 
development and 5,402 participants from an independent multi-site 
validation cohort (2016-2019). Data analysis was performed from 
January to November 2022.

EXPOSURES
Deep learning model prediction of malignancy risk based on CT imaging.

MAIN OUTCOMES AND MEASURES
The primary outcome was lung cancer diagnosis within 2 years. Model 
performance was assessed by area under the receiver operating 
characteristic curve (AUC), sensitivity, specificity, and comparison 
with radiologist assessments.

RESULTS
In the validation cohort (median age, 65 years; 57% male), 312 nodules 
(5.8%) were diagnosed as lung cancer within 2 years. The deep learning 
model achieved an AUC of 0.94 (95% CI, 0.92-0.96), compared with 0.85 
(95% CI, 0.82-0.88) for the Lung-RADS categorization used by radiologists 
(P<0.001). At 95% sensitivity, the model achieved 68% specificity compared 
with 38% for Lung-RADS, corresponding to a 49% reduction in false-positive 
nodules requiring follow-up. The model's performance was consistent across 
subgroups defined by nodule size, location, and patient demographics.

CONCLUSIONS AND RELEVANCE
A deep learning model for lung nodule malignancy prediction outperformed 
current clinical standards and could substantially reduce false-positive 
findings in lung cancer screening, decreasing unnecessary surveillance 
and invasive procedures.
```

**Key Features**:
- JAMA-specific sections (IMPORTANCE, OBJECTIVE, DESIGN...)
- "Importance" section required (2-3 sentences on why this matters)
- Detailed design section
- "Exposures" clearly stated
- "Main Outcomes and Measures" explicit

---

## BMJ Style (300 words max)

### Example 5: Cohort Study

```
OBJECTIVE
To examine the association between statin use and risk of Parkinson's 
disease in a large population-based cohort.

DESIGN
Prospective cohort study.

SETTING
UK Biobank, 2006-2021.

PARTICIPANTS
402,251 adults aged 40-69 years without Parkinson's disease at baseline.

MAIN OUTCOME MEASURES
Incident Parkinson's disease identified through hospital admissions, 
primary care records, and death certificates. Hazard ratios were 
estimated using Cox regression, adjusted for age, sex, education, 
smoking, alcohol, physical activity, body mass index, and comorbidities.

RESULTS
Over a median follow-up of 12.3 years, 2,841 participants developed 
Parkinson's disease (incidence rate 5.7 per 10,000 person-years). 
Statin use at baseline was not associated with incident Parkinson's 
disease (adjusted hazard ratio 0.95, 95% confidence interval 0.87 to 
1.04). Results were consistent across analyses stratified by statin 
type (lipophilic vs hydrophilic), dose, and duration of use, and in 
sensitivity analyses accounting for reverse causation. No protective 
association was observed in analyses restricted to participants with 
high cardiovascular risk or in propensity-score matched cohorts.

CONCLUSIONS
In this large prospective cohort, statin use was not associated with 
reduced risk of Parkinson's disease, contrary to findings from some 
previous observational studies. The null findings were robust across 
multiple sensitivity analyses. These results do not support a 
neuroprotective effect of statins against Parkinson's disease.

WHAT IS ALREADY KNOWN ON THIS TOPIC
Previous observational studies have yielded inconsistent results 
regarding statin use and Parkinson's disease risk.

WHAT THIS STUDY ADDS
This large prospective study with long follow-up found no evidence 
that statin use protects against Parkinson's disease.
```

**Key Features**:
- BMJ uses abbreviated section headers
- Includes "What is already known" and "What this study adds" boxes
- Design, Setting, and Participants as separate sections
- Clear Main Outcome Measures section

---

## Key Differences Between Journals

| Element | NEJM | Lancet | JAMA | BMJ |
|---------|------|--------|------|-----|
| **Word limit** | 250 | 300 | 350 | 300 |
| **Results label** | RESULTS | FINDINGS | RESULTS | RESULTS |
| **Conclusions label** | CONCLUSIONS | INTERPRETATION | CONCLUSIONS AND RELEVANCE | CONCLUSIONS |
| **Unique sections** | — | Funding in abstract | IMPORTANCE | What is known/adds |
| **Decimal style** | Period (.) | Centered dot (·) | Period (.) | Period (.) |

---

## Essential Elements for All Medical Abstracts

### Background/Context
- Disease burden or clinical problem (1 sentence)
- Knowledge gap or rationale for study (1 sentence)

### Methods
- Study design (RCT, cohort, case-control)
- Setting (number of sites, country/region)
- Participants (N, key inclusion criteria)
- Intervention or exposure
- Primary outcome with definition

### Results
- Number enrolled and analyzed
- Primary outcome with effect size and 95% CI
- Key secondary outcomes
- P-values for primary comparisons
- Adverse events (if applicable)

### Conclusions
- Clear statement of main finding
- Appropriate hedging based on study design
- Clinical implication (optional, 1 sentence)

---

## Common Mistakes in Medical Abstracts

❌ **Missing confidence intervals**: "HR 0.75, P=0.02" → include 95% CI
❌ **Relative risk only**: Add absolute risk reduction, NNT
❌ **Causal language for observational studies**: "PPIs cause kidney disease"
❌ **Overstated conclusions**: Claims exceeding evidence
❌ **Missing sample sizes**: Always include N for each group
❌ **Vague outcomes**: "Improved outcomes" without specific definition

---

## See Also

- `medical_journal_styles.md` - Comprehensive medical writing guide
- `venue_writing_styles.md` - Style comparison across venues

