# Research Poster Guidelines

Comprehensive guidelines for creating effective academic research posters including sizing, layout, typography, and design best practices.

**Last Updated**: 2024

---

## Standard Poster Sizes

### International Sizes (ISO 216)

| Size | Dimensions (mm) | Dimensions (inches) | Common Use |
|------|----------------|---------------------|------------|
| **A0** | 841 × 1189 | 33.1 × 46.8 | Most common international standard |
| **A1** | 594 × 841 | 23.4 × 33.1 | Smaller conferences, travel-friendly |
| **A2** | 420 × 594 | 16.5 × 23.4 | Mini posters, small venues |

### US Sizes

| Size | Dimensions (inches) | Dimensions (mm) | Common Use |
|------|-------------------|-----------------|------------|
| **36" × 48"** | 36 × 48 | 914 × 1219 | Common US conference size (portrait) |
| **42" × 56"** | 42 × 56 | 1067 × 1422 | Large format US posters |
| **48" × 36"** | 48 × 36 | 1219 × 914 | Landscape orientation |
| **48" × 96"** | 48 × 96 | 1219 × 2438 | Extra-wide format |

### Other Common Sizes

| Size | Dimensions | Notes |
|------|-----------|-------|
| **90 cm × 120 cm** | 900 × 1200 mm / 35.4 × 47.2 in | Common in Europe |
| **40" × 30"** | 1016 × 762 mm | Landscape format |
| **3 ft × 4 ft** | 914 × 1219 mm / 36 × 48 in | Same as 36×48 |

### Orientation

- **Portrait**: Most common (height > width)
  - Better for long visual flows (top to bottom)
  - Examples: A0, 36"×48"
- **Landscape**: Less common but sometimes preferred
  - Better for wide content, timelines
  - Examples: 48"×36", 40"×30"

**Always verify**: Check conference specifications before designing!

---

## Typography and Font Sizes

### Recommended Font Sizes by Distance

Posters are viewed from 3-6 feet (1-2 meters) away:

| Element | Size Range | Recommended |
|---------|-----------|-------------|
| **Title** | 60-85 pt | 72-85 pt |
| **Author Names** | 48-60 pt | 54 pt |
| **Affiliations** | 32-40 pt | 36 pt |
| **Section Headers** | 36-48 pt | 42 pt |
| **Body Text** | 24-32 pt | 28 pt |
| **Figure Captions** | 20-24 pt | 22 pt |
| **References** | 18-22 pt | 20 pt |

### Font Families

**Sans-Serif (Recommended for Posters)**:
- Arial
- Helvetica
- Calibri
- Futura
- Gill Sans
- **Why**: Clean, readable at distance

**Serif (Use Sparingly)**:
- Times New Roman
- Georgia
- Palatino
- **When**: Body text if preferred, but sans-serif better for headers

**Monospace**:
- Courier New
- Consolas
- **When**: Code snippets only

### Typography Best Practices

1. **Limit fonts**: Use 1-2 font families maximum
2. **Hierarchy**: Establish clear size hierarchy
3. **Weight**: Use bold for emphasis, not italics
4. **Alignment**: Left-align body text, center title
5. **Spacing**: Generous line spacing (1.2-1.5)
6. **Consistency**: Same fonts for similar elements

---

## Layout and Design Principles

### Grid-Based Layouts

**Column Structures**:

| Layout | Columns | Best For |
|--------|---------|----------|
| **Single Column** | 1 | Simple, linear flow; timeline posters |
| **Two Column** | 2 | Most common; balanced layout |
| **Three Column** | 3 | Dense content; multi-part studies |
| **Four Column** | 4 | Very dense; avoid if possible |

**Recommended**: **2 or 3 columns** for most research posters

### Visual Flow

**Reading Order** (Western conventions):
1. Top to bottom
2. Left to right
3. Z-pattern or F-pattern

**Section Ordering** (typical):
```
+----------------------------------+
|            TITLE                 |
|     Authors, Affiliations        |
+----------------------------------+
| Introduction | Results           |
|              |                   |
| Methods      | Discussion        |
|              |                   |
| [Optional]   | Conclusions       |
+----------------------------------+
|         References / QR Code     |
+----------------------------------+
```

### Spacing and Margins

- **Outer margins**: 1-2 inches (2.5-5 cm) all sides
- **Column spacing**: 0.5-1 inch (1.3-2.5 cm)
- **Inter-section spacing**: 0.5-1 inch
- **White space**: 30-40% of poster should be white space

**Avoid**: Dense, text-heavy layouts with minimal white space

---

## Color Schemes

### Colorblind-Safe Palettes

Use colorblind-friendly color combinations:

**Okabe-Ito Palette** (Recommended):
- Orange: `#E69F00`
- Sky Blue: `#56B4E9`
- Bluish Green: `#009E73`
- Yellow: `#F0E442`
- Blue: `#0072B2`
- Vermillion: `#D55E00`
- Reddish Purple: `#CC79A7`
- Black: `#000000`
- Gray: `#999999`

**Viridis Palette** (sequential):
- Good for heatmaps and gradients
- Colorblind-safe and perceptually uniform

### Color Usage Guidelines

**Background**:
- **White or light gray**: Most common, professional
- **Light colored**: Pale blue, beige (use cautiously)
- **Avoid dark backgrounds**: Harder to read, expensive to print

**Text**:
- **Dark on light**: Black or dark gray text on white/light backgrounds
- **Contrast ratio**: At least 4.5:1 (WCAG AA standard)

**Accent Colors**:
- Use 2-3 accent colors maximum
- Section headers, key findings
- Consistent throughout poster

**Figures**:
- Colorblind-safe palettes
- Sufficient contrast
- Test in grayscale

### Color Contrast Tools
- WebAIM Contrast Checker: https://webaim.org/resources/contrastchecker/
- Coblis (Color Blindness Simulator): https://www.color-blindness.com/coblis-color-blindness-simulator/

---

## Content Structure

### Essential Sections

#### 1. Title Section
- **Title**: Clear, specific, engaging
- **Authors**: Names (underline presenting author)
- **Affiliations**: Institutions, departments
- **Logo**: Institutional logo (corner)
- **Contact**: Email, QR code to paper/website

#### 2. Introduction/Background
- **Purpose**: Context and motivation
- **Length**: 100-200 words
- **Include**: 
  - Problem statement
  - Research gap
  - Objectives/hypothesis

#### 3. Methods
- **Purpose**: How you did the study
- **Format**: 
  - Bullet points preferred
  - Flow diagram if complex
  - Key parameters
- **Include**: Sample size, procedures, analysis

#### 4. Results
- **Purpose**: What you found
- **Format**: Primarily visual (figures, tables, charts)
- **Include**:
  - Key findings (2-4 main results)
  - Statistical significance
  - Visual evidence

#### 5. Discussion/Conclusions
- **Purpose**: What it means
- **Length**: 100-200 words
- **Include**:
  - Interpretation
  - Implications
  - Limitations
  - Future work

#### 6. References
- **Format**: Small font, abbreviated citations
- **Include**: Key citations only (5-10)
- **Style**: Any consistent style

### Optional Sections
- **Abstract**: Sometimes included, often omitted
- **Acknowledgments**: Funding, collaborators
- **Future Work**: Next steps

---

## Visual Elements

### Figures and Plots

**Principles**:
1. **Simplify**: Remove clutter, emphasize key points
2. **Enlarge**: Make larger than in paper
3. **Label clearly**: Large axis labels, legends
4. **Standalone**: Each figure tells a complete story
5. **High resolution**: 300 dpi minimum

**Figure Types**:
- **Photographs**: High quality, cropped appropriately
- **Graphs**: Bar charts, line plots, scatter plots
- **Heatmaps**: Use colorblind-safe colormaps
- **Schematics**: Diagrams, flowcharts
- **Tables**: Simple tables (complex tables → figure)

### Tables

**When to Use**:
- Precise numerical values needed
- Comparisons across conditions
- Summary statistics

**Best Practices**:
- **Keep simple**: 3-5 columns, 5-10 rows maximum
- **Large fonts**: Same size as body text
- **Clear headers**: Bold column/row headers
- **Alternating rows**: Light shading for readability
- **Minimal lines**: Horizontal lines only (no vertical)

### Icons and Graphics

**Use**:
- Icons for visual interest (methods, concepts)
- Simple graphics to break text
- Arrows to guide flow

**Sources**:
- Noun Project: https://thenounproject.com/
- BioRender: https://biorender.com/ (scientific illustrations)
- Font Awesome: https://fontawesome.com/ (icons)

**Caution**: Don't overuse; maintain professionalism

---

## LaTeX Poster Packages

### beamerposter

**Description**: Extension of Beamer for posters  
**Best For**: Academic conferences, classic layout  
**Pros**: 
- Familiar to Beamer users
- Clean, professional appearance
- Many themes available

**Cons**:
- Less flexible than tikzposter
- Can be verbose

**Template**: `assets/posters/beamerposter_academic.tex`

**Example Usage**:
```latex
\documentclass[final]{beamer}
\usepackage[size=a0,scale=1.24]{beamerposter}
\usetheme{Berlin}
```

---

### tikzposter

**Description**: Modern poster package using TikZ  
**Best For**: Colorful, modern designs  
**Pros**:
- Highly customizable
- Modern, attractive themes
- Block-based layout

**Cons**:
- Steeper learning curve
- Can be slow to compile

**Template**: `assets/posters/tikzposter_research.tex`

**Example Usage**:
```latex
\documentclass[25pt, a0paper, portrait]{tikzposter}
\usetheme{Autumn}
\usecolorstyle{Denmark}
```

---

### baposter

**Description**: Box-and-poster system  
**Best For**: Structured, multi-column layouts  
**Pros**:
- Excellent column control
- Header boxes, structured layout
- Good for dense content

**Cons**:
- Complex syntax
- Less commonly used

**Template**: `assets/posters/baposter_conference.tex`

**Example Usage**:
```latex
\documentclass[a0paper,portrait]{baposter}
```

---

## Printing and File Preparation

### File Format

**For Printing**:
- **PDF**: Universal standard
- **High resolution**: 300 dpi minimum, 600 dpi for photos
- **Color space**: RGB for most printers (check with printer)
- **Embed fonts**: Ensure all fonts embedded
- **Flatten**: No transparency issues

### Print Quality Checks

Before printing:
1. **Proofread**: Check for typos, errors
2. **Colors**: Check in print preview
3. **Resolution**: Zoom to 100%, check figure quality
4. **Margins**: Verify nothing cut off
5. **Test print**: Print small version (A4) to check layout

### Print Providers

**Options**:
1. **University print shop**: Often cheapest, convenient
2. **FedEx Office**: Widely available
3. **Online services**: 
   - Vistaprint
   - Printful
   - Academic Poster Printing (specialized)

**Cost**: Typically $50-150 for A0 glossy poster

### Paper Types

| Paper Type | Description | Best For |
|-----------|-------------|----------|
| **Matte** | Non-reflective finish | Well-lit venues, minimal glare |
| **Glossy** | Shiny, vibrant colors | Photos, colorful figures |
| **Satin/Semi-gloss** | Between matte and glossy | Balanced option (recommended) |
| **Fabric** | Wrinkle-resistant, rollable | Travel, re-use |

**Recommendation**: **Satin or matte** for most academic posters

---

## QR Codes

### What to Include

Generate QR codes linking to:
- **Paper PDF**: Published or preprint
- **Supplementary materials**: Data, code, videos
- **Personal website**: Lab or researcher page
- **Video abstract**: 1-2 minute video summary
- **Online version**: Interactive poster

### Placement

- **Common locations**: 
  - Bottom right corner
  - Next to references
  - Near contact information
- **Size**: 3-4 inches (7-10 cm) square
- **Label**: "Scan for paper" or "More info"

### QR Code Generators
- QR Code Generator: https://www.qr-code-generator.com/
- QRStuff: https://www.qrstuff.com/
- LaTeX package: `qrcode` for generating in LaTeX

---

## Design Best Practices

### Do's

✓ **Use large fonts** (28pt+ for body text)  
✓ **Keep text minimal** (30-40% of poster)  
✓ **Use visuals** (60-70% figures, plots, images)  
✓ **Tell a story** (clear narrative flow)  
✓ **Colorblind-safe colors**  
✓ **Test readability** (view from 6 feet away)  
✓ **Include contact info** (email, QR code)  
✓ **Proofread** (multiple times!)

### Don'ts

✗ **Don't use small fonts** (<24pt body text)  
✗ **Don't overcrowd** (leave white space)  
✗ **Don't use complex tables** (simplify or visualize)  
✗ **Don't use full paragraphs** (use bullets)  
✗ **Don't use many fonts** (1-2 max)  
✗ **Don't use low-res images** (<300 dpi)  
✗ **Don't use red-green contrasts** (colorblind issue)  
✗ **Don't make it a paper** (posters ≠ papers)

---

## Poster Presentation Tips

### During the Poster Session

1. **Stand by your poster**: Be available, engaged
2. **Elevator pitch ready**: 1-2 minute summary prepared
3. **Different depths**: Short version (1 min), medium (3 min), deep dive (10 min)
4. **Engage visitors**: Ask questions, invite discussion
5. **Business cards**: Have them ready
6. **Notebook**: Record feedback, questions
7. **Handouts**: Optional 1-page summary (with QR code)

### Talking Through Your Poster

**30-second version**:
- What is the problem?
- What did you do?
- What did you find?

**2-minute version**:
- Background + motivation
- Methods (briefly)
- Key result (show main figure)
- Conclusion + implications

**5+ minute version**:
- Full walkthrough
- Address specific questions
- Discuss limitations, future work

---

## Accessibility Considerations

### Visual Accessibility

1. **Color contrast**: High contrast (4.5:1 minimum)
2. **Colorblind-safe**: Use Okabe-Ito or similar palettes
3. **Font size**: Large enough to read from distance
4. **Font choice**: Clear, sans-serif fonts
5. **Alt text**: Consider providing text description

### Physical Accessibility

1. **Mounting height**: Low enough for wheelchair users to read bottom
2. **QR codes**: Provide alternative (short URL, handout)

---

## Checklist Before Printing

- [ ] Proofread all text (typos, grammar)
- [ ] Check author names and affiliations
- [ ] Verify all figures are high resolution (300+ dpi)
- [ ] Ensure colorblind-safe color schemes
- [ ] Test readability from 6 feet away (print small version)
- [ ] Verify poster dimensions match conference requirements
- [ ] Check that fonts are embedded in PDF
- [ ] Include contact information (email, QR code)
- [ ] Add institutional logo
- [ ] Verify references are accurate
- [ ] Ensure figures have clear labels and captions
- [ ] Check that layout is not too dense (adequate white space)
- [ ] Verify QR codes work (test scan)
- [ ] Confirm file is high-resolution PDF
- [ ] Get feedback from colleagues

---

## Example Poster Layouts

### Layout 1: Two-Column (Recommended for Most)

```
+----------------------------------------+
|              TITLE                     |
|      Authors & Affiliations            |
+----------------------------------------+
|  INTRO    |  RESULTS                   |
|           |                            |
|  METHODS  |  RESULTS (cont.)           |
|           |                            |
|           |  DISCUSSION/CONCLUSIONS    |
+----------------------------------------+
|        REFERENCES    |    QR CODE      |
+----------------------------------------+
```

### Layout 2: Three-Column

```
+---------------------------------------+
|              TITLE                    |
|      Authors & Affiliations           |
+---------------------------------------+
| INTRO  | RESULTS | DISCUSSION         |
|        |         |                    |
| METHOD | RESULTS | CONCLUSIONS        |
|        |         |                    |
|        | RESULTS | FUTURE WORK        |
+---------------------------------------+
|    REFERENCES       |   QR CODE       |
+---------------------------------------+
```

### Layout 3: Horizontal Flow

```
+----------------------------------------+
|              TITLE                     |
|      Authors & Affiliations            |
+----------------------------------------+
|  INTRODUCTION    |    METHODS          |
+----------------------------------------+
|           RESULTS                      |
|    (large figure spanning width)       |
+----------------------------------------+
|  DISCUSSION      |   CONCLUSIONS       |
+----------------------------------------+
|        REFERENCES    |    QR CODE      |
+----------------------------------------+
```

---

## Resources

### LaTeX Templates
- `assets/posters/beamerposter_academic.tex`
- `assets/posters/tikzposter_research.tex`
- `assets/posters/baposter_conference.tex`

### Online Resources
- Better Posters Blog: https://betterposters.blogspot.com/
- Colorblind Safe Palettes: https://colorbrewer2.org/
- BioRender (scientific illustrations): https://biorender.com/
- Poster Design Guide (Colin Purrington): https://colinpurrington.com/tips/poster-design/

### Tools
- **Inkscape**: Free vector graphics editor
- **PowerPoint**: Surprisingly popular for posters
- **Illustrator**: Professional design tool
- **LaTeX**: Best for reproducibility, version control

---

## Summary

**Key Takeaways**:

1. **Size**: Verify conference requirements (typically A0 or 36"×48")
2. **Fonts**: Large (28pt+ body, 72pt+ title)
3. **Layout**: 2-3 columns, generous white space
4. **Visuals**: 60-70% visual content
5. **Colors**: Colorblind-safe, high contrast
6. **Content**: Tell a story, keep text minimal
7. **Quality**: 300+ dpi, test print
8. **Accessibility**: Readable from distance, clear hierarchy

**Remember**: A poster is **not a paper** - it's a visual summary designed to spark conversations!

