# Excel数据文件规范

McKinsey Consultant必须同步交付Excel数据文件,记录所有定量数据及来源。

## 文件命名

```
[项目名称]-数据汇总-YYYYMMDD.xlsx

例如:
中国有声市场分析-数据汇总-20251025.xlsx
充电桩市场研究-数据汇总-20251025.xlsx
```

## 文件结构

### Sheet1: 目录

| PPT页码 | 页面标题 | 数据类型 | Sheet名称 |
|---------|---------|---------|-----------|
| 第3页 | 市场规模历史趋势 | 时间序列 | Sheet2 |
| 第5页 | 细分市场占比 | 结构数据 | Sheet3 |
| 第7页 | 用户增长数据 | 增长分析 | Sheet4 |

### Sheet2~N: 数据页 (按PPT页码)

**命名格式**: `第X页 [页面主题]`

例如: `第3页 市场规模`

**每个Sheet包含**:

#### 区域1: 数据表格

```
┌──────┬────────┬────────┬──────────────────┐
│ 年份 │ 指标1  │ 指标2  │ 数据来源         │
├──────┼────────┼────────┼──────────────────┤
│ 2019 │ 45.2   │ 23.1   │ [1] 艾瑞咨询    │
│ 2020 │ 82.1   │ 34.5   │ [1] 艾瑞咨询    │
│ 2021 │ 134.5  │ 56.7   │ [2] 36氪        │
│ 2022 │ 189.3  │ 78.2   │ [2] 36氪        │
│ 2023 │ 256.7  │ 112.3  │ [3] 估算        │
└──────┴────────┴────────┴──────────────────┘
```

#### 区域2: 数据来源详情

```
数据来源列表:
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
[1] 艾瑞咨询 - 2024年中国在线音频市场报告
    URL: https://report.iresearch.cn/xxx
    采集日期: 2025-10-25
    数据年份: 2019-2022
    数据质量: 高 (官方行业报告)
    
[2] 36氪 - 2024年有声书市场分析
    URL: https://36kr.com/xxx
    采集日期: 2025-10-25
    数据年份: 2021-2022
    数据质量: 中 (媒体报道,引用其他报告)
    
[3] 基于历史增长率估算
    计算方法: 2023 = 2022 * (1 + CAGR_2019-2022)
    CAGR_2019-2022 = 35.6%
    数据质量: 低 (估算值)
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
```

#### 区域3: 数据说明

```
数据说明:
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
单位: 亿元人民币
口径: 在线有声市场总收入(包含广告+会员+打赏)
调整: 
  - 2021年数据根据通胀调整至2023年价格
  - 排除了硬件销售收入
验证:
  - 艾瑞与36氪2022年数据交叉验证,误差<5%
  - 与企业财报(喜马拉雅/蜻蜓FM)基本一致
置信度: 高 (2019-2022) / 中 (2023估算)
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
```

## 数据质量标注

### 质量等级

| 等级 | 定义 | 示例 |
|------|------|------|
| 高 | 官方报告/企业财报 | 艾瑞咨询,公司年报 |
| 中 | 媒体报道引用 | 36氪,虎嗅 |
| 低 | 估算/推算 | 基于CAGR估算 |

### 数据类型标注

| 类型 | 说明 | 标注 |
|------|------|------|
| 直接引用 | 原文数据未调整 | [直接] |
| 计算获得 | 基于原始数据计算 | [计算] |
| 估算 | 基于假设推算 | [估算] |
| 多源平均 | 多个来源取平均 | [平均] |

## 完整示例

### Sheet: 第3页 有声书市场规模

#### 数据表格

| 年份 | 市场规模(亿元) | 同比增长率 | 数据来源 | 质量 | 类型 |
|------|----------------|-----------|---------|------|------|
| 2019 | 45.2 | - | [1] | 高 | 直接 |
| 2020 | 82.1 | 81.6% | [1] | 高 | 直接 |
| 2021 | 134.5 | 63.8% | [2] | 中 | 直接 |
| 2022 | 189.3 | 40.7% | [2] | 中 | 直接 |
| 2023 | 256.7 | 35.6% | [3] | 低 | 估算 |
| 2024E | 347.8 | 35.5% | [3] | 低 | 估算 |

#### 数据来源

```
[1] 艾瑞咨询 - 2021年中国在线音频市场研究报告
    https://report.iresearch.cn/report/202104/3756.shtml
    采集: 2025-10-25
    覆盖: 2019-2020
    质量: 高 (官方行业报告,权威数据)

[2] 36氪 - 中国有声书市场分析2023
    https://36kr.com/p/2145678912
    采集: 2025-10-25
    覆盖: 2021-2022
    质量: 中 (媒体报道,引用艾媒咨询数据)
    
[3] 基于2019-2022 CAGR估算
    方法: 2023 = 2022 × (1 + 0.356)
          2024 = 2023 × (1 + 0.355)
    CAGR计算: ((189.3/45.2)^(1/3) - 1) = 61.5%
              保守估计35.6% (考虑市场成熟)
    质量: 低 (估算,实际可能偏差±15%)
```

#### 数据说明

```
单位: 亿元人民币
口径: 中国在线有声书市场总收入
      包含: 会员订阅 + 单本购买 + 广告收入
      排除: 有声书硬件设备销售

数据处理:
- 所有数据统一为当年价格(未通胀调整)
- 2021年艾媒数据与艾瑞2020基数有5.2%差异,
  已根据艾瑞口径调整

交叉验证:
- 喜马拉雅2022年财报显示收入67.8亿
- 蜻蜓FM 2022年收入约23.5亿
- 两家合计91.3亿,占市场189.3亿的48.2%
- 验证通过,数据合理

置信度:
2019-2020: 95% (官方报告)
2021-2022: 80% (媒体报道,已交叉验证)
2023-2024: 60% (估算,可能±15%偏差)
```

## 特殊数据处理

### 缺失数据

```
处理方式:
1. 线性插值 (短期缺失,1-2年)
2. CAGR估算 (长期缺失,3年以上)
3. 标注"数据缺失"(无法估算)

示例:
2020年数据缺失
→ 2020 = (2019 + 2021) / 2  [插值]
```

### 口径不一致

```
处理方式:
1. 统一为最权威来源的口径
2. 明确标注调整方法
3. 保留原始数据作为附注

示例:
来源A: 包含硬件销售
来源B: 仅内容收入
→ 统一为B口径,A数据减去硬件部分
```

### 多源数据冲突

```
处理方式:
1. 优先选择官方/权威来源
2. 多源取加权平均(按可信度)
3. 标注数据范围

示例:
来源A: 189.3亿 (权重60%)
来源B: 203.5亿 (权重40%)
→ 使用A(更权威)
→ 标注范围: 189-204亿
```

## 更新维护

### 版本控制

```
文件名包含日期:
中国有声市场-数据汇总-20251025.xlsx  # 初版
中国有声市场-数据汇总-20251126.xlsx  # 更新版

Sheet1添加更新记录:
┌────────────┬─────────┬────────────┐
│ 更新日期   │ 更新内容│ 更新人     │
├────────────┼─────────┼────────────┤
│ 2025-10-25 │ 初始版本│ Claude     │
│ 2025-11-26 │ 更新2024│ Claude     │
│            │ 实际数据│            │
└────────────┴─────────┴────────────┘
```

### 数据更新

当有新数据时:
1. 在对应Sheet更新数据
2. 添加新数据来源
3. 更新数据说明
4. 标注更新日期
5. 另存为新版本

## 质量保证

### 交付前检查清单

```
□ 每个定量数据都有来源URL
□ 来源URL可访问(未失效)
□ 数据单位统一标注
□ 估算数据标明计算方法
□ 冲突数据说明处理方式
□ 数据质量等级标注
□ 置信度评估
□ 交叉验证记录
□ Sheet命名规范
□ 目录完整
```

## 最佳实践

1. **边收集边记录** - STEP 6收集数据时就填入Excel
2. **URL完整保存** - 不要只记网站名,要完整URL
3. **计算留痕迹** - Excel中展示计算公式
4. **多源交叉验证** - 关键数据用2-3个来源验证
5. **标注置信度** - 让使用者知道数据可靠性
6. **便于更新** - 结构化存储,方便后续数据更新
