# Historical Government Shutdown Cases

This document provides reference data for past government shutdowns to contextualize current liquidity analysis.

## Overview of "Stealth Tightening" Hypothesis

Government shutdowns can create a **"stealth tightening"** effect (变相加息) through the following mechanism:

1. **Shutdown begins** → Federal spending restricted
2. **TGA accumulates** → Tax revenues continue but expenditures halt
3. **Bank reserves drain** → TGA accumulation mechanically withdraws reserves from banking system
4. **Funding costs rise** → SOFR premium over EFFR expands as liquidity becomes scarce
5. **Effective tightening** → Market experiences de facto interest rate increase beyond Fed's policy intent

**Critical moderating factor**: The transmission efficiency depends heavily on the monetary policy framework and existing reserve levels.

## Case 1: 2013 Shutdown (October 1-17, 2013)

### Macro Context: QE Era - Ample Reserves Buffer

- **Duration**: 16 days
- **Monetary environment**: Peak Quantitative Easing (QE3)
- **Bank reserves**: ~$2.3 trillion (extremely ample)
- **Policy rate**: Near-zero (EFFR ~0.08%)

### Data Summary

| Date | TGA ($B) | Reserves ($B) | EFFR (%) | SOFR (%) | Premium (bps) |
|------|----------|---------------|----------|----------|---------------|
| 09/30 (Pre-shutdown) | 44.99 | 2278.60 | 0.06 | N/A | N/A |
| 10/16 (End) | 35.30 | 2370.94 | 0.11 | N/A | N/A |

### Key Finding

**NO stealth tightening effect observed.**

- TGA remained extremely low (~$35B) throughout shutdown
- EFFR stable at 0.07-0.11%
- Massive reserve buffer (~$2.3T) absorbed any minor TGA fluctuations
- Market functioned normally with no liquidity stress

**Conclusion**: In ultra-ample reserve regimes, fiscal frictions do not transmit to money markets.

---

## Case 2: 2018-2019 Shutdown (December 22, 2018 - January 25, 2019)

### Macro Context: Early QT - Reserve Scarcity Emerging

- **Duration**: 35 days (longest in US history at the time)
- **Monetary environment**: Active Quantitative Tightening (QT)
- **Bank reserves**: Declining from ~$1.7T to ~$1.6T
- **Policy rate**: 2.25-2.50% target range

### Data Summary

| Date | TGA ($B) | Reserves ($B) | EFFR (%) | SOFR (%) | Premium (bps) |
|------|----------|---------------|----------|----------|---------------|
| 12/19 (Pre-shutdown) | 350.71 | 1699.14 | 2.20 | 2.30 | 10 |
| 12/26 (Early) | 374.09 | 1661.22 | 2.40 | 2.44 | 4 |
| 12/31 (Year-end) | N/A | N/A | 2.40 | **3.00** | **60** |
| 01/02 (Peak stress) | 379.90 | 1621.86 | 2.40 | **3.15** | **75** |
| 01/23 (Near end) | 389.63 | 1621.88 | 2.40 | 2.40 | 0 |

### Key Finding

**Clear stealth tightening effect observed.**

- TGA accumulated **+$40B** during shutdown
- Reserves drained to **$1.62T** (multi-year low)
- **SOFR spiked to 3.15%** on January 2, 2019
  - 75 bps premium over EFFR
  - Market funding costs far exceeded Fed's policy intent
- Year-end timing amplified stress (seasonal liquidity demand)

**Conclusion**: In QT environment with declining reserves, TGA accumulation directly transmitted to money market stress, validating the stealth tightening hypothesis.

---

## Case 3: 2025 Shutdown (October 1, 2025 - Ongoing)

### Macro Context: High Rates + Late QT - Acute Sensitivity

- **Duration**: Ongoing (as of November 2025)
- **Monetary environment**: Post-QT, high policy rates (~4%)
- **Bank reserves**: ~$2.8T (four-year low)
- **Policy rate**: 4%+ (IORB)

### Data Summary (Key Dates)

| Date | TGA ($B) | Reserves ($B) | EFFR (%) | SOFR (%) | Premium (bps) | Fed Action |
|------|----------|---------------|----------|----------|---------------|------------|
| 09/24 (Baseline) | 804.86 | 3002.22 | 4.09 | 4.13 | 4 | None |
| 10/01 (Start) | 805.14 | 2966.09 | 4.09 | 4.20 | 11 | None |
| 10/15 (Stress peak) | 809.59 | 3019.03 | 4.10 | 4.29 | **19** | None |
| 10/29 (TGA peak) | **957.99** | **2848.02** | 4.12 | 4.27 | 15 | None |
| 10/30 (Post-cut) | N/A | N/A | 3.87 | 4.04 | 17 | **Rate cut -25bps** |
| 10/31 (Crisis) | N/A | N/A | 3.86 | 4.22 | **36** | **SRF $29.4B** |
| 11/05 (Latest) | 940.98 | 2862.57 | 3.87 | 3.91 | 4 | None |

### Key Finding

**Acute stealth tightening observed, followed by reversal.**

**Phase 1: Tightening (Oct 1-29)**
- TGA surged **+$153B** (+19%)
- Reserves fell to **$2.85T** (four-year low, -5.1%)
- SOFR premium peaked at **19 bps** (Oct 15)

**Phase 2: Peak Crisis (Oct 29-31)**
- Fed cut rates **25 bps** on Oct 29
- Despite rate cut, SOFR jumped to **4.22%** on Oct 31
  - **36 bps premium** over new 3.9% IORB
  - Highest premium since March 2020
- Fed forced to inject **$29.4B via Standing Repo Facility (SRF)**

**Phase 3: Easing (Nov 1-5)**
- TGA releasing: **-$17B from peak** (-1.8%)
- Reserves recovering: **+$14.5B from trough**
- SOFR premium normalized: **4 bps** (back to pre-shutdown level)
- **Status**: Liquidity stress significantly easing

**Conclusion**: 
1. High policy rates + low reserves = maximum transmission efficiency
2. Fiscal friction directly impaired Fed's rate control (forced SRF intervention)
3. TGA release creating "invisible QE" effect as shutdown ends
4. Validates stealth tightening hypothesis with quantifiable impact

---

## Cross-Cycle Comparison

| Metric | 2013 (QE) | 2018-19 (QT) | 2025 (High Rates) |
|--------|-----------|--------------|-------------------|
| **Reserve environment** | Ample (2.3T) | Declining (1.6T) | Tight (2.8T) |
| **Policy rate** | Near-zero | 2.25-2.50% | 4%+ |
| **TGA accumulation** | Minimal | Moderate (+40B) | Large (+153B) |
| **Peak SOFR premium** | ~0 bps | 75 bps | 36 bps (post-cut) |
| **Fed intervention** | None | None | SRF $29.4B |
| **Stealth tightening** | ❌ No effect | ✅ Significant | ✅ Acute crisis |

## Key Takeaways

1. **Monetary framework matters most**: Reserve abundance determines whether fiscal shocks transmit to markets
2. **QT amplifies fiscal risks**: Low reserves make TGA fluctuations systemically important
3. **Policy rate height irrelevant to transmission**: High rates don't prevent stealth tightening; reserve scarcity is the critical factor
4. **2025 = Most severe case**: Forced Fed intervention proves fiscal dominance over monetary policy control
5. **Predictive value**: When reserves fall below "sufficient" threshold (~$2.5-3T?), government shutdowns create acute financial stability risks

## References

See main PDF report for detailed citations and methodology.
