---
name: alex-hormozi-pitch
description: Create irresistible offers and pitches using Alex Hormozi's methodology from $100M Offers. Guides through value equation, guarantee frameworks, pricing psychology, and creating offers "too good not to take" for any product or service.
---

# Alex Hormozi Pitch Skill

## When to Activate This Skill
- Create compelling offer or pitch
- Design irresistible value proposition
- Structure pricing and guarantees
- Build "too good not to take" offer
- Apply Hormozi frameworks
- Optimize existing offer
- Create Grand Slam Offer

## What This Skill Does

Guides you through Alex Hormozi's systematic approach to creating offers so compelling that prospects feel stupid saying no, using proven frameworks from "$100M Offers".

## How to Execute

**Execute the `/create-hormozi-pitch` slash command**, which provides:

1. Interactive guided process through Hormozi's frameworks
2. Value Equation optimization (Dream Outcome, Perceived Likelihood, Time Delay, Effort & Sacrifice)
3. Guarantee framework selection and structuring
4. Value stack and bonus construction
5. Scarcity and urgency implementation
6. Objection elimination strategies
7. Complete pitch output ready to use

## Core Frameworks Applied

### The Value Equation
```
Value = (Dream Outcome × Perceived Likelihood) / (Time Delay × Effort & Sacrifice)
```

### Four Guarantee Types
- Unconditional (money-back)
- Conditional (performance-based)
- Outcome-based (results-tied)
- Anti-guarantee (all sales final)

### MAGIC Naming Formula
- **M**ake it about them
- **A**nnounce the avatar
- **G**ive them a goal
- **I**ndicate a time interval
- **C**omplete with container word

## Use Cases

- Product launches
- Service offerings
- Consulting proposals
- Course creation
- High-ticket sales
- Lead magnets
- Upsells and downsells

## Full Workflow Reference

For complete step-by-step instructions: `read ${PAI_DIR}/commands/create-hormozi-pitch.md`
