---
name: financial-document-parser
description: Extract and analyze data from invoices, receipts, bank statements, and financial documents. Categorize expenses, track recurring charges, and generate expense reports. Use when user provides financial PDFs or images.
---

# Financial Document Parser

Extract structured data from financial documents with automatic categorization and analysis.

## When to Use This Skill

Activate when the user:
- Provides invoices, receipts, or bank statements
- Asks to "parse this invoice" or "extract data from this receipt"
- Needs expense categorization
- Wants to track spending patterns
- Asks to generate expense reports
- Mentions financial document analysis
- Provides PDF or image of financial documents

## Instructions

1. **Identify Document Type**
   - Invoice (business to business)
   - Receipt (point of sale)
   - Bank statement
   - Credit card statement
   - Expense report
   - Tax document

2. **Extract Core Information**

   **For Invoices:**
   - Invoice number
   - Invoice date and due date
   - Vendor/supplier name and contact
   - Client/recipient name
   - Line items (description, quantity, unit price, total)
   - Subtotal, tax, and grand total
   - Payment terms
   - Payment methods accepted

   **For Receipts:**
   - Merchant name and location
   - Date and time
   - Items purchased
   - Individual prices
   - Subtotal, tax, total
   - Payment method
   - Last 4 digits of card (if present)

   **For Bank/Credit Card Statements:**
   - Statement period
   - Account number (last 4 digits)
   - All transactions (date, description, amount, balance)
   - Beginning and ending balance
   - Total credits and debits
   - Fees or interest charges

3. **Categorize Expenses**
   - Business expenses: Office supplies, software, equipment
   - Travel: Transportation, lodging, meals
   - Utilities: Internet, phone, electricity
   - Professional services: Legal, accounting, consulting
   - Marketing: Advertising, subscriptions
   - Entertainment: Client meals, events
   - Other: Miscellaneous

4. **Identify Patterns**
   - Recurring charges (subscriptions)
   - Duplicate charges
   - Unusual or high-value transactions
   - Tax-deductible expenses
   - Foreign currency transactions

5. **Generate Structured Output**
   - Create CSV-ready format
   - Summarize totals by category
   - Flag items needing attention
   - Calculate tax implications (if relevant)

## Output Format

```markdown
# Financial Document Analysis

## Document Details
- **Type**: Invoice / Receipt / Statement
- **Date**: [Date]
- **Vendor/Merchant**: [Name]
- **Document Number**: [Number]
- **Total Amount**: $X,XXX.XX

## Line Items
| Description | Quantity | Unit Price | Total |
|-------------|----------|------------|-------|
| [Item] | X | $XX.XX | $XX.XX |

## Financial Summary
- **Subtotal**: $X,XXX.XX
- **Tax**: $XXX.XX
- **Total**: $X,XXX.XX
- **Payment Method**: [Method]

## Expense Categorization
| Category | Amount | Items |
|----------|--------|-------|
| Software | $XXX | Slack, GitHub |
| Office | $XX | Supplies |

## Insights
- ✓ Tax-deductible business expenses: $X,XXX
- ⚠ Recurring charges detected: 3 subscriptions ($XXX/month)
- ℹ Foreign transaction fees: $XX

## Flagged Items
- [ ] Large expense ($X,XXX) - verify approval
- [ ] Duplicate charge detected on [date]

## Export Data (CSV Format)
```csv
Date,Vendor,Description,Category,Amount,Tax Deductible
2025-01-15,Adobe,Creative Cloud,Software,52.99,Yes
```

## Recommendations
- Track recurring $XXX/month for [subscription]
- Consider negotiating bulk discount with [vendor]
- Set up payment reminder for [invoice due date]
```

## Examples

**User**: "Extract data from this invoice PDF"
**Response**: Parse PDF → Extract vendor info, line items, totals → Categorize as business expense → Format as structured data → Generate CSV export

**User**: "Analyze my bank statement and categorize expenses"
**Response**: Extract all transactions → Categorize each (dining, software, travel) → Identify recurring charges → Calculate totals by category → Flag unusual transactions → Generate spending report

**User**: "Parse these 10 receipts and create an expense report"
**Response**: Process each receipt → Extract merchant, date, amount, items → Categorize expenses → Calculate totals → Generate consolidated report → Create CSV for expense submission

## Best Practices

- Preserve exact amounts (don't round)
- Maintain currency symbols and formats
- Note when data is unclear or illegible
- Flag suspicious or duplicate transactions
- Provide tax-relevant categorization
- Use standard expense categories
- Generate export-ready formats (CSV, JSON)
- Protect sensitive info (mask account numbers)
- Identify missing information (no date, unclear vendor)
- Calculate totals and verify against document
- Note discrepancies or calculation errors
- Include exchange rates for foreign currency
