---
name: podcast-to-content-suite
description: Transform podcast transcripts into comprehensive content marketing suites including blog posts, social media content, newsletters, SEO-optimized articles, and timestamps. Use when user provides podcast transcripts or wants to repurpose podcast content.
---

# Podcast to Content Suite

Convert podcast episodes into a complete content marketing ecosystem.

## When to Use This Skill

Activate when the user:
- Provides a podcast transcript
- Asks to "repurpose this podcast"
- Wants to create content from audio
- Mentions podcast marketing or content distribution
- Needs blog posts from podcast episodes
- Wants social media content from podcasts
- Asks for podcast show notes

## Instructions

1. **Analyze Podcast Content**
   - Identify main topic and subtopics
   - Extract key insights and takeaways (5-7 main points)
   - Note memorable quotes and soundbites
   - Find statistics or data mentioned
   - Identify guest credentials (if applicable)
   - Determine target audience
   - Extract actionable advice
   - Note timestamps for key moments

2. **Create SEO-Optimized Blog Post**
   - Write compelling title (H1) with keyword
   - Craft meta description (150-160 chars)
   - Structure with clear H2/H3 headings
   - Include introduction with hook
   - Expand on key points from podcast
   - Add quotes from episode
   - Include embedded audio player suggestion
   - Add internal/external links
   - Create conclusion with CTA
   - Length: 1200-2000 words
   - Optimize for featured snippets

3. **Generate Social Media Content**

   **Twitter/X Thread (8-12 tweets):**
   - Hook tweet with episode value prop
   - Key insights as individual tweets
   - Quote tweets from episode
   - Final CTA tweet with link

   **LinkedIn Post:**
   - Professional angle on topic
   - Key business insights
   - Storytelling format
   - End with discussion prompt

   **Instagram Captions (3 variations):**
   - Audiogram caption
   - Key quote graphic caption
   - Behind-the-scenes/guest intro caption

   **Facebook Post:**
   - Conversational tone
   - Discussion prompt
   - Episode highlights

4. **Create Email Newsletter**
   - Subject line (3-5 variations)
   - Preview text
   - Email body:
     - Personal intro from host
     - Episode overview
     - Key takeaway bullets
     - Featured quote
     - Listen CTA with button
     - P.S. section (next episode tease)
   - Optimized for mobile

5. **Generate Show Notes**
   - Episode summary (2-3 paragraphs)
   - Guest bio and links (if applicable)
   - Key timestamps with descriptions
   - Resources mentioned
   - Quotable moments
   - Transcript excerpt (most valuable section)
   - Subscribe/follow links

6. **Create Audiogram Scripts**
   - 3-5 best 30-60 second clips
   - Timestamps for each clip
   - On-screen text suggestions
   - Suggested visuals/graphics

7. **Extract SEO Elements**
   - Primary keyword
   - Secondary keywords (5-7)
   - Suggested meta tags
   - Schema markup suggestions
   - Internal linking opportunities

## Output Format

```markdown
# Podcast Content Marketing Suite
## Episode: "[Episode Title]"

---

## 📝 SEO-Optimized Blog Post

### Title Options
1. [Primary title - 60 chars max]
2. [Alternative clickable version]
3. [SEO-focused version]

### Meta Description
[150-160 character meta description with keyword]

### Blog Post Content

# [H1 Title with Keyword]

[Engaging introduction paragraph with hook]

## [H2: First Main Topic]

[Expanded content from podcast discussion...]

> "[Memorable quote from episode]" — [Speaker]

[Continue with analysis and insights...]

## [H2: Second Main Topic]

[Content...]

### [H3: Subtopic]

[Detailed breakdown...]

## Key Takeaways

• [Takeaway 1]
• [Takeaway 2]
• [Takeaway 3]

## Conclusion

[Summary and call-to-action]

**Listen to the full episode**: [Link]

---

## 🐦 Twitter/X Thread

**Tweet 1/10** (Hook)
[Attention-grabbing value proposition]

🎙️ New episode with [guest]

[Topic/promise]

Thread 🧵

**Tweet 2/10**
[First key insight]

**Tweet 3/10**
> "[Powerful quote]"

[Continue through thread...]

**Tweet 10/10**
[Summary and CTA]

Listen to full episode: [link]

---

## 💼 LinkedIn Post

[Professional hook related to business topic]

I just published an episode of [podcast name] with [guest/topic].

Here are the [3/5] key insights:

1️⃣ [Insight with brief explanation]

2️⃣ [Insight with brief explanation]

3️⃣ [Insight with brief explanation]

[Personal reflection or question]

[CTA to listen]

#Hashtag1 #Hashtag2 #Hashtag3

---

## 📸 Instagram Captions

### Caption 1: Audiogram
🎙️ New Episode Alert!

[Hook about episode topic]

In this episode, we dive into:
✨ [Point 1]
✨ [Point 2]
✨ [Point 3]

[Emoji CTA] Link in bio to listen

.
.
.
#podcast #topic #niche [15-20 relevant hashtags]

### Caption 2: Quote Graphic
"[Powerful quote from episode]"

[Context for quote]

[CTA]

[Hashtags]

### Caption 3: Guest/Topic Intro
[Content...]

---

## 📧 Email Newsletter

### Subject Lines
1. [Curiosity-driven subject]
2. [Benefit-focused subject]
3. [Direct subject with guest name]

### Preview Text
[40-50 characters that complement subject]

### Email Body

Hi [First Name],

[Personal intro from host perspective]

This week's episode is about [topic], and here's why you should listen:

**What You'll Learn:**
• [Takeaway 1]
• [Takeaway 2]
• [Takeaway 3]

**My Favorite Moment:**
> "[Quote]"

[Brief personal reflection]

[Listen Now Button/CTA]

**P.S.** [Tease next episode or ask question]

---

## 📺 Audiogram Clips

### Clip 1: [Title]
**Timestamp**: 12:45 - 13:30
**Duration**: 45 seconds
**Hook**: "[Opening line]"
**On-Screen Text**:
- "[Key phrase 1]"
- "[Key phrase 2]"
**Why It Works**: [High energy / Surprising insight / Actionable tip]

### Clip 2: [Title]
[Same format...]

---

## 📋 Show Notes

**Episode #XX**: [Episode Title]

**Guest**: [Name, Title, Company]

**Summary**:
[2-3 paragraph overview of episode]

**Guest Bio**:
[Bio and credentials]
🔗 Website: [link]
🐦 Twitter: [handle]
💼 LinkedIn: [link]

**Episode Highlights**:
• [00:00] - Introduction
• [03:45] - [Topic 1]
• [12:30] - [Topic 2]
• [23:15] - [Topic 3]
• [38:00] - [Actionable advice]
• [45:20] - Final thoughts

**Resources Mentioned**:
• [Resource 1] - [link]
• [Resource 2] - [link]

**Quotable Moments**:
> "[Quote 1]" - [Timestamp]
> "[Quote 2]" - [Timestamp]

**Subscribe**:
🎧 [Apple Podcasts]
🟢 [Spotify]
📻 [Website]

---

## 🔍 SEO Elements

**Primary Keyword**: [main keyword]
**Secondary Keywords**: [keyword 1], [keyword 2], [keyword 3]

**Suggested Tags**: [tag1], [tag2], [tag3]

**Internal Linking Opportunities**:
• Link to: [related episode] (anchor: [text])
• Link to: [related blog] (anchor: [text])

**Schema Markup**: PodcastEpisode, Person (for guest)
```

---

## Examples

**User**: "Turn this podcast transcript into content"
**Response**: Analyze 45-min conversation → Extract 6 key insights → Create 1800-word blog post → Generate Twitter thread → Write LinkedIn post → Create email newsletter → Provide show notes with timestamps → Suggest 4 audiogram clips

**User**: "I need social media content from this episode"
**Response**: Focus on social components → Create platform-specific posts → Extract quotable moments → Suggest visuals → Provide hashtag research → Include optimal posting times

**User**: "Create show notes for this interview"
**Response**: Summarize episode → Write guest bio → Create detailed timestamps → Extract resources mentioned → Pull best quotes → Format for website publication

## Best Practices

- Preserve the conversational tone of podcast
- Expand on points mentioned (add context)
- Use quotes liberally (authentic podcast voice)
- Create modular content (mix and match pieces)
- Optimize for each platform's strengths
- Include clear CTAs in every piece
- Make content scannable (bullets, headers)
- Add value beyond just transcription
- Include timestamps for audio/video
- Cross-promote between content pieces
- Consider SEO in all written content
- Make email content mobile-friendly
- Test subject lines and titles
- Provide multiple format options
- Include evergreen elements
- Add internal links between episodes
- Suggest content calendar timing
