---
name: seo-content-optimizer
description: Optimize content for search engines with keyword analysis, readability scoring, meta descriptions, and competitor comparison. Use this when users want to improve SEO, optimize blog posts, or analyze content for search performance.
---

# SEO Content Optimizer

Comprehensive SEO analysis and optimization for content creators and marketers.

When a user asks you to optimize content for SEO, provide a detailed analysis covering keywords, readability, technical SEO, and actionable recommendations.

## Instructions

### 1. Analyze Target Keywords

Examine keyword usage and placement:
- Identify primary keyword(s) from user input or content
- Check keyword placement (title, H1, first 100 words, subheadings)
- Calculate keyword density (aim for 1-2%)
- Identify LSI keywords and semantic variations present
- Flag keyword stuffing issues

### 2. Evaluate Content Structure

Assess the organization and hierarchy:
- Check heading hierarchy (single H1 → multiple H2 → H3)
- Verify keyword usage in headings
- Evaluate heading descriptiveness
- Check paragraph length (aim for <150 words)
- Assess overall scanability

### 3. Readability Analysis

Calculate readability metrics:
- Flesch Reading Ease score (aim for 60-70)
- Grade level estimation
- Average sentence length (aim for <20 words)
- Passive voice percentage (minimize)
- Transition word usage
- Paragraph structure

### 4. Technical SEO Elements

Generate optimized meta elements:
- **Meta Title**: 50-60 characters with primary keyword
- **Meta Description**: 150-160 characters, compelling with keyword
- **URL Slug**: Short, keyword-rich, hyphen-separated
- **Image Alt Text**: Descriptive with keywords where natural
- **Internal Linking**: Opportunities to link to related content
- **External Links**: Quality of outbound links

### 5. Content Quality Assessment

Evaluate comprehensiveness:
- Word count (competitive topics need 1500+ words)
- Content depth and detail level
- Topic coverage completeness
- Unique value proposition
- E-A-T signals (expertise, authority, trust)
- Content freshness (dates, current examples)

### 6. Provide Actionable Recommendations

Prioritize improvements by impact:

**Critical (Fix Immediately)**:
- Missing or poor meta description
- No keyword in title or H1
- Broken internal links
- Keyword density too high/low

**High Priority**:
- Poor readability score
- Weak heading structure
- Missing alt text on images
- Content too thin

**Medium Priority**:
- Could add related keywords
- Opportunity for featured snippet
- Could improve internal linking

Provide specific, actionable fixes with examples.

## Output Format

```markdown
# SEO Analysis Report

## Overall Score: X/100

### Target Keywords
- Primary: [keyword] (density: X.X%)
- Secondary: [keyword 1], [keyword 2]
- LSI Keywords Found: [variations]

## Quick Wins (Implement First) 🚀
1. [Specific action with exact change needed]
2. [Specific action with exact change needed]

## Keyword Analysis

✅ Keyword in title
❌ Keyword missing in first 100 words ← Add to opening paragraph
✅ Keyword in 2/5 H2 headings
⚠️ Density: 0.8% (low - aim for 1-2%)

## Readability Metrics

- **Flesch Reading Ease**: XX/100 (Grade level: XX)
- **Average Sentence Length**: XX words
- **Passive Voice**: X%
- **Transition Words**: X%
- **Assessment**: [Good/Needs improvement]

## Meta Information

**Current Meta Title** (X chars): [current title]
**Suggested Meta Title** (XX chars):
`[Optimized title with keyword - 50-60 chars]`

**Current Meta Description**: [current or none]
**Suggested Meta Description** (XXX chars):
`[Compelling 150-160 char description with keyword and CTA]`

**URL Slug**:
Current: `/current-url-slug`
Suggested: `/keyword-rich-slug`

## Content Structure

- **Word Count**: XXXX words ([sufficient/too short] for this topic)
- **Heading Hierarchy**: [assessment]
- **Paragraph Length**: Average XX words [good/too long]
- **Sections**: [list main sections]

## Critical Issues 🚨

### 1. [Issue Name]
**Problem**: [Description]
**Impact**: [SEO impact]
**Fix**: [Specific instruction]

**Example**:
```
Current: [show current problematic text]
Improved: [show corrected version]
```

## High Priority Recommendations ⚠️

### 1. [Recommendation]
[Specific actionable instruction]

## Content Gaps

Missing subtopics to add:
- **[Subtopic 1]**: [Why it's important] (search volume: XXX)
- **[Subtopic 2]**: [Why it's important]

## Internal Linking Opportunities

- Link to: [page URL] using anchor text: "[keyword phrase]"
- Link from: [this content] to [related page]

## Featured Snippet Opportunity

[If applicable, show how to format content for featured snippet]

Example:
```markdown
## What is [topic]?

[Clear, concise 40-60 word answer]

- Key point 1
- Key point 2
- Key point 3
```

## Competitor Insights

[If analysis was done]
- Top ranking content averages XXXX words
- Common topics covered: [list]
- Your advantage: [unique angle]

## Implementation Checklist

- [ ] Update meta title and description
- [ ] Add keyword to first paragraph
- [ ] Fix heading structure
- [ ] Add missing alt text (X images)
- [ ] Add internal links (X opportunities)
- [ ] Expand [thin section] with XXX words
- [ ] Add FAQ section for featured snippet

## Estimated Impact

**Time to Implement**: X hours
**Expected Improvement**: [Moderate/Significant] ranking boost
**Priority**: [High/Medium/Low]
```

## Best Practices

- **Prioritize user experience** over keyword stuffing
- **Write for humans first**, optimize for search engines second
- **Provide specific examples**, not vague advice
- **Consider search intent** behind keywords (informational, commercial, transactional)
- **Recommend content additions**, not just optimization
- **Check for E-A-T signals** (author bio, credentials, sources)
- **Suggest schema markup** where relevant (FAQ, How-To, Review)
- **Look for featured snippet opportunities** (definition boxes, lists, tables)

## Example Workflow

**User**: "Optimize this blog post for 'best project management tools'"

**Your analysis**:
1. Check keyword placement → Found in title but not H1 (fix needed)
2. Calculate density → 0.5% (too low, needs 8-10 more mentions)
3. Analyze readability → Flesch score 55 (good), but sentences too long
4. Generate meta tags → Create compelling meta description
5. Identify gaps → Missing "pricing comparison" and "team size recommendations"
6. Find internal links → Link to "project management tips" article
7. Suggest featured snippet → Format comparison table
8. Provide prioritized action list

---

**Remember**: SEO is about creating valuable, well-optimized content that serves user intent better than competitors.
