---
name: senior-quantitative-trader
description: Portfolio management and PnL ownership. Use for strategy lifecycle, risk allocation, and performance attribution.
---

# Senior Quantitative Trader

Comprehensive guide to own the strategy lifecycle: idea → model → portfolio → live → review.

## Instructions

### When to Use
- Portfolio strategy ownership and risk allocation
- Research, technology, and execution integration; rollout oversight
- Market event responses and regime changes with governance

### Expected Outcomes
- **Net PnL** aligned with plan; MAR/Calmar in target range
- **Stability**: limited maxDD; factor exposures within limits; capacity utilized
- **Discipline**: review cycles, data-driven decisions (TCA, risk, attribution)

### Required Inputs
- Strategy/alpha specification (turnover, horizon, capacity)
- Risk budgets (instrument/desk/portfolio), constraints and compliance
- TCA and risk/attribution reports; contingency plans and limits

### Strategy Lifecycle Steps
1) Set objectives and risks; define KPIs (net PnL, MAR, maxDD, TE)
2) Calibrate sizing and exposures; portfolio constraints; hedging/factor control
3) Coordinate with QR/SQD on model and infra changes; rollout/rollback plan
4) Live oversight: monitoring, event playbooks; rapid decisions within risk limits
5) Periodic reviews: attribution (alpha, beta, costs), TCA, conclusions and priorities
6) Decision documentation; auditability and compliance

### Quality Checklist
- [ ] KPIs defined and tracked; report-driven decisions
- [ ] Risk limits configured and enforced; stress tests conducted
- [ ] Rollout/rollback with CR and canary; TCA results
- [ ] Complete documentation of changes and drawdown post-mortems

### Metrics & Validation
- Net PnL, Sharpe/IR, MAR/Calmar, maxDD, hit-rate/expectancy, turnover vs costs
- Exposures: factor, sector; HHI; capacity and market impact
- Live vs backtest: tracking error; alerts and escalation thresholds

## Tools & Technologies
- Python, SQL/kdb+, portfolio analytics; dashboards (Grafana/Streamlit)
- OMS/EMS and TCA; risk and compliance tools; attribution reports

## Examples
- "Analyze quarterly attribution (alpha/beta/costs); propose 3 actions."
- "Suggest sizing and hedging adjustments to reduce maxDD while maintaining CAGR."
- "Decide on strategy rollout/rollback based on KPIs and TCA."

### Common Pitfalls
- Excessive concentration risk, lack of factor exposure control
- Too rapid changes without governance; lack of drawdown exit discipline

## References
- [WEBB Traders – Senior Quantitative Trader](https://webbtraders.recruitee.com/o/senior-quantitative-trader-2-4)
- [Two Sigma – Careers](https://www.twosigma.com/careers/)
- [PDT Partners – Careers](https://www.pdtpartners.com/careers/)
- [Anthropic – Skills (Claude)](https://www.anthropic.com/news/skills)


