# User Documentation: KB Article Template

---
TOKEN_BUDGET: 250
TIER: 3
LOAD_TRIGGER: On-demand when creating knowledge base articles
DEPENDENCIES: 07-user-writing-style.md
---

## 7.3 KB Article Template

### Template Structure

```markdown
# [Title: How to Do Something]

**Category**: Task Management
**Tags**: create, task, assign
**Last Updated**: 2025-01-15

---

## Introduction
Brief 1-2 sentence overview of what this article covers.

Example: "This guide shows you how to create a new task and assign it to a team member."

---

## Prerequisites
What the user needs before starting:
- You must be logged in
- You must be a member of a project
- (Optional) You need admin permissions

---

## Step-by-Step Instructions

### Step 1: [Action - Use Verb]
Detailed explanation with screenshot.

**Example:**
Click the **"+ New Task"** button in the top-right corner of your dashboard.
[Screenshot with red box highlighting the button]

### Step 2: [Next Action]
Detailed explanation with animated GIF.

**Example:**
Fill in the task details:
- **Title**: Required. Give your task a clear name.
- **Description**: Optional. Add more context.
- **Due Date**: Optional. Set a deadline.

[Animated GIF showing form completion]

### Step 3: [Final Action]
Click **"Save"** to create your task.

---

## What Happens Next
Your task appears in the "Pending" column and is visible to all project members. If you assigned the task to someone, they'll receive an email notification.

---

## Troubleshooting

**Problem**: I can't see the "New Task" button.
**Solution**: Only project members can create tasks. Ask your admin to add you to the project.

**Problem**: The task isn't appearing after I save it.
**Solution**: Try refreshing the page. If it still doesn't appear, contact support at support@example.com.

---

## FAQ

**Q: Can I assign a task to multiple people?**
A: Currently, one task can have one assignee. We recommend breaking the work into separate tasks.

**Q: How do I edit a task after creating it?**
A: Click on the task to open it, then click the "Edit" button. See [How to Edit Tasks] for details.

---

## Related Articles
- [How to Invite Team Members](link)
- [Understanding Task Statuses](link)
- [Setting Up Email Notifications](link)

---

*Was this article helpful? [👍 Yes] [👎 No]*
```

---

### Article Metadata

**Category**: Organize by user journey
- Getting Started
- Account Management
- Task Management
- Team Collaboration
- Integrations
- Billing

**Tags**: Use for search
- Action verbs: create, edit, delete, assign
- Features: tasks, projects, notifications
- User types: admin, member, guest

**Last Updated**: Show freshness
- Date format: YYYY-MM-DD
- Updates trigger review

---

### Quality Checklist

Before publishing:
- [ ] Title starts with "How to" or asks a question
- [ ] Introduction is 1-2 sentences
- [ ] Prerequisites are listed
- [ ] Steps are numbered (not bulleted)
- [ ] Each step has a screenshot or GIF
- [ ] Expected outcome is described
- [ ] Troubleshooting covers common issues
- [ ] Related articles are linked
- [ ] Article is proofread for grammar/spelling

---

**End of KB Article Template Guide**
