# Workflow Navigation

Quick reference to find the right workflow for your task.

## Primary Workflows

| Intent | Workflow | Tokens | Description |
|--------|----------|--------|-------------|
| Create new docs | [greenfield-workflow.md](greenfield-workflow.md) | ~350 | Template-based creation |
| Document code | [brownfield-workflow.md](brownfield-workflow.md) | ~400 | Reverse-engineer from code |
| Review docs | [audit-workflow.md](audit-workflow.md) | ~350 | Audit and improve |
| Change format | [convert-workflow.md](convert-workflow.md) | ~250 | MD ↔ DOCX ↔ PDF |
| Create visuals | [diagram-workflow.md](diagram-workflow.md) | ~350 | Mermaid, PlantUML |

## Specialized Workflows

| Intent | Workflow | Description |
|--------|----------|-------------|
| User documentation | [user-docs-workflow.md](user-docs-workflow.md) | Manuals, how-tos |
| Developer tutorials | [tutorial-workflow.md](tutorial-workflow.md) | API guides, CLI docs |
| Operational docs | [runbook-workflow.md](runbook-workflow.md) | Runbooks, procedures |

## Sub-Guides (Load on demand)

### Greenfield
| Document | Guide | Tokens |
|----------|-------|--------|
| SRS | [greenfield/srs-guide.md](greenfield/srs-guide.md) | ~250 |
| PRD | [greenfield/prd-guide.md](greenfield/prd-guide.md) | ~250 |
| OpenAPI | [greenfield/openapi-guide.md](greenfield/openapi-guide.md) | ~250 |
| Advanced | [greenfield/advanced.md](greenfield/advanced.md) | ~200 |

### Brownfield
| Framework | Guide | Tokens |
|-----------|-------|--------|
| Spring Boot | [brownfield/springboot-guide.md](brownfield/springboot-guide.md) | ~300 |
| FastAPI | [brownfield/fastapi-guide.md](brownfield/fastapi-guide.md) | ~250 |
| Pulumi | [brownfield/pulumi-guide.md](brownfield/pulumi-guide.md) | ~250 |

---

**PDA Principle**: Load only the workflow and sub-guide needed for your current task.
