# Mastering PyTorch: Deep RL and NLP

This repository contains a Codex skill that provides expert guidance for PyTorch development, focused on deep reinforcement learning with TorchRL and NLP transformers with HuggingFace.

## Contents

- `SKILL.md` defines the skill metadata and core guidance.
- `references/` includes deeper topic references linked from the skill.
- `AGENTS.md` outlines contributor guidelines for updates.

## Usage

Open `SKILL.md` to review or update the skill content. When editing, keep examples concise and aligned with the verified library versions listed in the document.

## Installing with Skilz (Universal Installer)

The recommended way to install this skill across different AI coding agents is using the **skilz** universal installer.

### Install Skilz

```bash
pip install skilz
```

This skill supports [Agent Skill Standard](https://agentskills.io/) which means it supports 14 plus coding agents including Claude Code, OpenAI Codex, Cursor and Gemini.

### Git URL Options

You can use either `-g` or `--git` with HTTPS or SSH URLs:

```bash
# HTTPS URL
skilz install -g <https://github.com/SpillwaveSolutions/mastering-pytorch-rl-nlp-agentic-skill>

# SSH URL
skilz install --git git@github.com:SpillwaveSolutions/mastering-pytorch-rl-nlp-agentic-skill.git
```

### Claude Code

Install to user home (available in all projects):

```bash
skilz install -g <https://github.com/SpillwaveSolutions/mastering-pytorch-rl-nlp-agentic-skill>
```

Install to current project only:

```bash
skilz install -g <https://github.com/SpillwaveSolutions/mastering-pytorch-rl-nlp-agentic-skill> --project
```

### OpenCode

Install for [OpenCode](https://opencode.ai/):

```bash
skilz install -g <https://github.com/SpillwaveSolutions/mastering-pytorch-rl-nlp-agentic-skill> --agent opencode
```

Project-level install:

```bash
skilz install -g <https://github.com/SpillwaveSolutions/mastering-pytorch-rl-nlp-agentic-skill> --project --agent opencode
```

### Gemini

Project-level install for Gemini:

```bash
skilz install -g <https://github.com/SpillwaveSolutions/mastering-pytorch-rl-nlp-agentic-skill> --agent gemini
```

### OpenAI Codex

Install for OpenAI Codex:

```bash
skilz install -g <https://github.com/SpillwaveSolutions/mastering-pytorch-rl-nlp-agentic-skill> --agent codex
```

Project-level install:

```bash
skilz install -g <https://github.com/SpillwaveSolutions/mastering-pytorch-rl-nlp-agentic-skill> --project --agent codex
```

### Install from Skillzwave Marketplace

```
# Claude to user home dir ~/.claude/skills
skilz install SpillwaveSolutions_mastering-pytorch-rl-nlp-agentic-skill/mastering-pytorch-rl-nlp

# Claude skill in project folder ./claude/skills
skilz install SpillwaveSolutions_mastering-pytorch-rl-nlp-agentic-skill/mastering-pytorch-rl-nlp --project

# OpenCode install to user home dir ~/.config/opencode/skills
skilz install SpillwaveSolutions_mastering-pytorch-rl-nlp-agentic-skill/mastering-pytorch-rl-nlp --agent opencode

# OpenCode project level
skilz install SpillwaveSolutions_mastering-pytorch-rl-nlp-agentic-skill/mastering-pytorch-rl-nlp --agent opencode --project

# OpenAI Codex install to user home dir ~/.codex/skills
skilz install SpillwaveSolutions_mastering-pytorch-rl-nlp-agentic-skill/mastering-pytorch-rl-nlp

# OpenAI Codex project level ./.codex/skills
skilz install SpillwaveSolutions_mastering-pytorch-rl-nlp-agentic-skill/mastering-pytorch-rl-nlp --agent opencode --project

# Gemini CLI (project level) -- only works with project level
skilz install SpillwaveSolutions_mastering-pytorch-rl-nlp-agentic-skill/mastering-pytorch-rl-nlp --agent gemini
```

See this site [skill listing](https://skillzwave.ai/skill/SpillwaveSolutions_mastering-pytorch-rl-nlp-agentic-skill_mastering-pytorch-rl-nlp__SKILL/) to see how to install this exact skill to 14+ different coding agents.

### Other Supported Agents

Skilz supports 14+ coding agents including Claude Code, OpenAI Codex, OpenCode, Cursor, Gemini CLI, GitHub Copilot CLI, Windsurf, Qwen Code, Aidr, and more.

For the full list of supported platforms, visit [SkillzWave.ai/platforms](https://skillzwave.ai/platforms/) or see the [skilz-cli GitHub repository](https://github.com/SpillwaveSolutions/skilz-cli)

<a href="https://skillzwave.ai/">Largest Agentic Marketplace for AI Agent Skills</a> and
<a href="https://spillwave.com/">SpillWave: Leaders in AI Agent Development.</a>

## Contributing

Please read `AGENTS.md` before making changes.
