# Brand Guidelines

Frameworks for defining, documenting, and enforcing brand voice, tone, and visual identity.

## Contents

- [Voice Dimensions Matrix](#voice-dimensions-matrix)
- [This-But-Not-That Chart](#this-but-not-that-chart)
- [Tone Adaptation by Context](#tone-adaptation-by-context)
- [Messaging Framework](#messaging-framework)
- [Terminology Standards](#terminology-standards)
- [Visual Identity Quick Reference](#visual-identity-quick-reference)
- [Channel-Specific Guidelines](#channel-specific-guidelines)
- [Brand Voice Checklist](#brand-voice-checklist)

---

## Voice Dimensions Matrix

Define brand voice on 4 spectrums. Mark position with filled circle (●).

### Voice Spectrum Template

| Dimension | ← Left | 1 | 2 | 3 | 4 | 5 | Right → |
|-----------|--------|---|---|---|---|---|---------|
| **Formality** | Formal | ○ | ○ | ○ | ○ | ○ | Casual |
| **Energy** | Reserved | ○ | ○ | ○ | ○ | ○ | Enthusiastic |
| **Humor** | Serious | ○ | ○ | ○ | ○ | ○ | Playful |
| **Authority** | Peer | ○ | ○ | ○ | ○ | ○ | Expert |

### Example: B2B SaaS Brand

| Dimension | ← Left | 1 | 2 | 3 | 4 | 5 | Right → |
|-----------|--------|---|---|---|---|---|---------|
| **Formality** | Formal | ○ | ○ | ○ | ● | ○ | Casual |
| **Energy** | Reserved | ○ | ○ | ● | ○ | ○ | Enthusiastic |
| **Humor** | Serious | ○ | ○ | ○ | ● | ○ | Playful |
| **Authority** | Peer | ○ | ● | ○ | ○ | ○ | Expert |

### What Each Position Means

**Formality Spectrum:**

| Position | Characteristics | Example |
|----------|-----------------|---------|
| 1 (Formal) | No contractions, third person, corporate language | "The organization has determined..." |
| 2 | Professional but accessible | "We've found that teams perform better..." |
| 3 | Balanced professional/casual | "Here's what we learned..." |
| 4 | Conversational, contractions, "you/we" | "You're going to love this feature" |
| 5 (Casual) | Slang acceptable, very relaxed | "This is gonna blow your mind" |

**Energy Spectrum:**

| Position | Characteristics | Example |
|----------|-----------------|---------|
| 1 (Reserved) | Understated, calm, minimal exclamation | "Results improved by 40%." |
| 2 | Confident but restrained | "We're pleased to announce..." |
| 3 | Balanced enthusiasm | "Great news for your team." |
| 4 | Energetic, celebratory | "We're excited to share this!" |
| 5 (Enthusiastic) | High energy, multiple exclamations | "This is AMAZING news!!" |

**Humor Spectrum:**

| Position | Characteristics | Example |
|----------|-----------------|---------|
| 1 (Serious) | No humor, purely informational | "Follow these steps to configure..." |
| 2 | Occasional warmth, no jokes | "We know this can be tricky..." |
| 3 | Light touches, relatable | "Nobody likes a 47-step process." |
| 4 | Playful, puns acceptable | "Let's taco 'bout your metrics." |
| 5 (Playful) | Humor-forward, memes OK | "Your dashboard called. It misses you." |

**Authority Spectrum:**

| Position | Characteristics | Example |
|----------|-----------------|---------|
| 1 (Peer) | "We're figuring this out together" | "Like you, we've struggled with..." |
| 2 | Experienced friend | "After helping 500 teams, here's what works..." |
| 3 | Knowledgeable guide | "Best practice is to..." |
| 4 | Industry expert | "Research shows that..." |
| 5 (Expert) | Definitive authority | "The correct approach is..." |

---

## This-But-Not-That Chart

Clarify voice traits by defining boundaries. Prevents misinterpretation across teams.

### Template

| Trait | This Means... | But NOT... | Do | Don't |
|-------|---------------|------------|-----|-------|
| [Trait] | [Definition] | [Anti-pattern] | [Example] | [Counter-example] |

### Common Brand Voice Traits

| Trait | This Means... | But NOT... | Do | Don't |
|-------|---------------|------------|-----|-------|
| **Helpful** | Guiding with expertise | Patronizing or condescending | "Here's how to get started" | "You should already know this" |
| **Confident** | Speaking with earned authority | Arrogant or dismissive | "We've helped 10,000 teams" | "We're obviously the best" |
| **Clear** | Simple, jargon-free explanations | Dumbed down or vague | "Connect your data sources" | "Leverage synergistic integrations" |
| **Friendly** | Warm and approachable | Unprofessional or overly casual | "Hey, quick question for you" | "Yo wassup fam" |
| **Witty** | Clever observations, subtle humor | Sarcastic or confusing | "Nobody loves spreadsheet chaos" | "LOL your process is broken" |
| **Empathetic** | Understanding pain points | Dramatic or pitying | "We know reporting is frustrating" | "Your situation sounds terrible" |
| **Direct** | Getting to the point quickly | Blunt or rude | "Three steps to fix this" | "Just do it already" |
| **Inclusive** | Welcoming all audiences | Performative or tokenizing | "Teams of all sizes" | "Even small teams can..." |

### Industry-Specific Examples

**Tech/SaaS:**

| Trait | This Means... | But NOT... |
|-------|---------------|------------|
| Technical | Accurate, precise language | Jargon without explanation |
| Innovative | Forward-thinking solutions | Buzzword soup ("AI-powered synergy") |
| Reliable | Emphasizing stability, uptime | Boring or corporate-speak |

**E-commerce/DTC:**

| Trait | This Means... | But NOT... |
|-------|---------------|------------|
| Exciting | Creating desire, urgency | Pushy or manipulative |
| Personal | Feeling like a friend's recommendation | Fake intimacy |
| Trustworthy | Honest about products | Over-promising |

**Professional Services:**

| Trait | This Means... | But NOT... |
|-------|---------------|------------|
| Expert | Deep knowledge, credentials | Intimidating or elitist |
| Reassuring | Calming concerns | Dismissive of real problems |
| Professional | Polished communication | Stuffy or impersonal |

---

## Tone Adaptation by Context

Voice stays constant. Tone adapts to situation.

### Tone Matrix

| Context | Tone | Energy Level | Humor Level | Example |
|---------|------|--------------|-------------|---------|
| **Product Launch** | Excited, confident | High | Medium | "We're thrilled to introduce..." |
| **How-To Content** | Helpful, clear | Medium | Low | "Follow these three steps..." |
| **Error Message** | Calm, supportive | Low | None | "Something went wrong. Here's how to fix it." |
| **Outage/Crisis** | Empathetic, direct | Low | None | "We're aware of the issue and working on it." |
| **Customer Win** | Celebratory, grateful | High | Medium | "Congratulations on hitting your goal!" |
| **Sales Email** | Confident, helpful | Medium | Low | "Here's how we can help..." |
| **Social Media** | Casual, engaging | Medium-High | Medium-High | "Who else feels this way?" |
| **Legal/Compliance** | Formal, precise | Low | None | "In accordance with regulations..." |
| **Apology** | Sincere, accountable | Low | None | "We made a mistake. Here's what happened." |
| **Onboarding** | Encouraging, patient | Medium | Low | "You're doing great. Next step..." |

### Tone Adjustment Examples

**Same message, different tones:**

| Context | Message |
|---------|---------|
| **Celebratory** | "You did it! Your first campaign is live." |
| **Neutral** | "Your campaign is now live." |
| **Supportive** | "Great job getting your campaign set up. It's live now." |
| **Urgent** | "Your campaign is live. Monitor results in your dashboard." |

---

## Messaging Framework

### Value Proposition Canvas

| Element | Question | Your Answer |
|---------|----------|-------------|
| **For** | Who is the target audience? | |
| **Who** | What pain point do they have? | |
| **Our product** | What category are we in? | |
| **That** | What key benefit do we provide? | |
| **Unlike** | What are the alternatives? | |
| **We** | What's our key differentiator? | |

### Positioning Statement Template

```
For [target audience] who [pain point],
[Product] is a [category] that [key benefit].
Unlike [alternatives], we [differentiator].
```

**Example:**
```
For marketing teams who struggle to prove campaign ROI,
Acme Analytics is a marketing attribution platform that
shows exactly which touchpoints drive revenue.
Unlike spreadsheets and disconnected tools, we connect
every interaction to closed deals automatically.
```

### Message Hierarchy

| Level | Purpose | Character Limit | Example |
|-------|---------|-----------------|---------|
| **Tagline** | Memorable hook | 10 words | "Know what's working" |
| **Elevator Pitch** | Quick explanation | 30 words | "Acme shows marketing teams exactly which campaigns drive revenue, so you can double down on what works." |
| **Value Prop** | Full benefit statement | 50 words | Full positioning statement |
| **Proof Points** | Supporting evidence | 3-5 bullets | Stats, testimonials, awards |

### Key Messages by Funnel Stage

| Stage | Message Focus | Proof Type | Example |
|-------|---------------|------------|---------|
| **TOFU** | Problem awareness | Industry stats | "67% of marketers can't prove ROI" |
| **MOFU** | Solution education | Product capabilities | "See every touchpoint in one dashboard" |
| **BOFU** | Why us | Social proof | "Trusted by 500+ marketing teams" |
| **Retention** | Continued value | Success metrics | "Teams save 10 hours/week on reporting" |

### Objection Handling Framework

| Objection | Acknowledge | Reframe | Proof |
|-----------|-------------|---------|-------|
| "Too expensive" | "I understand budget is a concern" | "Consider the cost of not knowing ROI" | "Teams see 3x return in 6 months" |
| "We use spreadsheets" | "Spreadsheets work for simple tracking" | "As you scale, manual work compounds" | "Save 10+ hours per week" |
| "Too complex" | "New tools can feel overwhelming" | "We designed for quick setup" | "Average onboarding: 2 days" |

---

## Terminology Standards

### Product Terminology

| Always Use | Never Use | Context |
|------------|-----------|---------|
| dashboard | control panel, interface | Product UI reference |
| campaign | initiative, program | Marketing activity |
| customers | clients, users, accounts | External audience |
| team members | employees, staff | Internal audience |
| integration | connector, bridge, plugin | Third-party connections |

### Industry Terminology

| Term | Definition | When to Use |
|------|------------|-------------|
| **Attribution** | Assigning credit to touchpoints | Analytics discussions |
| **Conversion** | Desired action completed | Goal tracking |
| **Funnel** | Customer journey stages | Strategy planning |
| **Touchpoint** | Any brand interaction | Journey mapping |
| **Engagement** | Audience interaction | Social/email metrics |

### Banned Words & Phrases

| Banned | Why | Use Instead |
|--------|-----|-------------|
| "Best-in-class" | Unsubstantiated superlative | Specific differentiator |
| "Synergy" | Corporate jargon | "Work together" or specific benefit |
| "Leverage" (as verb) | Overused buzzword | "Use" or "apply" |
| "Revolutionary" | Hyperbolic | Specific improvement |
| "Seamless" | Vague promise | Specific integration detail |
| "Cutting-edge" | Cliché | Specific innovation |
| "Game-changer" | Overused | Specific impact |
| "Circle back" | Corporate speak | "Follow up" or "revisit" |

---

## Visual Identity Quick Reference

### Color Usage

| Color Type | Usage | Accessibility |
|------------|-------|---------------|
| **Primary** | CTAs, headlines, key elements | 4.5:1 contrast minimum |
| **Secondary** | Supporting elements, accents | 3:1 contrast minimum |
| **Neutral** | Body text, backgrounds | 7:1 contrast for body text |
| **Status** | Success/warning/error states | Never rely on color alone |

### Typography Hierarchy

| Element | Weight | Size Ratio | Usage |
|---------|--------|------------|-------|
| H1 | Bold | 2.5x base | Page titles |
| H2 | Semi-bold | 2x base | Section headers |
| H3 | Semi-bold | 1.5x base | Subsections |
| Body | Regular | 1x base (16px) | Paragraphs |
| Small | Regular | 0.875x base | Captions, meta |

### Logo Usage Rules

| Rule | Specification |
|------|---------------|
| Clear space | Minimum 1/4 logo width on all sides |
| Minimum size | 24px height for digital |
| Backgrounds | Light logo on dark, dark on light |
| Don'ts | No stretching, rotating, adding effects |

### Image Style Guidelines

| Type | Guidelines |
|------|------------|
| **Photography** | Real people, authentic moments, diverse representation |
| **Illustrations** | Consistent style, brand colors, purposeful |
| **Icons** | Uniform stroke weight, consistent corners |
| **Charts** | Brand colors, clear labels, accessible |

---

## Channel-Specific Guidelines

### Email

| Element | Guideline |
|---------|-----------|
| Subject line | 6-10 words, no ALL CAPS, personalization OK |
| Preview text | Complement subject, 40-90 characters |
| From name | Consistent sender identity |
| CTA button | One primary, action verb, brand color |
| Footer | Unsubscribe, address, social links |

### Social Media

| Platform | Tone Adjustment | Content Focus |
|----------|-----------------|---------------|
| LinkedIn | More professional, thought leadership | Industry insights, company news |
| Twitter/X | Conversational, timely | Quick tips, engagement, trends |
| Instagram | Visual-first, lifestyle | Behind-scenes, culture, visual tips |
| TikTok | Casual, trend-aware | Educational entertainment |

### Website

| Page Type | Voice Emphasis |
|-----------|----------------|
| Homepage | Confident, benefit-focused |
| Product pages | Clear, feature-benefit |
| Blog | Helpful, educational |
| Pricing | Transparent, value-focused |
| Support | Patient, solution-oriented |

### Sales Collateral

| Asset | Guidelines |
|-------|------------|
| Pitch deck | Confident, proof-focused |
| Case studies | Customer voice, specific metrics |
| One-pagers | Scannable, benefit headlines |
| Proposals | Professional, customized |

---

## Brand Voice Checklist

### Pre-Publish Checklist

Copy and complete before publishing any content:

```
## Brand Voice Validation

### Voice Alignment
- [ ] Matches brand voice dimensions (formality, energy, humor, authority)
- [ ] Consistent with This-But-Not-That guidelines
- [ ] Tone appropriate for context/channel

### Language Quality
- [ ] No banned words or phrases
- [ ] Correct terminology used throughout
- [ ] Active voice (not passive)
- [ ] Average sentence length < 20 words
- [ ] Jargon explained or avoided

### Messaging Alignment
- [ ] Supports positioning statement
- [ ] Key benefit clearly stated
- [ ] Appropriate for funnel stage
- [ ] Clear CTA included

### Proof & Credibility
- [ ] Claims supported by evidence
- [ ] No unsubstantiated superlatives
- [ ] Social proof included where appropriate

### Accessibility & Inclusion
- [ ] Inclusive language used
- [ ] Alt text for all images
- [ ] Sufficient color contrast
- [ ] No assumptions about audience

### Final Check
- [ ] Proofread for errors
- [ ] Links tested
- [ ] Reviewed by second person (for high-visibility content)
```

### Quick Validation Questions

Before publishing, ask:

1. **Would a customer understand this in 5 seconds?**
2. **Does this sound like our brand or a competitor?**
3. **Is this something we'd be proud to share widely?**
4. **Does this help the reader take action?**
5. **Would this pass the "read aloud" test?**

---

## Brand Guidelines Governance

### Update Cadence

| Element | Review Frequency | Owner |
|---------|------------------|-------|
| Voice dimensions | Annually | Brand team |
| Terminology | Quarterly | Marketing + Product |
| Visual identity | Annually | Design team |
| Channel guidelines | Quarterly | Channel owners |

### Exception Process

1. Document the proposed deviation
2. Explain business rationale
3. Get approval from brand owner
4. Document decision for future reference

### Training Requirements

| Role | Training | Frequency |
|------|----------|-----------|
| Marketing writers | Full brand guidelines | Onboarding + annual refresh |
| External agencies | Brand deck + voice guide | Per project kickoff |
| Sales team | Messaging framework | Quarterly |
| Customer support | Tone guidelines | Onboarding |
