# Content Strategy

Frameworks and templates for planning, creating, and distributing marketing content.

## Contents

- [Topic Cluster Model](#topic-cluster-model)
- [Hero-Hub-Hygiene Framework](#hero-hub-hygiene-framework)
- [Funnel Content Mapping](#funnel-content-mapping)
- [Content Calendar Templates](#content-calendar-templates)
- [Content Atomization](#content-atomization)
- [Content Scoring](#content-scoring)

---

## Topic Cluster Model

Organize content around pillar pages linked to cluster articles for SEO authority.

### Pillar Page Guidelines

| Element | Specification |
|---------|---------------|
| Length | 2,500-5,000+ words |
| Scope | Comprehensive coverage of core topic |
| Structure | Clear H2/H3 hierarchy with jump links |
| Links | Connect to 8-20 cluster articles |
| Update frequency | Quarterly review and refresh |

### Cluster Article Strategy

| Element | Specification |
|---------|---------------|
| Length | 1,000-2,000 words |
| Focus | Single subtopic or long-tail keyword |
| Link to pillar | At least once, contextually placed |
| Internal links | 3-5 to related clusters |
| Quantity | 8-20 per pillar topic |

### Internal Linking Rules

- One hyperlink per ~150 words
- Use descriptive anchor text (not "click here")
- Link contextually within content flow
- Pillar links to all clusters; clusters link back to pillar
- Cross-link related clusters where relevant

### Example Cluster Structure

**Pillar:** "Complete Guide to Remote Work"

**Clusters:**
- Remote work tools comparison
- Setting up a home office
- Managing remote teams
- Remote work productivity tips
- Communication best practices for distributed teams
- Remote hiring and onboarding
- Work-life balance when working from home
- Remote work security considerations

---

## Hero-Hub-Hygiene Framework

Balance content types for reach, engagement, and evergreen value.

### Content Mix

| Type | % of Output | Purpose | Examples |
|------|-------------|---------|----------|
| **Hygiene** | 60-70% | Evergreen, SEO-driven, answers common questions | How-to guides, FAQs, tutorials, glossaries |
| **Hub** | 20-30% | Nurtures loyal audience, builds community | Weekly series, podcasts, newsletters, case studies |
| **Hero** | 5-10% | Major campaigns, viral potential, brand moments | Product launches, annual reports, viral videos |

### Planning Cadence

| Type | Planning Horizon | Production Lead Time |
|------|------------------|---------------------|
| Hygiene | Quarterly keyword research | 2-4 weeks |
| Hub | Monthly editorial calendar | 1-2 weeks |
| Hero | Annual campaign planning | 4-12 weeks |

### Resource Allocation

| Type | Effort per Piece | Promotion Effort |
|------|------------------|------------------|
| Hygiene | Low-Medium | SEO-focused, minimal paid |
| Hub | Medium | Email, social, community |
| Hero | High | Multi-channel, paid amplification |

---

## Funnel Content Mapping

Match content formats to buyer journey stages.

### TOFU (Top of Funnel) — Awareness

**Goal:** Attract and educate; build brand awareness

| Format | Best For | Distribution |
|--------|----------|--------------|
| Blog posts | SEO, thought leadership | Organic search, social |
| Infographics | Data visualization, shareability | Social, Pinterest |
| Short videos | Engagement, reach | TikTok, Reels, YouTube Shorts |
| Podcasts | Thought leadership, reach | Podcast platforms, social clips |
| Social posts | Brand awareness, engagement | Platform-native |

**Metrics:** Unique visitors, pageviews, social reach, brand mentions, new email subscribers

**Content characteristics:**
- Educational, not promotional
- Addresses broad pain points
- No product mention or soft mention only
- Optimized for search intent

### MOFU (Middle of Funnel) — Consideration

**Goal:** Nurture leads; demonstrate expertise and value

| Format | Best For | Distribution |
|--------|----------|--------------|
| Ebooks/White papers | Lead generation | Gated landing pages |
| Webinars | Engagement, expertise | Email, LinkedIn, ads |
| Case studies | Social proof | Sales enablement, website |
| Comparison guides | Decision support | SEO, email nurture |
| Email sequences | Nurturing | Marketing automation |

**Metrics:** Downloads, webinar registrations, email engagement, time on page, return visits

**Content characteristics:**
- Demonstrates expertise
- Often gated (email exchange)
- Addresses specific problems
- Introduces solution categories

### BOFU (Bottom of Funnel) — Decision

**Goal:** Convert leads to customers

| Format | Best For | Distribution |
|--------|----------|--------------|
| Product demos | Conversion | Sales, website |
| Free trials | Conversion | Website, email |
| Customer testimonials | Trust | Website, sales collateral |
| ROI calculators | Justification | Website, sales |
| Competitor comparisons | Decision support | SEO, sales enablement |
| Limited-time offers | Urgency | Email, retargeting |

**Metrics:** Conversion rate, trial starts, demo requests, SQLs, revenue

**Content characteristics:**
- Product-focused
- Addresses objections
- Clear CTAs
- Often personalized

---

## Content Calendar Templates

### Annual Planning Fields

| Field | Purpose | Example |
|-------|---------|---------|
| Quarter | Time grouping | Q1 2025 |
| Campaign theme | Overarching initiative | Product Launch, Brand Awareness |
| Content pillars | Topic clusters to develop | Remote Work, Productivity |
| Hero content | Major pieces planned | Annual Report, Product Video |
| Key dates | Industry events, holidays | Conference X, Black Friday |
| Goals | Quarterly targets | 50K organic visits, 500 MQLs |

### Quarterly Planning Fields

| Field | Purpose | Example |
|-------|---------|---------|
| Month | Time grouping | January |
| Pillar topic | Cluster focus | Remote Work Tools |
| Content pieces | Specific articles/assets | 4 blog posts, 1 ebook |
| Keywords | Target terms | "best remote work tools 2025" |
| Owner | Responsible person | Sarah M. |
| Status | Tracking | Planned, In Progress, Published |

### Monthly/Weekly Planning Fields

| Field | Purpose | Example |
|-------|---------|---------|
| Publish date | Specific timing | Jan 15, 2025 |
| Content title | Working title | "10 Remote Work Tools for 2025" |
| Format | Content type | Blog post |
| Funnel stage | TOFU/MOFU/BOFU | TOFU |
| Target keyword | Primary SEO term | remote work tools |
| Word count | Scope | 1,500 |
| Owner | Writer/creator | Sarah M. |
| Editor | Reviewer | Mike T. |
| Designer | Visual support | Design Team |
| Due: First draft | Deadline | Jan 8 |
| Due: Final | Deadline | Jan 13 |
| Distribution | Channels | Blog, LinkedIn, Newsletter |
| Promotion | Paid/organic plan | Organic + $200 LinkedIn |
| CTA | Desired action | Download tools checklist |
| Status | Workflow stage | Draft, Review, Scheduled, Live |
| Performance URL | Tracking link | UTM-tagged URL |

### Calendar Tool Options

| Tool | Best For | Price |
|------|----------|-------|
| Google Sheets | Simple, collaborative, free | Free |
| Notion | Flexible, database views | Free-$10/user |
| Airtable | Relational data, automations | Free-$20/user |
| Asana | Task management integration | Free-$25/user |
| CoSchedule | Marketing-specific features | $29+/month |
| Monday.com | Visual workflows | $9+/user |

---

## Content Atomization

Transform one comprehensive piece into multiple format-specific assets.

### Atomization Workflow

**Source content:** Long-form pillar (guide, webinar, report, podcast)

**Step 1: Extract core components**
- Key statistics and data points
- Quotable insights
- Step-by-step processes
- Visual concepts
- FAQs answered

**Step 2: Map to formats**

| Source Element | Output Formats |
|----------------|----------------|
| Full piece | Blog summary, email series |
| Key stats | Infographics, social graphics |
| Quotes | Social posts, email headers |
| Steps | Carousel posts, short videos |
| Visuals | Pinterest pins, presentation slides |
| FAQs | Short blog posts, social Q&A |
| Audio | Podcast clips, audiograms |

**Step 3: Platform adaptation**

| Platform | Format Adaptation |
|----------|-------------------|
| LinkedIn | Professional angle, text-heavy posts, carousels |
| Instagram | Visual-first, Reels, carousels, Stories |
| TikTok | Entertaining angle, trends, short clips |
| X/Twitter | Thread breakdown, key insights, quotes |
| Email | Series with progressive depth |
| YouTube | Long-form + Shorts clips |

### Atomization Example

**Source:** 5,000-word guide "Complete Remote Work Productivity Guide"

**Outputs:**
- 5 blog posts (1 per major section)
- 10-email nurture sequence
- 25+ social posts across platforms
- 5 carousel posts for LinkedIn/Instagram
- 3 infographics (stats, process, tools)
- 1 SlideShare presentation
- 5 short video clips (tips)
- 1 podcast episode (audio version)
- 1 webinar (expanded live version)
- 10 quote graphics

### Repurposing ROI

Research shows 46% of marketers find repurposed content more effective than new content. Target ratio: 1 pillar piece → 20-30 derivative assets.

---

## Content Scoring

Evaluate content quality and potential before publication.

### Pre-Publication Checklist

| Criterion | Check |
|-----------|-------|
| Target keyword defined | [ ] |
| Search intent matched | [ ] |
| Unique angle or value | [ ] |
| Proper length for format | [ ] |
| Clear structure (H2/H3) | [ ] |
| Internal links included | [ ] |
| CTA present and clear | [ ] |
| Meta title optimized | [ ] |
| Meta description written | [ ] |
| Images optimized (alt text, compression) | [ ] |
| Mobile-friendly format | [ ] |
| Proofread and edited | [ ] |

### Content Quality Rubric

| Factor | Weight | Scoring |
|--------|--------|---------|
| Relevance to audience | 25% | 1-5: How well does it address target persona needs? |
| Originality | 20% | 1-5: Unique insights vs. commodity content? |
| Depth | 20% | 1-5: Comprehensive coverage of topic? |
| Actionability | 15% | 1-5: Clear takeaways reader can implement? |
| SEO optimization | 10% | 1-5: Keyword targeting, structure, meta? |
| Visual appeal | 10% | 1-5: Formatting, images, readability? |

**Score interpretation:**
- 4.5-5.0: Publish and promote heavily
- 3.5-4.4: Publish with standard promotion
- 2.5-3.4: Revise before publishing
- Below 2.5: Rework or abandon

### Performance Review Cadence

| Timeframe | Action |
|-----------|--------|
| 1 week | Check initial traffic, social engagement |
| 1 month | Review rankings, conversions, time on page |
| 3 months | Assess SEO performance, update if needed |
| 6 months | Refresh stats, examples, links |
| 12 months | Major update or consolidate with other content |

---

## Quick Reference

### Content Type Selection

| Goal | Recommended Types |
|------|-------------------|
| Build SEO authority | Pillar pages, how-to guides, glossaries |
| Generate leads | Ebooks, webinars, templates, calculators |
| Nurture prospects | Email sequences, case studies, comparison guides |
| Drive conversions | Demos, trials, testimonials, ROI tools |
| Build community | Podcasts, newsletters, user stories |
| Viral potential | Original research, interactive tools, videos |

### Benchmarks

| Metric | Good | Excellent |
|--------|------|-----------|
| Blog post traffic (6 months) | 500+ visits | 2,000+ visits |
| Ebook downloads | 100+ | 500+ |
| Webinar registrations | 200+ | 1,000+ |
| Email sequence completion | 40%+ | 60%+ |
| Content→MQL conversion | 2%+ | 5%+ |
