# Social Media Marketing

Platform-specific tactics, posting strategies, and engagement benchmarks for 2024-2025.

## Contents

- [Platform Selection Matrix](#platform-selection-matrix)
- [Instagram](#instagram)
- [LinkedIn](#linkedin)
- [TikTok](#tiktok)
- [X/Twitter](#xtwitter)
- [Facebook](#facebook)
- [Engagement Benchmarks](#engagement-benchmarks)
- [UGC Strategy](#ugc-strategy)
- [Social Media Management Tools](#social-media-management-tools)

---

## Platform Selection Matrix

Choose platforms based on audience and goals.

| Platform | Best For | Primary Audience | Content Style |
|----------|----------|------------------|---------------|
| Instagram | B2C, lifestyle, visual brands | 18-44, slightly female-skewed | Visual, polished, aspirational |
| LinkedIn | B2B, professional services, recruiting | 25-54, professionals | Professional, thought leadership |
| TikTok | Gen Z/Millennial reach, brand awareness | 16-34, entertainment-seeking | Authentic, entertaining, trendy |
| X/Twitter | News, tech, real-time engagement | 25-49, news-focused | Concise, timely, conversational |
| Facebook | Local business, 35+ demographics, groups | 35-65+, broad | Community, video, local |

### Decision Framework

**Choose Instagram if:** Visual product, lifestyle brand, e-commerce, influencer potential
**Choose LinkedIn if:** B2B sales, thought leadership, recruiting, professional services
**Choose TikTok if:** Younger audience, brand awareness priority, entertainment angle possible
**Choose X/Twitter if:** Tech industry, news/media, real-time customer service, thought leadership
**Choose Facebook if:** Local business, 35+ audience, community building, groups strategy

---

## Instagram

### Algorithm Priorities (2025)

1. **Saves** — Strongest signal; content worth returning to
2. **Shares** — Indicates high value worth spreading
3. **Comments** — Engagement depth matters
4. **Likes** — Weakest signal but still counted

### Content Format Performance

| Format | Reach | Engagement | Best Use |
|--------|-------|------------|----------|
| Reels | Highest | Medium | Discovery, new audience |
| Carousels | Medium | Highest | Education, storytelling |
| Stories | Low (followers only) | High | Daily engagement, BTS |
| Static posts | Lowest | Medium | Brand moments, announcements |
| Lives | Medium | Very High | Q&A, launches, community |

### Reels Best Practices

- **Hook in first 1-3 seconds** — Pattern interrupt or curiosity gap
- **Length:** 15-60 seconds optimal; can go to 90 for tutorials
- **Trending audio:** Use trending sounds for algorithmic boost
- **Text overlays:** Many watch without sound
- **Native editing:** Instagram favors in-app created content
- **Post to feed:** Always share Reels to main feed

### Carousel Best Practices

- **Slides:** 5-10 optimal (encourages swiping)
- **First slide:** Hook that demands swipe
- **Last slide:** Clear CTA (save, share, follow, comment)
- **Design:** Consistent template, readable text
- **Value density:** Each slide delivers value

### Hashtag Strategy (2025 Update)

| Element | Recommendation |
|---------|----------------|
| Quantity | 3-5 hashtags (Instagram's recommendation) |
| Placement | In caption, not comments |
| Mix | 1-2 broad, 2-3 niche-specific |
| Branded | Include 1 branded hashtag if applicable |

**Note:** Instagram now functions more like a search engine. Optimize captions with keywords, not just hashtags.

### Posting Cadence

| Content Type | Frequency |
|--------------|-----------|
| Feed posts | 3-5 per week |
| Reels | 4-7 per week |
| Stories | 1-5 per day (more than 5 decreases engagement) |
| Lives | 1-2 per month |

### Best Posting Times

| Day | Optimal Windows |
|-----|-----------------|
| Monday | 6 AM, 11 AM, 1 PM |
| Tuesday | 8-10 AM, 2 PM |
| Wednesday | 9-11 AM |
| Thursday | 11 AM - 1 PM |
| Friday | 7-9 AM, 2 PM |
| Saturday | 9-11 AM |
| Sunday | 1-3 PM |

*Times in local audience timezone. Test and adjust based on your analytics.*

---

## LinkedIn

### Algorithm Priorities (2025)

LinkedIn intentionally limits virality, prioritizing professional relevance.

| Signal | Impact | Notes |
|--------|--------|-------|
| Comments | 15x more reach than likes | Longer comments (15+ words) weighted higher |
| Shares | 5x more reach than likes | Reshares with commentary perform best |
| Dwell time | High | Longer posts that hold attention rewarded |
| Reactions | Base signal | All reaction types weighted equally |

### Content That Performs

| Type | Performance | Best Practices |
|------|-------------|----------------|
| Personal stories | Highest | Professional lessons, career moments |
| Industry insights | High | Original perspectives, data |
| How-to content | High | Tactical, actionable advice |
| Carousels/Documents | High | Educational, swipeable content |
| Polls | Medium-High | Conversation starters |
| Video | Medium | Native upload, captions required |
| External links | Lowest | Add links in comments instead |

### Post Structure

**Optimal length:** 1,200-1,600 characters (shows "see more")

**Hook formula:**
```
Line 1: Bold statement or question
Line 2: Create curiosity gap
[blank line]
Line 3-5: Build context
[blank line]
Body: Deliver value
[blank line]
CTA: Ask for engagement
```

### Link Strategy

Posts without external links get **6x more reach**. Strategy:
1. Post content without link
2. Add link in first comment
3. Reference "link in comments" in post

### Engagement Rules

- **Wait 12+ hours** between posts (algorithm penalty for rapid posting)
- **Reply to comments within 1 hour** for algorithmic boost
- **Tag sparingly:** Max 3-5 people, only if truly relevant
- **Engage before posting:** 15-30 minutes of engagement on others' posts

### Posting Cadence

| Type | Frequency |
|------|-----------|
| Feed posts | 3-5 per week |
| Articles | 1-2 per month |
| Documents/Carousels | 1-2 per week |
| Comments on others | Daily |

### Best Posting Times

| Day | Optimal Windows |
|-----|-----------------|
| Tuesday | 8-10 AM, 12 PM |
| Wednesday | 8-10 AM, 12 PM |
| Thursday | 8-10 AM, 1-2 PM |

*Tuesday-Thursday are consistently highest engagement. Avoid weekends.*

---

## TikTok

### Algorithm Priorities

| Signal | Weight | Notes |
|--------|--------|-------|
| Watch time | Highest | Completion rate is key metric |
| Rewatches | Very High | Loops count as multiple views |
| Shares | High | Especially shares to messages |
| Comments | High | Especially early comments |
| Likes | Medium | Table stakes engagement |

### Content Approach

**Core principle:** Entertainment first, brand second.

| Do | Don't |
|----|-------|
| Be authentic, imperfect | Over-produce content |
| Join trends with your angle | Force irrelevant trends |
| Show personality | Be corporate/stiff |
| Provide value or entertainment | Hard sell |
| Use native features | Cross-post polished ads |

### Video Best Practices

| Element | Recommendation |
|---------|----------------|
| Length | 15-60 seconds optimal; 7-15 for trends |
| Hook | First 1-2 seconds must grab attention |
| Audio | Trending sounds boost discovery |
| Text | On-screen text for accessibility |
| Pacing | Fast cuts maintain attention |
| CTA | Soft, native-feeling |

### Content Pillars for Brands

| Pillar | Purpose | Example |
|--------|---------|---------|
| Behind the scenes | Humanize brand | Day in the life, office tours |
| Educational | Demonstrate expertise | Quick tips, how-tos, myths busted |
| Trending | Reach new audiences | Sounds, challenges, memes |
| Product/Service | Showcase offerings | Use cases, transformations |
| Community | Build loyalty | Duets, responses, UGC features |

### TikTok Shop Integration

- **67% increase in in-app purchases** reported
- **35% higher conversion rates** vs. traditional e-commerce
- Tag products in videos for direct purchase
- Live shopping events drive high conversion

### Posting Cadence

| Approach | Frequency |
|----------|-----------|
| Minimum | 3-5 per week |
| Growth mode | 1-3 per day |
| Testing phase | 2+ per day to find what works |

### Best Posting Times

| Day | Optimal Windows |
|-----|-----------------|
| Thursday | 7 PM |
| Friday | 7-9 PM |
| Saturday | 11 AM, 7-8 PM |
| Sunday | 4 PM, 7 PM |

*Evening and weekend content performs best. Test extensively.*

---

## X/Twitter

### Platform Characteristics

| Factor | Reality |
|--------|---------|
| Tweet lifespan | ~6 hours (then minimal reach) |
| Character limit | 280 (Premium: 4,000) |
| Algorithm | Engagement-based with interest signals |
| Strength | Real-time, news, tech community |

### Content Performance

| Type | Engagement Multiplier |
|------|----------------------|
| Image posts | 150% more retweets |
| Video (native) | 40% more engagement |
| Threads (4-8 tweets) | High for thought leadership |
| Polls | Good for engagement, limited reach |
| Text only | Baseline |
| External links | Lower reach |

### Tweet Best Practices

| Element | Recommendation |
|---------|----------------|
| Length | 70-100 characters optimal |
| Images | Add for 150% engagement boost |
| Hashtags | 1-2 maximum, only if relevant |
| Mentions | Use sparingly, tag relevant accounts |
| CTAs | Ask for retweet, reply, or follow |

### Thread Strategy

Threads work well for thought leadership and educational content.

**Structure:**
1. **Tweet 1:** Hook + promise (what reader will learn)
2. **Tweets 2-7:** Deliver value, one point per tweet
3. **Final tweet:** Summary + CTA (follow, retweet, etc.)

**Tips:**
- Number tweets (1/, 2/, etc.) or use visual continuity
- Make each tweet standalone valuable
- End with engagement request

### Posting Cadence

| Type | Frequency |
|------|-----------|
| Tweets | 3-5 per day |
| Threads | 2-3 per week |
| Replies/Engagement | Ongoing throughout day |
| Retweets with comment | 1-2 per day |

### Best Posting Times

| Day | Optimal Windows |
|-----|-----------------|
| Tuesday | 9 AM, 9 PM |
| Wednesday | 9 AM, 12 PM, 9 PM |
| Thursday | 9 AM, 9 PM |

*9 PM globally shows peak connected users. B2B: focus on business hours.*

---

## Facebook

### Organic Reach Reality

| Metric | 2024-2025 Reality |
|--------|-------------------|
| Average organic reach | 5.2% of page likes |
| Many brand pages | Under 3% reach |
| Declining trend | Year-over-year decreases |

### Algorithm Priorities

| Signal | Weight | Notes |
|--------|--------|-------|
| Meaningful interactions | Highest | Comments, shares, reactions |
| Friends & family | High | Personal connections prioritized |
| Video (especially Live) | High | Watch time matters |
| Groups content | High | Community content boosted |
| External links | Low | Keeps users on platform |

### Content That Works

| Type | Performance | Notes |
|------|-------------|-------|
| Facebook Live | Highest | 6x more engagement than regular video |
| Native video | High | Auto-play in feed |
| User-generated content | High | Authenticity signals |
| Groups posts | High | Community algorithm boost |
| Images | Medium | 2.3x more engagement than text |
| Link posts | Lowest | Consider link in comments |

### Groups Strategy

Facebook Groups offer significantly better organic reach than Pages.

**Approach:**
1. Create branded community group (not promotional)
2. Focus on member value and discussion
3. Post as Page admin but encourage member posts
4. Use Groups for exclusive content, early access

### Video Best Practices

| Element | Recommendation |
|---------|----------------|
| Length | 1-3 minutes optimal for feed |
| Captions | Required (85% watch without sound) |
| Thumbnail | Custom, clear, attention-grabbing |
| Square/Vertical | Better mobile performance |
| Native upload | Always (not YouTube links) |

### Posting Cadence

| Page Size | Frequency |
|-----------|-----------|
| Small (< 10K) | 3 posts per week |
| Medium (10-100K) | 1 post per day |
| Large (> 100K) | 1-2 posts per day |

*More than 2 posts/day can decrease engagement.*

### Best Posting Times

| Day | Optimal Windows |
|-----|-----------------|
| Wednesday | 11 AM, 1 PM |
| Thursday | 11 AM, 1-2 PM |

*Weekday late mornings perform best. Test for your audience.*

---

## Engagement Benchmarks

### 2024-2025 Benchmarks by Platform

| Platform | Median Engagement Rate | Good | Excellent |
|----------|------------------------|------|-----------|
| LinkedIn | 6.5% | 4-8% | 8%+ |
| Instagram | 3-6% | 3-5% | 6%+ |
| Facebook | 3.6% | 2-4% | 5%+ |
| TikTok | Declining (~2-4%) | 3-5% | 6%+ |
| X/Twitter | 0.5-1% | 1-2% | 3%+ |

### Engagement Rate Calculation

```
Engagement Rate = (Likes + Comments + Shares + Saves) / Followers × 100
```

**Alternative (Reach-based):**
```
Engagement Rate = (Engagements / Reach) × 100
```

### Follower Growth Benchmarks

| Growth Rate | Assessment |
|-------------|------------|
| < 1% monthly | Slow, review strategy |
| 1-3% monthly | Healthy, sustainable |
| 3-5% monthly | Strong performance |
| 5%+ monthly | Excellent (ensure quality) |

---

## UGC Strategy

User-generated content outperforms brand content significantly.

### UGC Performance Stats

| Metric | UGC vs. Brand Content |
|--------|----------------------|
| Authenticity perception | 2.4x more authentic |
| Conversion lift | 29% higher conversions |
| Marketer effectiveness | 93% report UGC outperforms |
| Trust factor | Consumers trust UGC like recommendations |

### UGC Collection Methods

| Method | Implementation |
|--------|----------------|
| Branded hashtag | Create and promote unique hashtag |
| Contests | Incentivize submissions with prizes |
| Reviews/Testimonials | Request post-purchase |
| Influencer partnerships | Negotiate content rights |
| Community features | Spotlight customer content |
| Direct outreach | Ask permission to reshare |

### UGC Rights Management

1. **Always get permission** before reposting
2. **Credit the creator** in caption
3. **Save permission records** (screenshot DMs/emails)
4. **Consider formal agreements** for commercial use
5. **Use UGC platforms** (TINT, Pixlee) for scale

### UGC Content Calendar Integration

| Week | UGC Usage |
|------|-----------|
| Week 1 | Feature customer testimonial |
| Week 2 | Reshare customer photo/video |
| Week 3 | Highlight community member |
| Week 4 | UGC compilation or roundup |

---

## Social Media Management Tools

### Tool Comparison

| Tool | Best For | Platforms | Starting Price |
|------|----------|-----------|----------------|
| Hootsuite | Enterprise, teams | 35+ platforms | $99/month |
| Buffer | Creators, small teams | 8 platforms | Free - $5/channel |
| Sprout Social | Enterprise analytics | Major platforms | $249/month |
| Later | Visual-first (Instagram) | Instagram, TikTok, Pinterest | Free - $25/month |
| Metricool | Budget-conscious | Major platforms | Free - $22/month |

### Selection Criteria

| Need | Recommended Tool |
|------|------------------|
| Free/budget option | Buffer Free, Metricool Free |
| Instagram-focused | Later |
| Enterprise/team | Hootsuite, Sprout Social |
| Analytics depth | Sprout Social |
| Simple scheduling | Buffer |

---

## Quick Reference

### Daily Engagement Checklist

- [ ] Respond to comments/DMs within 2 hours
- [ ] Engage with 10-15 accounts in your niche
- [ ] Monitor brand mentions
- [ ] Check trending topics/sounds for opportunities
- [ ] Review yesterday's post performance

### Content Ratio Guidelines

| Content Type | % of Posts |
|--------------|------------|
| Value/Educational | 40% |
| Entertaining/Relatable | 30% |
| Promotional | 20% |
| Community/UGC | 10% |

### Cross-Posting Cautions

| Do | Don't |
|----|-------|
| Adapt content per platform | Post identical content everywhere |
| Respect platform conventions | Use Instagram hashtags on LinkedIn |
| Adjust aspect ratios | Post square videos on TikTok |
| Modify tone/length | Use 280-char limit text on LinkedIn |
